/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.ode;

import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.ode.DAABBC;

public class DAABB
implements DAABBC {
    private final DVector3 _min = new DVector3();
    private final DVector3 _max = new DVector3();

    public void setToInfinity() {
        this.setMinMax(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setMinMax(double mm0, double mm1, double mm2) {
        this._min.set(-mm0, -mm1, -mm2);
        this._max.set(mm0, mm1, mm2);
    }

    public void shiftPos(DVector3C pos) {
        this._min.add(pos);
        this._max.add(pos);
    }

    @Override
    public double len0() {
        return this.getMax0() - this.getMin0();
    }

    @Override
    public double len1() {
        return this.getMax1() - this.getMin1();
    }

    @Override
    public double len2() {
        return this.getMax2() - this.getMin2();
    }

    public double avg0() {
        return 0.5 * (this.getMax0() + this.getMin0());
    }

    public double avg1() {
        return 0.5 * (this.getMax1() + this.getMin1());
    }

    public double avg2() {
        return 0.5 * (this.getMax2() + this.getMin2());
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.getMin0()) && !Double.isNaN(this.getMax0()) && !Double.isNaN(this.getMin1()) && !Double.isNaN(this.getMax1()) && !Double.isNaN(this.getMin2()) && !Double.isNaN(this.getMax2());
    }

    @Override
    public boolean isDisjoint(DAABBC aabb2) {
        return this.getMin0() > aabb2.getMax0() || this.getMax0() < aabb2.getMin0() || this.getMin1() > aabb2.getMax1() || this.getMax1() < aabb2.getMin1() || this.getMin2() > aabb2.getMax2() || this.getMax2() < aabb2.getMin2();
    }

    public void setMinMax(DVector3C v1, DVector3C v2) {
        if (v1.get0() < v2.get0()) {
            this.setMin0(v1.get0());
            this.setMax0(v2.get0());
        } else {
            this.setMin0(v2.get0());
            this.setMax0(v1.get0());
        }
        if (v1.get1() < v2.get1()) {
            this.setMin1(v1.get1());
            this.setMax1(v2.get1());
        } else {
            this.setMin1(v2.get1());
            this.setMax1(v1.get1());
        }
        if (v1.get2() < v2.get2()) {
            this.setMin2(v1.get2());
            this.setMax2(v2.get2());
        } else {
            this.setMin2(v2.get2());
            this.setMax2(v1.get2());
        }
    }

    public void setMin0(double d) {
        this._min.set0(d);
    }

    public void setMin1(double d) {
        this._min.set1(d);
    }

    public void setMin2(double d) {
        this._min.set2(d);
    }

    public void setMax0(double d) {
        this._max.set0(d);
    }

    public void setMax1(double d) {
        this._max.set1(d);
    }

    public void setMax2(double d) {
        this._max.set2(d);
    }

    @Override
    public double getMin0() {
        return this._min.get0();
    }

    @Override
    public double getMin1() {
        return this._min.get1();
    }

    @Override
    public double getMin2() {
        return this._min.get2();
    }

    @Override
    public double getMax0() {
        return this._max.get0();
    }

    @Override
    public double getMax1() {
        return this._max.get1();
    }

    @Override
    public double getMax2() {
        return this._max.get2();
    }

    @Override
    public double getMax(int i) {
        return this._max.get(i);
    }

    @Override
    public double getMin(int i) {
        return this._min.get(i);
    }

    @Override
    public DVector3 getLengths() {
        return new DVector3(this.len0(), this.len1(), this.len2());
    }

    @Override
    public DVector3 getCenter() {
        return new DVector3(this.avg0(), this.avg1(), this.avg2());
    }

    public void set(DAABBC aabb) {
        this.setMin0(aabb.getMin0());
        this.setMin1(aabb.getMin1());
        this.setMin2(aabb.getMin2());
        this.setMax0(aabb.getMax0());
        this.setMax1(aabb.getMax1());
        this.setMax2(aabb.getMax2());
    }

    public void set(double min0, double max0, double min1, double max1, double min2, double max2) {
        this._min.set(min0, min1, min2);
        this._max.set(max0, max1, max2);
    }

    public void setZero() {
        this._min.setZero();
        this._max.setZero();
    }

    public void setMin(DVector3C min) {
        this._min.set(min);
    }

    public void setMax(DVector3C max) {
        this._max.set(max);
    }

    public void expand(DVector3C point) {
        if (point.get0() < this._min.get0()) {
            this._min.set0(point.get0());
        }
        if (point.get1() < this._min.get1()) {
            this._min.set1(point.get1());
        }
        if (point.get2() < this._min.get2()) {
            this._min.set2(point.get2());
        }
        if (point.get0() > this._max.get0()) {
            this._max.set0(point.get0());
        }
        if (point.get1() > this._max.get1()) {
            this._max.set1(point.get1());
        }
        if (point.get2() > this._max.get2()) {
            this._max.set2(point.get2());
        }
    }

    public void expand(DAABBC aabb) {
        if (aabb.getMin0() < this._min.get0()) {
            this._min.set0(aabb.getMin0());
        }
        if (aabb.getMin1() < this._min.get1()) {
            this._min.set1(aabb.getMin1());
        }
        if (aabb.getMin2() < this._min.get2()) {
            this._min.set2(aabb.getMin2());
        }
        if (aabb.getMax0() > this._max.get0()) {
            this._max.set0(aabb.getMax0());
        }
        if (aabb.getMax1() > this._max.get1()) {
            this._max.set1(aabb.getMax1());
        }
        if (aabb.getMax2() > this._max.get2()) {
            this._max.set2(aabb.getMax2());
        }
    }

    public String toString() {
        return "DAABB min=" + this._min + " / max=" + this._max;
    }
}

