/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

public class DVectorN {
    private final double[] v;
    public static final int CURRENT_LENGTH = 4;

    public DVectorN(int len) {
        this.v = new double[len];
    }

    public DVectorN(DVectorN v2) {
        this(v2.v.length);
        this.set(v2.v);
    }

    public DVectorN(double[] data) {
        this(data.length);
        System.arraycopy(data, 0, this.v, 0, this.v.length);
    }

    public DVectorN clone() {
        return new DVectorN(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("dVector3[");
        int i = 0;
        while (i < this.v.length - 1) {
            b.append(this.v[i]).append(", ");
            ++i;
        }
        b.append(this.v[this.v.length - 1]).append("]");
        return b.toString();
    }

    public void set0(double d) {
        this.v[0] = d;
    }

    public void set1(double d) {
        this.v[1] = d;
    }

    public void set2(double d) {
        this.v[2] = d;
    }

    public double get0() {
        return this.v[0];
    }

    public double get1() {
        return this.v[1];
    }

    public double get2() {
        return this.v[2];
    }

    public final double get(int i) {
        return this.v[i];
    }

    public final boolean safeNormalizeN() {
        double d = Math.abs(this.v[0]);
        int i = 1;
        while (i < this.v.length) {
            if (Math.abs(this.v[i]) > d) {
                d = Math.abs(this.v[i]);
            }
            ++i;
        }
        if (d <= Double.MIN_NORMAL) {
            this.setIdentity();
            return false;
        }
        i = 0;
        while (i < this.v.length) {
            int n = i++;
            this.v[n] = this.v[n] / d;
        }
        double sum = 0.0;
        double[] dArray = this.v;
        int n = this.v.length;
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray[n2];
            sum += d2 * d2;
            ++n2;
        }
        double l = 1.0 / Math.sqrt(sum);
        int i2 = 0;
        while (i2 < this.v.length) {
            int n3 = i2++;
            this.v[n3] = this.v[n3] * l;
        }
        return true;
    }

    public void normalize() {
        if (!this.safeNormalizeN()) {
            throw new IllegalStateException("Normalization failed: " + this);
        }
    }

    public final void set(int i, double d) {
        this.v[i] = d;
    }

    public void set(double[] a) {
        System.arraycopy(a, 0, this.v, 0, this.v.length);
    }

    public void setIdentity() {
        this.v[0] = 1.0;
        int i = 1;
        while (i < this.v.length - 1) {
            this.v[i] = 0.0;
            ++i;
        }
    }
}

