/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import java.util.Arrays;

public class DVector6 {
    private final double[] v = new double[6];
    private static final int LEN = 6;

    public DVector6() {
    }

    public DVector6(DVector6 v2) {
        this();
        this.set(v2);
    }

    public DVector6(double d0, double d1, double d2, double d3, double d4, double d5) {
        this();
        this.set(d0, d1, d2, d3, d4, d5);
    }

    public DVector6 set(double d0, double d1, double d2, double d3, double d4, double d5) {
        this.v[0] = d0;
        this.v[1] = d1;
        this.v[2] = d2;
        this.v[3] = d3;
        this.v[4] = d4;
        this.v[5] = d5;
        return this;
    }

    public DVector6 set(double[] a) {
        this.v[0] = a[0];
        this.v[1] = a[1];
        this.v[2] = a[2];
        this.v[3] = a[3];
        this.v[4] = a[4];
        this.v[5] = a[5];
        return this;
    }

    public void set(DVector6 v2) {
        int i = 0;
        while (i < 6) {
            this.v[i] = v2.v[i];
            ++i;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("dVector6[");
        int i = 0;
        while (i < this.v.length - 1) {
            b.append(this.v[i]).append(", ");
            ++i;
        }
        b.append(this.v[this.v.length - 1]).append("]");
        return b.toString();
    }

    public int dim() {
        return 6;
    }

    public double get0() {
        return this.v[0];
    }

    public double get1() {
        return this.v[1];
    }

    public double get2() {
        return this.v[2];
    }

    public double get3() {
        return this.v[3];
    }

    public double get4() {
        return this.v[4];
    }

    public double get5() {
        return this.v[5];
    }

    public final double get(int i) {
        return this.v[i];
    }

    public boolean equals(DVector6 v2) {
        return Arrays.equals(this.v, v2.v);
    }

    public void set0(double d) {
        this.v[0] = d;
    }

    public void set1(double d) {
        this.v[1] = d;
    }

    public void set2(double d) {
        this.v[2] = d;
    }

    public void set3(double d) {
        this.v[3] = d;
    }

    public void set4(double d) {
        this.v[4] = d;
    }

    public void set5(double d) {
        this.v[5] = d;
    }

    public final void set(int i, double d) {
        this.v[i] = d;
    }

    public void add(int i, double d) {
        int n = i;
        this.v[n] = this.v[n] + d;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double lengthSquared() {
        return this.get0() * this.get0() + this.get1() * this.get1() + this.get2() * this.get2() + this.get3() * this.get3() + this.get4() * this.get4() + this.get5() * this.get5();
    }

    public final boolean safeNormalize6() {
        double d = Math.abs(this.v[0]);
        int i = 1;
        while (i < this.v.length) {
            if (Math.abs(this.v[i]) > d) {
                d = Math.abs(this.v[i]);
            }
            ++i;
        }
        if (d <= Double.MIN_NORMAL) {
            this.set(1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return false;
        }
        i = 0;
        while (i < this.v.length) {
            int n = i++;
            this.v[n] = this.v[n] / d;
        }
        double sum = 0.0;
        double[] dArray = this.v;
        int n = this.v.length;
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray[n2];
            sum += d2 * d2;
            ++n2;
        }
        double l = 1.0 / Math.sqrt(sum);
        int i2 = 0;
        while (i2 < this.v.length) {
            int n3 = i2++;
            this.v[n3] = this.v[n3] * l;
        }
        return true;
    }

    public void normalize() {
        if (!this.safeNormalize6()) {
            throw new IllegalStateException("Normalization failed: " + this);
        }
    }
}

