/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import org.ode4j.math.DVector4C;

public class DVector4
implements DVector4C {
    private final double[] v = new double[4];
    private static final int LEN = 4;

    public DVector4(DVector4 v4) {
        this();
        this.set(v4.v);
    }

    public DVector4() {
    }

    public void set(double a, double b, double c, double d) {
        this.v[0] = a;
        this.v[1] = b;
        this.v[2] = c;
        this.v[3] = d;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DVector4[ ");
        b.append(this.get0()).append(", ");
        b.append(this.get1()).append(", ");
        b.append(this.get2()).append(", ");
        b.append(this.get3()).append(" ]");
        return b.toString();
    }

    @Override
    public double get0() {
        return this.v[0];
    }

    @Override
    public double get1() {
        return this.v[1];
    }

    @Override
    public double get2() {
        return this.v[2];
    }

    @Override
    public double get3() {
        return this.v[3];
    }

    public int dim() {
        return 4;
    }

    public DVector4 scale(double d) {
        this.v[0] = this.v[0] * d;
        this.v[1] = this.v[1] * d;
        this.v[2] = this.v[2] * d;
        this.v[3] = this.v[3] * d;
        return this;
    }

    @Override
    public double lengthSquared() {
        return this.get0() * this.get0() + this.get1() * this.get1() + this.get2() * this.get2() + this.get3() * this.get3();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    public double get(int i) {
        return this.v[i];
    }

    public final boolean safeNormalize4() {
        double d = Math.abs(this.get0());
        if (Math.abs(this.get1()) > d) {
            d = Math.abs(this.get1());
        }
        if (Math.abs(this.get2()) > d) {
            d = Math.abs(this.get2());
        }
        if (Math.abs(this.get3()) > d) {
            d = Math.abs(this.get3());
        }
        if (d <= Double.MIN_NORMAL) {
            this.set(1.0, 0.0, 0.0, 0.0);
            return false;
        }
        this.scale(1.0 / d);
        double l = 1.0 / this.length();
        this.scale(l);
        return true;
    }

    public void normalize() {
        if (!this.safeNormalize4()) {
            throw new IllegalStateException("Normalization failed: " + this);
        }
    }

    public void set(double[] a) {
        System.arraycopy(a, 0, this.v, 0, this.v.length);
    }

    @Override
    public final double dot(DVector4C b) {
        return this.get0() * b.get0() + this.get1() * b.get1() + this.get2() * b.get2() + this.get3() * b.get3();
    }

    public void set0(double d) {
        this.v[0] = d;
    }

    public void set1(double d) {
        this.v[1] = d;
    }

    public void set2(double d) {
        this.v[2] = d;
    }

    public void set3(double d) {
        this.v[3] = d;
    }
}

