/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import org.ode4j.math.DMatrix3;
import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector3I;
import org.ode4j.math.DVector3View;

public class DVector3
implements DVector3I,
DVector3C {
    private final double[] v = new double[4];
    private static final int LEN = 4;
    public static final DVector3C ZERO = new DVector3();
    public static final int CURRENT_LENGTH = 4;

    public DVector3() {
    }

    public DVector3(DVector3C v2) {
        this();
        this.set(v2);
    }

    public DVector3(double[] v2) {
        this();
        this.set(v2);
    }

    public DVector3(double i, double j, double k) {
        this();
        this.set(i, j, k);
    }

    public final DVector3 set(double[] v2) {
        this.set(v2[0], v2[1], v2[2]);
        return this;
    }

    public void set(float[] v2) {
        this.set(v2[0], v2[1], v2[2]);
    }

    public final DVector3 set(double x, double y, double z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
        return this;
    }

    public final DVector3 set(DVector3C v2) {
        this.set0(v2.get0());
        this.set1(v2.get1());
        this.set2(v2.get2());
        return this;
    }

    public final DVector3 set(DMatrix3.DVector3ColView v2) {
        this.set0(v2.get0());
        this.set1(v2.get1());
        this.set2(v2.get2());
        return this;
    }

    @Override
    public DVector3 clone() {
        return new DVector3(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DVector3[ ");
        b.append(this.get0()).append(", ");
        b.append(this.get1()).append(", ");
        b.append(this.get2()).append(" ]");
        return b.toString();
    }

    @Override
    public final void set0(double d) {
        this.v[0] = d;
    }

    @Override
    public final void set1(double d) {
        this.v[1] = d;
    }

    @Override
    public final void set2(double d) {
        this.v[2] = d;
    }

    @Override
    public final double get0() {
        return this.v[0];
    }

    @Override
    public final double get1() {
        return this.v[1];
    }

    @Override
    public final double get2() {
        return this.v[2];
    }

    public final DVector3 add(double a, double b, double c) {
        this.v[0] = this.v[0] + a;
        this.v[1] = this.v[1] + b;
        this.v[2] = this.v[2] + c;
        return this;
    }

    public final DVector3 add(DVector3C v2) {
        this.v[0] = this.v[0] + v2.get0();
        this.v[1] = this.v[1] + v2.get1();
        this.v[2] = this.v[2] + v2.get2();
        return this;
    }

    public final DVector3 eqSum(DVector3C v2, DVector3C v3) {
        this.set0(v2.get0() + v3.get0());
        this.set1(v2.get1() + v3.get1());
        this.set2(v2.get2() + v3.get2());
        return this;
    }

    public final DVector3 eqSum(DVector3C v2, double s2, DVector3C v3, double s3) {
        this.set0(v2.get0() * s2 + v3.get0() * s3);
        this.set1(v2.get1() * s2 + v3.get1() * s3);
        this.set2(v2.get2() * s2 + v3.get2() * s3);
        return this;
    }

    public final DVector3 eqSum(DMatrix3.DVector3ColView v2, double s2, DVector3C v3, double s3) {
        this.set0(v2.get0() * s2 + v3.get0() * s3);
        this.set1(v2.get1() * s2 + v3.get1() * s3);
        this.set2(v2.get2() * s2 + v3.get2() * s3);
        return this;
    }

    public final DVector3 eqSum(DMatrix3.DVector3ColView v2, double s2, DMatrix3.DVector3ColView v3, double s3) {
        this.set0(v2.get0() * s2 + v3.get0() * s3);
        this.set1(v2.get1() * s2 + v3.get1() * s3);
        this.set2(v2.get2() * s2 + v3.get2() * s3);
        return this;
    }

    public final DVector3 eqSum(DVector3C v2, DVector3C v3, double s3) {
        this.set0(v2.get0() + v3.get0() * s3);
        this.set1(v2.get1() + v3.get1() * s3);
        this.set2(v2.get2() + v3.get2() * s3);
        return this;
    }

    public final DVector3 eqSum(DVector3C v2, DMatrix3.DVector3ColView v3, double s3) {
        this.set0(v2.get0() + v3.get0() * s3);
        this.set1(v2.get1() + v3.get1() * s3);
        this.set2(v2.get2() + v3.get2() * s3);
        return this;
    }

    public final DVector3 sub(double a, double b, double c) {
        this.v[0] = this.v[0] - a;
        this.v[1] = this.v[1] - b;
        this.v[2] = this.v[2] - c;
        return this;
    }

    public final DVector3 sub(DVector3C v2) {
        this.v[0] = this.v[0] - v2.get0();
        this.v[1] = this.v[1] - v2.get1();
        this.v[2] = this.v[2] - v2.get2();
        return this;
    }

    public final DVector3 scale(double a, double b, double c) {
        this.v[0] = this.v[0] * a;
        this.v[1] = this.v[1] * b;
        this.v[2] = this.v[2] * c;
        return this;
    }

    public final DVector3 scale(double s) {
        this.v[0] = this.v[0] * s;
        this.v[1] = this.v[1] * s;
        this.v[2] = this.v[2] * s;
        return this;
    }

    public final DVector3 scale(DVector3C v2) {
        this.v[0] = this.v[0] * v2.get0();
        this.v[1] = this.v[1] * v2.get1();
        this.v[2] = this.v[2] * v2.get2();
        return this;
    }

    @Override
    public final double dot(DVector3C b) {
        return this.get0() * b.get0() + this.get1() * b.get1() + this.get2() * b.get2();
    }

    @Override
    public final double dot(DVector3View b) {
        return this.get0() * b.get0() + this.get1() * b.get1() + this.get2() * b.get2();
    }

    public final DVector3 eqDiff(DVector3C v2, DVector3C v3) {
        this.v[0] = v2.get0() - v3.get0();
        this.v[1] = v2.get1() - v3.get1();
        this.v[2] = v2.get2() - v3.get2();
        return this;
    }

    @Override
    public final DVector3 reSub(DVector3C v2) {
        return new DVector3(this.get0() - v2.get0(), this.get1() - v2.get1(), this.get2() - v2.get2());
    }

    public final boolean safeNormalize() {
        double s;
        double aa0 = Math.abs(this.get0());
        double aa1 = Math.abs(this.get1());
        double aa2 = Math.abs(this.get2());
        if (aa1 > aa0) {
            s = aa2 > aa1 ? aa2 : aa1;
        } else if (aa2 > aa0) {
            s = aa2;
        } else {
            if (aa0 <= 0.0) {
                this.set(1.0, 0.0, 0.0);
                return false;
            }
            s = aa0;
        }
        this.scale(1.0 / s);
        this.scale(1.0 / this.length());
        return true;
    }

    public final void normalize() {
        if (!this.safeNormalize()) {
            throw new IllegalStateException("Normalization failed: " + this);
        }
    }

    @Override
    public final double distance(DVector3C a) {
        double r1 = this.get0() - a.get0();
        double r2 = this.get1() - a.get1();
        double r3 = this.get2() - a.get2();
        return Math.sqrt(r1 * r1 + r2 * r2 + r3 * r3);
    }

    public final boolean isEq(DVector3 a) {
        return this.get0() == a.get0() && this.get1() == a.get1() && this.get2() == a.get2();
    }

    public final void eqAbs() {
        this.set0(Math.abs(this.get0()));
        this.set1(Math.abs(this.get1()));
        this.set2(Math.abs(this.get2()));
    }

    public final void add0(double d) {
        this.v[0] = this.v[0] + d;
    }

    public final void add1(double d) {
        this.v[1] = this.v[1] + d;
    }

    public final void add2(double d) {
        this.v[2] = this.v[2] + d;
    }

    public final int dim() {
        return 3;
    }

    public final DVector3C reAdd(DVector3C c) {
        return new DVector3(this).add(c);
    }

    public final void wrapSet(double[] array, int pos) {
        array[pos] = this.get0();
        array[pos + 1] = this.get1();
        array[pos + 2] = this.get2();
    }

    public final void wrapAdd(double[] array, int pos) {
        int n = pos;
        array[n] = array[n] + this.get0();
        int n2 = pos + 1;
        array[n2] = array[n2] + this.get1();
        int n3 = pos + 2;
        array[n3] = array[n3] + this.get2();
    }

    public final void wrapSub(double[] array, int pos) {
        int n = pos;
        array[n] = array[n] - this.get0();
        int n2 = pos + 1;
        array[n2] = array[n2] - this.get1();
        int n3 = pos + 2;
        array[n3] = array[n3] - this.get2();
    }

    @Override
    public final DVector3 reScale(double d) {
        return new DVector3(this).scale(d);
    }

    public final void eqZero() {
        this.set(0.0, 0.0, 0.0);
    }

    public final void setZero() {
        this.eqZero();
    }

    public final void eqIdentity() {
        this.set(1.0, 0.0, 0.0);
    }

    public final void setIdentity() {
        this.eqIdentity();
    }

    @Override
    public final float[] toFloatArray4() {
        return new float[]{(float)this.get0(), (float)this.get1(), (float)this.get2(), 0.0f};
    }

    @Override
    public final double length() {
        return Math.sqrt(this.get0() * this.get0() + this.get1() * this.get1() + this.get2() * this.get2());
    }

    @Override
    public final double lengthSquared() {
        return this.get0() * this.get0() + this.get1() * this.get1() + this.get2() * this.get2();
    }

    @Override
    public final double get(int i) {
        return this.v[i];
    }

    @Override
    public final float[] toFloatArray() {
        return new float[]{(float)this.get0(), (float)this.get1(), (float)this.get2()};
    }

    public final void set(int i, double d) {
        this.v[i] = d;
    }

    public final void scale(int i, double d) {
        int n = i;
        this.v[n] = this.v[n] * d;
    }

    public final void add(int i, double d) {
        int n = i;
        this.v[n] = this.v[n] + d;
    }

    @Override
    public final double dotCol(DMatrix3C m, int col) {
        if (col == 0) {
            return this.get0() * m.get00() + this.get1() * m.get10() + this.get2() * m.get20();
        }
        if (col == 1) {
            return this.get0() * m.get01() + this.get1() * m.get11() + this.get2() * m.get21();
        }
        if (col == 2) {
            return this.get0() * m.get02() + this.get1() * m.get12() + this.get2() * m.get22();
        }
        throw new IllegalArgumentException("col=" + col);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DVector3I)) {
            return false;
        }
        DVector3I v = (DVector3I)obj;
        return this.get0() == v.get0() && this.get1() == v.get1() && this.get2() == v.get2();
    }

    public int hashCode() {
        return (int)(Double.doubleToRawLongBits(this.get0()) * Double.doubleToRawLongBits(this.get1()) * Double.doubleToRawLongBits(this.get2()));
    }

    public final DVector3 addScaled(DVector3C v2, double d) {
        this.v[0] = this.v[0] + v2.get0() * d;
        this.v[1] = this.v[1] + v2.get1() * d;
        this.v[2] = this.v[2] + v2.get2() * d;
        return this;
    }

    public final void eqCross(DVector3C b, DVector3C c) {
        this.set0(b.get1() * c.get2() - b.get2() * c.get1());
        this.set1(b.get2() * c.get0() - b.get0() * c.get2());
        this.set2(b.get0() * c.get1() - b.get1() * c.get0());
    }

    public final void eqProd(DMatrix3C m, DVector3C v2) {
        this.set0(m.get00() * v2.get0() + m.get01() * v2.get1() + m.get02() * v2.get2());
        this.set1(m.get10() * v2.get0() + m.get11() * v2.get1() + m.get12() * v2.get2());
        this.set2(m.get20() * v2.get0() + m.get21() * v2.get1() + m.get22() * v2.get2());
    }
}

