/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import org.ode4j.math.DQuaternionC;

public class DQuaternion
implements DQuaternionC {
    private final double[] v = new double[4];
    public static final int LEN = 4;

    public DQuaternion() {
    }

    public DQuaternion(double x0, double x1, double x2, double x3) {
        this();
        this.set(x0, x1, x2, x3);
    }

    public DQuaternion(DQuaternion x) {
        this();
        this.set(x);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DQuaternion[ ");
        b.append(this.get0()).append(", ");
        b.append(this.get1()).append(", ");
        b.append(this.get2()).append(", ");
        b.append(this.get3()).append(" ]");
        return b.toString();
    }

    public DQuaternion set(double x0, double x1, double x2, double x3) {
        this.v[0] = x0;
        this.v[1] = x1;
        this.v[2] = x2;
        this.v[3] = x3;
        return this;
    }

    public DQuaternion set(DQuaternionC q) {
        this.v[0] = q.get0();
        this.v[1] = q.get1();
        this.v[2] = q.get2();
        this.v[3] = q.get3();
        return this;
    }

    public DQuaternion scale(double d) {
        this.v[0] = this.v[0] * d;
        this.v[1] = this.v[1] * d;
        this.v[2] = this.v[2] * d;
        this.v[3] = this.v[3] * d;
        return this;
    }

    public DQuaternion add(DQuaternion q) {
        this.v[0] = this.v[0] + q.get0();
        this.v[1] = this.v[1] + q.get1();
        this.v[2] = this.v[2] + q.get2();
        this.v[3] = this.v[3] + q.get3();
        return this;
    }

    @Override
    public double get0() {
        return this.v[0];
    }

    @Override
    public double get1() {
        return this.v[1];
    }

    @Override
    public double get2() {
        return this.v[2];
    }

    @Override
    public double get3() {
        return this.v[3];
    }

    public int dim() {
        return 4;
    }

    public void set0(double d) {
        this.v[0] = d;
    }

    public void set1(double d) {
        this.v[1] = d;
    }

    public void set2(double d) {
        this.v[2] = d;
    }

    public void set3(double d) {
        this.v[3] = d;
    }

    public boolean equals(DQuaternion q) {
        return this.get0() == q.get0() && this.get1() == q.get1() && this.get2() == q.get2() && this.get3() == q.get3();
    }

    public boolean equals(Object q) {
        return false;
    }

    public void add(double d0, double d1, double d2, double d3) {
        this.v[0] = this.v[0] + d0;
        this.v[1] = this.v[1] + d1;
        this.v[2] = this.v[2] + d2;
        this.v[3] = this.v[3] + d3;
    }

    public final void sum(DQuaternion q1, DQuaternion q2, double d2) {
        this.v[0] = q1.get0() + q2.get0() * d2;
        this.v[1] = q1.get1() + q2.get1() * d2;
        this.v[2] = q1.get2() + q2.get2() * d2;
        this.v[3] = q1.get3() + q2.get3() * d2;
    }

    public final void set(int i, double d) {
        this.v[i] = d;
    }

    public final void setZero() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public final void scale(int i, double l) {
        int n = i;
        this.v[n] = this.v[n] * l;
    }

    public final double lengthSquared() {
        return this.get0() * this.get0() + this.get1() * this.get1() + this.get2() * this.get2() + this.get3() * this.get3();
    }

    @Override
    public final double get(int i) {
        return this.v[i];
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final boolean safeNormalize4() {
        double d = Math.abs(this.get0());
        if (Math.abs(this.get1()) > d) {
            d = Math.abs(this.get1());
        }
        if (Math.abs(this.get2()) > d) {
            d = Math.abs(this.get2());
        }
        if (Math.abs(this.get3()) > d) {
            d = Math.abs(this.get3());
        }
        if (d <= Double.MIN_NORMAL) {
            this.set(1.0, 0.0, 0.0, 0.0);
            return false;
        }
        this.scale(1.0 / d);
        double l = 1.0 / this.length();
        this.scale(l);
        return true;
    }

    public void normalize() {
        if (!this.safeNormalize4()) {
            throw new IllegalStateException("Normalization failed: " + this);
        }
    }

    public void setIdentity() {
        this.set(1.0, 0.0, 0.0, 0.0);
    }
}

