/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import org.ode4j.math.DVector3;
import org.ode4j.ode.internal.Misc;

public class DMatrixN {
    private final double[] v;
    private final int MAX_I;
    private final int MAX_J;

    public DMatrixN(int max_i, int max_j) {
        this.v = new double[max_i * max_j];
        this.MAX_I = max_i;
        this.MAX_J = max_j;
    }

    public DMatrixN(DMatrixN matrix) {
        this(matrix.MAX_I, matrix.MAX_J);
        this.set(matrix);
    }

    private DMatrixN(double[] a, int i, int j) {
        this.v = a;
        this.MAX_I = i;
        this.MAX_J = j;
    }

    public static DMatrixN wrap(double[] a, int i, int j) {
        return new DMatrixN(a, i, j);
    }

    public void set(DMatrixN mat) {
        System.arraycopy(mat.v, 0, this.v, 0, this.v.length);
    }

    public void setOfs(int ofs, DVector3 v3) {
        this.v[ofs] = v3.get0();
        this.v[ofs + 1] = v3.get1();
        this.v[ofs + 2] = v3.get2();
    }

    public void setCol(int i, DVector3 v3) {
        int ofs = i * 4;
        this.v[ofs] = v3.get0();
        this.v[ofs + 1] = v3.get1();
        this.v[ofs + 2] = v3.get2();
    }

    public void set(double[] da, int da_ofs) {
        System.arraycopy(da, da_ofs, this.v, 0, this.v.length);
    }

    public void set(double a) {
        int i = 0;
        while (i < this.v.length) {
            this.v[i] = a;
            ++i;
        }
    }

    public void set(double[] _data, int rowskip, int colskip) {
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < this.MAX_J) {
                this.v[i * this.MAX_J + j] = _data[i * rowskip + j * colskip];
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("dMatrixN=" + this.MAX_I + "*" + this.MAX_J + " \n");
        b.append("[[");
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < this.MAX_J - 1) {
                b.append(this.v[i * this.MAX_J + j]).append(", ");
                ++j;
            }
            b.append(this.v[i * this.MAX_J + this.MAX_J - 1]).append("],\n ");
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public DMatrixN reTranspose() {
        DMatrixN r = new DMatrixN(this.MAX_I, this.MAX_J);
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < this.MAX_J) {
                r.v[j * this.MAX_I + i] = this.v[i * this.MAX_J + j];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DMatrixN newSubMatrix(int np, int[] p, int nq, int[] q) {
        if (np < 1 || nq < 1) {
            this.dDebug(0, "Matrix select, bad index array sizes");
        }
        DMatrixN r = new DMatrixN(np, nq);
        int i = 0;
        while (i < np) {
            int j = 0;
            while (j < nq) {
                if (p[i] < 0 || p[i] >= this.MAX_I || q[i] < 0 || q[i] >= this.MAX_J) {
                    this.dDebug(0, "Matrix select, bad index arrays");
                }
                r.v[i * nq + j] = this.v[p[i] * this.MAX_J + q[j]];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DMatrixN mulNew(DMatrixN a) {
        if (this.MAX_I != a.MAX_J) {
            this.dDebug(0, "matrix *, mismatched sizes");
        }
        DMatrixN r = new DMatrixN(this.MAX_I, a.MAX_J);
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < a.MAX_J) {
                double sum = 0.0;
                int k = 0;
                while (k < this.MAX_J) {
                    sum += this.v[i * this.MAX_J + k] * a.v[k * a.MAX_J + j];
                    ++k;
                }
                r.v[i * a.MAX_I + j] = sum;
                ++j;
            }
            ++i;
        }
        return r;
    }

    void plusEq(DMatrixN a) {
        if (this.MAX_I != a.MAX_I || this.MAX_J != a.MAX_J) {
            this.dDebug(0, "matrix +=, mismatched sizes");
        }
        int i = 0;
        while (i < this.MAX_I * this.MAX_J) {
            int n = i;
            this.v[n] = this.v[n] + a.v[i];
            ++i;
        }
    }

    void subEq(DMatrixN a) {
        if (this.MAX_I != a.MAX_I || this.MAX_J != a.MAX_J) {
            this.dDebug(0, "matrix -=, mismatched sizes");
        }
        int i = 0;
        while (i < this.MAX_I * this.MAX_J) {
            int n = i;
            this.v[n] = this.v[n] - a.v[i];
            ++i;
        }
    }

    public void clearUpperTriangle() {
        if (this.MAX_I != this.MAX_J) {
            this.dDebug(0, "clearUpperTriangle() only works on square matrices");
        }
        int i = 0;
        while (i < this.MAX_I) {
            int j = i + 1;
            while (j < this.MAX_J) {
                this.v[i * this.MAX_J + j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void clearLowerTriangle() {
        if (this.MAX_I != this.MAX_J) {
            this.dDebug(0, "clearLowerTriangle() only works on square matrices");
        }
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < i) {
                this.v[i * this.MAX_J + j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    DMatrixN makeRandom(double range) {
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < this.MAX_J) {
                this.v[i * this.MAX_J + j] = (Misc.dRandReal() * 2.0 - 1.0) * range;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public double maxDifference(DMatrixN a) {
        if (this.MAX_J != a.MAX_J || this.MAX_I != a.MAX_I) {
            this.dDebug(0, "maxDifference(), mismatched sizes");
        }
        double max = 0.0;
        int i = 0;
        while (i < this.MAX_I) {
            int j = 0;
            while (j < this.MAX_J) {
                double diff = Math.abs(this.v[i * this.MAX_J + j] - a.v[i * this.MAX_J + j]);
                if (diff > max) {
                    max = diff;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public void set(int i, int j, double a) {
        this.v[i * this.MAX_J + j] = a;
    }

    private void dDebug(int n, String msg) {
        throw new IllegalStateException(msg);
    }
}

