/*
 * Decompiled with CFR 0.152.
 */
package org.ode4j.math;

import org.ode4j.math.DMatrix3C;
import org.ode4j.math.DVector3;
import org.ode4j.math.DVector3C;
import org.ode4j.math.DVector3View;

public final class DMatrix3
implements DMatrix3C {
    private final double[] v;
    public static final int MAX_I = 3;
    public static final int MAX_J = 4;
    public static final int LEN = 12;
    public static final DMatrix3C ZERO = new DMatrix3();

    public DMatrix3(double d, double e, double f, double g, double h, double i, double j, double k, double l, double m, double n, double o) {
        this();
        this.v[0] = d;
        this.v[1] = e;
        this.v[2] = f;
        this.v[3] = g;
        this.v[4] = h;
        this.v[5] = i;
        this.v[6] = j;
        this.v[7] = k;
        this.v[8] = l;
        this.v[9] = m;
        this.v[10] = n;
        this.v[11] = o;
        if (g != 0.0 || k != 0.0 || o != 0.0) {
            System.err.println("Warning: 4th column in dMatrix3 != 0 !");
        }
    }

    public DMatrix3(double d, double e, double f, double g, double h, double i, double j, double k, double l) {
        this();
        this.v[0] = d;
        this.v[1] = e;
        this.v[2] = f;
        this.v[4] = g;
        this.v[5] = h;
        this.v[6] = i;
        this.v[8] = j;
        this.v[9] = k;
        this.v[10] = l;
    }

    public DMatrix3(DMatrix3C matrix3) {
        this();
        this.set(matrix3);
    }

    public DMatrix3() {
        this.v = new double[12];
    }

    private DMatrix3(double[] a) {
        this.v = a;
    }

    public static DMatrix3 wrap(double[] a) {
        return new DMatrix3(a);
    }

    public DMatrix3 set(DMatrix3C m) {
        this.set00(m.get00());
        this.set01(m.get01());
        this.set02(m.get02());
        this.set10(m.get10());
        this.set11(m.get11());
        this.set12(m.get12());
        this.set20(m.get20());
        this.set21(m.get21());
        this.set22(m.get22());
        return this;
    }

    @Override
    public DMatrix3 clone() {
        return new DMatrix3(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DMatrix3[[");
        b.append(this.get00()).append(", ");
        b.append(this.get01()).append(", ");
        b.append(this.get02()).append("], [");
        b.append(this.get10()).append(", ");
        b.append(this.get11()).append(", ");
        b.append(this.get12()).append("], [");
        b.append(this.get20()).append(", ");
        b.append(this.get21()).append(", ");
        b.append(this.get22()).append("]]");
        return b.toString();
    }

    public void setOfs(int ofs, DVector3 v3) {
        this.v[ofs] = v3.get0();
        this.v[ofs + 1] = v3.get1();
        this.v[ofs + 2] = v3.get2();
    }

    public void setCol(int i, DVector3 v3) {
        int ofs = i * 4;
        this.v[ofs] = v3.get0();
        this.v[ofs + 1] = v3.get1();
        this.v[ofs + 2] = v3.get2();
    }

    public void set(double i, double j, double k, double l, double m, double n, double o, double p, double q) {
        this.set00(i);
        this.set01(j);
        this.set02(k);
        this.set10(l);
        this.set11(m);
        this.set12(n);
        this.set20(o);
        this.set21(p);
        this.set22(q);
    }

    public void set12(double[] da, int da_ofs) {
        System.arraycopy(da, da_ofs, this.v, 0, da.length);
    }

    public double get(int i) {
        return this.v[i];
    }

    @Override
    public DVector3 columnAsNewVector(int c) {
        return new DVector3(this.v[c], this.v[c + 4], this.v[c + 8]);
    }

    public DMatrix3 add(DMatrix3C m) {
        this.set00(this.get00() + m.get00());
        this.set01(this.get01() + m.get01());
        this.set02(this.get02() + m.get02());
        this.set10(this.get10() + m.get10());
        this.set11(this.get11() + m.get11());
        this.set12(this.get12() + m.get12());
        this.set20(this.get20() + m.get20());
        this.set21(this.get21() + m.get21());
        this.set22(this.get22() + m.get22());
        return this;
    }

    public void scale(double scale) {
        int i = 0;
        while (i < this.v.length) {
            int n = i++;
            this.v[n] = this.v[n] * scale;
        }
    }

    public void dMultiply0(DMatrix3C B, DMatrix3C C) {
        this.eqMul(B, C);
    }

    public void eqMul(DMatrix3C B, DMatrix3C C) {
        this.set00(B.get00() * C.get00() + B.get01() * C.get10() + B.get02() * C.get20());
        this.set01(B.get00() * C.get01() + B.get01() * C.get11() + B.get02() * C.get21());
        this.set02(B.get00() * C.get02() + B.get01() * C.get12() + B.get02() * C.get22());
        this.set10(B.get10() * C.get00() + B.get11() * C.get10() + B.get12() * C.get20());
        this.set11(B.get10() * C.get01() + B.get11() * C.get11() + B.get12() * C.get21());
        this.set12(B.get10() * C.get02() + B.get11() * C.get12() + B.get12() * C.get22());
        this.set20(B.get20() * C.get00() + B.get21() * C.get10() + B.get22() * C.get20());
        this.set21(B.get20() * C.get01() + B.get21() * C.get11() + B.get22() * C.get21());
        this.set22(B.get20() * C.get02() + B.get21() * C.get12() + B.get22() * C.get22());
    }

    @Override
    public DVector3ColView viewCol(int column) {
        return new DVector3ColView(column);
    }

    public DVector3RowTView viewRowT(int row) {
        return new DVector3RowTView(row);
    }

    @Override
    public final double get00() {
        return this.v[0];
    }

    @Override
    public final double get01() {
        return this.v[1];
    }

    @Override
    public final double get02() {
        return this.v[2];
    }

    @Override
    public final double get10() {
        return this.v[4];
    }

    @Override
    public final double get11() {
        return this.v[5];
    }

    @Override
    public final double get12() {
        return this.v[6];
    }

    @Override
    public final double get20() {
        return this.v[8];
    }

    @Override
    public final double get21() {
        return this.v[9];
    }

    @Override
    public final double get22() {
        return this.v[10];
    }

    public final void set00(double d) {
        this.v[0] = d;
    }

    public final void set01(double d) {
        this.v[1] = d;
    }

    public final void set02(double d) {
        this.v[2] = d;
    }

    public final void set10(double d) {
        this.v[4] = d;
    }

    public final void set11(double d) {
        this.v[5] = d;
    }

    public final void set12(double d) {
        this.v[6] = d;
    }

    public final void set20(double d) {
        this.v[8] = d;
    }

    public final void set21(double d) {
        this.v[9] = d;
    }

    public final void set22(double d) {
        this.v[10] = d;
    }

    public final int dimI() {
        return 3;
    }

    public final int dimJ() {
        return 3;
    }

    public final boolean isEqual(DMatrix3C m) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (this.get(i, j) != m.get(i, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DMatrix3C)) {
            return false;
        }
        DMatrix3C m = (DMatrix3C)o;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (this.get(i, j) != m.get(i, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final void eqIdentity() {
        this.eqZero();
        this.set00(1.0);
        this.set11(1.0);
        this.set22(1.0);
    }

    public final DMatrix3 setIdentity() {
        this.eqIdentity();
        return this;
    }

    public final void eqZero() {
        int i = 0;
        while (i < this.v.length) {
            this.v[i] = 0.0;
            ++i;
        }
    }

    public final void setZero() {
        this.eqZero();
    }

    @Override
    public final float[] toFloatArray12() {
        return new float[]{(float)this.get00(), (float)this.get01(), (float)this.get02(), 0.0f, (float)this.get10(), (float)this.get11(), (float)this.get12(), 0.0f, (float)this.get20(), (float)this.get21(), (float)this.get22(), 0.0f};
    }

    @Override
    public final float[] toFloatArray() {
        return new float[]{(float)this.get00(), (float)this.get01(), (float)this.get02(), (float)this.get10(), (float)this.get11(), (float)this.get12(), (float)this.get20(), (float)this.get21(), (float)this.get22()};
    }

    public final DMatrix3 eqTranspose() {
        double t = this.get01();
        this.set01(this.get10());
        this.set10(t);
        t = this.get02();
        this.set02(this.get20());
        this.set20(t);
        t = this.get21();
        this.set21(this.get12());
        this.set12(t);
        return this;
    }

    public final DMatrix3 reTranspose() {
        return new DMatrix3(this.get00(), this.get10(), this.get20(), this.get01(), this.get11(), this.get21(), this.get02(), this.get12(), this.get22());
    }

    @Override
    public final double dotCol(int col, DVector3C v3) {
        if (col == 0) {
            return this.get00() * v3.get0() + this.get10() * v3.get1() + this.get20() * v3.get2();
        }
        if (col == 1) {
            return this.get01() * v3.get0() + this.get11() * v3.get1() + this.get21() * v3.get2();
        }
        if (col == 2) {
            return this.get02() * v3.get0() + this.get12() * v3.get1() + this.get22() * v3.get2();
        }
        throw new IllegalArgumentException("col=" + col);
    }

    @Override
    public final double dotRow(int row, DVector3C v3) {
        if (row == 0) {
            return this.get00() * v3.get0() + this.get01() * v3.get1() + this.get02() * v3.get2();
        }
        if (row == 1) {
            return this.get10() * v3.get0() + this.get11() * v3.get1() + this.get12() * v3.get2();
        }
        if (row == 2) {
            return this.get20() * v3.get0() + this.get21() * v3.get1() + this.get22() * v3.get2();
        }
        throw new IllegalArgumentException("row=" + row);
    }

    @Override
    public final double dotColCol(int col, DMatrix3C m2, int col2) {
        if (col == 0) {
            if (col2 == 0) {
                return this.get00() * m2.get00() + this.get10() * m2.get10() + this.get20() * m2.get20();
            }
            if (col2 == 1) {
                return this.get00() * m2.get01() + this.get10() * m2.get11() + this.get20() * m2.get21();
            }
            if (col2 == 2) {
                return this.get00() * m2.get02() + this.get10() * m2.get12() + this.get20() * m2.get22();
            }
        } else if (col == 1) {
            if (col2 == 0) {
                return this.get01() * m2.get00() + this.get11() * m2.get10() + this.get21() * m2.get20();
            }
            if (col2 == 1) {
                return this.get01() * m2.get01() + this.get11() * m2.get11() + this.get21() * m2.get21();
            }
            if (col2 == 2) {
                return this.get01() * m2.get02() + this.get11() * m2.get12() + this.get21() * m2.get22();
            }
        } else if (col == 2) {
            if (col2 == 0) {
                return this.get02() * m2.get00() + this.get12() * m2.get10() + this.get22() * m2.get20();
            }
            if (col2 == 1) {
                return this.get02() * m2.get01() + this.get12() * m2.get11() + this.get22() * m2.get21();
            }
            if (col2 == 2) {
                return this.get02() * m2.get02() + this.get12() * m2.get12() + this.get22() * m2.get22();
            }
        }
        throw new IllegalArgumentException("col=" + col + " col2=" + col2);
    }

    @Override
    public double dotRowCol(int row, DMatrix3C m2, int col2) {
        if (row == 0) {
            if (col2 == 0) {
                return this.get00() * m2.get00() + this.get01() * m2.get10() + this.get02() * m2.get20();
            }
            if (col2 == 1) {
                return this.get00() * m2.get01() + this.get01() * m2.get11() + this.get02() * m2.get21();
            }
            if (col2 == 2) {
                return this.get00() * m2.get02() + this.get01() * m2.get12() + this.get02() * m2.get22();
            }
        } else if (row == 1) {
            if (col2 == 0) {
                return this.get10() * m2.get00() + this.get11() * m2.get10() + this.get12() * m2.get20();
            }
            if (col2 == 1) {
                return this.get10() * m2.get01() + this.get11() * m2.get11() + this.get12() * m2.get21();
            }
            if (col2 == 2) {
                return this.get10() * m2.get02() + this.get11() * m2.get12() + this.get12() * m2.get22();
            }
        } else if (row == 2) {
            if (col2 == 0) {
                return this.get20() * m2.get00() + this.get21() * m2.get10() + this.get22() * m2.get20();
            }
            if (col2 == 1) {
                return this.get20() * m2.get01() + this.get21() * m2.get11() + this.get22() * m2.get21();
            }
            if (col2 == 2) {
                return this.get20() * m2.get02() + this.get21() * m2.get12() + this.get22() * m2.get22();
            }
        }
        throw new IllegalArgumentException("row=" + row + " col2=" + col2);
    }

    @Override
    public final double dotRow(int row, double[] c, int cOfs) {
        if (row == 0) {
            return this.get00() * c[cOfs + 0] + this.get01() * c[cOfs + 1] + this.get02() * c[cOfs + 2];
        }
        if (row == 1) {
            return this.get10() * c[cOfs + 0] + this.get11() * c[cOfs + 1] + this.get12() * c[cOfs + 2];
        }
        if (row == 2) {
            return this.get20() * c[cOfs + 0] + this.get21() * c[cOfs + 1] + this.get22() * c[cOfs + 2];
        }
        throw new IllegalArgumentException("row=" + row);
    }

    @Override
    public double dotRowRow(int row, DMatrix3C m2, int row2) {
        if (row == 0) {
            if (row2 == 0) {
                return this.get00() * m2.get00() + this.get01() * m2.get01() + this.get02() * m2.get02();
            }
            if (row2 == 1) {
                return this.get00() * m2.get10() + this.get01() * m2.get11() + this.get02() * m2.get12();
            }
            if (row2 == 2) {
                return this.get00() * m2.get20() + this.get01() * m2.get21() + this.get02() * m2.get22();
            }
        } else if (row == 1) {
            if (row2 == 0) {
                return this.get10() * m2.get00() + this.get11() * m2.get01() + this.get12() * m2.get02();
            }
            if (row2 == 1) {
                return this.get10() * m2.get10() + this.get11() * m2.get11() + this.get12() * m2.get12();
            }
            if (row2 == 2) {
                return this.get10() * m2.get20() + this.get11() * m2.get21() + this.get12() * m2.get22();
            }
        } else if (row == 2) {
            if (row2 == 0) {
                return this.get20() * m2.get00() + this.get21() * m2.get01() + this.get22() * m2.get02();
            }
            if (row2 == 1) {
                return this.get20() * m2.get10() + this.get21() * m2.get11() + this.get22() * m2.get12();
            }
            if (row2 == 2) {
                return this.get20() * m2.get20() + this.get21() * m2.get21() + this.get22() * m2.get22();
            }
        }
        throw new IllegalArgumentException("row=" + row + " row2=" + row2);
    }

    @Override
    public double get(int i, int j) {
        return this.v[i * 4 + j];
    }

    public void set(int i, int j, double a) {
        this.v[i * 4 + j] = a;
    }

    public void add(int i, int j, double d) {
        int n = i * 4 + j;
        this.v[n] = this.v[n] + d;
    }

    public void sub(int i, int j, double d) {
        int n = i * 4 + j;
        this.v[n] = this.v[n] - d;
    }

    public class DVector3ColView
    extends DVector3View {
        private final int _column;

        public DVector3ColView(int c) {
            this._column = c;
        }

        @Override
        public double get(int i) {
            return DMatrix3.this.v[i * 4 + this._column];
        }

        @Override
        public double get0() {
            return DMatrix3.this.v[this._column];
        }

        @Override
        public double get1() {
            return DMatrix3.this.v[4 + this._column];
        }

        @Override
        public double get2() {
            return DMatrix3.this.v[8 + this._column];
        }

        @Override
        public void set0(double d) {
            ((DMatrix3)DMatrix3.this).v[this._column] = d;
        }

        @Override
        public void set1(double d) {
            ((DMatrix3)DMatrix3.this).v[4 + this._column] = d;
        }

        @Override
        public void set2(double d) {
            ((DMatrix3)DMatrix3.this).v[8 + this._column] = d;
        }

        @Override
        public String toString() {
            return "DVector3ColView" + super.toString();
        }
    }

    public class DVector3RowTView
    extends DVector3View {
        private final int _ofs;

        public DVector3RowTView(int row) {
            this._ofs = row * 4;
        }

        @Override
        public double get(int i) {
            return DMatrix3.this.v[this._ofs + i];
        }

        @Override
        public double get0() {
            return DMatrix3.this.v[this._ofs];
        }

        @Override
        public double get1() {
            return DMatrix3.this.v[1 + this._ofs];
        }

        @Override
        public double get2() {
            return DMatrix3.this.v[2 + this._ofs];
        }

        @Override
        public void set0(double d) {
            ((DMatrix3)DMatrix3.this).v[this._ofs] = d;
        }

        @Override
        public void set1(double d) {
            ((DMatrix3)DMatrix3.this).v[this._ofs + 1] = d;
        }

        @Override
        public void set2(double d) {
            ((DMatrix3)DMatrix3.this).v[this._ofs + 2] = d;
        }

        @Override
        public String toString() {
            return "DVector3RowTView" + super.toString();
        }
    }
}

