/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j.java;

import java.util.Arrays;

public class ObjArray<T> {
    private final T[] _data;
    private int _ofs;

    public ObjArray(T[] array) {
        this._data = array;
        this._ofs = 0;
    }

    public ObjArray(T[] array, int ofs) {
        this._data = array;
        this._ofs = ofs;
    }

    public ObjArray(ObjArray<T> array) {
        this._data = array._data;
        this._ofs = array._ofs;
    }

    public ObjArray(ObjArray<T> array, int ofs) {
        this._data = array._data;
        this._ofs = array._ofs + ofs;
        if (this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(array._ofs) + " + " + ofs + " = " + this._ofs + " >= " + this._data.length);
        }
    }

    public T at0() {
        return this._data[this._ofs];
    }

    public T at(int ofs) {
        return this._data[this._ofs + ofs];
    }

    public void setAt0(T d) {
        this._data[this._ofs] = d;
    }

    public void setAt(int ofs, T d) {
        this._data[this._ofs + ofs] = d;
    }

    public void setData(T[] data) {
        if (data.length + this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + this._ofs + " = " + (data.length + this._ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public void setData(ObjArray<T> array) {
        T[] data = array._data;
        int ofs = array._ofs;
        if (data.length + this._ofs + ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + ofs + " + " + this._ofs + " = " + (data.length + this._ofs + ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public T[] cloneData() {
        T[] ret = Arrays.copyOf(this._data, this._data.length - this._ofs);
        return ret;
    }

    public T[] cloneData(int ofs, int len) {
        Object[] ret = (Object[])this._data.clone();
        return ret;
    }

    public void dec() {
        --this._ofs;
    }

    public void dec(int n) {
        this._ofs -= n;
    }

    public void inc() {
        ++this._ofs;
    }

    public void inc(int n) {
        this._ofs += n;
    }

    public int size() {
        return this._data.length - this._ofs;
    }

    public int dataSize() {
        return this._data.length;
    }

    public void memcpy(int destPos, int srcPos, int len) {
        block3: {
            block2: {
                if (destPos <= srcPos) break block2;
                int i = this._ofs + len - 1;
                while (i >= this._ofs) {
                    this._data[destPos + i] = this._data[srcPos + i];
                    --i;
                }
                break block3;
            }
            if (destPos >= srcPos) break block3;
            int i = this._ofs;
            while (i < this._ofs + len) {
                this._data[destPos + i] = this._data[srcPos + i];
                ++i;
            }
        }
    }
}

