/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j.java;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class FormattedStringBuilder {
    public static final String NL = System.getProperty("line.separator");
    private StringBuilder _delegate;

    public FormattedStringBuilder() {
        this._delegate = new StringBuilder();
    }

    public FormattedStringBuilder(String initial) {
        this._delegate = new StringBuilder(initial);
    }

    public FormattedStringBuilder append(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this._delegate.append(s);
            ++n2;
        }
        return this;
    }

    public FormattedStringBuilder appendln(String ... strings) {
        this.append(strings);
        this._delegate.append(NL);
        return this;
    }

    public FormattedStringBuilder append(char c) {
        this._delegate.append(c);
        return this;
    }

    public FormattedStringBuilder append(int i) {
        this._delegate.append(i);
        return this;
    }

    public FormattedStringBuilder append(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(os);
        t.printStackTrace(p);
        p.close();
        return this.append(os.toString());
    }

    public FormattedStringBuilder appendln(Throwable t) {
        return this.append(t).appendln(new String[0]);
    }

    public FormattedStringBuilder appendRightAligned(String s, int alignPosition) {
        int fillPosition;
        int lineStart = this._delegate.lastIndexOf(NL);
        int currentLength = this._delegate.length();
        int rightPosition = alignPosition;
        if (lineStart != -1) {
            rightPosition = (lineStart += NL.length()) + alignPosition;
        }
        if ((fillPosition = rightPosition - s.length()) < currentLength) {
            throw new IllegalArgumentException("String \"" + s + "\" to right " + "align is longer than the unfilled buffer space [" + (rightPosition - currentLength) + "]");
        }
        this.fillBuffer(fillPosition, ' ');
        return this.append(s);
    }

    private FormattedStringBuilder fillBuffer(int newLength, char c) {
        int i = this._delegate.length();
        while (i < newLength) {
            this._delegate.append(c);
            ++i;
        }
        return this;
    }

    public FormattedStringBuilder fill(int newLength, char c) {
        int lineStart = this._delegate.lastIndexOf(NL);
        if (lineStart == -1) {
            return this.fillBuffer(newLength, c);
        }
        return this.fillBuffer((lineStart += NL.length()) + newLength, c);
    }

    public FormattedStringBuilder fill(int newLength) {
        return this.fill(newLength, ' ');
    }

    public FormattedStringBuilder fillOrCut(int newLength, char c) {
        if (newLength < 0) {
            throw new IllegalArgumentException();
        }
        int lineStart = this._delegate.lastIndexOf(NL);
        lineStart = lineStart == -1 ? 0 : (lineStart += NL.length());
        int lineLen = this._delegate.length() - lineStart;
        if (newLength < lineLen) {
            this._delegate = new StringBuilder(this._delegate.substring(0, lineStart + newLength));
            return this;
        }
        return this.fill(newLength, c);
    }

    public FormattedStringBuilder fillOrCutBuffer(int newLength, char c) {
        if (newLength < this._delegate.length()) {
            this._delegate = new StringBuilder(this._delegate.substring(0, newLength));
            return this;
        }
        int i = this._delegate.length();
        while (i < newLength) {
            this._delegate.append(c);
            ++i;
        }
        return this;
    }

    public int length() {
        return this._delegate.length();
    }

    public FormattedStringBuilder insert(int offset, String str) {
        this._delegate.insert(offset, str);
        return this;
    }

    public static FormattedStringBuilder wrap(StringBuilder builder) {
        FormattedStringBuilder b = new FormattedStringBuilder();
        b._delegate = builder;
        return b;
    }

    public String toString() {
        return this._delegate.toString();
    }
}

