/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j.java;

public class FloatArray {
    private final float[] _data;
    private int _ofs;

    public FloatArray(int size) {
        this._data = new float[size];
        this._ofs = 0;
    }

    public FloatArray(float[] array) {
        this._data = array;
        this._ofs = 0;
    }

    public FloatArray(float[] array, int ofs) {
        this._data = array;
        this._ofs = ofs;
    }

    public FloatArray(FloatArray array) {
        this._data = array._data;
        this._ofs = array._ofs;
    }

    public FloatArray(FloatArray array, int ofs) {
        this._data = array._data;
        this._ofs = array._ofs + ofs;
        if (this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(array._ofs) + " + " + ofs + " = " + this._ofs + " >= " + this._data.length);
        }
    }

    public float at0() {
        return this._data[this._ofs];
    }

    public float at(int ofs) {
        return this._data[this._ofs + ofs];
    }

    public void setAt0(float d) {
        this._data[this._ofs] = d;
    }

    public void setAt(int ofs, float d) {
        this._data[this._ofs + ofs] = d;
    }

    public void setData(float[] data) {
        if (data.length + this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + this._ofs + " = " + (data.length + this._ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public void setData(FloatArray array) {
        float[] data = array._data;
        int ofs = array._ofs;
        if (data.length + this._ofs + ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + ofs + " + " + this._ofs + " = " + (data.length + this._ofs + ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public float[] cloneData() {
        float[] ret = new float[this._data.length - this._ofs];
        System.arraycopy(this._data, this._ofs, ret, 0, this._data.length - this._ofs);
        return ret;
    }

    public float[] cloneData(int ofs, int len) {
        float[] ret = new float[len];
        System.arraycopy(this._data, this._ofs + ofs, ret, 0, len);
        return ret;
    }

    public void dec() {
        --this._ofs;
    }

    public void dec(int n) {
        this._ofs -= n;
    }

    public void inc() {
        ++this._ofs;
    }

    public void inc(int n) {
        this._ofs += n;
    }

    public int size() {
        return this._data.length - this._ofs;
    }
}

