/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j.java;

public class DoubleArray {
    private final double[] _data;
    private int _ofs;

    public DoubleArray(int size) {
        this._data = new double[size];
        this._ofs = 0;
    }

    public DoubleArray(double[] array) {
        this._data = array;
        this._ofs = 0;
    }

    public DoubleArray(double[] array, int ofs) {
        this._data = array;
        this._ofs = ofs;
    }

    public DoubleArray(DoubleArray array) {
        this._data = array._data;
        this._ofs = array._ofs;
    }

    public DoubleArray(DoubleArray array, int ofs) {
        this._data = array._data;
        this._ofs = array._ofs + ofs;
        if (this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(array._ofs) + " + " + ofs + " = " + this._ofs + " >= " + this._data.length);
        }
    }

    public double getAt0() {
        return this._data[this._ofs];
    }

    public double getAt(int ofs) {
        return this._data[this._ofs + ofs];
    }

    public void setAt0(double d) {
        this._data[this._ofs] = d;
    }

    public void setAt(int ofs, double d) {
        this._data[this._ofs + ofs] = d;
    }

    public void setData(double[] data) {
        if (data.length + this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + this._ofs + " = " + (data.length + this._ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public void setData(DoubleArray array) {
        double[] data = array._data;
        int ofs = array._ofs;
        if (data.length + this._ofs + ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(data.length) + " + " + ofs + " + " + this._ofs + " = " + (data.length + this._ofs + ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public double[] cloneData() {
        double[] ret = new double[this._data.length - this._ofs];
        System.arraycopy(this._data, this._ofs, ret, 0, this._data.length - this._ofs);
        return ret;
    }

    public double[] cloneData(int ofs, int len) {
        double[] ret = new double[len];
        System.arraycopy(this._data, this._ofs + ofs, ret, 0, len);
        return ret;
    }

    public void dec() {
        --this._ofs;
    }

    public void dec(int n) {
        this._ofs -= n;
    }

    public void inc() {
        ++this._ofs;
    }

    public void inc(int n) {
        this._ofs += n;
    }
}

