/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class FILE {
    private static final int EOF = -1;
    private static final long serialVersionUID = 1L;
    private OutputStream _out;
    private PushbackInputStream _in;

    public FILE(String pathname, String opt) {
        block4: {
            try {
                if (opt.equals("r") || opt.equals("rb")) {
                    this._in = new PushbackInputStream(new FileInputStream(pathname));
                    break block4;
                }
                if (opt.equals("r") || opt.equals("rb")) {
                    this._out = new FileOutputStream(pathname);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown option: " + opt);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public FILE(OutputStream out) {
        this._out = out;
    }

    public OutputStream out() {
        this.checkOut();
        return this._out;
    }

    public void write(int b) {
        this.checkOut();
        try {
            this._out.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkIn() {
        if (this._in == null) {
            throw new IllegalStateException("This stream is not open for reading.");
        }
    }

    private void checkOut() {
        if (this._out == null) {
            throw new IllegalStateException("This stream is not open for writing.");
        }
    }

    public void close() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._in = null;
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._out = null;
        }
    }

    public int fgetc() {
        this.checkIn();
        try {
            return this._in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char fgetcC() {
        return (char)this.fgetc();
    }

    public int ungetc(int c) {
        this.checkIn();
        try {
            this._in.unread(c);
            return c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int fread(byte[] ptr, int size, int nitems) {
        this.checkIn();
        try {
            return this._in.read(ptr, 0, size * nitems);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

