/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.ga.core;

import java.util.ArrayList;
import org.apache.log4j.Category;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATSpecie;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Specie;

public class Species {
    private static final Category cat;
    private ArrayList specieList = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.ga.core.Species");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public void addSpecie(Specie specie) {
        this.specieList.add(specie);
    }

    public ArrayList specieList() {
        return this.specieList;
    }

    public ArrayList validSpecieList(int championSpecieId) {
        ArrayList<Specie> validSpecies = new ArrayList<Specie>();
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (!(specie.isExtinct() && specie.id() != championSpecieId || specie.specieMembers().size() <= 0)) {
                validSpecies.add(specie);
            }
            ++i;
        }
        return validSpecies;
    }

    public void resetSpecies(double threshold) {
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (!specie.isExtinct()) {
                specie.resetSpecie(threshold);
            }
            ++i;
        }
    }

    public void shareFitness() {
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (specie.specieMembers().size() > 0) {
                specie.adjustFitness();
                specie.ageFitness();
            }
            ++i;
        }
    }

    public double totalAvSpeciesFitness() {
        double totalFitness = 0.0;
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (!specie.isExtinct() && specie.specieMembers().size() > 0) {
                totalFitness += specie.averageFitness();
            }
            ++i;
        }
        return totalFitness;
    }

    public void removeExtinctSpecies(NEATChromosome champion) {
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (specie.isExtinct() || specie.specieMembers().size() == 0) {
                if (!specie.containsMember(champion) && this.specieList.size() > 1) {
                    cat.info((Object)("Removing specie " + specie.id() + " size:" + specie.specieMembers().size() + ":fage:" + specie.getCurrentFitnessAge() + ":age:" + ((NEATSpecie)specie).specieAge() + ":avF:" + specie.averageFitness()));
                    this.specieList.remove(i);
                    continue;
                }
                cat.info((Object)("Specie " + specie.id() + " saved:" + specie.specieMembers().size() + ":fage:" + specie.getCurrentFitnessAge() + ":age:" + ((NEATSpecie)specie).specieAge() + ":avF:" + specie.averageFitness()));
                specie.reprieve();
                ++i;
                continue;
            }
            ++i;
        }
    }

    public Chromosome findBestFromSpecies() {
        Chromosome best = null;
        int i = 0;
        while (i < this.specieList.size()) {
            Specie specie = (Specie)this.specieList.get(i);
            if (specie.specieMembers().size() > 0 && (best == null || best.fitness() > specie.findBestMember().fitness())) {
                best = specie.findBestMember();
            }
            ++i;
        }
        return best;
    }

    public int calcSpecieOffspringCount(Specie specie, int popSize, double totalAvFitness) {
        int count = (int)Math.floor(specie.averageFitness() / totalAvFitness * (double)popSize);
        return count;
    }

    public Specie selectSpecie(int specieId) {
        NEATSpecie selectedSpecie = null;
        boolean specieFound = false;
        int i = 0;
        while (!specieFound && i < this.specieList.size() && specieId >= 1) {
            NEATSpecie testSpecie = (NEATSpecie)this.specieList.get(i);
            if (testSpecie.id() == specieId) {
                specieFound = true;
                selectedSpecie = testSpecie;
            }
            ++i;
        }
        return selectedSpecie;
    }
}

