/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core.pselectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.ChromosomeSet;
import org.neat4j.neat.ga.core.ParentSelector;
import org.neat4j.neat.ga.core.Population;
import org.neat4j.neat.ga.core.Specie;

public class TournamentSelector
implements ParentSelector {
    private int numElitist;
    private boolean naturalOrder = false;
    private Random rand = new Random();

    public void setElitismStrategy(int numElitst) {
        this.numElitist = numElitst;
    }

    private ChromosomeSet select(Chromosome[] genoTypes, boolean useElitismStrategy) {
        ChromosomeSet set = new ChromosomeSet(useElitismStrategy && this.numElitist > 0);
        if (useElitismStrategy) {
            Arrays.sort(genoTypes);
            int i = 0;
            while (i < this.numElitist) {
                set.add(genoTypes[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 2) {
                Chromosome pTwo;
                Chromosome pOne;
                if (genoTypes.length == 1) {
                    pOne = genoTypes[0];
                    pTwo = genoTypes[0];
                } else {
                    pOne = genoTypes[this.rand.nextInt(genoTypes.length - 1)];
                    pTwo = genoTypes[this.rand.nextInt(genoTypes.length - 1)];
                }
                set.add(this.performATournament(pOne, pTwo));
                ++i;
            }
        }
        return set;
    }

    public ChromosomeSet selectParents(Population currentPop, boolean useElitismStrategy) {
        Chromosome[] genoTypes = currentPop.genoTypes();
        return this.select(genoTypes, useElitismStrategy);
    }

    private Chromosome performATournament(Chromosome pOne, Chromosome pTwo) {
        Chromosome winner = null;
        winner = pOne.fitness() >= pTwo.fitness() ? (!this.naturalOrder ? pOne : pTwo) : (!this.naturalOrder ? pTwo : pOne);
        return winner;
    }

    public void setOrderStrategy(boolean naturalOrder) {
        this.naturalOrder = naturalOrder;
    }

    public ChromosomeSet selectParents(Specie specie, boolean useElitism) {
        ArrayList members = specie.specieMembers();
        Chromosome[] genoTypes = new Chromosome[members.size()];
        int i = 0;
        while (i < members.size()) {
            genoTypes[i] = (Chromosome)members.get(i);
            ++i;
        }
        return this.select(genoTypes, useElitism);
    }

    public ChromosomeSet selectParents(Chromosome[] members, boolean useElitism) {
        return this.select(members, useElitism);
    }
}

