/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Category;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATSpecieManager;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.ChromosomeSet;
import org.neat4j.neat.ga.core.CrossOver;
import org.neat4j.neat.ga.core.Mutator;
import org.neat4j.neat.ga.core.ParentSelector;
import org.neat4j.neat.ga.core.Specie;

public class NEATSpecie
extends Specie {
    private static final Category cat;
    private double excessCoeff;
    private double disjointCoeff;
    private double weightCoeff;
    private int specieAge;
    private double agePenalty;
    private double youthBoost;
    private int ageThreshold;
    private int youthThreshold;
    private double fitnessMultiplier = 1.0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.NEATSpecie");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public NEATSpecie(double threshold, double excessCoeff, double disjointCoeff, double weightCoeff, int id) {
        super(threshold, id);
        this.disjointCoeff = disjointCoeff;
        this.excessCoeff = excessCoeff;
        this.weightCoeff = weightCoeff;
    }

    public boolean addSpecieMember(Chromosome specieMember) {
        boolean addedOk = false;
        if (super.addSpecieMember(specieMember)) {
            ((NEATChromosome)specieMember).setSpecieId(this.id());
            addedOk = true;
        }
        return addedOk;
    }

    public void setAgePenalty(double agePenalty) {
        this.agePenalty = agePenalty;
    }

    public void setAgeThreshold(int ageThreshold) {
        this.ageThreshold = ageThreshold;
    }

    public void setSpecieAge(int specieAge) {
        this.specieAge = specieAge;
    }

    public void setYouthBoost(double youthBoost) {
        this.youthBoost = youthBoost;
    }

    protected void adjustFitness() {
        ArrayList members = this.specieMembers();
        this.fitnessMultiplier = 1.0;
        if (this.ageThreshold < this.specieAge) {
            this.fitnessMultiplier = this.agePenalty;
        } else if (this.youthThreshold > this.specieAge) {
            this.fitnessMultiplier = this.youthBoost;
        }
        int i = 0;
        while (i < members.size()) {
            Chromosome member = (Chromosome)members.get(i);
            member.updateFitness(member.fitness() * this.fitnessMultiplier);
            ++i;
        }
    }

    protected double fitnessMultiplier() {
        return this.fitnessMultiplier;
    }

    protected boolean isCompatable(Chromosome specieApplicant, Chromosome specieRepresentative) {
        boolean compatable = false;
        double compatabilityScore = 2.147483647E9;
        compatable = specieRepresentative == null ? true : (compatabilityScore = NEATSpecieManager.specieManager().compatibilityScore(specieApplicant, specieRepresentative, this.excessCoeff, this.disjointCoeff, this.weightCoeff)) < this.specieThreshold();
        return compatable;
    }

    protected Chromosome[] produceOffspring(int count, Mutator mut, ParentSelector selector, CrossOver xOver) {
        int i = 0;
        Chromosome[] offspring = new Chromosome[count];
        ArrayList unsorted = this.specieMembers();
        Object[] sorted = unsorted.toArray();
        Arrays.sort(sorted);
        int matableCount = (int)Math.ceil((double)sorted.length * this.getSurvivalThreshold());
        Chromosome[] matableMembers = new NEATChromosome[matableCount];
        i = 0;
        while (i < matableCount) {
            matableMembers[i] = (NEATChromosome)sorted[i];
            ++i;
        }
        if (count > 0) {
            offspring[0] = this.cloneChromosome((NEATChromosome)sorted[0]);
        }
        try {
            i = 1;
            while (i < offspring.length) {
                ChromosomeSet parents = selector.selectParents(matableMembers, false);
                ChromosomeSet child = xOver.crossOver(this.cloneParents(parents));
                offspring[i] = mut.mutate(child.nextChromosome());
                parents = null;
                ++i;
            }
            ++this.specieAge;
        }
        catch (Exception e) {
            cat.error((Object)("produceOffspring produced error:count:" + count + ":current iteration:" + i + ":specie size:" + this.specieMembers().size()));
            e.printStackTrace();
        }
        return offspring;
    }

    public int specieAge() {
        return this.specieAge;
    }

    public void setYouthThreshold(int youthThreshold) {
        this.youthThreshold = youthThreshold;
    }

    private ChromosomeSet cloneParents(ChromosomeSet clonee) {
        ChromosomeSet clonedSet = new ChromosomeSet();
        Chromosome cloneeChromo = clonee.nextChromosome();
        Chromosome clone = this.cloneChromosome(cloneeChromo);
        clone.updateFitness(cloneeChromo.fitness());
        clonedSet.add(clone);
        cloneeChromo = clonee.nextChromosome();
        clone = this.cloneChromosome(cloneeChromo);
        clone.updateFitness(cloneeChromo.fitness());
        clonedSet.add(clone);
        return clonedSet;
    }

    public int compareTo(Object arg0) {
        int compare = 0;
        if (arg0 instanceof Specie) {
            Specie s = (Specie)arg0;
            if (s.getAverageFitness() > this.getAverageFitness()) {
                compare = 1;
            } else if (s.getAverageFitness() < this.getAverageFitness()) {
                compare = -1;
            }
        }
        return compare;
    }
}

