/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import org.neat4j.neat.core.InnovationDatabase;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATFeatureGene;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.core.NEATNodeGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;
import org.neat4j.neat.ga.core.Population;
import org.neat4j.neat.utils.MathUtils;

public class NEATPopulation
implements Population {
    private Chromosome[] chromosomes;
    private int popSize;
    private int initialChromoSize;
    private int inputs;
    private int outputs;
    private boolean featureSelection;
    private int extraFeatureCount = 0;

    public NEATPopulation(int popSize, int initialChromoSize, int inputs, int outputs, boolean featureSelection, int extraFeaturecount) {
        this.popSize = popSize;
        this.initialChromoSize = initialChromoSize;
        this.inputs = inputs;
        this.outputs = outputs;
        this.featureSelection = featureSelection;
        this.extraFeatureCount = extraFeaturecount;
    }

    public NEATPopulation(int popSize, int initialChromoSize, int inputs, int outputs, boolean featureSelection) {
        this(popSize, initialChromoSize, inputs, outputs, featureSelection, 0);
    }

    public Chromosome[] genoTypes() {
        return this.chromosomes;
    }

    public void createPopulation() {
        this.chromosomes = new Chromosome[this.popSize];
        Chromosome[] templates = InnovationDatabase.database().initialiseInnovations(this.popSize, this.inputs, this.outputs, this.featureSelection, this.extraFeatureCount);
        int i = 0;
        while (i < this.popSize) {
            this.chromosomes[i] = this.individualFromTemplate(templates[i]);
            ++i;
        }
    }

    private Chromosome individualFromTemplate(Chromosome template) {
        Gene[] templateGenes = template.genes();
        Gene[] individualGenes = new Gene[templateGenes.length];
        int i = 0;
        while (i < templateGenes.length) {
            if (templateGenes[i] instanceof NEATNodeGene) {
                NEATNodeGene nodeGene = (NEATNodeGene)templateGenes[i];
                individualGenes[i] = new NEATNodeGene(nodeGene.getInnovationNumber(), nodeGene.id(), MathUtils.nextPlusMinusOne(), nodeGene.getType(), MathUtils.nextDouble());
            } else if (templateGenes[i] instanceof NEATLinkGene) {
                NEATLinkGene linkGene = (NEATLinkGene)templateGenes[i];
                individualGenes[i] = new NEATLinkGene(linkGene.getInnovationNumber(), true, linkGene.getFromId(), linkGene.getToId(), MathUtils.nextPlusMinusOne());
            } else if (templateGenes[i] instanceof NEATFeatureGene) {
                NEATFeatureGene featureGene = (NEATFeatureGene)templateGenes[i];
                individualGenes[i] = new NEATFeatureGene(featureGene.getInnovationNumber(), MathUtils.nextDouble());
            }
            ++i;
        }
        return new NEATChromosome(individualGenes);
    }

    public void updatePopulation(Chromosome[] newGenoTypes) {
        if (newGenoTypes.length == this.popSize) {
            System.arraycopy(newGenoTypes, 0, this.chromosomes, 0, this.popSize);
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ".updatePopulation() incompatable newGenoTypes length");
        }
    }
}

