/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import org.neat4j.neat.core.NEATGene;

public class NEATNodeGene
implements NEATGene {
    private int innovationNumber;
    private int id;
    private double sigmoidFactor = -1.0;
    private int type;
    private double depth;
    private double bias;
    public static final int HIDDEN = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT = 2;

    public NEATNodeGene(int innovationNumber, int id, double sigmoidF, int type, double bias) {
        this.innovationNumber = innovationNumber;
        this.id = id;
        this.sigmoidFactor = sigmoidF;
        this.type = type;
        this.bias = bias;
        this.initialiseDepth();
    }

    private void initialiseDepth() {
        if (this.type == 2) {
            this.depth = 0.0;
        } else if (this.type == 1) {
            this.depth = 1.0;
        }
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setSigmoidFactor(double bias) {
        this.sigmoidFactor = bias;
    }

    public int getType() {
        return this.type;
    }

    public int getInnovationNumber() {
        return this.innovationNumber;
    }

    public int id() {
        return this.id;
    }

    public double sigmoidFactor() {
        return this.sigmoidFactor;
    }

    public Number geneAsNumber() {
        return new Integer(this.innovationNumber);
    }

    public String geneAsString() {
        return String.valueOf(this.innovationNumber) + ":" + this.id + ":" + this.sigmoidFactor;
    }

    public double bias() {
        return this.bias;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }
}

