/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import java.util.ArrayList;
import org.neat4j.neat.nn.core.ActivationFunction;
import org.neat4j.neat.nn.core.Neuron;
import org.neat4j.neat.nn.core.Synapse;

public class NEATNeuron
implements Neuron {
    private double lastActivation;
    private double bias;
    private double[] weights;
    private ActivationFunction activationFunction;
    private int id;
    private int type;
    private int depth;
    private ArrayList sourceNeurons;
    private ArrayList incomingSynapses;
    private boolean isInput = false;

    public NEATNeuron(ActivationFunction function, int id, int type) {
        this.activationFunction = function;
        this.id = id;
        this.type = type;
        this.sourceNeurons = new ArrayList();
        this.incomingSynapses = new ArrayList();
        this.isInput = type == 2;
        this.depth = -1;
    }

    public void addSourceNeuron(NEATNeuron neuron) {
        this.sourceNeurons.add(neuron);
    }

    public void addIncomingSynapse(Synapse synapse) {
        this.incomingSynapses.add(synapse);
    }

    public ArrayList incomingSynapses() {
        return this.incomingSynapses;
    }

    public ArrayList sourceNeurons() {
        return this.sourceNeurons;
    }

    public double lastActivation() {
        return this.lastActivation;
    }

    public double activate(double[] nInputs) {
        double neuronIp = 0.0;
        int i = 0;
        Object[] incoming = this.incomingSynapses.toArray();
        this.lastActivation = -1.0;
        if (!this.isInput) {
            if (nInputs.length > 0) {
                i = 0;
                while (i < nInputs.length) {
                    double input = nInputs[i];
                    Synapse synapse = (Synapse)incoming[i];
                    if (synapse.isEnabled()) {
                        double weight = synapse.getWeight();
                        neuronIp += input * weight;
                    }
                    ++i;
                }
                this.lastActivation = this.activationFunction.activate(neuronIp += -1.0 * this.bias);
            }
        } else {
            this.lastActivation = nInputs[0];
        }
        return this.lastActivation;
    }

    public ActivationFunction function() {
        return this.activationFunction;
    }

    public void modifyWeights(double[] weightMods, double[] momentum, boolean mode) {
        System.arraycopy(weightMods, 0, this.weights, 0, this.weights.length);
    }

    public void modifyBias(double biasMod, double momentum, boolean mode) {
        this.bias = biasMod;
    }

    public double[] weights() {
        return this.weights;
    }

    public double bias() {
        return this.bias;
    }

    public double[] lastWeightDeltas() {
        return null;
    }

    public double lastBiasDelta() {
        return 0.0;
    }

    public int id() {
        return this.id;
    }

    public int neuronType() {
        return this.type;
    }

    public int neuronDepth() {
        return this.depth;
    }

    public void setNeuronDepth(int depth) {
        this.depth = depth;
    }
}

