/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.log4j.Category;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATGADescriptor;
import org.neat4j.neat.core.NEATPopulation;
import org.neat4j.neat.core.NEATSpecie;
import org.neat4j.neat.core.mutators.NEATMutator;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.ChromosomeSet;
import org.neat4j.neat.ga.core.CrossOver;
import org.neat4j.neat.ga.core.FitnessFunction;
import org.neat4j.neat.ga.core.GADescriptor;
import org.neat4j.neat.ga.core.GeneticAlgorithm;
import org.neat4j.neat.ga.core.Mutator;
import org.neat4j.neat.ga.core.ParentSelector;
import org.neat4j.neat.ga.core.Population;
import org.neat4j.neat.ga.core.Specie;
import org.neat4j.neat.ga.core.Species;

public class NEATGeneticAlgorithm
implements GeneticAlgorithm {
    private static final long serialVersionUID = 1L;
    private static final Category cat;
    private NEATGADescriptor descriptor;
    private NEATMutator mut;
    private FitnessFunction func;
    private ParentSelector selector;
    private CrossOver xOver;
    private Population pop;
    private Chromosome discoveredBest;
    private Chromosome genBest;
    private Species specieList;
    private static int specieIdIdx;
    private int eleCount = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.NEATGeneticAlgorithm");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
        specieIdIdx = 1;
    }

    public NEATGeneticAlgorithm(NEATGADescriptor descriptor) {
        this.descriptor = descriptor;
        this.specieList = new Species();
    }

    public FitnessFunction gaEvaluator() {
        return this.func;
    }

    public GADescriptor descriptor() {
        return this.descriptor;
    }

    public void createPopulation() {
        int popSize = this.descriptor.gaPopulationSize();
        int initialChromoSize = this.func.requiredChromosomeSize() + this.descriptor.getExtraFeatureCount();
        this.pop = new NEATPopulation(popSize, initialChromoSize, this.descriptor.getInputNodes(), this.descriptor.getOutputNodes(), this.descriptor.featureSelectionEnabled(), this.descriptor.getExtraFeatureCount());
        this.pop.createPopulation();
    }

    private Chromosome findBestChromosome(Chromosome[] genoTypes) {
        Chromosome best = genoTypes[0];
        int i = 1;
        while (i < genoTypes.length) {
            if (this.descriptor.isNaturalOrder()) {
                if (genoTypes[i].fitness() < best.fitness()) {
                    best = genoTypes[i];
                }
            } else if (genoTypes[i].fitness() > best.fitness()) {
                best = genoTypes[i];
            }
            ++i;
        }
        return best;
    }

    private void evaluatePopulation(Chromosome[] genoTypes) {
        int i = 0;
        while (i < genoTypes.length) {
            double eval = this.func.evaluate(genoTypes[i]);
            genoTypes[i].updateFitness(eval);
            ++i;
        }
    }

    private Chromosome cloneBest(Chromosome best) {
        NEATChromosome cloneBest = new NEATChromosome(best.genes());
        cloneBest.updateFitness(best.fitness());
        cloneBest.setSpecieId(((NEATChromosome)best).getSpecieId());
        return cloneBest;
    }

    private void speciatePopulation(Chromosome[] currentGen) {
        Specie specie;
        boolean memberAssigned = false;
        this.specieList.resetSpecies(this.descriptor.getThreshold());
        cat.info((Object)("Compat threshold:" + this.descriptor.getThreshold()));
        int i = 0;
        while (i < currentGen.length) {
            if (!memberAssigned) {
                ArrayList currentSpecieList = this.specieList.specieList();
                int j = 0;
                while (!memberAssigned && j < currentSpecieList.size()) {
                    specie = (Specie)currentSpecieList.get(j);
                    if (specie.addSpecieMember(currentGen[i])) {
                        memberAssigned = true;
                        continue;
                    }
                    ++j;
                }
                if (!memberAssigned) {
                    specie = this.createNewSpecie(currentGen[i]);
                    this.specieList.addSpecie(specie);
                    cat.info((Object)("Created new specie, member assigned to specie " + specie.id()));
                }
            }
            memberAssigned = false;
            ++i;
        }
        if (cat.isDebugEnabled()) {
            i = 0;
            while (i < this.specieList.specieList().size()) {
                specie = (Specie)this.specieList.specieList().get(i);
                if (!specie.isExtinct() && specie.specieMembers().size() > 0) {
                    cat.debug((Object)("Specie:" + specie.id() + ":size:" + specie.specieMembers().size() + ":age:" + ((NEATSpecie)specie).specieAge() + ":fAge:" + specie.getCurrentFitnessAge() + ":best:" + specie.findBestMember().fitness()));
                }
                ++i;
            }
        }
    }

    public void runEpoch() {
        Chromosome[] currentGen = this.pop.genoTypes();
        this.setChromosomeNO(currentGen);
        cat.debug((Object)"Evaluating pop");
        this.evaluatePopulation(currentGen);
        this.runEvolutionCycle(currentGen);
    }

    public void runEvolutionCycle(Chromosome[] currentGen) {
        this.runEle(currentGen);
        this.speciatePopulation(currentGen);
        this.genBest = this.findBestChromosome(currentGen);
        if (this.discoveredBest == null || this.genBest.fitness() >= this.discoveredBest.fitness() && !this.descriptor.isNaturalOrder() || this.genBest.fitness() <= this.discoveredBest.fitness() && this.descriptor.isNaturalOrder()) {
            this.discoveredBest = this.cloneBest(this.genBest);
        }
        cat.info((Object)("Best Ever Raw:" + this.discoveredBest.fitness() + ":from specie:" + ((NEATChromosome)this.discoveredBest).getSpecieId()));
        cat.debug((Object)("Best of Generation is:" + this.genBest.fitness() + " specie " + ((NEATChromosome)this.genBest).getSpecieId()));
        NEATChromosome champ = this.descriptor.keepBestEver() ? (NEATChromosome)this.discoveredBest : (NEATChromosome)this.genBest;
        this.specieList.removeExtinctSpecies(champ);
        cat.debug((Object)"Creating New Gen");
        this.pop.updatePopulation(this.spawn());
        ArrayList validSpecieList = this.specieList.validSpecieList(champ.getSpecieId());
        cat.debug((Object)("Num species:" + validSpecieList.size()));
        if (this.descriptor.getCompatabilityChange() > 0.0) {
            if (validSpecieList.size() > this.descriptor.getSpecieCount()) {
                this.descriptor.setThreshold(this.descriptor.getThreshold() + this.descriptor.getCompatabilityChange());
            } else if (validSpecieList.size() < this.descriptor.getSpecieCount() && this.descriptor.getThreshold() > this.descriptor.getCompatabilityChange()) {
                this.descriptor.setThreshold(this.descriptor.getThreshold() - this.descriptor.getCompatabilityChange());
            }
        }
        ++this.eleCount;
    }

    private void runEle(Chromosome[] currentGen) {
        if (this.descriptor.isEleEvents()) {
            if (this.eleCount % this.descriptor.getEleEventTime() == 0 && this.eleCount != 0) {
                cat.info((Object)"Runnig ELE");
                this.descriptor.setThreshold(this.descriptor.getThreshold() * 5.0);
            } else if (this.eleCount % this.descriptor.getEleEventTime() == 1 && this.eleCount != 1) {
                this.descriptor.setThreshold(this.descriptor.getThreshold() / 5.0);
            }
        }
    }

    private void setChromosomeNO(Chromosome[] gen) {
        int i = 0;
        while (i < gen.length) {
            ((NEATChromosome)gen[i]).setNaturalOrder(this.descriptor.isNaturalOrder());
            ++i;
        }
    }

    private Chromosome[] spawn() {
        Chromosome[] currentGen = this.pop.genoTypes();
        Chromosome[] newGen = new Chromosome[currentGen.length];
        Specie specie = null;
        ChromosomeSet offspring = null;
        int newGenIdx = 0;
        int j = 0;
        this.specieList.shareFitness();
        double totalAvFitness = this.specieList.totalAvSpeciesFitness();
        ArrayList species = this.specieList.validSpecieList(((NEATChromosome)this.discoveredBest).getSpecieId());
        int i = 0;
        while (i < species.size()) {
            int offSpringCount;
            specie = (Specie)species.get(i);
            if (specie.specieMembers().size() == 0) {
                cat.error((Object)"spawn produced error:");
            }
            if ((offSpringCount = i == species.size() - 1 ? newGen.length - newGenIdx : this.specieList.calcSpecieOffspringCount(specie, this.descriptor.gaPopulationSize(), totalAvFitness)) > 0) {
                offspring = specie.specieOffspring(offSpringCount, this.mut, this.selector, this.xOver);
                j = 0;
                while (j < offspring.size()) {
                    if (newGenIdx < newGen.length) {
                        newGen[newGenIdx++] = offspring.nextChromosome();
                    }
                    ++j;
                }
            } else {
                cat.debug((Object)("Specie " + specie.id() + ":size:" + specie.specieMembers().size() + " produced no offspring.  Average fitness was " + specie.averageFitness() + " out of a total fitness of " + this.specieList.totalAvSpeciesFitness()));
                specie.setExtinct();
            }
            ++i;
        }
        return newGen;
    }

    private Specie createNewSpecie(Chromosome member) {
        double excessCoeff = this.descriptor.getExcessCoeff();
        double disjointCoeff = this.descriptor.getDisjointCoeff();
        double weightCoeff = this.descriptor.getWeightCoeff();
        double threshold = this.descriptor.getThreshold();
        NEATSpecie specie = new NEATSpecie(threshold, excessCoeff, disjointCoeff, weightCoeff, specieIdIdx++);
        specie.setMaxFitnessAge(this.descriptor.getMaxSpecieAge());
        specie.setAgePenalty(this.descriptor.getAgePenalty());
        specie.setAgeThreshold(this.descriptor.getSpecieAgeThreshold());
        specie.setYouthBoost(this.descriptor.getYouthBoost());
        specie.setYouthThreshold(this.descriptor.getSpecieYouthThreshold());
        specie.setSurvivalThreshold(this.descriptor.getSurvivalThreshold());
        specie.addSpecieMember(member);
        return specie;
    }

    public Chromosome discoverdBestMember() {
        return this.discoveredBest;
    }

    public void pluginMutator(Mutator mut) {
        this.mut = (NEATMutator)mut;
        this.mut.setPAddLink(this.descriptor.getPAddLink());
        this.mut.setPAddNode(this.descriptor.getPAddNode());
        this.mut.setPPerturb(this.descriptor.getPMutation());
        this.mut.setPToggle(this.descriptor.getPToggleLink());
        this.mut.setPWeightReplaced(this.descriptor.getPWeightReplaced());
        this.mut.setFeatureSelection(this.descriptor.featureSelectionEnabled());
        this.mut.setRecurrencyAllowed(this.descriptor.isRecurrencyAllowed());
        this.mut.setPMutateBias(this.descriptor.getPMutateBias());
        this.mut.setBiasPerturb(this.descriptor.getMaxBiasPerturb());
        this.mut.setPerturb(this.descriptor.getMaxPerturb());
    }

    public void pluginFitnessFunction(FitnessFunction func) {
        this.func = func;
    }

    public void pluginParentSelector(ParentSelector selector) {
        this.selector = selector;
        this.selector.setOrderStrategy(this.descriptor.isNaturalOrder());
    }

    public void pluginCrossOver(CrossOver xOver) {
        this.xOver = xOver;
        this.xOver.setProbability(this.descriptor.getPXover());
    }

    public void savePopulationState(String fileName) {
        FileOutputStream out = null;
        ObjectOutputStream s = null;
        try {
            try {
                if (fileName != null) {
                    cat.debug((Object)("Saving Population " + fileName));
                    out = new FileOutputStream(fileName);
                    s = new ObjectOutputStream(out);
                    s.writeObject(this.pop);
                    s.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                s.close();
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        cat.debug((Object)"Saving Population...Done");
    }

    public Population population() {
        return this.pop;
    }

    public Chromosome generationBest() {
        return this.genBest;
    }
}

