/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.applications.train;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Category;
import org.neat4j.core.AIConfig;
import org.neat4j.core.InitialisationFailedException;
import org.neat4j.neat.core.InnovationDatabase;
import org.neat4j.neat.core.NEATGADescriptor;
import org.neat4j.neat.core.NEATGeneticAlgorithm;
import org.neat4j.neat.core.NEATLoader;
import org.neat4j.neat.core.control.NEATNetManager;
import org.neat4j.neat.core.fitness.InvalidFitnessFunction;
import org.neat4j.neat.core.mutators.InvalidMutatorFunction;
import org.neat4j.neat.core.pselectors.InvalidParentSelectorFunction;
import org.neat4j.neat.core.xover.InvalidCrossoverFunction;
import org.neat4j.neat.data.core.NetworkDataSet;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.CrossOver;
import org.neat4j.neat.ga.core.FitnessFunction;
import org.neat4j.neat.ga.core.GADescriptor;
import org.neat4j.neat.ga.core.GeneticAlgorithm;
import org.neat4j.neat.ga.core.Mutator;
import org.neat4j.neat.ga.core.ParentSelector;
import org.neat4j.neat.nn.core.LearningEnvironment;
import org.neat4j.neat.nn.core.NeuralNet;

public class NEATGATrainingManager {
    private static final Category cat;
    private GeneticAlgorithm ga;
    private AIConfig config;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.applications.train.NEATGATrainingManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public GeneticAlgorithm ga() {
        return this.ga;
    }

    public void initialise(AIConfig config) throws InitialisationFailedException {
        GADescriptor gaDescriptor = this.createDescriptor(config);
        this.assigGA(this.createGeneticAlgorithm(gaDescriptor));
        try {
            this.assignConfig(config);
            this.ga.pluginFitnessFunction(this.createFunction(config));
            this.ga.pluginCrossOver(this.createCrossOver(config));
            this.ga.pluginMutator(this.createMutator(config));
            this.ga.pluginParentSelector(this.createParentSelector(config));
            this.ga.createPopulation();
        }
        catch (InvalidFitnessFunction e) {
            throw new InitialisationFailedException(e.getMessage());
        }
        catch (InvalidCrossoverFunction e) {
            throw new InitialisationFailedException(e.getMessage());
        }
        catch (InvalidMutatorFunction e) {
            throw new InitialisationFailedException(e.getMessage());
        }
        catch (InvalidParentSelectorFunction e) {
            throw new InitialisationFailedException(e.getMessage());
        }
        catch (Exception e) {
            throw new InitialisationFailedException(e.getMessage());
        }
    }

    public void assigGA(GeneticAlgorithm ga) {
        this.ga = ga;
    }

    public void assignConfig(AIConfig config) {
        this.config = config;
    }

    public void evolve() {
        int epochs = Integer.parseInt(this.config.configElement("NUMBER.EPOCHS"));
        double terminateVal = ((NEATGADescriptor)this.ga.descriptor()).getTerminationValue();
        boolean nOrder = ((NEATGADescriptor)this.ga.descriptor()).isNaturalOrder();
        boolean terminate = false;
        int i = 0;
        while (i < epochs && !terminate) {
            cat.info((Object)("Running Epoch[" + i + "]\r"));
            this.ga.runEpoch();
            this.saveBest();
            if (this.ga.discoverdBestMember().fitness() >= terminateVal && !nOrder || this.ga.discoverdBestMember().fitness() <= terminateVal && nOrder) {
                terminate = true;
            }
            ++i;
        }
        cat.debug((Object)("Innovation Database Stats - Hits:" + InnovationDatabase.hits + " - misses:" + InnovationDatabase.misses));
    }

    public void saveBest() {
        this.save(this.config.configElement("SAVE.LOCATION"), this.ga.discoverdBestMember());
    }

    public GADescriptor createDescriptor(AIConfig config) {
        int popSize = Integer.parseInt(config.configElement("POP.SIZE"));
        double pXover = Double.parseDouble(config.configElement("PROBABILITY.CROSSOVER"));
        double pAddLink = Double.parseDouble(config.configElement("PROBABILITY.ADDLINK"));
        double pAddNode = Double.parseDouble(config.configElement("PROBABILITY.ADDNODE"));
        double pToggleLink = Double.parseDouble(config.configElement("PROBABILITY.TOGGLELINK"));
        double pMutation = Double.parseDouble(config.configElement("PROBABILITY.MUTATION"));
        double pMutateBias = Double.parseDouble(config.configElement("PROBABILITY.MUTATEBIAS"));
        double pWeightReplaced = Double.parseDouble(config.configElement("PROBABILITY.WEIGHT.REPLACED"));
        double excessCoeff = Double.parseDouble(config.configElement("EXCESS.COEFFICIENT"));
        double disjointCoeff = Double.parseDouble(config.configElement("DISJOINT.COEFFICIENT"));
        double weightCoeff = Double.parseDouble(config.configElement("WEIGHT.COEFFICIENT"));
        double threshold = Double.parseDouble(config.configElement("COMPATABILITY.THRESHOLD"));
        double thresholdChange = Double.parseDouble(config.configElement("COMPATABILITY.CHANGE"));
        int inputNodes = Integer.parseInt(config.configElement("INPUT.NODES"));
        int outputNodes = Integer.parseInt(config.configElement("OUTPUT.NODES"));
        boolean naturalOrder = Boolean.valueOf(config.configElement("NATURAL.ORDER.STRATEGY"));
        int maxSpecieAge = Integer.parseInt(config.configElement("SPECIE.FITNESS.MAX"));
        int specieAgeThreshold = Integer.parseInt(config.configElement("SPECIE.AGE.THRESHOLD"));
        int specieYouthThreshold = Integer.parseInt(config.configElement("SPECIE.YOUTH.THRESHOLD"));
        double agePenalty = Double.parseDouble(config.configElement("SPECIE.OLD.PENALTY"));
        double youthBoost = Double.parseDouble(config.configElement("SPECIE.YOUTH.BOOST"));
        int specieCount = Integer.parseInt(config.configElement("SPECIE.COUNT"));
        double survialThreshold = Double.parseDouble(config.configElement("SURVIVAL.THRESHOLD"));
        boolean featureSelection = Boolean.valueOf(config.configElement("FEATURE.SELECTION"));
        int extraAlleles = Integer.parseInt(config.configElement("EXTRA.FEATURE.COUNT"));
        boolean eleEvents = Boolean.valueOf(config.configElement("ELE.EVENTS"));
        double eleSurvivalCount = Double.parseDouble(config.configElement("ELE.SURVIVAL.COUNT"));
        int eleEventTime = Integer.parseInt(config.configElement("ELE.EVENT.TIME"));
        boolean recurrencyAllowed = Boolean.valueOf(config.configElement("RECURRENCY.ALLOWED"));
        boolean keepBestEver = Boolean.valueOf(config.configElement("KEEP.BEST.EVER"));
        double terminationValue = Double.parseDouble(config.configElement("TERMINATION.VALUE"));
        double maxPerturb = Double.parseDouble(config.configElement("MAX.PERTURB"));
        double maxBiasPerturb = Double.parseDouble(config.configElement("MAX.BIAS.PERTURB"));
        NEATGADescriptor descriptor = new NEATGADescriptor();
        descriptor.setPAddLink(pAddLink);
        descriptor.setPAddNode(pAddNode);
        descriptor.setPToggleLink(pToggleLink);
        descriptor.setPMutateBias(pMutateBias);
        descriptor.setPXover(pXover);
        descriptor.setPMutation(pMutation);
        descriptor.setInputNodes(inputNodes);
        descriptor.setOutputNodes(outputNodes);
        descriptor.setNaturalOrder(naturalOrder);
        descriptor.setPopulationSize(popSize);
        descriptor.setDisjointCoeff(disjointCoeff);
        descriptor.setExcessCoeff(excessCoeff);
        descriptor.setWeightCoeff(weightCoeff);
        descriptor.setThreshold(threshold);
        descriptor.setCompatabilityChange(thresholdChange);
        descriptor.setMaxSpecieAge(maxSpecieAge);
        descriptor.setSpecieAgeThreshold(specieAgeThreshold);
        descriptor.setSpecieYouthThreshold(specieYouthThreshold);
        descriptor.setAgePenalty(agePenalty);
        descriptor.setYouthBoost(youthBoost);
        descriptor.setSpecieCount(specieCount);
        descriptor.setPWeightReplaced(pWeightReplaced);
        descriptor.setSurvivalThreshold(survialThreshold);
        descriptor.setFeatureSelection(featureSelection);
        descriptor.setExtraFeatureCount(extraAlleles);
        descriptor.setEleEvents(eleEvents);
        descriptor.setEleSurvivalCount(eleSurvivalCount);
        descriptor.setEleEventTime(eleEventTime);
        descriptor.setRecurrencyAllowed(recurrencyAllowed);
        descriptor.setKeepBestEver(keepBestEver);
        descriptor.setTerminationValue(terminationValue);
        descriptor.setMaxPerturb(maxPerturb);
        descriptor.setMaxBiasPerturb(maxBiasPerturb);
        return descriptor;
    }

    public GeneticAlgorithm createGeneticAlgorithm(GADescriptor gaDescriptor) {
        NEATGeneticAlgorithm ga = new NEATGeneticAlgorithm((NEATGADescriptor)gaDescriptor);
        return ga;
    }

    public FitnessFunction createFunction(AIConfig config) throws InvalidFitnessFunction {
        FitnessFunction function;
        block51: {
            String functionClass = config.configElement("OPERATOR.FUNCTION");
            function = null;
            NeuralNet net = null;
            NetworkDataSet dataSet = null;
            if (functionClass == null) break block51;
            try {
                Class<?> clazz;
                Class[] classArray;
                Class<?> funcClass;
                block53: {
                    block52: {
                        funcClass = Class.forName(functionClass);
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz2.isAssignableFrom(funcClass)) break block52;
                        String nnConfigFile = config.configElement("NN.CONFIG");
                        AIConfig nnConfig = new NEATLoader().loadConfig(nnConfigFile);
                        nnConfig.updateConfig("INPUT_SIZE", config.configElement("INPUT.NODES"));
                        nnConfig.updateConfig("OUTPUT_SIZE", config.configElement("OUTPUT.NODES"));
                        NEATNetManager netManager = new NEATNetManager();
                        netManager.initialise(nnConfig);
                        net = netManager.managedNet();
                        LearningEnvironment env = net.netDescriptor().learnable().learningEnvironment();
                        dataSet = (NetworkDataSet)env.learningParameter("TRAINING.SET");
                        classArray = new Class[2];
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$2 = Class.forName("org.neat4j.neat.nn.core.NeuralNet");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz3;
                        clazz = class$3;
                        if (clazz != null) break block53;
                        try {
                            clazz = class$3 = Class.forName("org.neat4j.neat.data.core.NetworkDataSet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        break block53;
                    }
                    StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new InvalidFitnessFunction(stringBuffer.append(clazz4.getName()).toString());
                }
                classArray[1] = clazz;
                Constructor<?> fConstructor = funcClass.getConstructor(classArray);
                function = (FitnessFunction)fConstructor.newInstance(net, dataSet);
            }
            catch (ClassNotFoundException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (IllegalArgumentException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (InstantiationException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (IllegalAccessException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (InvocationTargetException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (SecurityException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (NoSuchMethodException e) {
                StringBuffer stringBuffer = new StringBuffer("Invalid function class, ").append(functionClass).append(" must extend ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.ga.core.NeuralFitnessFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new InvalidFitnessFunction(stringBuffer.append(clazz.getName()).append(":").append(e.getMessage()).toString());
            }
            catch (InitialisationFailedException e) {
                e.printStackTrace();
                throw new InvalidFitnessFunction("Could not create Firness function, configuration was invalid:" + e.getMessage());
            }
        }
        throw new InvalidFitnessFunction("Function class was null");
        return function;
    }

    /*
     * WARNING - void declaration
     */
    public ParentSelector createParentSelector(AIConfig config) throws InvalidParentSelectorFunction {
        void var3_3;
        String pSelectorClass = config.configElement("OPERATOR.PSELECTOR");
        if (pSelectorClass != null) {
            try {
                ParentSelector pSelector = (ParentSelector)Class.forName(pSelectorClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidParentSelectorFunction("Invalid Parent Selector class, " + pSelectorClass + ":" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InvalidParentSelectorFunction("Invalid Parent Selector class, " + pSelectorClass + ":" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidParentSelectorFunction("Invalid Parent Selector class, " + pSelectorClass + ":" + e.getMessage());
            }
            catch (Exception e) {
                throw new InvalidParentSelectorFunction("Invalid Parent Selector class, " + pSelectorClass + ":" + e.getMessage());
            }
        } else {
            throw new InvalidParentSelectorFunction("Parent Selector class was null");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Mutator createMutator(AIConfig config) throws InvalidMutatorFunction {
        void var3_3;
        String mutatorClass = config.configElement("OPERATOR.MUTATOR");
        if (mutatorClass != null) {
            try {
                Mutator mutator = (Mutator)Class.forName(mutatorClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidMutatorFunction("Invalid Mutator class, " + mutatorClass + ":" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InvalidMutatorFunction("Invalid Mutator class, " + mutatorClass + ":" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidMutatorFunction("Invalid Mutator class, " + mutatorClass + ":" + e.getMessage());
            }
            catch (Exception e) {
                throw new InvalidMutatorFunction("Invalid Mutator class, " + mutatorClass + ":" + e.getMessage());
            }
        } else {
            throw new InvalidMutatorFunction("Mutator class was null");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CrossOver createCrossOver(AIConfig config) throws InvalidCrossoverFunction {
        void var3_3;
        String xOverClass = config.configElement("OPERATOR.XOVER");
        if (xOverClass != null) {
            try {
                CrossOver xOver = (CrossOver)Class.forName(xOverClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidCrossoverFunction("Cross Over class, " + xOverClass + ":" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InvalidCrossoverFunction("Cross Over class, " + xOverClass + ":" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCrossoverFunction("Cross Over class, " + xOverClass + ":" + e.getMessage());
            }
            catch (Exception e) {
                throw new InvalidCrossoverFunction("Cross Over class, " + xOverClass + ":" + e.getMessage());
            }
        } else {
            throw new InvalidCrossoverFunction("Cross Over class was null");
        }
        return var3_3;
    }

    public boolean save(String fileName, Chromosome genoType) {
        boolean saveOk = false;
        ObjectOutputStream s = null;
        FileOutputStream out = null;
        try {
            try {
                if (fileName != null) {
                    out = new FileOutputStream(fileName);
                }
                s = new ObjectOutputStream(out);
                s.writeObject(genoType);
                s.flush();
                saveOk = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return saveOk;
    }

    public static void main(String[] args) {
        NEATGATrainingManager gam = new NEATGATrainingManager();
        try {
            if (args.length != 1) {
                System.out.println("Usage: NEATGAManager <ga ga config file");
            } else {
                AIConfig config = new NEATLoader().loadConfig(args[0]);
                gam.initialise(config);
                gam.evolve();
            }
        }
        catch (InitialisationFailedException e) {
            e.printStackTrace();
        }
    }
}

