/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.core.distribute;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.Category;
import org.neat4j.core.AIConfig;
import org.neat4j.core.AIController;
import org.neat4j.core.InitialisationFailedException;
import org.neat4j.core.distribute.Experiment;
import org.neat4j.core.distribute.ExperimentConnection;
import org.neat4j.core.distribute.ExperimentNotRunException;
import org.neat4j.neat.applications.train.NEATGATrainingManager;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATGeneticAlgorithm;
import org.neat4j.neat.core.NEATLoader;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.FitnessFunction;
import org.neat4j.neat.ga.core.Population;

public class ExperimentServer
implements AIController {
    private static final Category cat;
    private static int handlerId;
    private Experiment[] experiments;
    private Experiment[] finishedExperiments;
    private FitnessFunction func;
    private Population pop;
    private static int expIdx;
    private static int expFinishedIdx;
    private NEATGATrainingManager tm;
    private int genNum = 1;
    private ArrayBlockingQueue expQ;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.core.distribute.ExperimentServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
        handlerId = 1;
        expIdx = 0;
        expFinishedIdx = 0;
    }

    public void createServer() {
        try {
            ServerSocket server = new ServerSocket(1969);
            while (true) {
                this.acceptHandlerRegistrations(server);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void acceptHandlerRegistrations(ServerSocket server) throws IOException {
        Socket socket = server.accept();
        ExperimentConnection eConn = new ExperimentConnection(socket, handlerId++, this);
        Thread t = new Thread(eConn);
        t.setName("Handler " + eConn.id());
        t.start();
    }

    public synchronized Experiment createExperiment() {
        Experiment exp = null;
        if (expIdx >= this.experiments.length) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            exp = (Experiment)this.expQ.take();
            if (exp != null) {
                ++expIdx;
            } else {
                cat.error((Object)"Queued Experiment was null");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return exp;
    }

    public synchronized void returnFailedExperimentToPool(Experiment e) {
        if (e != null) {
            try {
                this.expQ.put(e);
                this.notifyAll();
                cat.info((Object)("Failed experiment " + e.id() + ":" + --expIdx));
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        this.notifyAll();
    }

    public synchronized void finishedExperiment(Experiment e) throws ExperimentNotRunException {
        if (e != null) {
            this.finishedExperiments[e.id()] = e;
            if (++expFinishedIdx >= this.pop.genoTypes().length) {
                this.notifyAll();
                cat.info((Object)"Finished epoch experiments");
                this.runEvolutionCycle();
                this.createExperiments();
                expFinishedIdx = 0;
                expIdx = 0;
            }
        } else {
            cat.warn((Object)"Tried to complete experiment that was null");
        }
    }

    private void runEvolutionCycle() throws ExperimentNotRunException {
        Chromosome[] newGenoTypes = new NEATChromosome[this.pop.genoTypes().length];
        cat.info((Object)("Finished generation " + this.genNum++));
        int i = 0;
        while (i < newGenoTypes.length) {
            newGenoTypes[i] = this.finishedExperiments[i].result();
            ++i;
        }
        ((NEATGeneticAlgorithm)this.tm.ga()).runEvolutionCycle(newGenoTypes);
        this.tm.saveBest();
        this.pop = this.tm.ga().population();
    }

    private void createExperiments() {
        this.expQ.clear();
        int i = 0;
        while (i < this.experiments.length) {
            Experiment e = new Experiment(i);
            e.setupExperiment(this.pop.genoTypes()[i]);
            this.experiments[i] = e;
            try {
                this.expQ.put(e);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
    }

    public void initialise(AIConfig config) throws InitialisationFailedException {
        this.tm = new NEATGATrainingManager();
        this.tm.initialise(config);
        this.pop = this.tm.ga().population();
        this.experiments = new Experiment[this.pop.genoTypes().length];
        this.expQ = new ArrayBlockingQueue(this.experiments.length);
        this.finishedExperiments = new Experiment[this.pop.genoTypes().length];
        this.func = ((NEATGeneticAlgorithm)this.tm.ga()).gaEvaluator();
        this.createExperiments();
    }

    public FitnessFunction function() {
        return this.func;
    }

    public static void main(String[] args) {
        AIConfig config = new NEATLoader().loadConfig(args[0]);
        ExperimentServer es = new ExperimentServer();
        try {
            es.initialise(config);
            es.createServer();
        }
        catch (InitialisationFailedException e) {
            e.printStackTrace();
        }
    }
}

