/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.core.distribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import org.apache.log4j.Category;
import org.neat4j.core.AIConfig;
import org.neat4j.core.distribute.Experiment;
import org.neat4j.neat.core.NEATFitnessFunction;

public class ExperimentAgent
implements Runnable {
    private static Category cat;
    private static final int MESSAGE_MARKER = 1;
    private static final int COMMAND_REGISTER = 16;
    private static final int COMMAND_REQUEST_EXPERIMENT = 32;
    private static final int COMMAND_REQUEST_FUNCTION = 64;
    private static int PORT;
    private AIConfig experimentConfig;
    private boolean isWorking = false;
    private Experiment experiment;
    private int id;
    private OutputStream os;
    private InputStream is;
    private String serverUrl;
    private NEATFitnessFunction func;
    private static final char[] ALIVE;
    private int aliveIdx = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.core.distribute.ExperimentAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
        PORT = 1969;
        ALIVE = new char[]{'/', '-', '\\', '-'};
    }

    public ExperimentAgent(String url) throws MalformedURLException {
        this.serverUrl = url;
    }

    public void run() {
        while (true) {
            this.runAgent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAgent() {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            cat.debug((Object)"Connecting...");
            this.connectToServer();
            oos = new ObjectOutputStream(this.os);
            ois = new ObjectInputStream(this.is);
            cat.debug((Object)"Registering...");
            this.registerExperimentHandler();
            this.readRegistrationResponse();
            this.requestExperimentFunction();
            this.readFunctionResponse(ois);
            cat.info((Object)("Registered id:" + this.id));
            while (true) {
                this.requestExperiment();
                this.readExperimentResponse(ois);
                this.runExperiment();
                this.returnExperimentResult(oos);
            }
        }
        catch (Exception e) {
            try {
                ExperimentAgent experimentAgent = this;
                synchronized (experimentAgent) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            return;
        }
    }

    private void connectToServer() throws IOException {
        Socket conn = new Socket(this.serverUrl, PORT);
        this.os = conn.getOutputStream();
        this.is = conn.getInputStream();
    }

    public void setHandlerId(int id) {
        this.id = id;
    }

    public int handlerId() {
        return this.id;
    }

    private void registerExperimentHandler() throws IOException {
        this.os.write(1);
        this.os.write(16);
        this.os.write(1);
    }

    private void requestExperiment() throws IOException {
        this.os.write(1);
        this.os.write(32);
        this.os.write(1);
    }

    private void requestExperimentFunction() throws IOException {
        this.os.write(1);
        this.os.write(64);
        this.os.write(1);
    }

    private void returnExperimentResult(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.experiment);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readExperimentResponse(ObjectInputStream ois) {
        try {
            this.experiment = (Experiment)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void readFunctionResponse(ObjectInputStream ois) {
        try {
            this.func = (NEATFitnessFunction)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void readRegistrationResponse() throws IOException {
        this.is.read();
        this.id = this.is.read();
        this.is.read();
    }

    private void runExperiment() {
        System.out.print(String.valueOf(ALIVE[this.aliveIdx]) + "\r");
        this.aliveIdx = (this.aliveIdx + 1) % ALIVE.length;
        this.experiment.setupFunction(this.func);
        this.experiment.performExperiment();
        this.isWorking = false;
    }

    public boolean isAvailable() {
        return !this.isWorking;
    }
}

