/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.core.distribute;

import java.io.Serializable;
import org.neat4j.core.distribute.ExperimentNotRunException;
import org.neat4j.neat.core.NEATFitnessFunction;
import org.neat4j.neat.ga.core.Chromosome;

public class Experiment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NEATFitnessFunction fitnessFunction;
    private Chromosome genoType;
    private int id;
    private boolean hasRun = false;

    public Experiment(int id) {
        this.id = id;
    }

    public void setupFunction(NEATFitnessFunction fitnessFunction) {
        this.fitnessFunction = fitnessFunction;
    }

    public void setupExperiment(Chromosome genoType) {
        this.genoType = genoType;
    }

    public void performExperiment() {
        double eval = this.fitnessFunction.evaluate(this.genoType);
        this.genoType.updateFitness(eval);
        this.hasRun = true;
    }

    public Chromosome result() throws ExperimentNotRunException {
        if (!this.hasRun) {
            throw new ExperimentNotRunException("result() called before experiment has run");
        }
        return this.genoType;
    }

    public int id() {
        return this.id;
    }
}

