/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.lang.reflect.Array;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;

public final class LoggingMatlabProxy
extends MatlabProxy {
    private static final String CLASS_NAME = LoggingMatlabProxy.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final MatlabProxy _delegate;

    public LoggingMatlabProxy(MatlabProxy delegateProxy) {
        super(delegateProxy.getIdentifier(), delegateProxy.isExistingSession());
        this._delegate = delegateProxy;
    }

    public static void showInConsoleHandler() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINER);
        }
    }

    private void invoke(VoidThrowingInvocation invocation) throws MatlabInvocationException {
        LOGGER.entering(CLASS_NAME, invocation.name, invocation.args);
        try {
            invocation.invoke();
            LOGGER.exiting(CLASS_NAME, invocation.name);
        }
        catch (MatlabInvocationException e) {
            LOGGER.throwing(CLASS_NAME, invocation.name, e);
            LOGGER.exiting(CLASS_NAME, invocation.name);
            throw e;
        }
    }

    private void invoke(VoidInvocation invocation) {
        LOGGER.entering(CLASS_NAME, invocation.name, invocation.args);
        invocation.invoke();
        LOGGER.exiting(CLASS_NAME, invocation.name);
    }

    private <T> T invoke(ReturnThrowingInvocation<T> invocation) throws MatlabInvocationException {
        T data;
        LOGGER.entering(CLASS_NAME, invocation.name, invocation.args);
        try {
            data = invocation.invoke();
            LOGGER.exiting(CLASS_NAME, invocation.name, this.formatResult(data));
        }
        catch (MatlabInvocationException e) {
            LOGGER.throwing(CLASS_NAME, invocation.name, e);
            LOGGER.exiting(CLASS_NAME, invocation.name);
            throw e;
        }
        return data;
    }

    private <T> T invoke(ReturnInvocation<T> invocation) {
        LOGGER.entering(CLASS_NAME, invocation.name, invocation.args);
        T data = invocation.invoke();
        LOGGER.exiting(CLASS_NAME, invocation.name, this.formatResult(data));
        return data;
    }

    private boolean invoke(ReturnBooleanInvocation invocation) {
        LOGGER.entering(CLASS_NAME, invocation.name, invocation.args);
        boolean data = invocation.invoke();
        LOGGER.exiting(CLASS_NAME, invocation.name, "boolean: " + data);
        return data;
    }

    @Override
    public void eval(final String command) throws MatlabInvocationException {
        this.invoke(new VoidThrowingInvocation("eval(String)", new Object[]{command}){

            @Override
            public void invoke() throws MatlabInvocationException {
                LoggingMatlabProxy.this._delegate.eval(command);
            }
        });
    }

    @Override
    public Object[] returningEval(final String command, final int nargout) throws MatlabInvocationException {
        return this.invoke(new ReturnThrowingInvocation<Object[]>("returningEval(String, int)", new Object[]{command, nargout}){

            @Override
            public Object[] invoke() throws MatlabInvocationException {
                return LoggingMatlabProxy.this._delegate.returningEval(command, nargout);
            }
        });
    }

    @Override
    public void feval(final String functionName, Object ... args) throws MatlabInvocationException {
        this.invoke(new VoidThrowingInvocation("feval(String, Object...)", new Object[]{functionName, args}){

            @Override
            public void invoke() throws MatlabInvocationException {
                LoggingMatlabProxy.this._delegate.feval(functionName, this.args);
            }
        });
    }

    @Override
    public Object[] returningFeval(final String functionName, final int nargout, Object ... args) throws MatlabInvocationException {
        return this.invoke(new ReturnThrowingInvocation<Object[]>("returningFeval(String, int, Object...)", new Object[]{functionName, nargout, args}){

            @Override
            public Object[] invoke() throws MatlabInvocationException {
                return LoggingMatlabProxy.this._delegate.returningFeval(functionName, nargout, this.args);
            }
        });
    }

    @Override
    public void setVariable(final String variableName, final Object value) throws MatlabInvocationException {
        this.invoke(new VoidThrowingInvocation("setVariable(String, int)", new Object[]{variableName, value}){

            @Override
            public void invoke() throws MatlabInvocationException {
                LoggingMatlabProxy.this._delegate.setVariable(variableName, value);
            }
        });
    }

    @Override
    public Object getVariable(final String variableName) throws MatlabInvocationException {
        return this.invoke(new ReturnThrowingInvocation<Object>("getVariable(String)", new Object[]{variableName}){

            @Override
            public Object invoke() throws MatlabInvocationException {
                return LoggingMatlabProxy.this._delegate.getVariable(variableName);
            }
        });
    }

    public <U> U invokeAndWait(final MatlabProxy.MatlabThreadCallable<U> callable) throws MatlabInvocationException {
        return (U)this.invoke(new ReturnThrowingInvocation<U>("invokeAndWait(MatlabThreadCallable)", new Object[]{callable}){

            @Override
            public U invoke() throws MatlabInvocationException {
                return LoggingMatlabProxy.this._delegate.invokeAndWait(callable);
            }
        });
    }

    @Override
    public void addDisconnectionListener(final MatlabProxy.DisconnectionListener listener) {
        this.invoke(new VoidInvocation("addDisconnectionListener(DisconnectionListener)", new Object[]{listener}){

            @Override
            public void invoke() {
                LoggingMatlabProxy.this._delegate.addDisconnectionListener(listener);
            }
        });
    }

    @Override
    public void removeDisconnectionListener(final MatlabProxy.DisconnectionListener listener) {
        this.invoke(new VoidInvocation("removeDisconnectionListener(DisconnectionListener)", new Object[]{listener}){

            @Override
            public void invoke() {
                LoggingMatlabProxy.this._delegate.removeDisconnectionListener(listener);
            }
        });
    }

    @Override
    public boolean disconnect() {
        return this.invoke(new ReturnBooleanInvocation("disconnect()", new Object[0]){

            @Override
            public boolean invoke() {
                return LoggingMatlabProxy.this._delegate.disconnect();
            }
        });
    }

    @Override
    public boolean isExistingSession() {
        return this.invoke(new ReturnBooleanInvocation("isExistingSession()", new Object[0]){

            @Override
            public boolean invoke() {
                return LoggingMatlabProxy.this._delegate.isExistingSession();
            }
        });
    }

    @Override
    public boolean isRunningInsideMatlab() {
        return this.invoke(new ReturnBooleanInvocation("isRunningInsideMatlab()", new Object[0]){

            @Override
            public boolean invoke() {
                return LoggingMatlabProxy.this._delegate.isRunningInsideMatlab();
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.invoke(new ReturnBooleanInvocation("isConnected()", new Object[0]){

            @Override
            public boolean invoke() {
                return LoggingMatlabProxy.this._delegate.isConnected();
            }
        });
    }

    @Override
    public MatlabProxy.Identifier getIdentifier() {
        return this.invoke(new ReturnInvocation<MatlabProxy.Identifier>("getIdentifier()", new Object[0]){

            @Override
            public MatlabProxy.Identifier invoke() {
                return LoggingMatlabProxy.this._delegate.getIdentifier();
            }
        });
    }

    @Override
    public void exit() throws MatlabInvocationException {
        this.invoke(new VoidThrowingInvocation("exit()", new Object[0]){

            @Override
            public void invoke() throws MatlabInvocationException {
                LoggingMatlabProxy.this._delegate.exit();
            }
        });
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + " delegateProxy=" + this._delegate + "]";
    }

    private String formatResult(Object result) {
        String formattedResult = result == null ? "null" : (result.getClass().isArray() ? result.getClass().getName() + "\n" + LoggingMatlabProxy.formatResult(result, 0).trim() : result.getClass().getName() + ": " + result.toString());
        return formattedResult;
    }

    private static String formatResult(Object result, int level) {
        StringBuilder builder = new StringBuilder();
        String tab = "";
        for (int i = 0; i < level + 1; ++i) {
            tab = tab + "  ";
        }
        if (result == null) {
            builder.append("null\n");
        } else if (result.getClass().isArray()) {
            Class<?> componentClass = result.getClass().getComponentType();
            if (componentClass.isPrimitive()) {
                String componentName = componentClass.getCanonicalName();
                int length = Array.getLength(result);
                builder.append(componentName);
                builder.append(" array, length = ");
                builder.append(length);
                builder.append("\n");
                for (int i = 0; i < length; ++i) {
                    builder.append(tab);
                    builder.append("index ");
                    builder.append(i);
                    builder.append(", ");
                    builder.append(componentName);
                    builder.append(": ");
                    builder.append(Array.get(result, i));
                    builder.append("\n");
                }
            } else {
                Object[] array = (Object[])result;
                builder.append(array.getClass().getComponentType().getCanonicalName());
                builder.append(" array, length = ");
                builder.append(array.length);
                builder.append("\n");
                for (int i = 0; i < array.length; ++i) {
                    builder.append(tab);
                    builder.append("index ");
                    builder.append(i);
                    builder.append(", ");
                    builder.append(LoggingMatlabProxy.formatResult(array[i], level + 1));
                }
            }
        } else {
            builder.append(result.getClass().getCanonicalName());
            builder.append(": ");
            builder.append(result);
            builder.append("\n");
        }
        return builder.toString();
    }

    static {
        LOGGER.setLevel(Level.FINER);
    }

    private static abstract class ReturnBooleanInvocation
    extends Invocation {
        public ReturnBooleanInvocation(String name, Object ... args) {
            super(name, args);
        }

        public abstract boolean invoke();
    }

    private static abstract class ReturnInvocation<T>
    extends Invocation {
        public ReturnInvocation(String name, Object ... args) {
            super(name, args);
        }

        public abstract T invoke();
    }

    private static abstract class ReturnThrowingInvocation<T>
    extends Invocation {
        public ReturnThrowingInvocation(String name, Object ... args) {
            super(name, args);
        }

        public abstract T invoke() throws MatlabInvocationException;
    }

    private static abstract class VoidInvocation
    extends Invocation {
        public VoidInvocation(String name, Object ... args) {
            super(name, args);
        }

        public abstract void invoke();
    }

    private static abstract class VoidThrowingInvocation
    extends Invocation {
        public VoidThrowingInvocation(String name, Object ... args) {
            super(name, args);
        }

        public abstract void invoke() throws MatlabInvocationException;
    }

    private static abstract class Invocation {
        final String name;
        final Object[] args;

        public Invocation(String name, Object ... args) {
            this.name = name;
            this.args = args;
        }
    }
}

