/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.glu;

import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Quadric;

public class PartialDisk
extends Quadric {
    private static final int CACHE_SIZE = 240;

    public void draw(float innerRadius, float outerRadius, int slices, int loops, float startAngle, float sweepAngle) {
        float[] sinCache = new float[240];
        float[] cosCache = new float[240];
        float texLow = 0.0f;
        float texHigh = 0.0f;
        if (slices >= 240) {
            slices = 239;
        }
        if (slices < 2 || loops < 1 || outerRadius <= 0.0f || innerRadius < 0.0f || innerRadius > outerRadius) {
            System.err.println("PartialDisk: GLU_INVALID_VALUE");
            return;
        }
        if (sweepAngle < -360.0f) {
            sweepAngle = 360.0f;
        }
        if (sweepAngle > 360.0f) {
            sweepAngle = 360.0f;
        }
        if (sweepAngle < 0.0f) {
            startAngle += sweepAngle;
            sweepAngle = -sweepAngle;
        }
        int slices2 = sweepAngle == 360.0f ? slices : slices + 1;
        float deltaRadius = outerRadius - innerRadius;
        float angleOffset = startAngle / 180.0f * (float)Math.PI;
        int i = 0;
        while (i <= slices) {
            float angle = angleOffset + (float)Math.PI * sweepAngle / 180.0f * (float)i / (float)slices;
            sinCache[i] = this.sin(angle);
            cosCache[i] = this.cos(angle);
            ++i;
        }
        if (sweepAngle == 360.0f) {
            sinCache[slices] = sinCache[0];
            cosCache[slices] = cosCache[0];
        }
        switch (this.normals) {
            case 100000: 
            case 100001: {
                if (this.orientation == 100020) {
                    GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
        }
        block3 : switch (this.drawStyle) {
            case 100012: {
                float radiusLow;
                int finish;
                if (innerRadius == 0.0f) {
                    finish = loops - 1;
                    GL11.glBegin((int)6);
                    if (this.textureFlag) {
                        GL11.glTexCoord2f((float)0.5f, (float)0.5f);
                    }
                    GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                    radiusLow = outerRadius - deltaRadius * ((float)(loops - 1) / (float)loops);
                    if (this.textureFlag) {
                        texLow = radiusLow / outerRadius / 2.0f;
                    }
                    if (this.orientation == 100020) {
                        i = slices;
                        while (i >= 0) {
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                            --i;
                        }
                    } else {
                        i = 0;
                        while (i <= slices) {
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                            ++i;
                        }
                    }
                    GL11.glEnd();
                } else {
                    finish = loops;
                }
                int j = 0;
                while (j < finish) {
                    radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                    float radiusHigh = outerRadius - deltaRadius * ((float)(j + 1) / (float)loops);
                    if (this.textureFlag) {
                        texLow = radiusLow / outerRadius / 2.0f;
                        texHigh = radiusHigh / outerRadius / 2.0f;
                    }
                    GL11.glBegin((int)8);
                    i = 0;
                    while (i <= slices) {
                        if (this.orientation == 100020) {
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texHigh * sinCache[i] + 0.5f), (float)(texHigh * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusHigh * sinCache[i]), (float)(radiusHigh * cosCache[i]), (float)0.0f);
                        } else {
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texHigh * sinCache[i] + 0.5f), (float)(texHigh * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusHigh * sinCache[i]), (float)(radiusHigh * cosCache[i]), (float)0.0f);
                            if (this.textureFlag) {
                                GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                        }
                        ++i;
                    }
                    GL11.glEnd();
                    ++j;
                }
                break;
            }
            case 100010: {
                GL11.glBegin((int)0);
                i = 0;
                while (i < slices2) {
                    float sintemp = sinCache[i];
                    float costemp = cosCache[i];
                    int j = 0;
                    while (j <= loops) {
                        float radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                        if (this.textureFlag) {
                            texLow = radiusLow / outerRadius / 2.0f;
                            GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                        }
                        GL11.glVertex3f((float)(radiusLow * sintemp), (float)(radiusLow * costemp), (float)0.0f);
                        ++j;
                    }
                    ++i;
                }
                GL11.glEnd();
                break;
            }
            case 100011: {
                float radiusLow;
                if (innerRadius == outerRadius) {
                    GL11.glBegin((int)3);
                    i = 0;
                    while (i <= slices) {
                        if (this.textureFlag) {
                            GL11.glTexCoord2f((float)(sinCache[i] / 2.0f + 0.5f), (float)(cosCache[i] / 2.0f + 0.5f));
                        }
                        GL11.glVertex3f((float)(innerRadius * sinCache[i]), (float)(innerRadius * cosCache[i]), (float)0.0f);
                        ++i;
                    }
                    GL11.glEnd();
                    break;
                }
                int j = 0;
                while (j <= loops) {
                    radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                    if (this.textureFlag) {
                        texLow = radiusLow / outerRadius / 2.0f;
                    }
                    GL11.glBegin((int)3);
                    i = 0;
                    while (i <= slices) {
                        if (this.textureFlag) {
                            GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                        }
                        GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                        ++i;
                    }
                    GL11.glEnd();
                    ++j;
                }
                i = 0;
                while (i < slices2) {
                    float sintemp = sinCache[i];
                    float costemp = cosCache[i];
                    GL11.glBegin((int)3);
                    j = 0;
                    while (j <= loops) {
                        radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                        if (this.textureFlag) {
                            texLow = radiusLow / outerRadius / 2.0f;
                        }
                        if (this.textureFlag) {
                            GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                        }
                        GL11.glVertex3f((float)(radiusLow * sintemp), (float)(radiusLow * costemp), (float)0.0f);
                        ++j;
                    }
                    GL11.glEnd();
                    ++i;
                }
                break;
            }
            case 100013: {
                float radiusLow;
                int j;
                if (sweepAngle < 360.0f) {
                    i = 0;
                    while (i <= slices) {
                        float sintemp = sinCache[i];
                        float costemp = cosCache[i];
                        GL11.glBegin((int)3);
                        j = 0;
                        while (j <= loops) {
                            radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                            if (this.textureFlag) {
                                texLow = radiusLow / outerRadius / 2.0f;
                                GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                            }
                            GL11.glVertex3f((float)(radiusLow * sintemp), (float)(radiusLow * costemp), (float)0.0f);
                            ++j;
                        }
                        GL11.glEnd();
                        i += slices;
                    }
                }
                j = 0;
                while (j <= loops) {
                    radiusLow = outerRadius - deltaRadius * ((float)j / (float)loops);
                    if (this.textureFlag) {
                        texLow = radiusLow / outerRadius / 2.0f;
                    }
                    GL11.glBegin((int)3);
                    i = 0;
                    while (i <= slices) {
                        if (this.textureFlag) {
                            GL11.glTexCoord2f((float)(texLow * sinCache[i] + 0.5f), (float)(texLow * cosCache[i] + 0.5f));
                        }
                        GL11.glVertex3f((float)(radiusLow * sinCache[i]), (float)(radiusLow * cosCache[i]), (float)0.0f);
                        ++i;
                    }
                    GL11.glEnd();
                    if (innerRadius == outerRadius) break block3;
                    j += loops;
                }
                break;
            }
        }
    }
}

