/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jblas.util.ArchFlavor;
import org.jblas.util.Logger;

public class LibraryLoader {
    private Logger logger = Logger.getLogger();
    private String libpath = null;

    public void loadLibrary(String libname, boolean withFlavor) {
        String flavor = null;
        if (withFlavor) {
            this.logger.debug("Preloading ArchFlavor library.");
            flavor = ArchFlavor.archFlavor();
        }
        libname = System.mapLibraryName(libname);
        this.logger.debug("Attempting to load \"" + libname + "\".");
        String[] paths = new String[]{"/", "/bin/", this.fatJarLibraryPath("static", flavor), this.fatJarLibraryPathNonUnified("static", flavor), this.fatJarLibraryPath("dynamic", flavor), this.fatJarLibraryPathNonUnified("dynamic", flavor)};
        InputStream is = this.findLibrary(paths, libname);
        if (is == null) {
            throw new UnsatisfiedLinkError("Couldn't find the resource " + libname + ".");
        }
        this.logger.config("Loading " + libname + " from " + this.libpath + ".");
        this.loadLibraryFromStream(libname, is);
    }

    private InputStream findLibrary(String[] paths, String libname) {
        InputStream is = null;
        for (String path : paths) {
            is = this.tryPath(path + libname);
            if (is == null) continue;
            this.libpath = path;
            break;
        }
        return is;
    }

    private String unifyOSName(String osname) {
        if (osname.startsWith("Windows")) {
            return "Windows";
        }
        return osname;
    }

    private String fatJarLibraryPath(String linkage, String flavor) {
        String sep = "/";
        String os_name = this.unifyOSName(System.getProperty("os.name"));
        String os_arch = System.getProperty("os.arch");
        String path = sep + "lib" + sep + linkage + sep + os_name + sep + os_arch + sep;
        if (null != flavor) {
            path = path + flavor + sep;
        }
        return path;
    }

    private String fatJarLibraryPathNonUnified(String linkage, String flavor) {
        String sep = "/";
        String os_name = System.getProperty("os.name");
        String os_arch = System.getProperty("os.arch");
        String path = sep + "lib" + sep + linkage + sep + os_name + sep + os_arch + sep;
        if (null != flavor) {
            path = path + flavor + sep;
        }
        return path;
    }

    private InputStream tryPath(String path) {
        Logger.getLogger().debug("Trying path \"" + path + "\".");
        return this.getClass().getResourceAsStream(path);
    }

    private void loadLibraryFromStream(String libname, InputStream is) {
        try {
            int len;
            File tempfile = File.createTempFile("jblas", libname);
            tempfile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(tempfile);
            this.logger.debug("tempfile.getPath() = " + tempfile.getPath());
            long savedTime = System.currentTimeMillis();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            double seconds = (double)(System.currentTimeMillis() - savedTime) / 1000.0;
            this.logger.debug("Copying took " + seconds + " seconds.");
            ((OutputStream)os).close();
            System.load(tempfile.getPath());
        }
        catch (IOException io) {
            this.logger.error("Could not create the temp file: " + io.toString() + ".\n");
        }
        catch (UnsatisfiedLinkError ule) {
            this.logger.error("Couldn't load copied link file: " + ule.toString() + ".\n");
        }
    }
}

