(ns scraper.core
  (:import java.net.URL
           org.openqa.selenium.Platform
           [org.openqa.selenium By Capabilities Dimension Keys NoSuchElementException OutputType Point TakesScreenshot WebDriver WebElement WebDriver$Window]
           [org.openqa.selenium.remote CapabilityType DesiredCapabilities RemoteWebDriver]))

(defn get-driver
  "Get the selenium driver"
  [selenium-server brower-name driver-name]
  (let [caps (doto (DesiredCapabilities.)
               (.setCapability CapabilityType/BROWSER_NAME brower-name)
               (.setCapability CapabilityType/PLATFORM Platform/LINUX)
               (.setCapability "name" driver-name))
        wd (RemoteWebDriver. (URL. selenium-server) caps)
        session-id (str (.getSessionId wd))]
    wd))

(defn back
  "Go back to the previous page in \"browsing history\""
  [driver]
  (.back (.navigate driver)))

(defn close
  "Close this browser instance, switching to an active one if more than one is open"
  [driver]
  (.close driver))

(defn forward
  "Go forward to the next page in \"browsing history\"."
  [driver]
  (.forward (.navigate driver)))

(defn get-url
  "Navigate the driver to a given URL"
  [driver url] 
  (.get driver url))

(defn quit
  "Destroy this browser instance"
  [driver]
  (.quit driver))

(defn refresh
  "Refresh the current page"
  [driver]
  (.refresh (.navigate driver)))

(defn to
  "Navigate to a particular URL. Arg `url` can be either String or java.net.URL. Equivalent to the `get` function, provided here for com"
  [driver url] 
  (.to (.navigate driver) url))

(defn xpath
  "Get object from xpath string"
  [arg]
  (. By xpath arg))

(defn find-element
  "Find one element"
  [driver arg]
  (.findElement driver (xpath arg)))

(defn find-elements
  "Find elements"
  [driver arg]
  (.findElements driver (xpath arg)))

(defn get-attribute
  "Get attribute"
  [element value-name]
  (.getAttribute element value-name))

(defn get-text
  "Get text"
  [element]
  (.getText element))
