(ns leiningen.kap.commands.rollback
  (:require [leiningen.kap.migrations :refer [migrated-filepath
                                              migration-files
                                              previous-migrations
                                              run-migration-function]]))

(defn run [project environment args]
  (let [migrations (migration-files)
        db-spec (-> project :kapooya :db-spec)
        migrations (previous-migrations environment)
        last-migration (last migrations)]
    (if last-migration
      (do
        (run-migration-function last-migration 'down db-spec)
        (spit (migrated-filepath environment) (str (string/join "\n" (disj migrations last-migration)) "\n"))
        (println " ⬇ Applied rollback:" last-migration)))))
