(ns leiningen.kap.migrations
  (:require [clj-time.core :as time]
            [clj-time.format :as time-format]
            [clojure.java.io :as io]
            [clojure.string :as string]
            [leiningen.new.templates :refer [name-to-path]]))

(def migrations-directory "db/migrations/")

(defn migration-files []
  (->> (io/file migrations-directory) .listFiles (map str) sort (filter #(.endsWith % ".clj"))))

(defn migrated-filepath [environment]
  (str "db/migrated/" environment ".txt"))

(defn- migration-file-reader [environment]
  (let [path (migrated-filepath environment)
        file (io/file path)]
    (if-not (.exists file)
      (.createNewFile file))
    (io/reader path)))

(defn previous-migrations [environment]
  (with-open [r (migration-file-reader environment)]
    (apply sorted-set (remove string/blank? (line-seq r)))))

(defn- current-timestamp []
  (let [format (time-format/formatters :basic-date-time-no-ms)
        timestamp (time-format/unparse format (time/now))]
    (string/replace timestamp #"T|Z" "")))

(defn- name-to-path-section
  [name]
  (-> (string/replace name #"[^a-zA-Z]" " ")
      string/trim
      (string/replace #"\s+" "_")
      (string/replace #"_+" "_")))

(defn args-to-migration-filename
  [args]
  (->> (map name-to-path-section args)
       (cons (current-timestamp))
       (string/join "_" )
       name-to-path))

(defn filepath-to-name-space-string
  [filepath]
  (-> filepath (string/replace ".clj" "") (string/replace "/" ".") (string/replace "_" "-")))

(defn run-migration-function
  [path f & args]
  (load-file path)
  (let [fn-name  (str (filepath-to-name-space-string path) "/" f)
        arg-str  (string/join " " args)
        eval-str (str "(" fn-name " " arg-str ")")]
    (load-string eval-str)))
