(ns leiningen.kap.eval
  (:require [leiningen.core.eval :as lein-eval]
            [leiningen.core.project :refer [merge-profiles]]))

(defn- has-dependency? [project name]
  (->> project
       :dependencies
       (map first)
       (some #{name})
       boolean))

(defn- add-dependency [project dependency]
  (merge-profiles project [{:dependencies [dependency]}]))

(defn- add-missing-dependencies [project dependencies]
  (let [missing-dependencies (remove (comp (partial has-dependency? project) first)
                                     dependencies)]
    (reduce add-dependency project missing-dependencies)))

(defn eval-in-project [project environment function args namespace]
  (let [dependencies [['org.clojure/java.jdbc "0.3.0-alpha5"]
                      ['org.postgresql/postgresql "9.2-1003-jdbc4"]
                      ['leiningen "2.3.3"]
                      ['kapooya/kap "0.1.3"]]
        project (add-missing-dependencies project dependencies)]
    (lein-eval/eval-in-project project
                               `(~function '~project '~environment '~args)
                               `(~'require '~namespace))))
