(ns leiningen.kap.commands.migrate
  (:require [leiningen.kap.migrations :refer [migrated-filepath
                                              migration-files
                                              previous-migrations
                                              run-migration-function]]))

(defn run [project environment args]
  (let [migrations (migration-files)
        db-spec (-> project :kapooya :db-spec)]
    (doseq [filepath (remove (previous-migrations environment) migrations)]
      (run-migration-function filepath 'up db-spec)
      (spit (migrated-filepath environment) (str filepath "\n") :append true)
      (println " ⬆ Applied migration:" filepath))))
