(ns leiningen.kap.templates
  (:require [clojure.java.io :as io]
            [clojure.string :as string]
            [leiningen.new.templates :refer [slurp-resource]]
            [stencil.core :as mustache]))

(defn- slurp-template
  [name]
  (let [path (str "templates/" (string/lower-case name) ".clj")]
    (if (io/resource path)
      (slurp-resource path)
      (let [file (io/file path)]
        (if (.exists file)
          (slurp file))))))

(defn render-template
  [name params]
  (if-let [template (slurp-template name)]
    (mustache/render-string template params)))
