A Leiningen plugin to manage database migrations in Clojure projects.

Inspired by database migrations in Ruby on Rails.

## Usage

### Setup

Add **Kapooya** as a plugin to your project.clj file:

    :plugins [[kapooya/kap "0.1.2"]]


Add a :kapooya entry to your :profiles map. This can be done in your project.clj file:

    :profiles { :dev { :kapooya { :environment "development"
                                   :db-spec { :subprotocol "postgresql"
                                              :subname "//localhost/mydatabase"
                                              :user "root" }}}}

Alternatively, you can use a profiles.clj file (see profiles.clj.sample for an example).

The :kapooya key maps to another hash with two relevant entries:

`:environment` Optional, defaults to 'development'.
Multiple databases can be managed with **Kapooya**. A common use case is to have a separate testing, development and production databases.
This key identifies the name of the environment associated with the current profile.

`:db-spec` Mandatory, must be specified.
This value is passed directly to the migration functions and is meant to be used to connect to the database.
Currently, PostgreSQL is supported using java.jdbc.

### Commands

Once the plugin has been setup in the project.clj file and the dependencies have been downloaded (`lein deps`) you are ready to run the following commands:

`lein kap help` Print a short help message (default)

`lein kap init` Creates directories that are required by Kapooya (Nondestructive).

`lein kap migrate` Run the `up` method for all outstanding migrations sorted by filename (which starts with a timestamp).

`lein kap rollback` Run the `down` method for the most recent migration.

`lein kap generate custom` Creates a new migration shell ready to be completed with some custom code.

`lein kap generate create-table table-name` Creates a new migration to create a table.

`lein kap generate drop-table table-name` Creates a new migration to drop a table.

`lein kap generate add-column table-name column-name [column-type]` Creates a new migration to add a column to a table. Column type defaults to `character varying(255)`.

`lein kap generate drop-column table-name column-name [column-type]` Creates a new migration to drop a column from a table.

`lein kap generate create-index table-name column-name` Creates a new migration to create an index.

`lein kap generate drop-index table-name column-name` Creates a new migration to drop an index.


## Supported databases

PostgreSQL

## License

Copyright © 2013

Distributed under the Eclipse Public License, the same as Clojure.
