(ns rend.html5-generators
  (:require [clojure.test.check.generators :as gen]
            [com.gfredericks.test.chuck.generators :as chuck]
            [instacheck.generators :as igen]
            [rend.misc-generators :as rgen]
            [instacheck.util :as util]))

;; Generated by instacheck

(defn- html5-generators-part-0 [gmap weights]
  (let [g gmap
        w weights

        gen-attr-val-img__sizes
        (igen/freq :attr-val-img__sizes [
          [(get w [:attr-val-img__sizes :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__sizes :alt 1] 100)
            (gen/return "STUB Valid source size list")]])
        g (assoc g :attr-val-img__sizes gen-attr-val-img__sizes)

        gen-non-negative-integer
        gen/nat
        g (assoc g :non-negative-integer gen-non-negative-integer)

        gen-attr-val-textarea__maxlength
        (igen/freq :attr-val-textarea__maxlength [
          [(get w [:attr-val-textarea__maxlength :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__maxlength :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-textarea__maxlength gen-attr-val-textarea__maxlength)

        gen-length-unit
        (igen/freq :length-unit [
          [(get w [:length-unit :alt 0] 100)
            (gen/return "em")]
          [(get w [:length-unit :alt 1] 100)
            (gen/return "ex")]
          [(get w [:length-unit :alt 2] 100)
            (gen/return "ch")]
          [(get w [:length-unit :alt 3] 100)
            (gen/return "ic")]
          [(get w [:length-unit :alt 4] 100)
            (gen/return "rem")]
          [(get w [:length-unit :alt 5] 100)
            (gen/return "lh")]
          [(get w [:length-unit :alt 6] 100)
            (gen/return "rlh")]
          [(get w [:length-unit :alt 7] 100)
            (gen/return "vh")]
          [(get w [:length-unit :alt 8] 100)
            (gen/return "vw")]
          [(get w [:length-unit :alt 9] 100)
            (gen/return "vi")]
          [(get w [:length-unit :alt 10] 100)
            (gen/return "vb")]
          [(get w [:length-unit :alt 11] 100)
            (gen/return "vmin")]
          [(get w [:length-unit :alt 12] 100)
            (gen/return "vmax")]
          [(get w [:length-unit :alt 13] 100)
            (gen/return "px")]
          [(get w [:length-unit :alt 14] 100)
            (gen/return "mm")]
          [(get w [:length-unit :alt 15] 100)
            (gen/return "q")]
          [(get w [:length-unit :alt 16] 100)
            (gen/return "cm")]
          [(get w [:length-unit :alt 17] 100)
            (gen/return "in")]
          [(get w [:length-unit :alt 18] 100)
            (gen/return "pt")]
          [(get w [:length-unit :alt 19] 100)
            (gen/return "pc")]
          [(get w [:length-unit :alt 20] 100)
            (gen/return "mozmm")]])
        g (assoc g :length-unit gen-length-unit)

        gen-attr-val-canvas__height
        (igen/freq :attr-val-canvas__height [
          [(get w [:attr-val-canvas__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-canvas__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-canvas__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-canvas__height [
                [(get w [:attr-val-canvas__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-canvas__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-canvas__height gen-attr-val-canvas__height)

        gen-attr-val-img__crossorigin
        (igen/freq :attr-val-img__crossorigin [
          [(get w [:attr-val-img__crossorigin :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__crossorigin :alt 1] 100)
            (gen/return "anonymous")]
          [(get w [:attr-val-img__crossorigin :alt 2] 100)
            (gen/return "use-credentials")]])
        g (assoc g :attr-val-img__crossorigin gen-attr-val-img__crossorigin)

        gen-attribute-data
        rgen/simple-identifier
        g (assoc g :attribute-data gen-attribute-data)

        gen-attr-val-input__dirname
        (igen/freq :attr-val-input__dirname [
          [(get w [:attr-val-input__dirname :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__dirname :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__dirname gen-attr-val-input__dirname)

        gen-comment
        (gen/return "<!-- HTML comment -->")
        g (assoc g :comment gen-comment)

        gen-comment-or-space
        (igen/freq :comment-or-space [
          [(get w [:comment-or-space :alt 0] 100)
            (:comment g)]
          [(get w [:comment-or-space :alt 1] 100)
            (gen/return " ")]])
        g (assoc g :comment-or-space gen-comment-or-space)

        gen-opt-boolean
        (igen/freq :opt-boolean [
          [(get w [:opt-boolean :alt 0] 100)
            (gen/return "")]
          [(get w [:opt-boolean :alt 1] 100)
            (gen/return "=\"\"")]
          [(get w [:opt-boolean :alt 2] 100)
            (gen/return "=\"true\"")]
          [(get w [:opt-boolean :alt 3] 100)
            (gen/return "=\"false\"")]])
        g (assoc g :opt-boolean gen-opt-boolean)

        gen-attr-val-keygen__name
        (igen/freq :attr-val-keygen__name [
          [(get w [:attr-val-keygen__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-keygen__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-keygen__name gen-attr-val-keygen__name)

        gen-attr-val-global__translate
        (igen/freq :attr-val-global__translate [
          [(get w [:attr-val-global__translate :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__translate :alt 1] 100)
            (gen/return "no")]
          [(get w [:attr-val-global__translate :alt 2] 100)
            (gen/return "yes")]])
        g (assoc g :attr-val-global__translate gen-attr-val-global__translate)

        gen-name
        rgen/simple-identifier
        g (assoc g :name gen-name)

        gen-attr-val-global__accesskey
        (igen/freq :attr-val-global__accesskey [
          [(get w [:attr-val-global__accesskey :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__accesskey :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-global__accesskey [
                [(get w [:attr-val-global__accesskey :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-global__accesskey :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]
          [(get w [:attr-val-global__accesskey :alt 2] 100)
            (gen/return "STUB case-sensitive")]])
        g (assoc g :attr-val-global__accesskey gen-attr-val-global__accesskey)

        gen-attr-val-global__style
        (:css-assignments-test g)
        g (assoc g :attr-val-global__style gen-attr-val-global__style)

        gen-attr-val-global__contenteditable
        (igen/freq :attr-val-global__contenteditable [
          [(get w [:attr-val-global__contenteditable :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__contenteditable :alt 1] 100)
            (gen/return "false")]
          [(get w [:attr-val-global__contenteditable :alt 2] 100)
            (gen/return "true")]])
        g (assoc g :attr-val-global__contenteditable gen-attr-val-global__contenteditable)

        gen-attr-val-global__draggable
        (igen/freq :attr-val-global__draggable [
          [(get w [:attr-val-global__draggable :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__draggable :alt 1] 100)
            (gen/return "false")]
          [(get w [:attr-val-global__draggable :alt 2] 100)
            (gen/return "true")]])
        g (assoc g :attr-val-global__draggable gen-attr-val-global__draggable)

        gen-attr-val-global__dir
        (igen/freq :attr-val-global__dir [
          [(get w [:attr-val-global__dir :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__dir :alt 1] 100)
            (gen/return "auto")]
          [(get w [:attr-val-global__dir :alt 2] 100)
            (gen/return "ltr")]
          [(get w [:attr-val-global__dir :alt 3] 100)
            (gen/return "rtl")]])
        g (assoc g :attr-val-global__dir gen-attr-val-global__dir)

        gen-attr-val-global__id
        (igen/freq :attr-val-global__id [
          [(get w [:attr-val-global__id :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__id :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-global__id gen-attr-val-global__id)

        gen-integer
        gen/int
        g (assoc g :integer gen-integer)

        gen-attr-val-global__spellcheck
        (igen/freq :attr-val-global__spellcheck [
          [(get w [:attr-val-global__spellcheck :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__spellcheck :alt 1] 100)
            (gen/return "false")]
          [(get w [:attr-val-global__spellcheck :alt 2] 100)
            (gen/return "true")]])
        g (assoc g :attr-val-global__spellcheck gen-attr-val-global__spellcheck)

        gen-lang
        (chuck/string-from-regex #"[a-z]+(?:-[A-Za-z]+)?")
        g (assoc g :lang gen-lang)

        gen-attr-val-global__title
        (igen/freq :attr-val-global__title [
          [(get w [:attr-val-global__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-global__title gen-attr-val-global__title)

        gen-role-attribute
        (gen/return "")
        g (assoc g :role-attribute gen-role-attribute)

        gen-attr-val-global__lang
        (igen/freq :attr-val-global__lang [
          [(get w [:attr-val-global__lang :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__lang :alt 1] 100)
            (:lang g)]])
        g (assoc g :attr-val-global__lang gen-attr-val-global__lang)

        gen-attr-val-global__dropzone
        (igen/freq :attr-val-global__dropzone [
          [(get w [:attr-val-global__dropzone :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__dropzone :alt 1] 100)
            (:attribute-data g)]
          [(get w [:attr-val-global__dropzone :alt 2] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-global__dropzone [
                [(get w [:attr-val-global__dropzone :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-global__dropzone :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-global__dropzone gen-attr-val-global__dropzone)

        gen-event-attribute
        (gen/return "")
        g (assoc g :event-attribute gen-event-attribute)

        gen-attr-val-global__class
        (igen/freq :attr-val-global__class [
          [(get w [:attr-val-global__class :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__class :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-global__class [
                [(get w [:attr-val-global__class :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-global__class :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-global__class gen-attr-val-global__class)

        gen-aria-attribute
        (gen/return "")
        g (assoc g :aria-attribute gen-aria-attribute)

        gen-attr-val-global__tabindex
        (igen/freq :attr-val-global__tabindex [
          [(get w [:attr-val-global__tabindex :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__tabindex :alt 1] 100)
            (:integer g)]])
        g (assoc g :attr-val-global__tabindex gen-attr-val-global__tabindex)

        gen-custom-data-attribute
        (gen/return "")
        g (assoc g :custom-data-attribute gen-custom-data-attribute)

        gen-attr-val-global__contextmenu
        (igen/freq :attr-val-global__contextmenu [
          [(get w [:attr-val-global__contextmenu :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-global__contextmenu :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-global__contextmenu gen-attr-val-global__contextmenu)

        gen-global-attribute
        (igen/freq :global-attribute [
          [(get w [:global-attribute :alt 0] 100)
            (gen/tuple
              (gen/return "hidden")
              (:opt-boolean g))]
          [(get w [:global-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "accesskey=\"")
              (:attr-val-global__accesskey g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "class=\"")
              (:attr-val-global__class g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "contenteditable=\"")
              (:attr-val-global__contenteditable g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "contextmenu=\"")
              (:attr-val-global__contextmenu g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "dir=\"")
              (:attr-val-global__dir g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "draggable=\"")
              (:attr-val-global__draggable g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "dropzone=\"")
              (:attr-val-global__dropzone g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "id=\"")
              (:attr-val-global__id g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "lang=\"")
              (:attr-val-global__lang g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 10] 100)
            (gen/tuple
              (gen/return "spellcheck=\"")
              (:attr-val-global__spellcheck g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 11] 100)
            (gen/tuple
              (gen/return "style=\"")
              (:attr-val-global__style g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 12] 100)
            (gen/tuple
              (gen/return "tabindex=\"")
              (:attr-val-global__tabindex g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 13] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-global__title g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 14] 100)
            (gen/tuple
              (gen/return "translate=\"")
              (:attr-val-global__translate g)
              (gen/return "\""))]
          [(get w [:global-attribute :alt 15] 100)
            (:custom-data-attribute g)]
          [(get w [:global-attribute :alt 16] 100)
            (:aria-attribute g)]
          [(get w [:global-attribute :alt 17] 100)
            (:role-attribute g)]
          [(get w [:global-attribute :alt 18] 100)
            (:event-attribute g)]])
        g (assoc g :global-attribute gen-global-attribute)

        gen-var-attribute
        (:global-attribute g)
        g (assoc g :var-attribute gen-var-attribute)

        gen-mime-type
        (chuck/string-from-regex #"[a-z]+/[a-z0-9+-]+")
        g (assoc g :mime-type gen-mime-type)

        gen-url-test
        (igen/freq :url-test [
          [(get w [:url-test :alt 0] 100)
            (chuck/string-from-regex #"(?:https:|http:)?//[A-Za-z0-9._\-/&#=?,]*[A-Za-z0-9._\-/&#=?]")]
          [(get w [:url-test :alt 1] 100)
            (chuck/string-from-regex #"[A-Za-z0-9._\-/&#=?,]*[A-Za-z0-9._\-/&#=?]")]
          [(get w [:url-test :alt 2] 100)
            (gen/tuple
              (gen/return "data:")
              (:mime-type g)
              (gen/return ";base64,")
              (chuck/string-from-regex #"[A-Za-z0-9+=/]+"))]])
        g (assoc g :url-test gen-url-test)

        gen-url
        (:url-test g)
        g (assoc g :url gen-url)

        gen-attr-val-track__src
        (igen/freq :attr-val-track__src [
          [(get w [:attr-val-track__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-track__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-track__src gen-attr-val-track__src)

        gen-attr-val-img__height
        (igen/freq :attr-val-img__height [
          [(get w [:attr-val-img__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-img__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-img__height [
                [(get w [:attr-val-img__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-img__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-img__height gen-attr-val-img__height)

        gen-attr-val-input__placeholder
        (igen/freq :attr-val-input__placeholder [
          [(get w [:attr-val-input__placeholder :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__placeholder :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__placeholder gen-attr-val-input__placeholder)

        gen-rp-attribute
        (:global-attribute g)
        g (assoc g :rp-attribute gen-rp-attribute)

        gen-noscript-attribute
        (:global-attribute g)
        g (assoc g :noscript-attribute gen-noscript-attribute)

        gen-attr-val-track__srclang
        (igen/freq :attr-val-track__srclang [
          [(get w [:attr-val-track__srclang :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-track__srclang :alt 1] 100)
            (:lang g)]])
        g (assoc g :attr-val-track__srclang gen-attr-val-track__srclang)

        gen-attr-val-track__kind
        (igen/freq :attr-val-track__kind [
          [(get w [:attr-val-track__kind :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-track__kind :alt 1] 100)
            (gen/return "captions")]
          [(get w [:attr-val-track__kind :alt 2] 100)
            (gen/return "chapters")]
          [(get w [:attr-val-track__kind :alt 3] 100)
            (gen/return "descriptions")]
          [(get w [:attr-val-track__kind :alt 4] 100)
            (gen/return "metadata")]
          [(get w [:attr-val-track__kind :alt 5] 100)
            (gen/return "subtitles")]])
        g (assoc g :attr-val-track__kind gen-attr-val-track__kind)

        gen-attr-val-track__label
        (igen/freq :attr-val-track__label [
          [(get w [:attr-val-track__label :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-track__label :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-track__label gen-attr-val-track__label)

        gen-track-attribute
        (igen/freq :track-attribute [
          [(get w [:track-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:track-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "default")
              (:opt-boolean g))]
          [(get w [:track-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "kind=\"")
              (:attr-val-track__kind g)
              (gen/return "\""))]
          [(get w [:track-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "label=\"")
              (:attr-val-track__label g)
              (gen/return "\""))]
          [(get w [:track-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-track__src g)
              (gen/return "\""))]
          [(get w [:track-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "srclang=\"")
              (:attr-val-track__srclang g)
              (gen/return "\""))]])
        g (assoc g :track-attribute gen-track-attribute)

        gen-section-attribute
        (:global-attribute g)
        g (assoc g :section-attribute gen-section-attribute)

        gen-attr-val-base__target
        (igen/freq :attr-val-base__target [
          [(get w [:attr-val-base__target :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-base__target :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-base__target gen-attr-val-base__target)

        gen-pre-attribute
        (:global-attribute g)
        g (assoc g :pre-attribute gen-pre-attribute)]
    g))

(defn- html5-generators-part-1 [gmap weights]
  (let [g gmap
        w weights

        gen-attr-val-input__src
        (igen/freq :attr-val-input__src [
          [(get w [:attr-val-input__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-input__src gen-attr-val-input__src)

        gen-doctype
        (gen/return "<!DOCTYPE html> ")
        g (assoc g :doctype gen-doctype)

        gen-h3-attribute
        (:global-attribute g)
        g (assoc g :h3-attribute gen-h3-attribute)

        gen-attr-val-object__name
        (igen/freq :attr-val-object__name [
          [(get w [:attr-val-object__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__name :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-object__name gen-attr-val-object__name)

        gen-thead-attribute
        (:global-attribute g)
        g (assoc g :thead-attribute gen-thead-attribute)

        gen-attr-val-button__formmethod
        (igen/freq :attr-val-button__formmethod [
          [(get w [:attr-val-button__formmethod :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__formmethod :alt 1] 100)
            (gen/return "GET")]
          [(get w [:attr-val-button__formmethod :alt 2] 100)
            (gen/return "POST")]])
        g (assoc g :attr-val-button__formmethod gen-attr-val-button__formmethod)

        gen-h5-attribute
        (:global-attribute g)
        g (assoc g :h5-attribute gen-h5-attribute)

        gen-attr-val-embed__src
        (igen/freq :attr-val-embed__src [
          [(get w [:attr-val-embed__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-embed__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-embed__src gen-attr-val-embed__src)

        gen-attr-val-embed__height
        (igen/freq :attr-val-embed__height [
          [(get w [:attr-val-embed__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-embed__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-embed__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-embed__height [
                [(get w [:attr-val-embed__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-embed__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-embed__height gen-attr-val-embed__height)

        gen-attr-val-embed__width
        (igen/freq :attr-val-embed__width [
          [(get w [:attr-val-embed__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-embed__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-embed__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-embed__width [
                [(get w [:attr-val-embed__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-embed__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-embed__width gen-attr-val-embed__width)

        gen-attr-val-embed__type
        (igen/freq :attr-val-embed__type [
          [(get w [:attr-val-embed__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-embed__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-embed__type gen-attr-val-embed__type)

        gen-embed-attribute
        (igen/freq :embed-attribute [
          [(get w [:embed-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:embed-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-embed__height g)
              (gen/return "\""))]
          [(get w [:embed-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-embed__src g)
              (gen/return "\""))]
          [(get w [:embed-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-embed__type g)
              (gen/return "\""))]
          [(get w [:embed-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-embed__width g)
              (gen/return "\""))]])
        g (assoc g :embed-attribute gen-embed-attribute)

        gen-p-attribute
        (:global-attribute g)
        g (assoc g :p-attribute gen-p-attribute)

        gen-attr-val-li__value
        (igen/freq :attr-val-li__value [
          [(get w [:attr-val-li__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-li__value :alt 1] 100)
            (:integer g)]])
        g (assoc g :attr-val-li__value gen-attr-val-li__value)

        gen-attr-val-map__name
        (igen/freq :attr-val-map__name [
          [(get w [:attr-val-map__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-map__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-map__name gen-attr-val-map__name)

        gen-map-attribute
        (igen/freq :map-attribute [
          [(get w [:map-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:map-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-map__name g)
              (gen/return "\""))]])
        g (assoc g :map-attribute gen-map-attribute)

        gen-attr-val-label__form
        (igen/freq :attr-val-label__form [
          [(get w [:attr-val-label__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-label__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-label__form gen-attr-val-label__form)

        gen-attr-val-time__datetime
        (igen/freq :attr-val-time__datetime [
          [(get w [:attr-val-time__datetime :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-time__datetime :alt 1] 100)
            (gen/return "STUB Valid month string")]
          [(get w [:attr-val-time__datetime :alt 2] 100)
            (gen/return "STUB valid date string")]
          [(get w [:attr-val-time__datetime :alt 3] 100)
            (gen/return "STUB valid duration string")]
          [(get w [:attr-val-time__datetime :alt 4] 100)
            (gen/return "STUB valid floating date and time string")]
          [(get w [:attr-val-time__datetime :alt 5] 100)
            (gen/return "STUB valid global date and time string")]
          [(get w [:attr-val-time__datetime :alt 6] 100)
            (gen/return "STUB valid non-negative integer")]
          [(get w [:attr-val-time__datetime :alt 7] 100)
            (gen/return "STUB valid time string")]
          [(get w [:attr-val-time__datetime :alt 8] 100)
            (gen/return "STUB valid time-zone offset string")]
          [(get w [:attr-val-time__datetime :alt 9] 100)
            (gen/return "STUB valid week string")]
          [(get w [:attr-val-time__datetime :alt 10] 100)
            (gen/return "STUB valid yearless date string")]])
        g (assoc g :attr-val-time__datetime gen-attr-val-time__datetime)

        gen-strong-attribute
        (:global-attribute g)
        g (assoc g :strong-attribute gen-strong-attribute)

        gen-small-attribute
        (:global-attribute g)
        g (assoc g :small-attribute gen-small-attribute)

        gen-attr-val-source__sizes
        (igen/freq :attr-val-source__sizes [
          [(get w [:attr-val-source__sizes :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-source__sizes :alt 1] 100)
            (gen/return "STUB Valid source size list")]])
        g (assoc g :attr-val-source__sizes gen-attr-val-source__sizes)

        gen-attr-val-input__form
        (igen/freq :attr-val-input__form [
          [(get w [:attr-val-input__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-input__form gen-attr-val-input__form)

        gen-wbr-attribute
        (:global-attribute g)
        g (assoc g :wbr-attribute gen-wbr-attribute)

        gen-attr-val-ol__start
        (igen/freq :attr-val-ol__start [
          [(get w [:attr-val-ol__start :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-ol__start :alt 1] 100)
            (:integer g)]])
        g (assoc g :attr-val-ol__start gen-attr-val-ol__start)

        gen-attr-val-output__for
        (igen/freq :attr-val-output__for [
          [(get w [:attr-val-output__for :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-output__for :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-output__for [
                [(get w [:attr-val-output__for :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-output__for :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]
          [(get w [:attr-val-output__for :alt 2] 100)
            (gen/return "STUB case-sensitive")]])
        g (assoc g :attr-val-output__for gen-attr-val-output__for)

        gen-attr-val-input__maxlength
        (igen/freq :attr-val-input__maxlength [
          [(get w [:attr-val-input__maxlength :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__maxlength :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-input__maxlength gen-attr-val-input__maxlength)

        gen-time-attribute
        (igen/freq :time-attribute [
          [(get w [:time-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:time-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "datetime=\"")
              (:attr-val-time__datetime g)
              (gen/return "\""))]])
        g (assoc g :time-attribute gen-time-attribute)

        gen-h6-attribute
        (:global-attribute g)
        g (assoc g :h6-attribute gen-h6-attribute)

        gen-attr-val-input__width
        (igen/freq :attr-val-input__width [
          [(get w [:attr-val-input__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-input__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-input__width [
                [(get w [:attr-val-input__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-input__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-input__width gen-attr-val-input__width)

        gen-attr-val-video__height
        (igen/freq :attr-val-video__height [
          [(get w [:attr-val-video__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-video__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-video__height [
                [(get w [:attr-val-video__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-video__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-video__height gen-attr-val-video__height)

        gen-attr-val-ins__datetime
        (igen/freq :attr-val-ins__datetime [
          [(get w [:attr-val-ins__datetime :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-ins__datetime :alt 1] 100)
            (gen/return "STUB Valid date string with optional time")]])
        g (assoc g :attr-val-ins__datetime gen-attr-val-ins__datetime)

        gen-attr-val-button__formtarget
        (igen/freq :attr-val-button__formtarget [
          [(get w [:attr-val-button__formtarget :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__formtarget :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-button__formtarget gen-attr-val-button__formtarget)

        gen-attr-val-button__form
        (igen/freq :attr-val-button__form [
          [(get w [:attr-val-button__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-button__form gen-attr-val-button__form)

        gen-attr-val-button__name
        (igen/freq :attr-val-button__name [
          [(get w [:attr-val-button__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-button__name gen-attr-val-button__name)

        gen-attr-val-button__formaction
        (igen/freq :attr-val-button__formaction [
          [(get w [:attr-val-button__formaction :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__formaction :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-button__formaction gen-attr-val-button__formaction)

        gen-attr-val-button__value
        (igen/freq :attr-val-button__value [
          [(get w [:attr-val-button__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__value :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-button__value gen-attr-val-button__value)

        gen-attr-val-button__type
        (igen/freq :attr-val-button__type [
          [(get w [:attr-val-button__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__type :alt 1] 100)
            (gen/return "button")]
          [(get w [:attr-val-button__type :alt 2] 100)
            (gen/return "menu")]
          [(get w [:attr-val-button__type :alt 3] 100)
            (gen/return "reset")]
          [(get w [:attr-val-button__type :alt 4] 100)
            (gen/return "submit")]])
        g (assoc g :attr-val-button__type gen-attr-val-button__type)

        gen-attr-val-button__formenctype
        (igen/freq :attr-val-button__formenctype [
          [(get w [:attr-val-button__formenctype :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__formenctype :alt 1] 100)
            (gen/return "application/x-www-form-urlencoded")]
          [(get w [:attr-val-button__formenctype :alt 2] 100)
            (gen/return "multipart/form-data")]
          [(get w [:attr-val-button__formenctype :alt 3] 100)
            (gen/return "text/plain")]])
        g (assoc g :attr-val-button__formenctype gen-attr-val-button__formenctype)

        gen-attr-val-button__menu
        (igen/freq :attr-val-button__menu [
          [(get w [:attr-val-button__menu :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-button__menu :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-button__menu gen-attr-val-button__menu)

        gen-button-attribute
        (igen/freq :button-attribute [
          [(get w [:button-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:button-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autofocus")
              (:opt-boolean g))]
          [(get w [:button-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:button-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "formnovalidate")
              (:opt-boolean g))]
          [(get w [:button-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-button__form g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "formaction=\"")
              (:attr-val-button__formaction g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "formenctype=\"")
              (:attr-val-button__formenctype g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "formmethod=\"")
              (:attr-val-button__formmethod g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "formtarget=\"")
              (:attr-val-button__formtarget g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "menu=\"")
              (:attr-val-button__menu g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 10] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-button__name g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 11] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-button__type g)
              (gen/return "\""))]
          [(get w [:button-attribute :alt 12] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-button__value g)
              (gen/return "\""))]])
        g (assoc g :button-attribute gen-button-attribute)

        gen-attr-val-meta__name
        (igen/freq :attr-val-meta__name [
          [(get w [:attr-val-meta__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meta__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-meta__name gen-attr-val-meta__name)

        gen-attr-val-object__data
        (igen/freq :attr-val-object__data [
          [(get w [:attr-val-object__data :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__data :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-object__data gen-attr-val-object__data)

        gen-samp-attribute
        (:global-attribute g)
        g (assoc g :samp-attribute gen-samp-attribute)

        gen-attr-val-video__width
        (igen/freq :attr-val-video__width [
          [(get w [:attr-val-video__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-video__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-video__width [
                [(get w [:attr-val-video__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-video__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-video__width gen-attr-val-video__width)

        gen-attr-val-img__src
        rgen/image-path
        g (assoc g :attr-val-img__src gen-attr-val-img__src)

        gen-attr-val-textarea__form
        (igen/freq :attr-val-textarea__form [
          [(get w [:attr-val-textarea__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-textarea__form gen-attr-val-textarea__form)

        gen-attr-val-textarea__name
        (igen/freq :attr-val-textarea__name [
          [(get w [:attr-val-textarea__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-textarea__name gen-attr-val-textarea__name)

        gen-h1-attribute
        (:global-attribute g)
        g (assoc g :h1-attribute gen-h1-attribute)

        gen-attr-val-textarea__dirname
        (igen/freq :attr-val-textarea__dirname [
          [(get w [:attr-val-textarea__dirname :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__dirname :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-textarea__dirname gen-attr-val-textarea__dirname)

        gen-h4-attribute
        (:global-attribute g)
        g (assoc g :h4-attribute gen-h4-attribute)]
    g))

(defn- html5-generators-part-2 [gmap weights]
  (let [g gmap
        w weights

        gen-attr-val-dfn__title
        (igen/freq :attr-val-dfn__title [
          [(get w [:attr-val-dfn__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-dfn__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-dfn__title gen-attr-val-dfn__title)

        gen-dfn-attribute
        (igen/freq :dfn-attribute [
          [(get w [:dfn-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:dfn-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-dfn__title g)
              (gen/return "\""))]])
        g (assoc g :dfn-attribute gen-dfn-attribute)

        gen-attr-val-table__border
        (igen/freq :attr-val-table__border [
          [(get w [:attr-val-table__border :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-table__border :alt 1] 100)
            (gen/return "1")]])
        g (assoc g :attr-val-table__border gen-attr-val-table__border)

        gen-floating-point-number
        rgen/floating-point-number
        g (assoc g :floating-point-number gen-floating-point-number)

        gen-attr-val-meter__value
        (igen/freq :attr-val-meter__value [
          [(get w [:attr-val-meter__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__value :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__value gen-attr-val-meter__value)

        gen-attr-val-colgroup__span
        (igen/freq :attr-val-colgroup__span [
          [(get w [:attr-val-colgroup__span :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-colgroup__span :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-colgroup__span gen-attr-val-colgroup__span)

        gen-attr-val-form__target
        (igen/freq :attr-val-form__target [
          [(get w [:attr-val-form__target :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__target :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-form__target gen-attr-val-form__target)

        gen-attr-val-fieldset__name
        (igen/freq :attr-val-fieldset__name [
          [(get w [:attr-val-fieldset__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-fieldset__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-fieldset__name gen-attr-val-fieldset__name)

        gen-attr-val-iframe__src
        (igen/freq :attr-val-iframe__src [
          [(get w [:attr-val-iframe__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-iframe__src gen-attr-val-iframe__src)

        gen-attr-val-iframe__name
        (igen/freq :attr-val-iframe__name [
          [(get w [:attr-val-iframe__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__name :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-iframe__name gen-attr-val-iframe__name)

        gen-attr-val-iframe__width
        (igen/freq :attr-val-iframe__width [
          [(get w [:attr-val-iframe__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-iframe__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-iframe__width [
                [(get w [:attr-val-iframe__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-iframe__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-iframe__width gen-attr-val-iframe__width)

        gen-attr-val-iframe__sandbox
        (igen/freq :attr-val-iframe__sandbox [
          [(get w [:attr-val-iframe__sandbox :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__sandbox :alt 1] 100)
            (gen/return "allow-forms")]
          [(get w [:attr-val-iframe__sandbox :alt 2] 100)
            (gen/return "allow-pointer-lock")]
          [(get w [:attr-val-iframe__sandbox :alt 3] 100)
            (gen/return "allow-popups")]
          [(get w [:attr-val-iframe__sandbox :alt 4] 100)
            (gen/return "allow-same-origin")]
          [(get w [:attr-val-iframe__sandbox :alt 5] 100)
            (gen/return "allow-scripts")]
          [(get w [:attr-val-iframe__sandbox :alt 6] 100)
            (gen/return "allow-top-navigation")]
          [(get w [:attr-val-iframe__sandbox :alt 7] 100)
            (:attribute-data g)]
          [(get w [:attr-val-iframe__sandbox :alt 8] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-iframe__sandbox [
                [(get w [:attr-val-iframe__sandbox :alt 8 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-iframe__sandbox :alt 8 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-iframe__sandbox gen-attr-val-iframe__sandbox)

        gen-attr-val-iframe__srcdoc
        (igen/freq :attr-val-iframe__srcdoc [
          [(get w [:attr-val-iframe__srcdoc :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__srcdoc :alt 1] 100)
            (gen/return "iframe")]
          [(get w [:attr-val-iframe__srcdoc :alt 2] 100)
            (gen/return "srcdoc")]])
        g (assoc g :attr-val-iframe__srcdoc gen-attr-val-iframe__srcdoc)

        gen-attr-val-iframe__height
        (igen/freq :attr-val-iframe__height [
          [(get w [:attr-val-iframe__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-iframe__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-iframe__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-iframe__height [
                [(get w [:attr-val-iframe__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-iframe__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-iframe__height gen-attr-val-iframe__height)

        gen-iframe-attribute
        (igen/freq :iframe-attribute [
          [(get w [:iframe-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:iframe-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "allowfullscreen")
              (:opt-boolean g))]
          [(get w [:iframe-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-iframe__height g)
              (gen/return "\""))]
          [(get w [:iframe-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-iframe__name g)
              (gen/return "\""))]
          [(get w [:iframe-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "sandbox=\"")
              (:attr-val-iframe__sandbox g)
              (gen/return "\""))]
          [(get w [:iframe-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-iframe__src g)
              (gen/return "\""))]
          [(get w [:iframe-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "srcdoc=\"")
              (:attr-val-iframe__srcdoc g)
              (gen/return "\""))]
          [(get w [:iframe-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-iframe__width g)
              (gen/return "\""))]])
        g (assoc g :iframe-attribute gen-iframe-attribute)

        gen-attr-val-meter__min
        (igen/freq :attr-val-meter__min [
          [(get w [:attr-val-meter__min :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__min :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__min gen-attr-val-meter__min)

        gen-attr-val-area__rel
        (igen/freq :attr-val-area__rel [
          [(get w [:attr-val-area__rel :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__rel :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-area__rel [
                [(get w [:attr-val-area__rel :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-area__rel :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-area__rel gen-attr-val-area__rel)

        gen-attr-val-area__href
        (igen/freq :attr-val-area__href [
          [(get w [:attr-val-area__href :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__href :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-area__href gen-attr-val-area__href)

        gen-attr-val-area__alt
        (igen/freq :attr-val-area__alt [
          [(get w [:attr-val-area__alt :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__alt :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-area__alt gen-attr-val-area__alt)

        gen-attr-val-area__target
        (igen/freq :attr-val-area__target [
          [(get w [:attr-val-area__target :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__target :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-area__target gen-attr-val-area__target)

        gen-attr-val-area__coords
        (igen/freq :attr-val-area__coords [
          [(get w [:attr-val-area__coords :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__coords :alt 1] 100)
            (gen/return "STUB Valid list of floating-point numbers")]])
        g (assoc g :attr-val-area__coords gen-attr-val-area__coords)

        gen-attr-val-area__type
        (igen/freq :attr-val-area__type [
          [(get w [:attr-val-area__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-area__type gen-attr-val-area__type)

        gen-attr-val-area__shape
        (igen/freq :attr-val-area__shape [
          [(get w [:attr-val-area__shape :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__shape :alt 1] 100)
            (gen/return "circle")]
          [(get w [:attr-val-area__shape :alt 2] 100)
            (gen/return "default")]
          [(get w [:attr-val-area__shape :alt 3] 100)
            (gen/return "poly")]
          [(get w [:attr-val-area__shape :alt 4] 100)
            (gen/return "rect")]])
        g (assoc g :attr-val-area__shape gen-attr-val-area__shape)

        gen-attr-val-area__download
        (gen/return "")
        g (assoc g :attr-val-area__download gen-attr-val-area__download)

        gen-attr-val-area__hreflang
        (igen/freq :attr-val-area__hreflang [
          [(get w [:attr-val-area__hreflang :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-area__hreflang :alt 1] 100)
            (:lang g)]])
        g (assoc g :attr-val-area__hreflang gen-attr-val-area__hreflang)

        gen-area-attribute
        (igen/freq :area-attribute [
          [(get w [:area-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:area-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "alt=\"")
              (:attr-val-area__alt g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "coords=\"")
              (:attr-val-area__coords g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "download=\"")
              (:attr-val-area__download g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "href=\"")
              (:attr-val-area__href g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "hreflang=\"")
              (:attr-val-area__hreflang g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "rel=\"")
              (:attr-val-area__rel g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "shape=\"")
              (:attr-val-area__shape g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "target=\"")
              (:attr-val-area__target g)
              (gen/return "\""))]
          [(get w [:area-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-area__type g)
              (gen/return "\""))]])
        g (assoc g :area-attribute gen-area-attribute)

        gen-tbody-attribute
        (:global-attribute g)
        g (assoc g :tbody-attribute gen-tbody-attribute)

        gen-dt-attribute
        (:global-attribute g)
        g (assoc g :dt-attribute gen-dt-attribute)

        gen-attr-val-select__size
        (igen/freq :attr-val-select__size [
          [(get w [:attr-val-select__size :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-select__size :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-select__size gen-attr-val-select__size)

        gen-summary-attribute
        (:global-attribute g)
        g (assoc g :summary-attribute gen-summary-attribute)

        gen-attr-val-video__preload
        (igen/freq :attr-val-video__preload [
          [(get w [:attr-val-video__preload :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__preload :alt 1] 100)
            (gen/return "auto")]
          [(get w [:attr-val-video__preload :alt 2] 100)
            (gen/return "metadata")]
          [(get w [:attr-val-video__preload :alt 3] 100)
            (gen/return "none")]])
        g (assoc g :attr-val-video__preload gen-attr-val-video__preload)

        gen-attr-val-output__name
        (igen/freq :attr-val-output__name [
          [(get w [:attr-val-output__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-output__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-output__name gen-attr-val-output__name)

        gen-attr-val-output__form
        (igen/freq :attr-val-output__form [
          [(get w [:attr-val-output__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-output__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-output__form gen-attr-val-output__form)

        gen-output-attribute
        (igen/freq :output-attribute [
          [(get w [:output-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:output-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "for=\"")
              (:attr-val-output__for g)
              (gen/return "\""))]
          [(get w [:output-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-output__form g)
              (gen/return "\""))]
          [(get w [:output-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-output__name g)
              (gen/return "\""))]])
        g (assoc g :output-attribute gen-output-attribute)

        gen-attr-val-ol__type
        (igen/freq :attr-val-ol__type [
          [(get w [:attr-val-ol__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-ol__type :alt 1] 100)
            (gen/return "1")]
          [(get w [:attr-val-ol__type :alt 2] 100)
            (gen/return "A")]
          [(get w [:attr-val-ol__type :alt 3] 100)
            (gen/return "I")]
          [(get w [:attr-val-ol__type :alt 4] 100)
            (gen/return "a")]
          [(get w [:attr-val-ol__type :alt 5] 100)
            (gen/return "i")]])
        g (assoc g :attr-val-ol__type gen-attr-val-ol__type)

        gen-attr-val-a__type
        (igen/freq :attr-val-a__type [
          [(get w [:attr-val-a__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-a__type gen-attr-val-a__type)

        gen-attr-val-a__target
        (igen/freq :attr-val-a__target [
          [(get w [:attr-val-a__target :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__target :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-a__target gen-attr-val-a__target)

        gen-attr-val-meter__max
        (igen/freq :attr-val-meter__max [
          [(get w [:attr-val-meter__max :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__max :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__max gen-attr-val-meter__max)

        gen-attr-val-option__value
        (igen/freq :attr-val-option__value [
          [(get w [:attr-val-option__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-option__value :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-option__value gen-attr-val-option__value)

        gen-attr-val-blockquote__cite
        (igen/freq :attr-val-blockquote__cite [
          [(get w [:attr-val-blockquote__cite :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-blockquote__cite :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-blockquote__cite gen-attr-val-blockquote__cite)

        gen-colgroup-attribute
        (igen/freq :colgroup-attribute [
          [(get w [:colgroup-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:colgroup-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "span=\"")
              (:attr-val-colgroup__span g)
              (gen/return "\""))]])
        g (assoc g :colgroup-attribute gen-colgroup-attribute)

        gen-figure-attribute
        (:global-attribute g)
        g (assoc g :figure-attribute gen-figure-attribute)

        gen-attr-val-td__rowspan
        (igen/freq :attr-val-td__rowspan [
          [(get w [:attr-val-td__rowspan :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-td__rowspan :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-td__rowspan gen-attr-val-td__rowspan)

        gen-attr-val-textarea__wrap
        (igen/freq :attr-val-textarea__wrap [
          [(get w [:attr-val-textarea__wrap :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__wrap :alt 1] 100)
            (gen/return "hard")]
          [(get w [:attr-val-textarea__wrap :alt 2] 100)
            (gen/return "soft")]])
        g (assoc g :attr-val-textarea__wrap gen-attr-val-textarea__wrap)

        gen-i-attribute
        (:global-attribute g)
        g (assoc g :i-attribute gen-i-attribute)

        gen-attr-val-keygen__form
        (igen/freq :attr-val-keygen__form [
          [(get w [:attr-val-keygen__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-keygen__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-keygen__form gen-attr-val-keygen__form)

        gen-attr-val-input__title
        (igen/freq :attr-val-input__title [
          [(get w [:attr-val-input__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__title gen-attr-val-input__title)

        gen-attr-val-th__colspan
        (igen/freq :attr-val-th__colspan [
          [(get w [:attr-val-th__colspan :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-th__colspan :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-th__colspan gen-attr-val-th__colspan)

        gen-ul-attribute
        (:global-attribute g)
        g (assoc g :ul-attribute gen-ul-attribute)

        gen-body-attribute
        (:global-attribute g)
        g (assoc g :body-attribute gen-body-attribute)]
    g))

(defn- html5-generators-part-3 [gmap weights]
  (let [g gmap
        w weights

        gen-attr-val-input__list
        (igen/freq :attr-val-input__list [
          [(get w [:attr-val-input__list :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__list :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-input__list gen-attr-val-input__list)

        gen-kbd-attribute
        (:global-attribute g)
        g (assoc g :kbd-attribute gen-kbd-attribute)

        gen-attr-val-link__media
        (igen/freq :attr-val-link__media [
          [(get w [:attr-val-link__media :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__media :alt 1] 100)
            (gen/return "STUB Valid media query list")]])
        g (assoc g :attr-val-link__media gen-attr-val-link__media)

        gen-attr-val-keygen__keytype
        (igen/freq :attr-val-keygen__keytype [
          [(get w [:attr-val-keygen__keytype :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-keygen__keytype :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-keygen__keytype gen-attr-val-keygen__keytype)

        gen-em-attribute
        (:global-attribute g)
        g (assoc g :em-attribute gen-em-attribute)

        gen-ol-attribute
        (igen/freq :ol-attribute [
          [(get w [:ol-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:ol-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "reversed")
              (:opt-boolean g))]
          [(get w [:ol-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "start=\"")
              (:attr-val-ol__start g)
              (gen/return "\""))]
          [(get w [:ol-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-ol__type g)
              (gen/return "\""))]])
        g (assoc g :ol-attribute gen-ol-attribute)

        gen-attr-val-meta__http-equiv
        (igen/freq :attr-val-meta__http-equiv [
          [(get w [:attr-val-meta__http-equiv :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meta__http-equiv :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-meta__http-equiv gen-attr-val-meta__http-equiv)

        gen-attr-val-label__for
        (igen/freq :attr-val-label__for [
          [(get w [:attr-val-label__for :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-label__for :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-label__for gen-attr-val-label__for)

        gen-label-attribute
        (igen/freq :label-attribute [
          [(get w [:label-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:label-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "for=\"")
              (:attr-val-label__for g)
              (gen/return "\""))]
          [(get w [:label-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-label__form g)
              (gen/return "\""))]])
        g (assoc g :label-attribute gen-label-attribute)

        gen-attr-val-input__minlength
        (igen/freq :attr-val-input__minlength [
          [(get w [:attr-val-input__minlength :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__minlength :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-input__minlength gen-attr-val-input__minlength)

        gen-attr-val-input__inputmode
        (igen/freq :attr-val-input__inputmode [
          [(get w [:attr-val-input__inputmode :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__inputmode :alt 1] 100)
            (gen/return "email")]
          [(get w [:attr-val-input__inputmode :alt 2] 100)
            (gen/return "full-width-latin")]
          [(get w [:attr-val-input__inputmode :alt 3] 100)
            (gen/return "kana")]
          [(get w [:attr-val-input__inputmode :alt 4] 100)
            (gen/return "kana-name")]
          [(get w [:attr-val-input__inputmode :alt 5] 100)
            (gen/return "katakana")]
          [(get w [:attr-val-input__inputmode :alt 6] 100)
            (gen/return "latin")]
          [(get w [:attr-val-input__inputmode :alt 7] 100)
            (gen/return "latin-name")]
          [(get w [:attr-val-input__inputmode :alt 8] 100)
            (gen/return "latin-prose")]
          [(get w [:attr-val-input__inputmode :alt 9] 100)
            (gen/return "numeric")]
          [(get w [:attr-val-input__inputmode :alt 10] 100)
            (gen/return "tel")]
          [(get w [:attr-val-input__inputmode :alt 11] 100)
            (gen/return "url")]
          [(get w [:attr-val-input__inputmode :alt 12] 100)
            (gen/return "verbatim")]])
        g (assoc g :attr-val-input__inputmode gen-attr-val-input__inputmode)

        gen-attr-val-input__max
        (igen/freq :attr-val-input__max [
          [(get w [:attr-val-input__max :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__max :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__max gen-attr-val-input__max)

        gen-attr-val-input__step
        (igen/freq :attr-val-input__step [
          [(get w [:attr-val-input__step :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__step :alt 1] 100)
            (gen/return "any")]
          [(get w [:attr-val-input__step :alt 2] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-input__step gen-attr-val-input__step)

        gen-attr-val-input__pattern
        (gen/return "")
        g (assoc g :attr-val-input__pattern gen-attr-val-input__pattern)

        gen-attr-val-input__autocomplete
        (igen/freq :attr-val-input__autocomplete [
          [(get w [:attr-val-input__autocomplete :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__autocomplete :alt 1] 100)
            (gen/return "additional-name")]
          [(get w [:attr-val-input__autocomplete :alt 2] 100)
            (gen/return "address-level1")]
          [(get w [:attr-val-input__autocomplete :alt 3] 100)
            (gen/return "address-level2")]
          [(get w [:attr-val-input__autocomplete :alt 4] 100)
            (gen/return "address-level3")]
          [(get w [:attr-val-input__autocomplete :alt 5] 100)
            (gen/return "address-level4")]
          [(get w [:attr-val-input__autocomplete :alt 6] 100)
            (gen/return "address-line1")]
          [(get w [:attr-val-input__autocomplete :alt 7] 100)
            (gen/return "address-line2")]
          [(get w [:attr-val-input__autocomplete :alt 8] 100)
            (gen/return "address-line3")]
          [(get w [:attr-val-input__autocomplete :alt 9] 100)
            (gen/return "bday")]
          [(get w [:attr-val-input__autocomplete :alt 10] 100)
            (gen/return "bday-day")]
          [(get w [:attr-val-input__autocomplete :alt 11] 100)
            (gen/return "bday-month")]
          [(get w [:attr-val-input__autocomplete :alt 12] 100)
            (gen/return "bday-year")]
          [(get w [:attr-val-input__autocomplete :alt 13] 100)
            (gen/return "cc-additional-name")]
          [(get w [:attr-val-input__autocomplete :alt 14] 100)
            (gen/return "cc-csc")]
          [(get w [:attr-val-input__autocomplete :alt 15] 100)
            (gen/return "cc-exp")]
          [(get w [:attr-val-input__autocomplete :alt 16] 100)
            (gen/return "cc-exp-month")]
          [(get w [:attr-val-input__autocomplete :alt 17] 100)
            (gen/return "cc-exp-year")]
          [(get w [:attr-val-input__autocomplete :alt 18] 100)
            (gen/return "cc-family-name")]
          [(get w [:attr-val-input__autocomplete :alt 19] 100)
            (gen/return "cc-given-name")]
          [(get w [:attr-val-input__autocomplete :alt 20] 100)
            (gen/return "cc-name")]
          [(get w [:attr-val-input__autocomplete :alt 21] 100)
            (gen/return "cc-number")]
          [(get w [:attr-val-input__autocomplete :alt 22] 100)
            (gen/return "cc-type")]
          [(get w [:attr-val-input__autocomplete :alt 23] 100)
            (gen/return "country")]
          [(get w [:attr-val-input__autocomplete :alt 24] 100)
            (gen/return "country-name")]
          [(get w [:attr-val-input__autocomplete :alt 25] 100)
            (gen/return "current-password")]
          [(get w [:attr-val-input__autocomplete :alt 26] 100)
            (gen/return "email")]
          [(get w [:attr-val-input__autocomplete :alt 27] 100)
            (gen/return "family-name")]
          [(get w [:attr-val-input__autocomplete :alt 28] 100)
            (gen/return "given-name")]
          [(get w [:attr-val-input__autocomplete :alt 29] 100)
            (gen/return "honorific-prefix")]
          [(get w [:attr-val-input__autocomplete :alt 30] 100)
            (gen/return "honorific-suffix")]
          [(get w [:attr-val-input__autocomplete :alt 31] 100)
            (gen/return "impp")]
          [(get w [:attr-val-input__autocomplete :alt 32] 100)
            (gen/return "language")]
          [(get w [:attr-val-input__autocomplete :alt 33] 100)
            (gen/return "name")]
          [(get w [:attr-val-input__autocomplete :alt 34] 100)
            (gen/return "new-password")]
          [(get w [:attr-val-input__autocomplete :alt 35] 100)
            (gen/return "nickname")]
          [(get w [:attr-val-input__autocomplete :alt 36] 100)
            (gen/return "off")]
          [(get w [:attr-val-input__autocomplete :alt 37] 100)
            (gen/return "on")]
          [(get w [:attr-val-input__autocomplete :alt 38] 100)
            (gen/return "organization")]
          [(get w [:attr-val-input__autocomplete :alt 39] 100)
            (gen/return "organization-title")]
          [(get w [:attr-val-input__autocomplete :alt 40] 100)
            (gen/return "photo")]
          [(get w [:attr-val-input__autocomplete :alt 41] 100)
            (gen/return "postal-code")]
          [(get w [:attr-val-input__autocomplete :alt 42] 100)
            (gen/return "sex")]
          [(get w [:attr-val-input__autocomplete :alt 43] 100)
            (gen/return "street-address")]
          [(get w [:attr-val-input__autocomplete :alt 44] 100)
            (gen/return "tel")]
          [(get w [:attr-val-input__autocomplete :alt 45] 100)
            (gen/return "tel-area-code")]
          [(get w [:attr-val-input__autocomplete :alt 46] 100)
            (gen/return "tel-country-code")]
          [(get w [:attr-val-input__autocomplete :alt 47] 100)
            (gen/return "tel-extension")]
          [(get w [:attr-val-input__autocomplete :alt 48] 100)
            (gen/return "tel-local")]
          [(get w [:attr-val-input__autocomplete :alt 49] 100)
            (gen/return "tel-local-prefix")]
          [(get w [:attr-val-input__autocomplete :alt 50] 100)
            (gen/return "tel-local-suffix")]
          [(get w [:attr-val-input__autocomplete :alt 51] 100)
            (gen/return "tel-national")]
          [(get w [:attr-val-input__autocomplete :alt 52] 100)
            (gen/return "transaction-amount")]
          [(get w [:attr-val-input__autocomplete :alt 53] 100)
            (gen/return "transaction-currency")]
          [(get w [:attr-val-input__autocomplete :alt 54] 100)
            (gen/return "url")]
          [(get w [:attr-val-input__autocomplete :alt 55] 100)
            (gen/return "username")]])
        g (assoc g :attr-val-input__autocomplete gen-attr-val-input__autocomplete)

        gen-attr-val-input__formenctype
        (igen/freq :attr-val-input__formenctype [
          [(get w [:attr-val-input__formenctype :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__formenctype :alt 1] 100)
            (gen/return "application/x-www-form-urlencoded")]
          [(get w [:attr-val-input__formenctype :alt 2] 100)
            (gen/return "multipart/form-data")]
          [(get w [:attr-val-input__formenctype :alt 3] 100)
            (gen/return "text/plain")]])
        g (assoc g :attr-val-input__formenctype gen-attr-val-input__formenctype)

        gen-attr-val-input__min
        (igen/freq :attr-val-input__min [
          [(get w [:attr-val-input__min :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__min :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__min gen-attr-val-input__min)

        gen-attr-val-input__formmethod
        (igen/freq :attr-val-input__formmethod [
          [(get w [:attr-val-input__formmethod :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__formmethod :alt 1] 100)
            (gen/return "GET")]
          [(get w [:attr-val-input__formmethod :alt 2] 100)
            (gen/return "POST")]])
        g (assoc g :attr-val-input__formmethod gen-attr-val-input__formmethod)

        gen-attr-val-input__value
        (igen/freq :attr-val-input__value [
          [(get w [:attr-val-input__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__value :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__value gen-attr-val-input__value)

        gen-attr-val-input__accept
        (igen/freq :attr-val-input__accept [
          [(get w [:attr-val-input__accept :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__accept :alt 1] 100)
            (gen/return "audio/*")]
          [(get w [:attr-val-input__accept :alt 2] 100)
            (gen/return "image/*")]
          [(get w [:attr-val-input__accept :alt 3] 100)
            (gen/return "video/*")]
          [(get w [:attr-val-input__accept :alt 4] 100)
            (gen/return "STUB Set of comma-separated tokens")]
          [(get w [:attr-val-input__accept :alt 5] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-input__accept gen-attr-val-input__accept)

        gen-attr-val-input__formaction
        (igen/freq :attr-val-input__formaction [
          [(get w [:attr-val-input__formaction :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__formaction :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-input__formaction gen-attr-val-input__formaction)

        gen-attr-val-input__height
        (igen/freq :attr-val-input__height [
          [(get w [:attr-val-input__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-input__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-input__height [
                [(get w [:attr-val-input__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-input__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-input__height gen-attr-val-input__height)

        gen-attr-val-input__formtarget
        (igen/freq :attr-val-input__formtarget [
          [(get w [:attr-val-input__formtarget :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__formtarget :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-input__formtarget gen-attr-val-input__formtarget)

        gen-attr-val-input__alt
        (igen/freq :attr-val-input__alt [
          [(get w [:attr-val-input__alt :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__alt :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__alt gen-attr-val-input__alt)

        gen-attr-val-input__name
        (igen/freq :attr-val-input__name [
          [(get w [:attr-val-input__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-input__name gen-attr-val-input__name)

        gen-attr-val-input__size
        (igen/freq :attr-val-input__size [
          [(get w [:attr-val-input__size :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__size :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-input__size gen-attr-val-input__size)

        gen-attr-val-input__type
        (igen/freq :attr-val-input__type [
          [(get w [:attr-val-input__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-input__type :alt 1] 100)
            (gen/return "button")]
          [(get w [:attr-val-input__type :alt 2] 100)
            (gen/return "checkbox")]
          [(get w [:attr-val-input__type :alt 3] 100)
            (gen/return "color")]
          [(get w [:attr-val-input__type :alt 4] 100)
            (gen/return "date")]
          [(get w [:attr-val-input__type :alt 5] 100)
            (gen/return "datetime-local")]
          [(get w [:attr-val-input__type :alt 6] 100)
            (gen/return "email")]
          [(get w [:attr-val-input__type :alt 7] 100)
            (gen/return "file")]
          [(get w [:attr-val-input__type :alt 8] 100)
            (gen/return "hidden")]
          [(get w [:attr-val-input__type :alt 9] 100)
            (gen/return "image")]
          [(get w [:attr-val-input__type :alt 10] 100)
            (gen/return "month")]
          [(get w [:attr-val-input__type :alt 11] 100)
            (gen/return "number")]
          [(get w [:attr-val-input__type :alt 12] 100)
            (gen/return "password")]
          [(get w [:attr-val-input__type :alt 13] 100)
            (gen/return "radio")]
          [(get w [:attr-val-input__type :alt 14] 100)
            (gen/return "range")]
          [(get w [:attr-val-input__type :alt 15] 100)
            (gen/return "reset")]
          [(get w [:attr-val-input__type :alt 16] 100)
            (gen/return "search")]
          [(get w [:attr-val-input__type :alt 17] 100)
            (gen/return "submit")]
          [(get w [:attr-val-input__type :alt 18] 100)
            (gen/return "tel")]
          [(get w [:attr-val-input__type :alt 19] 100)
            (gen/return "text")]
          [(get w [:attr-val-input__type :alt 20] 100)
            (gen/return "time")]
          [(get w [:attr-val-input__type :alt 21] 100)
            (gen/return "url")]
          [(get w [:attr-val-input__type :alt 22] 100)
            (gen/return "week")]])
        g (assoc g :attr-val-input__type gen-attr-val-input__type)

        gen-input-attribute
        (igen/freq :input-attribute [
          [(get w [:input-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:input-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autofocus")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "checked")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "formnovalidate")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "multiple")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "readonly")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "required")
              (:opt-boolean g))]
          [(get w [:input-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "accept=\"")
              (:attr-val-input__accept g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "alt=\"")
              (:attr-val-input__alt g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 10] 100)
            (gen/tuple
              (gen/return "autocomplete=\"")
              (:attr-val-input__autocomplete g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 11] 100)
            (gen/tuple
              (gen/return "dirname=\"")
              (:attr-val-input__dirname g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 12] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-input__form g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 13] 100)
            (gen/tuple
              (gen/return "formaction=\"")
              (:attr-val-input__formaction g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 14] 100)
            (gen/tuple
              (gen/return "formenctype=\"")
              (:attr-val-input__formenctype g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 15] 100)
            (gen/tuple
              (gen/return "formmethod=\"")
              (:attr-val-input__formmethod g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 16] 100)
            (gen/tuple
              (gen/return "formtarget=\"")
              (:attr-val-input__formtarget g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 17] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-input__height g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 18] 100)
            (gen/tuple
              (gen/return "inputmode=\"")
              (:attr-val-input__inputmode g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 19] 100)
            (gen/tuple
              (gen/return "list=\"")
              (:attr-val-input__list g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 20] 100)
            (gen/tuple
              (gen/return "max=\"")
              (:attr-val-input__max g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 21] 100)
            (gen/tuple
              (gen/return "maxlength=\"")
              (:attr-val-input__maxlength g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 22] 100)
            (gen/tuple
              (gen/return "min=\"")
              (:attr-val-input__min g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 23] 100)
            (gen/tuple
              (gen/return "minlength=\"")
              (:attr-val-input__minlength g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 24] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-input__name g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 25] 100)
            (gen/tuple
              (gen/return "pattern=\"")
              (:attr-val-input__pattern g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 26] 100)
            (gen/tuple
              (gen/return "placeholder=\"")
              (:attr-val-input__placeholder g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 27] 100)
            (gen/tuple
              (gen/return "size=\"")
              (:attr-val-input__size g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 28] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-input__src g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 29] 100)
            (gen/tuple
              (gen/return "step=\"")
              (:attr-val-input__step g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 30] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-input__title g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 31] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-input__type g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 32] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-input__value g)
              (gen/return "\""))]
          [(get w [:input-attribute :alt 33] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-input__width g)
              (gen/return "\""))]])
        g (assoc g :input-attribute gen-input-attribute)

        gen-s-attribute
        (:global-attribute g)
        g (assoc g :s-attribute gen-s-attribute)

        gen-attr-val-menu__type
        (igen/freq :attr-val-menu__type [
          [(get w [:attr-val-menu__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menu__type :alt 1] 100)
            (gen/return "context")]])
        g (assoc g :attr-val-menu__type gen-attr-val-menu__type)

        gen-attr-val-menu__label
        (igen/freq :attr-val-menu__label [
          [(get w [:attr-val-menu__label :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menu__label :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-menu__label gen-attr-val-menu__label)

        gen-menu-attribute
        (igen/freq :menu-attribute [
          [(get w [:menu-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:menu-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "label=\"")
              (:attr-val-menu__label g)
              (gen/return "\""))]
          [(get w [:menu-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-menu__type g)
              (gen/return "\""))]])
        g (assoc g :menu-attribute gen-menu-attribute)

        gen-attr-val-keygen__challenge
        (igen/freq :attr-val-keygen__challenge [
          [(get w [:attr-val-keygen__challenge :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-keygen__challenge :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-keygen__challenge gen-attr-val-keygen__challenge)

        gen-keygen-attribute
        (igen/freq :keygen-attribute [
          [(get w [:keygen-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:keygen-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autofocus")
              (:opt-boolean g))]
          [(get w [:keygen-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:keygen-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "challenge=\"")
              (:attr-val-keygen__challenge g)
              (gen/return "\""))]
          [(get w [:keygen-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-keygen__form g)
              (gen/return "\""))]
          [(get w [:keygen-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "keytype=\"")
              (:attr-val-keygen__keytype g)
              (gen/return "\""))]
          [(get w [:keygen-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-keygen__name g)
              (gen/return "\""))]])
        g (assoc g :keygen-attribute gen-keygen-attribute)

        gen-attr-val-data__value
        (igen/freq :attr-val-data__value [
          [(get w [:attr-val-data__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-data__value :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-data__value gen-attr-val-data__value)

        gen-attr-val-object__form
        (igen/freq :attr-val-object__form [
          [(get w [:attr-val-object__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-object__form gen-attr-val-object__form)

        gen-attr-val-form__autocomplete
        (igen/freq :attr-val-form__autocomplete [
          [(get w [:attr-val-form__autocomplete :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__autocomplete :alt 1] 100)
            (gen/return "off")]
          [(get w [:attr-val-form__autocomplete :alt 2] 100)
            (gen/return "on")]])
        g (assoc g :attr-val-form__autocomplete gen-attr-val-form__autocomplete)

        gen-rt-attribute
        (:global-attribute g)
        g (assoc g :rt-attribute gen-rt-attribute)

        gen-attr-val-del__cite
        (igen/freq :attr-val-del__cite [
          [(get w [:attr-val-del__cite :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-del__cite :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-del__cite gen-attr-val-del__cite)

        gen-address-attribute
        (:global-attribute g)
        g (assoc g :address-attribute gen-address-attribute)

        gen-figcaption-attribute
        (:global-attribute g)
        g (assoc g :figcaption-attribute gen-figcaption-attribute)

        gen-encoding-label
        (gen/return "utf-8")
        g (assoc g :encoding-label gen-encoding-label)

        gen-attr-val-script__charset
        (igen/freq :attr-val-script__charset [
          [(get w [:attr-val-script__charset :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-script__charset :alt 1] 100)
            (:encoding-label g)]])
        g (assoc g :attr-val-script__charset gen-attr-val-script__charset)

        gen-attr-val-textarea__minlength
        (igen/freq :attr-val-textarea__minlength [
          [(get w [:attr-val-textarea__minlength :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__minlength :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-textarea__minlength gen-attr-val-textarea__minlength)

        gen-attr-val-textarea__rows
        (igen/freq :attr-val-textarea__rows [
          [(get w [:attr-val-textarea__rows :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__rows :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-textarea__rows gen-attr-val-textarea__rows)

        gen-attr-val-optgroup__label
        (igen/freq :attr-val-optgroup__label [
          [(get w [:attr-val-optgroup__label :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-optgroup__label :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-optgroup__label gen-attr-val-optgroup__label)

        gen-optgroup-attribute
        (igen/freq :optgroup-attribute [
          [(get w [:optgroup-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:optgroup-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:optgroup-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "label=\"")
              (:attr-val-optgroup__label g)
              (gen/return "\""))]])
        g (assoc g :optgroup-attribute gen-optgroup-attribute)

        gen-attr-val-link__sizes
        (igen/freq :attr-val-link__sizes [
          [(get w [:attr-val-link__sizes :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__sizes :alt 1] 100)
            (:attribute-data g)]
          [(get w [:attr-val-link__sizes :alt 2] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-link__sizes [
                [(get w [:attr-val-link__sizes :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-link__sizes :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-link__sizes gen-attr-val-link__sizes)

        gen-attr-val-progress__value
        (igen/freq :attr-val-progress__value [
          [(get w [:attr-val-progress__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-progress__value :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-progress__value gen-attr-val-progress__value)

        gen-attr-val-progress__max
        (igen/freq :attr-val-progress__max [
          [(get w [:attr-val-progress__max :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-progress__max :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-progress__max gen-attr-val-progress__max)]
    g))

(defn- html5-generators-part-4 [gmap weights]
  (let [g gmap
        w weights

        gen-progress-attribute
        (igen/freq :progress-attribute [
          [(get w [:progress-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:progress-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "max=\"")
              (:attr-val-progress__max g)
              (gen/return "\""))]
          [(get w [:progress-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-progress__value g)
              (gen/return "\""))]])
        g (assoc g :progress-attribute gen-progress-attribute)

        gen-attr-val-del__datetime
        (igen/freq :attr-val-del__datetime [
          [(get w [:attr-val-del__datetime :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-del__datetime :alt 1] 100)
            (gen/return "STUB Valid date string with optional time")]])
        g (assoc g :attr-val-del__datetime gen-attr-val-del__datetime)

        gen-del-attribute
        (igen/freq :del-attribute [
          [(get w [:del-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:del-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "cite=\"")
              (:attr-val-del__cite g)
              (gen/return "\""))]
          [(get w [:del-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "datetime=\"")
              (:attr-val-del__datetime g)
              (gen/return "\""))]])
        g (assoc g :del-attribute gen-del-attribute)

        gen-span-attribute
        (:global-attribute g)
        g (assoc g :span-attribute gen-span-attribute)

        gen-rb-attribute
        (:global-attribute g)
        g (assoc g :rb-attribute gen-rb-attribute)

        gen-attr-val-th__headers
        (igen/freq :attr-val-th__headers [
          [(get w [:attr-val-th__headers :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-th__headers :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-th__headers [
                [(get w [:attr-val-th__headers :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-th__headers :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]
          [(get w [:attr-val-th__headers :alt 2] 100)
            (gen/return "STUB case-sensitive")]])
        g (assoc g :attr-val-th__headers gen-attr-val-th__headers)

        gen-attr-val-select__name
        (igen/freq :attr-val-select__name [
          [(get w [:attr-val-select__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-select__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-select__name gen-attr-val-select__name)

        gen-attr-val-style__title
        (igen/freq :attr-val-style__title [
          [(get w [:attr-val-style__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-style__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-style__title gen-attr-val-style__title)

        gen-attr-val-style__media
        (igen/freq :attr-val-style__media [
          [(get w [:attr-val-style__media :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-style__media :alt 1] 100)
            (gen/return "STUB Valid media query list")]])
        g (assoc g :attr-val-style__media gen-attr-val-style__media)

        gen-attr-val-style__nonce
        (igen/freq :attr-val-style__nonce [
          [(get w [:attr-val-style__nonce :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-style__nonce :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-style__nonce gen-attr-val-style__nonce)

        gen-attr-val-style__type
        (igen/freq :attr-val-style__type [
          [(get w [:attr-val-style__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-style__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-style__type gen-attr-val-style__type)

        gen-style-attribute
        (igen/freq :style-attribute [
          [(get w [:style-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:style-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "media=\"")
              (:attr-val-style__media g)
              (gen/return "\""))]
          [(get w [:style-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "nonce=\"")
              (:attr-val-style__nonce g)
              (gen/return "\""))]
          [(get w [:style-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-style__title g)
              (gen/return "\""))]
          [(get w [:style-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-style__type g)
              (gen/return "\""))]])
        g (assoc g :style-attribute gen-style-attribute)

        gen-attr-val-ins__cite
        (igen/freq :attr-val-ins__cite [
          [(get w [:attr-val-ins__cite :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-ins__cite :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-ins__cite gen-attr-val-ins__cite)

        gen-ins-attribute
        (igen/freq :ins-attribute [
          [(get w [:ins-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:ins-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "cite=\"")
              (:attr-val-ins__cite g)
              (gen/return "\""))]
          [(get w [:ins-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "datetime=\"")
              (:attr-val-ins__datetime g)
              (gen/return "\""))]])
        g (assoc g :ins-attribute gen-ins-attribute)

        gen-picture-attribute
        (:global-attribute g)
        g (assoc g :picture-attribute gen-picture-attribute)

        gen-attr-val-form__method
        (igen/freq :attr-val-form__method [
          [(get w [:attr-val-form__method :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__method :alt 1] 100)
            (gen/return "get")]
          [(get w [:attr-val-form__method :alt 2] 100)
            (gen/return "post")]])
        g (assoc g :attr-val-form__method gen-attr-val-form__method)

        gen-nav-attribute
        (:global-attribute g)
        g (assoc g :nav-attribute gen-nav-attribute)

        gen-attr-val-a__hreflang
        (igen/freq :attr-val-a__hreflang [
          [(get w [:attr-val-a__hreflang :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__hreflang :alt 1] 100)
            (:lang g)]])
        g (assoc g :attr-val-a__hreflang gen-attr-val-a__hreflang)

        gen-char-data-test
        rgen/wrap-ahem-char
        g (assoc g :char-data-test gen-char-data-test)

        gen-rtc-attribute
        (:global-attribute g)
        g (assoc g :rtc-attribute gen-rtc-attribute)

        gen-datalist-attribute
        (:global-attribute g)
        g (assoc g :datalist-attribute gen-datalist-attribute)

        gen-code-attribute
        (:global-attribute g)
        g (assoc g :code-attribute gen-code-attribute)

        gen-attr-val-abbr__title
        (igen/freq :attr-val-abbr__title [
          [(get w [:attr-val-abbr__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-abbr__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-abbr__title gen-attr-val-abbr__title)

        gen-abbr-attribute
        (igen/freq :abbr-attribute [
          [(get w [:abbr-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:abbr-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-abbr__title g)
              (gen/return "\""))]])
        g (assoc g :abbr-attribute gen-abbr-attribute)

        gen-attr-val-object__height
        (igen/freq :attr-val-object__height [
          [(get w [:attr-val-object__height :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__height :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-object__height :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-object__height [
                [(get w [:attr-val-object__height :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-object__height :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-object__height gen-attr-val-object__height)

        gen-attr-val-object__width
        (igen/freq :attr-val-object__width [
          [(get w [:attr-val-object__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-object__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-object__width [
                [(get w [:attr-val-object__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-object__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-object__width gen-attr-val-object__width)

        gen-attr-val-object__type
        (igen/freq :attr-val-object__type [
          [(get w [:attr-val-object__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-object__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-object__type gen-attr-val-object__type)

        gen-object-attribute
        (igen/freq :object-attribute [
          [(get w [:object-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:object-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "typemustmatch")
              (:opt-boolean g))]
          [(get w [:object-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "data=\"")
              (:attr-val-object__data g)
              (gen/return "\""))]
          [(get w [:object-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-object__form g)
              (gen/return "\""))]
          [(get w [:object-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-object__height g)
              (gen/return "\""))]
          [(get w [:object-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-object__name g)
              (gen/return "\""))]
          [(get w [:object-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-object__type g)
              (gen/return "\""))]
          [(get w [:object-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-object__width g)
              (gen/return "\""))]])
        g (assoc g :object-attribute gen-object-attribute)

        gen-tr-attribute
        (:global-attribute g)
        g (assoc g :tr-attribute gen-tr-attribute)

        gen-attr-val-audio__preload
        (igen/freq :attr-val-audio__preload [
          [(get w [:attr-val-audio__preload :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-audio__preload :alt 1] 100)
            (gen/return "auto")]
          [(get w [:attr-val-audio__preload :alt 2] 100)
            (gen/return "metadata")]
          [(get w [:attr-val-audio__preload :alt 3] 100)
            (gen/return "none")]])
        g (assoc g :attr-val-audio__preload gen-attr-val-audio__preload)

        gen-attr-val-a__href
        (igen/freq :attr-val-a__href [
          [(get w [:attr-val-a__href :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__href :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-a__href gen-attr-val-a__href)

        gen-reference
        rgen/wrap-ahem-ref
        g (assoc g :reference gen-reference)

        gen-attr-val-textarea__autocomplete
        (igen/freq :attr-val-textarea__autocomplete [
          [(get w [:attr-val-textarea__autocomplete :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__autocomplete :alt 1] 100)
            (gen/return "STUB Autofill field")]])
        g (assoc g :attr-val-textarea__autocomplete gen-attr-val-textarea__autocomplete)

        gen-attr-val-script__type
        (igen/freq :attr-val-script__type [
          [(get w [:attr-val-script__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-script__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-script__type gen-attr-val-script__type)

        gen-sup-attribute
        (:global-attribute g)
        g (assoc g :sup-attribute gen-sup-attribute)

        gen-attr-val-th__abbr
        (igen/freq :attr-val-th__abbr [
          [(get w [:attr-val-th__abbr :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-th__abbr :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-th__abbr gen-attr-val-th__abbr)

        gen-attr-val-th__rowspan
        (igen/freq :attr-val-th__rowspan [
          [(get w [:attr-val-th__rowspan :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-th__rowspan :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-th__rowspan gen-attr-val-th__rowspan)

        gen-attr-val-th__scope
        (igen/freq :attr-val-th__scope [
          [(get w [:attr-val-th__scope :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-th__scope :alt 1] 100)
            (gen/return "col")]
          [(get w [:attr-val-th__scope :alt 2] 100)
            (gen/return "colgroup")]
          [(get w [:attr-val-th__scope :alt 3] 100)
            (gen/return "row")]
          [(get w [:attr-val-th__scope :alt 4] 100)
            (gen/return "rowgroup")]])
        g (assoc g :attr-val-th__scope gen-attr-val-th__scope)

        gen-th-attribute
        (igen/freq :th-attribute [
          [(get w [:th-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:th-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "abbr=\"")
              (:attr-val-th__abbr g)
              (gen/return "\""))]
          [(get w [:th-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "colspan=\"")
              (:attr-val-th__colspan g)
              (gen/return "\""))]
          [(get w [:th-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "headers=\"")
              (:attr-val-th__headers g)
              (gen/return "\""))]
          [(get w [:th-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "rowspan=\"")
              (:attr-val-th__rowspan g)
              (gen/return "\""))]
          [(get w [:th-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "scope=\"")
              (:attr-val-th__scope g)
              (gen/return "\""))]])
        g (assoc g :th-attribute gen-th-attribute)

        gen-attr-val-meter__low
        (igen/freq :attr-val-meter__low [
          [(get w [:attr-val-meter__low :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__low :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__low gen-attr-val-meter__low)

        gen-attr-val-canvas__width
        (igen/freq :attr-val-canvas__width [
          [(get w [:attr-val-canvas__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-canvas__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-canvas__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-canvas__width [
                [(get w [:attr-val-canvas__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-canvas__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-canvas__width gen-attr-val-canvas__width)

        gen-dd-attribute
        (:global-attribute g)
        g (assoc g :dd-attribute gen-dd-attribute)

        gen-attr-val-option__label
        (igen/freq :attr-val-option__label [
          [(get w [:attr-val-option__label :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-option__label :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-option__label gen-attr-val-option__label)

        gen-option-attribute
        (igen/freq :option-attribute [
          [(get w [:option-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:option-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:option-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "selected")
              (:opt-boolean g))]
          [(get w [:option-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "label=\"")
              (:attr-val-option__label g)
              (gen/return "\""))]
          [(get w [:option-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-option__value g)
              (gen/return "\""))]])
        g (assoc g :option-attribute gen-option-attribute)

        gen-attr-val-select__autocomplete
        (igen/freq :attr-val-select__autocomplete [
          [(get w [:attr-val-select__autocomplete :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-select__autocomplete :alt 1] 100)
            (gen/return "STUB Autofill field")]])
        g (assoc g :attr-val-select__autocomplete gen-attr-val-select__autocomplete)

        gen-attr-val-select__form
        (igen/freq :attr-val-select__form [
          [(get w [:attr-val-select__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-select__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-select__form gen-attr-val-select__form)

        gen-select-attribute
        (igen/freq :select-attribute [
          [(get w [:select-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:select-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autofocus")
              (:opt-boolean g))]
          [(get w [:select-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:select-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "multiple")
              (:opt-boolean g))]
          [(get w [:select-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "required")
              (:opt-boolean g))]
          [(get w [:select-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "autocomplete=\"")
              (:attr-val-select__autocomplete g)
              (gen/return "\""))]
          [(get w [:select-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-select__form g)
              (gen/return "\""))]
          [(get w [:select-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-select__name g)
              (gen/return "\""))]
          [(get w [:select-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "size=\"")
              (:attr-val-select__size g)
              (gen/return "\""))]])
        g (assoc g :select-attribute gen-select-attribute)

        gen-attr-val-a__download
        (gen/return "")
        g (assoc g :attr-val-a__download gen-attr-val-a__download)

        gen-attr-val-link__title
        (igen/freq :attr-val-link__title [
          [(get w [:attr-val-link__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-link__title gen-attr-val-link__title)

        gen-sub-attribute
        (:global-attribute g)
        g (assoc g :sub-attribute gen-sub-attribute)]
    g))

(defn- html5-generators-part-5 [gmap weights]
  (let [g gmap
        w weights

        gen-footer-attribute
        (:global-attribute g)
        g (assoc g :footer-attribute gen-footer-attribute)

        gen-caption-attribute
        (:global-attribute g)
        g (assoc g :caption-attribute gen-caption-attribute)

        gen-attr-val-textarea__placeholder
        (igen/freq :attr-val-textarea__placeholder [
          [(get w [:attr-val-textarea__placeholder :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__placeholder :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-textarea__placeholder gen-attr-val-textarea__placeholder)

        gen-attr-val-td__headers
        (igen/freq :attr-val-td__headers [
          [(get w [:attr-val-td__headers :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-td__headers :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-td__headers [
                [(get w [:attr-val-td__headers :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-td__headers :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]
          [(get w [:attr-val-td__headers :alt 2] 100)
            (gen/return "STUB case-sensitive")]])
        g (assoc g :attr-val-td__headers gen-attr-val-td__headers)

        gen-tfoot-attribute
        (:global-attribute g)
        g (assoc g :tfoot-attribute gen-tfoot-attribute)

        gen-attr-val-form__enctype
        (igen/freq :attr-val-form__enctype [
          [(get w [:attr-val-form__enctype :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__enctype :alt 1] 100)
            (gen/return "application/x-www-form-urlencoded")]
          [(get w [:attr-val-form__enctype :alt 2] 100)
            (gen/return "multipart/form-data")]
          [(get w [:attr-val-form__enctype :alt 3] 100)
            (gen/return "text/plain")]])
        g (assoc g :attr-val-form__enctype gen-attr-val-form__enctype)

        gen-template-attribute
        (:global-attribute g)
        g (assoc g :template-attribute gen-template-attribute)

        gen-attr-val-q__cite
        (igen/freq :attr-val-q__cite [
          [(get w [:attr-val-q__cite :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-q__cite :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-q__cite gen-attr-val-q__cite)

        gen-attr-val-param__value
        (igen/freq :attr-val-param__value [
          [(get w [:attr-val-param__value :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-param__value :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-param__value gen-attr-val-param__value)

        gen-main-attribute
        (:global-attribute g)
        g (assoc g :main-attribute gen-main-attribute)

        gen-attr-val-video__poster
        (igen/freq :attr-val-video__poster [
          [(get w [:attr-val-video__poster :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__poster :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-video__poster gen-attr-val-video__poster)

        gen-attr-val-video__src
        (igen/freq :attr-val-video__src [
          [(get w [:attr-val-video__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-video__src gen-attr-val-video__src)

        gen-attr-val-video__crossorigin
        (igen/freq :attr-val-video__crossorigin [
          [(get w [:attr-val-video__crossorigin :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-video__crossorigin :alt 1] 100)
            (gen/return "anonymous")]
          [(get w [:attr-val-video__crossorigin :alt 2] 100)
            (gen/return "use-credentials")]])
        g (assoc g :attr-val-video__crossorigin gen-attr-val-video__crossorigin)

        gen-video-attribute
        (igen/freq :video-attribute [
          [(get w [:video-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:video-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autoplay")
              (:opt-boolean g))]
          [(get w [:video-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "controls")
              (:opt-boolean g))]
          [(get w [:video-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "loop")
              (:opt-boolean g))]
          [(get w [:video-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "muted")
              (:opt-boolean g))]
          [(get w [:video-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "crossorigin=\"")
              (:attr-val-video__crossorigin g)
              (gen/return "\""))]
          [(get w [:video-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-video__height g)
              (gen/return "\""))]
          [(get w [:video-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "poster=\"")
              (:attr-val-video__poster g)
              (gen/return "\""))]
          [(get w [:video-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "preload=\"")
              (:attr-val-video__preload g)
              (gen/return "\""))]
          [(get w [:video-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-video__src g)
              (gen/return "\""))]
          [(get w [:video-attribute :alt 10] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-video__width g)
              (gen/return "\""))]])
        g (assoc g :video-attribute gen-video-attribute)

        gen-attr-val-textarea__inputmode
        (igen/freq :attr-val-textarea__inputmode [
          [(get w [:attr-val-textarea__inputmode :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__inputmode :alt 1] 100)
            (gen/return "email")]
          [(get w [:attr-val-textarea__inputmode :alt 2] 100)
            (gen/return "full-width-latin")]
          [(get w [:attr-val-textarea__inputmode :alt 3] 100)
            (gen/return "kana")]
          [(get w [:attr-val-textarea__inputmode :alt 4] 100)
            (gen/return "kana-name")]
          [(get w [:attr-val-textarea__inputmode :alt 5] 100)
            (gen/return "katakana")]
          [(get w [:attr-val-textarea__inputmode :alt 6] 100)
            (gen/return "latin")]
          [(get w [:attr-val-textarea__inputmode :alt 7] 100)
            (gen/return "latin-name")]
          [(get w [:attr-val-textarea__inputmode :alt 8] 100)
            (gen/return "latin-prose")]
          [(get w [:attr-val-textarea__inputmode :alt 9] 100)
            (gen/return "numeric")]
          [(get w [:attr-val-textarea__inputmode :alt 10] 100)
            (gen/return "tel")]
          [(get w [:attr-val-textarea__inputmode :alt 11] 100)
            (gen/return "url")]
          [(get w [:attr-val-textarea__inputmode :alt 12] 100)
            (gen/return "verbatim")]])
        g (assoc g :attr-val-textarea__inputmode gen-attr-val-textarea__inputmode)

        gen-attr-val-textarea__cols
        (igen/freq :attr-val-textarea__cols [
          [(get w [:attr-val-textarea__cols :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-textarea__cols :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-textarea__cols gen-attr-val-textarea__cols)

        gen-textarea-attribute
        (igen/freq :textarea-attribute [
          [(get w [:textarea-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:textarea-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autofocus")
              (:opt-boolean g))]
          [(get w [:textarea-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:textarea-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "readonly")
              (:opt-boolean g))]
          [(get w [:textarea-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "required")
              (:opt-boolean g))]
          [(get w [:textarea-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "autocomplete=\"")
              (:attr-val-textarea__autocomplete g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "cols=\"")
              (:attr-val-textarea__cols g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "dirname=\"")
              (:attr-val-textarea__dirname g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-textarea__form g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "inputmode=\"")
              (:attr-val-textarea__inputmode g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 10] 100)
            (gen/tuple
              (gen/return "maxlength=\"")
              (:attr-val-textarea__maxlength g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 11] 100)
            (gen/tuple
              (gen/return "minlength=\"")
              (:attr-val-textarea__minlength g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 12] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-textarea__name g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 13] 100)
            (gen/tuple
              (gen/return "placeholder=\"")
              (:attr-val-textarea__placeholder g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 14] 100)
            (gen/tuple
              (gen/return "rows=\"")
              (:attr-val-textarea__rows g)
              (gen/return "\""))]
          [(get w [:textarea-attribute :alt 15] 100)
            (gen/tuple
              (gen/return "wrap=\"")
              (:attr-val-textarea__wrap g)
              (gen/return "\""))]])
        g (assoc g :textarea-attribute gen-textarea-attribute)

        gen-attr-val-a__rel
        (igen/freq :attr-val-a__rel [
          [(get w [:attr-val-a__rel :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__rel :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-a__rel [
                [(get w [:attr-val-a__rel :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-a__rel :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-a__rel gen-attr-val-a__rel)

        gen-attr-val-link__hreflang
        (igen/freq :attr-val-link__hreflang [
          [(get w [:attr-val-link__hreflang :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__hreflang :alt 1] 100)
            (:lang g)]])
        g (assoc g :attr-val-link__hreflang gen-attr-val-link__hreflang)

        gen-attr-val-link__href
        (igen/freq :attr-val-link__href [
          [(get w [:attr-val-link__href :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__href :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-link__href gen-attr-val-link__href)

        gen-attr-val-link__rel
        (igen/freq :attr-val-link__rel [
          [(get w [:attr-val-link__rel :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__rel :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-link__rel [
                [(get w [:attr-val-link__rel :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-link__rel :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-link__rel gen-attr-val-link__rel)

        gen-attr-val-link__crossorigin
        (igen/freq :attr-val-link__crossorigin [
          [(get w [:attr-val-link__crossorigin :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__crossorigin :alt 1] 100)
            (gen/return "anonymous")]
          [(get w [:attr-val-link__crossorigin :alt 2] 100)
            (gen/return "use-credentials")]])
        g (assoc g :attr-val-link__crossorigin gen-attr-val-link__crossorigin)

        gen-attr-val-link__type
        (igen/freq :attr-val-link__type [
          [(get w [:attr-val-link__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-link__type gen-attr-val-link__type)

        gen-attr-val-link__rev
        (igen/freq :attr-val-link__rev [
          [(get w [:attr-val-link__rev :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-link__rev :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-link__rev [
                [(get w [:attr-val-link__rev :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-link__rev :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-link__rev gen-attr-val-link__rev)

        gen-link-attribute
        (igen/freq :link-attribute [
          [(get w [:link-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:link-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "crossorigin=\"")
              (:attr-val-link__crossorigin g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "href=\"")
              (:attr-val-link__href g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "hreflang=\"")
              (:attr-val-link__hreflang g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "media=\"")
              (:attr-val-link__media g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "rel=\"")
              (:attr-val-link__rel g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "rev=\"")
              (:attr-val-link__rev g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "sizes=\"")
              (:attr-val-link__sizes g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-link__title g)
              (gen/return "\""))]
          [(get w [:link-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-link__type g)
              (gen/return "\""))]])
        g (assoc g :link-attribute gen-link-attribute)

        gen-attr-val-base__href
        (igen/freq :attr-val-base__href [
          [(get w [:attr-val-base__href :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-base__href :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-base__href gen-attr-val-base__href)

        gen-base-attribute
        (igen/freq :base-attribute [
          [(get w [:base-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:base-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "href=\"")
              (:attr-val-base__href g)
              (gen/return "\""))]
          [(get w [:base-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "target=\"")
              (:attr-val-base__target g)
              (gen/return "\""))]])
        g (assoc g :base-attribute gen-base-attribute)

        gen-dl-attribute
        (:global-attribute g)
        g (assoc g :dl-attribute gen-dl-attribute)

        gen-hr-attribute
        (:global-attribute g)
        g (assoc g :hr-attribute gen-hr-attribute)

        gen-attr-val-menuitem__command
        (igen/freq :attr-val-menuitem__command [
          [(get w [:attr-val-menuitem__command :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__command :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-menuitem__command gen-attr-val-menuitem__command)

        gen-attr-val-audio__crossorigin
        (igen/freq :attr-val-audio__crossorigin [
          [(get w [:attr-val-audio__crossorigin :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-audio__crossorigin :alt 1] 100)
            (gen/return "anonymous")]
          [(get w [:attr-val-audio__crossorigin :alt 2] 100)
            (gen/return "use-credentials")]])
        g (assoc g :attr-val-audio__crossorigin gen-attr-val-audio__crossorigin)

        gen-attr-val-audio__src
        (igen/freq :attr-val-audio__src [
          [(get w [:attr-val-audio__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-audio__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-audio__src gen-attr-val-audio__src)

        gen-audio-attribute
        (igen/freq :audio-attribute [
          [(get w [:audio-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:audio-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "autoplay")
              (:opt-boolean g))]
          [(get w [:audio-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "controls")
              (:opt-boolean g))]
          [(get w [:audio-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "loop")
              (:opt-boolean g))]
          [(get w [:audio-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "muted")
              (:opt-boolean g))]
          [(get w [:audio-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "crossorigin=\"")
              (:attr-val-audio__crossorigin g)
              (gen/return "\""))]
          [(get w [:audio-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "preload=\"")
              (:attr-val-audio__preload g)
              (gen/return "\""))]
          [(get w [:audio-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-audio__src g)
              (gen/return "\""))]])
        g (assoc g :audio-attribute gen-audio-attribute)

        gen-mark-attribute
        (:global-attribute g)
        g (assoc g :mark-attribute gen-mark-attribute)

        gen-blockquote-attribute
        (igen/freq :blockquote-attribute [
          [(get w [:blockquote-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:blockquote-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "cite=\"")
              (:attr-val-blockquote__cite g)
              (gen/return "\""))]])
        g (assoc g :blockquote-attribute gen-blockquote-attribute)

        gen-attr-val-img__usemap
        (igen/freq :attr-val-img__usemap [
          [(get w [:attr-val-img__usemap :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__usemap :alt 1] 100)
            (gen/return "STUB Valid hash-name reference")]])
        g (assoc g :attr-val-img__usemap gen-attr-val-img__usemap)

        gen-attr-val-bdo__dir
        (igen/freq :attr-val-bdo__dir [
          [(get w [:attr-val-bdo__dir :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-bdo__dir :alt 1] 100)
            (gen/return "ltr")]
          [(get w [:attr-val-bdo__dir :alt 2] 100)
            (gen/return "rtl")]])
        g (assoc g :attr-val-bdo__dir gen-attr-val-bdo__dir)

        gen-h2-attribute
        (:global-attribute g)
        g (assoc g :h2-attribute gen-h2-attribute)

        gen-attr-val-a__rev
        (igen/freq :attr-val-a__rev [
          [(get w [:attr-val-a__rev :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-a__rev :alt 1] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-a__rev [
                [(get w [:attr-val-a__rev :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-a__rev :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]])
        g (assoc g :attr-val-a__rev gen-attr-val-a__rev)

        gen-attr-val-form__name
        (igen/freq :attr-val-form__name [
          [(get w [:attr-val-form__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-form__name gen-attr-val-form__name)

        gen-b-attribute
        (:global-attribute g)
        g (assoc g :b-attribute gen-b-attribute)

        gen-attr-val-script__crossorigin
        (igen/freq :attr-val-script__crossorigin [
          [(get w [:attr-val-script__crossorigin :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-script__crossorigin :alt 1] 100)
            (gen/return "anonymous")]
          [(get w [:attr-val-script__crossorigin :alt 2] 100)
            (gen/return "use-credentials")]])
        g (assoc g :attr-val-script__crossorigin gen-attr-val-script__crossorigin)

        gen-details-attribute
        (igen/freq :details-attribute [
          [(get w [:details-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:details-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "open")
              (:opt-boolean g))]])
        g (assoc g :details-attribute gen-details-attribute)

        gen-attr-val-source__type
        (igen/freq :attr-val-source__type [
          [(get w [:attr-val-source__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-source__type :alt 1] 100)
            (:mime-type g)]])
        g (assoc g :attr-val-source__type gen-attr-val-source__type)

        gen-attr-val-meta__charset
        (igen/freq :attr-val-meta__charset [
          [(get w [:attr-val-meta__charset :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meta__charset :alt 1] 100)
            (:encoding-label g)]])
        g (assoc g :attr-val-meta__charset gen-attr-val-meta__charset)

        gen-attr-val-meta__content
        (igen/freq :attr-val-meta__content [
          [(get w [:attr-val-meta__content :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meta__content :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-meta__content gen-attr-val-meta__content)

        gen-meta-attribute
        (igen/freq :meta-attribute [
          [(get w [:meta-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:meta-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "charset=\"")
              (:attr-val-meta__charset g)
              (gen/return "\""))]
          [(get w [:meta-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "content=\"")
              (:attr-val-meta__content g)
              (gen/return "\""))]
          [(get w [:meta-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "http-equiv=\"")
              (:attr-val-meta__http-equiv g)
              (gen/return "\""))]
          [(get w [:meta-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-meta__name g)
              (gen/return "\""))]])
        g (assoc g :meta-attribute gen-meta-attribute)

        gen-attr-val-menuitem__type
        (igen/freq :attr-val-menuitem__type [
          [(get w [:attr-val-menuitem__type :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__type :alt 1] 100)
            (gen/return "checkbox")]
          [(get w [:attr-val-menuitem__type :alt 2] 100)
            (gen/return "command")]
          [(get w [:attr-val-menuitem__type :alt 3] 100)
            (gen/return "radio")]])
        g (assoc g :attr-val-menuitem__type gen-attr-val-menuitem__type)

        gen-header-attribute
        (:global-attribute g)
        g (assoc g :header-attribute gen-header-attribute)

        gen-attr-val-meter__optimum
        (igen/freq :attr-val-meter__optimum [
          [(get w [:attr-val-meter__optimum :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__optimum :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__optimum gen-attr-val-meter__optimum)]
    g))

(defn- html5-generators-part-6 [gmap weights]
  (let [g gmap
        w weights

        gen-attr-val-meter__high
        (igen/freq :attr-val-meter__high [
          [(get w [:attr-val-meter__high :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-meter__high :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :attr-val-meter__high gen-attr-val-meter__high)

        gen-meter-attribute
        (igen/freq :meter-attribute [
          [(get w [:meter-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:meter-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "high=\"")
              (:attr-val-meter__high g)
              (gen/return "\""))]
          [(get w [:meter-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "low=\"")
              (:attr-val-meter__low g)
              (gen/return "\""))]
          [(get w [:meter-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "max=\"")
              (:attr-val-meter__max g)
              (gen/return "\""))]
          [(get w [:meter-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "min=\"")
              (:attr-val-meter__min g)
              (gen/return "\""))]
          [(get w [:meter-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "optimum=\"")
              (:attr-val-meter__optimum g)
              (gen/return "\""))]
          [(get w [:meter-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-meter__value g)
              (gen/return "\""))]])
        g (assoc g :meter-attribute gen-meter-attribute)

        gen-br-attribute
        (:global-attribute g)
        g (assoc g :br-attribute gen-br-attribute)

        gen-attr-val-td__colspan
        (igen/freq :attr-val-td__colspan [
          [(get w [:attr-val-td__colspan :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-td__colspan :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-td__colspan gen-attr-val-td__colspan)

        gen-td-attribute
        (igen/freq :td-attribute [
          [(get w [:td-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:td-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "colspan=\"")
              (:attr-val-td__colspan g)
              (gen/return "\""))]
          [(get w [:td-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "headers=\"")
              (:attr-val-td__headers g)
              (gen/return "\""))]
          [(get w [:td-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "rowspan=\"")
              (:attr-val-td__rowspan g)
              (gen/return "\""))]])
        g (assoc g :td-attribute gen-td-attribute)

        gen-attr-val-img__width
        (igen/freq :attr-val-img__width [
          [(get w [:attr-val-img__width :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__width :alt 1] 100)
            (:non-negative-integer g)]
          [(get w [:attr-val-img__width :alt 2] 100)
            (gen/tuple
              (:non-negative-integer g)
              (igen/freq :attr-val-img__width [
                [(get w [:attr-val-img__width :alt 2 :cat 1 :alt 0] 100)
                  (:length-unit g)]
                [(get w [:attr-val-img__width :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "%")]]))]])
        g (assoc g :attr-val-img__width gen-attr-val-img__width)

        gen-aside-attribute
        (:global-attribute g)
        g (assoc g :aside-attribute gen-aside-attribute)

        gen-attr-val-form__action
        (igen/freq :attr-val-form__action [
          [(get w [:attr-val-form__action :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__action :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-form__action gen-attr-val-form__action)

        gen-attr-val-script__nonce
        (igen/freq :attr-val-script__nonce [
          [(get w [:attr-val-script__nonce :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-script__nonce :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-script__nonce gen-attr-val-script__nonce)

        gen-char-data
        (:char-data-test g)
        g (assoc g :char-data gen-char-data)

        gen-content
        (igen/freq :content [
          [(get w [:content :alt 0] 100)
            (:char-data g)]
          [(get w [:content :alt 1] 100)
            (:reference g)]
          [(get w [:content :alt 2] 100)
            (:comment g)]])
        g (assoc g :content gen-content)

        gen-attr-val-menuitem__icon
        (igen/freq :attr-val-menuitem__icon [
          [(get w [:attr-val-menuitem__icon :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__icon :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-menuitem__icon gen-attr-val-menuitem__icon)

        gen-attr-val-script__src
        (igen/freq :attr-val-script__src [
          [(get w [:attr-val-script__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-script__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-script__src gen-attr-val-script__src)

        gen-script-attribute
        (igen/freq :script-attribute [
          [(get w [:script-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:script-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "async")
              (:opt-boolean g))]
          [(get w [:script-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "defer")
              (:opt-boolean g))]
          [(get w [:script-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "charset=\"")
              (:attr-val-script__charset g)
              (gen/return "\""))]
          [(get w [:script-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "crossorigin=\"")
              (:attr-val-script__crossorigin g)
              (gen/return "\""))]
          [(get w [:script-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "nonce=\"")
              (:attr-val-script__nonce g)
              (gen/return "\""))]
          [(get w [:script-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-script__src g)
              (gen/return "\""))]
          [(get w [:script-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-script__type g)
              (gen/return "\""))]])
        g (assoc g :script-attribute gen-script-attribute)

        gen-data-attribute
        (igen/freq :data-attribute [
          [(get w [:data-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:data-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-data__value g)
              (gen/return "\""))]])
        g (assoc g :data-attribute gen-data-attribute)

        gen-bdo-attribute
        (igen/freq :bdo-attribute [
          [(get w [:bdo-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:bdo-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "dir=\"")
              (:attr-val-bdo__dir g)
              (gen/return "\""))]])
        g (assoc g :bdo-attribute gen-bdo-attribute)

        gen-attr-val-param__name
        (igen/freq :attr-val-param__name [
          [(get w [:attr-val-param__name :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-param__name :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-param__name gen-attr-val-param__name)

        gen-attr-val-menuitem__label
        (igen/freq :attr-val-menuitem__label [
          [(get w [:attr-val-menuitem__label :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__label :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-menuitem__label gen-attr-val-menuitem__label)

        gen-li-attribute
        (igen/freq :li-attribute [
          [(get w [:li-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:li-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-li__value g)
              (gen/return "\""))]])
        g (assoc g :li-attribute gen-li-attribute)

        gen-u-attribute
        (:global-attribute g)
        g (assoc g :u-attribute gen-u-attribute)

        gen-any-number
        (igen/freq :any-number [
          [(get w [:any-number :alt 0] 100)
            (:integer g)]
          [(get w [:any-number :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :any-number gen-any-number)

        gen-srcset
        (gen/tuple
          (:url g)
          (igen/freq :srcset [
            [(get w [:srcset :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:srcset :cat 1 :opt 0] 100)
              (gen/tuple
                (gen/return " ")
                (gen/tuple
                  (:any-number g)
                  (igen/freq :srcset [
                    [(get w [:srcset :cat 1 :opt 0 :cat 1 :cat 1 :alt 0] 100)
                      (gen/return "w")]
                    [(get w [:srcset :cat 1 :opt 0 :cat 1 :cat 1 :alt 1] 100)
                      (gen/return "x")]])))]])
          (igen/freq :srcset [
            [(get w [:srcset :cat 2 :star nil] 100)
              (gen/return "")]
            [(get w [:srcset :cat 2 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:url g)
                  (igen/freq :srcset [
                    [(get w [:srcset :cat 2 :star 0 :cat 3 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:srcset :cat 2 :star 0 :cat 3 :opt 0] 100)
                      (gen/tuple
                        (gen/return " ")
                        (gen/tuple
                          (:any-number g)
                          (igen/freq :srcset [
                            [(get w [:srcset :cat 2 :star 0 :cat 3 :opt 0 :cat 1 :cat 1 :alt 0] 100)
                              (gen/return "w")]
                            [(get w [:srcset :cat 2 :star 0 :cat 3 :opt 0 :cat 1 :cat 1 :alt 1] 100)
                              (gen/return "x")]])))]])))]]))
        g (assoc g :srcset gen-srcset)

        gen-attr-val-source__srcset
        (igen/freq :attr-val-source__srcset [
          [(get w [:attr-val-source__srcset :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-source__srcset :alt 1] 100)
            (:srcset g)]])
        g (assoc g :attr-val-source__srcset gen-attr-val-source__srcset)

        gen-a-attribute
        (igen/freq :a-attribute [
          [(get w [:a-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:a-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "download=\"")
              (:attr-val-a__download g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "href=\"")
              (:attr-val-a__href g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "hreflang=\"")
              (:attr-val-a__hreflang g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "rel=\"")
              (:attr-val-a__rel g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "rev=\"")
              (:attr-val-a__rev g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "target=\"")
              (:attr-val-a__target g)
              (gen/return "\""))]
          [(get w [:a-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-a__type g)
              (gen/return "\""))]])
        g (assoc g :a-attribute gen-a-attribute)

        gen-attr-val-form__accept-charset
        (igen/freq :attr-val-form__accept-charset [
          [(get w [:attr-val-form__accept-charset :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-form__accept-charset :alt 1] 100)
            (:attribute-data g)]
          [(get w [:attr-val-form__accept-charset :alt 2] 100)
            (gen/return "STUB ASCII-compatible encodings")]
          [(get w [:attr-val-form__accept-charset :alt 3] 100)
            (gen/tuple
              (:name g)
              (igen/freq :attr-val-form__accept-charset [
                [(get w [:attr-val-form__accept-charset :alt 3 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:attr-val-form__accept-charset :alt 3 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return " ")
                      (:name g)))]]))]
          [(get w [:attr-val-form__accept-charset :alt 4] 100)
            (gen/return "STUB labels")]])
        g (assoc g :attr-val-form__accept-charset gen-attr-val-form__accept-charset)

        gen-attr-val-menuitem__radiogroup
        (igen/freq :attr-val-menuitem__radiogroup [
          [(get w [:attr-val-menuitem__radiogroup :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__radiogroup :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-menuitem__radiogroup gen-attr-val-menuitem__radiogroup)

        gen-attr-val-menuitem__title
        (igen/freq :attr-val-menuitem__title [
          [(get w [:attr-val-menuitem__title :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-menuitem__title :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-menuitem__title gen-attr-val-menuitem__title)

        gen-menuitem-attribute
        (igen/freq :menuitem-attribute [
          [(get w [:menuitem-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:menuitem-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "checked")
              (:opt-boolean g))]
          [(get w [:menuitem-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "default")
              (:opt-boolean g))]
          [(get w [:menuitem-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:menuitem-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "command=\"")
              (:attr-val-menuitem__command g)
              (gen/return "\""))]
          [(get w [:menuitem-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "icon=\"")
              (:attr-val-menuitem__icon g)
              (gen/return "\""))]
          [(get w [:menuitem-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "label=\"")
              (:attr-val-menuitem__label g)
              (gen/return "\""))]
          [(get w [:menuitem-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "radiogroup=\"")
              (:attr-val-menuitem__radiogroup g)
              (gen/return "\""))]
          [(get w [:menuitem-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "title=\"")
              (:attr-val-menuitem__title g)
              (gen/return "\""))]
          [(get w [:menuitem-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-menuitem__type g)
              (gen/return "\""))]])
        g (assoc g :menuitem-attribute gen-menuitem-attribute)

        gen-ruby-attribute
        (:global-attribute g)
        g (assoc g :ruby-attribute gen-ruby-attribute)

        gen-attr-val-source__src
        (igen/freq :attr-val-source__src [
          [(get w [:attr-val-source__src :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-source__src :alt 1] 100)
            (:url g)]])
        g (assoc g :attr-val-source__src gen-attr-val-source__src)

        gen-legend-attribute
        (:global-attribute g)
        g (assoc g :legend-attribute gen-legend-attribute)

        gen-attr-val-img__srcset
        (igen/freq :attr-val-img__srcset [
          [(get w [:attr-val-img__srcset :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__srcset :alt 1] 100)
            (:srcset g)]])
        g (assoc g :attr-val-img__srcset gen-attr-val-img__srcset)

        gen-attr-val-col__span
        (igen/freq :attr-val-col__span [
          [(get w [:attr-val-col__span :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-col__span :alt 1] 100)
            (:non-negative-integer g)]])
        g (assoc g :attr-val-col__span gen-attr-val-col__span)

        gen-col-attribute
        (igen/freq :col-attribute [
          [(get w [:col-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:col-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "span=\"")
              (:attr-val-col__span g)
              (gen/return "\""))]])
        g (assoc g :col-attribute gen-col-attribute)

        gen-cite-attribute
        (:global-attribute g)
        g (assoc g :cite-attribute gen-cite-attribute)

        gen-canvas-attribute
        (igen/freq :canvas-attribute [
          [(get w [:canvas-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:canvas-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-canvas__height g)
              (gen/return "\""))]
          [(get w [:canvas-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-canvas__width g)
              (gen/return "\""))]])
        g (assoc g :canvas-attribute gen-canvas-attribute)

        gen-attr-val-fieldset__form
        (igen/freq :attr-val-fieldset__form [
          [(get w [:attr-val-fieldset__form :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-fieldset__form :alt 1] 100)
            (:name g)]])
        g (assoc g :attr-val-fieldset__form gen-attr-val-fieldset__form)

        gen-table-attribute
        (igen/freq :table-attribute [
          [(get w [:table-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:table-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "border=\"")
              (:attr-val-table__border g)
              (gen/return "\""))]])
        g (assoc g :table-attribute gen-table-attribute)

        gen-form-attribute
        (igen/freq :form-attribute [
          [(get w [:form-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:form-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "novalidate")
              (:opt-boolean g))]
          [(get w [:form-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "accept-charset=\"")
              (:attr-val-form__accept-charset g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "action=\"")
              (:attr-val-form__action g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "autocomplete=\"")
              (:attr-val-form__autocomplete g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "enctype=\"")
              (:attr-val-form__enctype g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "method=\"")
              (:attr-val-form__method g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-form__name g)
              (gen/return "\""))]
          [(get w [:form-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "target=\"")
              (:attr-val-form__target g)
              (gen/return "\""))]])
        g (assoc g :form-attribute gen-form-attribute)

        gen-param-attribute
        (igen/freq :param-attribute [
          [(get w [:param-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:param-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-param__name g)
              (gen/return "\""))]
          [(get w [:param-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "value=\"")
              (:attr-val-param__value g)
              (gen/return "\""))]])
        g (assoc g :param-attribute gen-param-attribute)

        gen-article-attribute
        (:global-attribute g)
        g (assoc g :article-attribute gen-article-attribute)

        gen-q-attribute
        (igen/freq :q-attribute [
          [(get w [:q-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:q-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "cite=\"")
              (:attr-val-q__cite g)
              (gen/return "\""))]])
        g (assoc g :q-attribute gen-q-attribute)

        gen-fieldset-attribute
        (igen/freq :fieldset-attribute [
          [(get w [:fieldset-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:fieldset-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "disabled")
              (:opt-boolean g))]
          [(get w [:fieldset-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "form=\"")
              (:attr-val-fieldset__form g)
              (gen/return "\""))]
          [(get w [:fieldset-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "name=\"")
              (:attr-val-fieldset__name g)
              (gen/return "\""))]])
        g (assoc g :fieldset-attribute gen-fieldset-attribute)

        gen-attr-val-img__alt
        (igen/freq :attr-val-img__alt [
          [(get w [:attr-val-img__alt :alt 0] 100)
            (gen/return "")]
          [(get w [:attr-val-img__alt :alt 1] 100)
            (:attribute-data g)]])
        g (assoc g :attr-val-img__alt gen-attr-val-img__alt)

        gen-img-attribute
        (igen/freq :img-attribute [
          [(get w [:img-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:img-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "ismap")
              (:opt-boolean g))]
          [(get w [:img-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "alt=\"")
              (:attr-val-img__alt g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "crossorigin=\"")
              (:attr-val-img__crossorigin g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "height=\"")
              (:attr-val-img__height g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 5] 100)
            (gen/tuple
              (gen/return "sizes=\"")
              (:attr-val-img__sizes g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 6] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-img__src g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 7] 100)
            (gen/tuple
              (gen/return "srcset=\"")
              (:attr-val-img__srcset g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 8] 100)
            (gen/tuple
              (gen/return "usemap=\"")
              (:attr-val-img__usemap g)
              (gen/return "\""))]
          [(get w [:img-attribute :alt 9] 100)
            (gen/tuple
              (gen/return "width=\"")
              (:attr-val-img__width g)
              (gen/return "\""))]])
        g (assoc g :img-attribute gen-img-attribute)

        gen-bdi-attribute
        (:global-attribute g)
        g (assoc g :bdi-attribute gen-bdi-attribute)

        gen-source-attribute
        (igen/freq :source-attribute [
          [(get w [:source-attribute :alt 0] 100)
            (:global-attribute g)]
          [(get w [:source-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "sizes=\"")
              (:attr-val-source__sizes g)
              (gen/return "\""))]
          [(get w [:source-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "src=\"")
              (:attr-val-source__src g)
              (gen/return "\""))]
          [(get w [:source-attribute :alt 3] 100)
            (gen/tuple
              (gen/return "srcset=\"")
              (:attr-val-source__srcset g)
              (gen/return "\""))]
          [(get w [:source-attribute :alt 4] 100)
            (gen/tuple
              (gen/return "type=\"")
              (:attr-val-source__type g)
              (gen/return "\""))]])
        g (assoc g :source-attribute gen-source-attribute)

        gen-div-attribute
        (:global-attribute g)
        g (assoc g :div-attribute gen-div-attribute)

        gen-element
        (gen/recursive-gen
          (fn [inner]
            (igen/freq :element [
              [(get w [:element :alt 0] 100)
                (gen/tuple
                  (gen/return "<a")
                  (igen/freq :element [
                    [(get w [:element :alt 0 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 0 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:a-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 0 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 0 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 0 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 0 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</a>"))]
              [(get w [:element :alt 1] 100)
                (gen/tuple
                  (gen/return "<abbr")
                  (igen/freq :element [
                    [(get w [:element :alt 1 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 1 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:abbr-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 1 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 1 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 1 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 1 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</abbr>"))]
              [(get w [:element :alt 2] 100)
                (gen/tuple
                  (gen/return "<address")
                  (igen/freq :element [
                    [(get w [:element :alt 2 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 2 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:address-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 2 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 2 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 2 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 2 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</address>"))]
              [(get w [:element :alt 3] 100)
                (gen/tuple
                  (gen/return "<area")
                  (igen/freq :element [
                    [(get w [:element :alt 3 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 3 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:area-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 4] 100)
                (gen/tuple
                  (gen/return "<article")
                  (igen/freq :element [
                    [(get w [:element :alt 4 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 4 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:article-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 4 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 4 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 4 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 4 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</article>"))]
              [(get w [:element :alt 5] 100)
                (gen/tuple
                  (gen/return "<aside")
                  (igen/freq :element [
                    [(get w [:element :alt 5 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 5 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:aside-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 5 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 5 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 5 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 5 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</aside>"))]
              [(get w [:element :alt 6] 100)
                (gen/tuple
                  (gen/return "<audio")
                  (igen/freq :element [
                    [(get w [:element :alt 6 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 6 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:audio-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 6 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 6 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 6 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 6 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</audio>"))]
              [(get w [:element :alt 7] 100)
                (gen/tuple
                  (gen/return "<b")
                  (igen/freq :element [
                    [(get w [:element :alt 7 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 7 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:b-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 7 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 7 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 7 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 7 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</b>"))]
              [(get w [:element :alt 8] 100)
                (gen/tuple
                  (gen/return "<base")
                  (igen/freq :element [
                    [(get w [:element :alt 8 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 8 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:base-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 9] 100)
                (gen/tuple
                  (gen/return "<bdi")
                  (igen/freq :element [
                    [(get w [:element :alt 9 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 9 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:bdi-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 9 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 9 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 9 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 9 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</bdi>"))]
              [(get w [:element :alt 10] 100)
                (gen/tuple
                  (gen/return "<bdo")
                  (igen/freq :element [
                    [(get w [:element :alt 10 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 10 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:bdo-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 10 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 10 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 10 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 10 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</bdo>"))]
              [(get w [:element :alt 11] 100)
                (gen/tuple
                  (gen/return "<blockquote")
                  (igen/freq :element [
                    [(get w [:element :alt 11 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 11 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:blockquote-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 11 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 11 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 11 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 11 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</blockquote>"))]
              [(get w [:element :alt 12] 100)
                (gen/tuple
                  (gen/return "<br")
                  (igen/freq :element [
                    [(get w [:element :alt 12 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 12 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:br-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 13] 100)
                (gen/tuple
                  (gen/return "<button")
                  (igen/freq :element [
                    [(get w [:element :alt 13 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 13 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:button-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 13 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 13 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 13 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 13 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</button>"))]
              [(get w [:element :alt 14] 100)
                (gen/tuple
                  (gen/return "<canvas")
                  (igen/freq :element [
                    [(get w [:element :alt 14 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 14 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:canvas-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 14 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 14 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 14 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 14 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</canvas>"))]
              [(get w [:element :alt 15] 100)
                (gen/tuple
                  (gen/return "<caption")
                  (igen/freq :element [
                    [(get w [:element :alt 15 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 15 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:caption-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 15 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 15 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 15 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 15 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</caption>"))]
              [(get w [:element :alt 16] 100)
                (gen/tuple
                  (gen/return "<cite")
                  (igen/freq :element [
                    [(get w [:element :alt 16 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 16 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:cite-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 16 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 16 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 16 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 16 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</cite>"))]
              [(get w [:element :alt 17] 100)
                (gen/tuple
                  (gen/return "<code")
                  (igen/freq :element [
                    [(get w [:element :alt 17 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 17 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:code-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 17 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 17 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 17 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 17 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</code>"))]
              [(get w [:element :alt 18] 100)
                (gen/tuple
                  (gen/return "<col")
                  (igen/freq :element [
                    [(get w [:element :alt 18 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 18 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:col-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 19] 100)
                (gen/tuple
                  (gen/return "<colgroup")
                  (igen/freq :element [
                    [(get w [:element :alt 19 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 19 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:colgroup-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 19 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 19 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 19 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 19 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</colgroup>"))]
              [(get w [:element :alt 20] 100)
                (gen/tuple
                  (gen/return "<data")
                  (igen/freq :element [
                    [(get w [:element :alt 20 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 20 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:data-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 20 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 20 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 20 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 20 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</data>"))]
              [(get w [:element :alt 21] 100)
                (gen/tuple
                  (gen/return "<datalist")
                  (igen/freq :element [
                    [(get w [:element :alt 21 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 21 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:datalist-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 21 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 21 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 21 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 21 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</datalist>"))]
              [(get w [:element :alt 22] 100)
                (gen/tuple
                  (gen/return "<dd")
                  (igen/freq :element [
                    [(get w [:element :alt 22 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 22 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:dd-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 22 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 22 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 22 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 22 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</dd>"))]
              [(get w [:element :alt 23] 100)
                (gen/tuple
                  (gen/return "<del")
                  (igen/freq :element [
                    [(get w [:element :alt 23 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 23 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:del-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 23 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 23 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 23 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 23 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</del>"))]
              [(get w [:element :alt 24] 100)
                (gen/tuple
                  (gen/return "<details")
                  (igen/freq :element [
                    [(get w [:element :alt 24 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 24 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:details-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 24 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 24 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 24 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 24 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</details>"))]
              [(get w [:element :alt 25] 100)
                (gen/tuple
                  (gen/return "<dfn")
                  (igen/freq :element [
                    [(get w [:element :alt 25 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 25 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:dfn-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 25 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 25 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 25 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 25 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</dfn>"))]
              [(get w [:element :alt 26] 100)
                (gen/tuple
                  (gen/return "<div")
                  (igen/freq :element [
                    [(get w [:element :alt 26 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 26 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:div-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 26 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 26 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 26 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 26 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</div>"))]
              [(get w [:element :alt 27] 100)
                (gen/tuple
                  (gen/return "<dl")
                  (igen/freq :element [
                    [(get w [:element :alt 27 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 27 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:dl-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 27 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 27 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 27 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 27 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</dl>"))]
              [(get w [:element :alt 28] 100)
                (gen/tuple
                  (gen/return "<dt")
                  (igen/freq :element [
                    [(get w [:element :alt 28 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 28 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:dt-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 28 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 28 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 28 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 28 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</dt>"))]
              [(get w [:element :alt 29] 100)
                (gen/tuple
                  (gen/return "<em")
                  (igen/freq :element [
                    [(get w [:element :alt 29 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 29 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:em-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 29 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 29 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 29 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 29 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</em>"))]
              [(get w [:element :alt 30] 100)
                (gen/tuple
                  (gen/return "<embed")
                  (igen/freq :element [
                    [(get w [:element :alt 30 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 30 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:embed-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 31] 100)
                (gen/tuple
                  (gen/return "<fieldset")
                  (igen/freq :element [
                    [(get w [:element :alt 31 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 31 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:fieldset-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 31 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 31 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 31 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 31 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</fieldset>"))]
              [(get w [:element :alt 32] 100)
                (gen/tuple
                  (gen/return "<figcaption")
                  (igen/freq :element [
                    [(get w [:element :alt 32 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 32 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:figcaption-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 32 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 32 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 32 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 32 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</figcaption>"))]
              [(get w [:element :alt 33] 100)
                (gen/tuple
                  (gen/return "<figure")
                  (igen/freq :element [
                    [(get w [:element :alt 33 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 33 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:figure-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 33 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 33 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 33 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 33 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</figure>"))]
              [(get w [:element :alt 34] 100)
                (gen/tuple
                  (gen/return "<footer")
                  (igen/freq :element [
                    [(get w [:element :alt 34 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 34 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:footer-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 34 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 34 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 34 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 34 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</footer>"))]
              [(get w [:element :alt 35] 100)
                (gen/tuple
                  (gen/return "<form")
                  (igen/freq :element [
                    [(get w [:element :alt 35 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 35 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:form-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 35 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 35 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 35 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 35 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</form>"))]
              [(get w [:element :alt 36] 100)
                (gen/tuple
                  (gen/return "<h1")
                  (igen/freq :element [
                    [(get w [:element :alt 36 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 36 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h1-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 36 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 36 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 36 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 36 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h1>"))]
              [(get w [:element :alt 37] 100)
                (gen/tuple
                  (gen/return "<h2")
                  (igen/freq :element [
                    [(get w [:element :alt 37 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 37 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h2-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 37 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 37 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 37 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 37 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h2>"))]
              [(get w [:element :alt 38] 100)
                (gen/tuple
                  (gen/return "<h3")
                  (igen/freq :element [
                    [(get w [:element :alt 38 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 38 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h3-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 38 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 38 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 38 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 38 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h3>"))]
              [(get w [:element :alt 39] 100)
                (gen/tuple
                  (gen/return "<h4")
                  (igen/freq :element [
                    [(get w [:element :alt 39 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 39 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h4-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 39 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 39 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 39 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 39 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h4>"))]
              [(get w [:element :alt 40] 100)
                (gen/tuple
                  (gen/return "<h5")
                  (igen/freq :element [
                    [(get w [:element :alt 40 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 40 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h5-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 40 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 40 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 40 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 40 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h5>"))]
              [(get w [:element :alt 41] 100)
                (gen/tuple
                  (gen/return "<h6")
                  (igen/freq :element [
                    [(get w [:element :alt 41 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 41 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:h6-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 41 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 41 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 41 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 41 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</h6>"))]
              [(get w [:element :alt 42] 100)
                (gen/tuple
                  (gen/return "<header")
                  (igen/freq :element [
                    [(get w [:element :alt 42 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 42 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:header-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 42 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 42 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 42 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 42 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</header>"))]
              [(get w [:element :alt 43] 100)
                (gen/tuple
                  (gen/return "<hr")
                  (igen/freq :element [
                    [(get w [:element :alt 43 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 43 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:hr-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 44] 100)
                (gen/tuple
                  (gen/return "<i")
                  (igen/freq :element [
                    [(get w [:element :alt 44 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 44 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:i-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 44 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 44 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 44 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 44 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</i>"))]
              [(get w [:element :alt 45] 100)
                (gen/tuple
                  (gen/return "<iframe")
                  (igen/freq :element [
                    [(get w [:element :alt 45 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 45 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:iframe-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 45 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 45 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 45 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 45 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</iframe>"))]
              [(get w [:element :alt 46] 100)
                (gen/tuple
                  (gen/return "<img")
                  (igen/freq :element [
                    [(get w [:element :alt 46 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 46 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:img-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 47] 100)
                (gen/tuple
                  (gen/return "<input")
                  (igen/freq :element [
                    [(get w [:element :alt 47 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 47 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:input-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 48] 100)
                (gen/tuple
                  (gen/return "<ins")
                  (igen/freq :element [
                    [(get w [:element :alt 48 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 48 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:ins-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 48 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 48 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 48 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 48 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</ins>"))]
              [(get w [:element :alt 49] 100)
                (gen/tuple
                  (gen/return "<kbd")
                  (igen/freq :element [
                    [(get w [:element :alt 49 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 49 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:kbd-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 49 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 49 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 49 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 49 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</kbd>"))]
              [(get w [:element :alt 50] 100)
                (gen/tuple
                  (gen/return "<keygen")
                  (igen/freq :element [
                    [(get w [:element :alt 50 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 50 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:keygen-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 51] 100)
                (gen/tuple
                  (gen/return "<label")
                  (igen/freq :element [
                    [(get w [:element :alt 51 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 51 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:label-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 51 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 51 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 51 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 51 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</label>"))]
              [(get w [:element :alt 52] 100)
                (gen/tuple
                  (gen/return "<legend")
                  (igen/freq :element [
                    [(get w [:element :alt 52 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 52 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:legend-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 52 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 52 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 52 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 52 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</legend>"))]
              [(get w [:element :alt 53] 100)
                (gen/tuple
                  (gen/return "<li")
                  (igen/freq :element [
                    [(get w [:element :alt 53 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 53 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:li-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 53 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 53 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 53 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 53 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</li>"))]
              [(get w [:element :alt 54] 100)
                (gen/tuple
                  (gen/return "<link")
                  (igen/freq :element [
                    [(get w [:element :alt 54 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 54 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:link-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 55] 100)
                (gen/tuple
                  (gen/return "<main")
                  (igen/freq :element [
                    [(get w [:element :alt 55 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 55 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:main-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 55 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 55 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 55 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 55 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</main>"))]
              [(get w [:element :alt 56] 100)
                (gen/tuple
                  (gen/return "<map")
                  (igen/freq :element [
                    [(get w [:element :alt 56 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 56 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:map-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 56 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 56 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 56 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 56 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</map>"))]
              [(get w [:element :alt 57] 100)
                (gen/tuple
                  (gen/return "<mark")
                  (igen/freq :element [
                    [(get w [:element :alt 57 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 57 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:mark-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 57 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 57 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 57 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 57 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</mark>"))]
              [(get w [:element :alt 58] 100)
                (gen/tuple
                  (gen/return "<menu")
                  (igen/freq :element [
                    [(get w [:element :alt 58 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 58 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:menu-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 58 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 58 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 58 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 58 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</menu>"))]
              [(get w [:element :alt 59] 100)
                (gen/tuple
                  (gen/return "<menuitem")
                  (igen/freq :element [
                    [(get w [:element :alt 59 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 59 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:menuitem-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 60] 100)
                (gen/tuple
                  (gen/return "<meta")
                  (igen/freq :element [
                    [(get w [:element :alt 60 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 60 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:meta-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 61] 100)
                (gen/tuple
                  (gen/return "<meter")
                  (igen/freq :element [
                    [(get w [:element :alt 61 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 61 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:meter-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 61 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 61 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 61 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 61 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</meter>"))]
              [(get w [:element :alt 62] 100)
                (gen/tuple
                  (gen/return "<nav")
                  (igen/freq :element [
                    [(get w [:element :alt 62 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 62 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:nav-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 62 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 62 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 62 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 62 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</nav>"))]
              [(get w [:element :alt 63] 100)
                (gen/tuple
                  (gen/return "<noscript")
                  (igen/freq :element [
                    [(get w [:element :alt 63 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 63 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:noscript-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 63 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 63 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 63 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 63 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</noscript>"))]
              [(get w [:element :alt 64] 100)
                (gen/tuple
                  (gen/return "<object")
                  (igen/freq :element [
                    [(get w [:element :alt 64 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 64 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:object-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 64 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 64 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 64 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 64 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</object>"))]
              [(get w [:element :alt 65] 100)
                (gen/tuple
                  (gen/return "<ol")
                  (igen/freq :element [
                    [(get w [:element :alt 65 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 65 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:ol-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 65 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 65 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 65 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 65 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</ol>"))]
              [(get w [:element :alt 66] 100)
                (gen/tuple
                  (gen/return "<optgroup")
                  (igen/freq :element [
                    [(get w [:element :alt 66 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 66 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:optgroup-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 66 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 66 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 66 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 66 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</optgroup>"))]
              [(get w [:element :alt 67] 100)
                (gen/tuple
                  (gen/return "<option")
                  (igen/freq :element [
                    [(get w [:element :alt 67 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 67 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:option-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 67 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 67 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 67 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 67 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</option>"))]
              [(get w [:element :alt 68] 100)
                (gen/tuple
                  (gen/return "<output")
                  (igen/freq :element [
                    [(get w [:element :alt 68 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 68 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:output-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 68 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 68 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 68 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 68 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</output>"))]
              [(get w [:element :alt 69] 100)
                (gen/tuple
                  (gen/return "<p")
                  (igen/freq :element [
                    [(get w [:element :alt 69 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 69 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:p-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 69 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 69 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 69 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 69 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</p>"))]
              [(get w [:element :alt 70] 100)
                (gen/tuple
                  (gen/return "<param")
                  (igen/freq :element [
                    [(get w [:element :alt 70 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 70 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:param-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 71] 100)
                (gen/tuple
                  (gen/return "<picture")
                  (igen/freq :element [
                    [(get w [:element :alt 71 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 71 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:picture-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 71 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 71 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 71 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 71 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</picture>"))]
              [(get w [:element :alt 72] 100)
                (gen/tuple
                  (gen/return "<pre")
                  (igen/freq :element [
                    [(get w [:element :alt 72 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 72 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:pre-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 72 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 72 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 72 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 72 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</pre>"))]
              [(get w [:element :alt 73] 100)
                (gen/tuple
                  (gen/return "<progress")
                  (igen/freq :element [
                    [(get w [:element :alt 73 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 73 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:progress-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 73 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 73 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 73 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 73 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</progress>"))]
              [(get w [:element :alt 74] 100)
                (gen/tuple
                  (gen/return "<q")
                  (igen/freq :element [
                    [(get w [:element :alt 74 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 74 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:q-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 74 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 74 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 74 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 74 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</q>"))]
              [(get w [:element :alt 75] 100)
                (gen/tuple
                  (gen/return "<rb")
                  (igen/freq :element [
                    [(get w [:element :alt 75 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 75 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:rb-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 75 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 75 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 75 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 75 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</rb>"))]
              [(get w [:element :alt 76] 100)
                (gen/tuple
                  (gen/return "<rp")
                  (igen/freq :element [
                    [(get w [:element :alt 76 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 76 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:rp-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 76 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 76 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 76 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 76 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</rp>"))]
              [(get w [:element :alt 77] 100)
                (gen/tuple
                  (gen/return "<rt")
                  (igen/freq :element [
                    [(get w [:element :alt 77 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 77 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:rt-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 77 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 77 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 77 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 77 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</rt>"))]
              [(get w [:element :alt 78] 100)
                (gen/tuple
                  (gen/return "<rtc")
                  (igen/freq :element [
                    [(get w [:element :alt 78 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 78 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:rtc-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 78 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 78 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 78 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 78 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</rtc>"))]
              [(get w [:element :alt 79] 100)
                (gen/tuple
                  (gen/return "<ruby")
                  (igen/freq :element [
                    [(get w [:element :alt 79 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 79 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:ruby-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 79 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 79 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 79 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 79 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</ruby>"))]
              [(get w [:element :alt 80] 100)
                (gen/tuple
                  (gen/return "<s")
                  (igen/freq :element [
                    [(get w [:element :alt 80 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 80 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:s-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 80 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 80 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 80 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 80 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</s>"))]
              [(get w [:element :alt 81] 100)
                (gen/tuple
                  (gen/return "<samp")
                  (igen/freq :element [
                    [(get w [:element :alt 81 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 81 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:samp-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 81 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 81 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 81 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 81 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</samp>"))]
              [(get w [:element :alt 82] 100)
                (gen/tuple
                  (gen/return "<script")
                  (igen/freq :element [
                    [(get w [:element :alt 82 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 82 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:script-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 82 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 82 :cat 3 :star 0] 100)
                      (igen/vector+
                        (:content g))]])
                  (gen/return "</script>"))]
              [(get w [:element :alt 83] 100)
                (gen/tuple
                  (gen/return "<section")
                  (igen/freq :element [
                    [(get w [:element :alt 83 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 83 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:section-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 83 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 83 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 83 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 83 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</section>"))]
              [(get w [:element :alt 84] 100)
                (gen/tuple
                  (gen/return "<select")
                  (igen/freq :element [
                    [(get w [:element :alt 84 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 84 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:select-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 84 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 84 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 84 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 84 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</select>"))]
              [(get w [:element :alt 85] 100)
                (gen/tuple
                  (gen/return "<small")
                  (igen/freq :element [
                    [(get w [:element :alt 85 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 85 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:small-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 85 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 85 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 85 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 85 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</small>"))]
              [(get w [:element :alt 86] 100)
                (gen/tuple
                  (gen/return "<source")
                  (igen/freq :element [
                    [(get w [:element :alt 86 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 86 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:source-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 87] 100)
                (gen/tuple
                  (gen/return "<span")
                  (igen/freq :element [
                    [(get w [:element :alt 87 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 87 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:span-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 87 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 87 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 87 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 87 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</span>"))]
              [(get w [:element :alt 88] 100)
                (gen/tuple
                  (gen/return "<strong")
                  (igen/freq :element [
                    [(get w [:element :alt 88 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 88 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:strong-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 88 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 88 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 88 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 88 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</strong>"))]
              [(get w [:element :alt 89] 100)
                (gen/tuple
                  (gen/return "<style")
                  (igen/freq :element [
                    [(get w [:element :alt 89 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 89 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:style-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 89 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 89 :cat 3 :star 0] 100)
                      (igen/vector+
                        (:content g))]])
                  (gen/return "</style>"))]
              [(get w [:element :alt 90] 100)
                (gen/tuple
                  (gen/return "<sub")
                  (igen/freq :element [
                    [(get w [:element :alt 90 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 90 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:sub-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 90 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 90 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 90 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 90 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</sub>"))]
              [(get w [:element :alt 91] 100)
                (gen/tuple
                  (gen/return "<summary")
                  (igen/freq :element [
                    [(get w [:element :alt 91 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 91 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:summary-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 91 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 91 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 91 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 91 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</summary>"))]
              [(get w [:element :alt 92] 100)
                (gen/tuple
                  (gen/return "<sup")
                  (igen/freq :element [
                    [(get w [:element :alt 92 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 92 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:sup-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 92 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 92 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 92 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 92 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</sup>"))]
              [(get w [:element :alt 93] 100)
                (gen/tuple
                  (gen/return "<table")
                  (igen/freq :element [
                    [(get w [:element :alt 93 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 93 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:table-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 93 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 93 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 93 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 93 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</table>"))]
              [(get w [:element :alt 94] 100)
                (gen/tuple
                  (gen/return "<tbody")
                  (igen/freq :element [
                    [(get w [:element :alt 94 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 94 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:tbody-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 94 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 94 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 94 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 94 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</tbody>"))]
              [(get w [:element :alt 95] 100)
                (gen/tuple
                  (gen/return "<td")
                  (igen/freq :element [
                    [(get w [:element :alt 95 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 95 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:td-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 95 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 95 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 95 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 95 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</td>"))]
              [(get w [:element :alt 96] 100)
                (gen/tuple
                  (gen/return "<template")
                  (igen/freq :element [
                    [(get w [:element :alt 96 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 96 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:template-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 96 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 96 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 96 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 96 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</template>"))]
              [(get w [:element :alt 97] 100)
                (gen/tuple
                  (gen/return "<textarea")
                  (igen/freq :element [
                    [(get w [:element :alt 97 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 97 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:textarea-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 97 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 97 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 97 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 97 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</textarea>"))]
              [(get w [:element :alt 98] 100)
                (gen/tuple
                  (gen/return "<tfoot")
                  (igen/freq :element [
                    [(get w [:element :alt 98 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 98 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:tfoot-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 98 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 98 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 98 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 98 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</tfoot>"))]
              [(get w [:element :alt 99] 100)
                (gen/tuple
                  (gen/return "<th")
                  (igen/freq :element [
                    [(get w [:element :alt 99 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 99 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:th-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 99 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 99 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 99 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 99 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</th>"))]
              [(get w [:element :alt 100] 100)
                (gen/tuple
                  (gen/return "<thead")
                  (igen/freq :element [
                    [(get w [:element :alt 100 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 100 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:thead-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 100 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 100 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 100 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 100 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</thead>"))]
              [(get w [:element :alt 101] 100)
                (gen/tuple
                  (gen/return "<time")
                  (igen/freq :element [
                    [(get w [:element :alt 101 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 101 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:time-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 101 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 101 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 101 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 101 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</time>"))]
              [(get w [:element :alt 102] 100)
                (gen/tuple
                  (gen/return "<tr")
                  (igen/freq :element [
                    [(get w [:element :alt 102 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 102 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:tr-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 102 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 102 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 102 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 102 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</tr>"))]
              [(get w [:element :alt 103] 100)
                (gen/tuple
                  (gen/return "<track")
                  (igen/freq :element [
                    [(get w [:element :alt 103 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 103 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:track-attribute g)))]])
                  (gen/return ">"))]
              [(get w [:element :alt 104] 100)
                (gen/tuple
                  (gen/return "<u")
                  (igen/freq :element [
                    [(get w [:element :alt 104 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 104 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:u-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 104 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 104 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 104 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 104 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</u>"))]
              [(get w [:element :alt 105] 100)
                (gen/tuple
                  (gen/return "<ul")
                  (igen/freq :element [
                    [(get w [:element :alt 105 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 105 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:ul-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 105 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 105 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 105 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 105 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</ul>"))]
              [(get w [:element :alt 106] 100)
                (gen/tuple
                  (gen/return "<var")
                  (igen/freq :element [
                    [(get w [:element :alt 106 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 106 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:var-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 106 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 106 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 106 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 106 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</var>"))]
              [(get w [:element :alt 107] 100)
                (gen/tuple
                  (gen/return "<video")
                  (igen/freq :element [
                    [(get w [:element :alt 107 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 107 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:video-attribute g)))]])
                  (gen/return ">")
                  (igen/freq :element [
                    [(get w [:element :alt 107 :cat 3 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 107 :cat 3 :star 0] 100)
                      (igen/vector+
                        (igen/freq :element [
                          [(get w [:element :alt 107 :cat 3 :star 0 :alt 0] 100)
                            inner]
                          [(get w [:element :alt 107 :cat 3 :star 0 :alt 1] 100)
                            (:content g)]]))]])
                  (gen/return "</video>"))]
              [(get w [:element :alt 108] 100)
                (gen/tuple
                  (gen/return "<wbr")
                  (igen/freq :element [
                    [(get w [:element :alt 108 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:element :alt 108 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return " ")
                          (:wbr-attribute g)))]])
                  (gen/return ">"))]]))
          (igen/freq :element [
            [(get w [:element :alt 0] 100)
              (gen/tuple
                (gen/return "<a")
                (igen/freq :element [
                  [(get w [:element :alt 0 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 0 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:a-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 0 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 0 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</a>"))]
            [(get w [:element :alt 1] 100)
              (gen/tuple
                (gen/return "<abbr")
                (igen/freq :element [
                  [(get w [:element :alt 1 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 1 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:abbr-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 1 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 1 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</abbr>"))]
            [(get w [:element :alt 2] 100)
              (gen/tuple
                (gen/return "<address")
                (igen/freq :element [
                  [(get w [:element :alt 2 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 2 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:address-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 2 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 2 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</address>"))]
            [(get w [:element :alt 3] 100)
              (gen/tuple
                (gen/return "<area")
                (igen/freq :element [
                  [(get w [:element :alt 3 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 3 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:area-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 4] 100)
              (gen/tuple
                (gen/return "<article")
                (igen/freq :element [
                  [(get w [:element :alt 4 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 4 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:article-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 4 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 4 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</article>"))]
            [(get w [:element :alt 5] 100)
              (gen/tuple
                (gen/return "<aside")
                (igen/freq :element [
                  [(get w [:element :alt 5 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 5 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:aside-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 5 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 5 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</aside>"))]
            [(get w [:element :alt 6] 100)
              (gen/tuple
                (gen/return "<audio")
                (igen/freq :element [
                  [(get w [:element :alt 6 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 6 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:audio-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 6 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 6 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</audio>"))]
            [(get w [:element :alt 7] 100)
              (gen/tuple
                (gen/return "<b")
                (igen/freq :element [
                  [(get w [:element :alt 7 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 7 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:b-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 7 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 7 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</b>"))]
            [(get w [:element :alt 8] 100)
              (gen/tuple
                (gen/return "<base")
                (igen/freq :element [
                  [(get w [:element :alt 8 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 8 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:base-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 9] 100)
              (gen/tuple
                (gen/return "<bdi")
                (igen/freq :element [
                  [(get w [:element :alt 9 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 9 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:bdi-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 9 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 9 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</bdi>"))]
            [(get w [:element :alt 10] 100)
              (gen/tuple
                (gen/return "<bdo")
                (igen/freq :element [
                  [(get w [:element :alt 10 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 10 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:bdo-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 10 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 10 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</bdo>"))]
            [(get w [:element :alt 11] 100)
              (gen/tuple
                (gen/return "<blockquote")
                (igen/freq :element [
                  [(get w [:element :alt 11 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 11 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:blockquote-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 11 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 11 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</blockquote>"))]
            [(get w [:element :alt 12] 100)
              (gen/tuple
                (gen/return "<br")
                (igen/freq :element [
                  [(get w [:element :alt 12 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 12 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:br-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 13] 100)
              (gen/tuple
                (gen/return "<button")
                (igen/freq :element [
                  [(get w [:element :alt 13 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 13 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:button-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 13 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 13 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</button>"))]
            [(get w [:element :alt 14] 100)
              (gen/tuple
                (gen/return "<canvas")
                (igen/freq :element [
                  [(get w [:element :alt 14 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 14 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:canvas-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 14 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 14 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</canvas>"))]
            [(get w [:element :alt 15] 100)
              (gen/tuple
                (gen/return "<caption")
                (igen/freq :element [
                  [(get w [:element :alt 15 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 15 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:caption-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 15 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 15 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</caption>"))]
            [(get w [:element :alt 16] 100)
              (gen/tuple
                (gen/return "<cite")
                (igen/freq :element [
                  [(get w [:element :alt 16 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 16 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:cite-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 16 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 16 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</cite>"))]
            [(get w [:element :alt 17] 100)
              (gen/tuple
                (gen/return "<code")
                (igen/freq :element [
                  [(get w [:element :alt 17 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 17 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:code-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 17 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 17 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</code>"))]
            [(get w [:element :alt 18] 100)
              (gen/tuple
                (gen/return "<col")
                (igen/freq :element [
                  [(get w [:element :alt 18 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 18 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:col-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 19] 100)
              (gen/tuple
                (gen/return "<colgroup")
                (igen/freq :element [
                  [(get w [:element :alt 19 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 19 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:colgroup-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 19 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 19 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</colgroup>"))]
            [(get w [:element :alt 20] 100)
              (gen/tuple
                (gen/return "<data")
                (igen/freq :element [
                  [(get w [:element :alt 20 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 20 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:data-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 20 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 20 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</data>"))]
            [(get w [:element :alt 21] 100)
              (gen/tuple
                (gen/return "<datalist")
                (igen/freq :element [
                  [(get w [:element :alt 21 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 21 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:datalist-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 21 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 21 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</datalist>"))]
            [(get w [:element :alt 22] 100)
              (gen/tuple
                (gen/return "<dd")
                (igen/freq :element [
                  [(get w [:element :alt 22 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 22 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:dd-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 22 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 22 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</dd>"))]
            [(get w [:element :alt 23] 100)
              (gen/tuple
                (gen/return "<del")
                (igen/freq :element [
                  [(get w [:element :alt 23 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 23 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:del-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 23 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 23 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</del>"))]
            [(get w [:element :alt 24] 100)
              (gen/tuple
                (gen/return "<details")
                (igen/freq :element [
                  [(get w [:element :alt 24 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 24 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:details-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 24 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 24 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</details>"))]
            [(get w [:element :alt 25] 100)
              (gen/tuple
                (gen/return "<dfn")
                (igen/freq :element [
                  [(get w [:element :alt 25 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 25 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:dfn-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 25 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 25 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</dfn>"))]
            [(get w [:element :alt 26] 100)
              (gen/tuple
                (gen/return "<div")
                (igen/freq :element [
                  [(get w [:element :alt 26 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 26 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:div-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 26 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 26 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</div>"))]
            [(get w [:element :alt 27] 100)
              (gen/tuple
                (gen/return "<dl")
                (igen/freq :element [
                  [(get w [:element :alt 27 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 27 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:dl-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 27 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 27 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</dl>"))]
            [(get w [:element :alt 28] 100)
              (gen/tuple
                (gen/return "<dt")
                (igen/freq :element [
                  [(get w [:element :alt 28 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 28 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:dt-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 28 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 28 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</dt>"))]
            [(get w [:element :alt 29] 100)
              (gen/tuple
                (gen/return "<em")
                (igen/freq :element [
                  [(get w [:element :alt 29 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 29 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:em-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 29 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 29 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</em>"))]
            [(get w [:element :alt 30] 100)
              (gen/tuple
                (gen/return "<embed")
                (igen/freq :element [
                  [(get w [:element :alt 30 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 30 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:embed-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 31] 100)
              (gen/tuple
                (gen/return "<fieldset")
                (igen/freq :element [
                  [(get w [:element :alt 31 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 31 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:fieldset-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 31 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 31 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</fieldset>"))]
            [(get w [:element :alt 32] 100)
              (gen/tuple
                (gen/return "<figcaption")
                (igen/freq :element [
                  [(get w [:element :alt 32 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 32 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:figcaption-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 32 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 32 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</figcaption>"))]
            [(get w [:element :alt 33] 100)
              (gen/tuple
                (gen/return "<figure")
                (igen/freq :element [
                  [(get w [:element :alt 33 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 33 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:figure-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 33 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 33 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</figure>"))]
            [(get w [:element :alt 34] 100)
              (gen/tuple
                (gen/return "<footer")
                (igen/freq :element [
                  [(get w [:element :alt 34 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 34 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:footer-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 34 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 34 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</footer>"))]
            [(get w [:element :alt 35] 100)
              (gen/tuple
                (gen/return "<form")
                (igen/freq :element [
                  [(get w [:element :alt 35 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 35 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:form-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 35 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 35 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</form>"))]
            [(get w [:element :alt 36] 100)
              (gen/tuple
                (gen/return "<h1")
                (igen/freq :element [
                  [(get w [:element :alt 36 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 36 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h1-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 36 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 36 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h1>"))]
            [(get w [:element :alt 37] 100)
              (gen/tuple
                (gen/return "<h2")
                (igen/freq :element [
                  [(get w [:element :alt 37 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 37 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h2-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 37 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 37 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h2>"))]
            [(get w [:element :alt 38] 100)
              (gen/tuple
                (gen/return "<h3")
                (igen/freq :element [
                  [(get w [:element :alt 38 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 38 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h3-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 38 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 38 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h3>"))]
            [(get w [:element :alt 39] 100)
              (gen/tuple
                (gen/return "<h4")
                (igen/freq :element [
                  [(get w [:element :alt 39 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 39 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h4-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 39 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 39 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h4>"))]
            [(get w [:element :alt 40] 100)
              (gen/tuple
                (gen/return "<h5")
                (igen/freq :element [
                  [(get w [:element :alt 40 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 40 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h5-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 40 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 40 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h5>"))]
            [(get w [:element :alt 41] 100)
              (gen/tuple
                (gen/return "<h6")
                (igen/freq :element [
                  [(get w [:element :alt 41 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 41 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:h6-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 41 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 41 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</h6>"))]
            [(get w [:element :alt 42] 100)
              (gen/tuple
                (gen/return "<header")
                (igen/freq :element [
                  [(get w [:element :alt 42 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 42 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:header-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 42 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 42 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</header>"))]
            [(get w [:element :alt 43] 100)
              (gen/tuple
                (gen/return "<hr")
                (igen/freq :element [
                  [(get w [:element :alt 43 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 43 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:hr-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 44] 100)
              (gen/tuple
                (gen/return "<i")
                (igen/freq :element [
                  [(get w [:element :alt 44 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 44 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:i-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 44 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 44 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</i>"))]
            [(get w [:element :alt 45] 100)
              (gen/tuple
                (gen/return "<iframe")
                (igen/freq :element [
                  [(get w [:element :alt 45 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 45 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:iframe-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 45 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 45 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</iframe>"))]
            [(get w [:element :alt 46] 100)
              (gen/tuple
                (gen/return "<img")
                (igen/freq :element [
                  [(get w [:element :alt 46 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 46 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:img-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 47] 100)
              (gen/tuple
                (gen/return "<input")
                (igen/freq :element [
                  [(get w [:element :alt 47 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 47 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:input-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 48] 100)
              (gen/tuple
                (gen/return "<ins")
                (igen/freq :element [
                  [(get w [:element :alt 48 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 48 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:ins-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 48 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 48 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</ins>"))]
            [(get w [:element :alt 49] 100)
              (gen/tuple
                (gen/return "<kbd")
                (igen/freq :element [
                  [(get w [:element :alt 49 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 49 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:kbd-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 49 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 49 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</kbd>"))]
            [(get w [:element :alt 50] 100)
              (gen/tuple
                (gen/return "<keygen")
                (igen/freq :element [
                  [(get w [:element :alt 50 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 50 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:keygen-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 51] 100)
              (gen/tuple
                (gen/return "<label")
                (igen/freq :element [
                  [(get w [:element :alt 51 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 51 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:label-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 51 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 51 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</label>"))]
            [(get w [:element :alt 52] 100)
              (gen/tuple
                (gen/return "<legend")
                (igen/freq :element [
                  [(get w [:element :alt 52 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 52 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:legend-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 52 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 52 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</legend>"))]
            [(get w [:element :alt 53] 100)
              (gen/tuple
                (gen/return "<li")
                (igen/freq :element [
                  [(get w [:element :alt 53 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 53 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:li-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 53 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 53 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</li>"))]
            [(get w [:element :alt 54] 100)
              (gen/tuple
                (gen/return "<link")
                (igen/freq :element [
                  [(get w [:element :alt 54 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 54 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:link-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 55] 100)
              (gen/tuple
                (gen/return "<main")
                (igen/freq :element [
                  [(get w [:element :alt 55 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 55 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:main-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 55 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 55 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</main>"))]
            [(get w [:element :alt 56] 100)
              (gen/tuple
                (gen/return "<map")
                (igen/freq :element [
                  [(get w [:element :alt 56 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 56 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:map-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 56 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 56 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</map>"))]
            [(get w [:element :alt 57] 100)
              (gen/tuple
                (gen/return "<mark")
                (igen/freq :element [
                  [(get w [:element :alt 57 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 57 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:mark-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 57 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 57 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</mark>"))]
            [(get w [:element :alt 58] 100)
              (gen/tuple
                (gen/return "<menu")
                (igen/freq :element [
                  [(get w [:element :alt 58 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 58 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:menu-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 58 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 58 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</menu>"))]
            [(get w [:element :alt 59] 100)
              (gen/tuple
                (gen/return "<menuitem")
                (igen/freq :element [
                  [(get w [:element :alt 59 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 59 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:menuitem-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 60] 100)
              (gen/tuple
                (gen/return "<meta")
                (igen/freq :element [
                  [(get w [:element :alt 60 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 60 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:meta-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 61] 100)
              (gen/tuple
                (gen/return "<meter")
                (igen/freq :element [
                  [(get w [:element :alt 61 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 61 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:meter-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 61 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 61 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</meter>"))]
            [(get w [:element :alt 62] 100)
              (gen/tuple
                (gen/return "<nav")
                (igen/freq :element [
                  [(get w [:element :alt 62 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 62 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:nav-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 62 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 62 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</nav>"))]
            [(get w [:element :alt 63] 100)
              (gen/tuple
                (gen/return "<noscript")
                (igen/freq :element [
                  [(get w [:element :alt 63 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 63 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:noscript-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 63 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 63 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</noscript>"))]
            [(get w [:element :alt 64] 100)
              (gen/tuple
                (gen/return "<object")
                (igen/freq :element [
                  [(get w [:element :alt 64 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 64 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:object-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 64 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 64 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</object>"))]
            [(get w [:element :alt 65] 100)
              (gen/tuple
                (gen/return "<ol")
                (igen/freq :element [
                  [(get w [:element :alt 65 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 65 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:ol-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 65 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 65 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</ol>"))]
            [(get w [:element :alt 66] 100)
              (gen/tuple
                (gen/return "<optgroup")
                (igen/freq :element [
                  [(get w [:element :alt 66 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 66 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:optgroup-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 66 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 66 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</optgroup>"))]
            [(get w [:element :alt 67] 100)
              (gen/tuple
                (gen/return "<option")
                (igen/freq :element [
                  [(get w [:element :alt 67 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 67 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:option-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 67 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 67 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</option>"))]
            [(get w [:element :alt 68] 100)
              (gen/tuple
                (gen/return "<output")
                (igen/freq :element [
                  [(get w [:element :alt 68 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 68 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:output-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 68 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 68 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</output>"))]
            [(get w [:element :alt 69] 100)
              (gen/tuple
                (gen/return "<p")
                (igen/freq :element [
                  [(get w [:element :alt 69 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 69 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:p-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 69 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 69 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</p>"))]
            [(get w [:element :alt 70] 100)
              (gen/tuple
                (gen/return "<param")
                (igen/freq :element [
                  [(get w [:element :alt 70 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 70 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:param-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 71] 100)
              (gen/tuple
                (gen/return "<picture")
                (igen/freq :element [
                  [(get w [:element :alt 71 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 71 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:picture-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 71 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 71 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</picture>"))]
            [(get w [:element :alt 72] 100)
              (gen/tuple
                (gen/return "<pre")
                (igen/freq :element [
                  [(get w [:element :alt 72 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 72 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:pre-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 72 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 72 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</pre>"))]
            [(get w [:element :alt 73] 100)
              (gen/tuple
                (gen/return "<progress")
                (igen/freq :element [
                  [(get w [:element :alt 73 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 73 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:progress-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 73 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 73 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</progress>"))]
            [(get w [:element :alt 74] 100)
              (gen/tuple
                (gen/return "<q")
                (igen/freq :element [
                  [(get w [:element :alt 74 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 74 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:q-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 74 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 74 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</q>"))]
            [(get w [:element :alt 75] 100)
              (gen/tuple
                (gen/return "<rb")
                (igen/freq :element [
                  [(get w [:element :alt 75 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 75 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:rb-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 75 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 75 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</rb>"))]
            [(get w [:element :alt 76] 100)
              (gen/tuple
                (gen/return "<rp")
                (igen/freq :element [
                  [(get w [:element :alt 76 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 76 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:rp-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 76 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 76 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</rp>"))]
            [(get w [:element :alt 77] 100)
              (gen/tuple
                (gen/return "<rt")
                (igen/freq :element [
                  [(get w [:element :alt 77 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 77 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:rt-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 77 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 77 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</rt>"))]
            [(get w [:element :alt 78] 100)
              (gen/tuple
                (gen/return "<rtc")
                (igen/freq :element [
                  [(get w [:element :alt 78 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 78 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:rtc-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 78 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 78 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</rtc>"))]
            [(get w [:element :alt 79] 100)
              (gen/tuple
                (gen/return "<ruby")
                (igen/freq :element [
                  [(get w [:element :alt 79 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 79 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:ruby-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 79 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 79 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</ruby>"))]
            [(get w [:element :alt 80] 100)
              (gen/tuple
                (gen/return "<s")
                (igen/freq :element [
                  [(get w [:element :alt 80 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 80 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:s-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 80 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 80 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</s>"))]
            [(get w [:element :alt 81] 100)
              (gen/tuple
                (gen/return "<samp")
                (igen/freq :element [
                  [(get w [:element :alt 81 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 81 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:samp-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 81 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 81 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</samp>"))]
            [(get w [:element :alt 82] 100)
              (gen/tuple
                (gen/return "<script")
                (igen/freq :element [
                  [(get w [:element :alt 82 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 82 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:script-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 82 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 82 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</script>"))]
            [(get w [:element :alt 83] 100)
              (gen/tuple
                (gen/return "<section")
                (igen/freq :element [
                  [(get w [:element :alt 83 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 83 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:section-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 83 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 83 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</section>"))]
            [(get w [:element :alt 84] 100)
              (gen/tuple
                (gen/return "<select")
                (igen/freq :element [
                  [(get w [:element :alt 84 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 84 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:select-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 84 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 84 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</select>"))]
            [(get w [:element :alt 85] 100)
              (gen/tuple
                (gen/return "<small")
                (igen/freq :element [
                  [(get w [:element :alt 85 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 85 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:small-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 85 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 85 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</small>"))]
            [(get w [:element :alt 86] 100)
              (gen/tuple
                (gen/return "<source")
                (igen/freq :element [
                  [(get w [:element :alt 86 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 86 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:source-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 87] 100)
              (gen/tuple
                (gen/return "<span")
                (igen/freq :element [
                  [(get w [:element :alt 87 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 87 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:span-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 87 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 87 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</span>"))]
            [(get w [:element :alt 88] 100)
              (gen/tuple
                (gen/return "<strong")
                (igen/freq :element [
                  [(get w [:element :alt 88 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 88 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:strong-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 88 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 88 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</strong>"))]
            [(get w [:element :alt 89] 100)
              (gen/tuple
                (gen/return "<style")
                (igen/freq :element [
                  [(get w [:element :alt 89 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 89 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:style-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 89 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 89 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</style>"))]
            [(get w [:element :alt 90] 100)
              (gen/tuple
                (gen/return "<sub")
                (igen/freq :element [
                  [(get w [:element :alt 90 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 90 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:sub-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 90 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 90 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</sub>"))]
            [(get w [:element :alt 91] 100)
              (gen/tuple
                (gen/return "<summary")
                (igen/freq :element [
                  [(get w [:element :alt 91 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 91 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:summary-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 91 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 91 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</summary>"))]
            [(get w [:element :alt 92] 100)
              (gen/tuple
                (gen/return "<sup")
                (igen/freq :element [
                  [(get w [:element :alt 92 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 92 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:sup-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 92 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 92 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</sup>"))]
            [(get w [:element :alt 93] 100)
              (gen/tuple
                (gen/return "<table")
                (igen/freq :element [
                  [(get w [:element :alt 93 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 93 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:table-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 93 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 93 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</table>"))]
            [(get w [:element :alt 94] 100)
              (gen/tuple
                (gen/return "<tbody")
                (igen/freq :element [
                  [(get w [:element :alt 94 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 94 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:tbody-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 94 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 94 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</tbody>"))]
            [(get w [:element :alt 95] 100)
              (gen/tuple
                (gen/return "<td")
                (igen/freq :element [
                  [(get w [:element :alt 95 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 95 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:td-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 95 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 95 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</td>"))]
            [(get w [:element :alt 96] 100)
              (gen/tuple
                (gen/return "<template")
                (igen/freq :element [
                  [(get w [:element :alt 96 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 96 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:template-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 96 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 96 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</template>"))]
            [(get w [:element :alt 97] 100)
              (gen/tuple
                (gen/return "<textarea")
                (igen/freq :element [
                  [(get w [:element :alt 97 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 97 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:textarea-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 97 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 97 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</textarea>"))]
            [(get w [:element :alt 98] 100)
              (gen/tuple
                (gen/return "<tfoot")
                (igen/freq :element [
                  [(get w [:element :alt 98 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 98 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:tfoot-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 98 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 98 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</tfoot>"))]
            [(get w [:element :alt 99] 100)
              (gen/tuple
                (gen/return "<th")
                (igen/freq :element [
                  [(get w [:element :alt 99 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 99 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:th-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 99 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 99 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</th>"))]
            [(get w [:element :alt 100] 100)
              (gen/tuple
                (gen/return "<thead")
                (igen/freq :element [
                  [(get w [:element :alt 100 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 100 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:thead-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 100 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 100 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</thead>"))]
            [(get w [:element :alt 101] 100)
              (gen/tuple
                (gen/return "<time")
                (igen/freq :element [
                  [(get w [:element :alt 101 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 101 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:time-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 101 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 101 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</time>"))]
            [(get w [:element :alt 102] 100)
              (gen/tuple
                (gen/return "<tr")
                (igen/freq :element [
                  [(get w [:element :alt 102 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 102 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:tr-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 102 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 102 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</tr>"))]
            [(get w [:element :alt 103] 100)
              (gen/tuple
                (gen/return "<track")
                (igen/freq :element [
                  [(get w [:element :alt 103 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 103 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:track-attribute g)))]])
                (gen/return ">"))]
            [(get w [:element :alt 104] 100)
              (gen/tuple
                (gen/return "<u")
                (igen/freq :element [
                  [(get w [:element :alt 104 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 104 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:u-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 104 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 104 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</u>"))]
            [(get w [:element :alt 105] 100)
              (gen/tuple
                (gen/return "<ul")
                (igen/freq :element [
                  [(get w [:element :alt 105 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 105 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:ul-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 105 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 105 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</ul>"))]
            [(get w [:element :alt 106] 100)
              (gen/tuple
                (gen/return "<var")
                (igen/freq :element [
                  [(get w [:element :alt 106 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 106 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:var-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 106 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 106 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</var>"))]
            [(get w [:element :alt 107] 100)
              (gen/tuple
                (gen/return "<video")
                (igen/freq :element [
                  [(get w [:element :alt 107 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 107 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:video-attribute g)))]])
                (gen/return ">")
                (igen/freq :element [
                  [(get w [:element :alt 107 :cat 3 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 107 :cat 3 :star 0] 100)
                    (igen/vector+
                      (:content g))]])
                (gen/return "</video>"))]
            [(get w [:element :alt 108] 100)
              (gen/tuple
                (gen/return "<wbr")
                (igen/freq :element [
                  [(get w [:element :alt 108 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:element :alt 108 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return " ")
                        (:wbr-attribute g)))]])
                (gen/return ">"))]]))
        g (assoc g :element gen-element)

        gen-body
        (gen/tuple
          (gen/return "<body")
          (igen/freq :body [
            [(get w [:body :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:body :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:body-attribute g)))]])
          (gen/return ">")
          (igen/freq :body [
            [(get w [:body :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:body :cat 3 :star 0] 100)
              (igen/vector+
                (igen/freq :body [
                  [(get w [:body :cat 3 :star 0 :alt 0] 100)
                    (:element g)]
                  [(get w [:body :cat 3 :star 0 :alt 1] 100)
                    (:content g)]]))]])
          (gen/return "</body> "))
        g (assoc g :body gen-body)]
    g))

(defn- html5-generators-part-7 [gmap weights]
  (let [g gmap
        w weights

        gen-title-attribute
        (:global-attribute g)
        g (assoc g :title-attribute gen-title-attribute)

        gen-html-attribute
        (igen/freq :html-attribute [
          [(get w [:html-attribute :alt 0] 100)
            (gen/tuple
              (gen/return "xmlns=\"")
              (:url g)
              (gen/return "\""))]
          [(get w [:html-attribute :alt 1] 100)
            (gen/tuple
              (gen/return "xml:lang=\"")
              (:lang g)
              (gen/return "\""))]
          [(get w [:html-attribute :alt 2] 100)
            (gen/tuple
              (gen/return "prefix=\"")
              (chuck/string-from-regex #"[^\"]*")
              (gen/return "\""))]
          [(get w [:html-attribute :alt 3] 100)
            (:global-attribute g)]])
        g (assoc g :html-attribute gen-html-attribute)

        gen-link
        (gen/tuple
          (gen/return "<link")
          (igen/freq :link [
            [(get w [:link :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:link :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:link-attribute g)))]])
          (gen/return "> "))
        g (assoc g :link gen-link)

        gen-title
        (gen/tuple
          (gen/return "<title")
          (igen/freq :title [
            [(get w [:title :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:title :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:title-attribute g)))]])
          (gen/return ">")
          (igen/freq :title [
            [(get w [:title :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:title :cat 3 :star 0] 100)
              (igen/vector+
                (:char-data g))]])
          (gen/return "</title> "))
        g (assoc g :title gen-title)

        gen-meta
        (gen/tuple
          (gen/return "<meta")
          (igen/freq :meta [
            [(get w [:meta :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:meta :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:meta-attribute g)))]])
          (gen/return "> "))
        g (assoc g :meta gen-meta)

        gen-head-elements
        (igen/freq :head-elements [
          [(get w [:head-elements :alt 0] 100)
            (:title g)]
          [(get w [:head-elements :alt 1] 100)
            (:meta g)]
          [(get w [:head-elements :alt 2] 100)
            (:link g)]
          [(get w [:head-elements :alt 3] 100)
            (:comment-or-space g)]])
        g (assoc g :head-elements gen-head-elements)

        gen-head
        (gen/tuple
          (gen/return "<head>")
          (gen/return " ")
          (igen/freq :head [
            [(get w [:head :cat 2 :star nil] 100)
              (gen/return "")]
            [(get w [:head :cat 2 :star 0] 100)
              (igen/vector+
                (:head-elements g))]])
          (gen/return "</head> "))
        g (assoc g :head gen-head)

        gen-html
        (gen/tuple
          (igen/freq :html [
            [(get w [:html :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:html :cat 0 :opt 0] 100)
              (:doctype g)]])
          (igen/freq :html [
            [(get w [:html :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:html :cat 1 :star 0] 100)
              (igen/vector+
                (:comment-or-space g))]])
          (gen/return "<html")
          (igen/freq :html [
            [(get w [:html :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:html :cat 3 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:html-attribute g)))]])
          (gen/return ">")
          (gen/return " ")
          (igen/freq :html [
            [(get w [:html :cat 6 :opt nil] 100)
              (gen/return "")]
            [(get w [:html :cat 6 :opt 0] 100)
              (:head g)]])
          (:body g)
          (gen/return "</html> "))
        g (assoc g :html gen-html)

        gen-S
        (igen/freq :S [
          [(get w [:S :star nil] 100)
            (gen/return "")]
          [(get w [:S :star 0] 100)
            (igen/vector+
              (chuck/string-from-regex #"\s"))]])
        g (assoc g :S gen-S)

        gen-quoted-string
        (igen/freq :quoted-string [
          [(get w [:quoted-string :alt 0] 100)
            (gen/tuple
              (chuck/string-from-regex #"'[\"A-Za-z0-9 .,_:/%=#?+\-^]*'")
              (gen/return " "))]
          [(get w [:quoted-string :alt 1] 100)
            (gen/tuple
              (chuck/string-from-regex #"\"['A-Za-z0-9 .,_:/%=#?+\-^]*\"")
              (gen/return " "))]])
        g (assoc g :quoted-string gen-quoted-string)

        gen-comment-test
        (chuck/string-from-regex #"<!--(?:[A-Za-z0-9_<>/\\ .]|-[A-Za-z0-9_<>/\\ .])*-->")
        g (assoc g :comment-test gen-comment-test)

        gen-rend-css
        (gen/return "<link rel=\"stylesheet\" href=\"/static/rend.css\">")
        g (assoc g :rend-css gen-rend-css)

        gen-entity-ref
        (gen/tuple
          (gen/return "&")
          (:name g)
          (gen/return ";"))
        g (assoc g :entity-ref gen-entity-ref)

        gen-normalize-css
        (gen/return "<link rel=\"stylesheet\" href=\"/static/normalize.css\">")
        g (assoc g :normalize-css gen-normalize-css)

        gen-body-test
        (gen/tuple
          (gen/return "<body")
          (igen/freq :body-test [
            [(get w [:body-test :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:body-test :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:body-attribute g)))]])
          (gen/return ">")
          (gen/return "x")
          (igen/freq :body-test [
            [(get w [:body-test :cat 4 :star nil] 100)
              (gen/return "")]
            [(get w [:body-test :cat 4 :star 0] 100)
              (igen/vector+
                (igen/freq :body-test [
                  [(get w [:body-test :cat 4 :star 0 :alt 0] 100)
                    (:element g)]
                  [(get w [:body-test :cat 4 :star 0 :alt 1] 100)
                    (:content g)]]))]])
          (gen/return "</body>"))
        g (assoc g :body-test gen-body-test)

        gen-title-test
        (gen/tuple
          (gen/return "<title")
          (igen/freq :title-test [
            [(get w [:title-test :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:title-test :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return " ")
                  (:title-attribute g)))]])
          (gen/return ">")
          (igen/freq :title-test [
            [(get w [:title-test :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:title-test :cat 3 :star 0] 100)
              (igen/vector+
                (:content g))]])
          (gen/return "</title>"))
        g (assoc g :title-test gen-title-test)

        gen-head-test
        (gen/tuple
          (gen/return "<head>")
          (:normalize-css g)
          (:rend-css g)
          (igen/freq :head-test [
            [(get w [:head-test :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:head-test :cat 3 :opt 0] 100)
              (:title-test g)]])
          (gen/return "</head>"))
        g (assoc g :head-test gen-head-test)

        gen-html-test
        (gen/tuple
          (gen/return "<!DOCTYPE html><html>")
          (:head-test g)
          (:body-test g)
          (gen/return "</html>"))
        g (assoc g :html-test gen-html-test)

        gen-charset
        (igen/freq :charset [
          [(get w [:charset :alt 0] 100)
            (gen/return "UTF-8")]
          [(get w [:charset :alt 1] 100)
            (gen/return "utf-8")]
          [(get w [:charset :alt 2] 100)
            (gen/return "iso-8859-15")]])
        g (assoc g :charset gen-charset)

        gen-rS
        (gen/tuple (gen/return " "))
        g (assoc g :rS gen-rS)

        gen-head-attribute
        (:global-attribute g)
        g (assoc g :head-attribute gen-head-attribute)

        gen-positive-integer
        gen/s-pos-int
        g (assoc g :positive-integer gen-positive-integer)

        gen-char-ref-dec
        (chuck/string-from-regex #"&#[0-9]{1,7};")
        g (assoc g :char-ref-dec gen-char-ref-dec)

        gen-char-ref-hex
        (chuck/string-from-regex #"&#x[0-9A-Fa-f]{1,6};")
        g (assoc g :char-ref-hex gen-char-ref-hex)]
    g))

(defn html5-generators [& [gmap weights]]
  (let [g (or gmap {})
        w weights

        g (html5-generators-part-0 g weights)
        g (html5-generators-part-1 g weights)
        g (html5-generators-part-2 g weights)
        g (html5-generators-part-3 g weights)
        g (html5-generators-part-4 g weights)
        g (html5-generators-part-5 g weights)
        g (html5-generators-part-6 g weights)
        g (html5-generators-part-7 g weights)]
    g))