(ns rend.css3-generators
  (:require [clojure.test.check.generators :as gen]
            [com.gfredericks.test.chuck.generators :as chuck]
            [instacheck.generators :as igen]
            [rend.misc-generators :as rgen]
            [instacheck.util :as util]))

;; Generated by instacheck

(defn- css3-generators-part-0 [gmap weights]
  (let [g gmap
        w weights

        gen-nonprop-single-animation-direction
        (igen/freq :nonprop-single-animation-direction [
          [(get w [:nonprop-single-animation-direction :alt 0] 100)
            (gen/return "normal ")]
          [(get w [:nonprop-single-animation-direction :alt 1] 100)
            (gen/return "reverse ")]
          [(get w [:nonprop-single-animation-direction :alt 2] 100)
            (gen/return "alternate ")]
          [(get w [:nonprop-single-animation-direction :alt 3] 100)
            (gen/return "alternate-reverse ")]])
        g (assoc g :nonprop-single-animation-direction gen-nonprop-single-animation-direction)

        gen-integer
        gen/int
        g (assoc g :integer gen-integer)

        gen-floating-point-number
        rgen/floating-point-number
        g (assoc g :floating-point-number gen-floating-point-number)

        gen-any-number
        (igen/freq :any-number [
          [(get w [:any-number :alt 0] 100)
            (:integer g)]
          [(get w [:any-number :alt 1] 100)
            (:floating-point-number g)]])
        g (assoc g :any-number gen-any-number)

        gen-nonprop-angle
        (gen/tuple
          (:any-number g)
          (igen/freq :nonprop-angle [
            [(get w [:nonprop-angle :cat 1 :alt 0] 100)
              (gen/return "deg")]
            [(get w [:nonprop-angle :cat 1 :alt 1] 100)
              (gen/return "grad")]
            [(get w [:nonprop-angle :cat 1 :alt 2] 100)
              (gen/return "rad")]
            [(get w [:nonprop-angle :cat 1 :alt 3] 100)
              (gen/return "turn")]]))
        g (assoc g :nonprop-angle gen-nonprop-angle)

        gen-func-skew
        (gen/tuple
          (gen/return "skew ")
          (gen/return "( ")
          (:nonprop-angle g)
          (igen/freq :func-skew [
            [(get w [:func-skew :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-skew :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return ", ")
                (:nonprop-angle g))]])
          (gen/return ") "))
        g (assoc g :func-skew gen-func-skew)

        gen-nonprop-combinator
        (igen/freq :nonprop-combinator [
          [(get w [:nonprop-combinator :alt 0] 100)
            (gen/return "> ")]
          [(get w [:nonprop-combinator :alt 1] 100)
            (gen/return "+ ")]
          [(get w [:nonprop-combinator :alt 2] 100)
            (gen/return "~ ")]
          [(get w [:nonprop-combinator :alt 3] 100)
            (gen/return "|| ")]])
        g (assoc g :nonprop-combinator gen-nonprop-combinator)

        gen-length-unit
        (igen/freq :length-unit [
          [(get w [:length-unit :alt 0] 100)
            (gen/return "em")]
          [(get w [:length-unit :alt 1] 100)
            (gen/return "ex")]
          [(get w [:length-unit :alt 2] 100)
            (gen/return "ch")]
          [(get w [:length-unit :alt 3] 100)
            (gen/return "ic")]
          [(get w [:length-unit :alt 4] 100)
            (gen/return "rem")]
          [(get w [:length-unit :alt 5] 100)
            (gen/return "lh")]
          [(get w [:length-unit :alt 6] 100)
            (gen/return "rlh")]
          [(get w [:length-unit :alt 7] 100)
            (gen/return "vh")]
          [(get w [:length-unit :alt 8] 100)
            (gen/return "vw")]
          [(get w [:length-unit :alt 9] 100)
            (gen/return "vi")]
          [(get w [:length-unit :alt 10] 100)
            (gen/return "vb")]
          [(get w [:length-unit :alt 11] 100)
            (gen/return "vmin")]
          [(get w [:length-unit :alt 12] 100)
            (gen/return "vmax")]
          [(get w [:length-unit :alt 13] 100)
            (gen/return "px")]
          [(get w [:length-unit :alt 14] 100)
            (gen/return "mm")]
          [(get w [:length-unit :alt 15] 100)
            (gen/return "q")]
          [(get w [:length-unit :alt 16] 100)
            (gen/return "cm")]
          [(get w [:length-unit :alt 17] 100)
            (gen/return "in")]
          [(get w [:length-unit :alt 18] 100)
            (gen/return "pt")]
          [(get w [:length-unit :alt 19] 100)
            (gen/return "pc")]
          [(get w [:length-unit :alt 20] 100)
            (gen/return "mozmm")]])
        g (assoc g :length-unit gen-length-unit)

        gen-nonprop-length
        (igen/freq :nonprop-length [
          [(get w [:nonprop-length :alt 0] 100)
            (gen/tuple
              (:any-number g)
              (:length-unit g)
              (gen/return " "))]
          [(get w [:nonprop-length :alt 1] 100)
            (gen/return "0 ")]])
        g (assoc g :nonprop-length gen-nonprop-length)

        gen-nonprop-percentage
        (gen/tuple
          (:any-number g)
          (gen/return "% "))
        g (assoc g :nonprop-percentage gen-nonprop-percentage)

        gen-nonprop-length-percentage
        (igen/freq :nonprop-length-percentage [
          [(get w [:nonprop-length-percentage :alt 0] 100)
            (:nonprop-length g)]
          [(get w [:nonprop-length-percentage :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-length-percentage gen-nonprop-length-percentage)

        gen-nonprop-bg-position
        (igen/freq :nonprop-bg-position [
          [(get w [:nonprop-bg-position :alt 0] 100)
            (igen/freq :nonprop-bg-position [
              [(get w [:nonprop-bg-position :alt 0 :alt 0] 100)
                (gen/return "left ")]
              [(get w [:nonprop-bg-position :alt 0 :alt 1] 100)
                (gen/return "center ")]
              [(get w [:nonprop-bg-position :alt 0 :alt 2] 100)
                (gen/return "right ")]
              [(get w [:nonprop-bg-position :alt 0 :alt 3] 100)
                (gen/return "top ")]
              [(get w [:nonprop-bg-position :alt 0 :alt 4] 100)
                (gen/return "bottom ")]
              [(get w [:nonprop-bg-position :alt 0 :alt 5] 100)
                (:nonprop-length-percentage g)]])]
          [(get w [:nonprop-bg-position :alt 1] 100)
            (gen/tuple
              (igen/freq :nonprop-bg-position [
                [(get w [:nonprop-bg-position :alt 1 :cat 0 :alt 0] 100)
                  (gen/return "left ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 0 :alt 1] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 0 :alt 2] 100)
                  (gen/return "right ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 0 :alt 3] 100)
                  (:nonprop-length-percentage g)]])
              (igen/freq :nonprop-bg-position [
                [(get w [:nonprop-bg-position :alt 1 :cat 1 :alt 0] 100)
                  (gen/return "top ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 1 :alt 1] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 1 :alt 2] 100)
                  (gen/return "bottom ")]
                [(get w [:nonprop-bg-position :alt 1 :cat 1 :alt 3] 100)
                  (:nonprop-length-percentage g)]]))]
          [(get w [:nonprop-bg-position :alt 2] 100)
            (gen/tuple
              (igen/freq :nonprop-bg-position [
                [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 0] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 1] 100)
                  (gen/tuple
                    (igen/freq :nonprop-bg-position [
                      [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 1 :cat 0 :alt 0] 100)
                        (gen/return "left ")]
                      [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 1 :cat 0 :alt 1] 100)
                        (gen/return "right ")]])
                    (igen/freq :nonprop-bg-position [
                      [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 1 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:nonprop-bg-position :alt 2 :cat 0 :alt 1 :cat 1 :opt 0] 100)
                        (:nonprop-length-percentage g)]]))]])
              (igen/freq :nonprop-bg-position [
                [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 0] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 1] 100)
                  (gen/tuple
                    (igen/freq :nonprop-bg-position [
                      [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 1 :cat 0 :alt 0] 100)
                        (gen/return "top ")]
                      [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 1 :cat 0 :alt 1] 100)
                        (gen/return "bottom ")]])
                    (igen/freq :nonprop-bg-position [
                      [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 1 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:nonprop-bg-position :alt 2 :cat 1 :alt 1 :cat 1 :opt 0] 100)
                        (:nonprop-length-percentage g)]]))]]))]])
        g (assoc g :nonprop-bg-position gen-nonprop-bg-position)

        gen-nonprop-suffix
        (gen/return "STUB_suffix")
        g (assoc g :nonprop-suffix gen-nonprop-suffix)

        gen-prop-all
        (igen/freq :prop-all [
          [(get w [:prop-all :alt 0] 100)
            (gen/return "initial ")]
          [(get w [:prop-all :alt 1] 100)
            (gen/return "inherit ")]
          [(get w [:prop-all :alt 2] 100)
            (gen/return "unset ")]
          [(get w [:prop-all :alt 3] 100)
            (gen/return "revert ")]])
        g (assoc g :prop-all gen-prop-all)

        gen-prop-padding-left
        (igen/freq :prop-padding-left [
          [(get w [:prop-padding-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-left :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-padding-left :alt 2] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-padding-left gen-prop-padding-left)

        gen-prop-padding-block-start
        (igen/freq :prop-padding-block-start [
          [(get w [:prop-padding-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-block-start :alt 1] 100)
            (:prop-padding-left g)]])
        g (assoc g :prop-padding-block-start gen-prop-padding-block-start)

        gen-prop-image-rendering
        (igen/freq :prop-image-rendering [
          [(get w [:prop-image-rendering :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-image-rendering :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-image-rendering :alt 2] 100)
            (gen/return "crisp-edges ")]
          [(get w [:prop-image-rendering :alt 3] 100)
            (gen/return "pixelated ")]])
        g (assoc g :prop-image-rendering gen-prop-image-rendering)

        gen-prop-right
        (igen/freq :prop-right [
          [(get w [:prop-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-right :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-right :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-right :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-right gen-prop-right)

        gen-prop-bottom
        (igen/freq :prop-bottom [
          [(get w [:prop-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-bottom :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-bottom :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-bottom :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-bottom gen-prop-bottom)

        gen-nonprop-bottom
        (:prop-bottom g)
        g (assoc g :nonprop-bottom gen-nonprop-bottom)

        gen-prop-left
        (igen/freq :prop-left [
          [(get w [:prop-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-left :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-left :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-left :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-left gen-prop-left)

        gen-prop-top
        (igen/freq :prop-top [
          [(get w [:prop-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-top :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-top :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-top :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-top gen-prop-top)

        gen-nonprop-left
        (:prop-left g)
        g (assoc g :nonprop-left gen-nonprop-left)

        gen-nonprop-top
        (:prop-top g)
        g (assoc g :nonprop-top gen-nonprop-top)

        gen-nonprop-right
        (:prop-right g)
        g (assoc g :nonprop-right gen-nonprop-right)

        gen-nonprop-shape
        (igen/freq :nonprop-shape [
          [(get w [:nonprop-shape :alt 0] 100)
            (gen/tuple
              (gen/return "rect ")
              (gen/return "( ")
              (:nonprop-top g)
              (gen/return ",")
              (gen/return " ")
              (:nonprop-right g)
              (gen/return ", ")
              (:nonprop-bottom g)
              (gen/return ", ")
              (:nonprop-left g)
              (gen/return ") "))]
          [(get w [:nonprop-shape :alt 1] 100)
            (gen/tuple
              (gen/return "rect ")
              (gen/return "( ")
              (:nonprop-top g)
              (:nonprop-right g)
              (:nonprop-bottom g)
              (:nonprop-left g)
              (gen/return ") "))]])
        g (assoc g :nonprop-shape gen-nonprop-shape)

        gen-prop-clip
        (igen/freq :prop-clip [
          [(get w [:prop-clip :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-clip :alt 1] 100)
            (:nonprop-shape g)]
          [(get w [:prop-clip :alt 2] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-clip gen-prop-clip)

        gen-nonprop-number
        (gen/tuple
          (:any-number g)
          (gen/return " "))
        g (assoc g :nonprop-number gen-nonprop-number)

        gen-nonprop-alpha-value
        (igen/freq :nonprop-alpha-value [
          [(get w [:nonprop-alpha-value :alt 0] 100)
            (:nonprop-number g)]
          [(get w [:nonprop-alpha-value :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-alpha-value gen-nonprop-alpha-value)

        gen-nonprop-hue
        (igen/freq :nonprop-hue [
          [(get w [:nonprop-hue :alt 0] 100)
            (:nonprop-number g)]
          [(get w [:nonprop-hue :alt 1] 100)
            (:nonprop-angle g)]])
        g (assoc g :nonprop-hue gen-nonprop-hue)

        gen-func-hsl
        (igen/freq :func-hsl [
          [(get w [:func-hsl :alt 0] 100)
            (gen/tuple
              (gen/return "hsl ")
              (gen/return "( ")
              (:nonprop-hue g)
              (:nonprop-percentage g)
              (:nonprop-percentage g)
              (igen/freq :func-hsl [
                [(get w [:func-hsl :alt 0 :cat 5 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-hsl :alt 0 :cat 5 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-hsl :alt 1] 100)
            (gen/tuple
              (gen/return "hsl ")
              (gen/return "( ")
              (:nonprop-hue g)
              (gen/return ", ")
              (:nonprop-percentage g)
              (gen/return ", ")
              (:nonprop-percentage g)
              (gen/return ", ")
              (igen/freq :func-hsl [
                [(get w [:func-hsl :alt 1 :cat 8 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-hsl :alt 1 :cat 8 :opt 0] 100)
                  (:nonprop-alpha-value g)]])
              (gen/return ") "))]])
        g (assoc g :func-hsl gen-func-hsl)

        gen-nonprop-deprecated-system-color
        (igen/freq :nonprop-deprecated-system-color [
          [(get w [:nonprop-deprecated-system-color :alt 0] 100)
            (gen/return "ActiveBorder ")]
          [(get w [:nonprop-deprecated-system-color :alt 1] 100)
            (gen/return "ActiveCaption ")]
          [(get w [:nonprop-deprecated-system-color :alt 2] 100)
            (gen/return "AppWorkspace ")]
          [(get w [:nonprop-deprecated-system-color :alt 3] 100)
            (gen/return "Background ")]
          [(get w [:nonprop-deprecated-system-color :alt 4] 100)
            (gen/return "ButtonFace ")]
          [(get w [:nonprop-deprecated-system-color :alt 5] 100)
            (gen/return "ButtonHighlight ")]
          [(get w [:nonprop-deprecated-system-color :alt 6] 100)
            (gen/return "ButtonShadow ")]
          [(get w [:nonprop-deprecated-system-color :alt 7] 100)
            (gen/return "ButtonText ")]
          [(get w [:nonprop-deprecated-system-color :alt 8] 100)
            (gen/return "CaptionText ")]
          [(get w [:nonprop-deprecated-system-color :alt 9] 100)
            (gen/return "GrayText ")]
          [(get w [:nonprop-deprecated-system-color :alt 10] 100)
            (gen/return "Highlight ")]
          [(get w [:nonprop-deprecated-system-color :alt 11] 100)
            (gen/return "HighlightText ")]
          [(get w [:nonprop-deprecated-system-color :alt 12] 100)
            (gen/return "InactiveBorder ")]
          [(get w [:nonprop-deprecated-system-color :alt 13] 100)
            (gen/return "InactiveCaption ")]
          [(get w [:nonprop-deprecated-system-color :alt 14] 100)
            (gen/return "InactiveCaptionText ")]
          [(get w [:nonprop-deprecated-system-color :alt 15] 100)
            (gen/return "InfoBackground ")]
          [(get w [:nonprop-deprecated-system-color :alt 16] 100)
            (gen/return "InfoText ")]
          [(get w [:nonprop-deprecated-system-color :alt 17] 100)
            (gen/return "Menu ")]
          [(get w [:nonprop-deprecated-system-color :alt 18] 100)
            (gen/return "MenuText ")]
          [(get w [:nonprop-deprecated-system-color :alt 19] 100)
            (gen/return "Scrollbar ")]
          [(get w [:nonprop-deprecated-system-color :alt 20] 100)
            (gen/return "ThreeDDarkShadow ")]
          [(get w [:nonprop-deprecated-system-color :alt 21] 100)
            (gen/return "ThreeDFace ")]
          [(get w [:nonprop-deprecated-system-color :alt 22] 100)
            (gen/return "ThreeDHighlight ")]
          [(get w [:nonprop-deprecated-system-color :alt 23] 100)
            (gen/return "ThreeDLightShadow ")]
          [(get w [:nonprop-deprecated-system-color :alt 24] 100)
            (gen/return "ThreeDShadow ")]
          [(get w [:nonprop-deprecated-system-color :alt 25] 100)
            (gen/return "Window ")]
          [(get w [:nonprop-deprecated-system-color :alt 26] 100)
            (gen/return "WindowFrame ")]
          [(get w [:nonprop-deprecated-system-color :alt 27] 100)
            (gen/return "WindowText ")]])
        g (assoc g :nonprop-deprecated-system-color gen-nonprop-deprecated-system-color)

        gen-func-rgb
        (igen/freq :func-rgb [
          [(get w [:func-rgb :alt 0] 100)
            (gen/tuple
              (gen/return "rgb ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-percentage g)
                (gen/return " ")
                (:nonprop-percentage g)
                (gen/return " ")
                (:nonprop-percentage g))
              (igen/freq :func-rgb [
                [(get w [:func-rgb :alt 0 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgb :alt 0 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgb :alt 1] 100)
            (gen/tuple
              (gen/return "rgb ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-number g)
                (gen/return " ")
                (:nonprop-number g)
                (gen/return " ")
                (:nonprop-number g))
              (igen/freq :func-rgb [
                [(get w [:func-rgb :alt 1 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgb :alt 1 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgb :alt 2] 100)
            (gen/tuple
              (gen/return "rgb ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-percentage g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-percentage g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-percentage g))
              (igen/freq :func-rgb [
                [(get w [:func-rgb :alt 2 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgb :alt 2 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return ", ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgb :alt 3] 100)
            (gen/tuple
              (gen/return "rgb ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-number g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-number g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-number g))
              (igen/freq :func-rgb [
                [(get w [:func-rgb :alt 3 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgb :alt 3 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return ", ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]])
        g (assoc g :func-rgb gen-func-rgb)

        gen-nonprop-named-color
        (igen/freq :nonprop-named-color [
          [(get w [:nonprop-named-color :alt 0] 100)
            (gen/return "transparent ")]
          [(get w [:nonprop-named-color :alt 1] 100)
            (gen/return "aliceblue ")]
          [(get w [:nonprop-named-color :alt 2] 100)
            (gen/return "antiquewhite ")]
          [(get w [:nonprop-named-color :alt 3] 100)
            (gen/return "aqua ")]
          [(get w [:nonprop-named-color :alt 4] 100)
            (gen/return "aquamarine ")]
          [(get w [:nonprop-named-color :alt 5] 100)
            (gen/return "azure ")]
          [(get w [:nonprop-named-color :alt 6] 100)
            (gen/return "beige ")]
          [(get w [:nonprop-named-color :alt 7] 100)
            (gen/return "bisque ")]
          [(get w [:nonprop-named-color :alt 8] 100)
            (gen/return "black ")]
          [(get w [:nonprop-named-color :alt 9] 100)
            (gen/return "blanchedalmond ")]
          [(get w [:nonprop-named-color :alt 10] 100)
            (gen/return "blue ")]
          [(get w [:nonprop-named-color :alt 11] 100)
            (gen/return "blueviolet ")]
          [(get w [:nonprop-named-color :alt 12] 100)
            (gen/return "brown ")]
          [(get w [:nonprop-named-color :alt 13] 100)
            (gen/return "burlywood ")]
          [(get w [:nonprop-named-color :alt 14] 100)
            (gen/return "cadetblue ")]
          [(get w [:nonprop-named-color :alt 15] 100)
            (gen/return "chartreuse ")]
          [(get w [:nonprop-named-color :alt 16] 100)
            (gen/return "chocolate ")]
          [(get w [:nonprop-named-color :alt 17] 100)
            (gen/return "coral ")]
          [(get w [:nonprop-named-color :alt 18] 100)
            (gen/return "cornflowerblue ")]
          [(get w [:nonprop-named-color :alt 19] 100)
            (gen/return "cornsilk ")]
          [(get w [:nonprop-named-color :alt 20] 100)
            (gen/return "crimson ")]
          [(get w [:nonprop-named-color :alt 21] 100)
            (gen/return "cyan ")]
          [(get w [:nonprop-named-color :alt 22] 100)
            (gen/return "darkblue ")]
          [(get w [:nonprop-named-color :alt 23] 100)
            (gen/return "darkcyan ")]
          [(get w [:nonprop-named-color :alt 24] 100)
            (gen/return "darkgoldenrod ")]
          [(get w [:nonprop-named-color :alt 25] 100)
            (gen/return "darkgray ")]
          [(get w [:nonprop-named-color :alt 26] 100)
            (gen/return "darkgreen ")]
          [(get w [:nonprop-named-color :alt 27] 100)
            (gen/return "darkgrey ")]
          [(get w [:nonprop-named-color :alt 28] 100)
            (gen/return "darkkhaki ")]
          [(get w [:nonprop-named-color :alt 29] 100)
            (gen/return "darkmagenta ")]
          [(get w [:nonprop-named-color :alt 30] 100)
            (gen/return "darkolivegreen ")]
          [(get w [:nonprop-named-color :alt 31] 100)
            (gen/return "darkorange ")]
          [(get w [:nonprop-named-color :alt 32] 100)
            (gen/return "darkorchid ")]
          [(get w [:nonprop-named-color :alt 33] 100)
            (gen/return "darkred ")]
          [(get w [:nonprop-named-color :alt 34] 100)
            (gen/return "darksalmon ")]
          [(get w [:nonprop-named-color :alt 35] 100)
            (gen/return "darkseagreen ")]
          [(get w [:nonprop-named-color :alt 36] 100)
            (gen/return "darkslateblue ")]
          [(get w [:nonprop-named-color :alt 37] 100)
            (gen/return "darkslategray ")]
          [(get w [:nonprop-named-color :alt 38] 100)
            (gen/return "darkslategrey ")]
          [(get w [:nonprop-named-color :alt 39] 100)
            (gen/return "darkturquoise ")]
          [(get w [:nonprop-named-color :alt 40] 100)
            (gen/return "darkviolet ")]
          [(get w [:nonprop-named-color :alt 41] 100)
            (gen/return "deeppink ")]
          [(get w [:nonprop-named-color :alt 42] 100)
            (gen/return "deepskyblue ")]
          [(get w [:nonprop-named-color :alt 43] 100)
            (gen/return "dimgray ")]
          [(get w [:nonprop-named-color :alt 44] 100)
            (gen/return "dimgrey ")]
          [(get w [:nonprop-named-color :alt 45] 100)
            (gen/return "dodgerblue ")]
          [(get w [:nonprop-named-color :alt 46] 100)
            (gen/return "firebrick ")]
          [(get w [:nonprop-named-color :alt 47] 100)
            (gen/return "floralwhite ")]
          [(get w [:nonprop-named-color :alt 48] 100)
            (gen/return "forestgreen ")]
          [(get w [:nonprop-named-color :alt 49] 100)
            (gen/return "fuchsia ")]
          [(get w [:nonprop-named-color :alt 50] 100)
            (gen/return "gainsboro ")]
          [(get w [:nonprop-named-color :alt 51] 100)
            (gen/return "ghostwhite ")]
          [(get w [:nonprop-named-color :alt 52] 100)
            (gen/return "gold ")]
          [(get w [:nonprop-named-color :alt 53] 100)
            (gen/return "goldenrod ")]
          [(get w [:nonprop-named-color :alt 54] 100)
            (gen/return "gray ")]
          [(get w [:nonprop-named-color :alt 55] 100)
            (gen/return "green ")]
          [(get w [:nonprop-named-color :alt 56] 100)
            (gen/return "greenyellow ")]
          [(get w [:nonprop-named-color :alt 57] 100)
            (gen/return "grey ")]
          [(get w [:nonprop-named-color :alt 58] 100)
            (gen/return "honeydew ")]
          [(get w [:nonprop-named-color :alt 59] 100)
            (gen/return "hotpink ")]
          [(get w [:nonprop-named-color :alt 60] 100)
            (gen/return "indianred ")]
          [(get w [:nonprop-named-color :alt 61] 100)
            (gen/return "indigo ")]
          [(get w [:nonprop-named-color :alt 62] 100)
            (gen/return "ivory ")]
          [(get w [:nonprop-named-color :alt 63] 100)
            (gen/return "khaki ")]
          [(get w [:nonprop-named-color :alt 64] 100)
            (gen/return "lavender ")]
          [(get w [:nonprop-named-color :alt 65] 100)
            (gen/return "lavenderblush ")]
          [(get w [:nonprop-named-color :alt 66] 100)
            (gen/return "lawngreen ")]
          [(get w [:nonprop-named-color :alt 67] 100)
            (gen/return "lemonchiffon ")]
          [(get w [:nonprop-named-color :alt 68] 100)
            (gen/return "lightblue ")]
          [(get w [:nonprop-named-color :alt 69] 100)
            (gen/return "lightcoral ")]
          [(get w [:nonprop-named-color :alt 70] 100)
            (gen/return "lightcyan ")]
          [(get w [:nonprop-named-color :alt 71] 100)
            (gen/return "lightgoldenrodyellow ")]
          [(get w [:nonprop-named-color :alt 72] 100)
            (gen/return "lightgray ")]
          [(get w [:nonprop-named-color :alt 73] 100)
            (gen/return "lightgreen ")]
          [(get w [:nonprop-named-color :alt 74] 100)
            (gen/return "lightgrey ")]
          [(get w [:nonprop-named-color :alt 75] 100)
            (gen/return "lightpink ")]
          [(get w [:nonprop-named-color :alt 76] 100)
            (gen/return "lightsalmon ")]
          [(get w [:nonprop-named-color :alt 77] 100)
            (gen/return "lightseagreen ")]
          [(get w [:nonprop-named-color :alt 78] 100)
            (gen/return "lightskyblue ")]
          [(get w [:nonprop-named-color :alt 79] 100)
            (gen/return "lightslategray ")]
          [(get w [:nonprop-named-color :alt 80] 100)
            (gen/return "lightslategrey ")]
          [(get w [:nonprop-named-color :alt 81] 100)
            (gen/return "lightsteelblue ")]
          [(get w [:nonprop-named-color :alt 82] 100)
            (gen/return "lightyellow ")]
          [(get w [:nonprop-named-color :alt 83] 100)
            (gen/return "lime ")]
          [(get w [:nonprop-named-color :alt 84] 100)
            (gen/return "limegreen ")]
          [(get w [:nonprop-named-color :alt 85] 100)
            (gen/return "linen ")]
          [(get w [:nonprop-named-color :alt 86] 100)
            (gen/return "magenta ")]
          [(get w [:nonprop-named-color :alt 87] 100)
            (gen/return "maroon ")]
          [(get w [:nonprop-named-color :alt 88] 100)
            (gen/return "mediumaquamarine ")]
          [(get w [:nonprop-named-color :alt 89] 100)
            (gen/return "mediumblue ")]
          [(get w [:nonprop-named-color :alt 90] 100)
            (gen/return "mediumorchid ")]
          [(get w [:nonprop-named-color :alt 91] 100)
            (gen/return "mediumpurple ")]
          [(get w [:nonprop-named-color :alt 92] 100)
            (gen/return "mediumseagreen ")]
          [(get w [:nonprop-named-color :alt 93] 100)
            (gen/return "mediumslateblue ")]
          [(get w [:nonprop-named-color :alt 94] 100)
            (gen/return "mediumspringgreen ")]
          [(get w [:nonprop-named-color :alt 95] 100)
            (gen/return "mediumturquoise ")]
          [(get w [:nonprop-named-color :alt 96] 100)
            (gen/return "mediumvioletred ")]
          [(get w [:nonprop-named-color :alt 97] 100)
            (gen/return "midnightblue ")]
          [(get w [:nonprop-named-color :alt 98] 100)
            (gen/return "mintcream ")]
          [(get w [:nonprop-named-color :alt 99] 100)
            (gen/return "mistyrose ")]
          [(get w [:nonprop-named-color :alt 100] 100)
            (gen/return "moccasin ")]
          [(get w [:nonprop-named-color :alt 101] 100)
            (gen/return "navajowhite ")]
          [(get w [:nonprop-named-color :alt 102] 100)
            (gen/return "navy ")]
          [(get w [:nonprop-named-color :alt 103] 100)
            (gen/return "oldlace ")]
          [(get w [:nonprop-named-color :alt 104] 100)
            (gen/return "olive ")]
          [(get w [:nonprop-named-color :alt 105] 100)
            (gen/return "olivedrab ")]
          [(get w [:nonprop-named-color :alt 106] 100)
            (gen/return "orange ")]
          [(get w [:nonprop-named-color :alt 107] 100)
            (gen/return "orangered ")]
          [(get w [:nonprop-named-color :alt 108] 100)
            (gen/return "orchid ")]
          [(get w [:nonprop-named-color :alt 109] 100)
            (gen/return "palegoldenrod ")]
          [(get w [:nonprop-named-color :alt 110] 100)
            (gen/return "palegreen ")]
          [(get w [:nonprop-named-color :alt 111] 100)
            (gen/return "paleturquoise ")]
          [(get w [:nonprop-named-color :alt 112] 100)
            (gen/return "palevioletred ")]
          [(get w [:nonprop-named-color :alt 113] 100)
            (gen/return "papayawhip ")]
          [(get w [:nonprop-named-color :alt 114] 100)
            (gen/return "peachpuff ")]
          [(get w [:nonprop-named-color :alt 115] 100)
            (gen/return "peru ")]
          [(get w [:nonprop-named-color :alt 116] 100)
            (gen/return "pink ")]
          [(get w [:nonprop-named-color :alt 117] 100)
            (gen/return "plum ")]
          [(get w [:nonprop-named-color :alt 118] 100)
            (gen/return "powderblue ")]
          [(get w [:nonprop-named-color :alt 119] 100)
            (gen/return "purple ")]
          [(get w [:nonprop-named-color :alt 120] 100)
            (gen/return "rebeccapurple ")]
          [(get w [:nonprop-named-color :alt 121] 100)
            (gen/return "red ")]
          [(get w [:nonprop-named-color :alt 122] 100)
            (gen/return "rosybrown ")]
          [(get w [:nonprop-named-color :alt 123] 100)
            (gen/return "royalblue ")]
          [(get w [:nonprop-named-color :alt 124] 100)
            (gen/return "saddlebrown ")]
          [(get w [:nonprop-named-color :alt 125] 100)
            (gen/return "salmon ")]
          [(get w [:nonprop-named-color :alt 126] 100)
            (gen/return "sandybrown ")]
          [(get w [:nonprop-named-color :alt 127] 100)
            (gen/return "seagreen ")]
          [(get w [:nonprop-named-color :alt 128] 100)
            (gen/return "seashell ")]
          [(get w [:nonprop-named-color :alt 129] 100)
            (gen/return "sienna ")]
          [(get w [:nonprop-named-color :alt 130] 100)
            (gen/return "silver ")]
          [(get w [:nonprop-named-color :alt 131] 100)
            (gen/return "skyblue ")]
          [(get w [:nonprop-named-color :alt 132] 100)
            (gen/return "slateblue ")]
          [(get w [:nonprop-named-color :alt 133] 100)
            (gen/return "slategray ")]
          [(get w [:nonprop-named-color :alt 134] 100)
            (gen/return "slategrey ")]
          [(get w [:nonprop-named-color :alt 135] 100)
            (gen/return "snow ")]
          [(get w [:nonprop-named-color :alt 136] 100)
            (gen/return "springgreen ")]
          [(get w [:nonprop-named-color :alt 137] 100)
            (gen/return "steelblue ")]
          [(get w [:nonprop-named-color :alt 138] 100)
            (gen/return "tan ")]
          [(get w [:nonprop-named-color :alt 139] 100)
            (gen/return "teal ")]
          [(get w [:nonprop-named-color :alt 140] 100)
            (gen/return "thistle ")]
          [(get w [:nonprop-named-color :alt 141] 100)
            (gen/return "tomato ")]
          [(get w [:nonprop-named-color :alt 142] 100)
            (gen/return "turquoise ")]
          [(get w [:nonprop-named-color :alt 143] 100)
            (gen/return "violet ")]
          [(get w [:nonprop-named-color :alt 144] 100)
            (gen/return "wheat ")]
          [(get w [:nonprop-named-color :alt 145] 100)
            (gen/return "white ")]
          [(get w [:nonprop-named-color :alt 146] 100)
            (gen/return "whitesmoke ")]
          [(get w [:nonprop-named-color :alt 147] 100)
            (gen/return "yellow ")]
          [(get w [:nonprop-named-color :alt 148] 100)
            (gen/return "yellowgreen ")]])
        g (assoc g :nonprop-named-color gen-nonprop-named-color)

        gen-nonprop-hex-color
        (igen/freq :nonprop-hex-color [
          [(get w [:nonprop-hex-color :alt 0] 100)
            (gen/tuple
              (chuck/string-from-regex #"#[0-9A-Fa-f]{3}")
              (gen/return " "))]
          [(get w [:nonprop-hex-color :alt 1] 100)
            (gen/tuple
              (chuck/string-from-regex #"#[0-9A-Fa-f]{6}")
              (gen/return " "))]])
        g (assoc g :nonprop-hex-color gen-nonprop-hex-color)

        gen-func-hsla
        (igen/freq :func-hsla [
          [(get w [:func-hsla :alt 0] 100)
            (gen/tuple
              (gen/return "hsla ")
              (gen/return "( ")
              (:nonprop-hue g)
              (:nonprop-percentage g)
              (:nonprop-percentage g)
              (igen/freq :func-hsla [
                [(get w [:func-hsla :alt 0 :cat 5 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-hsla :alt 0 :cat 5 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-hsla :alt 1] 100)
            (gen/tuple
              (gen/return "hsla ")
              (gen/return "( ")
              (:nonprop-hue g)
              (gen/return ", ")
              (:nonprop-percentage g)
              (gen/return ", ")
              (:nonprop-percentage g)
              (gen/return ",")
              (gen/return " ")
              (igen/freq :func-hsla [
                [(get w [:func-hsla :alt 1 :cat 9 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-hsla :alt 1 :cat 9 :opt 0] 100)
                  (:nonprop-alpha-value g)]])
              (gen/return ") "))]])
        g (assoc g :func-hsla gen-func-hsla)

        gen-func-rgba
        (igen/freq :func-rgba [
          [(get w [:func-rgba :alt 0] 100)
            (gen/tuple
              (gen/return "rgba ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-percentage g)
                (gen/return " ")
                (:nonprop-percentage g)
                (gen/return " ")
                (:nonprop-percentage g))
              (igen/freq :func-rgba [
                [(get w [:func-rgba :alt 0 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgba :alt 0 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgba :alt 1] 100)
            (gen/tuple
              (gen/return "rgba ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-number g)
                (gen/return " ")
                (:nonprop-number g)
                (gen/return " ")
                (:nonprop-number g))
              (igen/freq :func-rgba [
                [(get w [:func-rgba :alt 1 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgba :alt 1 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgba :alt 2] 100)
            (gen/tuple
              (gen/return "rgba ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-percentage g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-percentage g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-percentage g))
              (igen/freq :func-rgba [
                [(get w [:func-rgba :alt 2 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgba :alt 2 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return ", ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]
          [(get w [:func-rgba :alt 3] 100)
            (gen/tuple
              (gen/return "rgba ")
              (gen/return "( ")
              (gen/tuple
                (:nonprop-number g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-number g)
                (gen/return ",")
                (gen/return " ")
                (:nonprop-number g))
              (igen/freq :func-rgba [
                [(get w [:func-rgba :alt 3 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:func-rgba :alt 3 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return ", ")
                    (:nonprop-alpha-value g))]])
              (gen/return ") "))]])
        g (assoc g :func-rgba gen-func-rgba)

        gen-nonprop-color
        (igen/freq :nonprop-color [
          [(get w [:nonprop-color :alt 0] 100)
            (:func-rgb g)]
          [(get w [:nonprop-color :alt 1] 100)
            (:func-rgba g)]
          [(get w [:nonprop-color :alt 2] 100)
            (:func-hsl g)]
          [(get w [:nonprop-color :alt 3] 100)
            (:func-hsla g)]
          [(get w [:nonprop-color :alt 4] 100)
            (:nonprop-hex-color g)]
          [(get w [:nonprop-color :alt 5] 100)
            (:nonprop-named-color g)]
          [(get w [:nonprop-color :alt 6] 100)
            (gen/return "currentcolor ")]
          [(get w [:nonprop-color :alt 7] 100)
            (:nonprop-deprecated-system-color g)]])
        g (assoc g :nonprop-color gen-nonprop-color)

        gen-nonprop-shadow
        (gen/tuple
          (igen/freq :nonprop-shadow [
            [(get w [:nonprop-shadow :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-shadow :cat 0 :opt 0] 100)
              (gen/return "inset ")]])
          (igen/freq :nonprop-shadow [
            [(get w [:nonprop-shadow :cat 1 :alt 0] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]
            [(get w [:nonprop-shadow :cat 1 :alt 1] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]
            [(get w [:nonprop-shadow :cat 1 :alt 2] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]])
          (igen/freq :nonprop-shadow [
            [(get w [:nonprop-shadow :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-shadow :cat 2 :opt 0] 100)
              (:nonprop-color g)]]))
        g (assoc g :nonprop-shadow gen-nonprop-shadow)

        gen-prop-box-shadow
        (igen/freq :prop-box-shadow [
          [(get w [:prop-box-shadow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-box-shadow :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-box-shadow :alt 2] 100)
            (gen/tuple
              (:nonprop-shadow g)
              (igen/freq :prop-box-shadow [
                [(get w [:prop-box-shadow :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-box-shadow :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-shadow g)))]]))]])
        g (assoc g :prop-box-shadow gen-prop-box-shadow)

        gen-prop-resize
        (igen/freq :prop-resize [
          [(get w [:prop-resize :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-resize :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-resize :alt 2] 100)
            (gen/return "both ")]
          [(get w [:prop-resize :alt 3] 100)
            (gen/return "horizontal ")]
          [(get w [:prop-resize :alt 4] 100)
            (gen/return "vertical ")]
          [(get w [:prop-resize :alt 5] 100)
            (gen/return "block ")]
          [(get w [:prop-resize :alt 6] 100)
            (gen/return "inline ")]])
        g (assoc g :prop-resize gen-prop-resize)

        gen-prop-border-top-color
        (igen/freq :prop-border-top-color [
          [(get w [:prop-border-top-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-border-top-color gen-prop-border-top-color)

        gen-prop-border-inline-color
        (igen/freq :prop-border-inline-color [
          [(get w [:prop-border-inline-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-color :alt 1] 100)
            (igen/freq :prop-border-inline-color [
              [(get w [:prop-border-inline-color :alt 1 :alt 0] 100)
                (:prop-border-top-color g)]
              [(get w [:prop-border-inline-color :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-border-top-color g)
                  (gen/return " ")
                  (:prop-border-top-color g))]])]])
        g (assoc g :prop-border-inline-color gen-prop-border-inline-color)

        gen-prop-column-width
        (igen/freq :prop-column-width [
          [(get w [:prop-column-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-width :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-column-width :alt 2] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-column-width gen-prop-column-width)

        gen-nonprop-integer
        (:integer g)
        g (assoc g :nonprop-integer gen-nonprop-integer)

        gen-prop-column-count
        (igen/freq :prop-column-count [
          [(get w [:prop-column-count :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-count :alt 1] 100)
            (:nonprop-integer g)]
          [(get w [:prop-column-count :alt 2] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-column-count gen-prop-column-count)

        gen-prop-columns
        (igen/freq :prop-columns [
          [(get w [:prop-columns :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-columns :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-columns [
                [(get w [:prop-columns :alt 1 :plus 0 :alt 0] 100)
                  (:prop-column-width g)]
                [(get w [:prop-columns :alt 1 :plus 0 :alt 1] 100)
                  (:prop-column-count g)]]))]])
        g (assoc g :prop-columns gen-prop-columns)

        gen-nonprop-font-stretch-absolute
        (igen/freq :nonprop-font-stretch-absolute [
          [(get w [:nonprop-font-stretch-absolute :alt 0] 100)
            (gen/return "normal ")]
          [(get w [:nonprop-font-stretch-absolute :alt 1] 100)
            (gen/return "ultra-condensed ")]
          [(get w [:nonprop-font-stretch-absolute :alt 2] 100)
            (gen/return "extra-condensed ")]
          [(get w [:nonprop-font-stretch-absolute :alt 3] 100)
            (gen/return "condensed ")]
          [(get w [:nonprop-font-stretch-absolute :alt 4] 100)
            (gen/return "semi-condensed ")]
          [(get w [:nonprop-font-stretch-absolute :alt 5] 100)
            (gen/return "semi-expanded ")]
          [(get w [:nonprop-font-stretch-absolute :alt 6] 100)
            (gen/return "expanded ")]
          [(get w [:nonprop-font-stretch-absolute :alt 7] 100)
            (gen/return "extra-expanded ")]
          [(get w [:nonprop-font-stretch-absolute :alt 8] 100)
            (gen/return "ultra-expanded ")]
          [(get w [:nonprop-font-stretch-absolute :alt 9] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-font-stretch-absolute gen-nonprop-font-stretch-absolute)

        gen-nonprop-display-outside
        (igen/freq :nonprop-display-outside [
          [(get w [:nonprop-display-outside :alt 0] 100)
            (gen/return "block ")]
          [(get w [:nonprop-display-outside :alt 1] 100)
            (gen/return "inline ")]
          [(get w [:nonprop-display-outside :alt 2] 100)
            (gen/return "run-in ")]])
        g (assoc g :nonprop-display-outside gen-nonprop-display-outside)

        gen-nonprop-display-listitem
        (gen/tuple
          (igen/freq :nonprop-display-listitem [
            [(get w [:nonprop-display-listitem :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-display-listitem :cat 0 :opt 0] 100)
              (:nonprop-display-outside g)]])
          (igen/freq :nonprop-display-listitem [
            [(get w [:nonprop-display-listitem :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-display-listitem :cat 1 :opt 0] 100)
              (igen/freq :nonprop-display-listitem [
                [(get w [:nonprop-display-listitem :cat 1 :opt 0 :alt 0] 100)
                  (gen/return "flow ")]
                [(get w [:nonprop-display-listitem :cat 1 :opt 0 :alt 1] 100)
                  (gen/return "flow-root ")]])]])
          (gen/return "list-item "))
        g (assoc g :nonprop-display-listitem gen-nonprop-display-listitem)]
    g))

(defn- css3-generators-part-1 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-text-decoration-style
        (igen/freq :prop-text-decoration-style [
          [(get w [:prop-text-decoration-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-decoration-style :alt 1] 100)
            (gen/return "solid ")]
          [(get w [:prop-text-decoration-style :alt 2] 100)
            (gen/return "double ")]
          [(get w [:prop-text-decoration-style :alt 3] 100)
            (gen/return "dotted ")]
          [(get w [:prop-text-decoration-style :alt 4] 100)
            (gen/return "dashed ")]
          [(get w [:prop-text-decoration-style :alt 5] 100)
            (gen/return "wavy ")]])
        g (assoc g :prop-text-decoration-style gen-prop-text-decoration-style)

        gen-prop-text-decoration-color
        (igen/freq :prop-text-decoration-color [
          [(get w [:prop-text-decoration-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-decoration-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-text-decoration-color gen-prop-text-decoration-color)

        gen-prop-text-decoration-line
        (igen/freq :prop-text-decoration-line [
          [(get w [:prop-text-decoration-line :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-decoration-line :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-text-decoration-line :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-text-decoration-line [
                [(get w [:prop-text-decoration-line :alt 2 :plus 0 :alt 0] 100)
                  (gen/return "underline ")]
                [(get w [:prop-text-decoration-line :alt 2 :plus 0 :alt 1] 100)
                  (gen/return "overline ")]
                [(get w [:prop-text-decoration-line :alt 2 :plus 0 :alt 2] 100)
                  (gen/return "line-through ")]
                [(get w [:prop-text-decoration-line :alt 2 :plus 0 :alt 3] 100)
                  (gen/return "blink ")]]))]])
        g (assoc g :prop-text-decoration-line gen-prop-text-decoration-line)

        gen-prop-text-decoration
        (igen/freq :prop-text-decoration [
          [(get w [:prop-text-decoration :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-decoration :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-text-decoration [
                [(get w [:prop-text-decoration :alt 1 :plus 0 :alt 0] 100)
                  (:prop-text-decoration-line g)]
                [(get w [:prop-text-decoration :alt 1 :plus 0 :alt 1] 100)
                  (:prop-text-decoration-style g)]
                [(get w [:prop-text-decoration :alt 1 :plus 0 :alt 2] 100)
                  (:prop-text-decoration-color g)]]))]])
        g (assoc g :prop-text-decoration gen-prop-text-decoration)

        gen-quoted-string
        (gen/return "'QUOTED STRING'")
        g (assoc g :quoted-string gen-quoted-string)

        gen-nonprop-resolution
        (gen/tuple
          (:any-number g)
          (igen/freq :nonprop-resolution [
            [(get w [:nonprop-resolution :cat 1 :alt 0] 100)
              (gen/return "dpi")]
            [(get w [:nonprop-resolution :cat 1 :alt 1] 100)
              (gen/return "dpcm")]
            [(get w [:nonprop-resolution :cat 1 :alt 2] 100)
              (gen/return "dppx")]
            [(get w [:nonprop-resolution :cat 1 :alt 3] 100)
              (gen/return "px")]])
          (gen/return " "))
        g (assoc g :nonprop-resolution gen-nonprop-resolution)

        gen-nonprop-url
        (gen/tuple
          (gen/return "url(")
          (:quoted-string g)
          (gen/return ") "))
        g (assoc g :nonprop-url gen-nonprop-url)

        gen-nonprop-string
        (:quoted-string g)
        g (assoc g :nonprop-string gen-nonprop-string)

        gen-nonprop-image
        (:nonprop-url g)
        g (assoc g :nonprop-image gen-nonprop-image)

        gen-nonprop-image-set-option
        (gen/tuple
          (igen/freq :nonprop-image-set-option [
            [(get w [:nonprop-image-set-option :cat 0 :alt 0] 100)
              (:nonprop-image g)]
            [(get w [:nonprop-image-set-option :cat 0 :alt 1] 100)
              (:nonprop-string g)]])
          (:nonprop-resolution g))
        g (assoc g :nonprop-image-set-option gen-nonprop-image-set-option)

        gen-nonprop-line-width
        (igen/freq :nonprop-line-width [
          [(get w [:nonprop-line-width :alt 0] 100)
            (:nonprop-length g)]
          [(get w [:nonprop-line-width :alt 1] 100)
            (gen/return "thin ")]
          [(get w [:nonprop-line-width :alt 2] 100)
            (gen/return "medium ")]
          [(get w [:nonprop-line-width :alt 3] 100)
            (gen/return "thick ")]])
        g (assoc g :nonprop-line-width gen-nonprop-line-width)

        gen-nonprop-line-style
        (igen/freq :nonprop-line-style [
          [(get w [:nonprop-line-style :alt 0] 100)
            (gen/return "none ")]
          [(get w [:nonprop-line-style :alt 1] 100)
            (gen/return "hidden ")]
          [(get w [:nonprop-line-style :alt 2] 100)
            (gen/return "dotted ")]
          [(get w [:nonprop-line-style :alt 3] 100)
            (gen/return "dashed ")]
          [(get w [:nonprop-line-style :alt 4] 100)
            (gen/return "solid ")]
          [(get w [:nonprop-line-style :alt 5] 100)
            (gen/return "double ")]
          [(get w [:nonprop-line-style :alt 6] 100)
            (gen/return "groove ")]
          [(get w [:nonprop-line-style :alt 7] 100)
            (gen/return "ridge ")]
          [(get w [:nonprop-line-style :alt 8] 100)
            (gen/return "inset ")]
          [(get w [:nonprop-line-style :alt 9] 100)
            (gen/return "outset ")]])
        g (assoc g :nonprop-line-style gen-nonprop-line-style)

        gen-prop-border
        (igen/freq :prop-border [
          [(get w [:prop-border :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border [
                [(get w [:prop-border :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-line-width g)]
                [(get w [:prop-border :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-line-style g)]
                [(get w [:prop-border :alt 1 :plus 0 :alt 2] 100)
                  (:nonprop-color g)]]))]])
        g (assoc g :prop-border gen-prop-border)

        gen-prop-font-variant-caps
        (igen/freq :prop-font-variant-caps [
          [(get w [:prop-font-variant-caps :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-caps :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-caps :alt 2] 100)
            (gen/return "small-caps ")]
          [(get w [:prop-font-variant-caps :alt 3] 100)
            (gen/return "all-small-caps ")]
          [(get w [:prop-font-variant-caps :alt 4] 100)
            (gen/return "petite-caps ")]
          [(get w [:prop-font-variant-caps :alt 5] 100)
            (gen/return "all-petite-caps ")]
          [(get w [:prop-font-variant-caps :alt 6] 100)
            (gen/return "unicase ")]
          [(get w [:prop-font-variant-caps :alt 7] 100)
            (gen/return "titling-caps ")]])
        g (assoc g :prop-font-variant-caps gen-prop-font-variant-caps)

        gen-nonprop-custom-ident
        (gen/tuple
          rgen/simple-identifier
          (gen/return " "))
        g (assoc g :nonprop-custom-ident gen-nonprop-custom-ident)

        gen-nonprop-ident
        (:nonprop-custom-ident g)
        g (assoc g :nonprop-ident gen-nonprop-ident)

        gen-nonprop-any-value
        (gen/return "STUB_any_value")
        g (assoc g :nonprop-any-value gen-nonprop-any-value)

        gen-prop-group-rule-body
        (gen/return "STUB_prop_group_rule_body")
        g (assoc g :prop-group-rule-body gen-prop-group-rule-body)

        gen-prop-inset
        (igen/freq :prop-inset [
          [(get w [:prop-inset :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset :alt 1] 100)
            (igen/freq :prop-inset [
              [(get w [:prop-inset :alt 1 :alt 0] 100)
                (:prop-top g)]
              [(get w [:prop-inset :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g))]
              [(get w [:prop-inset :alt 1 :alt 2] 100)
                (gen/tuple
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g))]
              [(get w [:prop-inset :alt 1 :alt 3] 100)
                (gen/tuple
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g))]])]])
        g (assoc g :prop-inset gen-prop-inset)

        gen-nonprop-time
        (gen/tuple
          (:any-number g)
          (igen/freq :nonprop-time [
            [(get w [:nonprop-time :cat 1 :alt 0] 100)
              (gen/return "s")]
            [(get w [:nonprop-time :cat 1 :alt 1] 100)
              (gen/return "ms")]])
          (gen/return " "))
        g (assoc g :nonprop-time gen-nonprop-time)

        gen-prop-transition-duration
        (igen/freq :prop-transition-duration [
          [(get w [:prop-transition-duration :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transition-duration :alt 1] 100)
            (gen/tuple
              (:nonprop-time g)
              (igen/freq :prop-transition-duration [
                [(get w [:prop-transition-duration :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-transition-duration :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-time g)))]]))]])
        g (assoc g :prop-transition-duration gen-prop-transition-duration)

        gen-nonprop-flex
        (gen/tuple
          (:any-number g)
          (gen/return "fr "))
        g (assoc g :nonprop-flex gen-nonprop-flex)

        gen-nonprop-track-breadth
        (igen/freq :nonprop-track-breadth [
          [(get w [:nonprop-track-breadth :alt 0] 100)
            (:nonprop-length-percentage g)]
          [(get w [:nonprop-track-breadth :alt 1] 100)
            (:nonprop-flex g)]
          [(get w [:nonprop-track-breadth :alt 2] 100)
            (gen/return "min-content ")]
          [(get w [:nonprop-track-breadth :alt 3] 100)
            (gen/return "max-content ")]
          [(get w [:nonprop-track-breadth :alt 4] 100)
            (gen/return "auto ")]])
        g (assoc g :nonprop-track-breadth gen-nonprop-track-breadth)

        gen-nonprop-fixed-breadth
        (:nonprop-length-percentage g)
        g (assoc g :nonprop-fixed-breadth gen-nonprop-fixed-breadth)

        gen-nonprop-inflexible-breadth
        (igen/freq :nonprop-inflexible-breadth [
          [(get w [:nonprop-inflexible-breadth :alt 0] 100)
            (:nonprop-length g)]
          [(get w [:nonprop-inflexible-breadth :alt 1] 100)
            (:nonprop-percentage g)]
          [(get w [:nonprop-inflexible-breadth :alt 2] 100)
            (gen/return "min-content ")]
          [(get w [:nonprop-inflexible-breadth :alt 3] 100)
            (gen/return "max-content ")]
          [(get w [:nonprop-inflexible-breadth :alt 4] 100)
            (gen/return "auto ")]])
        g (assoc g :nonprop-inflexible-breadth gen-nonprop-inflexible-breadth)

        gen-nonprop-fixed-size
        (igen/freq :nonprop-fixed-size [
          [(get w [:nonprop-fixed-size :alt 0] 100)
            (:nonprop-fixed-breadth g)]
          [(get w [:nonprop-fixed-size :alt 1] 100)
            (gen/tuple
              (gen/return "minmax ")
              (gen/return "( ")
              (:nonprop-fixed-breadth g)
              (gen/return ", ")
              (:nonprop-track-breadth g)
              (gen/return ") "))]
          [(get w [:nonprop-fixed-size :alt 2] 100)
            (gen/tuple
              (gen/return "minmax ")
              (gen/return "( ")
              (:nonprop-inflexible-breadth g)
              (gen/return ", ")
              (:nonprop-fixed-breadth g)
              (gen/return ") "))]])
        g (assoc g :nonprop-fixed-size gen-nonprop-fixed-size)

        gen-nonprop-ending-shape
        (igen/freq :nonprop-ending-shape [
          [(get w [:nonprop-ending-shape :alt 0] 100)
            (gen/return "circle ")]
          [(get w [:nonprop-ending-shape :alt 1] 100)
            (gen/return "ellipse ")]])
        g (assoc g :nonprop-ending-shape gen-nonprop-ending-shape)

        gen-nonprop-color-stop-length
        (igen/freq :nonprop-color-stop-length [
          [(get w [:nonprop-color-stop-length :alt 0] 100)
            (:nonprop-length-percentage g)]
          [(get w [:nonprop-color-stop-length :alt 1] 100)
            (gen/tuple
              (:nonprop-length-percentage g)
              (gen/return " ")
              (:nonprop-length-percentage g))]])
        g (assoc g :nonprop-color-stop-length gen-nonprop-color-stop-length)

        gen-nonprop-linear-color-stop
        (gen/tuple
          (:nonprop-color g)
          (:nonprop-color-stop-length g))
        g (assoc g :nonprop-linear-color-stop gen-nonprop-linear-color-stop)

        gen-nonprop-linear-color-hint
        (:nonprop-length-percentage g)
        g (assoc g :nonprop-linear-color-hint gen-nonprop-linear-color-hint)

        gen-nonprop-position
        (igen/freq :nonprop-position [
          [(get w [:nonprop-position :alt 0] 100)
            (igen/vector+
              (igen/freq :nonprop-position [
                [(get w [:nonprop-position :alt 0 :plus 0 :alt 0] 100)
                  (igen/freq :nonprop-position [
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 0 :alt 0] 100)
                      (gen/return "left ")]
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 0 :alt 1] 100)
                      (gen/return "center ")]
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 0 :alt 2] 100)
                      (gen/return "right ")]])]
                [(get w [:nonprop-position :alt 0 :plus 0 :alt 1] 100)
                  (igen/freq :nonprop-position [
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 1 :alt 0] 100)
                      (gen/return "top ")]
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 1 :alt 1] 100)
                      (gen/return "center ")]
                    [(get w [:nonprop-position :alt 0 :plus 0 :alt 1 :alt 2] 100)
                      (gen/return "bottom ")]])]]))]
          [(get w [:nonprop-position :alt 1] 100)
            (gen/tuple
              (igen/freq :nonprop-position [
                [(get w [:nonprop-position :alt 1 :cat 0 :alt 0] 100)
                  (gen/return "left ")]
                [(get w [:nonprop-position :alt 1 :cat 0 :alt 1] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-position :alt 1 :cat 0 :alt 2] 100)
                  (gen/return "right ")]
                [(get w [:nonprop-position :alt 1 :cat 0 :alt 3] 100)
                  (:nonprop-length-percentage g)]])
              (igen/freq :nonprop-position [
                [(get w [:nonprop-position :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-position :alt 1 :cat 1 :opt 0] 100)
                  (igen/freq :nonprop-position [
                    [(get w [:nonprop-position :alt 1 :cat 1 :opt 0 :alt 0] 100)
                      (gen/return "top ")]
                    [(get w [:nonprop-position :alt 1 :cat 1 :opt 0 :alt 1] 100)
                      (gen/return "center ")]
                    [(get w [:nonprop-position :alt 1 :cat 1 :opt 0 :alt 2] 100)
                      (gen/return "bottom ")]
                    [(get w [:nonprop-position :alt 1 :cat 1 :opt 0 :alt 3] 100)
                      (:nonprop-length-percentage g)]])]]))]
          [(get w [:nonprop-position :alt 2] 100)
            (gen/tuple
              (gen/tuple
                (igen/freq :nonprop-position [
                  [(get w [:nonprop-position :alt 2 :cat 0 :cat 0 :alt 0] 100)
                    (gen/return "left ")]
                  [(get w [:nonprop-position :alt 2 :cat 0 :cat 0 :alt 1] 100)
                    (gen/return "right ")]])
                (:nonprop-length-percentage g))
              (gen/tuple
                (igen/freq :nonprop-position [
                  [(get w [:nonprop-position :alt 2 :cat 1 :cat 0 :alt 0] 100)
                    (gen/return "top ")]
                  [(get w [:nonprop-position :alt 2 :cat 1 :cat 0 :alt 1] 100)
                    (gen/return "bottom ")]])
                (:nonprop-length-percentage g)))]])
        g (assoc g :nonprop-position gen-nonprop-position)

        gen-nonprop-size
        (igen/freq :nonprop-size [
          [(get w [:nonprop-size :alt 0] 100)
            (gen/return "closest-side ")]
          [(get w [:nonprop-size :alt 1] 100)
            (gen/return "farthest-side ")]
          [(get w [:nonprop-size :alt 2] 100)
            (gen/return "closest-corner ")]
          [(get w [:nonprop-size :alt 3] 100)
            (gen/return "farthest-corner ")]
          [(get w [:nonprop-size :alt 4] 100)
            (:nonprop-length g)]
          [(get w [:nonprop-size :alt 5] 100)
            (gen/tuple
              (:nonprop-length-percentage g)
              (gen/return " ")
              (:nonprop-length-percentage g))]])
        g (assoc g :nonprop-size gen-nonprop-size)

        gen-nonprop-color-stop-list
        (gen/tuple
          (gen/tuple
            (:nonprop-linear-color-stop g)
            (igen/freq :nonprop-color-stop-list [
              [(get w [:nonprop-color-stop-list :cat 0 :cat 1 :opt nil] 100)
                (gen/return "")]
              [(get w [:nonprop-color-stop-list :cat 0 :cat 1 :opt 0] 100)
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-linear-color-hint g))]]))
          (igen/freq :nonprop-color-stop-list [
            [(get w [:nonprop-color-stop-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-color-stop-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (gen/tuple
                    (:nonprop-linear-color-stop g)
                    (igen/freq :nonprop-color-stop-list [
                      [(get w [:nonprop-color-stop-list :cat 1 :star 0 :cat 2 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:nonprop-color-stop-list :cat 1 :star 0 :cat 2 :cat 1 :opt 0] 100)
                        (gen/tuple
                          (gen/return ", ")
                          (:nonprop-linear-color-hint g))]]))))]])
          (gen/return ", ")
          (:nonprop-linear-color-stop g))
        g (assoc g :nonprop-color-stop-list gen-nonprop-color-stop-list)

        gen-func-repeating-radial-gradient
        (gen/tuple
          (gen/return "repeating-radial-gradient ")
          (gen/return "( ")
          (igen/freq :func-repeating-radial-gradient [
            [(get w [:func-repeating-radial-gradient :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-repeating-radial-gradient :cat 2 :opt 0] 100)
              (igen/vector+
                (igen/freq :func-repeating-radial-gradient [
                  [(get w [:func-repeating-radial-gradient :cat 2 :opt 0 :plus 0 :alt 0] 100)
                    (:nonprop-ending-shape g)]
                  [(get w [:func-repeating-radial-gradient :cat 2 :opt 0 :plus 0 :alt 1] 100)
                    (:nonprop-size g)]]))]])
          (igen/freq :func-repeating-radial-gradient [
            [(get w [:func-repeating-radial-gradient :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-repeating-radial-gradient :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "at ")
                (:nonprop-position g))]])
          (gen/return ", ")
          (:nonprop-color-stop-list g)
          (gen/return ") "))
        g (assoc g :func-repeating-radial-gradient gen-func-repeating-radial-gradient)

        gen-prop-overflow-x
        (igen/freq :prop-overflow-x [
          [(get w [:prop-overflow-x :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-overflow-x :alt 1] 100)
            (gen/return "visible ")]
          [(get w [:prop-overflow-x :alt 2] 100)
            (gen/return "hidden ")]
          [(get w [:prop-overflow-x :alt 3] 100)
            (gen/return "clip ")]
          [(get w [:prop-overflow-x :alt 4] 100)
            (gen/return "scroll ")]
          [(get w [:prop-overflow-x :alt 5] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-overflow-x gen-prop-overflow-x)

        gen-nonprop-angle-percentage
        (igen/freq :nonprop-angle-percentage [
          [(get w [:nonprop-angle-percentage :alt 0] 100)
            (:nonprop-angle g)]
          [(get w [:nonprop-angle-percentage :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-angle-percentage gen-nonprop-angle-percentage)

        gen-nonprop-shape-radius
        (igen/freq :nonprop-shape-radius [
          [(get w [:nonprop-shape-radius :alt 0] 100)
            (:nonprop-length-percentage g)]
          [(get w [:nonprop-shape-radius :alt 1] 100)
            (gen/return "closest-side ")]
          [(get w [:nonprop-shape-radius :alt 2] 100)
            (gen/return "farthest-side ")]])
        g (assoc g :nonprop-shape-radius gen-nonprop-shape-radius)

        gen-func-circle
        (gen/tuple
          (gen/return "circle ")
          (gen/return "( ")
          (igen/freq :func-circle [
            [(get w [:func-circle :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-circle :cat 2 :opt 0] 100)
              (:nonprop-shape-radius g)]])
          (igen/freq :func-circle [
            [(get w [:func-circle :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-circle :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "at ")
                (:nonprop-position g))]])
          (gen/return ") "))
        g (assoc g :func-circle gen-func-circle)

        gen-prop-vertical-align
        (igen/freq :prop-vertical-align [
          [(get w [:prop-vertical-align :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-vertical-align :alt 1] 100)
            (gen/return "baseline ")]
          [(get w [:prop-vertical-align :alt 2] 100)
            (gen/return "sub ")]
          [(get w [:prop-vertical-align :alt 3] 100)
            (gen/return "super ")]
          [(get w [:prop-vertical-align :alt 4] 100)
            (gen/return "text-top ")]
          [(get w [:prop-vertical-align :alt 5] 100)
            (gen/return "text-bottom ")]
          [(get w [:prop-vertical-align :alt 6] 100)
            (gen/return "middle ")]
          [(get w [:prop-vertical-align :alt 7] 100)
            (gen/return "top ")]
          [(get w [:prop-vertical-align :alt 8] 100)
            (gen/return "bottom ")]
          [(get w [:prop-vertical-align :alt 9] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-vertical-align :alt 10] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-vertical-align gen-prop-vertical-align)

        gen-prop-animation-delay
        (igen/freq :prop-animation-delay [
          [(get w [:prop-animation-delay :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-delay :alt 1] 100)
            (gen/tuple
              (:nonprop-time g)
              (igen/freq :prop-animation-delay [
                [(get w [:prop-animation-delay :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-delay :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-time g)))]]))]])
        g (assoc g :prop-animation-delay gen-prop-animation-delay)

        gen-nonprop-step-position
        (igen/freq :nonprop-step-position [
          [(get w [:nonprop-step-position :alt 0] 100)
            (gen/return "jump-start ")]
          [(get w [:nonprop-step-position :alt 1] 100)
            (gen/return "jump-end ")]
          [(get w [:nonprop-step-position :alt 2] 100)
            (gen/return "jump-none ")]
          [(get w [:nonprop-step-position :alt 3] 100)
            (gen/return "jump-both ")]
          [(get w [:nonprop-step-position :alt 4] 100)
            (gen/return "start ")]
          [(get w [:nonprop-step-position :alt 5] 100)
            (gen/return "end ")]])
        g (assoc g :nonprop-step-position gen-nonprop-step-position)

        gen-nonprop-step-timing-function
        (igen/freq :nonprop-step-timing-function [
          [(get w [:nonprop-step-timing-function :alt 0] 100)
            (gen/return "step-start ")]
          [(get w [:nonprop-step-timing-function :alt 1] 100)
            (gen/return "step-end ")]
          [(get w [:nonprop-step-timing-function :alt 2] 100)
            (gen/tuple
              (gen/return "steps ")
              (gen/return "( ")
              (:nonprop-integer g)
              (igen/freq :nonprop-step-timing-function [
                [(get w [:nonprop-step-timing-function :alt 2 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-step-timing-function :alt 2 :cat 3 :opt 0] 100)
                  (gen/tuple
                    (gen/return ", ")
                    (:nonprop-step-position g))]])
              (gen/return ") "))]])
        g (assoc g :nonprop-step-timing-function gen-nonprop-step-timing-function)

        gen-nonprop-cubic-bezier-timing-function
        (igen/freq :nonprop-cubic-bezier-timing-function [
          [(get w [:nonprop-cubic-bezier-timing-function :alt 0] 100)
            (gen/return "ease ")]
          [(get w [:nonprop-cubic-bezier-timing-function :alt 1] 100)
            (gen/return "ease-in ")]
          [(get w [:nonprop-cubic-bezier-timing-function :alt 2] 100)
            (gen/return "ease-out ")]
          [(get w [:nonprop-cubic-bezier-timing-function :alt 3] 100)
            (gen/return "ease-in-out ")]
          [(get w [:nonprop-cubic-bezier-timing-function :alt 4] 100)
            (gen/tuple
              (gen/return "cubic-bezier ")
              (gen/return "( ")
              (:nonprop-number g)
              (gen/return ",")
              (gen/return " ")
              (:nonprop-number g)
              (gen/return ", ")
              (:nonprop-number g)
              (gen/return ",")
              (gen/return " ")
              (:nonprop-number g)
              (gen/return ") "))]])
        g (assoc g :nonprop-cubic-bezier-timing-function gen-nonprop-cubic-bezier-timing-function)

        gen-nonprop-timing-function
        (igen/freq :nonprop-timing-function [
          [(get w [:nonprop-timing-function :alt 0] 100)
            (gen/return "linear ")]
          [(get w [:nonprop-timing-function :alt 1] 100)
            (:nonprop-cubic-bezier-timing-function g)]
          [(get w [:nonprop-timing-function :alt 2] 100)
            (:nonprop-step-timing-function g)]])
        g (assoc g :nonprop-timing-function gen-nonprop-timing-function)

        gen-prop-caption-side
        (igen/freq :prop-caption-side [
          [(get w [:prop-caption-side :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-caption-side :alt 1] 100)
            (gen/return "top ")]
          [(get w [:prop-caption-side :alt 2] 100)
            (gen/return "bottom ")]
          [(get w [:prop-caption-side :alt 3] 100)
            (gen/return "block-start ")]
          [(get w [:prop-caption-side :alt 4] 100)
            (gen/return "block-end ")]
          [(get w [:prop-caption-side :alt 5] 100)
            (gen/return "inline-start ")]
          [(get w [:prop-caption-side :alt 6] 100)
            (gen/return "inline-end ")]])
        g (assoc g :prop-caption-side gen-prop-caption-side)

        gen-prop-text-transform
        (igen/freq :prop-text-transform [
          [(get w [:prop-text-transform :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-transform :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-text-transform :alt 2] 100)
            (gen/return "capitalize ")]
          [(get w [:prop-text-transform :alt 3] 100)
            (gen/return "uppercase ")]
          [(get w [:prop-text-transform :alt 4] 100)
            (gen/return "lowercase ")]
          [(get w [:prop-text-transform :alt 5] 100)
            (gen/return "full-width ")]
          [(get w [:prop-text-transform :alt 6] 100)
            (gen/return "full-size-kana ")]])
        g (assoc g :prop-text-transform gen-prop-text-transform)

        gen-prop-rotate
        (igen/freq :prop-rotate [
          [(get w [:prop-rotate :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-rotate :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-rotate :alt 2] 100)
            (:nonprop-angle g)]
          [(get w [:prop-rotate :alt 3] 100)
            (gen/tuple
              (igen/freq :prop-rotate [
                [(get w [:prop-rotate :alt 3 :cat 0 :alt 0] 100)
                  (gen/return "x ")]
                [(get w [:prop-rotate :alt 3 :cat 0 :alt 1] 100)
                  (gen/return "y ")]
                [(get w [:prop-rotate :alt 3 :cat 0 :alt 2] 100)
                  (gen/return "z ")]
                [(get w [:prop-rotate :alt 3 :cat 0 :alt 3] 100)
                  (gen/tuple
                    (:nonprop-number g)
                    (gen/return " ")
                    (:nonprop-number g)
                    (gen/return " ")
                    (:nonprop-number g))]])
              (:nonprop-angle g))]])
        g (assoc g :prop-rotate gen-prop-rotate)

        gen-func-minmax
        (gen/tuple
          (gen/return "minmax ")
          (gen/return "( ")
          (igen/freq :func-minmax [
            [(get w [:func-minmax :cat 2 :alt 0] 100)
              (:nonprop-length g)]
            [(get w [:func-minmax :cat 2 :alt 1] 100)
              (:nonprop-percentage g)]
            [(get w [:func-minmax :cat 2 :alt 2] 100)
              (:nonprop-flex g)]
            [(get w [:func-minmax :cat 2 :alt 3] 100)
              (gen/return "min-content ")]
            [(get w [:func-minmax :cat 2 :alt 4] 100)
              (gen/return "max-content ")]
            [(get w [:func-minmax :cat 2 :alt 5] 100)
              (gen/return "auto ")]])
          (gen/return ", ")
          (igen/freq :func-minmax [
            [(get w [:func-minmax :cat 4 :alt 0] 100)
              (:nonprop-length g)]
            [(get w [:func-minmax :cat 4 :alt 1] 100)
              (:nonprop-percentage g)]
            [(get w [:func-minmax :cat 4 :alt 2] 100)
              (:nonprop-flex g)]
            [(get w [:func-minmax :cat 4 :alt 3] 100)
              (gen/return "min-content ")]
            [(get w [:func-minmax :cat 4 :alt 4] 100)
              (gen/return "max-content ")]
            [(get w [:func-minmax :cat 4 :alt 5] 100)
              (gen/return "auto ")]])
          (gen/return ") "))
        g (assoc g :func-minmax gen-func-minmax)

        gen-nonprop-calc-value
        (:any-number g)
        g (assoc g :nonprop-calc-value gen-nonprop-calc-value)

        gen-nonprop-calc-product
        (gen/tuple
          (:nonprop-calc-value g)
          (igen/freq :nonprop-calc-product [
            [(get w [:nonprop-calc-product :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-calc-product :cat 1 :star 0] 100)
              (igen/vector+
                (igen/freq :nonprop-calc-product [
                  [(get w [:nonprop-calc-product :cat 1 :star 0 :alt 0] 100)
                    (gen/tuple
                      (gen/return "* ")
                      (:nonprop-calc-value g))]
                  [(get w [:nonprop-calc-product :cat 1 :star 0 :alt 1] 100)
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-number g))]]))]]))
        g (assoc g :nonprop-calc-product gen-nonprop-calc-product)]
    g))

(defn- css3-generators-part-2 [gmap weights]
  (let [g gmap
        w weights

        gen-nonprop-calc-sum
        (gen/tuple
          (:nonprop-calc-product g)
          (igen/freq :nonprop-calc-sum [
            [(get w [:nonprop-calc-sum :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-calc-sum :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (igen/freq :nonprop-calc-sum [
                    [(get w [:nonprop-calc-sum :cat 1 :star 0 :cat 0 :alt 0] 100)
                      (gen/return "+ ")]
                    [(get w [:nonprop-calc-sum :cat 1 :star 0 :cat 0 :alt 1] 100)
                      (gen/return "- ")]])
                  (:nonprop-calc-product g)))]]))
        g (assoc g :nonprop-calc-sum gen-nonprop-calc-sum)

        gen-func-calc
        (gen/tuple
          (gen/return "calc ")
          (gen/return "( ")
          (:nonprop-calc-sum g)
          (gen/return ") "))
        g (assoc g :func-calc gen-func-calc)

        gen-prop-unknown
        (gen/tuple
          (gen/return " ")
          (igen/freq :prop-unknown [
            [(get w [:prop-unknown :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:prop-unknown :cat 1 :star 0] 100)
              (igen/vector+
                (igen/freq :prop-unknown [
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 0] 100)
                    (:nonprop-custom-ident g)]
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 1] 100)
                    (gen/tuple
                      (:nonprop-string g)
                      (gen/return " "))]
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 2] 100)
                    (gen/tuple
                      (:nonprop-number g)
                      (gen/return " "))]
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 3] 100)
                    (gen/tuple
                      (:nonprop-percentage g)
                      (gen/return " "))]
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 4] 100)
                    (gen/tuple
                      (:nonprop-hex-color g)
                      (gen/return " "))]
                  [(get w [:prop-unknown :cat 1 :star 0 :alt 5] 100)
                    (:func-calc g)]]))]]))
        g (assoc g :prop-unknown gen-prop-unknown)

        gen-css-unknown
        (gen/tuple
          (chuck/string-from-regex #"[A-Za-z-]+")
          (gen/return " ")
          (gen/return ":")
          (gen/return " ")
          (igen/freq :css-unknown [
            [(get w [:css-unknown :cat 4 :alt 0] 100)
              (:prop-all g)]
            [(get w [:css-unknown :cat 4 :alt 1] 100)
              (:prop-unknown g)]]))
        g (assoc g :css-unknown gen-css-unknown)

        gen-nonprop-repeat-style
        (igen/freq :nonprop-repeat-style [
          [(get w [:nonprop-repeat-style :alt 0] 100)
            (gen/return "repeat-x ")]
          [(get w [:nonprop-repeat-style :alt 1] 100)
            (gen/return "repeat-y ")]
          [(get w [:nonprop-repeat-style :alt 2] 100)
            (igen/freq :nonprop-repeat-style [
              [(get w [:nonprop-repeat-style :alt 2 :alt 0] 100)
                (igen/freq :nonprop-repeat-style [
                  [(get w [:nonprop-repeat-style :alt 2 :alt 0 :alt 0] 100)
                    (gen/return "repeat ")]
                  [(get w [:nonprop-repeat-style :alt 2 :alt 0 :alt 1] 100)
                    (gen/return "space ")]
                  [(get w [:nonprop-repeat-style :alt 2 :alt 0 :alt 2] 100)
                    (gen/return "round ")]
                  [(get w [:nonprop-repeat-style :alt 2 :alt 0 :alt 3] 100)
                    (gen/return "no-repeat ")]])]
              [(get w [:nonprop-repeat-style :alt 2 :alt 1] 100)
                (gen/tuple
                  (igen/freq :nonprop-repeat-style [
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "repeat ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "space ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "round ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 0 :alt 3] 100)
                      (gen/return "no-repeat ")]])
                  (gen/return " ")
                  (igen/freq :nonprop-repeat-style [
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "repeat ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "space ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "round ")]
                    [(get w [:nonprop-repeat-style :alt 2 :alt 1 :cat 2 :alt 3] 100)
                      (gen/return "no-repeat ")]]))]])]])
        g (assoc g :nonprop-repeat-style gen-nonprop-repeat-style)

        gen-prop-font-synthesis
        (igen/freq :prop-font-synthesis [
          [(get w [:prop-font-synthesis :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-synthesis :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-font-synthesis :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-font-synthesis [
                [(get w [:prop-font-synthesis :alt 2 :plus 0 :alt 0] 100)
                  (gen/return "weight ")]
                [(get w [:prop-font-synthesis :alt 2 :plus 0 :alt 1] 100)
                  (gen/return "style ")]]))]])
        g (assoc g :prop-font-synthesis gen-prop-font-synthesis)

        gen-prop-min-height
        (igen/freq :prop-min-height [
          [(get w [:prop-min-height :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-min-height :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-min-height :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-min-height :alt 3] 100)
            (gen/return "auto ")]
          [(get w [:prop-min-height :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-min-height :alt 5] 100)
            (gen/return "min-content ")]
          [(get w [:prop-min-height :alt 6] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-min-height :alt 7] 100)
            (gen/return "fill-available ")]])
        g (assoc g :prop-min-height gen-prop-min-height)

        gen-nonprop-range
        (gen/return "STUB_range")
        g (assoc g :nonprop-range gen-nonprop-range)

        gen-nonprop-keyframe-selector
        (igen/freq :nonprop-keyframe-selector [
          [(get w [:nonprop-keyframe-selector :alt 0] 100)
            (gen/return "from ")]
          [(get w [:nonprop-keyframe-selector :alt 1] 100)
            (gen/return "to ")]
          [(get w [:nonprop-keyframe-selector :alt 2] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-keyframe-selector gen-nonprop-keyframe-selector)

        gen-prop-scroll-margin-inline-end
        (igen/freq :prop-scroll-margin-inline-end [
          [(get w [:prop-scroll-margin-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-inline-end :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-inline-end :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-inline-end gen-prop-scroll-margin-inline-end)

        gen-prop-border-right-style
        (igen/freq :prop-border-right-style [
          [(get w [:prop-border-right-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-right-style :alt 1] 100)
            (:nonprop-line-style g)]])
        g (assoc g :prop-border-right-style gen-prop-border-right-style)

        gen-prop-transform-origin
        (igen/freq :prop-transform-origin [
          [(get w [:prop-transform-origin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transform-origin :alt 1] 100)
            (igen/freq :prop-transform-origin [
              [(get w [:prop-transform-origin :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-transform-origin :alt 1 :alt 1] 100)
                (gen/return "left ")]
              [(get w [:prop-transform-origin :alt 1 :alt 2] 100)
                (gen/return "center ")]
              [(get w [:prop-transform-origin :alt 1 :alt 3] 100)
                (gen/return "right ")]
              [(get w [:prop-transform-origin :alt 1 :alt 4] 100)
                (gen/return "top ")]
              [(get w [:prop-transform-origin :alt 1 :alt 5] 100)
                (gen/return "bottom ")]])]
          [(get w [:prop-transform-origin :alt 2] 100)
            (gen/tuple
              (gen/tuple
                (igen/freq :prop-transform-origin [
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 0 :alt 0] 100)
                    (:nonprop-length-percentage g)]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 0 :alt 1] 100)
                    (gen/return "left ")]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 0 :alt 2] 100)
                    (gen/return "center ")]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 0 :alt 3] 100)
                    (gen/return "right ")]])
                (igen/freq :prop-transform-origin [
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 1 :alt 0] 100)
                    (:nonprop-length-percentage g)]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 1 :alt 1] 100)
                    (gen/return "top ")]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 1 :alt 2] 100)
                    (gen/return "center ")]
                  [(get w [:prop-transform-origin :alt 2 :cat 0 :cat 1 :alt 3] 100)
                    (gen/return "bottom ")]]))
              (igen/freq :prop-transform-origin [
                [(get w [:prop-transform-origin :alt 2 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-transform-origin :alt 2 :cat 1 :opt 0] 100)
                  (:nonprop-length g)]]))]])
        g (assoc g :prop-transform-origin gen-prop-transform-origin)

        gen-prop-font-size-adjust
        (igen/freq :prop-font-size-adjust [
          [(get w [:prop-font-size-adjust :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-size-adjust :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-font-size-adjust :alt 2] 100)
            (:nonprop-number g)]])
        g (assoc g :prop-font-size-adjust gen-prop-font-size-adjust)

        gen-positive-integer
        gen/s-pos-int
        g (assoc g :positive-integer gen-positive-integer)

        gen-nonprop-ratio
        (gen/tuple
          (:positive-integer g)
          (gen/return "/")
          (:positive-integer g))
        g (assoc g :nonprop-ratio gen-nonprop-ratio)

        gen-nonprop-dimension
        (:nonprop-resolution g)
        g (assoc g :nonprop-dimension gen-nonprop-dimension)

        gen-nonprop-mf-value
        (igen/freq :nonprop-mf-value [
          [(get w [:nonprop-mf-value :alt 0] 100)
            (:nonprop-number g)]
          [(get w [:nonprop-mf-value :alt 1] 100)
            (:nonprop-dimension g)]
          [(get w [:nonprop-mf-value :alt 2] 100)
            (:nonprop-ident g)]
          [(get w [:nonprop-mf-value :alt 3] 100)
            (:nonprop-ratio g)]])
        g (assoc g :nonprop-mf-value gen-nonprop-mf-value)

        gen-nonprop-mf-name
        (:nonprop-ident g)
        g (assoc g :nonprop-mf-name gen-nonprop-mf-name)

        gen-nonprop-mf-range
        (igen/freq :nonprop-mf-range [
          [(get w [:nonprop-mf-range :alt 0] 100)
            (gen/tuple
              (:nonprop-mf-name g)
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 0 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 0 :cat 1 :opt 0] 100)
                  (igen/freq :nonprop-mf-range [
                    [(get w [:nonprop-mf-range :alt 0 :cat 1 :opt 0 :alt 0] 100)
                      (gen/return "< ")]
                    [(get w [:nonprop-mf-range :alt 0 :cat 1 :opt 0 :alt 1] 100)
                      (gen/return "> ")]])]])
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 0 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 0 :cat 2 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-value g))]
          [(get w [:nonprop-mf-range :alt 1] 100)
            (gen/tuple
              (:nonprop-mf-value g)
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 1 :cat 1 :opt 0] 100)
                  (igen/freq :nonprop-mf-range [
                    [(get w [:nonprop-mf-range :alt 1 :cat 1 :opt 0 :alt 0] 100)
                      (gen/return "< ")]
                    [(get w [:nonprop-mf-range :alt 1 :cat 1 :opt 0 :alt 1] 100)
                      (gen/return "> ")]])]])
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 1 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 1 :cat 2 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-name g))]
          [(get w [:nonprop-mf-range :alt 2] 100)
            (gen/tuple
              (:nonprop-mf-value g)
              (gen/return "< ")
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 2 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 2 :cat 2 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-name g)
              (gen/return "< ")
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 2 :cat 5 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 2 :cat 5 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-value g))]
          [(get w [:nonprop-mf-range :alt 3] 100)
            (gen/tuple
              (:nonprop-mf-value g)
              (gen/return "> ")
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 3 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 3 :cat 2 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-name g)
              (gen/return "> ")
              (igen/freq :nonprop-mf-range [
                [(get w [:nonprop-mf-range :alt 3 :cat 5 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-mf-range :alt 3 :cat 5 :opt 0] 100)
                  (gen/return "= ")]])
              (:nonprop-mf-value g))]])
        g (assoc g :nonprop-mf-range gen-nonprop-mf-range)

        gen-nonprop-mf-plain
        (gen/tuple
          (:nonprop-mf-name g)
          (gen/return ": ")
          (:nonprop-mf-value g))
        g (assoc g :nonprop-mf-plain gen-nonprop-mf-plain)

        gen-nonprop-mf-boolean
        (:nonprop-mf-name g)
        g (assoc g :nonprop-mf-boolean gen-nonprop-mf-boolean)

        gen-nonprop-media-feature
        (gen/tuple
          (gen/return "( ")
          (igen/freq :nonprop-media-feature [
            [(get w [:nonprop-media-feature :cat 1 :alt 0] 100)
              (:nonprop-mf-plain g)]
            [(get w [:nonprop-media-feature :cat 1 :alt 1] 100)
              (:nonprop-mf-boolean g)]
            [(get w [:nonprop-media-feature :cat 1 :alt 2] 100)
              (:nonprop-mf-range g)]])
          (gen/return ") "))
        g (assoc g :nonprop-media-feature gen-nonprop-media-feature)

        gen-IDENT
        gen/symbol
        g (assoc g :IDENT gen-IDENT)

        gen-css-class
        (gen/tuple
          (gen/return ".")
          (:IDENT g))
        g (assoc g :css-class gen-css-class)

        gen-css-ns-pre
        (gen/tuple
          (igen/freq :css-ns-pre [
            [(get w [:css-ns-pre :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-ns-pre :cat 0 :opt 0] 100)
              (igen/freq :css-ns-pre [
                [(get w [:css-ns-pre :cat 0 :opt 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-ns-pre :cat 0 :opt 0 :opt 0] 100)
                  (igen/freq :css-ns-pre [
                    [(get w [:css-ns-pre :cat 0 :opt 0 :opt 0 :alt 0] 100)
                      (:IDENT g)]
                    [(get w [:css-ns-pre :cat 0 :opt 0 :opt 0 :alt 1] 100)
                      (gen/return "*")]])]])]])
          (gen/return "|"))
        g (assoc g :css-ns-pre gen-css-ns-pre)

        gen-STRING
        (:quoted-string g)
        g (assoc g :STRING gen-STRING)

        gen-css-attr
        (gen/tuple
          (gen/return "[")
          (gen/return " ")
          (igen/freq :css-attr [
            [(get w [:css-attr :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-attr :cat 2 :opt 0] 100)
              (igen/freq :css-attr [
                [(get w [:css-attr :cat 2 :opt 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-attr :cat 2 :opt 0 :opt 0] 100)
                  (:css-ns-pre g)]])]])
          (:IDENT g)
          (gen/return " ")
          (igen/freq :css-attr [
            [(get w [:css-attr :cat 5 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-attr :cat 5 :opt 0] 100)
              (igen/freq :css-attr [
                [(get w [:css-attr :cat 5 :opt 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-attr :cat 5 :opt 0 :opt 0] 100)
                  (gen/tuple
                    (igen/freq :css-attr [
                      [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0] 100)
                        (igen/freq :css-attr [
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 0] 100)
                            (gen/return "^=")]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 1] 100)
                            (gen/return "$=")]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 2] 100)
                            (gen/return "*=")]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 3] 100)
                            (gen/return "=")]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 4] 100)
                            (gen/return "~=")]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 0 :opt 0 :alt 5] 100)
                            (gen/return "|=")]])]])
                    (gen/return " ")
                    (igen/freq :css-attr [
                      [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 2 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 2 :opt 0] 100)
                        (igen/freq :css-attr [
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 2 :opt 0 :alt 0] 100)
                            (:IDENT g)]
                          [(get w [:css-attr :cat 5 :opt 0 :opt 0 :cat 2 :opt 0 :alt 1] 100)
                            (:STRING g)]])]])
                    (gen/return " "))]])]])
          (gen/return "]"))
        g (assoc g :css-attr gen-css-attr)

        gen-NUMBER
        (:any-number g)
        g (assoc g :NUMBER gen-NUMBER)

        gen-css-expr
        (igen/vector+
          (igen/freq :css-expr [
            [(get w [:css-expr :plus 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-expr :plus 0 :opt 0] 100)
              (gen/tuple
                (igen/freq :css-expr [
                  [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0] 100)
                    (igen/freq :css-expr [
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 0] 100)
                        (gen/return "+")]
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 1] 100)
                        (gen/return "-")]
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 2] 100)
                        (gen/tuple
                          (:NUMBER g)
                          (gen/return "%"))]
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 3] 100)
                        (:NUMBER g)]
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 4] 100)
                        (:STRING g)]
                      [(get w [:css-expr :plus 0 :opt 0 :cat 0 :opt 0 :alt 5] 100)
                        (:IDENT g)]])]])
                (gen/return " "))]]))
        g (assoc g :css-expr gen-css-expr)

        gen-css-func
        (gen/tuple
          (:IDENT g)
          (gen/return "(")
          (gen/return " ")
          (:css-expr g)
          (gen/return ") "))
        g (assoc g :css-func gen-css-func)

        gen-css-psuedo
        (gen/tuple
          (gen/return ":")
          (igen/freq :css-psuedo [
            [(get w [:css-psuedo :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-psuedo :cat 1 :opt 0] 100)
              (gen/return ":")]])
          (igen/freq :css-psuedo [
            [(get w [:css-psuedo :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-psuedo :cat 2 :opt 0] 100)
              (igen/freq :css-psuedo [
                [(get w [:css-psuedo :cat 2 :opt 0 :alt 0] 100)
                  (:IDENT g)]
                [(get w [:css-psuedo :cat 2 :opt 0 :alt 1] 100)
                  (:css-func g)]])]]))
        g (assoc g :css-psuedo gen-css-psuedo)

        gen-css-hash
        (gen/tuple
          (gen/return "#")
          (:IDENT g))
        g (assoc g :css-hash gen-css-hash)

        gen-css-type
        (gen/tuple
          (igen/freq :css-type [
            [(get w [:css-type :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-type :cat 0 :opt 0] 100)
              (igen/freq :css-type [
                [(get w [:css-type :cat 0 :opt 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-type :cat 0 :opt 0 :opt 0] 100)
                  (:css-ns-pre g)]])]])
          (:IDENT g))
        g (assoc g :css-type gen-css-type)

        gen-css-univ
        (gen/tuple
          (igen/freq :css-univ [
            [(get w [:css-univ :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-univ :cat 0 :opt 0] 100)
              (igen/freq :css-univ [
                [(get w [:css-univ :cat 0 :opt 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-univ :cat 0 :opt 0 :opt 0] 100)
                  (:css-ns-pre g)]])]])
          (gen/return "*"))
        g (assoc g :css-univ gen-css-univ)

        gen-css-negate
        (gen/tuple
          (gen/return ":not(")
          (gen/return " ")
          (igen/freq :css-negate [
            [(get w [:css-negate :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:css-negate :cat 2 :opt 0] 100)
              (igen/freq :css-negate [
                [(get w [:css-negate :cat 2 :opt 0 :alt 0] 100)
                  (:css-type g)]
                [(get w [:css-negate :cat 2 :opt 0 :alt 1] 100)
                  (:css-univ g)]
                [(get w [:css-negate :cat 2 :opt 0 :alt 2] 100)
                  (:css-hash g)]
                [(get w [:css-negate :cat 2 :opt 0 :alt 3] 100)
                  (:css-class g)]
                [(get w [:css-negate :cat 2 :opt 0 :alt 4] 100)
                  (:css-attr g)]
                [(get w [:css-negate :cat 2 :opt 0 :alt 5] 100)
                  (:css-psuedo g)]])]])
          (gen/return " )"))
        g (assoc g :css-negate gen-css-negate)

        gen-nonprop-self-position
        (igen/freq :nonprop-self-position [
          [(get w [:nonprop-self-position :alt 0] 100)
            (gen/return "center ")]
          [(get w [:nonprop-self-position :alt 1] 100)
            (gen/return "start ")]
          [(get w [:nonprop-self-position :alt 2] 100)
            (gen/return "end ")]
          [(get w [:nonprop-self-position :alt 3] 100)
            (gen/return "self-start ")]
          [(get w [:nonprop-self-position :alt 4] 100)
            (gen/return "self-end ")]
          [(get w [:nonprop-self-position :alt 5] 100)
            (gen/return "flex-start ")]
          [(get w [:nonprop-self-position :alt 6] 100)
            (gen/return "flex-end ")]])
        g (assoc g :nonprop-self-position gen-nonprop-self-position)

        gen-nonprop-baseline-position
        (gen/tuple
          (igen/freq :nonprop-baseline-position [
            [(get w [:nonprop-baseline-position :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-baseline-position :cat 0 :opt 0] 100)
              (igen/freq :nonprop-baseline-position [
                [(get w [:nonprop-baseline-position :cat 0 :opt 0 :alt 0] 100)
                  (gen/return "first ")]
                [(get w [:nonprop-baseline-position :cat 0 :opt 0 :alt 1] 100)
                  (gen/return "last ")]])]])
          (gen/return "baseline "))
        g (assoc g :nonprop-baseline-position gen-nonprop-baseline-position)

        gen-nonprop-overflow-position
        (igen/freq :nonprop-overflow-position [
          [(get w [:nonprop-overflow-position :alt 0] 100)
            (gen/return "unsafe ")]
          [(get w [:nonprop-overflow-position :alt 1] 100)
            (gen/return "safe ")]])
        g (assoc g :nonprop-overflow-position gen-nonprop-overflow-position)

        gen-prop-align-items
        (igen/freq :prop-align-items [
          [(get w [:prop-align-items :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-align-items :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-align-items :alt 2] 100)
            (gen/return "stretch ")]
          [(get w [:prop-align-items :alt 3] 100)
            (:nonprop-baseline-position g)]
          [(get w [:prop-align-items :alt 4] 100)
            (gen/tuple
              (igen/freq :prop-align-items [
                [(get w [:prop-align-items :alt 4 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-align-items :alt 4 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (:nonprop-self-position g))]])
        g (assoc g :prop-align-items gen-prop-align-items)

        gen-prop-border-right
        (igen/freq :prop-border-right [
          [(get w [:prop-border-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-right :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-right [
                [(get w [:prop-border-right :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-line-width g)]
                [(get w [:prop-border-right :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-line-style g)]
                [(get w [:prop-border-right :alt 1 :plus 0 :alt 2] 100)
                  (:nonprop-color g)]]))]])
        g (assoc g :prop-border-right gen-prop-border-right)

        gen-nonprop-image-src
        (igen/freq :nonprop-image-src [
          [(get w [:nonprop-image-src :alt 0] 100)
            (:nonprop-url g)]
          [(get w [:nonprop-image-src :alt 1] 100)
            (:nonprop-string g)]])
        g (assoc g :nonprop-image-src gen-nonprop-image-src)

        gen-prop-font-optical-sizing
        (igen/freq :prop-font-optical-sizing [
          [(get w [:prop-font-optical-sizing :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-optical-sizing :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-font-optical-sizing :alt 2] 100)
            (gen/return "none ")]])
        g (assoc g :prop-font-optical-sizing gen-prop-font-optical-sizing)

        gen-prop-margin-left
        (igen/freq :prop-margin-left [
          [(get w [:prop-margin-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-left :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-margin-left :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-margin-left :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-margin-left gen-prop-margin-left)

        gen-prop-margin-block
        (igen/freq :prop-margin-block [
          [(get w [:prop-margin-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-block :alt 1] 100)
            (igen/freq :prop-margin-block [
              [(get w [:prop-margin-block :alt 1 :alt 0] 100)
                (:prop-margin-left g)]
              [(get w [:prop-margin-block :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-margin-left g)
                  (gen/return " ")
                  (:prop-margin-left g))]])]])
        g (assoc g :prop-margin-block gen-prop-margin-block)

        gen-nonprop-namespace-prefix
        (:nonprop-ident g)
        g (assoc g :nonprop-namespace-prefix gen-nonprop-namespace-prefix)

        gen-prop-AT-namespace
        (gen/tuple
          (gen/return "@namespace ")
          (igen/freq :prop-AT-namespace [
            [(get w [:prop-AT-namespace :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:prop-AT-namespace :cat 1 :opt 0] 100)
              (:nonprop-namespace-prefix g)]])
          (igen/freq :prop-AT-namespace [
            [(get w [:prop-AT-namespace :cat 2 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:prop-AT-namespace :cat 2 :alt 1] 100)
              (:nonprop-url g)]])
          (gen/return "; "))
        g (assoc g :prop-AT-namespace gen-prop-AT-namespace)

        gen-nonprop-box
        (igen/freq :nonprop-box [
          [(get w [:nonprop-box :alt 0] 100)
            (gen/return "border-box ")]
          [(get w [:nonprop-box :alt 1] 100)
            (gen/return "padding-box ")]
          [(get w [:nonprop-box :alt 2] 100)
            (gen/return "content-box ")]])
        g (assoc g :nonprop-box gen-nonprop-box)

        gen-nonprop-shape-box
        (igen/freq :nonprop-shape-box [
          [(get w [:nonprop-shape-box :alt 0] 100)
            (:nonprop-box g)]
          [(get w [:nonprop-shape-box :alt 1] 100)
            (gen/return "margin-box ")]])
        g (assoc g :nonprop-shape-box gen-nonprop-shape-box)

        gen-nonprop-geometry-box
        (igen/freq :nonprop-geometry-box [
          [(get w [:nonprop-geometry-box :alt 0] 100)
            (:nonprop-shape-box g)]
          [(get w [:nonprop-geometry-box :alt 1] 100)
            (gen/return "fill-box ")]
          [(get w [:nonprop-geometry-box :alt 2] 100)
            (gen/return "stroke-box ")]
          [(get w [:nonprop-geometry-box :alt 3] 100)
            (gen/return "view-box ")]])
        g (assoc g :nonprop-geometry-box gen-nonprop-geometry-box)

        gen-prop-column-fill
        (igen/freq :prop-column-fill [
          [(get w [:prop-column-fill :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-fill :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-column-fill :alt 2] 100)
            (gen/return "balance ")]
          [(get w [:prop-column-fill :alt 3] 100)
            (gen/return "balance-all ")]])
        g (assoc g :prop-column-fill gen-prop-column-fill)]
    g))

(defn- css3-generators-part-3 [gmap weights]
  (let [g gmap
        w weights

        gen-func-rotate
        (gen/tuple
          (gen/return "rotate ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-rotate gen-func-rotate)

        gen-prop-border-style
        (igen/freq :prop-border-style [
          [(get w [:prop-border-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-style :alt 1] 100)
            (igen/freq :prop-border-style [
              [(get w [:prop-border-style :alt 1 :alt 0] 100)
                (:nonprop-line-style g)]
              [(get w [:prop-border-style :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g))]
              [(get w [:prop-border-style :alt 1 :alt 2] 100)
                (gen/tuple
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g))]
              [(get w [:prop-border-style :alt 1 :alt 3] 100)
                (gen/tuple
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g)
                  (gen/return " ")
                  (:nonprop-line-style g))]])]])
        g (assoc g :prop-border-style gen-prop-border-style)

        gen-prop-column-rule-style
        (igen/freq :prop-column-rule-style [
          [(get w [:prop-column-rule-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-rule-style :alt 1] 100)
            (:prop-border-style g)]])
        g (assoc g :prop-column-rule-style gen-prop-column-rule-style)

        gen-nonprop-single-transition-property
        (igen/freq :nonprop-single-transition-property [
          [(get w [:nonprop-single-transition-property :alt 0] 100)
            (gen/return "all ")]
          [(get w [:nonprop-single-transition-property :alt 1] 100)
            (:nonprop-custom-ident g)]])
        g (assoc g :nonprop-single-transition-property gen-nonprop-single-transition-property)

        gen-nonprop-side-or-corner
        (igen/vector+
          (igen/freq :nonprop-side-or-corner [
            [(get w [:nonprop-side-or-corner :plus 0 :alt 0] 100)
              (igen/freq :nonprop-side-or-corner [
                [(get w [:nonprop-side-or-corner :plus 0 :alt 0 :alt 0] 100)
                  (gen/return "left ")]
                [(get w [:nonprop-side-or-corner :plus 0 :alt 0 :alt 1] 100)
                  (gen/return "right ")]])]
            [(get w [:nonprop-side-or-corner :plus 0 :alt 1] 100)
              (igen/freq :nonprop-side-or-corner [
                [(get w [:nonprop-side-or-corner :plus 0 :alt 1 :alt 0] 100)
                  (gen/return "top ")]
                [(get w [:nonprop-side-or-corner :plus 0 :alt 1 :alt 1] 100)
                  (gen/return "bottom ")]])]]))
        g (assoc g :nonprop-side-or-corner gen-nonprop-side-or-corner)

        gen-func-linear-gradient
        (gen/tuple
          (gen/return "linear-gradient ")
          (gen/return "( ")
          (igen/freq :func-linear-gradient [
            [(get w [:func-linear-gradient :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-linear-gradient :cat 2 :opt 0] 100)
              (igen/freq :func-linear-gradient [
                [(get w [:func-linear-gradient :cat 2 :opt 0 :alt 0] 100)
                  (:nonprop-angle g)]
                [(get w [:func-linear-gradient :cat 2 :opt 0 :alt 1] 100)
                  (gen/tuple
                    (gen/return "to ")
                    (:nonprop-side-or-corner g))]])]])
          (gen/return ", ")
          (:nonprop-color-stop-list g)
          (gen/return ") "))
        g (assoc g :func-linear-gradient gen-func-linear-gradient)

        gen-nonprop-numeric-figure-values
        (igen/freq :nonprop-numeric-figure-values [
          [(get w [:nonprop-numeric-figure-values :alt 0] 100)
            (gen/return "lining-nums ")]
          [(get w [:nonprop-numeric-figure-values :alt 1] 100)
            (gen/return "oldstyle-nums ")]])
        g (assoc g :nonprop-numeric-figure-values gen-nonprop-numeric-figure-values)

        gen-nonprop-numeric-spacing-values
        (igen/freq :nonprop-numeric-spacing-values [
          [(get w [:nonprop-numeric-spacing-values :alt 0] 100)
            (gen/return "proportional-nums ")]
          [(get w [:nonprop-numeric-spacing-values :alt 1] 100)
            (gen/return "tabular-nums ")]])
        g (assoc g :nonprop-numeric-spacing-values gen-nonprop-numeric-spacing-values)

        gen-nonprop-numeric-fraction-values
        (igen/freq :nonprop-numeric-fraction-values [
          [(get w [:nonprop-numeric-fraction-values :alt 0] 100)
            (gen/return "diagonal-fractions ")]
          [(get w [:nonprop-numeric-fraction-values :alt 1] 100)
            (gen/return "stacked-fractions ")]])
        g (assoc g :nonprop-numeric-fraction-values gen-nonprop-numeric-fraction-values)

        gen-prop-font-variant-numeric
        (igen/freq :prop-font-variant-numeric [
          [(get w [:prop-font-variant-numeric :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-numeric :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-numeric :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-font-variant-numeric [
                [(get w [:prop-font-variant-numeric :alt 2 :plus 0 :alt 0] 100)
                  (:nonprop-numeric-figure-values g)]
                [(get w [:prop-font-variant-numeric :alt 2 :plus 0 :alt 1] 100)
                  (:nonprop-numeric-spacing-values g)]
                [(get w [:prop-font-variant-numeric :alt 2 :plus 0 :alt 2] 100)
                  (:nonprop-numeric-fraction-values g)]
                [(get w [:prop-font-variant-numeric :alt 2 :plus 0 :alt 3] 100)
                  (gen/return "ordinal ")]
                [(get w [:prop-font-variant-numeric :alt 2 :plus 0 :alt 4] 100)
                  (gen/return "slashed-zero ")]]))]])
        g (assoc g :prop-font-variant-numeric gen-prop-font-variant-numeric)

        gen-NAME
        (chuck/string-from-regex #"[_A-Za-z0-9-]+")
        g (assoc g :NAME gen-NAME)

        gen-nonprop-leader-type
        (igen/freq :nonprop-leader-type [
          [(get w [:nonprop-leader-type :alt 0] 100)
            (gen/return "dotted ")]
          [(get w [:nonprop-leader-type :alt 1] 100)
            (gen/return "solid ")]
          [(get w [:nonprop-leader-type :alt 2] 100)
            (gen/return "space ")]
          [(get w [:nonprop-leader-type :alt 3] 100)
            (:nonprop-string g)]])
        g (assoc g :nonprop-leader-type gen-nonprop-leader-type)

        gen-func-leader
        (gen/tuple
          (gen/return "leader ")
          (gen/return "( ")
          (:nonprop-leader-type g)
          (gen/return ") "))
        g (assoc g :func-leader gen-func-leader)

        gen-nonprop-grid-line
        (igen/freq :nonprop-grid-line [
          [(get w [:nonprop-grid-line :alt 0] 100)
            (gen/return "auto ")]
          [(get w [:nonprop-grid-line :alt 1] 100)
            (:nonprop-custom-ident g)]
          [(get w [:nonprop-grid-line :alt 2] 100)
            (gen/tuple
              (:nonprop-integer g)
              (igen/freq :nonprop-grid-line [
                [(get w [:nonprop-grid-line :alt 2 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-grid-line :alt 2 :cat 1 :opt 0] 100)
                  (:nonprop-custom-ident g)]]))]
          [(get w [:nonprop-grid-line :alt 3] 100)
            (gen/tuple
              (gen/return "span ")
              (igen/vector+
                (igen/freq :nonprop-grid-line [
                  [(get w [:nonprop-grid-line :alt 3 :cat 1 :plus 0 :alt 0] 100)
                    (:nonprop-integer g)]
                  [(get w [:nonprop-grid-line :alt 3 :cat 1 :plus 0 :alt 1] 100)
                    (:nonprop-custom-ident g)]])))]])
        g (assoc g :nonprop-grid-line gen-nonprop-grid-line)

        gen-prop-grid-row-end
        (igen/freq :prop-grid-row-end [
          [(get w [:prop-grid-row-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-row-end :alt 1] 100)
            (:nonprop-grid-line g)]])
        g (assoc g :prop-grid-row-end gen-prop-grid-row-end)

        gen-charset
        (igen/freq :charset [
          [(get w [:charset :alt 0] 100)
            (gen/return "UTF-8")]
          [(get w [:charset :alt 1] 100)
            (gen/return "utf-8")]
          [(get w [:charset :alt 2] 100)
            (gen/return "iso-8859-15")]])
        g (assoc g :charset gen-charset)

        gen-nonprop-charset
        (:charset g)
        g (assoc g :nonprop-charset gen-nonprop-charset)

        gen-prop-AT-charset
        (gen/tuple
          (gen/return "@charset ")
          (gen/return "\" ")
          (:nonprop-charset g)
          (gen/return "\" ")
          (gen/return "; "))
        g (assoc g :prop-AT-charset gen-prop-AT-charset)

        gen-prop-inset-block-end
        (igen/freq :prop-inset-block-end [
          [(get w [:prop-inset-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-block-end :alt 1] 100)
            (:prop-top g)]])
        g (assoc g :prop-inset-block-end gen-prop-inset-block-end)

        gen-prop-scroll-padding-block
        (igen/freq :prop-scroll-padding-block [
          [(get w [:prop-scroll-padding-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-block :alt 1] 100)
            (igen/freq :prop-scroll-padding-block [
              [(get w [:prop-scroll-padding-block :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-padding-block [
                  [(get w [:prop-scroll-padding-block :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-padding-block :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-scroll-padding-block :alt 1 :alt 0 :alt 2] 100)
                    (:nonprop-percentage g)]])]
              [(get w [:prop-scroll-padding-block :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-padding-block [
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding-block [
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding-block :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (:nonprop-percentage g)]]))]])]])
        g (assoc g :prop-scroll-padding-block gen-prop-scroll-padding-block)

        gen-prop-clear
        (igen/freq :prop-clear [
          [(get w [:prop-clear :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-clear :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-clear :alt 2] 100)
            (gen/return "left ")]
          [(get w [:prop-clear :alt 3] 100)
            (gen/return "right ")]
          [(get w [:prop-clear :alt 4] 100)
            (gen/return "both ")]
          [(get w [:prop-clear :alt 5] 100)
            (gen/return "inline-start ")]
          [(get w [:prop-clear :alt 6] 100)
            (gen/return "inline-end ")]])
        g (assoc g :prop-clear gen-prop-clear)

        gen-nonprop-east-asian-variant-values
        (igen/freq :nonprop-east-asian-variant-values [
          [(get w [:nonprop-east-asian-variant-values :alt 0] 100)
            (gen/return "jis78 ")]
          [(get w [:nonprop-east-asian-variant-values :alt 1] 100)
            (gen/return "jis83 ")]
          [(get w [:nonprop-east-asian-variant-values :alt 2] 100)
            (gen/return "jis90 ")]
          [(get w [:nonprop-east-asian-variant-values :alt 3] 100)
            (gen/return "jis04 ")]
          [(get w [:nonprop-east-asian-variant-values :alt 4] 100)
            (gen/return "simplified ")]
          [(get w [:nonprop-east-asian-variant-values :alt 5] 100)
            (gen/return "traditional ")]])
        g (assoc g :nonprop-east-asian-variant-values gen-nonprop-east-asian-variant-values)

        gen-prop-outline-offset
        (igen/freq :prop-outline-offset [
          [(get w [:prop-outline-offset :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-outline-offset :alt 1] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-outline-offset gen-prop-outline-offset)

        gen-nonprop-viewport-length
        (igen/freq :nonprop-viewport-length [
          [(get w [:nonprop-viewport-length :alt 0] 100)
            (gen/return "auto ")]
          [(get w [:nonprop-viewport-length :alt 1] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :nonprop-viewport-length gen-nonprop-viewport-length)

        gen-prop-border-width
        (igen/freq :prop-border-width [
          [(get w [:prop-border-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-width :alt 1] 100)
            (igen/freq :prop-border-width [
              [(get w [:prop-border-width :alt 1 :alt 0] 100)
                (:nonprop-line-width g)]
              [(get w [:prop-border-width :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g))]
              [(get w [:prop-border-width :alt 1 :alt 2] 100)
                (gen/tuple
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g))]
              [(get w [:prop-border-width :alt 1 :alt 3] 100)
                (gen/tuple
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g)
                  (gen/return " ")
                  (:nonprop-line-width g))]])]])
        g (assoc g :prop-border-width gen-prop-border-width)

        gen-prop-column-rule-width
        (igen/freq :prop-column-rule-width [
          [(get w [:prop-column-rule-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-rule-width :alt 1] 100)
            (:prop-border-width g)]])
        g (assoc g :prop-column-rule-width gen-prop-column-rule-width)

        gen-prop-column-rule-color
        (igen/freq :prop-column-rule-color [
          [(get w [:prop-column-rule-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-rule-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-column-rule-color gen-prop-column-rule-color)

        gen-prop-column-rule
        (igen/freq :prop-column-rule [
          [(get w [:prop-column-rule :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-rule :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-column-rule [
                [(get w [:prop-column-rule :alt 1 :plus 0 :alt 0] 100)
                  (:prop-column-rule-width g)]
                [(get w [:prop-column-rule :alt 1 :plus 0 :alt 1] 100)
                  (:prop-column-rule-style g)]
                [(get w [:prop-column-rule :alt 1 :plus 0 :alt 2] 100)
                  (:prop-column-rule-color g)]]))]])
        g (assoc g :prop-column-rule gen-prop-column-rule)

        gen-nonprop-bg-image
        (igen/freq :nonprop-bg-image [
          [(get w [:nonprop-bg-image :alt 0] 100)
            (gen/return "none ")]
          [(get w [:nonprop-bg-image :alt 1] 100)
            (:nonprop-image g)]])
        g (assoc g :nonprop-bg-image gen-nonprop-bg-image)

        gen-func-skewY
        (gen/tuple
          (gen/return "skewY ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-skewY gen-func-skewY)

        gen-nonprop-positive-integer
        (:positive-integer g)
        g (assoc g :nonprop-positive-integer gen-nonprop-positive-integer)

        gen-nonprop-line-names
        (gen/tuple
          (gen/return "[ ")
          (igen/freq :nonprop-line-names [
            [(get w [:nonprop-line-names :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-line-names :cat 1 :star 0] 100)
              (igen/vector+
                (:nonprop-custom-ident g))]])
          (gen/return "] "))
        g (assoc g :nonprop-line-names gen-nonprop-line-names)

        gen-nonprop-track-size
        (igen/freq :nonprop-track-size [
          [(get w [:nonprop-track-size :alt 0] 100)
            (:nonprop-track-breadth g)]
          [(get w [:nonprop-track-size :alt 1] 100)
            (gen/tuple
              (gen/return "minmax ")
              (gen/return "( ")
              (:nonprop-inflexible-breadth g)
              (gen/return ", ")
              (:nonprop-track-breadth g)
              (gen/return ") "))]
          [(get w [:nonprop-track-size :alt 2] 100)
            (gen/tuple
              (gen/return "fit-content ")
              (gen/return "( ")
              (igen/freq :nonprop-track-size [
                [(get w [:nonprop-track-size :alt 2 :cat 2 :alt 0] 100)
                  (:nonprop-length g)]
                [(get w [:nonprop-track-size :alt 2 :cat 2 :alt 1] 100)
                  (:nonprop-percentage g)]])
              (gen/return ") "))]])
        g (assoc g :nonprop-track-size gen-nonprop-track-size)

        gen-nonprop-track-repeat
        (gen/tuple
          (gen/return "repeat ")
          (gen/return "( ")
          (:nonprop-positive-integer g)
          (gen/return ", ")
          (igen/vector+
            (gen/tuple
              (igen/freq :nonprop-track-repeat [
                [(get w [:nonprop-track-repeat :cat 4 :plus 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-track-repeat :cat 4 :plus 0 :cat 0 :opt 0] 100)
                  (:nonprop-line-names g)]])
              (:nonprop-track-size g)))
          (igen/freq :nonprop-track-repeat [
            [(get w [:nonprop-track-repeat :cat 5 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-track-repeat :cat 5 :opt 0] 100)
              (:nonprop-line-names g)]])
          (gen/return ") "))
        g (assoc g :nonprop-track-repeat gen-nonprop-track-repeat)

        gen-nonprop-track-list
        (gen/tuple
          (igen/vector+
            (gen/tuple
              (igen/freq :nonprop-track-list [
                [(get w [:nonprop-track-list :cat 0 :plus 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-track-list :cat 0 :plus 0 :cat 0 :opt 0] 100)
                  (:nonprop-line-names g)]])
              (igen/freq :nonprop-track-list [
                [(get w [:nonprop-track-list :cat 0 :plus 0 :cat 1 :alt 0] 100)
                  (:nonprop-track-size g)]
                [(get w [:nonprop-track-list :cat 0 :plus 0 :cat 1 :alt 1] 100)
                  (:nonprop-track-repeat g)]])))
          (igen/freq :nonprop-track-list [
            [(get w [:nonprop-track-list :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-track-list :cat 1 :opt 0] 100)
              (:nonprop-line-names g)]]))
        g (assoc g :nonprop-track-list gen-nonprop-track-list)

        gen-prop-orphans
        (igen/freq :prop-orphans [
          [(get w [:prop-orphans :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-orphans :alt 1] 100)
            (:nonprop-integer g)]])
        g (assoc g :prop-orphans gen-prop-orphans)

        gen-S
        (igen/freq :S [
          [(get w [:S :star nil] 100)
            (gen/return "")]
          [(get w [:S :star 0] 100)
            (igen/vector+
              (chuck/string-from-regex #"\s"))]])
        g (assoc g :S gen-S)

        gen-prop-shape-image-threshold
        (igen/freq :prop-shape-image-threshold [
          [(get w [:prop-shape-image-threshold :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-shape-image-threshold :alt 1] 100)
            (:nonprop-number g)]])
        g (assoc g :prop-shape-image-threshold gen-prop-shape-image-threshold)

        gen-func-scaleY
        (gen/tuple
          (gen/return "scaleY ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/return ") "))
        g (assoc g :func-scaleY gen-func-scaleY)

        gen-nonprop-discretionary-lig-values
        (igen/freq :nonprop-discretionary-lig-values [
          [(get w [:nonprop-discretionary-lig-values :alt 0] 100)
            (gen/return "discretionary-ligatures ")]
          [(get w [:nonprop-discretionary-lig-values :alt 1] 100)
            (gen/return "no-discretionary-ligatures ")]])
        g (assoc g :nonprop-discretionary-lig-values gen-nonprop-discretionary-lig-values)

        gen-prop-border-top-style
        (igen/freq :prop-border-top-style [
          [(get w [:prop-border-top-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top-style :alt 1] 100)
            (:nonprop-line-style g)]])
        g (assoc g :prop-border-top-style gen-prop-border-top-style)

        gen-prop-border-block-start-style
        (igen/freq :prop-border-block-start-style [
          [(get w [:prop-border-block-start-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-start-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-block-start-style gen-prop-border-block-start-style)

        gen-prop-text-emphasis-style
        (igen/freq :prop-text-emphasis-style [
          [(get w [:prop-text-emphasis-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-emphasis-style :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-text-emphasis-style :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-text-emphasis-style [
                [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 0] 100)
                  (igen/freq :prop-text-emphasis-style [
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 0 :alt 0] 100)
                      (gen/return "filled ")]
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 0 :alt 1] 100)
                      (gen/return "open ")]])]
                [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1] 100)
                  (igen/freq :prop-text-emphasis-style [
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1 :alt 0] 100)
                      (gen/return "dot ")]
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1 :alt 1] 100)
                      (gen/return "circle ")]
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1 :alt 2] 100)
                      (gen/return "double-circle ")]
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1 :alt 3] 100)
                      (gen/return "triangle ")]
                    [(get w [:prop-text-emphasis-style :alt 2 :plus 0 :alt 1 :alt 4] 100)
                      (gen/return "sesame ")]])]]))]
          [(get w [:prop-text-emphasis-style :alt 3] 100)
            (:nonprop-string g)]])
        g (assoc g :prop-text-emphasis-style gen-prop-text-emphasis-style)

        gen-nonprop-blend-mode
        (igen/freq :nonprop-blend-mode [
          [(get w [:nonprop-blend-mode :alt 0] 100)
            (gen/return "normal ")]
          [(get w [:nonprop-blend-mode :alt 1] 100)
            (gen/return "multiply ")]
          [(get w [:nonprop-blend-mode :alt 2] 100)
            (gen/return "screen ")]
          [(get w [:nonprop-blend-mode :alt 3] 100)
            (gen/return "overlay ")]
          [(get w [:nonprop-blend-mode :alt 4] 100)
            (gen/return "darken ")]
          [(get w [:nonprop-blend-mode :alt 5] 100)
            (gen/return "lighten ")]
          [(get w [:nonprop-blend-mode :alt 6] 100)
            (gen/return "color-dodge ")]
          [(get w [:nonprop-blend-mode :alt 7] 100)
            (gen/return "color-burn ")]
          [(get w [:nonprop-blend-mode :alt 8] 100)
            (gen/return "hard-light ")]
          [(get w [:nonprop-blend-mode :alt 9] 100)
            (gen/return "soft-light ")]
          [(get w [:nonprop-blend-mode :alt 10] 100)
            (gen/return "difference ")]
          [(get w [:nonprop-blend-mode :alt 11] 100)
            (gen/return "exclusion ")]
          [(get w [:nonprop-blend-mode :alt 12] 100)
            (gen/return "hue ")]
          [(get w [:nonprop-blend-mode :alt 13] 100)
            (gen/return "saturation ")]
          [(get w [:nonprop-blend-mode :alt 14] 100)
            (gen/return "color ")]
          [(get w [:nonprop-blend-mode :alt 15] 100)
            (gen/return "luminosity ")]])
        g (assoc g :nonprop-blend-mode gen-nonprop-blend-mode)

        gen-prop-background-blend-mode
        (igen/freq :prop-background-blend-mode [
          [(get w [:prop-background-blend-mode :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-blend-mode :alt 1] 100)
            (gen/tuple
              (:nonprop-blend-mode g)
              (igen/freq :prop-background-blend-mode [
                [(get w [:prop-background-blend-mode :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-blend-mode :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-blend-mode g)))]]))]])
        g (assoc g :prop-background-blend-mode gen-prop-background-blend-mode)

        gen-prop-border-start-end-radius
        (igen/freq :prop-border-start-end-radius [
          [(get w [:prop-border-start-end-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-start-end-radius :alt 1] 100)
            (igen/freq :prop-border-start-end-radius [
              [(get w [:prop-border-start-end-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-start-end-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-start-end-radius gen-prop-border-start-end-radius)

        gen-prop-border-start-start-radius
        (igen/freq :prop-border-start-start-radius [
          [(get w [:prop-border-start-start-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-start-start-radius :alt 1] 100)
            (igen/freq :prop-border-start-start-radius [
              [(get w [:prop-border-start-start-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-start-start-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-start-start-radius gen-prop-border-start-start-radius)

        gen-prop-border-top-width
        (igen/freq :prop-border-top-width [
          [(get w [:prop-border-top-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top-width :alt 1] 100)
            (:nonprop-line-width g)]])
        g (assoc g :prop-border-top-width gen-prop-border-top-width)

        gen-prop-border-inline-end-width
        (igen/freq :prop-border-inline-end-width [
          [(get w [:prop-border-inline-end-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-end-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-inline-end-width gen-prop-border-inline-end-width)

        gen-nonprop-custom-property-name
        (gen/return "STUB_custom_property")
        g (assoc g :nonprop-custom-property-name gen-nonprop-custom-property-name)]
    g))

(defn- css3-generators-part-4 [gmap weights]
  (let [g gmap
        w weights

        gen-nonprop-declaration-value
        (gen/return "STUB_declaration_value")
        g (assoc g :nonprop-declaration-value gen-nonprop-declaration-value)

        gen-func-var
        (gen/tuple
          (gen/return "var ")
          (gen/return "( ")
          (:nonprop-custom-property-name g)
          (gen/return ", ")
          (igen/freq :func-var [
            [(get w [:func-var :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-var :cat 4 :opt 0] 100)
              (:nonprop-declaration-value g)]])
          (gen/return ") "))
        g (assoc g :func-var gen-func-var)

        gen-nonprop-negative-symbol
        (gen/return "STUB_negative_symbol")
        g (assoc g :nonprop-negative-symbol gen-nonprop-negative-symbol)

        gen-prop-border-image-source
        (igen/freq :prop-border-image-source [
          [(get w [:prop-border-image-source :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image-source :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-border-image-source :alt 2] 100)
            (:nonprop-image g)]])
        g (assoc g :prop-border-image-source gen-prop-border-image-source)

        gen-prop-font-language-override
        (igen/freq :prop-font-language-override [
          [(get w [:prop-font-language-override :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-language-override :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-language-override :alt 2] 100)
            (:nonprop-string g)]])
        g (assoc g :prop-font-language-override gen-prop-font-language-override)

        gen-prop-justify-items
        (igen/freq :prop-justify-items [
          [(get w [:prop-justify-items :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-justify-items :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-justify-items :alt 2] 100)
            (gen/return "stretch ")]
          [(get w [:prop-justify-items :alt 3] 100)
            (:nonprop-baseline-position g)]
          [(get w [:prop-justify-items :alt 4] 100)
            (gen/tuple
              (igen/freq :prop-justify-items [
                [(get w [:prop-justify-items :alt 4 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-justify-items :alt 4 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (igen/freq :prop-justify-items [
                [(get w [:prop-justify-items :alt 4 :cat 1 :alt 0] 100)
                  (:nonprop-self-position g)]
                [(get w [:prop-justify-items :alt 4 :cat 1 :alt 1] 100)
                  (gen/return "left ")]
                [(get w [:prop-justify-items :alt 4 :cat 1 :alt 2] 100)
                  (gen/return "right ")]]))]
          [(get w [:prop-justify-items :alt 5] 100)
            (gen/return "legacy ")]
          [(get w [:prop-justify-items :alt 6] 100)
            (gen/tuple
              (gen/return "legacy ")
              (igen/freq :prop-justify-items [
                [(get w [:prop-justify-items :alt 6 :cat 1 :alt 0] 100)
                  (gen/return "left ")]
                [(get w [:prop-justify-items :alt 6 :cat 1 :alt 1] 100)
                  (gen/return "right ")]
                [(get w [:prop-justify-items :alt 6 :cat 1 :alt 2] 100)
                  (gen/return "center ")]]))]])
        g (assoc g :prop-justify-items gen-prop-justify-items)

        gen-prop-place-items
        (igen/freq :prop-place-items [
          [(get w [:prop-place-items :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-place-items :alt 1] 100)
            (gen/tuple
              (:prop-align-items g)
              (igen/freq :prop-place-items [
                [(get w [:prop-place-items :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-place-items :alt 1 :cat 1 :opt 0] 100)
                  (:prop-justify-items g)]]))]])
        g (assoc g :prop-place-items gen-prop-place-items)

        gen-prop-word-spacing
        (igen/freq :prop-word-spacing [
          [(get w [:prop-word-spacing :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-word-spacing :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-word-spacing :alt 2] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :prop-word-spacing gen-prop-word-spacing)

        gen-prop-opacity
        (igen/freq :prop-opacity [
          [(get w [:prop-opacity :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-opacity :alt 1] 100)
            (:nonprop-number g)]])
        g (assoc g :prop-opacity gen-prop-opacity)

        gen-nonprop-attachment
        (igen/freq :nonprop-attachment [
          [(get w [:nonprop-attachment :alt 0] 100)
            (gen/return "scroll ")]
          [(get w [:nonprop-attachment :alt 1] 100)
            (gen/return "fixed ")]
          [(get w [:nonprop-attachment :alt 2] 100)
            (gen/return "local ")]])
        g (assoc g :nonprop-attachment gen-nonprop-attachment)

        gen-nonprop-single-animation-fill-mode
        (igen/freq :nonprop-single-animation-fill-mode [
          [(get w [:nonprop-single-animation-fill-mode :alt 0] 100)
            (gen/return "none ")]
          [(get w [:nonprop-single-animation-fill-mode :alt 1] 100)
            (gen/return "forwards ")]
          [(get w [:nonprop-single-animation-fill-mode :alt 2] 100)
            (gen/return "backwards ")]
          [(get w [:nonprop-single-animation-fill-mode :alt 3] 100)
            (gen/return "both ")]])
        g (assoc g :nonprop-single-animation-fill-mode gen-nonprop-single-animation-fill-mode)

        gen-prop-width
        (igen/freq :prop-width [
          [(get w [:prop-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-width :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-width [
                [(get w [:prop-width :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-length g)]
                [(get w [:prop-width :alt 1 :cat 0 :alt 1] 100)
                  (:nonprop-percentage g)]])
              (igen/freq :prop-width [
                [(get w [:prop-width :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-width :alt 1 :cat 1 :opt 0] 100)
                  (igen/freq :prop-width [
                    [(get w [:prop-width :alt 1 :cat 1 :opt 0 :alt 0] 100)
                      (gen/return "border-box ")]
                    [(get w [:prop-width :alt 1 :cat 1 :opt 0 :alt 1] 100)
                      (gen/return "content-box ")]])]]))]
          [(get w [:prop-width :alt 2] 100)
            (gen/return "available ")]
          [(get w [:prop-width :alt 3] 100)
            (gen/return "min-content ")]
          [(get w [:prop-width :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-width :alt 5] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-width :alt 6] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-width gen-prop-width)

        gen-prop-inline-size
        (igen/freq :prop-inline-size [
          [(get w [:prop-inline-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inline-size :alt 1] 100)
            (:prop-width g)]])
        g (assoc g :prop-inline-size gen-prop-inline-size)

        gen-nonprop-fixed-repeat
        (gen/tuple
          (gen/return "repeat ")
          (gen/return "( ")
          (:nonprop-positive-integer g)
          (gen/return ", ")
          (igen/vector+
            (gen/tuple
              (igen/freq :nonprop-fixed-repeat [
                [(get w [:nonprop-fixed-repeat :cat 4 :plus 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-fixed-repeat :cat 4 :plus 0 :cat 0 :opt 0] 100)
                  (:nonprop-line-names g)]])
              (:nonprop-fixed-size g)))
          (igen/freq :nonprop-fixed-repeat [
            [(get w [:nonprop-fixed-repeat :cat 5 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-fixed-repeat :cat 5 :opt 0] 100)
              (:nonprop-line-names g)]])
          (gen/return ") "))
        g (assoc g :nonprop-fixed-repeat gen-nonprop-fixed-repeat)

        gen-nonprop-auto-repeat
        (gen/tuple
          (gen/return "repeat ")
          (gen/return "( ")
          (igen/freq :nonprop-auto-repeat [
            [(get w [:nonprop-auto-repeat :cat 2 :alt 0] 100)
              (gen/return "auto-fill ")]
            [(get w [:nonprop-auto-repeat :cat 2 :alt 1] 100)
              (gen/return "auto-fit ")]])
          (gen/return ", ")
          (igen/vector+
            (gen/tuple
              (igen/freq :nonprop-auto-repeat [
                [(get w [:nonprop-auto-repeat :cat 4 :plus 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-auto-repeat :cat 4 :plus 0 :cat 0 :opt 0] 100)
                  (:nonprop-line-names g)]])
              (:nonprop-fixed-size g)))
          (igen/freq :nonprop-auto-repeat [
            [(get w [:nonprop-auto-repeat :cat 5 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-auto-repeat :cat 5 :opt 0] 100)
              (:nonprop-line-names g)]])
          (gen/return ") "))
        g (assoc g :nonprop-auto-repeat gen-nonprop-auto-repeat)

        gen-nonprop-auto-track-list
        (gen/tuple
          (igen/freq :nonprop-auto-track-list [
            [(get w [:nonprop-auto-track-list :cat 0 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-auto-track-list :cat 0 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (igen/freq :nonprop-auto-track-list [
                    [(get w [:nonprop-auto-track-list :cat 0 :star 0 :cat 0 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-auto-track-list :cat 0 :star 0 :cat 0 :opt 0] 100)
                      (:nonprop-line-names g)]])
                  (igen/freq :nonprop-auto-track-list [
                    [(get w [:nonprop-auto-track-list :cat 0 :star 0 :cat 1 :alt 0] 100)
                      (:nonprop-fixed-size g)]
                    [(get w [:nonprop-auto-track-list :cat 0 :star 0 :cat 1 :alt 1] 100)
                      (:nonprop-fixed-repeat g)]])))]])
          (igen/freq :nonprop-auto-track-list [
            [(get w [:nonprop-auto-track-list :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-auto-track-list :cat 1 :opt 0] 100)
              (:nonprop-line-names g)]])
          (:nonprop-auto-repeat g)
          (igen/freq :nonprop-auto-track-list [
            [(get w [:nonprop-auto-track-list :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-auto-track-list :cat 3 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (igen/freq :nonprop-auto-track-list [
                    [(get w [:nonprop-auto-track-list :cat 3 :star 0 :cat 0 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-auto-track-list :cat 3 :star 0 :cat 0 :opt 0] 100)
                      (:nonprop-line-names g)]])
                  (igen/freq :nonprop-auto-track-list [
                    [(get w [:nonprop-auto-track-list :cat 3 :star 0 :cat 1 :alt 0] 100)
                      (:nonprop-fixed-size g)]
                    [(get w [:nonprop-auto-track-list :cat 3 :star 0 :cat 1 :alt 1] 100)
                      (:nonprop-fixed-repeat g)]])))]])
          (igen/freq :nonprop-auto-track-list [
            [(get w [:nonprop-auto-track-list :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-auto-track-list :cat 4 :opt 0] 100)
              (:nonprop-line-names g)]]))
        g (assoc g :nonprop-auto-track-list gen-nonprop-auto-track-list)

        gen-prop-grid-template-rows
        (igen/freq :prop-grid-template-rows [
          [(get w [:prop-grid-template-rows :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-template-rows :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-grid-template-rows :alt 2] 100)
            (:nonprop-track-list g)]
          [(get w [:prop-grid-template-rows :alt 3] 100)
            (:nonprop-auto-track-list g)]])
        g (assoc g :prop-grid-template-rows gen-prop-grid-template-rows)

        gen-prop-grid-template-columns
        (igen/freq :prop-grid-template-columns [
          [(get w [:prop-grid-template-columns :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-template-columns :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-grid-template-columns :alt 2] 100)
            (:nonprop-track-list g)]
          [(get w [:prop-grid-template-columns :alt 3] 100)
            (:nonprop-auto-track-list g)]])
        g (assoc g :prop-grid-template-columns gen-prop-grid-template-columns)

        gen-nonprop-explicit-track-list
        (gen/tuple
          (igen/vector+
            (gen/tuple
              (igen/freq :nonprop-explicit-track-list [
                [(get w [:nonprop-explicit-track-list :cat 0 :plus 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-explicit-track-list :cat 0 :plus 0 :cat 0 :opt 0] 100)
                  (:nonprop-line-names g)]])
              (:nonprop-track-size g)))
          (igen/freq :nonprop-explicit-track-list [
            [(get w [:nonprop-explicit-track-list :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-explicit-track-list :cat 1 :opt 0] 100)
              (:nonprop-line-names g)]]))
        g (assoc g :nonprop-explicit-track-list gen-nonprop-explicit-track-list)

        gen-prop-grid-template
        (igen/freq :prop-grid-template [
          [(get w [:prop-grid-template :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-template :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-grid-template :alt 2] 100)
            (gen/tuple
              (:prop-grid-template-rows g)
              (gen/return "/ ")
              (:prop-grid-template-columns g))]
          [(get w [:prop-grid-template :alt 3] 100)
            (gen/tuple
              (igen/vector+
                (gen/tuple
                  (igen/freq :prop-grid-template [
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 0 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 0 :opt 0] 100)
                      (:nonprop-line-names g)]])
                  (:nonprop-string g)
                  (igen/freq :prop-grid-template [
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 2 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 2 :opt 0] 100)
                      (:nonprop-track-size g)]])
                  (igen/freq :prop-grid-template [
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 3 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:prop-grid-template :alt 3 :cat 0 :plus 0 :cat 3 :opt 0] 100)
                      (:nonprop-line-names g)]])))
              (igen/freq :prop-grid-template [
                [(get w [:prop-grid-template :alt 3 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-grid-template :alt 3 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-explicit-track-list g))]]))]])
        g (assoc g :prop-grid-template gen-prop-grid-template)

        gen-prop-border-left-style
        (igen/freq :prop-border-left-style [
          [(get w [:prop-border-left-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-left-style :alt 1] 100)
            (:nonprop-line-style g)]])
        g (assoc g :prop-border-left-style gen-prop-border-left-style)

        gen-prop-widows
        (igen/freq :prop-widows [
          [(get w [:prop-widows :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-widows :alt 1] 100)
            (:nonprop-integer g)]])
        g (assoc g :prop-widows gen-prop-widows)

        gen-prop-break-inside
        (igen/freq :prop-break-inside [
          [(get w [:prop-break-inside :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-break-inside :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-break-inside :alt 2] 100)
            (gen/return "avoid ")]
          [(get w [:prop-break-inside :alt 3] 100)
            (gen/return "avoid-page ")]
          [(get w [:prop-break-inside :alt 4] 100)
            (gen/return "avoid-column ")]
          [(get w [:prop-break-inside :alt 5] 100)
            (gen/return "avoid-region ")]])
        g (assoc g :prop-break-inside gen-prop-break-inside)

        gen-nonprop-content-position
        (igen/freq :nonprop-content-position [
          [(get w [:nonprop-content-position :alt 0] 100)
            (gen/return "center ")]
          [(get w [:nonprop-content-position :alt 1] 100)
            (gen/return "start ")]
          [(get w [:nonprop-content-position :alt 2] 100)
            (gen/return "end ")]
          [(get w [:nonprop-content-position :alt 3] 100)
            (gen/return "flex-start ")]
          [(get w [:nonprop-content-position :alt 4] 100)
            (gen/return "flex-end ")]])
        g (assoc g :nonprop-content-position gen-nonprop-content-position)

        gen-nonprop-content-distribution
        (igen/freq :nonprop-content-distribution [
          [(get w [:nonprop-content-distribution :alt 0] 100)
            (gen/return "space-between ")]
          [(get w [:nonprop-content-distribution :alt 1] 100)
            (gen/return "space-around ")]
          [(get w [:nonprop-content-distribution :alt 2] 100)
            (gen/return "space-evenly ")]
          [(get w [:nonprop-content-distribution :alt 3] 100)
            (gen/return "stretch ")]])
        g (assoc g :nonprop-content-distribution gen-nonprop-content-distribution)

        gen-prop-align-content
        (igen/freq :prop-align-content [
          [(get w [:prop-align-content :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-align-content :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-align-content :alt 2] 100)
            (:nonprop-baseline-position g)]
          [(get w [:prop-align-content :alt 3] 100)
            (:nonprop-content-distribution g)]
          [(get w [:prop-align-content :alt 4] 100)
            (gen/tuple
              (igen/freq :prop-align-content [
                [(get w [:prop-align-content :alt 4 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-align-content :alt 4 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (:nonprop-content-position g))]])
        g (assoc g :prop-align-content gen-prop-align-content)

        gen-prop-justify-content
        (igen/freq :prop-justify-content [
          [(get w [:prop-justify-content :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-justify-content :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-justify-content :alt 2] 100)
            (:nonprop-content-distribution g)]
          [(get w [:prop-justify-content :alt 3] 100)
            (gen/tuple
              (igen/freq :prop-justify-content [
                [(get w [:prop-justify-content :alt 3 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-justify-content :alt 3 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (igen/freq :prop-justify-content [
                [(get w [:prop-justify-content :alt 3 :cat 1 :alt 0] 100)
                  (:nonprop-content-position g)]
                [(get w [:prop-justify-content :alt 3 :cat 1 :alt 1] 100)
                  (gen/return "left ")]
                [(get w [:prop-justify-content :alt 3 :cat 1 :alt 2] 100)
                  (gen/return "right ")]]))]])
        g (assoc g :prop-justify-content gen-prop-justify-content)

        gen-prop-place-content
        (igen/freq :prop-place-content [
          [(get w [:prop-place-content :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-place-content :alt 1] 100)
            (gen/tuple
              (:prop-align-content g)
              (igen/freq :prop-place-content [
                [(get w [:prop-place-content :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-place-content :alt 1 :cat 1 :opt 0] 100)
                  (:prop-justify-content g)]]))]])
        g (assoc g :prop-place-content gen-prop-place-content)

        gen-nonprop-keyframes-name
        (igen/freq :nonprop-keyframes-name [
          [(get w [:nonprop-keyframes-name :alt 0] 100)
            (:nonprop-custom-ident g)]
          [(get w [:nonprop-keyframes-name :alt 1] 100)
            (:nonprop-string g)]])
        g (assoc g :nonprop-keyframes-name gen-nonprop-keyframes-name)

        gen-prop-animation-name
        (igen/freq :prop-animation-name [
          [(get w [:prop-animation-name :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-name :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-animation-name [
                [(get w [:prop-animation-name :alt 1 :cat 0 :alt 0] 100)
                  (gen/return "none ")]
                [(get w [:prop-animation-name :alt 1 :cat 0 :alt 1] 100)
                  (:nonprop-keyframes-name g)]])
              (igen/freq :prop-animation-name [
                [(get w [:prop-animation-name :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-name :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (igen/freq :prop-animation-name [
                        [(get w [:prop-animation-name :alt 1 :cat 1 :star 0 :cat 2 :alt 0] 100)
                          (gen/return "none ")]
                        [(get w [:prop-animation-name :alt 1 :cat 1 :star 0 :cat 2 :alt 1] 100)
                          (:nonprop-keyframes-name g)]])))]]))]])
        g (assoc g :prop-animation-name gen-prop-animation-name)

        gen-prop-flex-grow
        (igen/freq :prop-flex-grow [
          [(get w [:prop-flex-grow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-grow :alt 1] 100)
            (:nonprop-number g)]])
        g (assoc g :prop-flex-grow gen-prop-flex-grow)

        gen-prop-padding-block-end
        (igen/freq :prop-padding-block-end [
          [(get w [:prop-padding-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-block-end :alt 1] 100)
            (:prop-padding-left g)]])
        g (assoc g :prop-padding-block-end gen-prop-padding-block-end)

        gen-nonprop-counter-style-name
        (:nonprop-custom-ident g)
        g (assoc g :nonprop-counter-style-name gen-nonprop-counter-style-name)

        gen-nonprop-counter-style
        (igen/freq :nonprop-counter-style [
          [(get w [:nonprop-counter-style :alt 0] 100)
            (:nonprop-counter-style-name g)]
          [(get w [:nonprop-counter-style :alt 1] 100)
            (gen/tuple
              (gen/return "symbols ")
              (gen/return "( ")
              (gen/return ") "))]])
        g (assoc g :nonprop-counter-style gen-nonprop-counter-style)

        gen-func-target-counters
        (gen/tuple
          (gen/return "target-counters ")
          (gen/return "( ")
          (igen/freq :func-target-counters [
            [(get w [:func-target-counters :cat 2 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:func-target-counters :cat 2 :alt 1] 100)
              (:nonprop-url g)]])
          (gen/return ", ")
          (:nonprop-custom-ident g)
          (gen/return ", ")
          (:nonprop-string g)
          (gen/return ", ")
          (igen/freq :func-target-counters [
            [(get w [:func-target-counters :cat 8 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-target-counters :cat 8 :opt 0] 100)
              (:nonprop-counter-style g)]])
          (gen/return ") "))
        g (assoc g :func-target-counters gen-func-target-counters)

        gen-func-target-text
        (gen/tuple
          (gen/return "target-text ")
          (gen/return "( ")
          (igen/freq :func-target-text [
            [(get w [:func-target-text :cat 2 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:func-target-text :cat 2 :alt 1] 100)
              (:nonprop-url g)]])
          (gen/return ", ")
          (igen/freq :func-target-text [
            [(get w [:func-target-text :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-target-text :cat 4 :opt 0] 100)
              (igen/freq :func-target-text [
                [(get w [:func-target-text :cat 4 :opt 0 :alt 0] 100)
                  (gen/return "content ")]
                [(get w [:func-target-text :cat 4 :opt 0 :alt 1] 100)
                  (gen/return "before ")]
                [(get w [:func-target-text :cat 4 :opt 0 :alt 2] 100)
                  (gen/return "after ")]
                [(get w [:func-target-text :cat 4 :opt 0 :alt 3] 100)
                  (gen/return "first-letter ")]])]])
          (gen/return ") "))
        g (assoc g :func-target-text gen-func-target-text)

        gen-func-target-counter
        (gen/tuple
          (gen/return "target-counter ")
          (gen/return "( ")
          (igen/freq :func-target-counter [
            [(get w [:func-target-counter :cat 2 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:func-target-counter :cat 2 :alt 1] 100)
              (:nonprop-url g)]])
          (gen/return ", ")
          (:nonprop-custom-ident g)
          (gen/return ", ")
          (igen/freq :func-target-counter [
            [(get w [:func-target-counter :cat 6 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-target-counter :cat 6 :opt 0] 100)
              (:nonprop-counter-style g)]])
          (gen/return ") "))
        g (assoc g :func-target-counter gen-func-target-counter)

        gen-nonprop-target
        (igen/freq :nonprop-target [
          [(get w [:nonprop-target :alt 0] 100)
            (:func-target-counter g)]
          [(get w [:nonprop-target :alt 1] 100)
            (:func-target-counters g)]
          [(get w [:nonprop-target :alt 2] 100)
            (:func-target-text g)]])
        g (assoc g :nonprop-target gen-nonprop-target)

        gen-func-rotateY
        (gen/tuple
          (gen/return "rotateY ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-rotateY gen-func-rotateY)

        gen-prop-outline-width
        (igen/freq :prop-outline-width [
          [(get w [:prop-outline-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-outline-width :alt 1] 100)
            (:nonprop-line-width g)]])
        g (assoc g :prop-outline-width gen-prop-outline-width)

        gen-prop-grid-auto-columns
        (igen/freq :prop-grid-auto-columns [
          [(get w [:prop-grid-auto-columns :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-auto-columns :alt 1] 100)
            (igen/vector+
              (:nonprop-track-size g))]])
        g (assoc g :prop-grid-auto-columns gen-prop-grid-auto-columns)

        gen-prop-grid-auto-rows
        (igen/freq :prop-grid-auto-rows [
          [(get w [:prop-grid-auto-rows :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-auto-rows :alt 1] 100)
            (igen/vector+
              (:nonprop-track-size g))]])
        g (assoc g :prop-grid-auto-rows gen-prop-grid-auto-rows)

        gen-prop-grid
        (igen/freq :prop-grid [
          [(get w [:prop-grid :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid :alt 1] 100)
            (:prop-grid-template g)]
          [(get w [:prop-grid :alt 2] 100)
            (gen/tuple
              (:prop-grid-template-rows g)
              (gen/return "/ ")
              (gen/tuple
                (gen/return "auto-flow ")
                (igen/freq :prop-grid [
                  [(get w [:prop-grid :alt 2 :cat 2 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:prop-grid :alt 2 :cat 2 :cat 1 :opt 0] 100)
                    (gen/return "dense ")]]))
              (igen/freq :prop-grid [
                [(get w [:prop-grid :alt 2 :cat 3 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-grid :alt 2 :cat 3 :opt 0] 100)
                  (:prop-grid-auto-columns g)]]))]
          [(get w [:prop-grid :alt 3] 100)
            (gen/tuple
              (gen/tuple
                (gen/return "auto-flow ")
                (igen/freq :prop-grid [
                  [(get w [:prop-grid :alt 3 :cat 0 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:prop-grid :alt 3 :cat 0 :cat 1 :opt 0] 100)
                    (gen/return "dense ")]]))
              (igen/freq :prop-grid [
                [(get w [:prop-grid :alt 3 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-grid :alt 3 :cat 1 :opt 0] 100)
                  (:prop-grid-auto-rows g)]])
              (gen/return "/ ")
              (:prop-grid-template-columns g))]])
        g (assoc g :prop-grid gen-prop-grid)

        gen-prop-padding-inline-end
        (igen/freq :prop-padding-inline-end [
          [(get w [:prop-padding-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-inline-end :alt 1] 100)
            (:prop-padding-left g)]])
        g (assoc g :prop-padding-inline-end gen-prop-padding-inline-end)

        gen-prop-counter-reset
        (igen/freq :prop-counter-reset [
          [(get w [:prop-counter-reset :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-counter-reset :alt 1] 100)
            (igen/vector+
              (gen/tuple
                (:nonprop-custom-ident g)
                (igen/freq :prop-counter-reset [
                  [(get w [:prop-counter-reset :alt 1 :plus 0 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:prop-counter-reset :alt 1 :plus 0 :cat 1 :opt 0] 100)
                    (:nonprop-integer g)]])))]
          [(get w [:prop-counter-reset :alt 2] 100)
            (gen/return "none ")]])
        g (assoc g :prop-counter-reset gen-prop-counter-reset)

        gen-prop-border-end-end-radius
        (igen/freq :prop-border-end-end-radius [
          [(get w [:prop-border-end-end-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-end-end-radius :alt 1] 100)
            (igen/freq :prop-border-end-end-radius [
              [(get w [:prop-border-end-end-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-end-end-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-end-end-radius gen-prop-border-end-end-radius)

        gen-prop-text-align-last
        (igen/freq :prop-text-align-last [
          [(get w [:prop-text-align-last :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-align-last :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-text-align-last :alt 2] 100)
            (gen/return "start ")]
          [(get w [:prop-text-align-last :alt 3] 100)
            (gen/return "end ")]
          [(get w [:prop-text-align-last :alt 4] 100)
            (gen/return "left ")]
          [(get w [:prop-text-align-last :alt 5] 100)
            (gen/return "right ")]
          [(get w [:prop-text-align-last :alt 6] 100)
            (gen/return "center ")]
          [(get w [:prop-text-align-last :alt 7] 100)
            (gen/return "justify ")]])
        g (assoc g :prop-text-align-last gen-prop-text-align-last)

        gen-prop-border-inline-width
        (igen/freq :prop-border-inline-width [
          [(get w [:prop-border-inline-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-inline-width gen-prop-border-inline-width)

        gen-nonprop-display-inside
        (igen/freq :nonprop-display-inside [
          [(get w [:nonprop-display-inside :alt 0] 100)
            (gen/return "flow ")]
          [(get w [:nonprop-display-inside :alt 1] 100)
            (gen/return "flow-root ")]
          [(get w [:nonprop-display-inside :alt 2] 100)
            (gen/return "table ")]
          [(get w [:nonprop-display-inside :alt 3] 100)
            (gen/return "flex ")]
          [(get w [:nonprop-display-inside :alt 4] 100)
            (gen/return "grid ")]
          [(get w [:nonprop-display-inside :alt 5] 100)
            (gen/return "ruby ")]])
        g (assoc g :nonprop-display-inside gen-nonprop-display-inside)

        gen-prop-color-adjust
        (igen/freq :prop-color-adjust [
          [(get w [:prop-color-adjust :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-color-adjust :alt 1] 100)
            (gen/return "economy ")]
          [(get w [:prop-color-adjust :alt 2] 100)
            (gen/return "exact ")]])
        g (assoc g :prop-color-adjust gen-prop-color-adjust)]
    g))

(defn- css3-generators-part-5 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-inset-inline-start
        (igen/freq :prop-inset-inline-start [
          [(get w [:prop-inset-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-inline-start :alt 1] 100)
            (:prop-top g)]])
        g (assoc g :prop-inset-inline-start gen-prop-inset-inline-start)

        gen-nonprop-number-percentage
        (igen/freq :nonprop-number-percentage [
          [(get w [:nonprop-number-percentage :alt 0] 100)
            (:nonprop-number g)]
          [(get w [:nonprop-number-percentage :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-number-percentage gen-nonprop-number-percentage)

        gen-func-contrast
        (gen/tuple
          (gen/return "contrast ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-contrast gen-func-contrast)

        gen-prop-animation-duration
        (igen/freq :prop-animation-duration [
          [(get w [:prop-animation-duration :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-duration :alt 1] 100)
            (gen/tuple
              (:nonprop-time g)
              (igen/freq :prop-animation-duration [
                [(get w [:prop-animation-duration :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-duration :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-time g)))]]))]])
        g (assoc g :prop-animation-duration gen-prop-animation-duration)

        gen-prop-color
        (igen/freq :prop-color [
          [(get w [:prop-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-color gen-prop-color)

        gen-prop-border-block
        (igen/freq :prop-border-block [
          [(get w [:prop-border-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-block [
                [(get w [:prop-border-block :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-block :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-block :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-block gen-prop-border-block)

        gen-prop-scroll-margin-inline
        (igen/freq :prop-scroll-margin-inline [
          [(get w [:prop-scroll-margin-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-inline :alt 1] 100)
            (igen/freq :prop-scroll-margin-inline [
              [(get w [:prop-scroll-margin-inline :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-margin-inline [
                  [(get w [:prop-scroll-margin-inline :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-margin-inline :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]])]
              [(get w [:prop-scroll-margin-inline :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-margin-inline [
                    [(get w [:prop-scroll-margin-inline :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin-inline :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin-inline [
                    [(get w [:prop-scroll-margin-inline :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin-inline :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]]))]])]])
        g (assoc g :prop-scroll-margin-inline gen-prop-scroll-margin-inline)

        gen-prop-border-inline-style
        (igen/freq :prop-border-inline-style [
          [(get w [:prop-border-inline-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-inline-style gen-prop-border-inline-style)

        gen-prop-border-block-start
        (igen/freq :prop-border-block-start [
          [(get w [:prop-border-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-start :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-block-start [
                [(get w [:prop-border-block-start :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-block-start :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-block-start :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-block-start gen-prop-border-block-start)

        gen-nonprop-shadow-t
        (gen/tuple
          (igen/freq :nonprop-shadow-t [
            [(get w [:nonprop-shadow-t :cat 0 :alt 0] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]
            [(get w [:nonprop-shadow-t :cat 0 :alt 1] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]])
          (igen/freq :nonprop-shadow-t [
            [(get w [:nonprop-shadow-t :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-shadow-t :cat 1 :opt 0] 100)
              (:nonprop-color g)]]))
        g (assoc g :nonprop-shadow-t gen-nonprop-shadow-t)

        gen-prop-text-shadow
        (igen/freq :prop-text-shadow [
          [(get w [:prop-text-shadow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-shadow :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-text-shadow :alt 2] 100)
            (gen/tuple
              (:nonprop-shadow-t g)
              (igen/freq :prop-text-shadow [
                [(get w [:prop-text-shadow :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-text-shadow :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-shadow-t g)))]]))]])
        g (assoc g :prop-text-shadow gen-prop-text-shadow)

        gen-nonprop-feature-value-name
        (:nonprop-custom-ident g)
        g (assoc g :nonprop-feature-value-name gen-nonprop-feature-value-name)

        gen-prop-border-left-color
        (igen/freq :prop-border-left-color [
          [(get w [:prop-border-left-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-left-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-border-left-color gen-prop-border-left-color)

        gen-prop-column-gap
        (igen/freq :prop-column-gap [
          [(get w [:prop-column-gap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-gap :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-column-gap :alt 2] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :prop-column-gap gen-prop-column-gap)

        gen-prop-row-gap
        (igen/freq :prop-row-gap [
          [(get w [:prop-row-gap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-row-gap :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-row-gap :alt 2] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :prop-row-gap gen-prop-row-gap)

        gen-prop-gap
        (igen/freq :prop-gap [
          [(get w [:prop-gap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-gap :alt 1] 100)
            (gen/tuple
              (:prop-row-gap g)
              (igen/freq :prop-gap [
                [(get w [:prop-gap :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-gap :alt 1 :cat 1 :opt 0] 100)
                  (:prop-column-gap g)]]))]])
        g (assoc g :prop-gap gen-prop-gap)

        gen-prop-direction
        (igen/freq :prop-direction [
          [(get w [:prop-direction :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-direction :alt 1] 100)
            (gen/return "ltr ")]
          [(get w [:prop-direction :alt 2] 100)
            (gen/return "rtl ")]])
        g (assoc g :prop-direction gen-prop-direction)

        gen-prop-min-width
        (igen/freq :prop-min-width [
          [(get w [:prop-min-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-min-width :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-min-width :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-min-width :alt 3] 100)
            (gen/return "auto ")]
          [(get w [:prop-min-width :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-min-width :alt 5] 100)
            (gen/return "min-content ")]
          [(get w [:prop-min-width :alt 6] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-min-width :alt 7] 100)
            (gen/return "fill-available ")]])
        g (assoc g :prop-min-width gen-prop-min-width)

        gen-prop-min-block-size
        (igen/freq :prop-min-block-size [
          [(get w [:prop-min-block-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-min-block-size :alt 1] 100)
            (:prop-min-width g)]])
        g (assoc g :prop-min-block-size gen-prop-min-block-size)

        gen-nonprop-single-transition
        (igen/vector+
          (igen/freq :nonprop-single-transition [
            [(get w [:nonprop-single-transition :plus 0 :alt 0] 100)
              (igen/freq :nonprop-single-transition [
                [(get w [:nonprop-single-transition :plus 0 :alt 0 :alt 0] 100)
                  (gen/return "none ")]
                [(get w [:nonprop-single-transition :plus 0 :alt 0 :alt 1] 100)
                  (:nonprop-single-transition-property g)]])]
            [(get w [:nonprop-single-transition :plus 0 :alt 1] 100)
              (:nonprop-time g)]
            [(get w [:nonprop-single-transition :plus 0 :alt 2] 100)
              (:nonprop-timing-function g)]
            [(get w [:nonprop-single-transition :plus 0 :alt 3] 100)
              (:nonprop-time g)]]))
        g (assoc g :nonprop-single-transition gen-nonprop-single-transition)

        gen-nonprop-mask-source
        (:nonprop-url g)
        g (assoc g :nonprop-mask-source gen-nonprop-mask-source)

        gen-nonprop-mask-reference
        (igen/freq :nonprop-mask-reference [
          [(get w [:nonprop-mask-reference :alt 0] 100)
            (gen/return "none ")]
          [(get w [:nonprop-mask-reference :alt 1] 100)
            (:nonprop-image g)]
          [(get w [:nonprop-mask-reference :alt 2] 100)
            (:nonprop-mask-source g)]])
        g (assoc g :nonprop-mask-reference gen-nonprop-mask-reference)

        gen-prop-border-right-color
        (igen/freq :prop-border-right-color [
          [(get w [:prop-border-right-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-right-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-border-right-color gen-prop-border-right-color)

        gen-func-translateY
        (gen/tuple
          (gen/return "translateY ")
          (gen/return "( ")
          (:nonprop-length-percentage g)
          (gen/return ") "))
        g (assoc g :func-translateY gen-func-translateY)

        gen-func-scale
        (gen/tuple
          (gen/return "scale ")
          (gen/return "( ")
          (:nonprop-number g)
          (igen/freq :func-scale [
            [(get w [:func-scale :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-scale :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return ", ")
                (:nonprop-number g))]])
          (gen/return ") "))
        g (assoc g :func-scale gen-func-scale)

        gen-func-rotateZ
        (gen/tuple
          (gen/return "rotateZ ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-rotateZ gen-func-rotateZ)

        gen-func-rotate3d
        (gen/tuple
          (gen/return "rotate3d ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/return ", ")
          (:nonprop-number g)
          (gen/return ", ")
          (:nonprop-number g)
          (gen/return ", ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-rotate3d gen-func-rotate3d)

        gen-func-skewX
        (gen/tuple
          (gen/return "skewX ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-skewX gen-func-skewX)

        gen-func-matrix3d
        (gen/tuple
          (gen/return "matrix3d ")
          (gen/return "( ")
          (:nonprop-number g)
          (igen/freq :func-matrix3d [
            [(get w [:func-matrix3d :cat 3 :alt 0] 100)
              (gen/tuple
                (gen/return ", ")
                (:nonprop-number g))]
            [(get w [:func-matrix3d :cat 3 :alt 1] 100)
              (gen/tuple
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g)))]
            [(get w [:func-matrix3d :cat 3 :alt 2] 100)
              (gen/tuple
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g)))]
            [(get w [:func-matrix3d :cat 3 :alt 3] 100)
              (gen/tuple
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g)))]
            [(get w [:func-matrix3d :cat 3 :alt 4] 100)
              (gen/tuple
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g))
                (gen/return " ")
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-number g)))]])
          (gen/return ") "))
        g (assoc g :func-matrix3d gen-func-matrix3d)

        gen-func-translate
        (gen/tuple
          (gen/return "translate ")
          (gen/return "( ")
          (:nonprop-length-percentage g)
          (igen/freq :func-translate [
            [(get w [:func-translate :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-translate :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return ", ")
                (:nonprop-length-percentage g))]])
          (gen/return ") "))
        g (assoc g :func-translate gen-func-translate)

        gen-func-scaleZ
        (gen/tuple
          (gen/return "scaleZ ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/return ") "))
        g (assoc g :func-scaleZ gen-func-scaleZ)

        gen-func-scale3d
        (gen/tuple
          (gen/return "scale3d ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/return ", ")
          (:nonprop-number g)
          (gen/return ", ")
          (:nonprop-number g)
          (gen/return ") "))
        g (assoc g :func-scale3d gen-func-scale3d)

        gen-func-rotateX
        (gen/tuple
          (gen/return "rotateX ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-rotateX gen-func-rotateX)

        gen-func-scaleX
        (gen/tuple
          (gen/return "scaleX ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/return ") "))
        g (assoc g :func-scaleX gen-func-scaleX)

        gen-func-matrix
        (gen/tuple
          (gen/return "matrix ")
          (gen/return "( ")
          (:nonprop-number g)
          (gen/tuple
            (gen/tuple
              (gen/return ", ")
              (:nonprop-number g))
            (gen/return " ")
            (gen/tuple
              (gen/return ", ")
              (:nonprop-number g))
            (gen/return " ")
            (gen/tuple
              (gen/return ", ")
              (:nonprop-number g))
            (gen/return " ")
            (gen/tuple
              (gen/return ", ")
              (:nonprop-number g))
            (gen/return " ")
            (gen/tuple
              (gen/return ", ")
              (:nonprop-number g)))
          (gen/return ") "))
        g (assoc g :func-matrix gen-func-matrix)

        gen-func-perspective
        (gen/tuple
          (gen/return "perspective ")
          (gen/return "( ")
          (:nonprop-length g)
          (gen/return ") "))
        g (assoc g :func-perspective gen-func-perspective)

        gen-func-translate3d
        (gen/tuple
          (gen/return "translate3d ")
          (gen/return "( ")
          (:nonprop-length-percentage g)
          (gen/return ", ")
          (:nonprop-length-percentage g)
          (gen/return ", ")
          (:nonprop-length g)
          (gen/return ") "))
        g (assoc g :func-translate3d gen-func-translate3d)

        gen-func-translateX
        (gen/tuple
          (gen/return "translateX ")
          (gen/return "( ")
          (:nonprop-length-percentage g)
          (gen/return ") "))
        g (assoc g :func-translateX gen-func-translateX)

        gen-func-translateZ
        (gen/tuple
          (gen/return "translateZ ")
          (gen/return "( ")
          (:nonprop-length g)
          (gen/return ") "))
        g (assoc g :func-translateZ gen-func-translateZ)

        gen-nonprop-transform-function
        (igen/freq :nonprop-transform-function [
          [(get w [:nonprop-transform-function :alt 0] 100)
            (:func-matrix g)]
          [(get w [:nonprop-transform-function :alt 1] 100)
            (:func-translate g)]
          [(get w [:nonprop-transform-function :alt 2] 100)
            (:func-translateX g)]
          [(get w [:nonprop-transform-function :alt 3] 100)
            (:func-translateY g)]
          [(get w [:nonprop-transform-function :alt 4] 100)
            (:func-scale g)]
          [(get w [:nonprop-transform-function :alt 5] 100)
            (:func-scaleX g)]
          [(get w [:nonprop-transform-function :alt 6] 100)
            (:func-scaleY g)]
          [(get w [:nonprop-transform-function :alt 7] 100)
            (:func-rotate g)]
          [(get w [:nonprop-transform-function :alt 8] 100)
            (:func-skew g)]
          [(get w [:nonprop-transform-function :alt 9] 100)
            (:func-skewX g)]
          [(get w [:nonprop-transform-function :alt 10] 100)
            (:func-skewY g)]
          [(get w [:nonprop-transform-function :alt 11] 100)
            (:func-matrix3d g)]
          [(get w [:nonprop-transform-function :alt 12] 100)
            (:func-translate3d g)]
          [(get w [:nonprop-transform-function :alt 13] 100)
            (:func-translateZ g)]
          [(get w [:nonprop-transform-function :alt 14] 100)
            (:func-scale3d g)]
          [(get w [:nonprop-transform-function :alt 15] 100)
            (:func-scaleZ g)]
          [(get w [:nonprop-transform-function :alt 16] 100)
            (:func-rotate3d g)]
          [(get w [:nonprop-transform-function :alt 17] 100)
            (:func-rotateX g)]
          [(get w [:nonprop-transform-function :alt 18] 100)
            (:func-rotateY g)]
          [(get w [:nonprop-transform-function :alt 19] 100)
            (:func-rotateZ g)]
          [(get w [:nonprop-transform-function :alt 20] 100)
            (:func-perspective g)]])
        g (assoc g :nonprop-transform-function gen-nonprop-transform-function)

        gen-nonprop-transform-list
        (igen/vector+
          (:nonprop-transform-function g))
        g (assoc g :nonprop-transform-list gen-nonprop-transform-list)

        gen-prop-transform
        (igen/freq :prop-transform [
          [(get w [:prop-transform :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transform :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-transform :alt 2] 100)
            (:nonprop-transform-list g)]])
        g (assoc g :prop-transform gen-prop-transform)

        gen-prop-inset-inline
        (igen/freq :prop-inset-inline [
          [(get w [:prop-inset-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-inline :alt 1] 100)
            (igen/freq :prop-inset-inline [
              [(get w [:prop-inset-inline :alt 1 :alt 0] 100)
                (:prop-top g)]
              [(get w [:prop-inset-inline :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g))]])]])
        g (assoc g :prop-inset-inline gen-prop-inset-inline)

        gen-prop-border-inline-start
        (igen/freq :prop-border-inline-start [
          [(get w [:prop-border-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-start :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-inline-start [
                [(get w [:prop-border-inline-start :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-inline-start :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-inline-start :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-inline-start gen-prop-border-inline-start)

        gen-prop-border-right-width
        (igen/freq :prop-border-right-width [
          [(get w [:prop-border-right-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-right-width :alt 1] 100)
            (:nonprop-line-width g)]])
        g (assoc g :prop-border-right-width gen-prop-border-right-width)

        gen-nonprop-east-asian-width-values
        (igen/freq :nonprop-east-asian-width-values [
          [(get w [:nonprop-east-asian-width-values :alt 0] 100)
            (gen/return "full-width ")]
          [(get w [:nonprop-east-asian-width-values :alt 1] 100)
            (gen/return "proportional-width ")]])
        g (assoc g :nonprop-east-asian-width-values gen-nonprop-east-asian-width-values)

        gen-func-brightness
        (gen/tuple
          (gen/return "brightness ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-brightness gen-func-brightness)

        gen-nonprop-display-legacy
        (igen/freq :nonprop-display-legacy [
          [(get w [:nonprop-display-legacy :alt 0] 100)
            (gen/return "inline-block ")]
          [(get w [:nonprop-display-legacy :alt 1] 100)
            (gen/return "inline-list-item ")]
          [(get w [:nonprop-display-legacy :alt 2] 100)
            (gen/return "inline-table ")]
          [(get w [:nonprop-display-legacy :alt 3] 100)
            (gen/return "inline-flex ")]
          [(get w [:nonprop-display-legacy :alt 4] 100)
            (gen/return "inline-grid ")]])
        g (assoc g :nonprop-display-legacy gen-nonprop-display-legacy)

        gen-nonprop-feature-tag-value
        (gen/tuple
          (:nonprop-string g)
          (igen/freq :nonprop-feature-tag-value [
            [(get w [:nonprop-feature-tag-value :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-feature-tag-value :cat 1 :opt 0] 100)
              (igen/freq :nonprop-feature-tag-value [
                [(get w [:nonprop-feature-tag-value :cat 1 :opt 0 :alt 0] 100)
                  (:nonprop-integer g)]
                [(get w [:nonprop-feature-tag-value :cat 1 :opt 0 :alt 1] 100)
                  (gen/return "on ")]
                [(get w [:nonprop-feature-tag-value :cat 1 :opt 0 :alt 2] 100)
                  (gen/return "off ")]])]]))
        g (assoc g :nonprop-feature-tag-value gen-nonprop-feature-tag-value)

        gen-prop-margin-bottom
        (igen/freq :prop-margin-bottom [
          [(get w [:prop-margin-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-bottom :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-margin-bottom :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-margin-bottom :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-margin-bottom gen-prop-margin-bottom)]
    g))

(defn- css3-generators-part-6 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-shape-margin
        (igen/freq :prop-shape-margin [
          [(get w [:prop-shape-margin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-shape-margin :alt 1] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :prop-shape-margin gen-prop-shape-margin)

        gen-prop-text-emphasis-position
        (igen/freq :prop-text-emphasis-position [
          [(get w [:prop-text-emphasis-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-emphasis-position :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-text-emphasis-position [
                [(get w [:prop-text-emphasis-position :alt 1 :cat 0 :alt 0] 100)
                  (gen/return "over ")]
                [(get w [:prop-text-emphasis-position :alt 1 :cat 0 :alt 1] 100)
                  (gen/return "under ")]])
              (igen/freq :prop-text-emphasis-position [
                [(get w [:prop-text-emphasis-position :alt 1 :cat 1 :alt 0] 100)
                  (gen/return "right ")]
                [(get w [:prop-text-emphasis-position :alt 1 :cat 1 :alt 1] 100)
                  (gen/return "left ")]]))]])
        g (assoc g :prop-text-emphasis-position gen-prop-text-emphasis-position)

        gen-nonprop-display-internal
        (igen/freq :nonprop-display-internal [
          [(get w [:nonprop-display-internal :alt 0] 100)
            (gen/return "table-row-group ")]
          [(get w [:nonprop-display-internal :alt 1] 100)
            (gen/return "table-header-group ")]
          [(get w [:nonprop-display-internal :alt 2] 100)
            (gen/return "table-footer-group ")]
          [(get w [:nonprop-display-internal :alt 3] 100)
            (gen/return "table-row ")]
          [(get w [:nonprop-display-internal :alt 4] 100)
            (gen/return "table-cell ")]
          [(get w [:nonprop-display-internal :alt 5] 100)
            (gen/return "table-column-group ")]
          [(get w [:nonprop-display-internal :alt 6] 100)
            (gen/return "table-column ")]
          [(get w [:nonprop-display-internal :alt 7] 100)
            (gen/return "table-caption ")]
          [(get w [:nonprop-display-internal :alt 8] 100)
            (gen/return "ruby-base ")]
          [(get w [:nonprop-display-internal :alt 9] 100)
            (gen/return "ruby-text ")]
          [(get w [:nonprop-display-internal :alt 10] 100)
            (gen/return "ruby-base-container ")]
          [(get w [:nonprop-display-internal :alt 11] 100)
            (gen/return "ruby-text-container ")]])
        g (assoc g :nonprop-display-internal gen-nonprop-display-internal)

        gen-prop-border-inline-start-width
        (igen/freq :prop-border-inline-start-width [
          [(get w [:prop-border-inline-start-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-start-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-inline-start-width gen-prop-border-inline-start-width)

        gen-prop-border-inline-end-style
        (igen/freq :prop-border-inline-end-style [
          [(get w [:prop-border-inline-end-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-end-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-inline-end-style gen-prop-border-inline-end-style)

        gen-prop-backface-visibility
        (igen/freq :prop-backface-visibility [
          [(get w [:prop-backface-visibility :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-backface-visibility :alt 1] 100)
            (gen/return "visible ")]
          [(get w [:prop-backface-visibility :alt 2] 100)
            (gen/return "hidden ")]])
        g (assoc g :prop-backface-visibility gen-prop-backface-visibility)

        gen-prop-border-block-end
        (igen/freq :prop-border-block-end [
          [(get w [:prop-border-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-end :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-block-end [
                [(get w [:prop-border-block-end :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-block-end :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-block-end :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-block-end gen-prop-border-block-end)

        gen-prop-background-position
        (igen/freq :prop-background-position [
          [(get w [:prop-background-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-position :alt 1] 100)
            (gen/tuple
              (:nonprop-bg-position g)
              (igen/freq :prop-background-position [
                [(get w [:prop-background-position :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-position :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-bg-position g)))]]))]])
        g (assoc g :prop-background-position gen-prop-background-position)

        gen-prop-border-inline-start-style
        (igen/freq :prop-border-inline-start-style [
          [(get w [:prop-border-inline-start-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-start-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-inline-start-style gen-prop-border-inline-start-style)

        gen-prop-border-bottom-style
        (igen/freq :prop-border-bottom-style [
          [(get w [:prop-border-bottom-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom-style :alt 1] 100)
            (:nonprop-line-style g)]])
        g (assoc g :prop-border-bottom-style gen-prop-border-bottom-style)

        gen-prop-transition-delay
        (igen/freq :prop-transition-delay [
          [(get w [:prop-transition-delay :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transition-delay :alt 1] 100)
            (gen/tuple
              (:nonprop-time g)
              (igen/freq :prop-transition-delay [
                [(get w [:prop-transition-delay :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-transition-delay :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-time g)))]]))]])
        g (assoc g :prop-transition-delay gen-prop-transition-delay)

        gen-prop-flex-basis
        (igen/freq :prop-flex-basis [
          [(get w [:prop-flex-basis :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-basis :alt 1] 100)
            (gen/return "content ")]
          [(get w [:prop-flex-basis :alt 2] 100)
            (:prop-width g)]])
        g (assoc g :prop-flex-basis gen-prop-flex-basis)

        gen-prop-flex-shrink
        (igen/freq :prop-flex-shrink [
          [(get w [:prop-flex-shrink :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-shrink :alt 1] 100)
            (:nonprop-number g)]])
        g (assoc g :prop-flex-shrink gen-prop-flex-shrink)

        gen-prop-flex
        (igen/freq :prop-flex [
          [(get w [:prop-flex :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-flex :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-flex [
                [(get w [:prop-flex :alt 2 :plus 0 :alt 0] 100)
                  (gen/tuple
                    (:prop-flex-grow g)
                    (igen/freq :prop-flex [
                      [(get w [:prop-flex :alt 2 :plus 0 :alt 0 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:prop-flex :alt 2 :plus 0 :alt 0 :cat 1 :opt 0] 100)
                        (:prop-flex-shrink g)]]))]
                [(get w [:prop-flex :alt 2 :plus 0 :alt 1] 100)
                  (:prop-flex-basis g)]]))]])
        g (assoc g :prop-flex gen-prop-flex)

        gen-nonprop-animateable-feature
        (igen/freq :nonprop-animateable-feature [
          [(get w [:nonprop-animateable-feature :alt 0] 100)
            (gen/return "scroll-position ")]
          [(get w [:nonprop-animateable-feature :alt 1] 100)
            (gen/return "contents ")]
          [(get w [:nonprop-animateable-feature :alt 2] 100)
            (:nonprop-custom-ident g)]])
        g (assoc g :nonprop-animateable-feature gen-nonprop-animateable-feature)

        gen-prop-will-change
        (igen/freq :prop-will-change [
          [(get w [:prop-will-change :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-will-change :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-will-change :alt 2] 100)
            (gen/tuple
              (:nonprop-animateable-feature g)
              (igen/freq :prop-will-change [
                [(get w [:prop-will-change :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-will-change :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-animateable-feature g)))]]))]])
        g (assoc g :prop-will-change gen-prop-will-change)

        gen-prop-overflow
        (igen/freq :prop-overflow [
          [(get w [:prop-overflow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-overflow :alt 1] 100)
            (igen/freq :prop-overflow [
              [(get w [:prop-overflow :alt 1 :alt 0] 100)
                (igen/freq :prop-overflow [
                  [(get w [:prop-overflow :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "visible ")]
                  [(get w [:prop-overflow :alt 1 :alt 0 :alt 1] 100)
                    (gen/return "hidden ")]
                  [(get w [:prop-overflow :alt 1 :alt 0 :alt 2] 100)
                    (gen/return "clip ")]
                  [(get w [:prop-overflow :alt 1 :alt 0 :alt 3] 100)
                    (gen/return "scroll ")]
                  [(get w [:prop-overflow :alt 1 :alt 0 :alt 4] 100)
                    (gen/return "auto ")]])]
              [(get w [:prop-overflow :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-overflow [
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "visible ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "hidden ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "clip ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 0 :alt 3] 100)
                      (gen/return "scroll ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 0 :alt 4] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-overflow [
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "visible ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "hidden ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "clip ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 2 :alt 3] 100)
                      (gen/return "scroll ")]
                    [(get w [:prop-overflow :alt 1 :alt 1 :cat 2 :alt 4] 100)
                      (gen/return "auto ")]]))]])]])
        g (assoc g :prop-overflow gen-prop-overflow)

        gen-nonprop-x
        (gen/return "11")
        g (assoc g :nonprop-x gen-nonprop-x)

        gen-prop-visibility
        (igen/freq :prop-visibility [
          [(get w [:prop-visibility :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-visibility :alt 1] 100)
            (gen/return "visible ")]
          [(get w [:prop-visibility :alt 2] 100)
            (gen/return "hidden ")]
          [(get w [:prop-visibility :alt 3] 100)
            (gen/return "collapse ")]])
        g (assoc g :prop-visibility gen-prop-visibility)

        gen-prop-text-orientation
        (igen/freq :prop-text-orientation [
          [(get w [:prop-text-orientation :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-orientation :alt 1] 100)
            (gen/return "mixed ")]
          [(get w [:prop-text-orientation :alt 2] 100)
            (gen/return "upright ")]
          [(get w [:prop-text-orientation :alt 3] 100)
            (gen/return "sideways ")]])
        g (assoc g :prop-text-orientation gen-prop-text-orientation)

        gen-prop-scroll-padding-block-start
        (igen/freq :prop-scroll-padding-block-start [
          [(get w [:prop-scroll-padding-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-block-start :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-block-start :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-block-start :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-block-start gen-prop-scroll-padding-block-start)

        gen-func-drop-shadow
        (gen/tuple
          (gen/return "drop-shadow ")
          (gen/return "( ")
          (igen/freq :func-drop-shadow [
            [(get w [:func-drop-shadow :cat 2 :alt 0] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]
            [(get w [:func-drop-shadow :cat 2 :alt 1] 100)
              (gen/tuple
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g)
                (gen/return " ")
                (:nonprop-length g))]])
          (igen/freq :func-drop-shadow [
            [(get w [:func-drop-shadow :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-drop-shadow :cat 3 :opt 0] 100)
              (:nonprop-color g)]])
          (gen/return ") "))
        g (assoc g :func-drop-shadow gen-func-drop-shadow)

        gen-func-saturate
        (gen/tuple
          (gen/return "saturate ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-saturate gen-func-saturate)

        gen-func-hue-rotate
        (gen/tuple
          (gen/return "hue-rotate ")
          (gen/return "( ")
          (:nonprop-angle g)
          (gen/return ") "))
        g (assoc g :func-hue-rotate gen-func-hue-rotate)

        gen-func-blur
        (gen/tuple
          (gen/return "blur ")
          (gen/return "( ")
          (:nonprop-length g)
          (gen/return ") "))
        g (assoc g :func-blur gen-func-blur)

        gen-func-opacity
        (gen/tuple
          (gen/return "opacity ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-opacity gen-func-opacity)

        gen-func-grayscale
        (gen/tuple
          (gen/return "grayscale ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-grayscale gen-func-grayscale)

        gen-func-sepia
        (gen/tuple
          (gen/return "sepia ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-sepia gen-func-sepia)

        gen-func-invert
        (gen/tuple
          (gen/return "invert ")
          (gen/return "( ")
          (:nonprop-number-percentage g)
          (gen/return ") "))
        g (assoc g :func-invert gen-func-invert)

        gen-nonprop-filter-function
        (igen/freq :nonprop-filter-function [
          [(get w [:nonprop-filter-function :alt 0] 100)
            (:func-blur g)]
          [(get w [:nonprop-filter-function :alt 1] 100)
            (:func-brightness g)]
          [(get w [:nonprop-filter-function :alt 2] 100)
            (:func-contrast g)]
          [(get w [:nonprop-filter-function :alt 3] 100)
            (:func-drop-shadow g)]
          [(get w [:nonprop-filter-function :alt 4] 100)
            (:func-grayscale g)]
          [(get w [:nonprop-filter-function :alt 5] 100)
            (:func-hue-rotate g)]
          [(get w [:nonprop-filter-function :alt 6] 100)
            (:func-invert g)]
          [(get w [:nonprop-filter-function :alt 7] 100)
            (:func-opacity g)]
          [(get w [:nonprop-filter-function :alt 8] 100)
            (:func-saturate g)]
          [(get w [:nonprop-filter-function :alt 9] 100)
            (:func-sepia g)]])
        g (assoc g :nonprop-filter-function gen-nonprop-filter-function)

        gen-prop-margin-block-end
        (igen/freq :prop-margin-block-end [
          [(get w [:prop-margin-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-block-end :alt 1] 100)
            (:prop-margin-left g)]])
        g (assoc g :prop-margin-block-end gen-prop-margin-block-end)

        gen-prop-scroll-margin
        (igen/freq :prop-scroll-margin [
          [(get w [:prop-scroll-margin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin :alt 1] 100)
            (igen/freq :prop-scroll-margin [
              [(get w [:prop-scroll-margin :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-margin [
                  [(get w [:prop-scroll-margin :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-margin :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]])]
              [(get w [:prop-scroll-margin :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]]))]
              [(get w [:prop-scroll-margin :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-length g)]]))]
              [(get w [:prop-scroll-margin :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin [
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-length g)]]))]])]])
        g (assoc g :prop-scroll-margin gen-prop-scroll-margin)

        gen-prop-background-image
        (igen/freq :prop-background-image [
          [(get w [:prop-background-image :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-image :alt 1] 100)
            (gen/tuple
              (:nonprop-bg-image g)
              (igen/freq :prop-background-image [
                [(get w [:prop-background-image :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-image :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-bg-image g)))]]))]])
        g (assoc g :prop-background-image gen-prop-background-image)

        gen-prop-border-spacing
        (igen/freq :prop-border-spacing [
          [(get w [:prop-border-spacing :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-spacing :alt 1] 100)
            (gen/tuple
              (:nonprop-length g)
              (igen/freq :prop-border-spacing [
                [(get w [:prop-border-spacing :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-border-spacing :alt 1 :cat 1 :opt 0] 100)
                  (:nonprop-length g)]]))]])
        g (assoc g :prop-border-spacing gen-prop-border-spacing)

        gen-prop-hanging-punctuation
        (igen/freq :prop-hanging-punctuation [
          [(get w [:prop-hanging-punctuation :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-hanging-punctuation :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-hanging-punctuation :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-hanging-punctuation [
                [(get w [:prop-hanging-punctuation :alt 2 :plus 0 :alt 0] 100)
                  (gen/return "first ")]
                [(get w [:prop-hanging-punctuation :alt 2 :plus 0 :alt 1] 100)
                  (igen/freq :prop-hanging-punctuation [
                    [(get w [:prop-hanging-punctuation :alt 2 :plus 0 :alt 1 :alt 0] 100)
                      (gen/return "force-end ")]
                    [(get w [:prop-hanging-punctuation :alt 2 :plus 0 :alt 1 :alt 1] 100)
                      (gen/return "allow-end ")]])]
                [(get w [:prop-hanging-punctuation :alt 2 :plus 0 :alt 2] 100)
                  (gen/return "last ")]]))]])
        g (assoc g :prop-hanging-punctuation gen-prop-hanging-punctuation)

        gen-prop-grid-area
        (igen/freq :prop-grid-area [
          [(get w [:prop-grid-area :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-area :alt 1] 100)
            (gen/tuple
              (:nonprop-grid-line g)
              (igen/freq :prop-grid-area [
                [(get w [:prop-grid-area :alt 1 :cat 1 :alt 0] 100)
                  (gen/return "")]
                [(get w [:prop-grid-area :alt 1 :cat 1 :alt 1] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-grid-line g))]
                [(get w [:prop-grid-area :alt 1 :cat 1 :alt 2] 100)
                  (gen/tuple
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-grid-line g))
                    (gen/return " ")
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-grid-line g)))]
                [(get w [:prop-grid-area :alt 1 :cat 1 :alt 3] 100)
                  (gen/tuple
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-grid-line g))
                    (gen/return " ")
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-grid-line g))
                    (gen/return " ")
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-grid-line g)))]]))]])
        g (assoc g :prop-grid-area gen-prop-grid-area)

        gen-nonprop-family-name
        (igen/freq :nonprop-family-name [
          [(get w [:nonprop-family-name :alt 0] 100)
            (:nonprop-string g)]
          [(get w [:nonprop-family-name :alt 1] 100)
            (igen/vector+
              (:nonprop-custom-ident g))]])
        g (assoc g :nonprop-family-name gen-nonprop-family-name)

        gen-nonprop-generic-family
        (igen/freq :nonprop-generic-family [
          [(get w [:nonprop-generic-family :alt 0] 100)
            (gen/return "serif ")]
          [(get w [:nonprop-generic-family :alt 1] 100)
            (gen/return "sans-serif ")]
          [(get w [:nonprop-generic-family :alt 2] 100)
            (gen/return "cursive ")]
          [(get w [:nonprop-generic-family :alt 3] 100)
            (gen/return "fantasy ")]
          [(get w [:nonprop-generic-family :alt 4] 100)
            (gen/return "monospace ")]])
        g (assoc g :nonprop-generic-family gen-nonprop-generic-family)

        gen-prop-font-family
        (igen/freq :prop-font-family [
          [(get w [:prop-font-family :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-family :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-font-family [
                [(get w [:prop-font-family :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-family-name g)]
                [(get w [:prop-font-family :alt 1 :cat 0 :alt 1] 100)
                  (:nonprop-generic-family g)]])
              (igen/freq :prop-font-family [
                [(get w [:prop-font-family :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-font-family :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (igen/freq :prop-font-family [
                        [(get w [:prop-font-family :alt 1 :cat 1 :star 0 :cat 2 :alt 0] 100)
                          (:nonprop-family-name g)]
                        [(get w [:prop-font-family :alt 1 :cat 1 :star 0 :cat 2 :alt 1] 100)
                          (:nonprop-generic-family g)]])))]]))]])
        g (assoc g :prop-font-family gen-prop-font-family)

        gen-nonprop-single-animation-play-state
        (igen/freq :nonprop-single-animation-play-state [
          [(get w [:nonprop-single-animation-play-state :alt 0] 100)
            (gen/return "running ")]
          [(get w [:nonprop-single-animation-play-state :alt 1] 100)
            (gen/return "paused ")]])
        g (assoc g :nonprop-single-animation-play-state gen-nonprop-single-animation-play-state)

        gen-prop-animation-play-state
        (igen/freq :prop-animation-play-state [
          [(get w [:prop-animation-play-state :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-play-state :alt 1] 100)
            (gen/tuple
              (:nonprop-single-animation-play-state g)
              (igen/freq :prop-animation-play-state [
                [(get w [:prop-animation-play-state :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-play-state :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-animation-play-state g)))]]))]])
        g (assoc g :prop-animation-play-state gen-prop-animation-play-state)

        gen-prop-tab-size
        (igen/freq :prop-tab-size [
          [(get w [:prop-tab-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-tab-size :alt 1] 100)
            (:nonprop-integer g)]
          [(get w [:prop-tab-size :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-tab-size gen-prop-tab-size)

        gen-prop-grid-row
        (igen/freq :prop-grid-row [
          [(get w [:prop-grid-row :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-row :alt 1] 100)
            (gen/tuple
              (:nonprop-grid-line g)
              (igen/freq :prop-grid-row [
                [(get w [:prop-grid-row :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-grid-row :alt 1 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-grid-line g))]]))]])
        g (assoc g :prop-grid-row gen-prop-grid-row)

        gen-prop-white-space
        (igen/freq :prop-white-space [
          [(get w [:prop-white-space :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-white-space :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-white-space :alt 2] 100)
            (gen/return "pre ")]
          [(get w [:prop-white-space :alt 3] 100)
            (gen/return "nowrap ")]
          [(get w [:prop-white-space :alt 4] 100)
            (gen/return "pre-wrap ")]
          [(get w [:prop-white-space :alt 5] 100)
            (gen/return "pre-line ")]])
        g (assoc g :prop-white-space gen-prop-white-space)

        gen-prop-scale
        (igen/freq :prop-scale [
          [(get w [:prop-scale :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scale :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-scale :alt 2] 100)
            (igen/freq :prop-scale [
              [(get w [:prop-scale :alt 2 :alt 0] 100)
                (:nonprop-number g)]
              [(get w [:prop-scale :alt 2 :alt 1] 100)
                (gen/tuple
                  (:nonprop-number g)
                  (gen/return " ")
                  (:nonprop-number g))]
              [(get w [:prop-scale :alt 2 :alt 2] 100)
                (gen/tuple
                  (:nonprop-number g)
                  (gen/return " ")
                  (:nonprop-number g)
                  (gen/return " ")
                  (:nonprop-number g))]])]])
        g (assoc g :prop-scale gen-prop-scale)

        gen-nonprop-common-lig-values
        (igen/freq :nonprop-common-lig-values [
          [(get w [:nonprop-common-lig-values :alt 0] 100)
            (gen/return "common-ligatures ")]
          [(get w [:nonprop-common-lig-values :alt 1] 100)
            (gen/return "no-common-ligatures ")]])
        g (assoc g :nonprop-common-lig-values gen-nonprop-common-lig-values)

        gen-nonprop-historical-lig-values
        (igen/freq :nonprop-historical-lig-values [
          [(get w [:nonprop-historical-lig-values :alt 0] 100)
            (gen/return "historical-ligatures ")]
          [(get w [:nonprop-historical-lig-values :alt 1] 100)
            (gen/return "no-historical-ligatures ")]])
        g (assoc g :nonprop-historical-lig-values gen-nonprop-historical-lig-values)

        gen-nonprop-contextual-alt-values
        (igen/freq :nonprop-contextual-alt-values [
          [(get w [:nonprop-contextual-alt-values :alt 0] 100)
            (gen/return "contextual ")]
          [(get w [:nonprop-contextual-alt-values :alt 1] 100)
            (gen/return "no-contextual ")]])
        g (assoc g :nonprop-contextual-alt-values gen-nonprop-contextual-alt-values)

        gen-prop-font-variant-ligatures
        (igen/freq :prop-font-variant-ligatures [
          [(get w [:prop-font-variant-ligatures :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-ligatures :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-ligatures :alt 2] 100)
            (gen/return "none ")]
          [(get w [:prop-font-variant-ligatures :alt 3] 100)
            (igen/vector+
              (igen/freq :prop-font-variant-ligatures [
                [(get w [:prop-font-variant-ligatures :alt 3 :plus 0 :alt 0] 100)
                  (:nonprop-common-lig-values g)]
                [(get w [:prop-font-variant-ligatures :alt 3 :plus 0 :alt 1] 100)
                  (:nonprop-discretionary-lig-values g)]
                [(get w [:prop-font-variant-ligatures :alt 3 :plus 0 :alt 2] 100)
                  (:nonprop-historical-lig-values g)]
                [(get w [:prop-font-variant-ligatures :alt 3 :plus 0 :alt 3] 100)
                  (:nonprop-contextual-alt-values g)]]))]])
        g (assoc g :prop-font-variant-ligatures gen-prop-font-variant-ligatures)

        gen-prop-mask-clip
        (igen/freq :prop-mask-clip [
          [(get w [:prop-mask-clip :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-clip :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-mask-clip [
                [(get w [:prop-mask-clip :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-geometry-box g)]
                [(get w [:prop-mask-clip :alt 1 :cat 0 :alt 1] 100)
                  (gen/return "no-clip ")]])
              (igen/freq :prop-mask-clip [
                [(get w [:prop-mask-clip :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-clip :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (igen/freq :prop-mask-clip [
                        [(get w [:prop-mask-clip :alt 1 :cat 1 :star 0 :cat 2 :alt 0] 100)
                          (:nonprop-geometry-box g)]
                        [(get w [:prop-mask-clip :alt 1 :cat 1 :star 0 :cat 2 :alt 1] 100)
                          (gen/return "no-clip ")]])))]]))]])
        g (assoc g :prop-mask-clip gen-prop-mask-clip)]
    g))

(defn- css3-generators-part-7 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-max-width
        (igen/freq :prop-max-width [
          [(get w [:prop-max-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-max-width :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-max-width :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-max-width :alt 3] 100)
            (gen/return "none ")]
          [(get w [:prop-max-width :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-max-width :alt 5] 100)
            (gen/return "min-content ")]
          [(get w [:prop-max-width :alt 6] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-max-width :alt 7] 100)
            (gen/return "fill-available ")]])
        g (assoc g :prop-max-width gen-prop-max-width)

        gen-prop-transform-box
        (igen/freq :prop-transform-box [
          [(get w [:prop-transform-box :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transform-box :alt 1] 100)
            (gen/return "border-box ")]
          [(get w [:prop-transform-box :alt 2] 100)
            (gen/return "fill-box ")]
          [(get w [:prop-transform-box :alt 3] 100)
            (gen/return "view-box ")]])
        g (assoc g :prop-transform-box gen-prop-transform-box)

        gen-prop-scroll-behavior
        (igen/freq :prop-scroll-behavior [
          [(get w [:prop-scroll-behavior :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-behavior :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-behavior :alt 2] 100)
            (gen/return "smooth ")]])
        g (assoc g :prop-scroll-behavior gen-prop-scroll-behavior)

        gen-prop-grid-template-areas
        (igen/freq :prop-grid-template-areas [
          [(get w [:prop-grid-template-areas :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-template-areas :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-grid-template-areas :alt 2] 100)
            (igen/vector+
              (:nonprop-string g))]])
        g (assoc g :prop-grid-template-areas gen-prop-grid-template-areas)

        gen-nonprop-filter-function-list
        (igen/vector+
          (igen/freq :nonprop-filter-function-list [
            [(get w [:nonprop-filter-function-list :plus 0 :alt 0] 100)
              (:nonprop-filter-function g)]
            [(get w [:nonprop-filter-function-list :plus 0 :alt 1] 100)
              (:nonprop-url g)]]))
        g (assoc g :nonprop-filter-function-list gen-nonprop-filter-function-list)

        gen-prop-filter
        (igen/freq :prop-filter [
          [(get w [:prop-filter :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-filter :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-filter :alt 2] 100)
            (:nonprop-filter-function-list g)]])
        g (assoc g :prop-filter gen-prop-filter)

        gen-prop-text-justify
        (igen/freq :prop-text-justify [
          [(get w [:prop-text-justify :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-justify :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-text-justify :alt 2] 100)
            (gen/return "inter-character ")]
          [(get w [:prop-text-justify :alt 3] 100)
            (gen/return "inter-word ")]
          [(get w [:prop-text-justify :alt 4] 100)
            (gen/return "none ")]])
        g (assoc g :prop-text-justify gen-prop-text-justify)

        gen-prop-flex-wrap
        (igen/freq :prop-flex-wrap [
          [(get w [:prop-flex-wrap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-wrap :alt 1] 100)
            (gen/return "nowrap ")]
          [(get w [:prop-flex-wrap :alt 2] 100)
            (gen/return "wrap ")]
          [(get w [:prop-flex-wrap :alt 3] 100)
            (gen/return "wrap-reverse ")]])
        g (assoc g :prop-flex-wrap gen-prop-flex-wrap)

        gen-prop-flex-direction
        (igen/freq :prop-flex-direction [
          [(get w [:prop-flex-direction :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-direction :alt 1] 100)
            (gen/return "row ")]
          [(get w [:prop-flex-direction :alt 2] 100)
            (gen/return "row-reverse ")]
          [(get w [:prop-flex-direction :alt 3] 100)
            (gen/return "column ")]
          [(get w [:prop-flex-direction :alt 4] 100)
            (gen/return "column-reverse ")]])
        g (assoc g :prop-flex-direction gen-prop-flex-direction)

        gen-prop-flex-flow
        (igen/freq :prop-flex-flow [
          [(get w [:prop-flex-flow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-flex-flow :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-flex-flow [
                [(get w [:prop-flex-flow :alt 1 :plus 0 :alt 0] 100)
                  (:prop-flex-direction g)]
                [(get w [:prop-flex-flow :alt 1 :plus 0 :alt 1] 100)
                  (:prop-flex-wrap g)]]))]])
        g (assoc g :prop-flex-flow gen-prop-flex-flow)

        gen-prop-background-repeat
        (igen/freq :prop-background-repeat [
          [(get w [:prop-background-repeat :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-repeat :alt 1] 100)
            (gen/tuple
              (:nonprop-repeat-style g)
              (igen/freq :prop-background-repeat [
                [(get w [:prop-background-repeat :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-repeat :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-repeat-style g)))]]))]])
        g (assoc g :prop-background-repeat gen-prop-background-repeat)

        gen-nonprop-absolute-size
        (igen/freq :nonprop-absolute-size [
          [(get w [:nonprop-absolute-size :alt 0] 100)
            (gen/return "xx-small ")]
          [(get w [:nonprop-absolute-size :alt 1] 100)
            (gen/return "x-small ")]
          [(get w [:nonprop-absolute-size :alt 2] 100)
            (gen/return "small ")]
          [(get w [:nonprop-absolute-size :alt 3] 100)
            (gen/return "medium ")]
          [(get w [:nonprop-absolute-size :alt 4] 100)
            (gen/return "large ")]
          [(get w [:nonprop-absolute-size :alt 5] 100)
            (gen/return "x-large ")]
          [(get w [:nonprop-absolute-size :alt 6] 100)
            (gen/return "xx-large ")]])
        g (assoc g :nonprop-absolute-size gen-nonprop-absolute-size)

        gen-nonprop-relative-size
        (igen/freq :nonprop-relative-size [
          [(get w [:nonprop-relative-size :alt 0] 100)
            (gen/return "larger ")]
          [(get w [:nonprop-relative-size :alt 1] 100)
            (gen/return "smaller ")]])
        g (assoc g :nonprop-relative-size gen-nonprop-relative-size)

        gen-prop-font-size
        (igen/freq :prop-font-size [
          [(get w [:prop-font-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-size :alt 1] 100)
            (:nonprop-absolute-size g)]
          [(get w [:prop-font-size :alt 2] 100)
            (:nonprop-relative-size g)]
          [(get w [:prop-font-size :alt 3] 100)
            (:nonprop-length-percentage g)]])
        g (assoc g :prop-font-size gen-prop-font-size)

        gen-prop-border-inline-end
        (igen/freq :prop-border-inline-end [
          [(get w [:prop-border-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-end :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-inline-end [
                [(get w [:prop-border-inline-end :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-inline-end :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-inline-end :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-inline-end gen-prop-border-inline-end)

        gen-nonprop-bg-size
        (igen/freq :nonprop-bg-size [
          [(get w [:nonprop-bg-size :alt 0] 100)
            (igen/freq :nonprop-bg-size [
              [(get w [:nonprop-bg-size :alt 0 :alt 0] 100)
                (igen/freq :nonprop-bg-size [
                  [(get w [:nonprop-bg-size :alt 0 :alt 0 :alt 0] 100)
                    (:nonprop-length-percentage g)]
                  [(get w [:nonprop-bg-size :alt 0 :alt 0 :alt 1] 100)
                    (gen/return "auto ")]])]
              [(get w [:nonprop-bg-size :alt 0 :alt 1] 100)
                (gen/tuple
                  (igen/freq :nonprop-bg-size [
                    [(get w [:nonprop-bg-size :alt 0 :alt 1 :cat 0 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:nonprop-bg-size :alt 0 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :nonprop-bg-size [
                    [(get w [:nonprop-bg-size :alt 0 :alt 1 :cat 2 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:nonprop-bg-size :alt 0 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "auto ")]]))]])]
          [(get w [:nonprop-bg-size :alt 1] 100)
            (gen/return "cover ")]
          [(get w [:nonprop-bg-size :alt 2] 100)
            (gen/return "contain ")]])
        g (assoc g :nonprop-bg-size gen-nonprop-bg-size)

        gen-prop-mask-size
        (igen/freq :prop-mask-size [
          [(get w [:prop-mask-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-size :alt 1] 100)
            (gen/tuple
              (:nonprop-bg-size g)
              (igen/freq :prop-mask-size [
                [(get w [:prop-mask-size :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-size :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-bg-size g)))]]))]])
        g (assoc g :prop-mask-size gen-prop-mask-size)

        gen-prop-float
        (igen/freq :prop-float [
          [(get w [:prop-float :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-float :alt 1] 100)
            (gen/return "left ")]
          [(get w [:prop-float :alt 2] 100)
            (gen/return "right ")]
          [(get w [:prop-float :alt 3] 100)
            (gen/return "none ")]
          [(get w [:prop-float :alt 4] 100)
            (gen/return "inline-start ")]
          [(get w [:prop-float :alt 5] 100)
            (gen/return "inline-end ")]])
        g (assoc g :prop-float gen-prop-float)

        gen-prop-scroll-padding-inline
        (igen/freq :prop-scroll-padding-inline [
          [(get w [:prop-scroll-padding-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-inline :alt 1] 100)
            (igen/freq :prop-scroll-padding-inline [
              [(get w [:prop-scroll-padding-inline :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-padding-inline [
                  [(get w [:prop-scroll-padding-inline :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-padding-inline :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-scroll-padding-inline :alt 1 :alt 0 :alt 2] 100)
                    (:nonprop-percentage g)]])]
              [(get w [:prop-scroll-padding-inline :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-padding-inline [
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding-inline [
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding-inline :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (:nonprop-percentage g)]]))]])]])
        g (assoc g :prop-scroll-padding-inline gen-prop-scroll-padding-inline)

        gen-nonprop-masking-mode
        (igen/freq :nonprop-masking-mode [
          [(get w [:nonprop-masking-mode :alt 0] 100)
            (gen/return "alpha ")]
          [(get w [:nonprop-masking-mode :alt 1] 100)
            (gen/return "luminance ")]
          [(get w [:nonprop-masking-mode :alt 2] 100)
            (gen/return "match-source ")]])
        g (assoc g :nonprop-masking-mode gen-nonprop-masking-mode)

        gen-prop-mask-mode
        (igen/freq :prop-mask-mode [
          [(get w [:prop-mask-mode :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-mode :alt 1] 100)
            (gen/tuple
              (:nonprop-masking-mode g)
              (igen/freq :prop-mask-mode [
                [(get w [:prop-mask-mode :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-mode :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-masking-mode g)))]]))]])
        g (assoc g :prop-mask-mode gen-prop-mask-mode)

        gen-nonprop-quote
        (igen/freq :nonprop-quote [
          [(get w [:nonprop-quote :alt 0] 100)
            (gen/return "open-quote ")]
          [(get w [:nonprop-quote :alt 1] 100)
            (gen/return "close-quote ")]
          [(get w [:nonprop-quote :alt 2] 100)
            (gen/return "no-open-quote ")]
          [(get w [:nonprop-quote :alt 3] 100)
            (gen/return "no-close-quote ")]])
        g (assoc g :nonprop-quote gen-nonprop-quote)

        gen-prop-scroll-snap-stop
        (igen/freq :prop-scroll-snap-stop [
          [(get w [:prop-scroll-snap-stop :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-snap-stop :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-scroll-snap-stop :alt 2] 100)
            (gen/return "always ")]])
        g (assoc g :prop-scroll-snap-stop gen-prop-scroll-snap-stop)

        gen-prop-letter-spacing
        (igen/freq :prop-letter-spacing [
          [(get w [:prop-letter-spacing :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-letter-spacing :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-letter-spacing :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-letter-spacing gen-prop-letter-spacing)

        gen-prop-border-top
        (igen/freq :prop-border-top [
          [(get w [:prop-border-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-top [
                [(get w [:prop-border-top :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-line-width g)]
                [(get w [:prop-border-top :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-line-style g)]
                [(get w [:prop-border-top :alt 1 :plus 0 :alt 2] 100)
                  (:nonprop-color g)]]))]])
        g (assoc g :prop-border-top gen-prop-border-top)

        gen-prop-text-combine-upright
        (igen/freq :prop-text-combine-upright [
          [(get w [:prop-text-combine-upright :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-combine-upright :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-text-combine-upright :alt 2] 100)
            (gen/return "all ")]
          [(get w [:prop-text-combine-upright :alt 3] 100)
            (gen/tuple
              (gen/return "digits ")
              (igen/freq :prop-text-combine-upright [
                [(get w [:prop-text-combine-upright :alt 3 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-text-combine-upright :alt 3 :cat 1 :opt 0] 100)
                  (:nonprop-integer g)]]))]])
        g (assoc g :prop-text-combine-upright gen-prop-text-combine-upright)

        gen-prop-border-bottom-right-radius
        (igen/freq :prop-border-bottom-right-radius [
          [(get w [:prop-border-bottom-right-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom-right-radius :alt 1] 100)
            (igen/freq :prop-border-bottom-right-radius [
              [(get w [:prop-border-bottom-right-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-bottom-right-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-bottom-right-radius gen-prop-border-bottom-right-radius)

        gen-prop-align-self
        (igen/freq :prop-align-self [
          [(get w [:prop-align-self :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-align-self :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-align-self :alt 2] 100)
            (gen/return "normal ")]
          [(get w [:prop-align-self :alt 3] 100)
            (gen/return "stretch ")]
          [(get w [:prop-align-self :alt 4] 100)
            (:nonprop-baseline-position g)]
          [(get w [:prop-align-self :alt 5] 100)
            (gen/tuple
              (igen/freq :prop-align-self [
                [(get w [:prop-align-self :alt 5 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-align-self :alt 5 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (:nonprop-self-position g))]])
        g (assoc g :prop-align-self gen-prop-align-self)

        gen-prop-page-break-after
        (igen/freq :prop-page-break-after [
          [(get w [:prop-page-break-after :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-page-break-after :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-page-break-after :alt 2] 100)
            (gen/return "always ")]
          [(get w [:prop-page-break-after :alt 3] 100)
            (gen/return "avoid ")]
          [(get w [:prop-page-break-after :alt 4] 100)
            (gen/return "left ")]
          [(get w [:prop-page-break-after :alt 5] 100)
            (gen/return "right ")]
          [(get w [:prop-page-break-after :alt 6] 100)
            (gen/return "recto ")]
          [(get w [:prop-page-break-after :alt 7] 100)
            (gen/return "verso ")]])
        g (assoc g :prop-page-break-after gen-prop-page-break-after)

        gen-prop-border-inline-start-color
        (igen/freq :prop-border-inline-start-color [
          [(get w [:prop-border-inline-start-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-start-color :alt 1] 100)
            (:prop-border-top-color g)]])
        g (assoc g :prop-border-inline-start-color gen-prop-border-inline-start-color)

        gen-prop-mask-image
        (igen/freq :prop-mask-image [
          [(get w [:prop-mask-image :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-image :alt 1] 100)
            (gen/tuple
              (:nonprop-mask-reference g)
              (igen/freq :prop-mask-image [
                [(get w [:prop-mask-image :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-image :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-mask-reference g)))]]))]])
        g (assoc g :prop-mask-image gen-prop-mask-image)

        gen-prop-mask-position
        (igen/freq :prop-mask-position [
          [(get w [:prop-mask-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-position :alt 1] 100)
            (gen/tuple
              (:nonprop-position g)
              (igen/freq :prop-mask-position [
                [(get w [:prop-mask-position :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-position :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-position g)))]]))]])
        g (assoc g :prop-mask-position gen-prop-mask-position)

        gen-prop-list-style-position
        (igen/freq :prop-list-style-position [
          [(get w [:prop-list-style-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-list-style-position :alt 1] 100)
            (gen/return "inside ")]
          [(get w [:prop-list-style-position :alt 2] 100)
            (gen/return "outside ")]])
        g (assoc g :prop-list-style-position gen-prop-list-style-position)

        gen-prop-hyphens
        (igen/freq :prop-hyphens [
          [(get w [:prop-hyphens :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-hyphens :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-hyphens :alt 2] 100)
            (gen/return "manual ")]
          [(get w [:prop-hyphens :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-hyphens gen-prop-hyphens)

        gen-prop-transition
        (igen/freq :prop-transition [
          [(get w [:prop-transition :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transition :alt 1] 100)
            (gen/tuple
              (:nonprop-single-transition g)
              (igen/freq :prop-transition [
                [(get w [:prop-transition :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-transition :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-transition g)))]]))]])
        g (assoc g :prop-transition gen-prop-transition)

        gen-prop-caret-color
        (igen/freq :prop-caret-color [
          [(get w [:prop-caret-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-caret-color :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-caret-color :alt 2] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-caret-color gen-prop-caret-color)

        gen-func-ellipse
        (gen/tuple
          (gen/return "ellipse ")
          (gen/return "( ")
          (igen/freq :func-ellipse [
            [(get w [:func-ellipse :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-ellipse :cat 2 :opt 0] 100)
              (gen/tuple
                (:nonprop-shape-radius g)
                (gen/return " ")
                (:nonprop-shape-radius g))]])
          (igen/freq :func-ellipse [
            [(get w [:func-ellipse :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-ellipse :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "at ")
                (:nonprop-position g))]])
          (gen/return ") "))
        g (assoc g :func-ellipse gen-func-ellipse)

        gen-prop-pointer-events
        (igen/freq :prop-pointer-events [
          [(get w [:prop-pointer-events :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-pointer-events :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-pointer-events :alt 2] 100)
            (gen/return "none ")]
          [(get w [:prop-pointer-events :alt 3] 100)
            (gen/return "visiblePainted ")]
          [(get w [:prop-pointer-events :alt 4] 100)
            (gen/return "visibleFill ")]
          [(get w [:prop-pointer-events :alt 5] 100)
            (gen/return "visibleStroke ")]
          [(get w [:prop-pointer-events :alt 6] 100)
            (gen/return "visible ")]
          [(get w [:prop-pointer-events :alt 7] 100)
            (gen/return "painted ")]
          [(get w [:prop-pointer-events :alt 8] 100)
            (gen/return "fill ")]
          [(get w [:prop-pointer-events :alt 9] 100)
            (gen/return "stroke ")]
          [(get w [:prop-pointer-events :alt 10] 100)
            (gen/return "all ")]
          [(get w [:prop-pointer-events :alt 11] 100)
            (gen/return "inherit ")]])
        g (assoc g :prop-pointer-events gen-prop-pointer-events)

        gen-prop-animation-fill-mode
        (igen/freq :prop-animation-fill-mode [
          [(get w [:prop-animation-fill-mode :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-fill-mode :alt 1] 100)
            (gen/tuple
              (:nonprop-single-animation-fill-mode g)
              (igen/freq :prop-animation-fill-mode [
                [(get w [:prop-animation-fill-mode :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-fill-mode :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-animation-fill-mode g)))]]))]])
        g (assoc g :prop-animation-fill-mode gen-prop-animation-fill-mode)

        gen-prop-margin-top
        (igen/freq :prop-margin-top [
          [(get w [:prop-margin-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-top :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-margin-top :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-margin-top :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-margin-top gen-prop-margin-top)

        gen-prop-touch-action
        (igen/freq :prop-touch-action [
          [(get w [:prop-touch-action :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-touch-action :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-touch-action :alt 2] 100)
            (gen/return "none ")]
          [(get w [:prop-touch-action :alt 3] 100)
            (igen/vector+
              (igen/freq :prop-touch-action [
                [(get w [:prop-touch-action :alt 3 :plus 0 :alt 0] 100)
                  (igen/freq :prop-touch-action [
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 0 :alt 0] 100)
                      (gen/return "pan-x ")]
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 0 :alt 1] 100)
                      (gen/return "pan-left ")]
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 0 :alt 2] 100)
                      (gen/return "pan-right ")]])]
                [(get w [:prop-touch-action :alt 3 :plus 0 :alt 1] 100)
                  (igen/freq :prop-touch-action [
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 1 :alt 0] 100)
                      (gen/return "pan-y ")]
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 1 :alt 1] 100)
                      (gen/return "pan-up ")]
                    [(get w [:prop-touch-action :alt 3 :plus 0 :alt 1 :alt 2] 100)
                      (gen/return "pan-down ")]])]
                [(get w [:prop-touch-action :alt 3 :plus 0 :alt 2] 100)
                  (gen/return "pinch-zoom ")]]))]
          [(get w [:prop-touch-action :alt 4] 100)
            (gen/return "manipulation ")]])
        g (assoc g :prop-touch-action gen-prop-touch-action)

        gen-prop-text-underline-position
        (igen/freq :prop-text-underline-position [
          [(get w [:prop-text-underline-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-underline-position :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-text-underline-position :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-text-underline-position [
                [(get w [:prop-text-underline-position :alt 2 :plus 0 :alt 0] 100)
                  (gen/return "under ")]
                [(get w [:prop-text-underline-position :alt 2 :plus 0 :alt 1] 100)
                  (igen/freq :prop-text-underline-position [
                    [(get w [:prop-text-underline-position :alt 2 :plus 0 :alt 1 :alt 0] 100)
                      (gen/return "left ")]
                    [(get w [:prop-text-underline-position :alt 2 :plus 0 :alt 1 :alt 1] 100)
                      (gen/return "right ")]])]]))]])
        g (assoc g :prop-text-underline-position gen-prop-text-underline-position)

        gen-prop-line-break
        (igen/freq :prop-line-break [
          [(get w [:prop-line-break :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-line-break :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-line-break :alt 2] 100)
            (gen/return "loose ")]
          [(get w [:prop-line-break :alt 3] 100)
            (gen/return "normal ")]
          [(get w [:prop-line-break :alt 4] 100)
            (gen/return "strict ")]])
        g (assoc g :prop-line-break gen-prop-line-break)

        gen-prop-scroll-margin-bottom
        (igen/freq :prop-scroll-margin-bottom [
          [(get w [:prop-scroll-margin-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-bottom :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-bottom :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-bottom gen-prop-scroll-margin-bottom)

        gen-prop-border-end-start-radius
        (igen/freq :prop-border-end-start-radius [
          [(get w [:prop-border-end-start-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-end-start-radius :alt 1] 100)
            (igen/freq :prop-border-end-start-radius [
              [(get w [:prop-border-end-start-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-end-start-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-end-start-radius gen-prop-border-end-start-radius)

        gen-prop-padding-top
        (igen/freq :prop-padding-top [
          [(get w [:prop-padding-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-top :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-padding-top :alt 2] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-padding-top gen-prop-padding-top)

        gen-nonprop-clip-source
        (:nonprop-url g)
        g (assoc g :nonprop-clip-source gen-nonprop-clip-source)

        gen-nonprop-fill-rule
        (igen/freq :nonprop-fill-rule [
          [(get w [:nonprop-fill-rule :alt 0] 100)
            (gen/return "nonzero ")]
          [(get w [:nonprop-fill-rule :alt 1] 100)
            (gen/return "evenodd ")]])
        g (assoc g :nonprop-fill-rule gen-nonprop-fill-rule)

        gen-prop-border-radius
        (igen/freq :prop-border-radius [
          [(get w [:prop-border-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-radius :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-border-radius [
                [(get w [:prop-border-radius :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-length-percentage g)]
                [(get w [:prop-border-radius :alt 1 :cat 0 :alt 1] 100)
                  (gen/tuple
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g))]
                [(get w [:prop-border-radius :alt 1 :cat 0 :alt 2] 100)
                  (gen/tuple
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g))]
                [(get w [:prop-border-radius :alt 1 :cat 0 :alt 3] 100)
                  (gen/tuple
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g)
                    (gen/return " ")
                    (:nonprop-length-percentage g))]])
              (igen/freq :prop-border-radius [
                [(get w [:prop-border-radius :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-border-radius :alt 1 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (igen/freq :prop-border-radius [
                      [(get w [:prop-border-radius :alt 1 :cat 1 :opt 0 :cat 1 :alt 0] 100)
                        (:nonprop-length-percentage g)]
                      [(get w [:prop-border-radius :alt 1 :cat 1 :opt 0 :cat 1 :alt 1] 100)
                        (gen/tuple
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g))]
                      [(get w [:prop-border-radius :alt 1 :cat 1 :opt 0 :cat 1 :alt 2] 100)
                        (gen/tuple
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g))]
                      [(get w [:prop-border-radius :alt 1 :cat 1 :opt 0 :cat 1 :alt 3] 100)
                        (gen/tuple
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g)
                          (gen/return " ")
                          (:nonprop-length-percentage g))]]))]]))]])
        g (assoc g :prop-border-radius gen-prop-border-radius)

        gen-func-polygon
        (gen/tuple
          (gen/return "polygon ")
          (gen/return "( ")
          (igen/freq :func-polygon [
            [(get w [:func-polygon :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-polygon :cat 2 :opt 0] 100)
              (:nonprop-fill-rule g)]])
          (gen/return ", ")
          (gen/tuple
            (:nonprop-length-percentage g)
            (:nonprop-length-percentage g))
          (igen/freq :func-polygon [
            [(get w [:func-polygon :cat 5 :star nil] 100)
              (gen/return "")]
            [(get w [:func-polygon :cat 5 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (gen/tuple
                    (:nonprop-length-percentage g)
                    (:nonprop-length-percentage g))))]])
          (gen/return ") "))
        g (assoc g :func-polygon gen-func-polygon)]
    g))

(defn- css3-generators-part-8 [gmap weights]
  (let [g gmap
        w weights

        gen-func-inset
        (gen/tuple
          (gen/return "inset ")
          (gen/return "( ")
          (igen/freq :func-inset [
            [(get w [:func-inset :cat 2 :alt 0] 100)
              (:nonprop-length-percentage g)]
            [(get w [:func-inset :cat 2 :alt 1] 100)
              (gen/tuple
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g))]
            [(get w [:func-inset :cat 2 :alt 2] 100)
              (gen/tuple
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g))]
            [(get w [:func-inset :cat 2 :alt 3] 100)
              (gen/tuple
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g)
                (gen/return " ")
                (:nonprop-length-percentage g))]])
          (igen/freq :func-inset [
            [(get w [:func-inset :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-inset :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "round ")
                (:prop-border-radius g))]])
          (gen/return ") "))
        g (assoc g :func-inset gen-func-inset)

        gen-nonprop-basic-shape
        (igen/freq :nonprop-basic-shape [
          [(get w [:nonprop-basic-shape :alt 0] 100)
            (:func-inset g)]
          [(get w [:nonprop-basic-shape :alt 1] 100)
            (:func-circle g)]
          [(get w [:nonprop-basic-shape :alt 2] 100)
            (:func-ellipse g)]
          [(get w [:nonprop-basic-shape :alt 3] 100)
            (:func-polygon g)]])
        g (assoc g :nonprop-basic-shape gen-nonprop-basic-shape)

        gen-prop-shape-outside
        (igen/freq :prop-shape-outside [
          [(get w [:prop-shape-outside :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-shape-outside :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-shape-outside :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-shape-outside [
                [(get w [:prop-shape-outside :alt 2 :plus 0 :alt 0] 100)
                  (:nonprop-shape-box g)]
                [(get w [:prop-shape-outside :alt 2 :plus 0 :alt 1] 100)
                  (:nonprop-basic-shape g)]]))]
          [(get w [:prop-shape-outside :alt 3] 100)
            (:nonprop-image g)]])
        g (assoc g :prop-shape-outside gen-prop-shape-outside)

        gen-prop-block-size
        (igen/freq :prop-block-size [
          [(get w [:prop-block-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-block-size :alt 1] 100)
            (:prop-width g)]])
        g (assoc g :prop-block-size gen-prop-block-size)

        gen-prop-clip-path
        (igen/freq :prop-clip-path [
          [(get w [:prop-clip-path :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-clip-path :alt 1] 100)
            (:nonprop-clip-source g)]
          [(get w [:prop-clip-path :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-clip-path [
                [(get w [:prop-clip-path :alt 2 :plus 0 :alt 0] 100)
                  (:nonprop-basic-shape g)]
                [(get w [:prop-clip-path :alt 2 :plus 0 :alt 1] 100)
                  (:nonprop-geometry-box g)]]))]
          [(get w [:prop-clip-path :alt 3] 100)
            (gen/return "none ")]])
        g (assoc g :prop-clip-path gen-prop-clip-path)

        gen-nonprop-y
        (gen/return "11")
        g (assoc g :nonprop-y gen-nonprop-y)

        gen-prop-scroll-padding-left
        (igen/freq :prop-scroll-padding-left [
          [(get w [:prop-scroll-padding-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-left :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-left :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-left :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-left gen-prop-scroll-padding-left)

        gen-prop-word-break
        (igen/freq :prop-word-break [
          [(get w [:prop-word-break :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-word-break :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-word-break :alt 2] 100)
            (gen/return "break-all ")]
          [(get w [:prop-word-break :alt 3] 100)
            (gen/return "keep-all ")]
          [(get w [:prop-word-break :alt 4] 100)
            (gen/return "break-word ")]])
        g (assoc g :prop-word-break gen-prop-word-break)

        gen-prop-transition-property
        (igen/freq :prop-transition-property [
          [(get w [:prop-transition-property :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transition-property :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-transition-property :alt 2] 100)
            (gen/tuple
              (:nonprop-single-transition-property g)
              (igen/freq :prop-transition-property [
                [(get w [:prop-transition-property :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-transition-property :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-transition-property g)))]]))]])
        g (assoc g :prop-transition-property gen-prop-transition-property)

        gen-prop-list-style-image
        (igen/freq :prop-list-style-image [
          [(get w [:prop-list-style-image :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-list-style-image :alt 1] 100)
            (:nonprop-url g)]
          [(get w [:prop-list-style-image :alt 2] 100)
            (gen/return "none ")]])
        g (assoc g :prop-list-style-image gen-prop-list-style-image)

        gen-prop-border-bottom-color
        (igen/freq :prop-border-bottom-color [
          [(get w [:prop-border-bottom-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom-color :alt 1] 100)
            (:prop-border-top-color g)]])
        g (assoc g :prop-border-bottom-color gen-prop-border-bottom-color)

        gen-prop-list-style-type
        (igen/freq :prop-list-style-type [
          [(get w [:prop-list-style-type :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-list-style-type :alt 1] 100)
            (:nonprop-counter-style g)]
          [(get w [:prop-list-style-type :alt 2] 100)
            (:nonprop-string g)]
          [(get w [:prop-list-style-type :alt 3] 100)
            (gen/return "none ")]])
        g (assoc g :prop-list-style-type gen-prop-list-style-type)

        gen-prop-list-style
        (igen/freq :prop-list-style [
          [(get w [:prop-list-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-list-style :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-list-style [
                [(get w [:prop-list-style :alt 1 :plus 0 :alt 0] 100)
                  (:prop-list-style-type g)]
                [(get w [:prop-list-style :alt 1 :plus 0 :alt 1] 100)
                  (:prop-list-style-position g)]
                [(get w [:prop-list-style :alt 1 :plus 0 :alt 2] 100)
                  (:prop-list-style-image g)]]))]])
        g (assoc g :prop-list-style gen-prop-list-style)

        gen-prop-border-collapse
        (igen/freq :prop-border-collapse [
          [(get w [:prop-border-collapse :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-collapse :alt 1] 100)
            (gen/return "collapse ")]
          [(get w [:prop-border-collapse :alt 2] 100)
            (gen/return "separate ")]])
        g (assoc g :prop-border-collapse gen-prop-border-collapse)

        gen-prop-border-block-color
        (igen/freq :prop-border-block-color [
          [(get w [:prop-border-block-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-color :alt 1] 100)
            (igen/freq :prop-border-block-color [
              [(get w [:prop-border-block-color :alt 1 :alt 0] 100)
                (:prop-border-top-color g)]
              [(get w [:prop-border-block-color :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-border-top-color g)
                  (gen/return " ")
                  (:prop-border-top-color g))]])]])
        g (assoc g :prop-border-block-color gen-prop-border-block-color)

        gen-prop-break-before
        (igen/freq :prop-break-before [
          [(get w [:prop-break-before :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-break-before :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-break-before :alt 2] 100)
            (gen/return "avoid ")]
          [(get w [:prop-break-before :alt 3] 100)
            (gen/return "always ")]
          [(get w [:prop-break-before :alt 4] 100)
            (gen/return "all ")]
          [(get w [:prop-break-before :alt 5] 100)
            (gen/return "avoid-page ")]
          [(get w [:prop-break-before :alt 6] 100)
            (gen/return "page ")]
          [(get w [:prop-break-before :alt 7] 100)
            (gen/return "left ")]
          [(get w [:prop-break-before :alt 8] 100)
            (gen/return "right ")]
          [(get w [:prop-break-before :alt 9] 100)
            (gen/return "recto ")]
          [(get w [:prop-break-before :alt 10] 100)
            (gen/return "verso ")]
          [(get w [:prop-break-before :alt 11] 100)
            (gen/return "avoid-column ")]
          [(get w [:prop-break-before :alt 12] 100)
            (gen/return "column ")]
          [(get w [:prop-break-before :alt 13] 100)
            (gen/return "avoid-region ")]
          [(get w [:prop-break-before :alt 14] 100)
            (gen/return "region ")]])
        g (assoc g :prop-break-before gen-prop-break-before)

        gen-prop-background-color
        (igen/freq :prop-background-color [
          [(get w [:prop-background-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-background-color gen-prop-background-color)

        gen-prop-transition-timing-function
        (igen/freq :prop-transition-timing-function [
          [(get w [:prop-transition-timing-function :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transition-timing-function :alt 1] 100)
            (gen/tuple
              (:nonprop-timing-function g)
              (igen/freq :prop-transition-timing-function [
                [(get w [:prop-transition-timing-function :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-transition-timing-function :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-timing-function g)))]]))]])
        g (assoc g :prop-transition-timing-function gen-prop-transition-timing-function)

        gen-prop-background-clip
        (igen/freq :prop-background-clip [
          [(get w [:prop-background-clip :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-clip :alt 1] 100)
            (gen/tuple
              (:nonprop-box g)
              (igen/freq :prop-background-clip [
                [(get w [:prop-background-clip :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-clip :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-box g)))]]))]])
        g (assoc g :prop-background-clip gen-prop-background-clip)

        gen-prop-word-wrap
        (igen/freq :prop-word-wrap [
          [(get w [:prop-word-wrap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-word-wrap :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-word-wrap :alt 2] 100)
            (gen/return "break-word ")]])
        g (assoc g :prop-word-wrap gen-prop-word-wrap)

        gen-prop-scroll-margin-inline-start
        (igen/freq :prop-scroll-margin-inline-start [
          [(get w [:prop-scroll-margin-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-inline-start :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-inline-start :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-inline-start gen-prop-scroll-margin-inline-start)

        gen-prop-font-variant-alternates
        (igen/freq :prop-font-variant-alternates [
          [(get w [:prop-font-variant-alternates :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-alternates :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-alternates :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-font-variant-alternates [
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 0] 100)
                  (gen/tuple
                    (gen/return "stylistic ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 1] 100)
                  (gen/return "historical-forms ")]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 2] 100)
                  (gen/tuple
                    (gen/return "styleset ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (igen/freq :prop-font-variant-alternates [
                      [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 2 :cat 3 :star nil] 100)
                        (gen/return "")]
                      [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 2 :cat 3 :star 0] 100)
                        (igen/vector+
                          (gen/tuple
                            (gen/return ",")
                            (gen/return " ")
                            (:nonprop-feature-value-name g)))]])
                    (gen/return ") "))]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 3] 100)
                  (gen/tuple
                    (gen/return "character-variant ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (igen/freq :prop-font-variant-alternates [
                      [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 3 :cat 3 :star nil] 100)
                        (gen/return "")]
                      [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 3 :cat 3 :star 0] 100)
                        (igen/vector+
                          (gen/tuple
                            (gen/return ",")
                            (gen/return " ")
                            (:nonprop-feature-value-name g)))]])
                    (gen/return ") "))]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 4] 100)
                  (gen/tuple
                    (gen/return "swash ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 5] 100)
                  (gen/tuple
                    (gen/return "ornaments ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant-alternates :alt 2 :plus 0 :alt 6] 100)
                  (gen/tuple
                    (gen/return "annotation ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]]))]])
        g (assoc g :prop-font-variant-alternates gen-prop-font-variant-alternates)

        gen-prop-image-orientation
        (igen/freq :prop-image-orientation [
          [(get w [:prop-image-orientation :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-image-orientation :alt 1] 100)
            (gen/return "from-image ")]
          [(get w [:prop-image-orientation :alt 2] 100)
            (:nonprop-angle g)]
          [(get w [:prop-image-orientation :alt 3] 100)
            (gen/tuple
              (igen/freq :prop-image-orientation [
                [(get w [:prop-image-orientation :alt 3 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-image-orientation :alt 3 :cat 0 :opt 0] 100)
                  (:nonprop-angle g)]])
              (gen/return "flip "))]])
        g (assoc g :prop-image-orientation gen-prop-image-orientation)

        gen-prop-grid-column
        (igen/freq :prop-grid-column [
          [(get w [:prop-grid-column :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-column :alt 1] 100)
            (gen/tuple
              (:nonprop-grid-line g)
              (igen/freq :prop-grid-column [
                [(get w [:prop-grid-column :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-grid-column :alt 1 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-grid-line g))]]))]])
        g (assoc g :prop-grid-column gen-prop-grid-column)

        gen-prop-position
        (igen/freq :prop-position [
          [(get w [:prop-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-position :alt 1] 100)
            (gen/return "static ")]
          [(get w [:prop-position :alt 2] 100)
            (gen/return "relative ")]
          [(get w [:prop-position :alt 3] 100)
            (gen/return "absolute ")]
          [(get w [:prop-position :alt 4] 100)
            (gen/return "sticky ")]
          [(get w [:prop-position :alt 5] 100)
            (gen/return "fixed ")]])
        g (assoc g :prop-position gen-prop-position)

        gen-prop-grid-row-start
        (igen/freq :prop-grid-row-start [
          [(get w [:prop-grid-row-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-row-start :alt 1] 100)
            (:nonprop-grid-line g)]])
        g (assoc g :prop-grid-row-start gen-prop-grid-row-start)

        gen-prop-scroll-padding-inline-end
        (igen/freq :prop-scroll-padding-inline-end [
          [(get w [:prop-scroll-padding-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-inline-end :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-inline-end :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-inline-end :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-inline-end gen-prop-scroll-padding-inline-end)

        gen-prop-border-top-left-radius
        (igen/freq :prop-border-top-left-radius [
          [(get w [:prop-border-top-left-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top-left-radius :alt 1] 100)
            (igen/freq :prop-border-top-left-radius [
              [(get w [:prop-border-top-left-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-top-left-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-top-left-radius gen-prop-border-top-left-radius)

        gen-prop-margin-inline-end
        (igen/freq :prop-margin-inline-end [
          [(get w [:prop-margin-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-inline-end :alt 1] 100)
            (:prop-margin-left g)]])
        g (assoc g :prop-margin-inline-end gen-prop-margin-inline-end)

        gen-prop-outline-style
        (igen/freq :prop-outline-style [
          [(get w [:prop-outline-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-outline-style :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-outline-style :alt 2] 100)
            (:prop-border-style g)]])
        g (assoc g :prop-outline-style gen-prop-outline-style)

        gen-prop-scroll-padding-bottom
        (igen/freq :prop-scroll-padding-bottom [
          [(get w [:prop-scroll-padding-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-bottom :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-bottom :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-bottom :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-bottom gen-prop-scroll-padding-bottom)

        gen-prop-background-attachment
        (igen/freq :prop-background-attachment [
          [(get w [:prop-background-attachment :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-attachment :alt 1] 100)
            (gen/tuple
              (:nonprop-attachment g)
              (igen/freq :prop-background-attachment [
                [(get w [:prop-background-attachment :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-attachment :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-attachment g)))]]))]])
        g (assoc g :prop-background-attachment gen-prop-background-attachment)

        gen-prop-padding-block
        (igen/freq :prop-padding-block [
          [(get w [:prop-padding-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-block :alt 1] 100)
            (igen/freq :prop-padding-block [
              [(get w [:prop-padding-block :alt 1 :alt 0] 100)
                (:prop-padding-left g)]
              [(get w [:prop-padding-block :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-padding-left g)
                  (gen/return " ")
                  (:prop-padding-left g))]])]])
        g (assoc g :prop-padding-block gen-prop-padding-block)

        gen-prop-table-layout
        (igen/freq :prop-table-layout [
          [(get w [:prop-table-layout :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-table-layout :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-table-layout :alt 2] 100)
            (gen/return "fixed ")]])
        g (assoc g :prop-table-layout gen-prop-table-layout)

        gen-prop-border-left-width
        (igen/freq :prop-border-left-width [
          [(get w [:prop-border-left-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-left-width :alt 1] 100)
            (:nonprop-line-width g)]])
        g (assoc g :prop-border-left-width gen-prop-border-left-width)

        gen-nonprop-font-weight-absolute
        (igen/freq :nonprop-font-weight-absolute [
          [(get w [:nonprop-font-weight-absolute :alt 0] 100)
            (gen/return "normal ")]
          [(get w [:nonprop-font-weight-absolute :alt 1] 100)
            (gen/return "bold ")]
          [(get w [:nonprop-font-weight-absolute :alt 2] 100)
            (:nonprop-number g)]])
        g (assoc g :nonprop-font-weight-absolute gen-nonprop-font-weight-absolute)

        gen-prop-font-weight
        (igen/freq :prop-font-weight [
          [(get w [:prop-font-weight :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-weight :alt 1] 100)
            (:nonprop-font-weight-absolute g)]
          [(get w [:prop-font-weight :alt 2] 100)
            (gen/return "bolder ")]
          [(get w [:prop-font-weight :alt 3] 100)
            (gen/return "lighter ")]])
        g (assoc g :prop-font-weight gen-prop-font-weight)

        gen-prop-scroll-margin-block-end
        (igen/freq :prop-scroll-margin-block-end [
          [(get w [:prop-scroll-margin-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-block-end :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-block-end :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-block-end gen-prop-scroll-margin-block-end)

        gen-prop-outline-color
        (igen/freq :prop-outline-color [
          [(get w [:prop-outline-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-outline-color :alt 1] 100)
            (:nonprop-color g)]
          [(get w [:prop-outline-color :alt 2] 100)
            (gen/return "invert ")]])
        g (assoc g :prop-outline-color gen-prop-outline-color)

        gen-prop-animation-timing-function
        (igen/freq :prop-animation-timing-function [
          [(get w [:prop-animation-timing-function :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-timing-function :alt 1] 100)
            (gen/tuple
              (:nonprop-timing-function g)
              (igen/freq :prop-animation-timing-function [
                [(get w [:prop-animation-timing-function :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-timing-function :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-timing-function g)))]]))]])
        g (assoc g :prop-animation-timing-function gen-prop-animation-timing-function)

        gen-prop-page-break-before
        (igen/freq :prop-page-break-before [
          [(get w [:prop-page-break-before :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-page-break-before :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-page-break-before :alt 2] 100)
            (gen/return "always ")]
          [(get w [:prop-page-break-before :alt 3] 100)
            (gen/return "avoid ")]
          [(get w [:prop-page-break-before :alt 4] 100)
            (gen/return "left ")]
          [(get w [:prop-page-break-before :alt 5] 100)
            (gen/return "right ")]
          [(get w [:prop-page-break-before :alt 6] 100)
            (gen/return "recto ")]
          [(get w [:prop-page-break-before :alt 7] 100)
            (gen/return "verso ")]])
        g (assoc g :prop-page-break-before gen-prop-page-break-before)

        gen-nonprop-single-animation-iteration-count
        (igen/freq :nonprop-single-animation-iteration-count [
          [(get w [:nonprop-single-animation-iteration-count :alt 0] 100)
            (gen/return "infinite ")]
          [(get w [:nonprop-single-animation-iteration-count :alt 1] 100)
            (:nonprop-number g)]])
        g (assoc g :nonprop-single-animation-iteration-count gen-nonprop-single-animation-iteration-count)

        gen-nonprop-single-animation
        (igen/vector+
          (igen/freq :nonprop-single-animation [
            [(get w [:nonprop-single-animation :plus 0 :alt 0] 100)
              (:nonprop-time g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 1] 100)
              (:nonprop-timing-function g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 2] 100)
              (:nonprop-time g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 3] 100)
              (:nonprop-single-animation-iteration-count g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 4] 100)
              (:nonprop-single-animation-direction g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 5] 100)
              (:nonprop-single-animation-fill-mode g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 6] 100)
              (:nonprop-single-animation-play-state g)]
            [(get w [:nonprop-single-animation :plus 0 :alt 7] 100)
              (igen/freq :nonprop-single-animation [
                [(get w [:nonprop-single-animation :plus 0 :alt 7 :alt 0] 100)
                  (gen/return "none ")]
                [(get w [:nonprop-single-animation :plus 0 :alt 7 :alt 1] 100)
                  (:nonprop-keyframes-name g)]])]]))
        g (assoc g :nonprop-single-animation gen-nonprop-single-animation)

        gen-prop-grid-column-start
        (igen/freq :prop-grid-column-start [
          [(get w [:prop-grid-column-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-column-start :alt 1] 100)
            (:nonprop-grid-line g)]])
        g (assoc g :prop-grid-column-start gen-prop-grid-column-start)

        gen-prop-border-color
        (igen/freq :prop-border-color [
          [(get w [:prop-border-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-color :alt 1] 100)
            (igen/freq :prop-border-color [
              [(get w [:prop-border-color :alt 1 :alt 0] 100)
                (:nonprop-color g)]
              [(get w [:prop-border-color :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g))]
              [(get w [:prop-border-color :alt 1 :alt 2] 100)
                (gen/tuple
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g))]
              [(get w [:prop-border-color :alt 1 :alt 3] 100)
                (gen/tuple
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g)
                  (gen/return " ")
                  (:nonprop-color g))]])]])
        g (assoc g :prop-border-color gen-prop-border-color)

        gen-nonprop-bg-layer
        (igen/vector+
          (igen/freq :nonprop-bg-layer [
            [(get w [:nonprop-bg-layer :plus 0 :alt 0] 100)
              (:nonprop-bg-image g)]
            [(get w [:nonprop-bg-layer :plus 0 :alt 1] 100)
              (gen/tuple
                (:nonprop-bg-position g)
                (igen/freq :nonprop-bg-layer [
                  [(get w [:nonprop-bg-layer :plus 0 :alt 1 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-bg-layer :plus 0 :alt 1 :cat 1 :opt 0] 100)
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-bg-size g))]]))]
            [(get w [:nonprop-bg-layer :plus 0 :alt 2] 100)
              (:nonprop-repeat-style g)]
            [(get w [:nonprop-bg-layer :plus 0 :alt 3] 100)
              (:nonprop-attachment g)]
            [(get w [:nonprop-bg-layer :plus 0 :alt 4] 100)
              (:nonprop-box g)]
            [(get w [:nonprop-bg-layer :plus 0 :alt 5] 100)
              (:nonprop-box g)]]))
        g (assoc g :nonprop-bg-layer gen-nonprop-bg-layer)

        gen-prop-font-variant-position
        (igen/freq :prop-font-variant-position [
          [(get w [:prop-font-variant-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-position :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-position :alt 2] 100)
            (gen/return "sub ")]
          [(get w [:prop-font-variant-position :alt 3] 100)
            (gen/return "super ")]])
        g (assoc g :prop-font-variant-position gen-prop-font-variant-position)

        gen-prop-grid-column-end
        (igen/freq :prop-grid-column-end [
          [(get w [:prop-grid-column-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-column-end :alt 1] 100)
            (:nonprop-grid-line g)]])
        g (assoc g :prop-grid-column-end gen-prop-grid-column-end)

        gen-prop-text-emphasis-color
        (igen/freq :prop-text-emphasis-color [
          [(get w [:prop-text-emphasis-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-emphasis-color :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :prop-text-emphasis-color gen-prop-text-emphasis-color)

        gen-prop-background-size
        (igen/freq :prop-background-size [
          [(get w [:prop-background-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-size :alt 1] 100)
            (gen/tuple
              (:nonprop-bg-size g)
              (igen/freq :prop-background-size [
                [(get w [:prop-background-size :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-size :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-bg-size g)))]]))]])
        g (assoc g :prop-background-size gen-prop-background-size)]
    g))

(defn- css3-generators-part-9 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-font-variant-east-asian
        (igen/freq :prop-font-variant-east-asian [
          [(get w [:prop-font-variant-east-asian :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant-east-asian :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant-east-asian :alt 2] 100)
            (igen/vector+
              (igen/freq :prop-font-variant-east-asian [
                [(get w [:prop-font-variant-east-asian :alt 2 :plus 0 :alt 0] 100)
                  (:nonprop-east-asian-variant-values g)]
                [(get w [:prop-font-variant-east-asian :alt 2 :plus 0 :alt 1] 100)
                  (:nonprop-east-asian-width-values g)]
                [(get w [:prop-font-variant-east-asian :alt 2 :plus 0 :alt 2] 100)
                  (gen/return "ruby ")]]))]])
        g (assoc g :prop-font-variant-east-asian gen-prop-font-variant-east-asian)

        gen-prop-perspective-origin
        (igen/freq :prop-perspective-origin [
          [(get w [:prop-perspective-origin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-perspective-origin :alt 1] 100)
            (:nonprop-position g)]])
        g (assoc g :prop-perspective-origin gen-prop-perspective-origin)

        gen-prop-animation
        (igen/freq :prop-animation [
          [(get w [:prop-animation :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation :alt 1] 100)
            (gen/tuple
              (:nonprop-single-animation g)
              (igen/freq :prop-animation [
                [(get w [:prop-animation :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-animation g)))]]))]])
        g (assoc g :prop-animation gen-prop-animation)

        gen-prop-margin-block-start
        (igen/freq :prop-margin-block-start [
          [(get w [:prop-margin-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-block-start :alt 1] 100)
            (:prop-margin-left g)]])
        g (assoc g :prop-margin-block-start gen-prop-margin-block-start)

        gen-prop-translate
        (igen/freq :prop-translate [
          [(get w [:prop-translate :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-translate :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-translate :alt 2] 100)
            (gen/tuple
              (:nonprop-length-percentage g)
              (igen/freq :prop-translate [
                [(get w [:prop-translate :alt 2 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-translate :alt 2 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (:nonprop-length-percentage g)
                    (igen/freq :prop-translate [
                      [(get w [:prop-translate :alt 2 :cat 1 :opt 0 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:prop-translate :alt 2 :cat 1 :opt 0 :cat 1 :opt 0] 100)
                        (:nonprop-length g)]]))]]))]])
        g (assoc g :prop-translate gen-prop-translate)

        gen-prop-transform-style
        (igen/freq :prop-transform-style [
          [(get w [:prop-transform-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-transform-style :alt 1] 100)
            (gen/return "flat ")]
          [(get w [:prop-transform-style :alt 2] 100)
            (gen/return "preserve-3d ")]])
        g (assoc g :prop-transform-style gen-prop-transform-style)

        gen-nonprop-content-replacement
        (:nonprop-image g)
        g (assoc g :nonprop-content-replacement gen-nonprop-content-replacement)

        gen-prop-animation-direction
        (igen/freq :prop-animation-direction [
          [(get w [:prop-animation-direction :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-direction :alt 1] 100)
            (gen/tuple
              (:nonprop-single-animation-direction g)
              (igen/freq :prop-animation-direction [
                [(get w [:prop-animation-direction :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-direction :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-animation-direction g)))]]))]])
        g (assoc g :prop-animation-direction gen-prop-animation-direction)

        gen-prop-border-image-outset
        (igen/freq :prop-border-image-outset [
          [(get w [:prop-border-image-outset :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image-outset :alt 1] 100)
            (igen/freq :prop-border-image-outset [
              [(get w [:prop-border-image-outset :alt 1 :alt 0] 100)
                (igen/freq :prop-border-image-outset [
                  [(get w [:prop-border-image-outset :alt 1 :alt 0 :alt 0] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-border-image-outset :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-number g)]])]
              [(get w [:prop-border-image-outset :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]]))]
              [(get w [:prop-border-image-outset :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-number g)]]))]
              [(get w [:prop-border-image-outset :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-number g)]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-outset [
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-border-image-outset :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-number g)]]))]])]])
        g (assoc g :prop-border-image-outset gen-prop-border-image-outset)

        gen-prop-margin-inline-start
        (igen/freq :prop-margin-inline-start [
          [(get w [:prop-margin-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-inline-start :alt 1] 100)
            (:prop-margin-left g)]])
        g (assoc g :prop-margin-inline-start gen-prop-margin-inline-start)

        gen-prop-scroll-snap-type
        (igen/freq :prop-scroll-snap-type [
          [(get w [:prop-scroll-snap-type :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-snap-type :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-scroll-snap-type :alt 2] 100)
            (gen/tuple
              (igen/freq :prop-scroll-snap-type [
                [(get w [:prop-scroll-snap-type :alt 2 :cat 0 :alt 0] 100)
                  (gen/return "x ")]
                [(get w [:prop-scroll-snap-type :alt 2 :cat 0 :alt 1] 100)
                  (gen/return "y ")]
                [(get w [:prop-scroll-snap-type :alt 2 :cat 0 :alt 2] 100)
                  (gen/return "block ")]
                [(get w [:prop-scroll-snap-type :alt 2 :cat 0 :alt 3] 100)
                  (gen/return "inline ")]
                [(get w [:prop-scroll-snap-type :alt 2 :cat 0 :alt 4] 100)
                  (gen/return "both ")]])
              (igen/freq :prop-scroll-snap-type [
                [(get w [:prop-scroll-snap-type :alt 2 :cat 1 :alt 0] 100)
                  (gen/return "mandatory ")]
                [(get w [:prop-scroll-snap-type :alt 2 :cat 1 :alt 1] 100)
                  (gen/return "proximity ")]]))]])
        g (assoc g :prop-scroll-snap-type gen-prop-scroll-snap-type)

        gen-prop-scroll-padding-top
        (igen/freq :prop-scroll-padding-top [
          [(get w [:prop-scroll-padding-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-top :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-top :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-top :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-top gen-prop-scroll-padding-top)

        gen-prop-max-height
        (igen/freq :prop-max-height [
          [(get w [:prop-max-height :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-max-height :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-max-height :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-max-height :alt 3] 100)
            (gen/return "none ")]
          [(get w [:prop-max-height :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-max-height :alt 5] 100)
            (gen/return "min-content ")]
          [(get w [:prop-max-height :alt 6] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-max-height :alt 7] 100)
            (gen/return "fill-available ")]])
        g (assoc g :prop-max-height gen-prop-max-height)

        gen-prop-border-block-style
        (igen/freq :prop-border-block-style [
          [(get w [:prop-border-block-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-block-style gen-prop-border-block-style)

        gen-prop-border-image-slice
        (igen/freq :prop-border-image-slice [
          [(get w [:prop-border-image-slice :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image-slice :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-border-image-slice [
                [(get w [:prop-border-image-slice :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-number-percentage g)]
                [(get w [:prop-border-image-slice :alt 1 :cat 0 :alt 1] 100)
                  (gen/tuple
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g))]
                [(get w [:prop-border-image-slice :alt 1 :cat 0 :alt 2] 100)
                  (gen/tuple
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g))]
                [(get w [:prop-border-image-slice :alt 1 :cat 0 :alt 3] 100)
                  (gen/tuple
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g)
                    (gen/return " ")
                    (:nonprop-number-percentage g))]])
              (igen/freq :prop-border-image-slice [
                [(get w [:prop-border-image-slice :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-border-image-slice :alt 1 :cat 1 :opt 0] 100)
                  (gen/return "fill ")]]))]])
        g (assoc g :prop-border-image-slice gen-prop-border-image-slice)

        gen-prop-border-image-repeat
        (igen/freq :prop-border-image-repeat [
          [(get w [:prop-border-image-repeat :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image-repeat :alt 1] 100)
            (igen/freq :prop-border-image-repeat [
              [(get w [:prop-border-image-repeat :alt 1 :alt 0] 100)
                (igen/freq :prop-border-image-repeat [
                  [(get w [:prop-border-image-repeat :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "stretch ")]
                  [(get w [:prop-border-image-repeat :alt 1 :alt 0 :alt 1] 100)
                    (gen/return "repeat ")]
                  [(get w [:prop-border-image-repeat :alt 1 :alt 0 :alt 2] 100)
                    (gen/return "round ")]
                  [(get w [:prop-border-image-repeat :alt 1 :alt 0 :alt 3] 100)
                    (gen/return "space ")]])]
              [(get w [:prop-border-image-repeat :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-repeat [
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "stretch ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "repeat ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "round ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 0 :alt 3] 100)
                      (gen/return "space ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-repeat [
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "stretch ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "repeat ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "round ")]
                    [(get w [:prop-border-image-repeat :alt 1 :alt 1 :cat 2 :alt 3] 100)
                      (gen/return "space ")]]))]])]])
        g (assoc g :prop-border-image-repeat gen-prop-border-image-repeat)

        gen-prop-border-image-width
        (igen/freq :prop-border-image-width [
          [(get w [:prop-border-image-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image-width :alt 1] 100)
            (igen/freq :prop-border-image-width [
              [(get w [:prop-border-image-width :alt 1 :alt 0] 100)
                (igen/freq :prop-border-image-width [
                  [(get w [:prop-border-image-width :alt 1 :alt 0 :alt 0] 100)
                    (:nonprop-length-percentage g)]
                  [(get w [:prop-border-image-width :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-number g)]
                  [(get w [:prop-border-image-width :alt 1 :alt 0 :alt 2] 100)
                    (gen/return "auto ")]])]
              [(get w [:prop-border-image-width :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]]))]
              [(get w [:prop-border-image-width :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 2 :cat 4 :alt 2] 100)
                      (gen/return "auto ")]]))]
              [(get w [:prop-border-image-width :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 4 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-border-image-width [
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (:nonprop-length-percentage g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-number g)]
                    [(get w [:prop-border-image-width :alt 1 :alt 3 :cat 6 :alt 2] 100)
                      (gen/return "auto ")]]))]])]])
        g (assoc g :prop-border-image-width gen-prop-border-image-width)

        gen-prop-border-image
        (igen/freq :prop-border-image [
          [(get w [:prop-border-image :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-image :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-image [
                [(get w [:prop-border-image :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-image-source g)]
                [(get w [:prop-border-image :alt 1 :plus 0 :alt 1] 100)
                  (gen/tuple
                    (:prop-border-image-slice g)
                    (igen/freq :prop-border-image [
                      [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt 0] 100)
                        (igen/freq :prop-border-image [
                          [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt 0 :alt 0] 100)
                            (gen/tuple
                              (gen/return "/ ")
                              (:prop-border-image-width g))]
                          [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt 0 :alt 1] 100)
                            (gen/tuple
                              (gen/return "/ ")
                              (igen/freq :prop-border-image [
                                [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt 0 :alt 1 :cat 1 :opt nil] 100)
                                  (gen/return "")]
                                [(get w [:prop-border-image :alt 1 :plus 0 :alt 1 :cat 1 :opt 0 :alt 1 :cat 1 :opt 0] 100)
                                  (:prop-border-image-width g)]])
                              (gen/return "/ ")
                              (:prop-border-image-outset g))]])]]))]
                [(get w [:prop-border-image :alt 1 :plus 0 :alt 2] 100)
                  (:prop-border-image-repeat g)]]))]])
        g (assoc g :prop-border-image gen-prop-border-image)

        gen-prop-scroll-margin-right
        (igen/freq :prop-scroll-margin-right [
          [(get w [:prop-scroll-margin-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-right :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-right :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-right gen-prop-scroll-margin-right)

        gen-prop-margin
        (igen/freq :prop-margin [
          [(get w [:prop-margin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin :alt 1] 100)
            (igen/freq :prop-margin [
              [(get w [:prop-margin :alt 1 :alt 0] 100)
                (igen/freq :prop-margin [
                  [(get w [:prop-margin :alt 1 :alt 0 :alt 0] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-margin :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-percentage g)]
                  [(get w [:prop-margin :alt 1 :alt 0 :alt 2] 100)
                    (gen/return "auto ")]])]
              [(get w [:prop-margin :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]]))]
              [(get w [:prop-margin :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 2 :cat 4 :alt 2] 100)
                      (gen/return "auto ")]]))]
              [(get w [:prop-margin :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 0 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 2 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 4 :alt 2] 100)
                      (gen/return "auto ")]])
                  (gen/return " ")
                  (igen/freq :prop-margin [
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-percentage g)]
                    [(get w [:prop-margin :alt 1 :alt 3 :cat 6 :alt 2] 100)
                      (gen/return "auto ")]]))]])]])
        g (assoc g :prop-margin gen-prop-margin)

        gen-nonprop-compositing-operator
        (igen/freq :nonprop-compositing-operator [
          [(get w [:nonprop-compositing-operator :alt 0] 100)
            (gen/return "add ")]
          [(get w [:nonprop-compositing-operator :alt 1] 100)
            (gen/return "subtract ")]
          [(get w [:nonprop-compositing-operator :alt 2] 100)
            (gen/return "intersect ")]
          [(get w [:nonprop-compositing-operator :alt 3] 100)
            (gen/return "exclude ")]])
        g (assoc g :nonprop-compositing-operator gen-nonprop-compositing-operator)

        gen-nonprop-mask-layer
        (igen/vector+
          (igen/freq :nonprop-mask-layer [
            [(get w [:nonprop-mask-layer :plus 0 :alt 0] 100)
              (:nonprop-mask-reference g)]
            [(get w [:nonprop-mask-layer :plus 0 :alt 1] 100)
              (gen/tuple
                (:nonprop-position g)
                (igen/freq :nonprop-mask-layer [
                  [(get w [:nonprop-mask-layer :plus 0 :alt 1 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-mask-layer :plus 0 :alt 1 :cat 1 :opt 0] 100)
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-bg-size g))]]))]
            [(get w [:nonprop-mask-layer :plus 0 :alt 2] 100)
              (:nonprop-repeat-style g)]
            [(get w [:nonprop-mask-layer :plus 0 :alt 3] 100)
              (:nonprop-geometry-box g)]
            [(get w [:nonprop-mask-layer :plus 0 :alt 4] 100)
              (igen/freq :nonprop-mask-layer [
                [(get w [:nonprop-mask-layer :plus 0 :alt 4 :alt 0] 100)
                  (:nonprop-geometry-box g)]
                [(get w [:nonprop-mask-layer :plus 0 :alt 4 :alt 1] 100)
                  (gen/return "no-clip ")]])]
            [(get w [:nonprop-mask-layer :plus 0 :alt 5] 100)
              (:nonprop-compositing-operator g)]
            [(get w [:nonprop-mask-layer :plus 0 :alt 6] 100)
              (:nonprop-masking-mode g)]]))
        g (assoc g :nonprop-mask-layer gen-nonprop-mask-layer)

        gen-prop-mask-repeat
        (igen/freq :prop-mask-repeat [
          [(get w [:prop-mask-repeat :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-repeat :alt 1] 100)
            (gen/tuple
              (:nonprop-repeat-style g)
              (igen/freq :prop-mask-repeat [
                [(get w [:prop-mask-repeat :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-repeat :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-repeat-style g)))]]))]])
        g (assoc g :prop-mask-repeat gen-prop-mask-repeat)

        gen-prop-overflow-wrap
        (igen/freq :prop-overflow-wrap [
          [(get w [:prop-overflow-wrap :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-overflow-wrap :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-overflow-wrap :alt 2] 100)
            (gen/return "break-word ")]
          [(get w [:prop-overflow-wrap :alt 3] 100)
            (gen/return "anywhere ")]])
        g (assoc g :prop-overflow-wrap gen-prop-overflow-wrap)

        gen-prop-border-inline-end-color
        (igen/freq :prop-border-inline-end-color [
          [(get w [:prop-border-inline-end-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline-end-color :alt 1] 100)
            (:prop-border-top-color g)]])
        g (assoc g :prop-border-inline-end-color gen-prop-border-inline-end-color)

        gen-prop-font-kerning
        (igen/freq :prop-font-kerning [
          [(get w [:prop-font-kerning :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-kerning :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-font-kerning :alt 2] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-kerning :alt 3] 100)
            (gen/return "none ")]])
        g (assoc g :prop-font-kerning gen-prop-font-kerning)

        gen-prop-text-overflow
        (igen/freq :prop-text-overflow [
          [(get w [:prop-text-overflow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-overflow :alt 1] 100)
            (igen/freq :prop-text-overflow [
              [(get w [:prop-text-overflow :alt 1 :alt 0] 100)
                (igen/freq :prop-text-overflow [
                  [(get w [:prop-text-overflow :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "clip ")]
                  [(get w [:prop-text-overflow :alt 1 :alt 0 :alt 1] 100)
                    (gen/return "ellipsis ")]
                  [(get w [:prop-text-overflow :alt 1 :alt 0 :alt 2] 100)
                    (:nonprop-string g)]])]
              [(get w [:prop-text-overflow :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-text-overflow [
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "clip ")]
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "ellipsis ")]
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-string g)]])
                  (gen/return " ")
                  (igen/freq :prop-text-overflow [
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "clip ")]
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "ellipsis ")]
                    [(get w [:prop-text-overflow :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (:nonprop-string g)]]))]])]])
        g (assoc g :prop-text-overflow gen-prop-text-overflow)

        gen-prop-order
        (igen/freq :prop-order [
          [(get w [:prop-order :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-order :alt 1] 100)
            (:nonprop-integer g)]])
        g (assoc g :prop-order gen-prop-order)

        gen-prop-object-position
        (igen/freq :prop-object-position [
          [(get w [:prop-object-position :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-object-position :alt 1] 100)
            (:nonprop-position g)]])
        g (assoc g :prop-object-position gen-prop-object-position)

        gen-prop-writing-mode
        (igen/freq :prop-writing-mode [
          [(get w [:prop-writing-mode :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-writing-mode :alt 1] 100)
            (gen/return "horizontal-tb ")]
          [(get w [:prop-writing-mode :alt 2] 100)
            (gen/return "vertical-rl ")]
          [(get w [:prop-writing-mode :alt 3] 100)
            (gen/return "vertical-lr ")]
          [(get w [:prop-writing-mode :alt 4] 100)
            (gen/return "sideways-rl ")]
          [(get w [:prop-writing-mode :alt 5] 100)
            (gen/return "sideways-lr ")]])
        g (assoc g :prop-writing-mode gen-prop-writing-mode)

        gen-prop-overflow-y
        (igen/freq :prop-overflow-y [
          [(get w [:prop-overflow-y :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-overflow-y :alt 1] 100)
            (gen/return "visible ")]
          [(get w [:prop-overflow-y :alt 2] 100)
            (gen/return "hidden ")]
          [(get w [:prop-overflow-y :alt 3] 100)
            (gen/return "clip ")]
          [(get w [:prop-overflow-y :alt 4] 100)
            (gen/return "scroll ")]
          [(get w [:prop-overflow-y :alt 5] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-overflow-y gen-prop-overflow-y)

        gen-prop-line-height
        (igen/freq :prop-line-height [
          [(get w [:prop-line-height :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-line-height :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-line-height :alt 2] 100)
            (:nonprop-number g)]
          [(get w [:prop-line-height :alt 3] 100)
            (:nonprop-length g)]
          [(get w [:prop-line-height :alt 4] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-line-height gen-prop-line-height)

        gen-prop-inset-block
        (igen/freq :prop-inset-block [
          [(get w [:prop-inset-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-block :alt 1] 100)
            (igen/freq :prop-inset-block [
              [(get w [:prop-inset-block :alt 1 :alt 0] 100)
                (:prop-top g)]
              [(get w [:prop-inset-block :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-top g)
                  (gen/return " ")
                  (:prop-top g))]])]])
        g (assoc g :prop-inset-block gen-prop-inset-block)

        gen-prop-border-block-end-style
        (igen/freq :prop-border-block-end-style [
          [(get w [:prop-border-block-end-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-end-style :alt 1] 100)
            (:prop-border-top-style g)]])
        g (assoc g :prop-border-block-end-style gen-prop-border-block-end-style)

        gen-prop-border-bottom-width
        (igen/freq :prop-border-bottom-width [
          [(get w [:prop-border-bottom-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom-width :alt 1] 100)
            (:nonprop-line-width g)]])
        g (assoc g :prop-border-bottom-width gen-prop-border-bottom-width)

        gen-prop-border-block-end-color
        (igen/freq :prop-border-block-end-color [
          [(get w [:prop-border-block-end-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-end-color :alt 1] 100)
            (:prop-border-top-color g)]])
        g (assoc g :prop-border-block-end-color gen-prop-border-block-end-color)

        gen-prop-border-bottom
        (igen/freq :prop-border-bottom [
          [(get w [:prop-border-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-bottom [
                [(get w [:prop-border-bottom :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-line-width g)]
                [(get w [:prop-border-bottom :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-line-style g)]
                [(get w [:prop-border-bottom :alt 1 :plus 0 :alt 2] 100)
                  (:nonprop-color g)]]))]])
        g (assoc g :prop-border-bottom gen-prop-border-bottom)

        gen-prop-page-break-inside
        (igen/freq :prop-page-break-inside [
          [(get w [:prop-page-break-inside :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-page-break-inside :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-page-break-inside :alt 2] 100)
            (gen/return "avoid ")]])
        g (assoc g :prop-page-break-inside gen-prop-page-break-inside)

        gen-prop-text-indent
        (igen/freq :prop-text-indent [
          [(get w [:prop-text-indent :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-indent :alt 1] 100)
            (gen/tuple
              (:nonprop-length-percentage g)
              (igen/freq :prop-text-indent [
                [(get w [:prop-text-indent :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-text-indent :alt 1 :cat 1 :opt 0] 100)
                  (gen/return "hanging ")]])
              (igen/freq :prop-text-indent [
                [(get w [:prop-text-indent :alt 1 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-text-indent :alt 1 :cat 2 :opt 0] 100)
                  (gen/return "each-line ")]]))]])
        g (assoc g :prop-text-indent gen-prop-text-indent)

        gen-prop-min-inline-size
        (igen/freq :prop-min-inline-size [
          [(get w [:prop-min-inline-size :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-min-inline-size :alt 1] 100)
            (:prop-min-width g)]])
        g (assoc g :prop-min-inline-size gen-prop-min-inline-size)

        gen-prop-padding-inline-start
        (igen/freq :prop-padding-inline-start [
          [(get w [:prop-padding-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-inline-start :alt 1] 100)
            (:prop-padding-left g)]])
        g (assoc g :prop-padding-inline-start gen-prop-padding-inline-start)

        gen-prop-font-style
        (igen/freq :prop-font-style [
          [(get w [:prop-font-style :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-style :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-style :alt 2] 100)
            (gen/return "italic ")]
          [(get w [:prop-font-style :alt 3] 100)
            (gen/tuple
              (gen/return "oblique ")
              (igen/freq :prop-font-style [
                [(get w [:prop-font-style :alt 3 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-font-style :alt 3 :cat 1 :opt 0] 100)
                  (:nonprop-angle g)]]))]])
        g (assoc g :prop-font-style gen-prop-font-style)

        gen-prop-padding
        (igen/freq :prop-padding [
          [(get w [:prop-padding :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding :alt 1] 100)
            (igen/freq :prop-padding [
              [(get w [:prop-padding :alt 1 :alt 0] 100)
                (igen/freq :prop-padding [
                  [(get w [:prop-padding :alt 1 :alt 0 :alt 0] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-padding :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-percentage g)]])]
              [(get w [:prop-padding :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]]))]
              [(get w [:prop-padding :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-percentage g)]]))]
              [(get w [:prop-padding :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-padding [
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-padding :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-percentage g)]]))]])]])
        g (assoc g :prop-padding gen-prop-padding)

        gen-prop-padding-bottom
        (igen/freq :prop-padding-bottom [
          [(get w [:prop-padding-bottom :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-bottom :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-padding-bottom :alt 2] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-padding-bottom gen-prop-padding-bottom)

        gen-prop-cursor
        (igen/freq :prop-cursor [
          [(get w [:prop-cursor :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-cursor :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-cursor [
                [(get w [:prop-cursor :alt 1 :cat 0 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-cursor :alt 1 :cat 0 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (:nonprop-url g)
                      (igen/freq :prop-cursor [
                        [(get w [:prop-cursor :alt 1 :cat 0 :star 0 :cat 1 :opt nil] 100)
                          (gen/return "")]
                        [(get w [:prop-cursor :alt 1 :cat 0 :star 0 :cat 1 :opt 0] 100)
                          (gen/tuple
                            (:nonprop-x g)
                            (:nonprop-y g))]])
                      (gen/return ", ")))]])
              (igen/freq :prop-cursor [
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 0] 100)
                  (gen/return "auto ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 1] 100)
                  (gen/return "default ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 2] 100)
                  (gen/return "none ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 3] 100)
                  (gen/return "context-menu ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 4] 100)
                  (gen/return "help ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 5] 100)
                  (gen/return "pointer ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 6] 100)
                  (gen/return "progress ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 7] 100)
                  (gen/return "wait ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 8] 100)
                  (gen/return "cell ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 9] 100)
                  (gen/return "crosshair ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 10] 100)
                  (gen/return "text ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 11] 100)
                  (gen/return "vertical-text ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 12] 100)
                  (gen/return "alias ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 13] 100)
                  (gen/return "copy ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 14] 100)
                  (gen/return "move ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 15] 100)
                  (gen/return "no-drop ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 16] 100)
                  (gen/return "not-allowed ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 17] 100)
                  (gen/return "e-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 18] 100)
                  (gen/return "n-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 19] 100)
                  (gen/return "ne-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 20] 100)
                  (gen/return "nw-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 21] 100)
                  (gen/return "s-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 22] 100)
                  (gen/return "se-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 23] 100)
                  (gen/return "sw-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 24] 100)
                  (gen/return "w-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 25] 100)
                  (gen/return "ew-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 26] 100)
                  (gen/return "ns-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 27] 100)
                  (gen/return "nesw-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 28] 100)
                  (gen/return "nwse-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 29] 100)
                  (gen/return "col-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 30] 100)
                  (gen/return "row-resize ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 31] 100)
                  (gen/return "all-scroll ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 32] 100)
                  (gen/return "zoom-in ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 33] 100)
                  (gen/return "zoom-out ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 34] 100)
                  (gen/return "grab ")]
                [(get w [:prop-cursor :alt 1 :cat 1 :alt 35] 100)
                  (gen/return "grabbing ")]]))]])
        g (assoc g :prop-cursor gen-prop-cursor)

        gen-prop-scroll-padding
        (igen/freq :prop-scroll-padding [
          [(get w [:prop-scroll-padding :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding :alt 1] 100)
            (igen/freq :prop-scroll-padding [
              [(get w [:prop-scroll-padding :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-padding [
                  [(get w [:prop-scroll-padding :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-padding :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]
                  [(get w [:prop-scroll-padding :alt 1 :alt 0 :alt 2] 100)
                    (:nonprop-percentage g)]])]
              [(get w [:prop-scroll-padding :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (:nonprop-percentage g)]]))]
              [(get w [:prop-scroll-padding :alt 1 :alt 2] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 0 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 2 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 4 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 4 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 2 :cat 4 :alt 2] 100)
                      (:nonprop-percentage g)]]))]
              [(get w [:prop-scroll-padding :alt 1 :alt 3] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 0 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 2 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 4 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 4 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 4 :alt 2] 100)
                      (:nonprop-percentage g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-padding [
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 6 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 6 :alt 1] 100)
                      (:nonprop-length g)]
                    [(get w [:prop-scroll-padding :alt 1 :alt 3 :cat 6 :alt 2] 100)
                      (:nonprop-percentage g)]]))]])]])
        g (assoc g :prop-scroll-padding gen-prop-scroll-padding)

        gen-prop-animation-iteration-count
        (igen/freq :prop-animation-iteration-count [
          [(get w [:prop-animation-iteration-count :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-animation-iteration-count :alt 1] 100)
            (gen/tuple
              (:nonprop-single-animation-iteration-count g)
              (igen/freq :prop-animation-iteration-count [
                [(get w [:prop-animation-iteration-count :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-animation-iteration-count :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-single-animation-iteration-count g)))]]))]])
        g (assoc g :prop-animation-iteration-count gen-prop-animation-iteration-count)

        gen-prop-margin-inline
        (igen/freq :prop-margin-inline [
          [(get w [:prop-margin-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-inline :alt 1] 100)
            (igen/freq :prop-margin-inline [
              [(get w [:prop-margin-inline :alt 1 :alt 0] 100)
                (:prop-margin-left g)]
              [(get w [:prop-margin-inline :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-margin-left g)
                  (gen/return " ")
                  (:prop-margin-left g))]])]])
        g (assoc g :prop-margin-inline gen-prop-margin-inline)

        gen-prop-border-block-width
        (igen/freq :prop-border-block-width [
          [(get w [:prop-border-block-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-block-width gen-prop-border-block-width)

        gen-prop-font-feature-settings
        (igen/freq :prop-font-feature-settings [
          [(get w [:prop-font-feature-settings :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-feature-settings :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-feature-settings :alt 2] 100)
            (gen/tuple
              (:nonprop-feature-tag-value g)
              (igen/freq :prop-font-feature-settings [
                [(get w [:prop-font-feature-settings :alt 2 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-font-feature-settings :alt 2 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-feature-tag-value g)))]]))]])
        g (assoc g :prop-font-feature-settings gen-prop-font-feature-settings)]
    g))

(defn- css3-generators-part-10 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-perspective
        (igen/freq :prop-perspective [
          [(get w [:prop-perspective :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-perspective :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-perspective :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-perspective gen-prop-perspective)

        gen-prop-border-top-right-radius
        (igen/freq :prop-border-top-right-radius [
          [(get w [:prop-border-top-right-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-top-right-radius :alt 1] 100)
            (igen/freq :prop-border-top-right-radius [
              [(get w [:prop-border-top-right-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-top-right-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-top-right-radius gen-prop-border-top-right-radius)

        gen-nonprop-final-bg-layer
        (igen/vector+
          (igen/freq :nonprop-final-bg-layer [
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 0] 100)
              (:prop-background-color g)]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 1] 100)
              (:nonprop-bg-image g)]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 2] 100)
              (gen/tuple
                (:nonprop-bg-position g)
                (igen/freq :nonprop-final-bg-layer [
                  [(get w [:nonprop-final-bg-layer :plus 0 :alt 2 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-final-bg-layer :plus 0 :alt 2 :cat 1 :opt 0] 100)
                    (gen/tuple
                      (gen/return "/ ")
                      (:nonprop-bg-size g))]]))]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 3] 100)
              (:nonprop-repeat-style g)]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 4] 100)
              (:nonprop-attachment g)]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 5] 100)
              (:nonprop-box g)]
            [(get w [:nonprop-final-bg-layer :plus 0 :alt 6] 100)
              (:nonprop-box g)]]))
        g (assoc g :nonprop-final-bg-layer gen-nonprop-final-bg-layer)

        gen-prop-font-stretch
        (igen/freq :prop-font-stretch [
          [(get w [:prop-font-stretch :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-stretch :alt 1] 100)
            (:nonprop-font-stretch-absolute g)]])
        g (assoc g :prop-font-stretch gen-prop-font-stretch)

        gen-prop-margin-right
        (igen/freq :prop-margin-right [
          [(get w [:prop-margin-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-margin-right :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-margin-right :alt 2] 100)
            (:nonprop-percentage g)]
          [(get w [:prop-margin-right :alt 3] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-margin-right gen-prop-margin-right)

        gen-prop-outline
        (igen/freq :prop-outline [
          [(get w [:prop-outline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-outline :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-outline [
                [(get w [:prop-outline :alt 1 :plus 0 :alt 0] 100)
                  (:prop-outline-color g)]
                [(get w [:prop-outline :alt 1 :plus 0 :alt 1] 100)
                  (:prop-outline-style g)]
                [(get w [:prop-outline :alt 1 :plus 0 :alt 2] 100)
                  (:prop-outline-width g)]]))]])
        g (assoc g :prop-outline gen-prop-outline)

        gen-prop-text-rendering
        (igen/freq :prop-text-rendering [
          [(get w [:prop-text-rendering :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-rendering :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-text-rendering :alt 2] 100)
            (gen/return "optimizeSpeed ")]
          [(get w [:prop-text-rendering :alt 3] 100)
            (gen/return "optimizeLegibility ")]
          [(get w [:prop-text-rendering :alt 4] 100)
            (gen/return "geometricPrecision ")]])
        g (assoc g :prop-text-rendering gen-prop-text-rendering)

        gen-prop-border-block-start-color
        (igen/freq :prop-border-block-start-color [
          [(get w [:prop-border-block-start-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-start-color :alt 1] 100)
            (:prop-border-top-color g)]])
        g (assoc g :prop-border-block-start-color gen-prop-border-block-start-color)

        gen-prop-mask
        (igen/freq :prop-mask [
          [(get w [:prop-mask :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask :alt 1] 100)
            (gen/tuple
              (:nonprop-mask-layer g)
              (igen/freq :prop-mask [
                [(get w [:prop-mask :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-mask-layer g)))]]))]])
        g (assoc g :prop-mask gen-prop-mask)

        gen-prop-scroll-padding-inline-start
        (igen/freq :prop-scroll-padding-inline-start [
          [(get w [:prop-scroll-padding-inline-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-inline-start :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-inline-start :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-inline-start :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-inline-start gen-prop-scroll-padding-inline-start)

        gen-prop-mix-blend-mode
        (igen/freq :prop-mix-blend-mode [
          [(get w [:prop-mix-blend-mode :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mix-blend-mode :alt 1] 100)
            (:nonprop-blend-mode g)]])
        g (assoc g :prop-mix-blend-mode gen-prop-mix-blend-mode)

        gen-prop-background-origin
        (igen/freq :prop-background-origin [
          [(get w [:prop-background-origin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background-origin :alt 1] 100)
            (gen/tuple
              (:nonprop-box g)
              (igen/freq :prop-background-origin [
                [(get w [:prop-background-origin :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background-origin :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-box g)))]]))]])
        g (assoc g :prop-background-origin gen-prop-background-origin)

        gen-prop-border-block-start-width
        (igen/freq :prop-border-block-start-width [
          [(get w [:prop-border-block-start-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-start-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-block-start-width gen-prop-border-block-start-width)

        gen-prop-scroll-margin-block
        (igen/freq :prop-scroll-margin-block [
          [(get w [:prop-scroll-margin-block :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-block :alt 1] 100)
            (igen/freq :prop-scroll-margin-block [
              [(get w [:prop-scroll-margin-block :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-margin-block [
                  [(get w [:prop-scroll-margin-block :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "auto ")]
                  [(get w [:prop-scroll-margin-block :alt 1 :alt 0 :alt 1] 100)
                    (:nonprop-length g)]])]
              [(get w [:prop-scroll-margin-block :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-margin-block [
                    [(get w [:prop-scroll-margin-block :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin-block :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-length g)]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-margin-block [
                    [(get w [:prop-scroll-margin-block :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "auto ")]
                    [(get w [:prop-scroll-margin-block :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (:nonprop-length g)]]))]])]])
        g (assoc g :prop-scroll-margin-block gen-prop-scroll-margin-block)

        gen-nonprop-display-box
        (igen/freq :nonprop-display-box [
          [(get w [:nonprop-display-box :alt 0] 100)
            (gen/return "contents ")]
          [(get w [:nonprop-display-box :alt 1] 100)
            (gen/return "none ")]])
        g (assoc g :nonprop-display-box gen-nonprop-display-box)

        gen-prop-display
        (igen/freq :prop-display [
          [(get w [:prop-display :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-display :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-display [
                [(get w [:prop-display :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-display-outside g)]
                [(get w [:prop-display :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-display-inside g)]]))]
          [(get w [:prop-display :alt 2] 100)
            (:nonprop-display-listitem g)]
          [(get w [:prop-display :alt 3] 100)
            (:nonprop-display-internal g)]
          [(get w [:prop-display :alt 4] 100)
            (:nonprop-display-box g)]
          [(get w [:prop-display :alt 5] 100)
            (:nonprop-display-legacy g)]])
        g (assoc g :prop-display gen-prop-display)

        gen-prop-border-inline
        (igen/freq :prop-border-inline [
          [(get w [:prop-border-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-inline :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-inline [
                [(get w [:prop-border-inline :alt 1 :plus 0 :alt 0] 100)
                  (:prop-border-top-width g)]
                [(get w [:prop-border-inline :alt 1 :plus 0 :alt 1] 100)
                  (:prop-border-top-style g)]
                [(get w [:prop-border-inline :alt 1 :plus 0 :alt 2] 100)
                  (:prop-color g)]]))]])
        g (assoc g :prop-border-inline gen-prop-border-inline)

        gen-prop-padding-inline
        (igen/freq :prop-padding-inline [
          [(get w [:prop-padding-inline :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-inline :alt 1] 100)
            (igen/freq :prop-padding-inline [
              [(get w [:prop-padding-inline :alt 1 :alt 0] 100)
                (:prop-padding-left g)]
              [(get w [:prop-padding-inline :alt 1 :alt 1] 100)
                (gen/tuple
                  (:prop-padding-left g)
                  (gen/return " ")
                  (:prop-padding-left g))]])]])
        g (assoc g :prop-padding-inline gen-prop-padding-inline)

        gen-prop-isolation
        (igen/freq :prop-isolation [
          [(get w [:prop-isolation :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-isolation :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-isolation :alt 2] 100)
            (gen/return "isolate ")]])
        g (assoc g :prop-isolation gen-prop-isolation)

        gen-nonprop-content-list
        (igen/vector+
          (igen/freq :nonprop-content-list [
            [(get w [:nonprop-content-list :plus 0 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:nonprop-content-list :plus 0 :alt 1] 100)
              (gen/return "contents ")]
            [(get w [:nonprop-content-list :plus 0 :alt 2] 100)
              (:nonprop-image g)]
            [(get w [:nonprop-content-list :plus 0 :alt 3] 100)
              (:nonprop-quote g)]
            [(get w [:nonprop-content-list :plus 0 :alt 4] 100)
              (:nonprop-target g)]
            [(get w [:nonprop-content-list :plus 0 :alt 5] 100)
              (:func-leader g)]]))
        g (assoc g :nonprop-content-list gen-nonprop-content-list)

        gen-prop-content
        (igen/freq :prop-content [
          [(get w [:prop-content :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-content :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-content :alt 2] 100)
            (gen/return "none ")]
          [(get w [:prop-content :alt 3] 100)
            (gen/tuple
              (igen/freq :prop-content [
                [(get w [:prop-content :alt 3 :cat 0 :alt 0] 100)
                  (:nonprop-content-replacement g)]
                [(get w [:prop-content :alt 3 :cat 0 :alt 1] 100)
                  (:nonprop-content-list g)]])
              (igen/freq :prop-content [
                [(get w [:prop-content :alt 3 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-content :alt 3 :cat 1 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:nonprop-string g))]]))]])
        g (assoc g :prop-content gen-prop-content)

        gen-prop-text-align
        (igen/freq :prop-text-align [
          [(get w [:prop-text-align :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-align :alt 1] 100)
            (gen/return "start ")]
          [(get w [:prop-text-align :alt 2] 100)
            (gen/return "end ")]
          [(get w [:prop-text-align :alt 3] 100)
            (gen/return "left ")]
          [(get w [:prop-text-align :alt 4] 100)
            (gen/return "right ")]
          [(get w [:prop-text-align :alt 5] 100)
            (gen/return "center ")]
          [(get w [:prop-text-align :alt 6] 100)
            (gen/return "justify ")]
          [(get w [:prop-text-align :alt 7] 100)
            (gen/return "match-parent ")]])
        g (assoc g :prop-text-align gen-prop-text-align)

        gen-prop-mask-type
        (igen/freq :prop-mask-type [
          [(get w [:prop-mask-type :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-type :alt 1] 100)
            (gen/return "luminance ")]
          [(get w [:prop-mask-type :alt 2] 100)
            (gen/return "alpha ")]])
        g (assoc g :prop-mask-type gen-prop-mask-type)

        gen-prop-counter-increment
        (igen/freq :prop-counter-increment [
          [(get w [:prop-counter-increment :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-counter-increment :alt 1] 100)
            (igen/vector+
              (gen/tuple
                (:nonprop-custom-ident g)
                (igen/freq :prop-counter-increment [
                  [(get w [:prop-counter-increment :alt 1 :plus 0 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:prop-counter-increment :alt 1 :plus 0 :cat 1 :opt 0] 100)
                    (:nonprop-integer g)]])))]
          [(get w [:prop-counter-increment :alt 2] 100)
            (gen/return "none ")]])
        g (assoc g :prop-counter-increment gen-prop-counter-increment)

        gen-prop-scroll-margin-top
        (igen/freq :prop-scroll-margin-top [
          [(get w [:prop-scroll-margin-top :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-top :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-top :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-top gen-prop-scroll-margin-top)

        gen-prop-scroll-padding-block-end
        (igen/freq :prop-scroll-padding-block-end [
          [(get w [:prop-scroll-padding-block-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-block-end :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-block-end :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-block-end :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-block-end gen-prop-scroll-padding-block-end)

        gen-prop-scrollbar-width
        (igen/freq :prop-scrollbar-width [
          [(get w [:prop-scrollbar-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scrollbar-width :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scrollbar-width :alt 2] 100)
            (gen/return "thin ")]
          [(get w [:prop-scrollbar-width :alt 3] 100)
            (gen/return "none ")]])
        g (assoc g :prop-scrollbar-width gen-prop-scrollbar-width)

        gen-prop-inset-block-start
        (igen/freq :prop-inset-block-start [
          [(get w [:prop-inset-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-block-start :alt 1] 100)
            (:prop-top g)]])
        g (assoc g :prop-inset-block-start gen-prop-inset-block-start)

        gen-prop-scroll-padding-right
        (igen/freq :prop-scroll-padding-right [
          [(get w [:prop-scroll-padding-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-padding-right :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-padding-right :alt 2] 100)
            (:nonprop-length g)]
          [(get w [:prop-scroll-padding-right :alt 3] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-scroll-padding-right gen-prop-scroll-padding-right)

        gen-prop-quotes
        (igen/freq :prop-quotes [
          [(get w [:prop-quotes :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-quotes :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-quotes :alt 2] 100)
            (igen/vector+
              (gen/tuple
                (:nonprop-string g)
                (:nonprop-string g)))]])
        g (assoc g :prop-quotes gen-prop-quotes)

        gen-prop-unicode-bidi
        (igen/freq :prop-unicode-bidi [
          [(get w [:prop-unicode-bidi :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-unicode-bidi :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-unicode-bidi :alt 2] 100)
            (gen/return "embed ")]
          [(get w [:prop-unicode-bidi :alt 3] 100)
            (gen/return "isolate ")]
          [(get w [:prop-unicode-bidi :alt 4] 100)
            (gen/return "bidi-override ")]
          [(get w [:prop-unicode-bidi :alt 5] 100)
            (gen/return "isolate-override ")]
          [(get w [:prop-unicode-bidi :alt 6] 100)
            (gen/return "plaintext ")]])
        g (assoc g :prop-unicode-bidi gen-prop-unicode-bidi)

        gen-prop-inset-inline-end
        (igen/freq :prop-inset-inline-end [
          [(get w [:prop-inset-inline-end :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-inset-inline-end :alt 1] 100)
            (:prop-top g)]])
        g (assoc g :prop-inset-inline-end gen-prop-inset-inline-end)

        gen-prop-grid-auto-flow
        (igen/freq :prop-grid-auto-flow [
          [(get w [:prop-grid-auto-flow :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-grid-auto-flow :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-grid-auto-flow [
                [(get w [:prop-grid-auto-flow :alt 1 :plus 0 :alt 0] 100)
                  (igen/freq :prop-grid-auto-flow [
                    [(get w [:prop-grid-auto-flow :alt 1 :plus 0 :alt 0 :alt 0] 100)
                      (gen/return "row ")]
                    [(get w [:prop-grid-auto-flow :alt 1 :plus 0 :alt 0 :alt 1] 100)
                      (gen/return "column ")]])]
                [(get w [:prop-grid-auto-flow :alt 1 :plus 0 :alt 1] 100)
                  (gen/return "dense ")]]))]])
        g (assoc g :prop-grid-auto-flow gen-prop-grid-auto-flow)

        gen-prop-mask-origin
        (igen/freq :prop-mask-origin [
          [(get w [:prop-mask-origin :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-origin :alt 1] 100)
            (gen/tuple
              (:nonprop-geometry-box g)
              (igen/freq :prop-mask-origin [
                [(get w [:prop-mask-origin :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-origin :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-geometry-box g)))]]))]])
        g (assoc g :prop-mask-origin gen-prop-mask-origin)

        gen-prop-justify-self
        (igen/freq :prop-justify-self [
          [(get w [:prop-justify-self :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-justify-self :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-justify-self :alt 2] 100)
            (gen/return "normal ")]
          [(get w [:prop-justify-self :alt 3] 100)
            (gen/return "stretch ")]
          [(get w [:prop-justify-self :alt 4] 100)
            (:nonprop-baseline-position g)]
          [(get w [:prop-justify-self :alt 5] 100)
            (gen/tuple
              (igen/freq :prop-justify-self [
                [(get w [:prop-justify-self :alt 5 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-justify-self :alt 5 :cat 0 :opt 0] 100)
                  (:nonprop-overflow-position g)]])
              (igen/freq :prop-justify-self [
                [(get w [:prop-justify-self :alt 5 :cat 1 :alt 0] 100)
                  (:nonprop-self-position g)]
                [(get w [:prop-justify-self :alt 5 :cat 1 :alt 1] 100)
                  (gen/return "left ")]
                [(get w [:prop-justify-self :alt 5 :cat 1 :alt 2] 100)
                  (gen/return "right ")]]))]])
        g (assoc g :prop-justify-self gen-prop-justify-self)

        gen-prop-place-self
        (igen/freq :prop-place-self [
          [(get w [:prop-place-self :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-place-self :alt 1] 100)
            (gen/tuple
              (:prop-align-self g)
              (igen/freq :prop-place-self [
                [(get w [:prop-place-self :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-place-self :alt 1 :cat 1 :opt 0] 100)
                  (:prop-justify-self g)]]))]])
        g (assoc g :prop-place-self gen-prop-place-self)

        gen-prop-border-bottom-left-radius
        (igen/freq :prop-border-bottom-left-radius [
          [(get w [:prop-border-bottom-left-radius :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-bottom-left-radius :alt 1] 100)
            (igen/freq :prop-border-bottom-left-radius [
              [(get w [:prop-border-bottom-left-radius :alt 1 :alt 0] 100)
                (:nonprop-length-percentage g)]
              [(get w [:prop-border-bottom-left-radius :alt 1 :alt 1] 100)
                (gen/tuple
                  (:nonprop-length-percentage g)
                  (gen/return " ")
                  (:nonprop-length-percentage g))]])]])
        g (assoc g :prop-border-bottom-left-radius gen-prop-border-bottom-left-radius)

        gen-prop-border-block-end-width
        (igen/freq :prop-border-block-end-width [
          [(get w [:prop-border-block-end-width :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-block-end-width :alt 1] 100)
            (:prop-border-top-width g)]])
        g (assoc g :prop-border-block-end-width gen-prop-border-block-end-width)

        gen-prop-background
        (igen/freq :prop-background [
          [(get w [:prop-background :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-background :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-background [
                [(get w [:prop-background :alt 1 :cat 0 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-background :alt 1 :cat 0 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (:nonprop-bg-layer g)
                      (gen/return ", ")))]])
              (:nonprop-final-bg-layer g))]])
        g (assoc g :prop-background gen-prop-background)

        gen-prop-z-index
        (igen/freq :prop-z-index [
          [(get w [:prop-z-index :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-z-index :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-z-index :alt 2] 100)
            (:nonprop-integer g)]])
        g (assoc g :prop-z-index gen-prop-z-index)

        gen-prop-height
        (igen/freq :prop-height [
          [(get w [:prop-height :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-height :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-height [
                [(get w [:prop-height :alt 1 :cat 0 :alt 0] 100)
                  (:nonprop-length g)]
                [(get w [:prop-height :alt 1 :cat 0 :alt 1] 100)
                  (:nonprop-percentage g)]])
              (igen/freq :prop-height [
                [(get w [:prop-height :alt 1 :cat 1 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-height :alt 1 :cat 1 :opt 0] 100)
                  (igen/freq :prop-height [
                    [(get w [:prop-height :alt 1 :cat 1 :opt 0 :alt 0] 100)
                      (gen/return "border-box ")]
                    [(get w [:prop-height :alt 1 :cat 1 :opt 0 :alt 1] 100)
                      (gen/return "content-box ")]])]]))]
          [(get w [:prop-height :alt 2] 100)
            (gen/return "available ")]
          [(get w [:prop-height :alt 3] 100)
            (gen/return "min-content ")]
          [(get w [:prop-height :alt 4] 100)
            (gen/return "max-content ")]
          [(get w [:prop-height :alt 5] 100)
            (gen/return "fit-content ")]
          [(get w [:prop-height :alt 6] 100)
            (gen/return "auto ")]])
        g (assoc g :prop-height gen-prop-height)

        gen-prop-font-variant
        (igen/freq :prop-font-variant [
          [(get w [:prop-font-variant :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font-variant :alt 1] 100)
            (gen/return "normal ")]
          [(get w [:prop-font-variant :alt 2] 100)
            (gen/return "none ")]
          [(get w [:prop-font-variant :alt 3] 100)
            (igen/vector+
              (igen/freq :prop-font-variant [
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 0] 100)
                  (:nonprop-common-lig-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 1] 100)
                  (:nonprop-discretionary-lig-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 2] 100)
                  (:nonprop-historical-lig-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 3] 100)
                  (:nonprop-contextual-alt-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 4] 100)
                  (gen/tuple
                    (gen/return "stylistic ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 5] 100)
                  (gen/return "historical-forms ")]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 6] 100)
                  (gen/tuple
                    (gen/return "styleset ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (igen/freq :prop-font-variant [
                      [(get w [:prop-font-variant :alt 3 :plus 0 :alt 6 :cat 3 :star nil] 100)
                        (gen/return "")]
                      [(get w [:prop-font-variant :alt 3 :plus 0 :alt 6 :cat 3 :star 0] 100)
                        (igen/vector+
                          (gen/tuple
                            (gen/return ",")
                            (gen/return " ")
                            (:nonprop-feature-value-name g)))]])
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 7] 100)
                  (gen/tuple
                    (gen/return "character-variant ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (igen/freq :prop-font-variant [
                      [(get w [:prop-font-variant :alt 3 :plus 0 :alt 7 :cat 3 :star nil] 100)
                        (gen/return "")]
                      [(get w [:prop-font-variant :alt 3 :plus 0 :alt 7 :cat 3 :star 0] 100)
                        (igen/vector+
                          (gen/tuple
                            (gen/return ",")
                            (gen/return " ")
                            (:nonprop-feature-value-name g)))]])
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 8] 100)
                  (gen/tuple
                    (gen/return "swash ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 9] 100)
                  (gen/tuple
                    (gen/return "ornaments ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 10] 100)
                  (gen/tuple
                    (gen/return "annotation ")
                    (gen/return "( ")
                    (:nonprop-feature-value-name g)
                    (gen/return ") "))]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11] 100)
                  (igen/freq :prop-font-variant [
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 0] 100)
                      (gen/return "small-caps ")]
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 1] 100)
                      (gen/return "all-small-caps ")]
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 2] 100)
                      (gen/return "petite-caps ")]
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 3] 100)
                      (gen/return "all-petite-caps ")]
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 4] 100)
                      (gen/return "unicase ")]
                    [(get w [:prop-font-variant :alt 3 :plus 0 :alt 11 :alt 5] 100)
                      (gen/return "titling-caps ")]])]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 12] 100)
                  (:nonprop-numeric-figure-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 13] 100)
                  (:nonprop-numeric-spacing-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 14] 100)
                  (:nonprop-numeric-fraction-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 15] 100)
                  (gen/return "ordinal ")]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 16] 100)
                  (gen/return "slashed-zero ")]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 17] 100)
                  (:nonprop-east-asian-variant-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 18] 100)
                  (:nonprop-east-asian-width-values g)]
                [(get w [:prop-font-variant :alt 3 :plus 0 :alt 19] 100)
                  (gen/return "ruby ")]]))]])
        g (assoc g :prop-font-variant gen-prop-font-variant)

        gen-prop-mask-composite
        (igen/freq :prop-mask-composite [
          [(get w [:prop-mask-composite :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-mask-composite :alt 1] 100)
            (gen/tuple
              (:nonprop-compositing-operator g)
              (igen/freq :prop-mask-composite [
                [(get w [:prop-mask-composite :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:prop-mask-composite :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-compositing-operator g)))]]))]])
        g (assoc g :prop-mask-composite gen-prop-mask-composite)

        gen-nonprop-font-variant-css21
        (igen/freq :nonprop-font-variant-css21 [
          [(get w [:nonprop-font-variant-css21 :alt 0] 100)
            (gen/return "normal ")]
          [(get w [:nonprop-font-variant-css21 :alt 1] 100)
            (gen/return "small-caps ")]])
        g (assoc g :nonprop-font-variant-css21 gen-nonprop-font-variant-css21)

        gen-prop-font
        (igen/freq :prop-font [
          [(get w [:prop-font :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-font :alt 1] 100)
            (gen/tuple
              (igen/freq :prop-font [
                [(get w [:prop-font :alt 1 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-font :alt 1 :cat 0 :opt 0] 100)
                  (igen/vector+
                    (igen/freq :prop-font [
                      [(get w [:prop-font :alt 1 :cat 0 :opt 0 :plus 0 :alt 0] 100)
                        (:prop-font-style g)]
                      [(get w [:prop-font :alt 1 :cat 0 :opt 0 :plus 0 :alt 1] 100)
                        (:nonprop-font-variant-css21 g)]
                      [(get w [:prop-font :alt 1 :cat 0 :opt 0 :plus 0 :alt 2] 100)
                        (:prop-font-weight g)]
                      [(get w [:prop-font :alt 1 :cat 0 :opt 0 :plus 0 :alt 3] 100)
                        (:prop-font-stretch g)]]))]])
              (:prop-font-size g)
              (igen/freq :prop-font [
                [(get w [:prop-font :alt 1 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:prop-font :alt 1 :cat 2 :opt 0] 100)
                  (gen/tuple
                    (gen/return "/ ")
                    (:prop-line-height g))]])
              (:prop-font-family g))]
          [(get w [:prop-font :alt 2] 100)
            (gen/return "caption ")]
          [(get w [:prop-font :alt 3] 100)
            (gen/return "icon ")]
          [(get w [:prop-font :alt 4] 100)
            (gen/return "menu ")]
          [(get w [:prop-font :alt 5] 100)
            (gen/return "message-box ")]
          [(get w [:prop-font :alt 6] 100)
            (gen/return "small-caption ")]
          [(get w [:prop-font :alt 7] 100)
            (gen/return "status-bar ")]])
        g (assoc g :prop-font gen-prop-font)

        gen-prop-empty-cells
        (igen/freq :prop-empty-cells [
          [(get w [:prop-empty-cells :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-empty-cells :alt 1] 100)
            (gen/return "show ")]
          [(get w [:prop-empty-cells :alt 2] 100)
            (gen/return "hide ")]])
        g (assoc g :prop-empty-cells gen-prop-empty-cells)

        gen-prop-scrollbar-color
        (igen/freq :prop-scrollbar-color [
          [(get w [:prop-scrollbar-color :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scrollbar-color :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scrollbar-color :alt 2] 100)
            (gen/return "dark ")]
          [(get w [:prop-scrollbar-color :alt 3] 100)
            (gen/return "light ")]
          [(get w [:prop-scrollbar-color :alt 4] 100)
            (gen/tuple
              (:nonprop-color g)
              (gen/return " ")
              (:nonprop-color g))]])
        g (assoc g :prop-scrollbar-color gen-prop-scrollbar-color)

        gen-prop-box-decoration-break
        (igen/freq :prop-box-decoration-break [
          [(get w [:prop-box-decoration-break :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-box-decoration-break :alt 1] 100)
            (gen/return "slice ")]
          [(get w [:prop-box-decoration-break :alt 2] 100)
            (gen/return "clone ")]])
        g (assoc g :prop-box-decoration-break gen-prop-box-decoration-break)

        gen-prop-column-span
        (igen/freq :prop-column-span [
          [(get w [:prop-column-span :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-column-span :alt 1] 100)
            (gen/return "none ")]
          [(get w [:prop-column-span :alt 2] 100)
            (gen/return "all ")]])
        g (assoc g :prop-column-span gen-prop-column-span)

        gen-prop-padding-right
        (igen/freq :prop-padding-right [
          [(get w [:prop-padding-right :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-padding-right :alt 1] 100)
            (:nonprop-length g)]
          [(get w [:prop-padding-right :alt 2] 100)
            (:nonprop-percentage g)]])
        g (assoc g :prop-padding-right gen-prop-padding-right)]
    g))

(defn- css3-generators-part-11 [gmap weights]
  (let [g gmap
        w weights

        gen-prop-break-after
        (igen/freq :prop-break-after [
          [(get w [:prop-break-after :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-break-after :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-break-after :alt 2] 100)
            (gen/return "avoid ")]
          [(get w [:prop-break-after :alt 3] 100)
            (gen/return "always ")]
          [(get w [:prop-break-after :alt 4] 100)
            (gen/return "all ")]
          [(get w [:prop-break-after :alt 5] 100)
            (gen/return "avoid-page ")]
          [(get w [:prop-break-after :alt 6] 100)
            (gen/return "page ")]
          [(get w [:prop-break-after :alt 7] 100)
            (gen/return "left ")]
          [(get w [:prop-break-after :alt 8] 100)
            (gen/return "right ")]
          [(get w [:prop-break-after :alt 9] 100)
            (gen/return "recto ")]
          [(get w [:prop-break-after :alt 10] 100)
            (gen/return "verso ")]
          [(get w [:prop-break-after :alt 11] 100)
            (gen/return "avoid-column ")]
          [(get w [:prop-break-after :alt 12] 100)
            (gen/return "column ")]
          [(get w [:prop-break-after :alt 13] 100)
            (gen/return "avoid-region ")]
          [(get w [:prop-break-after :alt 14] 100)
            (gen/return "region ")]])
        g (assoc g :prop-break-after gen-prop-break-after)

        gen-prop-scroll-margin-block-start
        (igen/freq :prop-scroll-margin-block-start [
          [(get w [:prop-scroll-margin-block-start :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-block-start :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-block-start :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-block-start gen-prop-scroll-margin-block-start)

        gen-prop-text-emphasis
        (igen/freq :prop-text-emphasis [
          [(get w [:prop-text-emphasis :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-text-emphasis :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-text-emphasis [
                [(get w [:prop-text-emphasis :alt 1 :plus 0 :alt 0] 100)
                  (:prop-text-emphasis-style g)]
                [(get w [:prop-text-emphasis :alt 1 :plus 0 :alt 1] 100)
                  (:prop-text-emphasis-color g)]]))]])
        g (assoc g :prop-text-emphasis gen-prop-text-emphasis)

        gen-prop-scroll-snap-align
        (igen/freq :prop-scroll-snap-align [
          [(get w [:prop-scroll-snap-align :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-snap-align :alt 1] 100)
            (igen/freq :prop-scroll-snap-align [
              [(get w [:prop-scroll-snap-align :alt 1 :alt 0] 100)
                (igen/freq :prop-scroll-snap-align [
                  [(get w [:prop-scroll-snap-align :alt 1 :alt 0 :alt 0] 100)
                    (gen/return "none ")]
                  [(get w [:prop-scroll-snap-align :alt 1 :alt 0 :alt 1] 100)
                    (gen/return "start ")]
                  [(get w [:prop-scroll-snap-align :alt 1 :alt 0 :alt 2] 100)
                    (gen/return "end ")]
                  [(get w [:prop-scroll-snap-align :alt 1 :alt 0 :alt 3] 100)
                    (gen/return "center ")]])]
              [(get w [:prop-scroll-snap-align :alt 1 :alt 1] 100)
                (gen/tuple
                  (igen/freq :prop-scroll-snap-align [
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 0 :alt 0] 100)
                      (gen/return "none ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 0 :alt 1] 100)
                      (gen/return "start ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 0 :alt 2] 100)
                      (gen/return "end ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 0 :alt 3] 100)
                      (gen/return "center ")]])
                  (gen/return " ")
                  (igen/freq :prop-scroll-snap-align [
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 2 :alt 0] 100)
                      (gen/return "none ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 2 :alt 1] 100)
                      (gen/return "start ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 2 :alt 2] 100)
                      (gen/return "end ")]
                    [(get w [:prop-scroll-snap-align :alt 1 :alt 1 :cat 2 :alt 3] 100)
                      (gen/return "center ")]]))]])]])
        g (assoc g :prop-scroll-snap-align gen-prop-scroll-snap-align)

        gen-prop-box-sizing
        (igen/freq :prop-box-sizing [
          [(get w [:prop-box-sizing :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-box-sizing :alt 1] 100)
            (gen/return "content-box ")]
          [(get w [:prop-box-sizing :alt 2] 100)
            (gen/return "border-box ")]])
        g (assoc g :prop-box-sizing gen-prop-box-sizing)

        gen-prop-border-left
        (igen/freq :prop-border-left [
          [(get w [:prop-border-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-border-left :alt 1] 100)
            (igen/vector+
              (igen/freq :prop-border-left [
                [(get w [:prop-border-left :alt 1 :plus 0 :alt 0] 100)
                  (:nonprop-line-width g)]
                [(get w [:prop-border-left :alt 1 :plus 0 :alt 1] 100)
                  (:nonprop-line-style g)]
                [(get w [:prop-border-left :alt 1 :plus 0 :alt 2] 100)
                  (:nonprop-color g)]]))]])
        g (assoc g :prop-border-left gen-prop-border-left)

        gen-prop-object-fit
        (igen/freq :prop-object-fit [
          [(get w [:prop-object-fit :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-object-fit :alt 1] 100)
            (gen/return "fill ")]
          [(get w [:prop-object-fit :alt 2] 100)
            (gen/return "contain ")]
          [(get w [:prop-object-fit :alt 3] 100)
            (gen/return "cover ")]
          [(get w [:prop-object-fit :alt 4] 100)
            (gen/return "none ")]
          [(get w [:prop-object-fit :alt 5] 100)
            (gen/return "scale-down ")]])
        g (assoc g :prop-object-fit gen-prop-object-fit)

        gen-prop-scroll-margin-left
        (igen/freq :prop-scroll-margin-left [
          [(get w [:prop-scroll-margin-left :alt 0] 100)
            (:prop-all g)]
          [(get w [:prop-scroll-margin-left :alt 1] 100)
            (gen/return "auto ")]
          [(get w [:prop-scroll-margin-left :alt 2] 100)
            (:nonprop-length g)]])
        g (assoc g :prop-scroll-margin-left gen-prop-scroll-margin-left)

        gen-css-known-standard
        (igen/freq :css-known-standard [
          [(get w [:css-known-standard :alt 0] 100)
            (gen/tuple
              (gen/return "align-content")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-align-content g))]
          [(get w [:css-known-standard :alt 1] 100)
            (gen/tuple
              (gen/return "align-items")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-align-items g))]
          [(get w [:css-known-standard :alt 2] 100)
            (gen/tuple
              (gen/return "align-self")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-align-self g))]
          [(get w [:css-known-standard :alt 3] 100)
            (gen/tuple
              (gen/return "all")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-all g))]
          [(get w [:css-known-standard :alt 4] 100)
            (gen/tuple
              (gen/return "animation")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation g))]
          [(get w [:css-known-standard :alt 5] 100)
            (gen/tuple
              (gen/return "animation-delay")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-delay g))]
          [(get w [:css-known-standard :alt 6] 100)
            (gen/tuple
              (gen/return "animation-direction")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-direction g))]
          [(get w [:css-known-standard :alt 7] 100)
            (gen/tuple
              (gen/return "animation-duration")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-duration g))]
          [(get w [:css-known-standard :alt 8] 100)
            (gen/tuple
              (gen/return "animation-fill-mode")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-fill-mode g))]
          [(get w [:css-known-standard :alt 9] 100)
            (gen/tuple
              (gen/return "animation-iteration-count")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-iteration-count g))]
          [(get w [:css-known-standard :alt 10] 100)
            (gen/tuple
              (gen/return "animation-name")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-name g))]
          [(get w [:css-known-standard :alt 11] 100)
            (gen/tuple
              (gen/return "animation-play-state")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-play-state g))]
          [(get w [:css-known-standard :alt 12] 100)
            (gen/tuple
              (gen/return "animation-timing-function")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-animation-timing-function g))]
          [(get w [:css-known-standard :alt 13] 100)
            (gen/tuple
              (gen/return "backface-visibility")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-backface-visibility g))]
          [(get w [:css-known-standard :alt 14] 100)
            (gen/tuple
              (gen/return "background")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background g))]
          [(get w [:css-known-standard :alt 15] 100)
            (gen/tuple
              (gen/return "background-attachment")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-attachment g))]
          [(get w [:css-known-standard :alt 16] 100)
            (gen/tuple
              (gen/return "background-blend-mode")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-blend-mode g))]
          [(get w [:css-known-standard :alt 17] 100)
            (gen/tuple
              (gen/return "background-clip")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-clip g))]
          [(get w [:css-known-standard :alt 18] 100)
            (gen/tuple
              (gen/return "background-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-color g))]
          [(get w [:css-known-standard :alt 19] 100)
            (gen/tuple
              (gen/return "background-image")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-image g))]
          [(get w [:css-known-standard :alt 20] 100)
            (gen/tuple
              (gen/return "background-origin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-origin g))]
          [(get w [:css-known-standard :alt 21] 100)
            (gen/tuple
              (gen/return "background-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-position g))]
          [(get w [:css-known-standard :alt 22] 100)
            (gen/tuple
              (gen/return "background-repeat")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-repeat g))]
          [(get w [:css-known-standard :alt 23] 100)
            (gen/tuple
              (gen/return "background-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-background-size g))]
          [(get w [:css-known-standard :alt 24] 100)
            (gen/tuple
              (gen/return "block-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-block-size g))]
          [(get w [:css-known-standard :alt 25] 100)
            (gen/tuple
              (gen/return "border")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border g))]
          [(get w [:css-known-standard :alt 26] 100)
            (gen/tuple
              (gen/return "border-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block g))]
          [(get w [:css-known-standard :alt 27] 100)
            (gen/tuple
              (gen/return "border-block-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-color g))]
          [(get w [:css-known-standard :alt 28] 100)
            (gen/tuple
              (gen/return "border-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-end g))]
          [(get w [:css-known-standard :alt 29] 100)
            (gen/tuple
              (gen/return "border-block-end-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-end-color g))]
          [(get w [:css-known-standard :alt 30] 100)
            (gen/tuple
              (gen/return "border-block-end-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-end-style g))]
          [(get w [:css-known-standard :alt 31] 100)
            (gen/tuple
              (gen/return "border-block-end-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-end-width g))]
          [(get w [:css-known-standard :alt 32] 100)
            (gen/tuple
              (gen/return "border-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-start g))]
          [(get w [:css-known-standard :alt 33] 100)
            (gen/tuple
              (gen/return "border-block-start-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-start-color g))]
          [(get w [:css-known-standard :alt 34] 100)
            (gen/tuple
              (gen/return "border-block-start-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-start-style g))]
          [(get w [:css-known-standard :alt 35] 100)
            (gen/tuple
              (gen/return "border-block-start-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-start-width g))]
          [(get w [:css-known-standard :alt 36] 100)
            (gen/tuple
              (gen/return "border-block-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-style g))]
          [(get w [:css-known-standard :alt 37] 100)
            (gen/tuple
              (gen/return "border-block-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-block-width g))]
          [(get w [:css-known-standard :alt 38] 100)
            (gen/tuple
              (gen/return "border-bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom g))]
          [(get w [:css-known-standard :alt 39] 100)
            (gen/tuple
              (gen/return "border-bottom-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom-color g))]
          [(get w [:css-known-standard :alt 40] 100)
            (gen/tuple
              (gen/return "border-bottom-left-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom-left-radius g))]
          [(get w [:css-known-standard :alt 41] 100)
            (gen/tuple
              (gen/return "border-bottom-right-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom-right-radius g))]
          [(get w [:css-known-standard :alt 42] 100)
            (gen/tuple
              (gen/return "border-bottom-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom-style g))]
          [(get w [:css-known-standard :alt 43] 100)
            (gen/tuple
              (gen/return "border-bottom-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-bottom-width g))]
          [(get w [:css-known-standard :alt 44] 100)
            (gen/tuple
              (gen/return "border-collapse")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-collapse g))]
          [(get w [:css-known-standard :alt 45] 100)
            (gen/tuple
              (gen/return "border-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-color g))]
          [(get w [:css-known-standard :alt 46] 100)
            (gen/tuple
              (gen/return "border-end-end-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-end-end-radius g))]
          [(get w [:css-known-standard :alt 47] 100)
            (gen/tuple
              (gen/return "border-end-start-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-end-start-radius g))]
          [(get w [:css-known-standard :alt 48] 100)
            (gen/tuple
              (gen/return "border-image")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image g))]
          [(get w [:css-known-standard :alt 49] 100)
            (gen/tuple
              (gen/return "border-image-outset")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image-outset g))]
          [(get w [:css-known-standard :alt 50] 100)
            (gen/tuple
              (gen/return "border-image-repeat")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image-repeat g))]
          [(get w [:css-known-standard :alt 51] 100)
            (gen/tuple
              (gen/return "border-image-slice")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image-slice g))]
          [(get w [:css-known-standard :alt 52] 100)
            (gen/tuple
              (gen/return "border-image-source")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image-source g))]
          [(get w [:css-known-standard :alt 53] 100)
            (gen/tuple
              (gen/return "border-image-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-image-width g))]
          [(get w [:css-known-standard :alt 54] 100)
            (gen/tuple
              (gen/return "border-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline g))]
          [(get w [:css-known-standard :alt 55] 100)
            (gen/tuple
              (gen/return "border-inline-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-color g))]
          [(get w [:css-known-standard :alt 56] 100)
            (gen/tuple
              (gen/return "border-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-end g))]
          [(get w [:css-known-standard :alt 57] 100)
            (gen/tuple
              (gen/return "border-inline-end-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-end-color g))]
          [(get w [:css-known-standard :alt 58] 100)
            (gen/tuple
              (gen/return "border-inline-end-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-end-style g))]
          [(get w [:css-known-standard :alt 59] 100)
            (gen/tuple
              (gen/return "border-inline-end-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-end-width g))]
          [(get w [:css-known-standard :alt 60] 100)
            (gen/tuple
              (gen/return "border-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-start g))]
          [(get w [:css-known-standard :alt 61] 100)
            (gen/tuple
              (gen/return "border-inline-start-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-start-color g))]
          [(get w [:css-known-standard :alt 62] 100)
            (gen/tuple
              (gen/return "border-inline-start-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-start-style g))]
          [(get w [:css-known-standard :alt 63] 100)
            (gen/tuple
              (gen/return "border-inline-start-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-start-width g))]
          [(get w [:css-known-standard :alt 64] 100)
            (gen/tuple
              (gen/return "border-inline-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-style g))]
          [(get w [:css-known-standard :alt 65] 100)
            (gen/tuple
              (gen/return "border-inline-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-inline-width g))]
          [(get w [:css-known-standard :alt 66] 100)
            (gen/tuple
              (gen/return "border-left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-left g))]
          [(get w [:css-known-standard :alt 67] 100)
            (gen/tuple
              (gen/return "border-left-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-left-color g))]
          [(get w [:css-known-standard :alt 68] 100)
            (gen/tuple
              (gen/return "border-left-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-left-style g))]
          [(get w [:css-known-standard :alt 69] 100)
            (gen/tuple
              (gen/return "border-left-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-left-width g))]
          [(get w [:css-known-standard :alt 70] 100)
            (gen/tuple
              (gen/return "border-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-radius g))]
          [(get w [:css-known-standard :alt 71] 100)
            (gen/tuple
              (gen/return "border-right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-right g))]
          [(get w [:css-known-standard :alt 72] 100)
            (gen/tuple
              (gen/return "border-right-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-right-color g))]
          [(get w [:css-known-standard :alt 73] 100)
            (gen/tuple
              (gen/return "border-right-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-right-style g))]
          [(get w [:css-known-standard :alt 74] 100)
            (gen/tuple
              (gen/return "border-right-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-right-width g))]
          [(get w [:css-known-standard :alt 75] 100)
            (gen/tuple
              (gen/return "border-spacing")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-spacing g))]
          [(get w [:css-known-standard :alt 76] 100)
            (gen/tuple
              (gen/return "border-start-end-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-start-end-radius g))]
          [(get w [:css-known-standard :alt 77] 100)
            (gen/tuple
              (gen/return "border-start-start-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-start-start-radius g))]
          [(get w [:css-known-standard :alt 78] 100)
            (gen/tuple
              (gen/return "border-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-style g))]
          [(get w [:css-known-standard :alt 79] 100)
            (gen/tuple
              (gen/return "border-top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top g))]
          [(get w [:css-known-standard :alt 80] 100)
            (gen/tuple
              (gen/return "border-top-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top-color g))]
          [(get w [:css-known-standard :alt 81] 100)
            (gen/tuple
              (gen/return "border-top-left-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top-left-radius g))]
          [(get w [:css-known-standard :alt 82] 100)
            (gen/tuple
              (gen/return "border-top-right-radius")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top-right-radius g))]
          [(get w [:css-known-standard :alt 83] 100)
            (gen/tuple
              (gen/return "border-top-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top-style g))]
          [(get w [:css-known-standard :alt 84] 100)
            (gen/tuple
              (gen/return "border-top-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-top-width g))]
          [(get w [:css-known-standard :alt 85] 100)
            (gen/tuple
              (gen/return "border-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-border-width g))]
          [(get w [:css-known-standard :alt 86] 100)
            (gen/tuple
              (gen/return "bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-bottom g))]
          [(get w [:css-known-standard :alt 87] 100)
            (gen/tuple
              (gen/return "box-decoration-break")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-box-decoration-break g))]
          [(get w [:css-known-standard :alt 88] 100)
            (gen/tuple
              (gen/return "box-shadow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-box-shadow g))]
          [(get w [:css-known-standard :alt 89] 100)
            (gen/tuple
              (gen/return "box-sizing")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-box-sizing g))]
          [(get w [:css-known-standard :alt 90] 100)
            (gen/tuple
              (gen/return "break-after")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-break-after g))]
          [(get w [:css-known-standard :alt 91] 100)
            (gen/tuple
              (gen/return "break-before")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-break-before g))]
          [(get w [:css-known-standard :alt 92] 100)
            (gen/tuple
              (gen/return "break-inside")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-break-inside g))]
          [(get w [:css-known-standard :alt 93] 100)
            (gen/tuple
              (gen/return "caption-side")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-caption-side g))]
          [(get w [:css-known-standard :alt 94] 100)
            (gen/tuple
              (gen/return "caret-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-caret-color g))]
          [(get w [:css-known-standard :alt 95] 100)
            (gen/tuple
              (gen/return "clear")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-clear g))]
          [(get w [:css-known-standard :alt 96] 100)
            (gen/tuple
              (gen/return "clip")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-clip g))]
          [(get w [:css-known-standard :alt 97] 100)
            (gen/tuple
              (gen/return "clip-path")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-clip-path g))]
          [(get w [:css-known-standard :alt 98] 100)
            (gen/tuple
              (gen/return "color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-color g))]
          [(get w [:css-known-standard :alt 99] 100)
            (gen/tuple
              (gen/return "color-adjust")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-color-adjust g))]
          [(get w [:css-known-standard :alt 100] 100)
            (gen/tuple
              (gen/return "column-count")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-count g))]
          [(get w [:css-known-standard :alt 101] 100)
            (gen/tuple
              (gen/return "column-fill")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-fill g))]
          [(get w [:css-known-standard :alt 102] 100)
            (gen/tuple
              (gen/return "column-gap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-gap g))]
          [(get w [:css-known-standard :alt 103] 100)
            (gen/tuple
              (gen/return "column-rule")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-rule g))]
          [(get w [:css-known-standard :alt 104] 100)
            (gen/tuple
              (gen/return "column-rule-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-rule-color g))]
          [(get w [:css-known-standard :alt 105] 100)
            (gen/tuple
              (gen/return "column-rule-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-rule-style g))]
          [(get w [:css-known-standard :alt 106] 100)
            (gen/tuple
              (gen/return "column-rule-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-rule-width g))]
          [(get w [:css-known-standard :alt 107] 100)
            (gen/tuple
              (gen/return "column-span")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-span g))]
          [(get w [:css-known-standard :alt 108] 100)
            (gen/tuple
              (gen/return "column-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-column-width g))]
          [(get w [:css-known-standard :alt 109] 100)
            (gen/tuple
              (gen/return "columns")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-columns g))]
          [(get w [:css-known-standard :alt 110] 100)
            (gen/tuple
              (gen/return "content")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-content g))]
          [(get w [:css-known-standard :alt 111] 100)
            (gen/tuple
              (gen/return "counter-increment")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-counter-increment g))]
          [(get w [:css-known-standard :alt 112] 100)
            (gen/tuple
              (gen/return "counter-reset")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-counter-reset g))]
          [(get w [:css-known-standard :alt 113] 100)
            (gen/tuple
              (gen/return "cursor")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-cursor g))]
          [(get w [:css-known-standard :alt 114] 100)
            (gen/tuple
              (gen/return "direction")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-direction g))]
          [(get w [:css-known-standard :alt 115] 100)
            (gen/tuple
              (gen/return "display")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-display g))]
          [(get w [:css-known-standard :alt 116] 100)
            (gen/tuple
              (gen/return "empty-cells")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-empty-cells g))]
          [(get w [:css-known-standard :alt 117] 100)
            (gen/tuple
              (gen/return "filter")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-filter g))]
          [(get w [:css-known-standard :alt 118] 100)
            (gen/tuple
              (gen/return "flex")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex g))]
          [(get w [:css-known-standard :alt 119] 100)
            (gen/tuple
              (gen/return "flex-basis")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-basis g))]
          [(get w [:css-known-standard :alt 120] 100)
            (gen/tuple
              (gen/return "flex-direction")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-direction g))]
          [(get w [:css-known-standard :alt 121] 100)
            (gen/tuple
              (gen/return "flex-flow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-flow g))]
          [(get w [:css-known-standard :alt 122] 100)
            (gen/tuple
              (gen/return "flex-grow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-grow g))]
          [(get w [:css-known-standard :alt 123] 100)
            (gen/tuple
              (gen/return "flex-shrink")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-shrink g))]
          [(get w [:css-known-standard :alt 124] 100)
            (gen/tuple
              (gen/return "flex-wrap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-flex-wrap g))]
          [(get w [:css-known-standard :alt 125] 100)
            (gen/tuple
              (gen/return "float")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-float g))]
          [(get w [:css-known-standard :alt 126] 100)
            (gen/tuple
              (gen/return "font")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font g))]
          [(get w [:css-known-standard :alt 127] 100)
            (gen/tuple
              (gen/return "font-family")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-family g))]
          [(get w [:css-known-standard :alt 128] 100)
            (gen/tuple
              (gen/return "font-feature-settings")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-feature-settings g))]
          [(get w [:css-known-standard :alt 129] 100)
            (gen/tuple
              (gen/return "font-kerning")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-kerning g))]
          [(get w [:css-known-standard :alt 130] 100)
            (gen/tuple
              (gen/return "font-language-override")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-language-override g))]
          [(get w [:css-known-standard :alt 131] 100)
            (gen/tuple
              (gen/return "font-optical-sizing")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-optical-sizing g))]
          [(get w [:css-known-standard :alt 132] 100)
            (gen/tuple
              (gen/return "font-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-size g))]
          [(get w [:css-known-standard :alt 133] 100)
            (gen/tuple
              (gen/return "font-size-adjust")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-size-adjust g))]
          [(get w [:css-known-standard :alt 134] 100)
            (gen/tuple
              (gen/return "font-stretch")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-stretch g))]
          [(get w [:css-known-standard :alt 135] 100)
            (gen/tuple
              (gen/return "font-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-style g))]
          [(get w [:css-known-standard :alt 136] 100)
            (gen/tuple
              (gen/return "font-synthesis")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-synthesis g))]
          [(get w [:css-known-standard :alt 137] 100)
            (gen/tuple
              (gen/return "font-variant")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant g))]
          [(get w [:css-known-standard :alt 138] 100)
            (gen/tuple
              (gen/return "font-variant-alternates")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-alternates g))]
          [(get w [:css-known-standard :alt 139] 100)
            (gen/tuple
              (gen/return "font-variant-caps")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-caps g))]
          [(get w [:css-known-standard :alt 140] 100)
            (gen/tuple
              (gen/return "font-variant-east-asian")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-east-asian g))]
          [(get w [:css-known-standard :alt 141] 100)
            (gen/tuple
              (gen/return "font-variant-ligatures")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-ligatures g))]
          [(get w [:css-known-standard :alt 142] 100)
            (gen/tuple
              (gen/return "font-variant-numeric")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-numeric g))]
          [(get w [:css-known-standard :alt 143] 100)
            (gen/tuple
              (gen/return "font-variant-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-variant-position g))]
          [(get w [:css-known-standard :alt 144] 100)
            (gen/tuple
              (gen/return "font-weight")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-font-weight g))]
          [(get w [:css-known-standard :alt 145] 100)
            (gen/tuple
              (gen/return "gap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-gap g))]
          [(get w [:css-known-standard :alt 146] 100)
            (gen/tuple
              (gen/return "grid")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid g))]
          [(get w [:css-known-standard :alt 147] 100)
            (gen/tuple
              (gen/return "grid-area")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-area g))]
          [(get w [:css-known-standard :alt 148] 100)
            (gen/tuple
              (gen/return "grid-auto-columns")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-auto-columns g))]
          [(get w [:css-known-standard :alt 149] 100)
            (gen/tuple
              (gen/return "grid-auto-flow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-auto-flow g))]
          [(get w [:css-known-standard :alt 150] 100)
            (gen/tuple
              (gen/return "grid-auto-rows")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-auto-rows g))]
          [(get w [:css-known-standard :alt 151] 100)
            (gen/tuple
              (gen/return "grid-column")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-column g))]
          [(get w [:css-known-standard :alt 152] 100)
            (gen/tuple
              (gen/return "grid-column-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-column-end g))]
          [(get w [:css-known-standard :alt 153] 100)
            (gen/tuple
              (gen/return "grid-column-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-column-start g))]
          [(get w [:css-known-standard :alt 154] 100)
            (gen/tuple
              (gen/return "grid-row")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-row g))]
          [(get w [:css-known-standard :alt 155] 100)
            (gen/tuple
              (gen/return "grid-row-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-row-end g))]
          [(get w [:css-known-standard :alt 156] 100)
            (gen/tuple
              (gen/return "grid-row-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-row-start g))]
          [(get w [:css-known-standard :alt 157] 100)
            (gen/tuple
              (gen/return "grid-template")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-template g))]
          [(get w [:css-known-standard :alt 158] 100)
            (gen/tuple
              (gen/return "grid-template-areas")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-template-areas g))]
          [(get w [:css-known-standard :alt 159] 100)
            (gen/tuple
              (gen/return "grid-template-columns")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-template-columns g))]
          [(get w [:css-known-standard :alt 160] 100)
            (gen/tuple
              (gen/return "grid-template-rows")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-grid-template-rows g))]
          [(get w [:css-known-standard :alt 161] 100)
            (gen/tuple
              (gen/return "hanging-punctuation")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-hanging-punctuation g))]
          [(get w [:css-known-standard :alt 162] 100)
            (gen/tuple
              (gen/return "height")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-height g))]
          [(get w [:css-known-standard :alt 163] 100)
            (gen/tuple
              (gen/return "hyphens")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-hyphens g))]
          [(get w [:css-known-standard :alt 164] 100)
            (gen/tuple
              (gen/return "image-orientation")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-image-orientation g))]
          [(get w [:css-known-standard :alt 165] 100)
            (gen/tuple
              (gen/return "image-rendering")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-image-rendering g))]
          [(get w [:css-known-standard :alt 166] 100)
            (gen/tuple
              (gen/return "inline-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inline-size g))]
          [(get w [:css-known-standard :alt 167] 100)
            (gen/tuple
              (gen/return "inset")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset g))]
          [(get w [:css-known-standard :alt 168] 100)
            (gen/tuple
              (gen/return "inset-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-block g))]
          [(get w [:css-known-standard :alt 169] 100)
            (gen/tuple
              (gen/return "inset-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-block-end g))]
          [(get w [:css-known-standard :alt 170] 100)
            (gen/tuple
              (gen/return "inset-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-block-start g))]
          [(get w [:css-known-standard :alt 171] 100)
            (gen/tuple
              (gen/return "inset-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-inline g))]
          [(get w [:css-known-standard :alt 172] 100)
            (gen/tuple
              (gen/return "inset-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-inline-end g))]
          [(get w [:css-known-standard :alt 173] 100)
            (gen/tuple
              (gen/return "inset-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-inset-inline-start g))]
          [(get w [:css-known-standard :alt 174] 100)
            (gen/tuple
              (gen/return "isolation")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-isolation g))]
          [(get w [:css-known-standard :alt 175] 100)
            (gen/tuple
              (gen/return "justify-content")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-justify-content g))]
          [(get w [:css-known-standard :alt 176] 100)
            (gen/tuple
              (gen/return "justify-items")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-justify-items g))]
          [(get w [:css-known-standard :alt 177] 100)
            (gen/tuple
              (gen/return "justify-self")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-justify-self g))]
          [(get w [:css-known-standard :alt 178] 100)
            (gen/tuple
              (gen/return "left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-left g))]
          [(get w [:css-known-standard :alt 179] 100)
            (gen/tuple
              (gen/return "letter-spacing")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-letter-spacing g))]
          [(get w [:css-known-standard :alt 180] 100)
            (gen/tuple
              (gen/return "line-break")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-line-break g))]
          [(get w [:css-known-standard :alt 181] 100)
            (gen/tuple
              (gen/return "line-height")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-line-height g))]
          [(get w [:css-known-standard :alt 182] 100)
            (gen/tuple
              (gen/return "list-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-list-style g))]
          [(get w [:css-known-standard :alt 183] 100)
            (gen/tuple
              (gen/return "list-style-image")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-list-style-image g))]
          [(get w [:css-known-standard :alt 184] 100)
            (gen/tuple
              (gen/return "list-style-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-list-style-position g))]
          [(get w [:css-known-standard :alt 185] 100)
            (gen/tuple
              (gen/return "list-style-type")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-list-style-type g))]
          [(get w [:css-known-standard :alt 186] 100)
            (gen/tuple
              (gen/return "margin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin g))]
          [(get w [:css-known-standard :alt 187] 100)
            (gen/tuple
              (gen/return "margin-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-block g))]
          [(get w [:css-known-standard :alt 188] 100)
            (gen/tuple
              (gen/return "margin-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-block-end g))]
          [(get w [:css-known-standard :alt 189] 100)
            (gen/tuple
              (gen/return "margin-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-block-start g))]
          [(get w [:css-known-standard :alt 190] 100)
            (gen/tuple
              (gen/return "margin-bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-bottom g))]
          [(get w [:css-known-standard :alt 191] 100)
            (gen/tuple
              (gen/return "margin-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-inline g))]
          [(get w [:css-known-standard :alt 192] 100)
            (gen/tuple
              (gen/return "margin-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-inline-end g))]
          [(get w [:css-known-standard :alt 193] 100)
            (gen/tuple
              (gen/return "margin-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-inline-start g))]
          [(get w [:css-known-standard :alt 194] 100)
            (gen/tuple
              (gen/return "margin-left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-left g))]
          [(get w [:css-known-standard :alt 195] 100)
            (gen/tuple
              (gen/return "margin-right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-right g))]
          [(get w [:css-known-standard :alt 196] 100)
            (gen/tuple
              (gen/return "margin-top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-margin-top g))]
          [(get w [:css-known-standard :alt 197] 100)
            (gen/tuple
              (gen/return "mask")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask g))]
          [(get w [:css-known-standard :alt 198] 100)
            (gen/tuple
              (gen/return "mask-clip")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-clip g))]
          [(get w [:css-known-standard :alt 199] 100)
            (gen/tuple
              (gen/return "mask-composite")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-composite g))]
          [(get w [:css-known-standard :alt 200] 100)
            (gen/tuple
              (gen/return "mask-image")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-image g))]
          [(get w [:css-known-standard :alt 201] 100)
            (gen/tuple
              (gen/return "mask-mode")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-mode g))]
          [(get w [:css-known-standard :alt 202] 100)
            (gen/tuple
              (gen/return "mask-origin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-origin g))]
          [(get w [:css-known-standard :alt 203] 100)
            (gen/tuple
              (gen/return "mask-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-position g))]
          [(get w [:css-known-standard :alt 204] 100)
            (gen/tuple
              (gen/return "mask-repeat")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-repeat g))]
          [(get w [:css-known-standard :alt 205] 100)
            (gen/tuple
              (gen/return "mask-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-size g))]
          [(get w [:css-known-standard :alt 206] 100)
            (gen/tuple
              (gen/return "mask-type")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mask-type g))]
          [(get w [:css-known-standard :alt 207] 100)
            (gen/tuple
              (gen/return "max-height")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-max-height g))]
          [(get w [:css-known-standard :alt 208] 100)
            (gen/tuple
              (gen/return "max-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-max-width g))]
          [(get w [:css-known-standard :alt 209] 100)
            (gen/tuple
              (gen/return "min-block-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-min-block-size g))]
          [(get w [:css-known-standard :alt 210] 100)
            (gen/tuple
              (gen/return "min-height")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-min-height g))]
          [(get w [:css-known-standard :alt 211] 100)
            (gen/tuple
              (gen/return "min-inline-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-min-inline-size g))]
          [(get w [:css-known-standard :alt 212] 100)
            (gen/tuple
              (gen/return "min-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-min-width g))]
          [(get w [:css-known-standard :alt 213] 100)
            (gen/tuple
              (gen/return "mix-blend-mode")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-mix-blend-mode g))]
          [(get w [:css-known-standard :alt 214] 100)
            (gen/tuple
              (gen/return "object-fit")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-object-fit g))]
          [(get w [:css-known-standard :alt 215] 100)
            (gen/tuple
              (gen/return "object-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-object-position g))]
          [(get w [:css-known-standard :alt 216] 100)
            (gen/tuple
              (gen/return "opacity")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-opacity g))]
          [(get w [:css-known-standard :alt 217] 100)
            (gen/tuple
              (gen/return "order")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-order g))]
          [(get w [:css-known-standard :alt 218] 100)
            (gen/tuple
              (gen/return "orphans")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-orphans g))]
          [(get w [:css-known-standard :alt 219] 100)
            (gen/tuple
              (gen/return "outline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-outline g))]
          [(get w [:css-known-standard :alt 220] 100)
            (gen/tuple
              (gen/return "outline-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-outline-color g))]
          [(get w [:css-known-standard :alt 221] 100)
            (gen/tuple
              (gen/return "outline-offset")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-outline-offset g))]
          [(get w [:css-known-standard :alt 222] 100)
            (gen/tuple
              (gen/return "outline-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-outline-style g))]
          [(get w [:css-known-standard :alt 223] 100)
            (gen/tuple
              (gen/return "outline-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-outline-width g))]
          [(get w [:css-known-standard :alt 224] 100)
            (gen/tuple
              (gen/return "overflow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-overflow g))]
          [(get w [:css-known-standard :alt 225] 100)
            (gen/tuple
              (gen/return "overflow-wrap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-overflow-wrap g))]
          [(get w [:css-known-standard :alt 226] 100)
            (gen/tuple
              (gen/return "overflow-x")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-overflow-x g))]
          [(get w [:css-known-standard :alt 227] 100)
            (gen/tuple
              (gen/return "overflow-y")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-overflow-y g))]
          [(get w [:css-known-standard :alt 228] 100)
            (gen/tuple
              (gen/return "padding")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding g))]
          [(get w [:css-known-standard :alt 229] 100)
            (gen/tuple
              (gen/return "padding-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-block g))]
          [(get w [:css-known-standard :alt 230] 100)
            (gen/tuple
              (gen/return "padding-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-block-end g))]
          [(get w [:css-known-standard :alt 231] 100)
            (gen/tuple
              (gen/return "padding-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-block-start g))]
          [(get w [:css-known-standard :alt 232] 100)
            (gen/tuple
              (gen/return "padding-bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-bottom g))]
          [(get w [:css-known-standard :alt 233] 100)
            (gen/tuple
              (gen/return "padding-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-inline g))]
          [(get w [:css-known-standard :alt 234] 100)
            (gen/tuple
              (gen/return "padding-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-inline-end g))]
          [(get w [:css-known-standard :alt 235] 100)
            (gen/tuple
              (gen/return "padding-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-inline-start g))]
          [(get w [:css-known-standard :alt 236] 100)
            (gen/tuple
              (gen/return "padding-left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-left g))]
          [(get w [:css-known-standard :alt 237] 100)
            (gen/tuple
              (gen/return "padding-right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-right g))]
          [(get w [:css-known-standard :alt 238] 100)
            (gen/tuple
              (gen/return "padding-top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-padding-top g))]
          [(get w [:css-known-standard :alt 239] 100)
            (gen/tuple
              (gen/return "page-break-after")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-page-break-after g))]
          [(get w [:css-known-standard :alt 240] 100)
            (gen/tuple
              (gen/return "page-break-before")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-page-break-before g))]
          [(get w [:css-known-standard :alt 241] 100)
            (gen/tuple
              (gen/return "page-break-inside")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-page-break-inside g))]
          [(get w [:css-known-standard :alt 242] 100)
            (gen/tuple
              (gen/return "perspective")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-perspective g))]
          [(get w [:css-known-standard :alt 243] 100)
            (gen/tuple
              (gen/return "perspective-origin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-perspective-origin g))]
          [(get w [:css-known-standard :alt 244] 100)
            (gen/tuple
              (gen/return "place-content")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-place-content g))]
          [(get w [:css-known-standard :alt 245] 100)
            (gen/tuple
              (gen/return "place-items")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-place-items g))]
          [(get w [:css-known-standard :alt 246] 100)
            (gen/tuple
              (gen/return "place-self")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-place-self g))]
          [(get w [:css-known-standard :alt 247] 100)
            (gen/tuple
              (gen/return "pointer-events")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-pointer-events g))]
          [(get w [:css-known-standard :alt 248] 100)
            (gen/tuple
              (gen/return "position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-position g))]
          [(get w [:css-known-standard :alt 249] 100)
            (gen/tuple
              (gen/return "quotes")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-quotes g))]
          [(get w [:css-known-standard :alt 250] 100)
            (gen/tuple
              (gen/return "resize")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-resize g))]
          [(get w [:css-known-standard :alt 251] 100)
            (gen/tuple
              (gen/return "right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-right g))]
          [(get w [:css-known-standard :alt 252] 100)
            (gen/tuple
              (gen/return "rotate")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-rotate g))]
          [(get w [:css-known-standard :alt 253] 100)
            (gen/tuple
              (gen/return "row-gap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-row-gap g))]
          [(get w [:css-known-standard :alt 254] 100)
            (gen/tuple
              (gen/return "scale")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scale g))]
          [(get w [:css-known-standard :alt 255] 100)
            (gen/tuple
              (gen/return "scroll-behavior")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-behavior g))]
          [(get w [:css-known-standard :alt 256] 100)
            (gen/tuple
              (gen/return "scroll-margin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin g))]
          [(get w [:css-known-standard :alt 257] 100)
            (gen/tuple
              (gen/return "scroll-margin-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-block g))]
          [(get w [:css-known-standard :alt 258] 100)
            (gen/tuple
              (gen/return "scroll-margin-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-block-end g))]
          [(get w [:css-known-standard :alt 259] 100)
            (gen/tuple
              (gen/return "scroll-margin-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-block-start g))]
          [(get w [:css-known-standard :alt 260] 100)
            (gen/tuple
              (gen/return "scroll-margin-bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-bottom g))]
          [(get w [:css-known-standard :alt 261] 100)
            (gen/tuple
              (gen/return "scroll-margin-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-inline g))]
          [(get w [:css-known-standard :alt 262] 100)
            (gen/tuple
              (gen/return "scroll-margin-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-inline-end g))]
          [(get w [:css-known-standard :alt 263] 100)
            (gen/tuple
              (gen/return "scroll-margin-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-inline-start g))]
          [(get w [:css-known-standard :alt 264] 100)
            (gen/tuple
              (gen/return "scroll-margin-left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-left g))]
          [(get w [:css-known-standard :alt 265] 100)
            (gen/tuple
              (gen/return "scroll-margin-right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-right g))]
          [(get w [:css-known-standard :alt 266] 100)
            (gen/tuple
              (gen/return "scroll-margin-top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-margin-top g))]
          [(get w [:css-known-standard :alt 267] 100)
            (gen/tuple
              (gen/return "scroll-padding")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding g))]
          [(get w [:css-known-standard :alt 268] 100)
            (gen/tuple
              (gen/return "scroll-padding-block")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-block g))]
          [(get w [:css-known-standard :alt 269] 100)
            (gen/tuple
              (gen/return "scroll-padding-block-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-block-end g))]
          [(get w [:css-known-standard :alt 270] 100)
            (gen/tuple
              (gen/return "scroll-padding-block-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-block-start g))]
          [(get w [:css-known-standard :alt 271] 100)
            (gen/tuple
              (gen/return "scroll-padding-bottom")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-bottom g))]
          [(get w [:css-known-standard :alt 272] 100)
            (gen/tuple
              (gen/return "scroll-padding-inline")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-inline g))]
          [(get w [:css-known-standard :alt 273] 100)
            (gen/tuple
              (gen/return "scroll-padding-inline-end")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-inline-end g))]
          [(get w [:css-known-standard :alt 274] 100)
            (gen/tuple
              (gen/return "scroll-padding-inline-start")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-inline-start g))]
          [(get w [:css-known-standard :alt 275] 100)
            (gen/tuple
              (gen/return "scroll-padding-left")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-left g))]
          [(get w [:css-known-standard :alt 276] 100)
            (gen/tuple
              (gen/return "scroll-padding-right")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-right g))]
          [(get w [:css-known-standard :alt 277] 100)
            (gen/tuple
              (gen/return "scroll-padding-top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-padding-top g))]
          [(get w [:css-known-standard :alt 278] 100)
            (gen/tuple
              (gen/return "scroll-snap-align")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-snap-align g))]
          [(get w [:css-known-standard :alt 279] 100)
            (gen/tuple
              (gen/return "scroll-snap-stop")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-snap-stop g))]
          [(get w [:css-known-standard :alt 280] 100)
            (gen/tuple
              (gen/return "scroll-snap-type")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scroll-snap-type g))]
          [(get w [:css-known-standard :alt 281] 100)
            (gen/tuple
              (gen/return "scrollbar-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scrollbar-color g))]
          [(get w [:css-known-standard :alt 282] 100)
            (gen/tuple
              (gen/return "scrollbar-width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-scrollbar-width g))]
          [(get w [:css-known-standard :alt 283] 100)
            (gen/tuple
              (gen/return "shape-image-threshold")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-shape-image-threshold g))]
          [(get w [:css-known-standard :alt 284] 100)
            (gen/tuple
              (gen/return "shape-margin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-shape-margin g))]
          [(get w [:css-known-standard :alt 285] 100)
            (gen/tuple
              (gen/return "shape-outside")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-shape-outside g))]
          [(get w [:css-known-standard :alt 286] 100)
            (gen/tuple
              (gen/return "tab-size")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-tab-size g))]
          [(get w [:css-known-standard :alt 287] 100)
            (gen/tuple
              (gen/return "table-layout")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-table-layout g))]
          [(get w [:css-known-standard :alt 288] 100)
            (gen/tuple
              (gen/return "text-align")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-align g))]
          [(get w [:css-known-standard :alt 289] 100)
            (gen/tuple
              (gen/return "text-align-last")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-align-last g))]
          [(get w [:css-known-standard :alt 290] 100)
            (gen/tuple
              (gen/return "text-combine-upright")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-combine-upright g))]
          [(get w [:css-known-standard :alt 291] 100)
            (gen/tuple
              (gen/return "text-decoration")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-decoration g))]
          [(get w [:css-known-standard :alt 292] 100)
            (gen/tuple
              (gen/return "text-decoration-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-decoration-color g))]
          [(get w [:css-known-standard :alt 293] 100)
            (gen/tuple
              (gen/return "text-decoration-line")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-decoration-line g))]
          [(get w [:css-known-standard :alt 294] 100)
            (gen/tuple
              (gen/return "text-decoration-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-decoration-style g))]
          [(get w [:css-known-standard :alt 295] 100)
            (gen/tuple
              (gen/return "text-emphasis")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-emphasis g))]
          [(get w [:css-known-standard :alt 296] 100)
            (gen/tuple
              (gen/return "text-emphasis-color")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-emphasis-color g))]
          [(get w [:css-known-standard :alt 297] 100)
            (gen/tuple
              (gen/return "text-emphasis-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-emphasis-position g))]
          [(get w [:css-known-standard :alt 298] 100)
            (gen/tuple
              (gen/return "text-emphasis-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-emphasis-style g))]
          [(get w [:css-known-standard :alt 299] 100)
            (gen/tuple
              (gen/return "text-indent")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-indent g))]
          [(get w [:css-known-standard :alt 300] 100)
            (gen/tuple
              (gen/return "text-justify")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-justify g))]
          [(get w [:css-known-standard :alt 301] 100)
            (gen/tuple
              (gen/return "text-orientation")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-orientation g))]
          [(get w [:css-known-standard :alt 302] 100)
            (gen/tuple
              (gen/return "text-overflow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-overflow g))]
          [(get w [:css-known-standard :alt 303] 100)
            (gen/tuple
              (gen/return "text-rendering")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-rendering g))]
          [(get w [:css-known-standard :alt 304] 100)
            (gen/tuple
              (gen/return "text-shadow")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-shadow g))]
          [(get w [:css-known-standard :alt 305] 100)
            (gen/tuple
              (gen/return "text-transform")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-transform g))]
          [(get w [:css-known-standard :alt 306] 100)
            (gen/tuple
              (gen/return "text-underline-position")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-text-underline-position g))]
          [(get w [:css-known-standard :alt 307] 100)
            (gen/tuple
              (gen/return "top")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-top g))]
          [(get w [:css-known-standard :alt 308] 100)
            (gen/tuple
              (gen/return "touch-action")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-touch-action g))]
          [(get w [:css-known-standard :alt 309] 100)
            (gen/tuple
              (gen/return "transform")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transform g))]
          [(get w [:css-known-standard :alt 310] 100)
            (gen/tuple
              (gen/return "transform-box")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transform-box g))]
          [(get w [:css-known-standard :alt 311] 100)
            (gen/tuple
              (gen/return "transform-origin")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transform-origin g))]
          [(get w [:css-known-standard :alt 312] 100)
            (gen/tuple
              (gen/return "transform-style")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transform-style g))]
          [(get w [:css-known-standard :alt 313] 100)
            (gen/tuple
              (gen/return "transition")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transition g))]
          [(get w [:css-known-standard :alt 314] 100)
            (gen/tuple
              (gen/return "transition-delay")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transition-delay g))]
          [(get w [:css-known-standard :alt 315] 100)
            (gen/tuple
              (gen/return "transition-duration")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transition-duration g))]
          [(get w [:css-known-standard :alt 316] 100)
            (gen/tuple
              (gen/return "transition-property")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transition-property g))]
          [(get w [:css-known-standard :alt 317] 100)
            (gen/tuple
              (gen/return "transition-timing-function")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-transition-timing-function g))]
          [(get w [:css-known-standard :alt 318] 100)
            (gen/tuple
              (gen/return "translate")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-translate g))]
          [(get w [:css-known-standard :alt 319] 100)
            (gen/tuple
              (gen/return "unicode-bidi")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-unicode-bidi g))]
          [(get w [:css-known-standard :alt 320] 100)
            (gen/tuple
              (gen/return "vertical-align")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-vertical-align g))]
          [(get w [:css-known-standard :alt 321] 100)
            (gen/tuple
              (gen/return "visibility")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-visibility g))]
          [(get w [:css-known-standard :alt 322] 100)
            (gen/tuple
              (gen/return "white-space")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-white-space g))]
          [(get w [:css-known-standard :alt 323] 100)
            (gen/tuple
              (gen/return "widows")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-widows g))]
          [(get w [:css-known-standard :alt 324] 100)
            (gen/tuple
              (gen/return "width")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-width g))]
          [(get w [:css-known-standard :alt 325] 100)
            (gen/tuple
              (gen/return "will-change")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-will-change g))]
          [(get w [:css-known-standard :alt 326] 100)
            (gen/tuple
              (gen/return "word-break")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-word-break g))]
          [(get w [:css-known-standard :alt 327] 100)
            (gen/tuple
              (gen/return "word-spacing")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-word-spacing g))]
          [(get w [:css-known-standard :alt 328] 100)
            (gen/tuple
              (gen/return "word-wrap")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-word-wrap g))]
          [(get w [:css-known-standard :alt 329] 100)
            (gen/tuple
              (gen/return "writing-mode")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-writing-mode g))]
          [(get w [:css-known-standard :alt 330] 100)
            (gen/tuple
              (gen/return "z-index")
              (gen/return " ")
              (gen/return ":")
              (gen/return " ")
              (:prop-z-index g))]])
        g (assoc g :css-known-standard gen-css-known-standard)

        gen-nonprop-mask-attachment
        (gen/return "STUB_mask_attachment")
        g (assoc g :nonprop-mask-attachment gen-nonprop-mask-attachment)

        gen-nonprop-attr-fallback
        (gen/return "STUB_attr_fallback")
        g (assoc g :nonprop-attr-fallback gen-nonprop-attr-fallback)

        gen-nonprop-attr-name
        (gen/return "STUB_attr_name")
        g (assoc g :nonprop-attr-name gen-nonprop-attr-name)

        gen-nonprop-type-or-unit
        (igen/freq :nonprop-type-or-unit [
          [(get w [:nonprop-type-or-unit :alt 0] 100)
            (gen/return "string ")]
          [(get w [:nonprop-type-or-unit :alt 1] 100)
            (gen/return "integer ")]
          [(get w [:nonprop-type-or-unit :alt 2] 100)
            (gen/return "color ")]
          [(get w [:nonprop-type-or-unit :alt 3] 100)
            (gen/return "url ")]
          [(get w [:nonprop-type-or-unit :alt 4] 100)
            (gen/return "integer ")]
          [(get w [:nonprop-type-or-unit :alt 5] 100)
            (gen/return "number ")]
          [(get w [:nonprop-type-or-unit :alt 6] 100)
            (gen/return "length ")]
          [(get w [:nonprop-type-or-unit :alt 7] 100)
            (gen/return "angle ")]
          [(get w [:nonprop-type-or-unit :alt 8] 100)
            (gen/return "time ")]
          [(get w [:nonprop-type-or-unit :alt 9] 100)
            (gen/return "frequency ")]
          [(get w [:nonprop-type-or-unit :alt 10] 100)
            (gen/return "em ")]
          [(get w [:nonprop-type-or-unit :alt 11] 100)
            (gen/return "ex ")]
          [(get w [:nonprop-type-or-unit :alt 12] 100)
            (gen/return "px ")]
          [(get w [:nonprop-type-or-unit :alt 13] 100)
            (gen/return "rem ")]
          [(get w [:nonprop-type-or-unit :alt 14] 100)
            (gen/return "vw ")]
          [(get w [:nonprop-type-or-unit :alt 15] 100)
            (gen/return "vh ")]
          [(get w [:nonprop-type-or-unit :alt 16] 100)
            (gen/return "vmin ")]
          [(get w [:nonprop-type-or-unit :alt 17] 100)
            (gen/return "vmax ")]
          [(get w [:nonprop-type-or-unit :alt 18] 100)
            (gen/return "mm ")]
          [(get w [:nonprop-type-or-unit :alt 19] 100)
            (gen/return "q ")]
          [(get w [:nonprop-type-or-unit :alt 20] 100)
            (gen/return "cm ")]
          [(get w [:nonprop-type-or-unit :alt 21] 100)
            (gen/return "in ")]
          [(get w [:nonprop-type-or-unit :alt 22] 100)
            (gen/return "pt ")]
          [(get w [:nonprop-type-or-unit :alt 23] 100)
            (gen/return "pc ")]
          [(get w [:nonprop-type-or-unit :alt 24] 100)
            (gen/return "deg ")]
          [(get w [:nonprop-type-or-unit :alt 25] 100)
            (gen/return "grad ")]
          [(get w [:nonprop-type-or-unit :alt 26] 100)
            (gen/return "rad ")]
          [(get w [:nonprop-type-or-unit :alt 27] 100)
            (gen/return "ms ")]
          [(get w [:nonprop-type-or-unit :alt 28] 100)
            (gen/return "s ")]
          [(get w [:nonprop-type-or-unit :alt 29] 100)
            (gen/return "Hz ")]
          [(get w [:nonprop-type-or-unit :alt 30] 100)
            (gen/return "kHz ")]
          [(get w [:nonprop-type-or-unit :alt 31] 100)
            (gen/return "% ")]])
        g (assoc g :nonprop-type-or-unit gen-nonprop-type-or-unit)

        gen-func-attr
        (gen/tuple
          (gen/return "attr ")
          (gen/return "( ")
          (:nonprop-attr-name g)
          (igen/freq :func-attr [
            [(get w [:func-attr :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-attr :cat 3 :opt 0] 100)
              (:nonprop-type-or-unit g)]])
          (igen/freq :func-attr [
            [(get w [:func-attr :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-attr :cat 4 :opt 0] 100)
              (gen/tuple
                (gen/return ", ")
                (:nonprop-attr-fallback g))]])
          (gen/return ") "))
        g (assoc g :func-attr gen-func-attr)

        gen-nonprop-ident-token
        (gen/return "STUB_ident_token")
        g (assoc g :nonprop-ident-token gen-nonprop-ident-token)

        gen-nonprop-ns-prefix
        (gen/tuple
          (igen/freq :nonprop-ns-prefix [
            [(get w [:nonprop-ns-prefix :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-ns-prefix :cat 0 :opt 0] 100)
              (igen/freq :nonprop-ns-prefix [
                [(get w [:nonprop-ns-prefix :cat 0 :opt 0 :alt 0] 100)
                  (:nonprop-ident-token g)]
                [(get w [:nonprop-ns-prefix :cat 0 :opt 0 :alt 1] 100)
                  (gen/return "* ")]])]])
          (gen/return "| "))
        g (assoc g :nonprop-ns-prefix gen-nonprop-ns-prefix)

        gen-nonprop-wq-name
        (gen/tuple
          (igen/freq :nonprop-wq-name [
            [(get w [:nonprop-wq-name :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-wq-name :cat 0 :opt 0] 100)
              (:nonprop-ns-prefix g)]])
          (:nonprop-ident-token g))
        g (assoc g :nonprop-wq-name gen-nonprop-wq-name)

        gen-nonprop-type-selector
        (igen/freq :nonprop-type-selector [
          [(get w [:nonprop-type-selector :alt 0] 100)
            (:nonprop-wq-name g)]
          [(get w [:nonprop-type-selector :alt 1] 100)
            (gen/tuple
              (igen/freq :nonprop-type-selector [
                [(get w [:nonprop-type-selector :alt 1 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-type-selector :alt 1 :cat 0 :opt 0] 100)
                  (:nonprop-ns-prefix g)]])
              (gen/return "* "))]])
        g (assoc g :nonprop-type-selector gen-nonprop-type-selector)

        gen-nonprop-function-token
        (gen/return "STUB_flex_function_token")
        g (assoc g :nonprop-function-token gen-nonprop-function-token)

        gen-nonprop-pseudo-class-selector
        (igen/freq :nonprop-pseudo-class-selector [
          [(get w [:nonprop-pseudo-class-selector :alt 0] 100)
            (gen/tuple
              (gen/return ": ")
              (:nonprop-ident-token g))]
          [(get w [:nonprop-pseudo-class-selector :alt 1] 100)
            (gen/tuple
              (gen/return ": ")
              (:nonprop-function-token g)
              (:nonprop-any-value g)
              (gen/return ") "))]])
        g (assoc g :nonprop-pseudo-class-selector gen-nonprop-pseudo-class-selector)

        gen-nonprop-pseudo-element-selector
        (gen/tuple
          (gen/return ": ")
          (:nonprop-pseudo-class-selector g))
        g (assoc g :nonprop-pseudo-element-selector gen-nonprop-pseudo-element-selector)

        gen-nonprop-string-token
        (gen/return "STUB_string_token")
        g (assoc g :nonprop-string-token gen-nonprop-string-token)

        gen-nonprop-class-selector
        (gen/tuple
          (gen/return ". ")
          (:nonprop-ident-token g))
        g (assoc g :nonprop-class-selector gen-nonprop-class-selector)

        gen-nonprop-attr-matcher
        (gen/tuple
          (igen/freq :nonprop-attr-matcher [
            [(get w [:nonprop-attr-matcher :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-attr-matcher :cat 0 :opt 0] 100)
              (igen/freq :nonprop-attr-matcher [
                [(get w [:nonprop-attr-matcher :cat 0 :opt 0 :alt 0] 100)
                  (gen/return "~ ")]
                [(get w [:nonprop-attr-matcher :cat 0 :opt 0 :alt 1] 100)
                  (gen/return "| ")]
                [(get w [:nonprop-attr-matcher :cat 0 :opt 0 :alt 2] 100)
                  (gen/return "^ ")]
                [(get w [:nonprop-attr-matcher :cat 0 :opt 0 :alt 3] 100)
                  (gen/return "$ ")]
                [(get w [:nonprop-attr-matcher :cat 0 :opt 0 :alt 4] 100)
                  (gen/return "* ")]])]])
          (gen/return "= "))
        g (assoc g :nonprop-attr-matcher gen-nonprop-attr-matcher)

        gen-nonprop-attr-modifier
        (igen/freq :nonprop-attr-modifier [
          [(get w [:nonprop-attr-modifier :alt 0] 100)
            (gen/return "i ")]
          [(get w [:nonprop-attr-modifier :alt 1] 100)
            (gen/return "s ")]])
        g (assoc g :nonprop-attr-modifier gen-nonprop-attr-modifier)

        gen-nonprop-id-selector
        (:nonprop-custom-ident g)
        g (assoc g :nonprop-id-selector gen-nonprop-id-selector)

        gen-nonprop-attribute-selector
        (igen/freq :nonprop-attribute-selector [
          [(get w [:nonprop-attribute-selector :alt 0] 100)
            (gen/tuple
              (gen/return "[ ")
              (:nonprop-wq-name g)
              (gen/return "] "))]
          [(get w [:nonprop-attribute-selector :alt 1] 100)
            (gen/tuple
              (gen/return "[ ")
              (:nonprop-wq-name g)
              (:nonprop-attr-matcher g)
              (igen/freq :nonprop-attribute-selector [
                [(get w [:nonprop-attribute-selector :alt 1 :cat 3 :alt 0] 100)
                  (:nonprop-string-token g)]
                [(get w [:nonprop-attribute-selector :alt 1 :cat 3 :alt 1] 100)
                  (:nonprop-ident-token g)]])
              (igen/freq :nonprop-attribute-selector [
                [(get w [:nonprop-attribute-selector :alt 1 :cat 4 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-attribute-selector :alt 1 :cat 4 :opt 0] 100)
                  (:nonprop-attr-modifier g)]])
              (gen/return "] "))]])
        g (assoc g :nonprop-attribute-selector gen-nonprop-attribute-selector)

        gen-nonprop-subclass-selector
        (igen/freq :nonprop-subclass-selector [
          [(get w [:nonprop-subclass-selector :alt 0] 100)
            (:nonprop-id-selector g)]
          [(get w [:nonprop-subclass-selector :alt 1] 100)
            (:nonprop-class-selector g)]
          [(get w [:nonprop-subclass-selector :alt 2] 100)
            (:nonprop-attribute-selector g)]
          [(get w [:nonprop-subclass-selector :alt 3] 100)
            (:nonprop-pseudo-class-selector g)]])
        g (assoc g :nonprop-subclass-selector gen-nonprop-subclass-selector)

        gen-nonprop-compound-selector
        (gen/tuple
          (igen/freq :nonprop-compound-selector [
            [(get w [:nonprop-compound-selector :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-compound-selector :cat 0 :opt 0] 100)
              (:nonprop-type-selector g)]])
          (igen/freq :nonprop-compound-selector [
            [(get w [:nonprop-compound-selector :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-compound-selector :cat 1 :star 0] 100)
              (igen/vector+
                (:nonprop-subclass-selector g))]])
          (igen/freq :nonprop-compound-selector [
            [(get w [:nonprop-compound-selector :cat 2 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-compound-selector :cat 2 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (:nonprop-pseudo-element-selector g)
                  (igen/freq :nonprop-compound-selector [
                    [(get w [:nonprop-compound-selector :cat 2 :star 0 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-compound-selector :cat 2 :star 0 :cat 1 :star 0] 100)
                      (igen/vector+
                        (:nonprop-pseudo-class-selector g))]])))]]))
        g (assoc g :nonprop-compound-selector gen-nonprop-compound-selector)

        gen-nonprop-complex-selector
        (gen/tuple
          (:nonprop-compound-selector g)
          (igen/freq :nonprop-complex-selector [
            [(get w [:nonprop-complex-selector :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-complex-selector :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (igen/freq :nonprop-complex-selector [
                    [(get w [:nonprop-complex-selector :cat 1 :star 0 :cat 0 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-complex-selector :cat 1 :star 0 :cat 0 :opt 0] 100)
                      (:nonprop-combinator g)]])
                  (:nonprop-compound-selector g)))]]))
        g (assoc g :nonprop-complex-selector gen-nonprop-complex-selector)

        gen-nonprop-relative-selector
        (gen/tuple
          (igen/freq :nonprop-relative-selector [
            [(get w [:nonprop-relative-selector :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-relative-selector :cat 0 :opt 0] 100)
              (:nonprop-combinator g)]])
          (:nonprop-complex-selector g))
        g (assoc g :nonprop-relative-selector gen-nonprop-relative-selector)

        gen-nonprop-relative-selector-list
        (gen/tuple
          (:nonprop-relative-selector g)
          (igen/freq :nonprop-relative-selector-list [
            [(get w [:nonprop-relative-selector-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-relative-selector-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-relative-selector g)))]]))
        g (assoc g :nonprop-relative-selector-list gen-nonprop-relative-selector-list)

        gen-nonprop-all
        (:prop-all g)
        g (assoc g :nonprop-all gen-nonprop-all)

        gen-nonprop-page-margin-box-type
        (igen/freq :nonprop-page-margin-box-type [
          [(get w [:nonprop-page-margin-box-type :alt 0] 100)
            (gen/return "@top-left-corner ")]
          [(get w [:nonprop-page-margin-box-type :alt 1] 100)
            (gen/return "@top-left ")]
          [(get w [:nonprop-page-margin-box-type :alt 2] 100)
            (gen/return "@top-center ")]
          [(get w [:nonprop-page-margin-box-type :alt 3] 100)
            (gen/return "@top-right ")]
          [(get w [:nonprop-page-margin-box-type :alt 4] 100)
            (gen/return "@top-right-corner ")]
          [(get w [:nonprop-page-margin-box-type :alt 5] 100)
            (gen/return "@bottom-left-corner ")]
          [(get w [:nonprop-page-margin-box-type :alt 6] 100)
            (gen/return "@bottom-left ")]
          [(get w [:nonprop-page-margin-box-type :alt 7] 100)
            (gen/return "@bottom-center ")]
          [(get w [:nonprop-page-margin-box-type :alt 8] 100)
            (gen/return "@bottom-right ")]
          [(get w [:nonprop-page-margin-box-type :alt 9] 100)
            (gen/return "@bottom-right-corner ")]
          [(get w [:nonprop-page-margin-box-type :alt 10] 100)
            (gen/return "@left-top ")]
          [(get w [:nonprop-page-margin-box-type :alt 11] 100)
            (gen/return "@left-middle ")]
          [(get w [:nonprop-page-margin-box-type :alt 12] 100)
            (gen/return "@left-bottom ")]
          [(get w [:nonprop-page-margin-box-type :alt 13] 100)
            (gen/return "@right-top ")]
          [(get w [:nonprop-page-margin-box-type :alt 14] 100)
            (gen/return "@right-middle ")]
          [(get w [:nonprop-page-margin-box-type :alt 15] 100)
            (gen/return "@right-bottom ")]])
        g (assoc g :nonprop-page-margin-box-type gen-nonprop-page-margin-box-type)

        gen-nonprop-declaration-list
        (gen/return "STUB_declaration_list")
        g (assoc g :nonprop-declaration-list gen-nonprop-declaration-list)

        gen-nonprop-page-margin-box
        (gen/tuple
          (:nonprop-page-margin-box-type g)
          (gen/return "{ ")
          (:nonprop-declaration-list g)
          (gen/return "} "))
        g (assoc g :nonprop-page-margin-box gen-nonprop-page-margin-box)

        gen-func-repeating-linear-gradient
        (gen/tuple
          (gen/return "repeating-linear-gradient ")
          (gen/return "( ")
          (igen/freq :func-repeating-linear-gradient [
            [(get w [:func-repeating-linear-gradient :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-repeating-linear-gradient :cat 2 :opt 0] 100)
              (igen/freq :func-repeating-linear-gradient [
                [(get w [:func-repeating-linear-gradient :cat 2 :opt 0 :alt 0] 100)
                  (:nonprop-angle g)]
                [(get w [:func-repeating-linear-gradient :cat 2 :opt 0 :alt 1] 100)
                  (gen/tuple
                    (gen/return "to ")
                    (:nonprop-side-or-corner g))]])]])
          (gen/return ", ")
          (:nonprop-color-stop-list g)
          (gen/return ") "))
        g (assoc g :func-repeating-linear-gradient gen-func-repeating-linear-gradient)

        gen-nonprop-angular-color-hint
        (:nonprop-angle-percentage g)
        g (assoc g :nonprop-angular-color-hint gen-nonprop-angular-color-hint)

        gen-nonprop-color-stop-angle
        (igen/freq :nonprop-color-stop-angle [
          [(get w [:nonprop-color-stop-angle :alt 0] 100)
            (:nonprop-angle-percentage g)]
          [(get w [:nonprop-color-stop-angle :alt 1] 100)
            (gen/tuple
              (:nonprop-angle-percentage g)
              (gen/return " ")
              (:nonprop-angle-percentage g))]])
        g (assoc g :nonprop-color-stop-angle gen-nonprop-color-stop-angle)

        gen-nonprop-angular-color-stop
        (gen/tuple
          (:nonprop-color g)
          (igen/freq :nonprop-angular-color-stop [
            [(get w [:nonprop-angular-color-stop :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-angular-color-stop :cat 1 :opt 0] 100)
              (:nonprop-color-stop-angle g)]]))
        g (assoc g :nonprop-angular-color-stop gen-nonprop-angular-color-stop)

        gen-nonprop-angular-color-stop-list
        (gen/tuple
          (gen/tuple
            (:nonprop-angular-color-stop g)
            (igen/freq :nonprop-angular-color-stop-list [
              [(get w [:nonprop-angular-color-stop-list :cat 0 :cat 1 :opt nil] 100)
                (gen/return "")]
              [(get w [:nonprop-angular-color-stop-list :cat 0 :cat 1 :opt 0] 100)
                (gen/tuple
                  (gen/return ", ")
                  (:nonprop-angular-color-hint g))]]))
          (igen/freq :nonprop-angular-color-stop-list [
            [(get w [:nonprop-angular-color-stop-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-angular-color-stop-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (gen/tuple
                    (:nonprop-angular-color-stop g)
                    (igen/freq :nonprop-angular-color-stop-list [
                      [(get w [:nonprop-angular-color-stop-list :cat 1 :star 0 :cat 2 :cat 1 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:nonprop-angular-color-stop-list :cat 1 :star 0 :cat 2 :cat 1 :opt 0] 100)
                        (gen/tuple
                          (gen/return ", ")
                          (:nonprop-angular-color-hint g))]]))))]])
          (gen/return ", ")
          (:nonprop-angular-color-stop g))
        g (assoc g :nonprop-angular-color-stop-list gen-nonprop-angular-color-stop-list)

        gen-func-radial-gradient
        (gen/tuple
          (gen/return "radial-gradient ")
          (gen/return "( ")
          (igen/freq :func-radial-gradient [
            [(get w [:func-radial-gradient :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-radial-gradient :cat 2 :opt 0] 100)
              (igen/vector+
                (igen/freq :func-radial-gradient [
                  [(get w [:func-radial-gradient :cat 2 :opt 0 :plus 0 :alt 0] 100)
                    (:nonprop-ending-shape g)]
                  [(get w [:func-radial-gradient :cat 2 :opt 0 :plus 0 :alt 1] 100)
                    (:nonprop-size g)]]))]])
          (igen/freq :func-radial-gradient [
            [(get w [:func-radial-gradient :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-radial-gradient :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "at ")
                (:nonprop-position g))]])
          (gen/return ", ")
          (:nonprop-color-stop-list g)
          (gen/return ") "))
        g (assoc g :func-radial-gradient gen-func-radial-gradient)

        gen-func-conic-gradient
        (gen/tuple
          (gen/return "conic-gradient ")
          (gen/return "( ")
          (igen/freq :func-conic-gradient [
            [(get w [:func-conic-gradient :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-conic-gradient :cat 2 :opt 0] 100)
              (gen/tuple
                (gen/return "from ")
                (:nonprop-angle g))]])
          (igen/freq :func-conic-gradient [
            [(get w [:func-conic-gradient :cat 3 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-conic-gradient :cat 3 :opt 0] 100)
              (gen/tuple
                (gen/return "at ")
                (:nonprop-position g))]])
          (gen/return ",")
          (gen/return " ")
          (:nonprop-angular-color-stop-list g)
          (gen/return ") "))
        g (assoc g :func-conic-gradient gen-func-conic-gradient)

        gen-nonprop-gradient
        (igen/freq :nonprop-gradient [
          [(get w [:nonprop-gradient :alt 0] 100)
            (:func-linear-gradient g)]
          [(get w [:nonprop-gradient :alt 1] 100)
            (:func-repeating-linear-gradient g)]
          [(get w [:nonprop-gradient :alt 2] 100)
            (:func-radial-gradient g)]
          [(get w [:nonprop-gradient :alt 3] 100)
            (:func-repeating-radial-gradient g)]
          [(get w [:nonprop-gradient :alt 4] 100)
            (:func-conic-gradient g)]])
        g (assoc g :nonprop-gradient gen-nonprop-gradient)

        gen-css-comment
        (gen/return "/* CSS comment */ ")
        g (assoc g :css-comment gen-css-comment)

        gen-css-declaration
        (igen/freq :css-declaration [
          [(get w [:css-declaration :alt 0] 100)
            (gen/tuple
              (:css-known-standard g)
              (igen/freq :css-declaration [
                [(get w [:css-declaration :alt 0 :cat 1 :alt 0] 100)
                  (gen/return "")]
                [(get w [:css-declaration :alt 0 :cat 1 :alt 1] 100)
                  (gen/return "!important ")]]))]
          [(get w [:css-declaration :alt 1] 100)
            (:css-comment g)]])
        g (assoc g :css-declaration gen-css-declaration)

        gen-nonprop-declaration
        (:css-declaration g)
        g (assoc g :nonprop-declaration gen-nonprop-declaration)

        gen-nonprop-supports-selector-fn
        (gen/tuple
          (gen/return "selector ")
          (gen/return "( ")
          (:nonprop-complex-selector g)
          (gen/return ") "))
        g (assoc g :nonprop-supports-selector-fn gen-nonprop-supports-selector-fn)

        gen-nonprop-supports-decl
        (gen/tuple
          (gen/return "( ")
          (:nonprop-declaration g)
          (gen/return ") "))
        g (assoc g :nonprop-supports-decl gen-nonprop-supports-decl)

        gen-nonprop-supports-feature
        (igen/freq :nonprop-supports-feature [
          [(get w [:nonprop-supports-feature :alt 0] 100)
            (:nonprop-supports-decl g)]
          [(get w [:nonprop-supports-feature :alt 1] 100)
            (:nonprop-supports-selector-fn g)]])
        g (assoc g :nonprop-supports-feature gen-nonprop-supports-feature)]
    g))

(defn- css3-generators-part-12 [gmap weights]
  (let [g gmap
        w weights

        gen-nonprop-general-enclosed
        (igen/freq :nonprop-general-enclosed [
          [(get w [:nonprop-general-enclosed :alt 0] 100)
            (gen/tuple
              (:nonprop-function-token g)
              (:nonprop-any-value g)
              (gen/return ") "))]
          [(get w [:nonprop-general-enclosed :alt 1] 100)
            (gen/tuple
              (gen/return "( ")
              (:nonprop-ident g)
              (:nonprop-any-value g)
              (gen/return ") "))]])
        g (assoc g :nonprop-general-enclosed gen-nonprop-general-enclosed)

        gen-nonprop-supports-condition
        (gen/recursive-gen
          (fn [inner]
            (igen/freq :nonprop-supports-condition [
              [(get w [:nonprop-supports-condition :alt 0] 100)
                (gen/tuple
                  (gen/return "not ")
                  (igen/freq :nonprop-supports-condition [
                    [(get w [:nonprop-supports-condition :alt 0 :cat 1 :alt 0] 100)
                      (gen/tuple
                        (gen/return "( ")
                        inner
                        (gen/return ") "))]
                    [(get w [:nonprop-supports-condition :alt 0 :cat 1 :alt 1] 100)
                      (:nonprop-supports-feature g)]
                    [(get w [:nonprop-supports-condition :alt 0 :cat 1 :alt 2] 100)
                      (:nonprop-general-enclosed g)]]))]
              [(get w [:nonprop-supports-condition :alt 1] 100)
                (gen/tuple
                  (igen/freq :nonprop-supports-condition [
                    [(get w [:nonprop-supports-condition :alt 1 :cat 0 :alt 0] 100)
                      (gen/tuple
                        (gen/return "( ")
                        inner
                        (gen/return ") "))]
                    [(get w [:nonprop-supports-condition :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-supports-feature g)]
                    [(get w [:nonprop-supports-condition :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-general-enclosed g)]])
                  (igen/freq :nonprop-supports-condition [
                    [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return "and ")
                          (igen/freq :nonprop-supports-condition [
                            [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0 :cat 1 :alt 0] 100)
                              (gen/tuple
                                (gen/return "( ")
                                inner
                                (gen/return ") "))]
                            [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0 :cat 1 :alt 1] 100)
                              (:nonprop-supports-feature g)]
                            [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0 :cat 1 :alt 2] 100)
                              (:nonprop-general-enclosed g)]])))]]))]
              [(get w [:nonprop-supports-condition :alt 2] 100)
                (gen/tuple
                  (igen/freq :nonprop-supports-condition [
                    [(get w [:nonprop-supports-condition :alt 2 :cat 0 :alt 0] 100)
                      (gen/tuple
                        (gen/return "( ")
                        inner
                        (gen/return ") "))]
                    [(get w [:nonprop-supports-condition :alt 2 :cat 0 :alt 1] 100)
                      (:nonprop-supports-feature g)]
                    [(get w [:nonprop-supports-condition :alt 2 :cat 0 :alt 2] 100)
                      (:nonprop-general-enclosed g)]])
                  (igen/freq :nonprop-supports-condition [
                    [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0] 100)
                      (igen/vector+
                        (gen/tuple
                          (gen/return "or ")
                          (igen/freq :nonprop-supports-condition [
                            [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0 :cat 1 :alt 0] 100)
                              (gen/tuple
                                (gen/return "( ")
                                inner
                                (gen/return ") "))]
                            [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0 :cat 1 :alt 1] 100)
                              (:nonprop-supports-feature g)]
                            [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0 :cat 1 :alt 2] 100)
                              (:nonprop-general-enclosed g)]])))]]))]]))
          (igen/freq :nonprop-supports-condition [
            [(get w [:nonprop-supports-condition :alt 0] 100)
              (gen/tuple
                (gen/return "not ")
                (igen/freq :nonprop-supports-condition [
                  [(get w [:nonprop-supports-condition :alt 0 :cat 1 :alt 0] 100)
                    (:nonprop-supports-feature g)]
                  [(get w [:nonprop-supports-condition :alt 0 :cat 1 :alt 1] 100)
                    (:nonprop-general-enclosed g)]]))]
            [(get w [:nonprop-supports-condition :alt 1] 100)
              (gen/tuple
                (igen/freq :nonprop-supports-condition [
                  [(get w [:nonprop-supports-condition :alt 1 :cat 0 :alt 0] 100)
                    (:nonprop-supports-feature g)]
                  [(get w [:nonprop-supports-condition :alt 1 :cat 0 :alt 1] 100)
                    (:nonprop-general-enclosed g)]])
                (igen/freq :nonprop-supports-condition [
                  [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return "and ")
                        (igen/freq :nonprop-supports-condition [
                          [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0 :cat 1 :alt 0] 100)
                            (:nonprop-supports-feature g)]
                          [(get w [:nonprop-supports-condition :alt 1 :cat 1 :star 0 :cat 1 :alt 1] 100)
                            (:nonprop-general-enclosed g)]])))]]))]
            [(get w [:nonprop-supports-condition :alt 2] 100)
              (gen/tuple
                (igen/freq :nonprop-supports-condition [
                  [(get w [:nonprop-supports-condition :alt 2 :cat 0 :alt 0] 100)
                    (:nonprop-supports-feature g)]
                  [(get w [:nonprop-supports-condition :alt 2 :cat 0 :alt 1] 100)
                    (:nonprop-general-enclosed g)]])
                (igen/freq :nonprop-supports-condition [
                  [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0] 100)
                    (igen/vector+
                      (gen/tuple
                        (gen/return "or ")
                        (igen/freq :nonprop-supports-condition [
                          [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0 :cat 1 :alt 0] 100)
                            (:nonprop-supports-feature g)]
                          [(get w [:nonprop-supports-condition :alt 2 :cat 1 :star 0 :cat 1 :alt 1] 100)
                            (:nonprop-general-enclosed g)]])))]]))]]))
        g (assoc g :nonprop-supports-condition gen-nonprop-supports-condition)

        gen-nonprop-supports-in-parens
        (igen/freq :nonprop-supports-in-parens [
          [(get w [:nonprop-supports-in-parens :alt 0] 100)
            (gen/tuple
              (gen/return "( ")
              (:nonprop-supports-condition g)
              (gen/return ") "))]
          [(get w [:nonprop-supports-in-parens :alt 1] 100)
            (:nonprop-supports-feature g)]
          [(get w [:nonprop-supports-in-parens :alt 2] 100)
            (:nonprop-general-enclosed g)]])
        g (assoc g :nonprop-supports-in-parens gen-nonprop-supports-in-parens)

        gen-nonprop-pseudo-page
        (gen/tuple
          (gen/return ": ")
          (igen/freq :nonprop-pseudo-page [
            [(get w [:nonprop-pseudo-page :cat 1 :alt 0] 100)
              (gen/return "left ")]
            [(get w [:nonprop-pseudo-page :cat 1 :alt 1] 100)
              (gen/return "right ")]
            [(get w [:nonprop-pseudo-page :cat 1 :alt 2] 100)
              (gen/return "first ")]
            [(get w [:nonprop-pseudo-page :cat 1 :alt 3] 100)
              (gen/return "blank ")]]))
        g (assoc g :nonprop-pseudo-page gen-nonprop-pseudo-page)

        gen-nonprop-page-selector
        (igen/freq :nonprop-page-selector [
          [(get w [:nonprop-page-selector :alt 0] 100)
            (igen/vector+
              (:nonprop-pseudo-page g))]
          [(get w [:nonprop-page-selector :alt 1] 100)
            (gen/tuple
              (:nonprop-ident g)
              (igen/freq :nonprop-page-selector [
                [(get w [:nonprop-page-selector :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-page-selector :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (:nonprop-pseudo-page g))]]))]])
        g (assoc g :nonprop-page-selector gen-nonprop-page-selector)

        gen-nonprop-page-selector-list
        (gen/tuple
          (:nonprop-page-selector g)
          (igen/freq :nonprop-page-selector-list [
            [(get w [:nonprop-page-selector-list :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-page-selector-list :cat 1 :opt 0] 100)
              (igen/freq :nonprop-page-selector-list [
                [(get w [:nonprop-page-selector-list :cat 1 :opt 0 :star nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-page-selector-list :cat 1 :opt 0 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:nonprop-page-selector g)))]])]]))
        g (assoc g :nonprop-page-selector-list gen-nonprop-page-selector-list)

        gen-nonprop-page-body
        (gen/return "STUB_page_body")
        g (assoc g :nonprop-page-body gen-nonprop-page-body)

        gen-prop-AT-page
        (gen/tuple
          (gen/return "@page ")
          (:nonprop-page-selector-list g)
          (gen/return "{")
          (gen/return " ")
          (:nonprop-page-body g)
          (gen/return "} "))
        g (assoc g :prop-AT-page gen-prop-AT-page)

        gen-nonprop-font-feature-settings
        (:prop-font-feature-settings g)
        g (assoc g :nonprop-font-feature-settings gen-nonprop-font-feature-settings)

        gen-nonprop-frequency
        (gen/tuple
          (:any-number g)
          (igen/freq :nonprop-frequency [
            [(get w [:nonprop-frequency :cat 1 :alt 0] 100)
              (gen/return "Hz")]
            [(get w [:nonprop-frequency :cat 1 :alt 1] 100)
              (gen/return "kHz")]])
          (gen/return " "))
        g (assoc g :nonprop-frequency gen-nonprop-frequency)

        gen-nonprop-frequency-percentage
        (igen/freq :nonprop-frequency-percentage [
          [(get w [:nonprop-frequency-percentage :alt 0] 100)
            (:nonprop-frequency g)]
          [(get w [:nonprop-frequency-percentage :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-frequency-percentage gen-nonprop-frequency-percentage)

        gen-nonprop-an-plus-b
        (gen/return "STUB_an_plus_b")
        g (assoc g :nonprop-an-plus-b gen-nonprop-an-plus-b)

        gen-nonprop-padding
        (gen/return "STUB_padding")
        g (assoc g :nonprop-padding gen-nonprop-padding)

        gen-nonprop-feature-type
        (igen/freq :nonprop-feature-type [
          [(get w [:nonprop-feature-type :alt 0] 100)
            (gen/return "@stylistic ")]
          [(get w [:nonprop-feature-type :alt 1] 100)
            (gen/return "@historical-forms ")]
          [(get w [:nonprop-feature-type :alt 2] 100)
            (gen/return "@styleset ")]
          [(get w [:nonprop-feature-type :alt 3] 100)
            (gen/return "@character-variant ")]
          [(get w [:nonprop-feature-type :alt 4] 100)
            (gen/return "@swash ")]
          [(get w [:nonprop-feature-type :alt 5] 100)
            (gen/return "@ornaments ")]
          [(get w [:nonprop-feature-type :alt 6] 100)
            (gen/return "@annotation ")]])
        g (assoc g :nonprop-feature-type gen-nonprop-feature-type)

        gen-nonprop-media-condition
        (gen/recursive-gen
          (fn [inner]
            (igen/freq :nonprop-media-condition [
              [(get w [:nonprop-media-condition :alt 0] 100)
                (gen/tuple
                  (igen/freq :nonprop-media-condition [
                    [(get w [:nonprop-media-condition :alt 0 :cat 0 :opt nil] 100)
                      (gen/return "")]
                    [(get w [:nonprop-media-condition :alt 0 :cat 0 :opt 0] 100)
                      (gen/return "not ")]])
                  (igen/freq :nonprop-media-condition [
                    [(get w [:nonprop-media-condition :alt 0 :cat 1 :alt 0] 100)
                      (gen/tuple
                        (gen/return "( ")
                        inner
                        (gen/return ") "))]
                    [(get w [:nonprop-media-condition :alt 0 :cat 1 :alt 1] 100)
                      (:nonprop-media-feature g)]
                    [(get w [:nonprop-media-condition :alt 0 :cat 1 :alt 2] 100)
                      (:nonprop-general-enclosed g)]]))]
              [(get w [:nonprop-media-condition :alt 1] 100)
                (gen/tuple
                  (igen/freq :nonprop-media-condition [
                    [(get w [:nonprop-media-condition :alt 1 :cat 0 :alt 0] 100)
                      (gen/tuple
                        (gen/return "( ")
                        inner
                        (gen/return ") "))]
                    [(get w [:nonprop-media-condition :alt 1 :cat 0 :alt 1] 100)
                      (:nonprop-media-feature g)]
                    [(get w [:nonprop-media-condition :alt 1 :cat 0 :alt 2] 100)
                      (:nonprop-general-enclosed g)]])
                  (igen/vector+
                    (gen/tuple
                      (igen/freq :nonprop-media-condition [
                        [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 0 :alt 0] 100)
                          (gen/return "and ")]
                        [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 0 :alt 1] 100)
                          (gen/return "or ")]])
                      (igen/freq :nonprop-media-condition [
                        [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 1 :alt 0] 100)
                          (gen/tuple
                            (gen/return "( ")
                            inner
                            (gen/return ") "))]
                        [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 1 :alt 1] 100)
                          (:nonprop-media-feature g)]
                        [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 1 :alt 2] 100)
                          (:nonprop-general-enclosed g)]]))))]]))
          (igen/freq :nonprop-media-condition [
            [(get w [:nonprop-media-condition :alt 0] 100)
              (gen/tuple
                (igen/freq :nonprop-media-condition [
                  [(get w [:nonprop-media-condition :alt 0 :cat 0 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-media-condition :alt 0 :cat 0 :opt 0] 100)
                    (gen/return "not ")]])
                (igen/freq :nonprop-media-condition [
                  [(get w [:nonprop-media-condition :alt 0 :cat 1 :alt 0] 100)
                    (:nonprop-media-feature g)]
                  [(get w [:nonprop-media-condition :alt 0 :cat 1 :alt 1] 100)
                    (:nonprop-general-enclosed g)]]))]
            [(get w [:nonprop-media-condition :alt 1] 100)
              (gen/tuple
                (igen/freq :nonprop-media-condition [
                  [(get w [:nonprop-media-condition :alt 1 :cat 0 :alt 0] 100)
                    (:nonprop-media-feature g)]
                  [(get w [:nonprop-media-condition :alt 1 :cat 0 :alt 1] 100)
                    (:nonprop-general-enclosed g)]])
                (igen/vector+
                  (gen/tuple
                    (igen/freq :nonprop-media-condition [
                      [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 0 :alt 0] 100)
                        (gen/return "and ")]
                      [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 0 :alt 1] 100)
                        (gen/return "or ")]])
                    (igen/freq :nonprop-media-condition [
                      [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 1 :alt 0] 100)
                        (:nonprop-media-feature g)]
                      [(get w [:nonprop-media-condition :alt 1 :cat 1 :plus 0 :cat 1 :alt 1] 100)
                        (:nonprop-general-enclosed g)]]))))]]))
        g (assoc g :nonprop-media-condition gen-nonprop-media-condition)

        gen-nonprop-media-in-parens
        (igen/freq :nonprop-media-in-parens [
          [(get w [:nonprop-media-in-parens :alt 0] 100)
            (gen/tuple
              (gen/return "( ")
              (:nonprop-media-condition g)
              (gen/return ") "))]
          [(get w [:nonprop-media-in-parens :alt 1] 100)
            (:nonprop-media-feature g)]
          [(get w [:nonprop-media-in-parens :alt 2] 100)
            (:nonprop-general-enclosed g)]])
        g (assoc g :nonprop-media-in-parens gen-nonprop-media-in-parens)

        gen-nonprop-media-not
        (gen/tuple
          (gen/return "not ")
          (:nonprop-media-in-parens g))
        g (assoc g :nonprop-media-not gen-nonprop-media-not)

        gen-nonprop-media-and
        (gen/tuple
          (:nonprop-media-in-parens g)
          (igen/vector+
            (gen/tuple
              (gen/return "and ")
              (:nonprop-media-in-parens g))))
        g (assoc g :nonprop-media-and gen-nonprop-media-and)

        gen-nonprop-media-condition-without-or
        (igen/freq :nonprop-media-condition-without-or [
          [(get w [:nonprop-media-condition-without-or :alt 0] 100)
            (:nonprop-media-not g)]
          [(get w [:nonprop-media-condition-without-or :alt 1] 100)
            (:nonprop-media-and g)]
          [(get w [:nonprop-media-condition-without-or :alt 2] 100)
            (:nonprop-media-in-parens g)]])
        g (assoc g :nonprop-media-condition-without-or gen-nonprop-media-condition-without-or)

        gen-nonprop-media-type
        (:nonprop-ident g)
        g (assoc g :nonprop-media-type gen-nonprop-media-type)

        gen-nonprop-media-query
        (igen/freq :nonprop-media-query [
          [(get w [:nonprop-media-query :alt 0] 100)
            (:nonprop-media-condition g)]
          [(get w [:nonprop-media-query :alt 1] 100)
            (gen/tuple
              (igen/freq :nonprop-media-query [
                [(get w [:nonprop-media-query :alt 1 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-media-query :alt 1 :cat 0 :opt 0] 100)
                  (igen/freq :nonprop-media-query [
                    [(get w [:nonprop-media-query :alt 1 :cat 0 :opt 0 :alt 0] 100)
                      (gen/return "not ")]
                    [(get w [:nonprop-media-query :alt 1 :cat 0 :opt 0 :alt 1] 100)
                      (gen/return "only ")]])]])
              (:nonprop-media-type g)
              (igen/freq :nonprop-media-query [
                [(get w [:nonprop-media-query :alt 1 :cat 2 :opt nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-media-query :alt 1 :cat 2 :opt 0] 100)
                  (gen/tuple
                    (gen/return "and ")
                    (:nonprop-media-condition-without-or g))]]))]])
        g (assoc g :nonprop-media-query gen-nonprop-media-query)

        gen-nonprop-media-query-list
        (gen/tuple
          (:nonprop-media-query g)
          (igen/freq :nonprop-media-query-list [
            [(get w [:nonprop-media-query-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-media-query-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-media-query g)))]]))
        g (assoc g :nonprop-media-query-list gen-nonprop-media-query-list)

        gen-prop-AT-import
        (gen/tuple
          (gen/return "@import ")
          (igen/freq :prop-AT-import [
            [(get w [:prop-AT-import :cat 1 :alt 0] 100)
              (:nonprop-string g)]
            [(get w [:prop-AT-import :cat 1 :alt 1] 100)
              (:nonprop-url g)]])
          (igen/freq :prop-AT-import [
            [(get w [:prop-AT-import :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:prop-AT-import :cat 2 :opt 0] 100)
              (:nonprop-media-query-list g)]])
          (gen/return "; "))
        g (assoc g :prop-AT-import gen-prop-AT-import)

        gen-nonprop-feature-value-declaration
        (gen/tuple
          (:nonprop-custom-ident g)
          (gen/return ": ")
          (igen/vector+
            (:nonprop-integer g))
          (gen/return "; "))
        g (assoc g :nonprop-feature-value-declaration gen-nonprop-feature-value-declaration)

        gen-nonprop-feature-value-declaration-list
        (:nonprop-feature-value-declaration g)
        g (assoc g :nonprop-feature-value-declaration-list gen-nonprop-feature-value-declaration-list)

        gen-nonprop-feature-value-block
        (gen/tuple
          (:nonprop-feature-type g)
          (gen/return "{ ")
          (:nonprop-feature-value-declaration-list g)
          (gen/return "} "))
        g (assoc g :nonprop-feature-value-block gen-nonprop-feature-value-block)

        gen-nonprop-feature-value-block-list
        (igen/vector+
          (:nonprop-feature-value-block g))
        g (assoc g :nonprop-feature-value-block-list gen-nonprop-feature-value-block-list)

        gen-prop-AT-font-feature-values
        (gen/tuple
          (gen/return "@font-feature-values ")
          (:nonprop-family-name g)
          (igen/freq :prop-AT-font-feature-values [
            [(get w [:prop-AT-font-feature-values :cat 2 :star nil] 100)
              (gen/return "")]
            [(get w [:prop-AT-font-feature-values :cat 2 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-family-name g)))]])
          (gen/return "{")
          (gen/return " ")
          (:nonprop-feature-value-block-list g)
          (gen/return "} "))
        g (assoc g :prop-AT-font-feature-values gen-prop-AT-font-feature-values)

        gen-nonprop-keyframe-block
        (gen/tuple
          (:nonprop-keyframe-selector g)
          (igen/freq :nonprop-keyframe-block [
            [(get w [:nonprop-keyframe-block :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-keyframe-block :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-keyframe-selector g)))]])
          (gen/return "{")
          (gen/return " ")
          (:nonprop-declaration-list g)
          (gen/return "} "))
        g (assoc g :nonprop-keyframe-block gen-nonprop-keyframe-block)

        gen-nonprop-keyframe-block-list
        (igen/vector+
          (:nonprop-keyframe-block g))
        g (assoc g :nonprop-keyframe-block-list gen-nonprop-keyframe-block-list)

        gen-nonprop-unicode-range
        (gen/recursive-gen
          (fn [inner]
            (gen/tuple
              (chuck/string-from-regex #"U[+](?:[0-9A-Fa-f]{1,4}-[0-9A-Fa-f]{1,4}|[0-9A-Fa-f?]{1,4})")
              (igen/freq :nonprop-unicode-range [
                [(get w [:nonprop-unicode-range :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:nonprop-unicode-range :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      inner))]])))
          (gen/tuple
            (chuck/string-from-regex #"U[+](?:[0-9A-Fa-f]{1,4}-[0-9A-Fa-f]{1,4}|[0-9A-Fa-f?]{1,4})")
            (gen/return "")))
        g (assoc g :nonprop-unicode-range gen-nonprop-unicode-range)

        gen-nonprop-src
        (gen/tuple
          (igen/freq :nonprop-src [
            [(get w [:nonprop-src :cat 0 :alt 0] 100)
              (gen/tuple
                (:nonprop-url g)
                (igen/freq :nonprop-src [
                  [(get w [:nonprop-src :cat 0 :alt 0 :cat 1 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:nonprop-src :cat 0 :alt 0 :cat 1 :opt 0] 100)
                    (gen/tuple
                      (gen/return "format ")
                      (gen/return "( ")
                      (:nonprop-string g)
                      (igen/freq :nonprop-src [
                        [(get w [:nonprop-src :cat 0 :alt 0 :cat 1 :opt 0 :cat 3 :star nil] 100)
                          (gen/return "")]
                        [(get w [:nonprop-src :cat 0 :alt 0 :cat 1 :opt 0 :cat 3 :star 0] 100)
                          (igen/vector+
                            (gen/tuple
                              (gen/return ",")
                              (gen/return " ")
                              (:nonprop-string g)))]])
                      (gen/return ") "))]]))]
            [(get w [:nonprop-src :cat 0 :alt 1] 100)
              (gen/tuple
                (gen/return "local ")
                (gen/return "( ")
                (:nonprop-family-name g)
                (gen/return ") "))]])
          (igen/freq :nonprop-src [
            [(get w [:nonprop-src :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-src :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (igen/freq :nonprop-src [
                    [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 0] 100)
                      (gen/tuple
                        (:nonprop-url g)
                        (igen/freq :nonprop-src [
                          [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 0 :cat 1 :opt nil] 100)
                            (gen/return "")]
                          [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 0 :cat 1 :opt 0] 100)
                            (gen/tuple
                              (gen/return "format ")
                              (gen/return "( ")
                              (:nonprop-string g)
                              (igen/freq :nonprop-src [
                                [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 0 :cat 1 :opt 0 :cat 3 :star nil] 100)
                                  (gen/return "")]
                                [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 0 :cat 1 :opt 0 :cat 3 :star 0] 100)
                                  (igen/vector+
                                    (gen/tuple
                                      (gen/return ",")
                                      (gen/return " ")
                                      (:nonprop-string g)))]])
                              (gen/return ") "))]]))]
                    [(get w [:nonprop-src :cat 1 :star 0 :cat 2 :alt 1] 100)
                      (gen/tuple
                        (gen/return "local ")
                        (gen/return "( ")
                        (:nonprop-family-name g)
                        (gen/return ") "))]])))]]))
        g (assoc g :nonprop-src gen-nonprop-src)

        gen-nonprop-font-variant
        (:prop-font-variant g)
        g (assoc g :nonprop-font-variant gen-nonprop-font-variant)

        gen-nonprop-font-weight
        (:prop-font-weight g)
        g (assoc g :nonprop-font-weight gen-nonprop-font-weight)

        gen-nonprop-font-stretch
        (:prop-font-stretch g)
        g (assoc g :nonprop-font-stretch gen-nonprop-font-stretch)

        gen-nonprop-font-variation-settings
        (:prop-unknown g)
        g (assoc g :nonprop-font-variation-settings gen-nonprop-font-variation-settings)

        gen-nonprop-font-display
        (igen/freq :nonprop-font-display [
          [(get w [:nonprop-font-display :alt 0] 100)
            (gen/return "auto ")]
          [(get w [:nonprop-font-display :alt 1] 100)
            (gen/return "block ")]
          [(get w [:nonprop-font-display :alt 2] 100)
            (gen/return "swap ")]
          [(get w [:nonprop-font-display :alt 3] 100)
            (gen/return "fallback ")]
          [(get w [:nonprop-font-display :alt 4] 100)
            (gen/return "optional ")]])
        g (assoc g :nonprop-font-display gen-nonprop-font-display)

        gen-nonprop-font-style
        (:prop-font-style g)
        g (assoc g :nonprop-font-style gen-nonprop-font-style)

        gen-prop-AT-font-face
        (gen/tuple
          (gen/return "@font-face ")
          (gen/return "{")
          (gen/return " ")
          (igen/vector+
            (igen/freq :prop-AT-font-face [
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 0] 100)
                (gen/tuple
                  (gen/return "font-family: ")
                  (:nonprop-family-name g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 1] 100)
                (gen/tuple
                  (gen/return "src: ")
                  (:nonprop-src g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 2] 100)
                (gen/tuple
                  (gen/return "unicode-range: ")
                  (:nonprop-unicode-range g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 3] 100)
                (gen/tuple
                  (gen/return "font-variant: ")
                  (:nonprop-font-variant g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 4] 100)
                (gen/tuple
                  (gen/return "font-feature-settings: ")
                  (:nonprop-font-feature-settings g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 5] 100)
                (gen/tuple
                  (gen/return "font-variation-settings: ")
                  (:nonprop-font-variation-settings g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 6] 100)
                (gen/tuple
                  (gen/return "font-stretch: ")
                  (:nonprop-font-stretch g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 7] 100)
                (gen/tuple
                  (gen/return "font-weight: ")
                  (:nonprop-font-weight g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 8] 100)
                (gen/tuple
                  (gen/return "font-style: ")
                  (:nonprop-font-style g)
                  (gen/return "; "))]
              [(get w [:prop-AT-font-face :cat 3 :plus 0 :alt 9] 100)
                (gen/tuple
                  (gen/return "font-display: ")
                  (:nonprop-font-display g)
                  (gen/return "; "))]]))
          (gen/return "} "))
        g (assoc g :prop-AT-font-face gen-prop-AT-font-face)

        gen-prop-AT-keyframes
        (gen/tuple
          (gen/return "@keyframes ")
          (:nonprop-keyframes-name g)
          (gen/return "{")
          (gen/return " ")
          (:nonprop-keyframe-block-list g)
          (gen/return "} "))
        g (assoc g :prop-AT-keyframes gen-prop-AT-keyframes)

        gen-nonprop-additive-symbols
        (gen/return "STUB_additive_symbols")
        g (assoc g :nonprop-additive-symbols gen-nonprop-additive-symbols)

        gen-nonprop-prefix
        (gen/return "STUB_prefix")
        g (assoc g :nonprop-prefix gen-nonprop-prefix)

        gen-nonprop-speak-as
        (gen/return "STUB_speak_as")
        g (assoc g :nonprop-speak-as gen-nonprop-speak-as)

        gen-nonprop-group-rule-body
        (gen/return "STUB_nonprop_group_rule_body")
        g (assoc g :nonprop-group-rule-body gen-nonprop-group-rule-body)

        gen-prop-AT-supports
        (gen/tuple
          (gen/return "@supports ")
          (:nonprop-supports-condition g)
          (gen/return "{")
          (gen/return " ")
          (:nonprop-group-rule-body g)
          (gen/return "} "))
        g (assoc g :prop-AT-supports gen-prop-AT-supports)

        gen-nonprop-counter-symbols
        (gen/return "STUB_counter_symbols")
        g (assoc g :nonprop-counter-symbols gen-nonprop-counter-symbols)

        gen-nonprop-counter-system
        (gen/return "STUB_counter_system")
        g (assoc g :nonprop-counter-system gen-nonprop-counter-system)

        gen-prop-AT-viewport
        (gen/tuple
          (gen/return "@viewport ")
          (gen/return "{")
          (gen/return " ")
          (:nonprop-group-rule-body g)
          (gen/return "} "))
        g (assoc g :prop-AT-viewport gen-prop-AT-viewport)

        gen-prop-AT-counter-style
        (gen/tuple
          (gen/return "@counter-style ")
          (:nonprop-counter-style-name g)
          (gen/return "{")
          (gen/return " ")
          (igen/vector+
            (igen/freq :prop-AT-counter-style [
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 0] 100)
                (gen/tuple
                  (gen/return "system: ")
                  (:nonprop-counter-system g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 1] 100)
                (gen/tuple
                  (gen/return "symbols: ")
                  (:nonprop-counter-symbols g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 2] 100)
                (gen/tuple
                  (gen/return "additive-symbols: ")
                  (:nonprop-additive-symbols g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 3] 100)
                (gen/tuple
                  (gen/return "negative: ")
                  (:nonprop-negative-symbol g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 4] 100)
                (gen/tuple
                  (gen/return "prefix: ")
                  (:nonprop-prefix g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 5] 100)
                (gen/tuple
                  (gen/return "suffix: ")
                  (:nonprop-suffix g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 6] 100)
                (gen/tuple
                  (gen/return "range: ")
                  (:nonprop-range g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 7] 100)
                (gen/tuple
                  (gen/return "pad: ")
                  (:nonprop-padding g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 8] 100)
                (gen/tuple
                  (gen/return "speak-as: ")
                  (:nonprop-speak-as g)
                  (gen/return "; "))]
              [(get w [:prop-AT-counter-style :cat 4 :plus 0 :alt 9] 100)
                (gen/tuple
                  (gen/return "fallback: ")
                  (:nonprop-counter-style-name g)
                  (gen/return "; "))]]))
          (gen/return "} "))
        g (assoc g :prop-AT-counter-style gen-prop-AT-counter-style)

        gen-prop-AT-media
        (gen/tuple
          (gen/return "@media ")
          (:nonprop-media-query-list g)
          (gen/return "{")
          (gen/return " ")
          (:nonprop-group-rule-body g)
          (gen/return "} "))
        g (assoc g :prop-AT-media gen-prop-AT-media)]
    g))

(defn- css3-generators-part-13 [gmap weights]
  (let [g gmap
        w weights

        gen-css-at-rule
        (igen/freq :css-at-rule [
          [(get w [:css-at-rule :alt 0] 100)
            (:prop-AT-charset g)]
          [(get w [:css-at-rule :alt 1] 100)
            (:prop-AT-counter-style g)]
          [(get w [:css-at-rule :alt 2] 100)
            (:prop-AT-font-face g)]
          [(get w [:css-at-rule :alt 3] 100)
            (:prop-AT-font-feature-values g)]
          [(get w [:css-at-rule :alt 4] 100)
            (:prop-AT-import g)]
          [(get w [:css-at-rule :alt 5] 100)
            (:prop-AT-keyframes g)]
          [(get w [:css-at-rule :alt 6] 100)
            (:prop-AT-media g)]
          [(get w [:css-at-rule :alt 7] 100)
            (:prop-AT-namespace g)]
          [(get w [:css-at-rule :alt 8] 100)
            (:prop-AT-page g)]
          [(get w [:css-at-rule :alt 9] 100)
            (:prop-AT-supports g)]
          [(get w [:css-at-rule :alt 10] 100)
            (:prop-AT-viewport g)]])
        g (assoc g :css-at-rule gen-css-at-rule)

        gen-css-simple-selector
        (igen/freq :css-simple-selector [
          [(get w [:css-simple-selector :alt 0] 100)
            (gen/tuple
              (igen/freq :css-simple-selector [
                [(get w [:css-simple-selector :alt 0 :cat 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-simple-selector :alt 0 :cat 0 :opt 0] 100)
                  (igen/freq :css-simple-selector [
                    [(get w [:css-simple-selector :alt 0 :cat 0 :opt 0 :alt 0] 100)
                      (:css-type g)]
                    [(get w [:css-simple-selector :alt 0 :cat 0 :opt 0 :alt 1] 100)
                      (:css-univ g)]])]])
              (igen/freq :css-simple-selector [
                [(get w [:css-simple-selector :alt 0 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:css-simple-selector :alt 0 :cat 1 :star 0] 100)
                  (igen/vector+
                    (igen/freq :css-simple-selector [
                      [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt nil] 100)
                        (gen/return "")]
                      [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0] 100)
                        (igen/freq :css-simple-selector [
                          [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0 :alt 0] 100)
                            (:css-hash g)]
                          [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0 :alt 1] 100)
                            (:css-class g)]
                          [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0 :alt 2] 100)
                            (:css-attr g)]
                          [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0 :alt 3] 100)
                            (:css-psuedo g)]
                          [(get w [:css-simple-selector :alt 0 :cat 1 :star 0 :opt 0 :alt 4] 100)
                            (:css-negate g)]])]]))]]))]
          [(get w [:css-simple-selector :alt 1] 100)
            (igen/vector+
              (igen/freq :css-simple-selector [
                [(get w [:css-simple-selector :alt 1 :plus 0 :opt nil] 100)
                  (gen/return "")]
                [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0] 100)
                  (igen/freq :css-simple-selector [
                    [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0 :alt 0] 100)
                      (:css-hash g)]
                    [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0 :alt 1] 100)
                      (:css-class g)]
                    [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0 :alt 2] 100)
                      (:css-attr g)]
                    [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0 :alt 3] 100)
                      (:css-psuedo g)]
                    [(get w [:css-simple-selector :alt 1 :plus 0 :opt 0 :alt 4] 100)
                      (:css-negate g)]])]]))]])
        g (assoc g :css-simple-selector gen-css-simple-selector)

        gen-css-combinator
        (igen/freq :css-combinator [
          [(get w [:css-combinator :alt 0] 100)
            (gen/return "+ ")]
          [(get w [:css-combinator :alt 1] 100)
            (gen/return "> ")]
          [(get w [:css-combinator :alt 2] 100)
            (gen/return "~ ")]
          [(get w [:css-combinator :alt 3] 100)
            (gen/return " ")]])
        g (assoc g :css-combinator gen-css-combinator)

        gen-css-selector
        (gen/tuple
          (:css-simple-selector g)
          (igen/freq :css-selector [
            [(get w [:css-selector :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:css-selector :cat 1 :star 0] 100)
              (igen/vector+
                (igen/freq :css-selector [
                  [(get w [:css-selector :cat 1 :star 0 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:css-selector :cat 1 :star 0 :opt 0] 100)
                    (gen/tuple
                      (:css-combinator g)
                      (:css-simple-selector g))]]))]]))
        g (assoc g :css-selector gen-css-selector)

        gen-css-assignments
        (igen/freq :css-assignments [
          [(get w [:css-assignments :alt 0] 100)
            (gen/return " ")]
          [(get w [:css-assignments :alt 1] 100)
            (gen/tuple
              (:css-declaration g)
              (gen/return " ")
              (igen/freq :css-assignments [
                [(get w [:css-assignments :alt 1 :cat 2 :star nil] 100)
                  (gen/return "")]
                [(get w [:css-assignments :alt 1 :cat 2 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ";")
                      (gen/return " ")
                      (:css-declaration g)
                      (gen/return " ")))]])
              (igen/freq :css-assignments [
                [(get w [:css-assignments :alt 1 :cat 3 :star nil] 100)
                  (gen/return "")]
                [(get w [:css-assignments :alt 1 :cat 3 :star 0] 100)
                  (igen/vector+
                    (gen/return "; "))]]))]])
        g (assoc g :css-assignments gen-css-assignments)

        gen-css-ruleset
        (gen/tuple
          (:css-selector g)
          (igen/freq :css-ruleset [
            [(get w [:css-ruleset :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:css-ruleset :cat 1 :star 0] 100)
              (igen/vector+
                (igen/freq :css-ruleset [
                  [(get w [:css-ruleset :cat 1 :star 0 :opt nil] 100)
                    (gen/return "")]
                  [(get w [:css-ruleset :cat 1 :star 0 :opt 0] 100)
                    (gen/tuple
                      (gen/return ",")
                      (gen/return " ")
                      (:css-selector g))]]))]])
          (gen/return "{")
          (gen/return " ")
          (:css-assignments g)
          (gen/return "} "))
        g (assoc g :css-ruleset gen-css-ruleset)

        gen-stylesheet
        (gen/tuple
          (gen/return " ")
          (igen/freq :stylesheet [
            [(get w [:stylesheet :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:stylesheet :cat 1 :star 0] 100)
              (igen/vector+
                (igen/freq :stylesheet [
                  [(get w [:stylesheet :cat 1 :star 0 :alt 0] 100)
                    (:css-ruleset g)]
                  [(get w [:stylesheet :cat 1 :star 0 :alt 1] 100)
                    (:css-at-rule g)]
                  [(get w [:stylesheet :cat 1 :star 0 :alt 2] 100)
                    (:css-comment g)]]))]]))
        g (assoc g :stylesheet gen-stylesheet)

        gen-url
        (chuck/string-from-regex #"[A-Za-z0-9$_@.,&+%=;/#?:-]*[A-Za-z0-9$_@.&+%=;/#?:-]")
        g (assoc g :url gen-url)

        gen-nonprop-outline-radius
        (igen/freq :nonprop-outline-radius [
          [(get w [:nonprop-outline-radius :alt 0] 100)
            (:nonprop-length g)]
          [(get w [:nonprop-outline-radius :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-outline-radius gen-nonprop-outline-radius)

        gen-nonprop-compound-selector-list
        (gen/tuple
          (:nonprop-compound-selector g)
          (igen/freq :nonprop-compound-selector-list [
            [(get w [:nonprop-compound-selector-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-compound-selector-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-compound-selector g)))]]))
        g (assoc g :nonprop-compound-selector-list gen-nonprop-compound-selector-list)

        gen-nonprop-clip-style
        (gen/return "STUB_clip_style")
        g (assoc g :nonprop-clip-style gen-nonprop-clip-style)

        gen-func-max
        (gen/tuple
          (gen/return "max ")
          (gen/return "( ")
          (:nonprop-calc-sum g)
          (igen/freq :func-max [
            [(get w [:func-max :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:func-max :cat 3 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-calc-sum g)))]])
          (gen/return ") "))
        g (assoc g :func-max gen-func-max)

        gen-func-fit-content
        (gen/tuple
          (gen/return "fit-content ")
          (gen/return "( ")
          (igen/freq :func-fit-content [
            [(get w [:func-fit-content :cat 2 :alt 0] 100)
              (:nonprop-length g)]
            [(get w [:func-fit-content :cat 2 :alt 1] 100)
              (:nonprop-percentage g)]])
          (gen/return ") "))
        g (assoc g :func-fit-content gen-func-fit-content)

        gen-lang
        (chuck/string-from-regex #"[a-z]+(?:-[A-Za-z]+)?")
        g (assoc g :lang gen-lang)

        gen-nonprop-cf-mixing-image
        (gen/tuple
          (igen/freq :nonprop-cf-mixing-image [
            [(get w [:nonprop-cf-mixing-image :cat 0 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-cf-mixing-image :cat 0 :opt 0] 100)
              (:nonprop-percentage g)]])
          (:nonprop-image g))
        g (assoc g :nonprop-cf-mixing-image gen-nonprop-cf-mixing-image)

        gen-nonprop-cf-final-image
        (igen/freq :nonprop-cf-final-image [
          [(get w [:nonprop-cf-final-image :alt 0] 100)
            (:nonprop-image g)]
          [(get w [:nonprop-cf-final-image :alt 1] 100)
            (:nonprop-color g)]])
        g (assoc g :nonprop-cf-final-image gen-nonprop-cf-final-image)

        gen-func-cross-fade
        (gen/tuple
          (gen/return "cross-fade ")
          (gen/return "( ")
          (:nonprop-cf-mixing-image g)
          (gen/return ", ")
          (igen/freq :func-cross-fade [
            [(get w [:func-cross-fade :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-cross-fade :cat 4 :opt 0] 100)
              (:nonprop-cf-final-image g)]])
          (gen/return ") "))
        g (assoc g :func-cross-fade gen-func-cross-fade)

        gen-func-env
        (gen/tuple
          (gen/return "env ")
          (gen/return "( ")
          (:nonprop-custom-ident g)
          (gen/return ", ")
          (igen/freq :func-env [
            [(get w [:func-env :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-env :cat 4 :opt 0] 100)
              (:nonprop-declaration-value g)]])
          (gen/return ") "))
        g (assoc g :func-env gen-func-env)

        gen-func-image-set
        (gen/tuple
          (gen/return "image-set ")
          (gen/return "( ")
          (:nonprop-image-set-option g)
          (igen/freq :func-image-set [
            [(get w [:func-image-set :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:func-image-set :cat 3 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-image-set-option g)))]])
          (gen/return ") "))
        g (assoc g :func-image-set gen-func-image-set)

        gen-func-clamp
        (gen/tuple
          (gen/return "clamp ")
          (gen/return "( ")
          (gen/tuple
            (:nonprop-calc-sum g)
            (gen/return ",")
            (gen/return " ")
            (:nonprop-calc-sum g)
            (gen/return ",")
            (gen/return " ")
            (:nonprop-calc-sum g))
          (gen/return ") "))
        g (assoc g :func-clamp gen-func-clamp)

        gen-rS
        (gen/tuple (gen/return " "))
        g (assoc g :rS gen-rS)

        gen-func-element
        (gen/tuple
          (gen/return "element ")
          (gen/return "( ")
          (:nonprop-id-selector g)
          (gen/return ") "))
        g (assoc g :func-element gen-func-element)

        gen-nonprop-complex-selector-list
        (gen/tuple
          (:nonprop-complex-selector g)
          (igen/freq :nonprop-complex-selector-list [
            [(get w [:nonprop-complex-selector-list :cat 1 :star nil] 100)
              (gen/return "")]
            [(get w [:nonprop-complex-selector-list :cat 1 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-complex-selector g)))]]))
        g (assoc g :nonprop-complex-selector-list gen-nonprop-complex-selector-list)

        gen-mime-type
        (chuck/string-from-regex #"[a-z]+/[a-z0-9+-]+")
        g (assoc g :mime-type gen-mime-type)

        gen-nonprop-time-percentage
        (igen/freq :nonprop-time-percentage [
          [(get w [:nonprop-time-percentage :alt 0] 100)
            (:nonprop-time g)]
          [(get w [:nonprop-time-percentage :alt 1] 100)
            (:nonprop-percentage g)]])
        g (assoc g :nonprop-time-percentage gen-nonprop-time-percentage)

        gen-nonprop-name-repeat
        (gen/return "STUB_name_repeat")
        g (assoc g :nonprop-name-repeat gen-nonprop-name-repeat)

        gen-nonprop-image-tags
        (igen/freq :nonprop-image-tags [
          [(get w [:nonprop-image-tags :alt 0] 100)
            (gen/return "ltr ")]
          [(get w [:nonprop-image-tags :alt 1] 100)
            (gen/return "rtl ")]])
        g (assoc g :nonprop-image-tags gen-nonprop-image-tags)

        gen-func-image
        (gen/tuple
          (gen/return "image ")
          (gen/return "( ")
          (igen/freq :func-image [
            [(get w [:func-image :cat 2 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-image :cat 2 :opt 0] 100)
              (:nonprop-image-tags g)]])
          (gen/tuple
            (igen/freq :func-image [
              [(get w [:func-image :cat 3 :cat 0 :opt nil] 100)
                (gen/return "")]
              [(get w [:func-image :cat 3 :cat 0 :opt 0] 100)
                (:nonprop-image-src g)]])
            (gen/return ", ")
            (igen/freq :func-image [
              [(get w [:func-image :cat 3 :cat 2 :opt nil] 100)
                (gen/return "")]
              [(get w [:func-image :cat 3 :cat 2 :opt 0] 100)
                (:nonprop-color g)]]))
          (gen/return ") "))
        g (assoc g :func-image gen-func-image)

        gen-nonprop-compat
        (igen/freq :nonprop-compat [
          [(get w [:nonprop-compat :alt 0] 100)
            (gen/return "searchfield ")]
          [(get w [:nonprop-compat :alt 1] 100)
            (gen/return "textarea ")]
          [(get w [:nonprop-compat :alt 2] 100)
            (gen/return "push-button ")]
          [(get w [:nonprop-compat :alt 3] 100)
            (gen/return "button-bevel ")]
          [(get w [:nonprop-compat :alt 4] 100)
            (gen/return "slider-horizontal ")]
          [(get w [:nonprop-compat :alt 5] 100)
            (gen/return "checkbox ")]
          [(get w [:nonprop-compat :alt 6] 100)
            (gen/return "radio ")]
          [(get w [:nonprop-compat :alt 7] 100)
            (gen/return "square-button ")]
          [(get w [:nonprop-compat :alt 8] 100)
            (gen/return "menulist ")]
          [(get w [:nonprop-compat :alt 9] 100)
            (gen/return "menulist-button ")]
          [(get w [:nonprop-compat :alt 10] 100)
            (gen/return "listbox ")]
          [(get w [:nonprop-compat :alt 11] 100)
            (gen/return "meter ")]
          [(get w [:nonprop-compat :alt 12] 100)
            (gen/return "progress-bar ")]])
        g (assoc g :nonprop-compat gen-nonprop-compat)

        gen-func-min
        (gen/tuple
          (gen/return "min ")
          (gen/return "( ")
          (:nonprop-calc-sum g)
          (igen/freq :func-min [
            [(get w [:func-min :cat 3 :star nil] 100)
              (gen/return "")]
            [(get w [:func-min :cat 3 :star 0] 100)
              (igen/vector+
                (gen/tuple
                  (gen/return ",")
                  (gen/return " ")
                  (:nonprop-calc-sum g)))]])
          (gen/return ") "))
        g (assoc g :func-min gen-func-min)

        gen-nonprop-composite-style
        (igen/freq :nonprop-composite-style [
          [(get w [:nonprop-composite-style :alt 0] 100)
            (gen/return "clear ")]
          [(get w [:nonprop-composite-style :alt 1] 100)
            (gen/return "copy ")]
          [(get w [:nonprop-composite-style :alt 2] 100)
            (gen/return "source-over ")]
          [(get w [:nonprop-composite-style :alt 3] 100)
            (gen/return "source-in ")]
          [(get w [:nonprop-composite-style :alt 4] 100)
            (gen/return "source-out ")]
          [(get w [:nonprop-composite-style :alt 5] 100)
            (gen/return "source-atop ")]
          [(get w [:nonprop-composite-style :alt 6] 100)
            (gen/return "destination-over ")]
          [(get w [:nonprop-composite-style :alt 7] 100)
            (gen/return "destination-in ")]
          [(get w [:nonprop-composite-style :alt 8] 100)
            (gen/return "destination-out ")]
          [(get w [:nonprop-composite-style :alt 9] 100)
            (gen/return "destination-atop ")]
          [(get w [:nonprop-composite-style :alt 10] 100)
            (gen/return "xor ")]])
        g (assoc g :nonprop-composite-style gen-nonprop-composite-style)

        gen-nonprop-line-name-list
        (igen/vector+
          (igen/freq :nonprop-line-name-list [
            [(get w [:nonprop-line-name-list :plus 0 :alt 0] 100)
              (:nonprop-line-names g)]
            [(get w [:nonprop-line-name-list :plus 0 :alt 1] 100)
              (:nonprop-name-repeat g)]]))
        g (assoc g :nonprop-line-name-list gen-nonprop-line-name-list)

        gen-nonprop-mask-position
        (gen/tuple
          (igen/freq :nonprop-mask-position [
            [(get w [:nonprop-mask-position :cat 0 :alt 0] 100)
              (:nonprop-length-percentage g)]
            [(get w [:nonprop-mask-position :cat 0 :alt 1] 100)
              (gen/return "left ")]
            [(get w [:nonprop-mask-position :cat 0 :alt 2] 100)
              (gen/return "center ")]
            [(get w [:nonprop-mask-position :cat 0 :alt 3] 100)
              (gen/return "right ")]])
          (igen/freq :nonprop-mask-position [
            [(get w [:nonprop-mask-position :cat 1 :opt nil] 100)
              (gen/return "")]
            [(get w [:nonprop-mask-position :cat 1 :opt 0] 100)
              (igen/freq :nonprop-mask-position [
                [(get w [:nonprop-mask-position :cat 1 :opt 0 :alt 0] 100)
                  (:nonprop-length-percentage g)]
                [(get w [:nonprop-mask-position :cat 1 :opt 0 :alt 1] 100)
                  (gen/return "top ")]
                [(get w [:nonprop-mask-position :cat 1 :opt 0 :alt 2] 100)
                  (gen/return "center ")]
                [(get w [:nonprop-mask-position :cat 1 :opt 0 :alt 3] 100)
                  (gen/return "bottom ")]])]]))
        g (assoc g :nonprop-mask-position gen-nonprop-mask-position)

        gen-func-counter
        (gen/tuple
          (gen/return "counter ")
          (gen/return "( ")
          (:nonprop-custom-ident g)
          (gen/return ", ")
          (igen/freq :func-counter [
            [(get w [:func-counter :cat 4 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-counter :cat 4 :opt 0] 100)
              (igen/freq :func-counter [
                [(get w [:func-counter :cat 4 :opt 0 :alt 0] 100)
                  (:nonprop-counter-style g)]
                [(get w [:func-counter :cat 4 :opt 0 :alt 1] 100)
                  (gen/return "none ")]])]])
          (gen/return ") "))
        g (assoc g :func-counter gen-func-counter)

        gen-nonprop-color-stop
        (igen/freq :nonprop-color-stop [
          [(get w [:nonprop-color-stop :alt 0] 100)
            (:nonprop-color-stop-length g)]
          [(get w [:nonprop-color-stop :alt 1] 100)
            (:nonprop-color-stop-angle g)]])
        g (assoc g :nonprop-color-stop gen-nonprop-color-stop)

        gen-css-assignments-test
        (igen/freq :css-assignments-test [
          [(get w [:css-assignments-test :alt 0] 100)
            (gen/return "")]
          [(get w [:css-assignments-test :alt 1] 100)
            (gen/tuple
              (:css-declaration g)
              (igen/freq :css-assignments-test [
                [(get w [:css-assignments-test :alt 1 :cat 1 :star nil] 100)
                  (gen/return "")]
                [(get w [:css-assignments-test :alt 1 :cat 1 :star 0] 100)
                  (igen/vector+
                    (gen/tuple
                      (gen/return ";")
                      (gen/return " ")
                      (:css-declaration g)))]]))]])
        g (assoc g :css-assignments-test gen-css-assignments-test)

        gen-nonprop-generic-name
        (igen/freq :nonprop-generic-name [
          [(get w [:nonprop-generic-name :alt 0] 100)
            (gen/return "serif ")]
          [(get w [:nonprop-generic-name :alt 1] 100)
            (gen/return "sans-serif ")]
          [(get w [:nonprop-generic-name :alt 2] 100)
            (gen/return "cursive ")]
          [(get w [:nonprop-generic-name :alt 3] 100)
            (gen/return "fantasy ")]
          [(get w [:nonprop-generic-name :alt 4] 100)
            (gen/return "monospace ")]])
        g (assoc g :nonprop-generic-name gen-nonprop-generic-name)

        gen-func-path
        (gen/return "STUB_func_path")
        g (assoc g :func-path gen-func-path)

        gen-nonprop-media-or
        (gen/tuple
          (:nonprop-media-in-parens g)
          (igen/vector+
            (gen/tuple
              (gen/return "or ")
              (:nonprop-media-in-parens g))))
        g (assoc g :nonprop-media-or gen-nonprop-media-or)

        gen-nonprop-nth
        (igen/freq :nonprop-nth [
          [(get w [:nonprop-nth :alt 0] 100)
            (:nonprop-an-plus-b g)]
          [(get w [:nonprop-nth :alt 1] 100)
            (gen/return "even ")]
          [(get w [:nonprop-nth :alt 2] 100)
            (gen/return "odd ")]])
        g (assoc g :nonprop-nth gen-nonprop-nth)

        gen-nonprop-symbol
        (igen/freq :nonprop-symbol [
          [(get w [:nonprop-symbol :alt 0] 100)
            (:nonprop-string g)]
          [(get w [:nonprop-symbol :alt 1] 100)
            (:nonprop-image g)]
          [(get w [:nonprop-symbol :alt 2] 100)
            (:nonprop-custom-ident g)]])
        g (assoc g :nonprop-symbol gen-nonprop-symbol)

        gen-non-negative-integer
        gen/nat
        g (assoc g :non-negative-integer gen-non-negative-integer)

        gen-func-counters
        (gen/tuple
          (gen/return "counters ")
          (gen/return "( ")
          (:nonprop-custom-ident g)
          (gen/return ", ")
          (:nonprop-string g)
          (gen/return ",")
          (gen/return " ")
          (igen/freq :func-counters [
            [(get w [:func-counters :cat 7 :opt nil] 100)
              (gen/return "")]
            [(get w [:func-counters :cat 7 :opt 0] 100)
              (igen/freq :func-counters [
                [(get w [:func-counters :cat 7 :opt 0 :alt 0] 100)
                  (:nonprop-counter-style g)]
                [(get w [:func-counters :cat 7 :opt 0 :alt 1] 100)
                  (gen/return "none ")]])]])
          (gen/return ") "))
        g (assoc g :func-counters gen-func-counters)]
    g))

(defn css3-generators [& [gmap weights]]
  (let [g (or gmap {})
        w weights

        g (css3-generators-part-0 g weights)
        g (css3-generators-part-1 g weights)
        g (css3-generators-part-2 g weights)
        g (css3-generators-part-3 g weights)
        g (css3-generators-part-4 g weights)
        g (css3-generators-part-5 g weights)
        g (css3-generators-part-6 g weights)
        g (css3-generators-part-7 g weights)
        g (css3-generators-part-8 g weights)
        g (css3-generators-part-9 g weights)
        g (css3-generators-part-10 g weights)
        g (css3-generators-part-11 g weights)
        g (css3-generators-part-12 g weights)
        g (css3-generators-part-13 g weights)]
    g))