(ns kaleidocs.convert
  (import [org.artofsolving.jodconverter OfficeDocumentConverter]
          [org.artofsolving.jodconverter.office
           OfficeManager DefaultOfficeManagerConfiguration]
          [org.artofsolving.jodconverter.process
           PureJavaProcessManager SigarProcessManager]))

(defn convert [in out]
  (let [office (->  (DefaultOfficeManagerConfiguration.)
                      (.setProcessManager (PureJavaProcessManager.))
                      .buildOfficeManager)
        converter (OfficeDocumentConverter. office)]
    (try
      (do
        (.start office)
        (.convert converter
                  (clojure.java.io/file in)
                  (clojure.java.io/file out)))
      (catch Throwable e
        (println
         "\n\n\n~~~=.=~~~\n"
         "This is hell" (.getMessage e)))
      (finally
        (.stop office)))))
