(ns leiningen.new.kaj-default
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "kaj-default"))

(defn kaj-default
  "Kris Jenkins' preferred default template."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' kaj-default project.")
    (->files data
             ["project.clj"                      (render "project.clj" data)]
             [".gitignore"                       (render "gitignore.txt" data)]
             ["src/{{sanitized}}/core.clj"       (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
             )))
