(ns license-report)

(require '[clojure.string :as str])

; lein licenses :edn > l.edn

(def l (clojure.core/read-string (slurp "l.edn")))

; lein deps :tree > src/t.edn

(def t (slurp "t.edn"))

(def nodes (for [n (clojure.string/split-lines t)]
          (let [r (rest (clojure.string/split n #""))]
            [(/ (count (take-while #(= " " %) r)) 2) (take 2 (clojure.core/read-string (clojure.string/triml n)))])))

(defn nestedmapfromt [t]
  (reduce
    (fn insertdepth [s [d v]]
      (let [depthis
            (fn depthis [ss d]
               (let [s (second ss)
                     i (count s)]
                 (lazy-seq
                   (if (or (= i 0) (= d 0))
                     [i]
                     (concat [(- i 1)] (depthis (get s (- i 1)) (- d 1)))))))]
        (assoc-in s (take (* 2 (+ 1 d)) (concat [1] (interpose 1 (depthis s d))))
                  [v []])))
    ["nil" []]
    t))

(def tree (second (nestedmapfromt nodes)))

;  :dependencies taken from project.clj until "Provided dependencies included in uberjar."
(def ps '[[org.clojure/clojure "1.10.0"]
         [org.clojure/tools.logging "0.4.1"]
         [com.stuartsierra/dependency "0.2.0"]
         [com.taoensso/nippy "2.14.0"]
         [com.taoensso/encore "2.114.0"]
         [org.agrona/agrona "1.0.0"]])

(def licenses (for [lib (partition 2 (flatten
                                       (for [p ps]
                                         (reduce
                                           (fn [r t]
                                             (when (= (first (second t)) p)
                                               (reduced (flatten (rest t)))))
                                           (map-indexed vector tree)))))]
                [lib (reduce
                       (fn [r ll] 
                         (when (= (first ll) lib)
                           (reduced (second ll))))
                       l)]))

; (clojure.pprint/pprint licenses)

(comment ; output

([(org.clojure/clojure "1.10.0") "Eclipse Public License 1.0"]
 [(org.clojure/core.specs.alpha "0.2.44") "Eclipse Public License 1.0"]
 [(org.clojure/spec.alpha "0.2.176") "Eclipse Public License 1.0"]
 [(org.clojure/tools.logging "0.4.1") "Eclipse Public License 1.0"]
 [(com.stuartsierra/dependency "0.2.0") "Eclipse Public License"]
 [(com.taoensso/nippy "2.14.0") "Eclipse Public License"]
 [(net.jpountz.lz4/lz4 "1.3") "Apache v2.0 license"]
 [(org.clojure/tools.reader "1.1.1") "Eclipse Public License 1.0"]
 [(org.iq80.snappy/snappy "0.4") "Apache License 2.0"]
 [(org.tukaani/xz "1.6") "Public Domain"]
 [(com.taoensso/encore "2.114.0") "Eclipse Public License"]
 [(com.taoensso/truss "1.5.0") "Eclipse Public License"]
 [(org.agrona/agrona "1.0.0") "Apache v2.0 license"])

)
