// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('crux.ui.uikit.utils');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('reagent.core');
crux.ui.uikit.utils.example_data = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$columns,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$column_DASH_key,cljs.core.cst$kw$status,cljs.core.cst$kw$column_DASH_name,"Status"], null),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$column_DASH_key,cljs.core.cst$kw$scale_DASH_id,cljs.core.cst$kw$column_DASH_name,"ScaleID",cljs.core.cst$kw$render_DASH_fn,(function (row,v){
return null;
}),cljs.core.cst$kw$render_DASH_only,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$custom_DASH_one_QMARK_,null,cljs.core.cst$kw$filter,null,cljs.core.cst$kw$sort,null], null), null)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$column_DASH_key,cljs.core.cst$kw$name,cljs.core.cst$kw$column_DASH_name,"Name"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$column_DASH_key,cljs.core.cst$kw$location,cljs.core.cst$kw$column_DASH_name,"Location"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$column_DASH_key,cljs.core.cst$kw$error,cljs.core.cst$kw$column_DASH_name,"Error"], null)], null),cljs.core.cst$kw$rows,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,cljs.core.random_uuid(),cljs.core.cst$kw$status,"ok",cljs.core.cst$kw$scale_DASH_id,"ASD",cljs.core.cst$kw$name,"luch",cljs.core.cst$kw$location,"London",cljs.core.cst$kw$error,"Overload"], null),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,cljs.core.random_uuid(),cljs.core.cst$kw$status,"something",cljs.core.cst$kw$scale_DASH_id,"ASD",cljs.core.cst$kw$name,"luch",cljs.core.cst$kw$location,"London",cljs.core.cst$kw$error,"Overload"], null)], null),cljs.core.cst$kw$filters,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$input,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$scale_DASH_id,null], null), null),cljs.core.cst$kw$select,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,null,cljs.core.cst$kw$error,null], null), null),cljs.core.cst$kw$select_DASH_normalize,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$status,null], null), null)], null),cljs.core.cst$kw$utils,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$filter_DASH_all,"value",cljs.core.cst$kw$filter_DASH_columns,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["a",null,"b",null], null), null),cljs.core.cst$kw$scale_DASH_id,"id"], null),cljs.core.cst$kw$hidden,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,true,cljs.core.cst$kw$name,false], null),cljs.core.cst$kw$pagination,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$rows_DASH_per_DASH_page,(34),cljs.core.cst$kw$current_DASH_page,(3)], null),cljs.core.cst$kw$sort,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$status,cljs.core.cst$kw$asc], null)], null)], null);
crux.ui.uikit.utils.component_hide_show = (function crux$ui$uikit$utils$component_hide_show(var_args){
var args__4534__auto__ = [];
var len__4531__auto___28486 = arguments.length;
var i__4532__auto___28487 = (0);
while(true){
if((i__4532__auto___28487 < len__4531__auto___28486)){
args__4534__auto__.push((arguments[i__4532__auto___28487]));

var G__28488 = (i__4532__auto___28487 + (1));
i__4532__auto___28487 = G__28488;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return crux.ui.uikit.utils.component_hide_show.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

crux.ui.uikit.utils.component_hide_show.cljs$core$IFn$_invoke$arity$variadic = (function (component,p__28482){
var vec__28483 = p__28482;
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28483,(0),null);
var _BANG_ref_toggle = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _BANG_ref_box = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var active_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var handler = ((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,vec__28483,args){
return (function (e){
var node = e.target;
if(cljs.core.truth_(cljs.core.deref(_BANG_ref_box).contains(node))){
return null;
} else {
if(cljs.core.truth_(cljs.core.deref(_BANG_ref_toggle).contains(node))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(active_QMARK_,cljs.core.not);
} else {
return cljs.core.reset_BANG_(active_QMARK_,false);

}
}
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,vec__28483,args))
;
var ref_toggle = ((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,vec__28483,args){
return (function (el){
return cljs.core.reset_BANG_(_BANG_ref_toggle,el);
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,vec__28483,args))
;
var ref_box = ((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,vec__28483,args){
return (function (el){
return cljs.core.reset_BANG_(_BANG_ref_box,el);
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,vec__28483,args))
;
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args){
return (function (){
return document.addEventListener("mouseup",handler);
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args){
return (function (){
return document.removeEventListener("mouseup",handler);
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args))
,cljs.core.cst$kw$reagent_DASH_render,((function (_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args){
return (function (component__$1){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [component__$1,cljs.core.deref(active_QMARK_),ref_toggle,ref_box,args], null);
});})(_BANG_ref_toggle,_BANG_ref_box,active_QMARK_,handler,ref_toggle,ref_box,vec__28483,args))
], null));
});

crux.ui.uikit.utils.component_hide_show.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
crux.ui.uikit.utils.component_hide_show.cljs$lang$applyTo = (function (seq28480){
var G__28481 = cljs.core.first(seq28480);
var seq28480__$1 = cljs.core.next(seq28480);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28481,seq28480__$1);
});

crux.ui.uikit.utils.process_string = (function crux$ui$uikit$utils$process_string(s){
var G__28489 = s;
var G__28489__$1 = (((G__28489 == null))?null:cljs.core.not_empty(G__28489));
var G__28489__$2 = (((G__28489__$1 == null))?null:clojure.string.trim(G__28489__$1));
var G__28489__$3 = (((G__28489__$2 == null))?null:clojure.string.lower_case(G__28489__$2));
if((G__28489__$3 == null)){
return null;
} else {
return clojure.string.replace(G__28489__$3,/\s+/," ");
}
});
crux.ui.uikit.utils.reset_pagination = (function crux$ui$uikit$utils$reset_pagination(table){
return cljs.core.assoc_in(table,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$current_DASH_page], null),(0));
});
crux.ui.uikit.utils.column_sort = (function crux$ui$uikit$utils$column_sort(table_atom,column_key){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28490_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(crux.ui.uikit.utils.reset_pagination(p1__28490_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$sort], null),(function (m){
var curr_column_key = cljs.core.ffirst(m);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(curr_column_key,column_key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(m,column_key,((function (curr_column_key){
return (function (order){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$asc,order)){
return cljs.core.cst$kw$desc;
} else {
return cljs.core.cst$kw$asc;
}
});})(curr_column_key))
);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([column_key,cljs.core.cst$kw$asc]);
}
}));
}));
});
crux.ui.uikit.utils.column_sort_icon = (function crux$ui$uikit$utils$column_sort_icon(table,column_key){
var sort = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$sort], null));
var G__28491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sort,column_key);
var G__28491__$1 = (((G__28491 instanceof cljs.core.Keyword))?G__28491.fqn:null);
switch (G__28491__$1) {
case "asc":
return "fa-caret-down";

break;
case "desc":
return "fa-caret-up";

break;
default:
return "fa-caret-down";

}
});
crux.ui.uikit.utils.column_sort_value = (function crux$ui$uikit$utils$column_sort_value(table){
return cljs.core.cst$kw$sort.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$utils.cljs$core$IFn$_invoke$arity$1(table));
});
crux.ui.uikit.utils.column_filter_value = (function crux$ui$uikit$utils$column_filter_value(table,column_key){
var G__28493 = cljs.core.cst$kw$filter_DASH_columns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$utils.cljs$core$IFn$_invoke$arity$1(table));
return (column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(G__28493) : column_key.call(null,G__28493));
});
crux.ui.uikit.utils.column_filter_on_change = (function crux$ui$uikit$utils$column_filter_on_change(evt,table_atom,column_key){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28494_SHARP_){
return cljs.core.assoc_in(crux.ui.uikit.utils.reset_pagination(p1__28494_SHARP_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns,column_key], null),evt.target.value);
}));
});
crux.ui.uikit.utils.column_filter_reset = (function crux$ui$uikit$utils$column_filter_reset(table_atom,column_key){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(table_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([column_key], 0));
});
crux.ui.uikit.utils.column_filter_type = (function crux$ui$uikit$utils$column_filter_type(data,column_key){
var input_filters = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters,cljs.core.cst$kw$input], null));
var select_filters = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters,cljs.core.cst$kw$select], null));
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(input_filters,column_key))){
return cljs.core.cst$kw$input;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(select_filters,column_key))){
return cljs.core.cst$kw$select;
} else {
return null;

}
}
});
crux.ui.uikit.utils.render_fn = (function crux$ui$uikit$utils$render_fn(data,column_key){
var G__28496 = cljs.core.cst$kw$columns.cljs$core$IFn$_invoke$arity$1(data);
var G__28496__$1 = (((G__28496 == null))?null:cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__28496){
return (function (p1__28495_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(column_key,cljs.core.cst$kw$column_DASH_key.cljs$core$IFn$_invoke$arity$1(p1__28495_SHARP_));
});})(G__28496))
,G__28496));
var G__28496__$2 = (((G__28496__$1 == null))?null:cljs.core.first(G__28496__$1));
if((G__28496__$2 == null)){
return null;
} else {
return cljs.core.cst$kw$render_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__28496__$2);
}
});
crux.ui.uikit.utils.process_cell_value = (function crux$ui$uikit$utils$process_cell_value(var_args){
var G__28498 = arguments.length;
switch (G__28498) {
case 4:
return crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$4 = (function (data,row,column_key,value){
return crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5(data,row,column_key,value,true);
});

crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5 = (function (data,row,column_key,value,allow_QMARK_){
var render_fn = crux.ui.uikit.utils.render_fn(data,column_key);
if(cljs.core.truth_((function (){var and__3938__auto__ = allow_QMARK_;
if(cljs.core.truth_(and__3938__auto__)){
return render_fn;
} else {
return and__3938__auto__;
}
})())){
return (render_fn.cljs$core$IFn$_invoke$arity$2 ? render_fn.cljs$core$IFn$_invoke$arity$2(row,value) : render_fn.call(null,row,value));
} else {
return value;
}
});

crux.ui.uikit.utils.process_cell_value.cljs$lang$maxFixedArity = 5;

crux.ui.uikit.utils.column_select_filter_options = (function crux$ui$uikit$utils$column_select_filter_options(data,column_key){
var processed_val = (function (p1__28500_SHARP_){
return crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$4(data,p1__28500_SHARP_,column_key,(column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(p1__28500_SHARP_) : column_key.call(null,p1__28500_SHARP_)));
});
var options = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (processed_val){
return (function (p__28501){
var vec__28502 = p__28501;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28502,(0),null);
var vec__28505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28502,(1),null);
var group = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28505,(0),null);
return group;
});})(processed_val))
,cljs.core.group_by(cljs.core.second,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (processed_val){
return (function (row){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_key,(column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(row) : column_key.call(null,row)),processed_val(row)], null);
});})(processed_val))
,cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data)))));
return options;
});
crux.ui.uikit.utils.column_select_filter_on_change = (function crux$ui$uikit$utils$column_select_filter_on_change(table_atom,column_key,value,processed_value){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28508_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(crux.ui.uikit.utils.reset_pagination(p1__28508_SHARP_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns,column_key], null),(function (selected_values){
var val_AMPERSAND_processed = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [value,processed_value], null);
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(selected_values,val_AMPERSAND_processed))){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(selected_values,val_AMPERSAND_processed);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var fexpr__28509 = cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY);
return (fexpr__28509.cljs$core$IFn$_invoke$arity$1 ? fexpr__28509.cljs$core$IFn$_invoke$arity$1(selected_values) : fexpr__28509.call(null,selected_values));
})(),val_AMPERSAND_processed);
}
}));
}));
});
crux.ui.uikit.utils.column_select_filter_value = (function crux$ui$uikit$utils$column_select_filter_value(table,column_key,value,processed_value){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(table,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns,column_key,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [value,processed_value], null),(0)], null),false);
});
crux.ui.uikit.utils.column_select_filter_reset = (function crux$ui$uikit$utils$column_select_filter_reset(table_atom,column_key,value){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(table_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns,column_key], null),(function (column_filters){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (v){
return ((cljs.core.vector_QMARK_(v)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(v),value)));
}),column_filters));
}));
});
crux.ui.uikit.utils.column_filter_reset_all = (function crux$ui$uikit$utils$column_filter_reset_all(table_atom){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28510_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(crux.ui.uikit.utils.reset_pagination(p1__28510_SHARP_),cljs.core.cst$kw$utils,cljs.core.dissoc,cljs.core.cst$kw$filter_DASH_columns);
}));
});
crux.ui.uikit.utils.filter_all_value = (function crux$ui$uikit$utils$filter_all_value(table){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_all], null),"");
});
crux.ui.uikit.utils.filter_all_on_change = (function crux$ui$uikit$utils$filter_all_on_change(evt,table_atom){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28511_SHARP_){
return cljs.core.assoc_in(crux.ui.uikit.utils.reset_pagination(p1__28511_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_all], null),evt.target.value);
}));
});
crux.ui.uikit.utils.filter_all_reset = (function crux$ui$uikit$utils$filter_all_reset(table_atom){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28512_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(crux.ui.uikit.utils.reset_pagination(p1__28512_SHARP_),cljs.core.cst$kw$utils,cljs.core.dissoc,cljs.core.cst$kw$filter_DASH_all);
}));
});
/**
 * Collect only the active column filters for UI
 */
crux.ui.uikit.utils.block_filter_values = (function crux$ui$uikit$utils$block_filter_values(table){
return cljs.core.not_empty(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__28514){
var vec__28515 = p__28514;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28515,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28515,(1),null);
if(cljs.core.set_QMARK_(v)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__28515,k,v){
return (function (p1__28513_SHARP_){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[k,p1__28513_SHARP_,cljs.core.cst$kw$select],null));
});})(vec__28515,k,v))
,v);
} else {
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null)],null));
}
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.empty_QMARK_,cljs.core.second),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns], null))))));
});
crux.ui.uikit.utils.column_visible_QMARK_ = (function crux$ui$uikit$utils$column_visible_QMARK_(table,column_key){
return cljs.core.not((function (){var G__28518 = cljs.core.cst$kw$hidden.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$utils.cljs$core$IFn$_invoke$arity$1(table));
return (column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(G__28518) : column_key.call(null,G__28518));
})());
});
crux.ui.uikit.utils.column_visibility_on_change = (function crux$ui$uikit$utils$column_visibility_on_change(table_atom,column_key){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28519_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(crux.ui.uikit.utils.reset_pagination(p1__28519_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns], null),cljs.core.dissoc,column_key),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$hidden,column_key], null),cljs.core.not);
}));
});
/**
 * Transform hidden column keys from map to vec
 */
crux.ui.uikit.utils.hidden_columns = (function crux$ui$uikit$utils$hidden_columns(table){
return cljs.core.not_empty(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.cst$kw$hidden.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$utils.cljs$core$IFn$_invoke$arity$1(table)))));
});
crux.ui.uikit.utils.table_columns = (function crux$ui$uikit$utils$table_columns(data,table){
var columns = cljs.core.cst$kw$columns.cljs$core$IFn$_invoke$arity$1(data);
var hidden = cljs.core.cst$kw$hidden.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$utils.cljs$core$IFn$_invoke$arity$1(table));
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (columns,hidden){
return (function (p1__28520_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(hidden,cljs.core.cst$kw$column_DASH_key.cljs$core$IFn$_invoke$arity$1(p1__28520_SHARP_));
});})(columns,hidden))
,columns);
});
crux.ui.uikit.utils.pagination_info = (function crux$ui$uikit$utils$pagination_info(data,processed_rows){
var rows_count = cljs.core.count(processed_rows);
var offset = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(data);
var sum_rows_offset = (rows_count + offset);
if((rows_count === (0))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((offset + (1)))," - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((offset + (1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((offset + (1)))," - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sum_rows_offset)].join('');
}
});
crux.ui.uikit.utils.pagination_rows_per_page_on_change = (function crux$ui$uikit$utils$pagination_rows_per_page_on_change(evt,table_atom){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(table_atom,(function (p1__28521_SHARP_){
return cljs.core.assoc_in(cljs.core.assoc_in(p1__28521_SHARP_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$rows_DASH_per_DASH_page], null),parseInt(evt.target.value)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$current_DASH_page], null),(0));
}));
});
crux.ui.uikit.utils.pagination_rows_per_page = (function crux$ui$uikit$utils$pagination_rows_per_page(table){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(table,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$rows_DASH_per_DASH_page], null),(10));
});
crux.ui.uikit.utils.pagination_current_page = (function crux$ui$uikit$utils$pagination_current_page(table){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(table,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$current_DASH_page], null),(0));
});
crux.ui.uikit.utils.pagination_current_and_total_pages = (function crux$ui$uikit$utils$pagination_current_and_total_pages(table,processed_rows){
var offset = crux.ui.uikit.utils.pagination_current_page(table);
var rows_per_page = crux.ui.uikit.utils.pagination_rows_per_page(table);
var nth_rows_at_page = (rows_per_page + (offset * rows_per_page));
var nth_rows = cljs.core.count(processed_rows);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(((offset * rows_per_page) + (1))),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((nth_rows_at_page > nth_rows))?nth_rows:nth_rows_at_page))," of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(nth_rows)].join('');
});
crux.ui.uikit.utils.pagination_rows_exhausted_QMARK_ = (function crux$ui$uikit$utils$pagination_rows_exhausted_QMARK_(table,processed_rows){
var current_page = crux.ui.uikit.utils.pagination_current_page(table);
var rows_per_page = crux.ui.uikit.utils.pagination_rows_per_page(table);
var tot_rows = cljs.core.count(processed_rows);
var left_rows = ((tot_rows - (rows_per_page * current_page)) - rows_per_page);
return (((left_rows === (0))) || ((left_rows < (0))));
});
crux.ui.uikit.utils.pagination_inc_page = (function crux$ui$uikit$utils$pagination_inc_page(table_atom,processed_rows){
if(cljs.core.truth_(crux.ui.uikit.utils.pagination_rows_exhausted_QMARK_(cljs.core.deref(table_atom),processed_rows))){
return null;
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(table_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$current_DASH_page], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.inc,(0)));
}
});
crux.ui.uikit.utils.pagination_dec_page = (function crux$ui$uikit$utils$pagination_dec_page(table_atom){
if((crux.ui.uikit.utils.pagination_current_page(cljs.core.deref(table_atom)) > (0))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(table_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$pagination,cljs.core.cst$kw$current_DASH_page], null),cljs.core.dec);
} else {
return null;
}
});
crux.ui.uikit.utils.render_fn_allow_QMARK_ = (function crux$ui$uikit$utils$render_fn_allow_QMARK_(data,column_key,operation){
var column_map = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28522_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(column_key,cljs.core.cst$kw$column_DASH_key.cljs$core$IFn$_invoke$arity$1(p1__28522_SHARP_));
}),cljs.core.cst$kw$columns.cljs$core$IFn$_invoke$arity$1(data)));
var deny_QMARK_ = (function (){var G__28523 = cljs.core.cst$kw$render_DASH_only.cljs$core$IFn$_invoke$arity$1(column_map);
return (operation.cljs$core$IFn$_invoke$arity$1 ? operation.cljs$core$IFn$_invoke$arity$1(G__28523) : operation.call(null,G__28523));
})();
return cljs.core.not(deny_QMARK_);
});
crux.ui.uikit.utils.date_QMARK_ = (function crux$ui$uikit$utils$date_QMARK_(d){
return (d instanceof Date);
});
crux.ui.uikit.utils.date_as_sortable = (function crux$ui$uikit$utils$date_as_sortable(d){
return d.getTime();
});
crux.ui.uikit.utils.compare_vals = (function crux$ui$uikit$utils$compare_vals(x,y){
if(((((typeof x === 'number') && (typeof y === 'number'))) || (((typeof x === 'string') && (typeof y === 'string'))) || (((cljs.core.boolean_QMARK_(x)) && (cljs.core.boolean_QMARK_(y)))))){
return cljs.core.compare(x,y);
} else {
if(cljs.core.truth_((function (){var and__3938__auto__ = crux.ui.uikit.utils.date_QMARK_(x);
if(cljs.core.truth_(and__3938__auto__)){
return crux.ui.uikit.utils.date_QMARK_(y);
} else {
return and__3938__auto__;
}
})())){
return cljs.core.compare(crux.ui.uikit.utils.date_as_sortable(x),crux.ui.uikit.utils.date_as_sortable(y));
} else {
return cljs.core.compare([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(''));

}
}
});
crux.ui.uikit.utils.resolve_sorting = (function crux$ui$uikit$utils$resolve_sorting(data,table,rows){
var temp__5733__auto__ = crux.ui.uikit.utils.column_sort_value(table);
if(cljs.core.truth_(temp__5733__auto__)){
var m = temp__5733__auto__;
var column_key = cljs.core.ffirst(m);
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,column_key);
var allow_sort_QMARK_ = crux.ui.uikit.utils.render_fn_allow_QMARK_(data,column_key,cljs.core.cst$kw$sort);
var processed_val = ((function (column_key,order,allow_sort_QMARK_,m,temp__5733__auto__){
return (function (row){
return crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5(data,row,column_key,(column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(row) : column_key.call(null,row)),allow_sort_QMARK_);
});})(column_key,order,allow_sort_QMARK_,m,temp__5733__auto__))
;
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(((function (column_key,order,allow_sort_QMARK_,processed_val,m,temp__5733__auto__){
return (function (row1,row2){
var val1 = processed_val(row1);
var val2 = processed_val(row2);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$desc,order)){
return crux.ui.uikit.utils.compare_vals(val2,val1);
} else {
return crux.ui.uikit.utils.compare_vals(val1,val2);
}
});})(column_key,order,allow_sort_QMARK_,processed_val,m,temp__5733__auto__))
,rows);
} else {
return rows;
}
});
crux.ui.uikit.utils.column_filters = (function crux$ui$uikit$utils$column_filters(table){
return cljs.core.not_empty(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__28524){
var vec__28525 = p__28524;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28525,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28525,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,((typeof v === 'string')?crux.ui.uikit.utils.process_string(v):v)], null);
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (k_v){
return cljs.core.empty_QMARK_(cljs.core.second(k_v));
}),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$utils,cljs.core.cst$kw$filter_DASH_columns], null)))));
});
crux.ui.uikit.utils.resolve_column_filtering = (function crux$ui$uikit$utils$resolve_column_filtering(data,table,rows){
var temp__5733__auto__ = crux.ui.uikit.utils.column_filters(table);
if(cljs.core.truth_(temp__5733__auto__)){
var column_filters = temp__5733__auto__;
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (column_filters,temp__5733__auto__){
return (function (row){
return cljs.core.every_QMARK_(((function (column_filters,temp__5733__auto__){
return (function (p__28528){
var vec__28529 = p__28528;
var column_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28529,(0),null);
var filtering = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28529,(1),null);
var allow_filter_QMARK_ = crux.ui.uikit.utils.render_fn_allow_QMARK_(data,column_key,cljs.core.cst$kw$filter);
var processed_val = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5(data,row,column_key,(column_key.cljs$core$IFn$_invoke$arity$1 ? column_key.cljs$core$IFn$_invoke$arity$1(row) : column_key.call(null,row)),allow_filter_QMARK_))].join('');
if(typeof filtering === 'string'){
return clojure.string.includes_QMARK_(clojure.string.lower_case(processed_val),filtering);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,(cljs.core.truth_(allow_filter_QMARK_)?cljs.core.second:cljs.core.first)),filtering)),processed_val);
}
});})(column_filters,temp__5733__auto__))
,column_filters);
});})(column_filters,temp__5733__auto__))
,rows);
} else {
return rows;
}
});
crux.ui.uikit.utils.resolve_filter_all = (function crux$ui$uikit$utils$resolve_filter_all(data,table,rows){
var temp__5733__auto__ = crux.ui.uikit.utils.process_string(crux.ui.uikit.utils.filter_all_value(table));
if(cljs.core.truth_(temp__5733__auto__)){
var filter_value = temp__5733__auto__;
var column_keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (filter_value,temp__5733__auto__){
return (function (p1__28532_SHARP_){
return cljs.core.cst$kw$column_DASH_key.cljs$core$IFn$_invoke$arity$1(p1__28532_SHARP_);
});})(filter_value,temp__5733__auto__))
,(function (){var G__28533 = cljs.core.cst$kw$columns;
return (data.cljs$core$IFn$_invoke$arity$1 ? data.cljs$core$IFn$_invoke$arity$1(G__28533) : data.call(null,G__28533));
})());
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (column_keys,filter_value,temp__5733__auto__){
return (function (row){
return cljs.core.some(((function (column_keys,filter_value,temp__5733__auto__){
return (function (p__28534){
var vec__28535 = p__28534;
var column_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28535,(0),null);
var cell_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28535,(1),null);
var allow_filter_QMARK_ = crux.ui.uikit.utils.render_fn_allow_QMARK_(data,column_key,cljs.core.cst$kw$filter);
var processed_val = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(crux.ui.uikit.utils.process_cell_value.cljs$core$IFn$_invoke$arity$5(data,row,column_key,cell_value,allow_filter_QMARK_))].join('');
return clojure.string.includes_QMARK_(clojure.string.lower_case(processed_val),filter_value);
});})(column_keys,filter_value,temp__5733__auto__))
,cljs.core.select_keys(row,column_keys));
});})(column_keys,filter_value,temp__5733__auto__))
,rows);
} else {
return rows;
}
});
crux.ui.uikit.utils.resolve_hidden_columns = (function crux$ui$uikit$utils$resolve_hidden_columns(table,rows){
var temp__5733__auto__ = crux.ui.uikit.utils.hidden_columns(table);
if(cljs.core.truth_(temp__5733__auto__)){
var columns_to_hide = temp__5733__auto__;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (columns_to_hide,temp__5733__auto__){
return (function (row){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,row,columns_to_hide);
});})(columns_to_hide,temp__5733__auto__))
,rows);
} else {
return rows;
}
});
crux.ui.uikit.utils.resolve_pagination = (function crux$ui$uikit$utils$resolve_pagination(table,rows){
var current_page = crux.ui.uikit.utils.pagination_current_page(table);
var rows_per_page = crux.ui.uikit.utils.pagination_rows_per_page(table);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows,((cljs.core.seq(rows))?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2(rows_per_page,rows),current_page):null)], null);
});
crux.ui.uikit.utils.process_rows = (function crux$ui$uikit$utils$process_rows(data,table){
var rows = cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data);
return crux.ui.uikit.utils.resolve_pagination(table,crux.ui.uikit.utils.resolve_filter_all(data,table,crux.ui.uikit.utils.resolve_column_filtering(data,table,crux.ui.uikit.utils.resolve_sorting(data,table,crux.ui.uikit.utils.resolve_hidden_columns(table,rows)))));
});
