// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__20833){
var vec__20834 = p__20833;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20834,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20834,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__20837 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20837,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20837,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20837,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__20841 = arguments.length;
switch (G__20841) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4037__auto__ = cljs.core.count(a);
var y__4038__auto__ = cljs.core.count(b);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));
} else {
var m__4244__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4243__auto__ = (((a == null))?null:a);
var m__4244__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto__.call(null,a,b));
} else {
var m__4244__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__20843_20867 = clojure.data.equality_partition;
var G__20844_20868 = "null";
var G__20845_20869 = ((function (G__20843_20867,G__20844_20868){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20843_20867,G__20844_20868))
;
goog.object.set(G__20843_20867,G__20844_20868,G__20845_20869);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__20846_20870 = clojure.data.equality_partition;
var G__20847_20871 = "string";
var G__20848_20872 = ((function (G__20846_20870,G__20847_20871){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20846_20870,G__20847_20871))
;
goog.object.set(G__20846_20870,G__20847_20871,G__20848_20872);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__20849_20873 = clojure.data.equality_partition;
var G__20850_20874 = "number";
var G__20851_20875 = ((function (G__20849_20873,G__20850_20874){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20849_20873,G__20850_20874))
;
goog.object.set(G__20849_20873,G__20850_20874,G__20851_20875);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__20852_20876 = clojure.data.equality_partition;
var G__20853_20877 = "array";
var G__20854_20878 = ((function (G__20852_20876,G__20853_20877){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__20852_20876,G__20853_20877))
;
goog.object.set(G__20852_20876,G__20853_20877,G__20854_20878);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__20855_20879 = clojure.data.equality_partition;
var G__20856_20880 = "function";
var G__20857_20881 = ((function (G__20855_20879,G__20856_20880){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20855_20879,G__20856_20880))
;
goog.object.set(G__20855_20879,G__20856_20880,G__20857_20881);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__20858_20882 = clojure.data.equality_partition;
var G__20859_20883 = "boolean";
var G__20860_20884 = ((function (G__20858_20882,G__20859_20883){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20858_20882,G__20859_20883))
;
goog.object.set(G__20858_20882,G__20859_20883,G__20860_20884);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__20861_20885 = clojure.data.equality_partition;
var G__20862_20886 = "_";
var G__20863_20887 = ((function (G__20861_20885,G__20862_20886){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__20861_20885,G__20862_20886))
;
goog.object.set(G__20861_20885,G__20862_20886,G__20863_20887);
goog.object.set(clojure.data.Diff,"null",true);

var G__20888_20912 = clojure.data.diff_similar;
var G__20889_20913 = "null";
var G__20890_20914 = ((function (G__20888_20912,G__20889_20913){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20888_20912,G__20889_20913))
;
goog.object.set(G__20888_20912,G__20889_20913,G__20890_20914);

goog.object.set(clojure.data.Diff,"string",true);

var G__20891_20915 = clojure.data.diff_similar;
var G__20892_20916 = "string";
var G__20893_20917 = ((function (G__20891_20915,G__20892_20916){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20891_20915,G__20892_20916))
;
goog.object.set(G__20891_20915,G__20892_20916,G__20893_20917);

goog.object.set(clojure.data.Diff,"number",true);

var G__20894_20918 = clojure.data.diff_similar;
var G__20895_20919 = "number";
var G__20896_20920 = ((function (G__20894_20918,G__20895_20919){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20894_20918,G__20895_20919))
;
goog.object.set(G__20894_20918,G__20895_20919,G__20896_20920);

goog.object.set(clojure.data.Diff,"array",true);

var G__20897_20921 = clojure.data.diff_similar;
var G__20898_20922 = "array";
var G__20899_20923 = ((function (G__20897_20921,G__20898_20922){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__20897_20921,G__20898_20922))
;
goog.object.set(G__20897_20921,G__20898_20922,G__20899_20923);

goog.object.set(clojure.data.Diff,"function",true);

var G__20900_20924 = clojure.data.diff_similar;
var G__20901_20925 = "function";
var G__20902_20926 = ((function (G__20900_20924,G__20901_20925){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20900_20924,G__20901_20925))
;
goog.object.set(G__20900_20924,G__20901_20925,G__20902_20926);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__20903_20927 = clojure.data.diff_similar;
var G__20904_20928 = "boolean";
var G__20905_20929 = ((function (G__20903_20927,G__20904_20928){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20903_20927,G__20904_20928))
;
goog.object.set(G__20903_20927,G__20904_20928,G__20905_20929);

goog.object.set(clojure.data.Diff,"_",true);

var G__20906_20930 = clojure.data.diff_similar;
var G__20907_20931 = "_";
var G__20908_20932 = ((function (G__20906_20930,G__20907_20931){
return (function (a,b){
var fexpr__20910 = (function (){var G__20911 = clojure.data.equality_partition(a);
var G__20911__$1 = (((G__20911 instanceof cljs.core.Keyword))?G__20911.fqn:null);
switch (G__20911__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20911__$1)].join('')));

}
})();
return (fexpr__20910.cljs$core$IFn$_invoke$arity$2 ? fexpr__20910.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__20910.call(null,a,b));
});})(G__20906_20930,G__20907_20931))
;
goog.object.set(G__20906_20930,G__20907_20931,G__20908_20932);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
