// Compiled by ClojureScript 1.10.339 {}
goog.provide('crux.ui.codemirror');
goog.require('cljs.core');
goog.require('cljsjs.codemirror');
goog.require('cljsjs.codemirror.mode.clojure');
goog.require('cljsjs.codemirror.mode.javascript');
goog.require('cljsjs.codemirror.addon.edit.closebrackets');
goog.require('cljsjs.codemirror.addon.edit.matchbrackets');
goog.require('cljsjs.codemirror.addon.hint.show_hint');
goog.require('cljsjs.codemirror.addon.hint.anyword_hint');
goog.require('cljsjs.codemirror.addon.display.autorefresh');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('goog.object');
goog.require('goog.string');
goog.require('cljs.pprint');
crux.ui.codemirror.escape_re = (function crux$ui$codemirror$escape_re(input){
var re = (new RegExp("([.*+?^=!:${}()|[\\]\\/\\\\])","g"));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(input)].join('').replace(re,"\\$1");
});
crux.ui.codemirror.fuzzy_re = (function crux$ui$codemirror$fuzzy_re(input){
return RegExp(cljs.core.reduce.call(null,(function (s,c){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),cljs.core.str.cljs$core$IFn$_invoke$arity$1(crux.ui.codemirror.escape_re.call(null,c)),".*"].join('');
}),"",input),"i");
});
crux.ui.codemirror.crux_builtin_keywords = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"rules","rules",1198912366),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"order-by","order-by",1527318070),new cljs.core.Keyword(null,"timeout","timeout",-318625318),new cljs.core.Keyword(null,"full-results?","full-results?",498698591),new cljs.core.Keyword("crux.db","id","crux.db/id",1812338074)], null);
crux.ui.codemirror.autocomplete = (function crux$ui$codemirror$autocomplete(index,cm,options){
var cur = cm.getCursor();
var line = cur.line;
var ch = cur.ch;
var token = cm.getTokenAt(cur);
var reg = cljs.core.subs.call(null,token.string,(0),(ch - token.start));
var blank_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["(",null,"{",null,"[",null," ",null], null), null).call(null,reg);
var start = (cljs.core.truth_(blank_QMARK_)?cur:CodeMirror.Pos(line,goog.object.get(token,"start")));
var end = (cljs.core.truth_(blank_QMARK_)?cur:CodeMirror.Pos(line,goog.object.get(token,"end")));
var words = cljs.core.concat.call(null,crux.ui.codemirror.crux_builtin_keywords,index);
var fuzzy = (cljs.core.truth_(blank_QMARK_)?/.*/:crux.ui.codemirror.fuzzy_re.call(null,reg));
var words__$1 = cljs.core.filter.call(null,((function (cur,line,ch,token,reg,blank_QMARK_,start,end,words,fuzzy){
return (function (p1__41030_SHARP_){
return cljs.core.re_find.call(null,fuzzy,p1__41030_SHARP_);
});})(cur,line,ch,token,reg,blank_QMARK_,start,end,words,fuzzy))
,cljs.core.map.call(null,cljs.core.str,words));
return cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"list","list",765357683),words__$1,new cljs.core.Keyword(null,"from","from",1815293044),start,new cljs.core.Keyword(null,"to","to",192099007),end], null));
});
crux.ui.codemirror.code_mirror = (function crux$ui$codemirror$code_mirror(initial_value,p__41031){
var map__41032 = p__41031;
var map__41032__$1 = ((((!((map__41032 == null)))?(((((map__41032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41032):map__41032);
var cm_instance = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"cm-instance","cm-instance",1889208187));
var class$ = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var stats = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var on_change = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_blur = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_cm_init = cljs.core.get.call(null,map__41032__$1,new cljs.core.Keyword(null,"on-cm-init","on-cm-init",105207782));
var value_atom = cljs.core.atom.call(null,(function (){var or__3949__auto__ = initial_value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
var on_change__$1 = (function (){var or__3949__auto__ = on_change;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.constantly.call(null,null);
}
})();
var on_blur__$1 = (function (){var or__3949__auto__ = on_blur;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.constantly.call(null,null);
}
})();
var cm_inst = (function (){var or__3949__auto__ = cm_instance;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.atom.call(null,null);
}
})();
var indexes = ((cljs.core.map_QMARK_.call(null,stats))?cljs.core.keys.call(null,stats):null);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (this$){
var el = reagent.dom.dom_node.call(null,this$);
var opts = ({"autoRefresh": true, "matchBrackets": true, "value": cljs.core.deref.call(null,value_atom), "extraKeys": new cljs.core.PersistentArrayMap(null, 1, ["Ctrl-Space","autocomplete"], null), "theme": "eclipse", "viewportMargin": Infinity, "undoDepth": (100000000), "hintOptions": ({"hint": cljs.core.partial.call(null,crux.ui.codemirror.autocomplete,indexes), "completeSingle": false}), "historyEventDelay": (1), "lineNumbers": true, "autoCloseBrackets": true});
var inst = cljs.core.reset_BANG_.call(null,cm_inst,(new CodeMirror(el,opts)));
inst.on("keyup",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (cm,e){
if(((cljs.core.not.call(null,goog.object.getValueByKeys(cm,["state","completionActive"]))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,goog.object.get(e,"key")))) && (cljs.core._EQ_.call(null,goog.object.get(e,"key"),":")))){
return inst.showHint();
} else {
return null;
}
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

inst.on("change",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
var value = inst.getValue();
if(cljs.core._EQ_.call(null,value,cljs.core.deref.call(null,value_atom))){
return null;
} else {
on_change__$1.call(null,value);

return cljs.core.reset_BANG_.call(null,value_atom,value);
}
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

inst.on("blur",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
return on_blur__$1.call(null);
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

if(cljs.core.truth_(on_cm_init)){
return on_cm_init.call(null,inst);
} else {
return null;
}
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,value_atom),cljs.core.deref.call(null,cm_inst).getValue())){
return null;
} else {
cljs.core.deref.call(null,cm_inst).setValue(cljs.core.deref.call(null,value_atom));

var last_line = cljs.core.deref.call(null,cm_inst).lastLine();
var last_ch = cljs.core.count.call(null,cljs.core.deref.call(null,cm_inst).getLine(last_line));
return cljs.core.deref.call(null,cm_inst).setCursor(last_line,last_ch);
}
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.textarea","div.textarea",964106957),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),class$], null)], null);
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__41032,map__41032__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
], null));
});
crux.ui.codemirror.code_mirror_static = (function crux$ui$codemirror$code_mirror_static(initial_value,p__41034){
var map__41035 = p__41034;
var map__41035__$1 = ((((!((map__41035 == null)))?(((((map__41035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41035.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41035):map__41035);
var cm_instance = cljs.core.get.call(null,map__41035__$1,new cljs.core.Keyword(null,"cm-instance","cm-instance",1889208187));
var class$ = cljs.core.get.call(null,map__41035__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var value_atom = cljs.core.atom.call(null,(function (){var or__3949__auto__ = initial_value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
var cm_inst = (function (){var or__3949__auto__ = cm_instance;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.atom.call(null,null);
}
})();
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (value_atom,cm_inst,map__41035,map__41035__$1,cm_instance,class$){
return (function (this$){
var el = reagent.dom.dom_node.call(null,this$);
var opts = ({"lineNumbers": false, "readOnly": true, "undoDepth": (100000000), "historyEventDelay": (1), "viewportMargin": Infinity, "autoRefresh": true, "value": cljs.core.deref.call(null,value_atom), "theme": "eclipse"});
return cljs.core.reset_BANG_.call(null,cm_inst,(new CodeMirror(el,opts)));
});})(value_atom,cm_inst,map__41035,map__41035__$1,cm_instance,class$))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (value_atom,cm_inst,map__41035,map__41035__$1,cm_instance,class$){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.CodeMirror-readOnly","div.CodeMirror-readOnly",-1731966265),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.textarea","div.textarea",964106957),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),class$], null)], null)], null);
});})(value_atom,cm_inst,map__41035,map__41035__$1,cm_instance,class$))
], null));
});
crux.ui.codemirror.indent_code = (function crux$ui$codemirror$indent_code(var_args){
var G__41038 = arguments.length;
switch (G__41038) {
case 1:
return crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1 = (function (level){
return crux.ui.codemirror.indent_code.call(null,level,(0));
});

crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2 = (function (level,plus_any){
return goog.string.unescapeEntities(cljs.core.apply.call(null,cljs.core.str,cljs.core.repeat.call(null,(level + plus_any),"&nbsp;")));
});

crux.ui.codemirror.indent_code.cljs$lang$maxFixedArity = 2;

crux.ui.codemirror.coll_type = (function crux$ui$codemirror$coll_type(m){
if(cljs.core.vector_QMARK_.call(null,m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["[","]"], null);
} else {
if(cljs.core.list_QMARK_.call(null,m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",")"], null);
} else {
if(cljs.core.set_QMARK_.call(null,m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#{","}"], null);
} else {
return null;
}
}
}
});
crux.ui.codemirror.span_class = (function crux$ui$codemirror$span_class(m){
if(typeof m === 'string'){
return "cm-string";
} else {
if((m instanceof cljs.core.Keyword)){
return "cm-atom";
} else {
if(typeof m === 'number'){
return "cm-number";
} else {
return null;

}
}
}
});
crux.ui.codemirror.unfolding_icon = (function crux$ui$codemirror$unfolding_icon(state,m,k){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.update,k,cljs.core.not);
})], null),(cljs.core.truth_(cljs.core.get.call(null,cljs.core.deref.call(null,state),k))?goog.string.unescapeEntities("&#9660;"):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.string.unescapeEntities("&#9654;")),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__41040 = " ";
var G__41040__$1 = ((cljs.core.map_QMARK_.call(null,m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41040),"{...}"].join(''):G__41040);
var G__41040__$2 = ((cljs.core.vector_QMARK_.call(null,m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41040__$1),"[...]"].join(''):G__41040__$1);
var G__41040__$3 = ((cljs.core.list_QMARK_.call(null,m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41040__$2),"(...)"].join(''):G__41040__$2);
if(cljs.core.set_QMARK_.call(null,m)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41040__$3),"#{...}"].join('');
} else {
return G__41040__$3;
}
})())].join(''))], null);
});
crux.ui.codemirror.code_snippet = (function crux$ui$codemirror$code_snippet(_,___$1){
var state = reagent.core.atom.call(null,null);
return ((function (state){
return (function (m,links){
var generate_snippet = ((function (state){
return (function crux$ui$codemirror$code_snippet_$_generate_snippet(parent_keys,m__$1){
var level = (cljs.core.count.call(null,parent_keys) + (1));
if(cljs.core.truth_(cljs.core.get.call(null,links,m__$1))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,links,m__$1))].join('')], null),(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_41041_41067 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_41042_41068 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_41041_41067,_STAR_print_fn_STAR_41042_41068,sb__4462__auto__,level,state){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_41041_41067,_STAR_print_fn_STAR_41042_41068,sb__4462__auto__,level,state))
;

try{var _STAR_print_pprint_dispatch_STAR_41043_41069 = cljs.pprint._STAR_print_pprint_dispatch_STAR_;
cljs.pprint._STAR_print_pprint_dispatch_STAR_ = cljs.pprint.code_dispatch;

try{cljs.pprint.pprint.call(null,m__$1);
}finally {cljs.pprint._STAR_print_pprint_dispatch_STAR_ = _STAR_print_pprint_dispatch_STAR_41043_41069;
}}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_41042_41068;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_41041_41067;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null);
} else {
if(cljs.core.map_QMARK_.call(null,m__$1)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.unfolding_icon,state,m__$1,parent_keys], null),(cljs.core.truth_(cljs.core.get.call(null,cljs.core.deref.call(null,state),parent_keys))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level),"{"], null),(function (){var iter__4324__auto__ = ((function (level,state){
return (function crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__41044(s__41045){
return (new cljs.core.LazySeq(null,((function (level,state){
return (function (){
var s__41045__$1 = s__41045;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__41045__$1);
if(temp__5735__auto__){
var s__41045__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41045__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__41045__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__41047 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__41046 = (0);
while(true){
if((i__41046 < size__4323__auto__)){
var vec__41048 = cljs.core._nth.call(null,c__4322__auto__,i__41046);
var k = cljs.core.nth.call(null,vec__41048,(0),null);
var v = cljs.core.nth.call(null,vec__41048,(1),null);
cljs.core.chunk_append.call(null,b__41047,cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.cm-atom","span.cm-atom",-972311901),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),crux$ui$codemirror$code_snippet_$_generate_snippet.call(null,cljs.core.conj.call(null,parent_keys,k),v)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)));

var G__41070 = (i__41046 + (1));
i__41046 = G__41070;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41047),crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__41044.call(null,cljs.core.chunk_rest.call(null,s__41045__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41047),null);
}
} else {
var vec__41051 = cljs.core.first.call(null,s__41045__$2);
var k = cljs.core.nth.call(null,vec__41051,(0),null);
var v = cljs.core.nth.call(null,vec__41051,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.cm-atom","span.cm-atom",-972311901),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),crux$ui$codemirror$code_snippet_$_generate_snippet.call(null,cljs.core.conj.call(null,parent_keys,k),v)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)),crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__41044.call(null,cljs.core.rest.call(null,s__41045__$2)));
}
} else {
return null;
}
break;
}
});})(level,state))
,null,null));
});})(level,state))
;
return iter__4324__auto__.call(null,m__$1);
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level),"}"], null)], null):null)], null);
} else {
if(cljs.core.coll_QMARK_.call(null,m__$1)){
var vec__41054 = crux.ui.codemirror.coll_type.call(null,m__$1);
var open = cljs.core.nth.call(null,vec__41054,(0),null);
var close = cljs.core.nth.call(null,vec__41054,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.unfolding_icon,state,m__$1,parent_keys], null),(cljs.core.truth_(cljs.core.get.call(null,cljs.core.deref.call(null,state),parent_keys))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level),open], null),cljs.core.doall.call(null,cljs.core.map_indexed.call(null,((function (vec__41054,open,close,level,state){
return (function (idx,v){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level,(1))], null),crux$ui$codemirror$code_snippet_$_generate_snippet.call(null,cljs.core.conj.call(null,parent_keys,idx),v)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),v], null));
});})(vec__41054,open,close,level,state))
,m__$1)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,level),close], null)], null):null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),crux.ui.codemirror.span_class.call(null,m__$1)], null),((typeof m__$1 === 'string')?["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1),"\""].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1)].join(''))], null);

}
}
}
});})(state))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.CodeMirror.cm-s-eclipse","div.CodeMirror.cm-s-eclipse",-99918637),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"default"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"{"], null),cljs.core.doall.call(null,(function (){var iter__4324__auto__ = ((function (generate_snippet,state){
return (function crux$ui$codemirror$code_snippet_$_iter__41057(s__41058){
return (new cljs.core.LazySeq(null,((function (generate_snippet,state){
return (function (){
var s__41058__$1 = s__41058;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__41058__$1);
if(temp__5735__auto__){
var s__41058__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41058__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__41058__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__41060 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__41059 = (0);
while(true){
if((i__41059 < size__4323__auto__)){
var vec__41061 = cljs.core._nth.call(null,c__4322__auto__,i__41059);
var k = cljs.core.nth.call(null,vec__41061,(0),null);
var v = cljs.core.nth.call(null,vec__41061,(1),null);
cljs.core.chunk_append.call(null,b__41060,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"line-height","line-height",1870784992),"1.2rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.cm-atom","span.cm-atom",-972311901),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),generate_snippet.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),v)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)));

var G__41071 = (i__41059 + (1));
i__41059 = G__41071;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41060),crux$ui$codemirror$code_snippet_$_iter__41057.call(null,cljs.core.chunk_rest.call(null,s__41058__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41060),null);
}
} else {
var vec__41064 = cljs.core.first.call(null,s__41058__$2);
var k = cljs.core.nth.call(null,vec__41064,(0),null);
var v = cljs.core.nth.call(null,vec__41064,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"line-height","line-height",1870784992),"1.2rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.cm-atom","span.cm-atom",-972311901),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),generate_snippet.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),v)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)),crux$ui$codemirror$code_snippet_$_iter__41057.call(null,cljs.core.rest.call(null,s__41058__$2)));
}
} else {
return null;
}
break;
}
});})(generate_snippet,state))
,null,null));
});})(generate_snippet,state))
;
return iter__4324__auto__.call(null,m);
})()),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),crux.ui.codemirror.indent_code.call(null,(0)),"}"], null)], null)], null);
});
;})(state))
});

//# sourceMappingURL=codemirror.js.map
