// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('crux.ui.codemirror');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('goog.object');
goog.require('goog.string');
goog.require('cljs.pprint');
crux.ui.codemirror.escape_re = (function crux$ui$codemirror$escape_re(input){
var re = (new RegExp("([.*+?^=!:${}()|[\\]\\/\\\\])","g"));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(input)].join('').replace(re,"\\$1");
});
crux.ui.codemirror.fuzzy_re = (function crux$ui$codemirror$fuzzy_re(input){
return RegExp(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,c){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),cljs.core.str.cljs$core$IFn$_invoke$arity$1(crux.ui.codemirror.escape_re(c)),".*"].join('');
}),"",input),"i");
});
crux.ui.codemirror.crux_builtin_keywords = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$find,cljs.core.cst$kw$where,cljs.core.cst$kw$args,cljs.core.cst$kw$rules,cljs.core.cst$kw$offset,cljs.core.cst$kw$limit,cljs.core.cst$kw$order_DASH_by,cljs.core.cst$kw$timeout,cljs.core.cst$kw$full_DASH_results_QMARK_,cljs.core.cst$kw$crux$db_SLASH_id], null);
crux.ui.codemirror.autocomplete = (function crux$ui$codemirror$autocomplete(index,cm,options){
var cur = cm.getCursor();
var line = cur.line;
var ch = cur.ch;
var token = cm.getTokenAt(cur);
var reg = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(token.string,(0),(ch - token.start));
var blank_QMARK_ = (function (){var fexpr__23348 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["(",null,"{",null,"[",null," ",null], null), null);
return (fexpr__23348.cljs$core$IFn$_invoke$arity$1 ? fexpr__23348.cljs$core$IFn$_invoke$arity$1(reg) : fexpr__23348.call(null,reg));
})();
var start = (cljs.core.truth_(blank_QMARK_)?cur:CodeMirror.Pos(line,goog.object.get(token,"start")));
var end = (cljs.core.truth_(blank_QMARK_)?cur:CodeMirror.Pos(line,goog.object.get(token,"end")));
var words = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(crux.ui.codemirror.crux_builtin_keywords,index);
var fuzzy = (cljs.core.truth_(blank_QMARK_)?/.*/:crux.ui.codemirror.fuzzy_re(reg));
var words__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (cur,line,ch,token,reg,blank_QMARK_,start,end,words,fuzzy){
return (function (p1__23347_SHARP_){
return cljs.core.re_find(fuzzy,p1__23347_SHARP_);
});})(cur,line,ch,token,reg,blank_QMARK_,start,end,words,fuzzy))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,words));
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$list,words__$1,cljs.core.cst$kw$from,start,cljs.core.cst$kw$to,end], null));
});
crux.ui.codemirror.code_mirror = (function crux$ui$codemirror$code_mirror(initial_value,p__23349){
var map__23350 = p__23349;
var map__23350__$1 = ((((!((map__23350 == null)))?(((((map__23350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23350.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23350):map__23350);
var cm_instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$cm_DASH_instance);
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$class);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$stats);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$on_DASH_change);
var on_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$on_DASH_blur);
var on_cm_init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$on_DASH_cm_DASH_init);
var value_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((function (){var or__3949__auto__ = initial_value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
var on_change__$1 = (function (){var or__3949__auto__ = on_change;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.constantly(null);
}
})();
var on_blur__$1 = (function (){var or__3949__auto__ = on_blur;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.constantly(null);
}
})();
var cm_inst = (function (){var or__3949__auto__ = cm_instance;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
})();
var indexes = ((cljs.core.map_QMARK_(stats))?cljs.core.keys(stats):null);
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (this$){
var el = reagent.dom.dom_node(this$);
var opts = ({"autoRefresh": true, "matchBrackets": true, "value": cljs.core.deref(value_atom), "extraKeys": new cljs.core.PersistentArrayMap(null, 1, ["Ctrl-Space","autocomplete"], null), "theme": "eclipse", "viewportMargin": Infinity, "undoDepth": (100000000), "hintOptions": ({"hint": cljs.core.partial.cljs$core$IFn$_invoke$arity$2(crux.ui.codemirror.autocomplete,indexes), "completeSingle": false}), "historyEventDelay": (1), "lineNumbers": true, "autoCloseBrackets": true});
var inst = cljs.core.reset_BANG_(cm_inst,(new CodeMirror(el,opts)));
inst.on("keyup",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (cm,e){
if(((cljs.core.not((function (){var G__23354 = cm;
var G__23355 = ["state","completionActive"];
return goog.object.getValueByKeys(G__23354,G__23355);
})())) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(goog.object.get(e,"key")))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.object.get(e,"key"),":")))){
return inst.showHint();
} else {
return null;
}
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

inst.on("change",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
var value = inst.getValue();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.deref(value_atom))){
return null;
} else {
(on_change__$1.cljs$core$IFn$_invoke$arity$1 ? on_change__$1.cljs$core$IFn$_invoke$arity$1(value) : on_change__$1.call(null,value));

return cljs.core.reset_BANG_(value_atom,value);
}
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

inst.on("blur",((function (el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
return (on_blur__$1.cljs$core$IFn$_invoke$arity$0 ? on_blur__$1.cljs$core$IFn$_invoke$arity$0() : on_blur__$1.call(null));
});})(el,opts,inst,value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
);

if(cljs.core.truth_(on_cm_init)){
return (on_cm_init.cljs$core$IFn$_invoke$arity$1 ? on_cm_init.cljs$core$IFn$_invoke$arity$1(inst) : on_cm_init.call(null,inst));
} else {
return null;
}
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
,cljs.core.cst$kw$component_DASH_did_DASH_update,((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(value_atom),cljs.core.deref(cm_inst).getValue())){
return null;
} else {
cljs.core.deref(cm_inst).setValue(cljs.core.deref(value_atom));

var last_line = cljs.core.deref(cm_inst).lastLine();
var last_ch = cljs.core.count(cljs.core.deref(cm_inst).getLine(last_line));
return cljs.core.deref(cm_inst).setCursor(last_line,last_ch);
}
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
,cljs.core.cst$kw$reagent_DASH_render,((function (value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$textarea,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,class$], null)], null);
});})(value_atom,on_change__$1,on_blur__$1,cm_inst,indexes,map__23350,map__23350__$1,cm_instance,class$,stats,on_change,on_blur,on_cm_init))
], null));
});
crux.ui.codemirror.code_mirror_static = (function crux$ui$codemirror$code_mirror_static(initial_value,p__23356){
var map__23357 = p__23356;
var map__23357__$1 = ((((!((map__23357 == null)))?(((((map__23357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23357):map__23357);
var cm_instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23357__$1,cljs.core.cst$kw$cm_DASH_instance);
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23357__$1,cljs.core.cst$kw$class);
var value_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((function (){var or__3949__auto__ = initial_value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
var cm_inst = (function (){var or__3949__auto__ = cm_instance;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
})();
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (value_atom,cm_inst,map__23357,map__23357__$1,cm_instance,class$){
return (function (this$){
var el = reagent.dom.dom_node(this$);
var opts = ({"lineNumbers": false, "readOnly": true, "undoDepth": (100000000), "historyEventDelay": (1), "viewportMargin": Infinity, "autoRefresh": true, "value": cljs.core.deref(value_atom), "theme": "eclipse"});
return cljs.core.reset_BANG_(cm_inst,(new CodeMirror(el,opts)));
});})(value_atom,cm_inst,map__23357,map__23357__$1,cm_instance,class$))
,cljs.core.cst$kw$reagent_DASH_render,((function (value_atom,cm_inst,map__23357,map__23357__$1,cm_instance,class$){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$CodeMirror_DASH_readOnly,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$textarea,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,class$], null)], null)], null);
});})(value_atom,cm_inst,map__23357,map__23357__$1,cm_instance,class$))
], null));
});
crux.ui.codemirror.indent_code = (function crux$ui$codemirror$indent_code(var_args){
var G__23360 = arguments.length;
switch (G__23360) {
case 1:
return crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1 = (function (level){
return crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2(level,(0));
});

crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2 = (function (level,plus_any){
var G__23361 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((level + plus_any),"&nbsp;"));
return goog.string.unescapeEntities(G__23361);
});

crux.ui.codemirror.indent_code.cljs$lang$maxFixedArity = 2;

crux.ui.codemirror.coll_type = (function crux$ui$codemirror$coll_type(m){
if(cljs.core.vector_QMARK_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["[","]"], null);
} else {
if(cljs.core.list_QMARK_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(",")"], null);
} else {
if(cljs.core.set_QMARK_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#{","}"], null);
} else {
return null;
}
}
}
});
crux.ui.codemirror.span_class = (function crux$ui$codemirror$span_class(m){
if(typeof m === 'string'){
return "cm-string";
} else {
if((m instanceof cljs.core.Keyword)){
return "cm-atom";
} else {
if(typeof m === 'number'){
return "cm-number";
} else {
return null;

}
}
}
});
crux.ui.codemirror.unfolding_icon = (function crux$ui$codemirror$unfolding_icon(state,m,k){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cursor,"pointer"], null),cljs.core.cst$kw$on_DASH_click,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,k,cljs.core.not);
})], null),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),k))?goog.string.unescapeEntities("&#9660;"):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.string.unescapeEntities("&#9654;")),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__23363 = " ";
var G__23363__$1 = ((cljs.core.map_QMARK_(m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23363),"{...}"].join(''):G__23363);
var G__23363__$2 = ((cljs.core.vector_QMARK_(m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23363__$1),"[...]"].join(''):G__23363__$1);
var G__23363__$3 = ((cljs.core.list_QMARK_(m))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23363__$2),"(...)"].join(''):G__23363__$2);
if(cljs.core.set_QMARK_(m)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23363__$3),"#{...}"].join('');
} else {
return G__23363__$3;
}
})())].join(''))], null);
});
crux.ui.codemirror.code_snippet = (function crux$ui$codemirror$code_snippet(_,___$1){
var state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return ((function (state){
return (function (m,links){
var generate_snippet = ((function (state){
return (function crux$ui$codemirror$code_snippet_$_generate_snippet(parent_keys,m__$1){
var level = (cljs.core.count(parent_keys) + (1));
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(links,m__$1))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(links,m__$1))].join('')], null),(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_23364_23390 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_23365_23391 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_23364_23390,_STAR_print_fn_STAR_23365_23391,sb__4462__auto__,level,state){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_23364_23390,_STAR_print_fn_STAR_23365_23391,sb__4462__auto__,level,state))
;

try{var _STAR_print_pprint_dispatch_STAR_23366_23392 = cljs.pprint._STAR_print_pprint_dispatch_STAR_;
cljs.pprint._STAR_print_pprint_dispatch_STAR_ = cljs.pprint.code_dispatch;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(m__$1);
}finally {cljs.pprint._STAR_print_pprint_dispatch_STAR_ = _STAR_print_pprint_dispatch_STAR_23366_23392;
}}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_23365_23391;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_23364_23390;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null);
} else {
if(cljs.core.map_QMARK_(m__$1)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.unfolding_icon,state,m__$1,parent_keys], null),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),parent_keys))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin,(0)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level),"{"], null),(function (){var iter__4324__auto__ = ((function (level,state){
return (function crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__23367(s__23368){
return (new cljs.core.LazySeq(null,((function (level,state){
return (function (){
var s__23368__$1 = s__23368;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__23368__$1);
if(temp__5735__auto__){
var s__23368__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23368__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__23368__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__23370 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__23369 = (0);
while(true){
if((i__23369 < size__4323__auto__)){
var vec__23371 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__23369);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23371,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23371,(1),null);
cljs.core.chunk_append(b__23370,cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin,(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$cm_DASH_atom,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),crux$ui$codemirror$code_snippet_$_generate_snippet(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(parent_keys,k),v)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)));

var G__23393 = (i__23369 + (1));
i__23369 = G__23393;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23370),crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__23367(cljs.core.chunk_rest(s__23368__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23370),null);
}
} else {
var vec__23374 = cljs.core.first(s__23368__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23374,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23374,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin,(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$cm_DASH_atom,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),crux$ui$codemirror$code_snippet_$_generate_snippet(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(parent_keys,k),v)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)),crux$ui$codemirror$code_snippet_$_generate_snippet_$_iter__23367(cljs.core.rest(s__23368__$2)));
}
} else {
return null;
}
break;
}
});})(level,state))
,null,null));
});})(level,state))
;
return iter__4324__auto__(m__$1);
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level),"}"], null)], null):null)], null);
} else {
if(cljs.core.coll_QMARK_(m__$1)){
var vec__23377 = crux.ui.codemirror.coll_type(m__$1);
var open = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23377,(0),null);
var close = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23377,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.unfolding_icon,state,m__$1,parent_keys], null),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),parent_keys))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin,(0)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level),open], null),cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (vec__23377,open,close,level,state){
return (function (idx,v){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin,(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$2(level,(1))], null),crux$ui$codemirror$code_snippet_$_generate_snippet(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(parent_keys,idx),v)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,v], null));
});})(vec__23377,open,close,level,state))
,m__$1)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1(level),close], null)], null):null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,crux.ui.codemirror.span_class(m__$1)], null),((typeof m__$1 === 'string')?["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1),"\""].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1)].join(''))], null);

}
}
}
});})(state))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$CodeMirror$cm_DASH_s_DASH_eclipse,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cursor,"default"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"{"], null),cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4324__auto__ = ((function (generate_snippet,state){
return (function crux$ui$codemirror$code_snippet_$_iter__23380(s__23381){
return (new cljs.core.LazySeq(null,((function (generate_snippet,state){
return (function (){
var s__23381__$1 = s__23381;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__23381__$1);
if(temp__5735__auto__){
var s__23381__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23381__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__23381__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__23383 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__23382 = (0);
while(true){
if((i__23382 < size__4323__auto__)){
var vec__23384 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__23382);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23384,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23384,(1),null);
cljs.core.chunk_append(b__23383,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$margin,(0),cljs.core.cst$kw$line_DASH_height,"1.2rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$cm_DASH_atom,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),generate_snippet(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),v)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)));

var G__23394 = (i__23382 + (1));
i__23382 = G__23394;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23383),crux$ui$codemirror$code_snippet_$_iter__23380(cljs.core.chunk_rest(s__23381__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23383),null);
}
} else {
var vec__23387 = cljs.core.first(s__23381__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23387,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23387,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$margin,(0),cljs.core.cst$kw$line_DASH_height,"1.2rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$cm_DASH_atom,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," "].join('')], null),generate_snippet(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),v)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)),crux$ui$codemirror$code_snippet_$_iter__23380(cljs.core.rest(s__23381__$2)));
}
} else {
return null;
}
break;
}
});})(generate_snippet,state))
,null,null));
});})(generate_snippet,state))
;
return iter__4324__auto__(m);
})()),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,crux.ui.codemirror.indent_code.cljs$core$IFn$_invoke$arity$1((0)),"}"], null)], null)], null);
});
;})(state))
});
