// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__20740){
var map__20741 = p__20740;
var map__20741__$1 = ((((!((map__20741 == null)))?(((((map__20741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20741):map__20741);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20741__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20741__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20741__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20741__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__20743_20757 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__20744_20758 = null;
var count__20745_20759 = (0);
var i__20746_20760 = (0);
while(true){
if((i__20746_20760 < count__20745_20759)){
var vec__20747_20761 = chunk__20744_20758.cljs$core$IIndexed$_nth$arity$2(null,i__20746_20760);
var k_20762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20747_20761,(0),null);
var cb_20763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20747_20761,(1),null);
try{var G__20751_20764 = cljs.core.deref(re_frame.trace.traces);
(cb_20763.cljs$core$IFn$_invoke$arity$1 ? cb_20763.cljs$core$IFn$_invoke$arity$1(G__20751_20764) : cb_20763.call(null,G__20751_20764));
}catch (e20750){var e_20765 = e20750;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20762,"while storing",cljs.core.deref(re_frame.trace.traces),e_20765], 0));
}

var G__20766 = seq__20743_20757;
var G__20767 = chunk__20744_20758;
var G__20768 = count__20745_20759;
var G__20769 = (i__20746_20760 + (1));
seq__20743_20757 = G__20766;
chunk__20744_20758 = G__20767;
count__20745_20759 = G__20768;
i__20746_20760 = G__20769;
continue;
} else {
var temp__5735__auto___20770 = cljs.core.seq(seq__20743_20757);
if(temp__5735__auto___20770){
var seq__20743_20771__$1 = temp__5735__auto___20770;
if(cljs.core.chunked_seq_QMARK_(seq__20743_20771__$1)){
var c__4351__auto___20772 = cljs.core.chunk_first(seq__20743_20771__$1);
var G__20773 = cljs.core.chunk_rest(seq__20743_20771__$1);
var G__20774 = c__4351__auto___20772;
var G__20775 = cljs.core.count(c__4351__auto___20772);
var G__20776 = (0);
seq__20743_20757 = G__20773;
chunk__20744_20758 = G__20774;
count__20745_20759 = G__20775;
i__20746_20760 = G__20776;
continue;
} else {
var vec__20752_20777 = cljs.core.first(seq__20743_20771__$1);
var k_20778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20752_20777,(0),null);
var cb_20779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20752_20777,(1),null);
try{var G__20756_20780 = cljs.core.deref(re_frame.trace.traces);
(cb_20779.cljs$core$IFn$_invoke$arity$1 ? cb_20779.cljs$core$IFn$_invoke$arity$1(G__20756_20780) : cb_20779.call(null,G__20756_20780));
}catch (e20755){var e_20781 = e20755;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20778,"while storing",cljs.core.deref(re_frame.trace.traces),e_20781], 0));
}

var G__20782 = cljs.core.next(seq__20743_20771__$1);
var G__20783 = null;
var G__20784 = (0);
var G__20785 = (0);
seq__20743_20757 = G__20782;
chunk__20744_20758 = G__20783;
count__20745_20759 = G__20784;
i__20746_20760 = G__20785;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
