// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_20892 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__20893 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20894 = null;
var count__20895 = (0);
var i__20896 = (0);
while(true){
if((i__20896 < count__20895)){
var vec__20897 = chunk__20894.cljs$core$IIndexed$_nth$arity$2(null,i__20896);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20897,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20897,(1),null);
var temp__5733__auto___20913 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20913)){
var effect_fn_20914 = temp__5733__auto___20913;
(effect_fn_20914.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20914.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20914.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20915 = seq__20893;
var G__20916 = chunk__20894;
var G__20917 = count__20895;
var G__20918 = (i__20896 + (1));
seq__20893 = G__20915;
chunk__20894 = G__20916;
count__20895 = G__20917;
i__20896 = G__20918;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20893);
if(temp__5735__auto__){
var seq__20893__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20893__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20893__$1);
var G__20919 = cljs.core.chunk_rest(seq__20893__$1);
var G__20920 = c__4351__auto__;
var G__20921 = cljs.core.count(c__4351__auto__);
var G__20922 = (0);
seq__20893 = G__20919;
chunk__20894 = G__20920;
count__20895 = G__20921;
i__20896 = G__20922;
continue;
} else {
var vec__20900 = cljs.core.first(seq__20893__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20900,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20900,(1),null);
var temp__5733__auto___20923 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20923)){
var effect_fn_20924 = temp__5733__auto___20923;
(effect_fn_20924.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20924.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20924.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20925 = cljs.core.next(seq__20893__$1);
var G__20926 = null;
var G__20927 = (0);
var G__20928 = (0);
seq__20893 = G__20925;
chunk__20894 = G__20926;
count__20895 = G__20927;
i__20896 = G__20928;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__20718__auto___20929 = re_frame.interop.now();
var duration__20719__auto___20930 = (end__20718__auto___20929 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__20719__auto___20930,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__20718__auto___20929);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_20892;
}} else {
var seq__20903 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20904 = null;
var count__20905 = (0);
var i__20906 = (0);
while(true){
if((i__20906 < count__20905)){
var vec__20907 = chunk__20904.cljs$core$IIndexed$_nth$arity$2(null,i__20906);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20907,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20907,(1),null);
var temp__5733__auto___20931 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20931)){
var effect_fn_20932 = temp__5733__auto___20931;
(effect_fn_20932.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20932.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20932.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20933 = seq__20903;
var G__20934 = chunk__20904;
var G__20935 = count__20905;
var G__20936 = (i__20906 + (1));
seq__20903 = G__20933;
chunk__20904 = G__20934;
count__20905 = G__20935;
i__20906 = G__20936;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20903);
if(temp__5735__auto__){
var seq__20903__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20903__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20903__$1);
var G__20937 = cljs.core.chunk_rest(seq__20903__$1);
var G__20938 = c__4351__auto__;
var G__20939 = cljs.core.count(c__4351__auto__);
var G__20940 = (0);
seq__20903 = G__20937;
chunk__20904 = G__20938;
count__20905 = G__20939;
i__20906 = G__20940;
continue;
} else {
var vec__20910 = cljs.core.first(seq__20903__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20910,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20910,(1),null);
var temp__5733__auto___20941 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20941)){
var effect_fn_20942 = temp__5733__auto___20941;
(effect_fn_20942.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20942.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20942.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20943 = cljs.core.next(seq__20903__$1);
var G__20944 = null;
var G__20945 = (0);
var G__20946 = (0);
seq__20903 = G__20943;
chunk__20904 = G__20944;
count__20905 = G__20945;
i__20906 = G__20946;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__20947 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20948 = null;
var count__20949 = (0);
var i__20950 = (0);
while(true){
if((i__20950 < count__20949)){
var map__20951 = chunk__20948.cljs$core$IIndexed$_nth$arity$2(null,i__20950);
var map__20951__$1 = ((((!((map__20951 == null)))?(((((map__20951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20951.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20951):map__20951);
var effect = map__20951__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20951__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20951__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20947,chunk__20948,count__20949,i__20950,map__20951,map__20951__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20947,chunk__20948,count__20949,i__20950,map__20951,map__20951__$1,effect,ms,dispatch))
,ms);
}


var G__20955 = seq__20947;
var G__20956 = chunk__20948;
var G__20957 = count__20949;
var G__20958 = (i__20950 + (1));
seq__20947 = G__20955;
chunk__20948 = G__20956;
count__20949 = G__20957;
i__20950 = G__20958;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20947);
if(temp__5735__auto__){
var seq__20947__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20947__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20947__$1);
var G__20959 = cljs.core.chunk_rest(seq__20947__$1);
var G__20960 = c__4351__auto__;
var G__20961 = cljs.core.count(c__4351__auto__);
var G__20962 = (0);
seq__20947 = G__20959;
chunk__20948 = G__20960;
count__20949 = G__20961;
i__20950 = G__20962;
continue;
} else {
var map__20953 = cljs.core.first(seq__20947__$1);
var map__20953__$1 = ((((!((map__20953 == null)))?(((((map__20953.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20953.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20953):map__20953);
var effect = map__20953__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20953__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20953__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20947,chunk__20948,count__20949,i__20950,map__20953,map__20953__$1,effect,ms,dispatch,seq__20947__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20947,chunk__20948,count__20949,i__20950,map__20953,map__20953__$1,effect,ms,dispatch,seq__20947__$1,temp__5735__auto__))
,ms);
}


var G__20963 = cljs.core.next(seq__20947__$1);
var G__20964 = null;
var G__20965 = (0);
var G__20966 = (0);
seq__20947 = G__20963;
chunk__20948 = G__20964;
count__20949 = G__20965;
i__20950 = G__20966;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__20967 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20968 = null;
var count__20969 = (0);
var i__20970 = (0);
while(true){
if((i__20970 < count__20969)){
var event = chunk__20968.cljs$core$IIndexed$_nth$arity$2(null,i__20970);
re_frame.router.dispatch(event);


var G__20971 = seq__20967;
var G__20972 = chunk__20968;
var G__20973 = count__20969;
var G__20974 = (i__20970 + (1));
seq__20967 = G__20971;
chunk__20968 = G__20972;
count__20969 = G__20973;
i__20970 = G__20974;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20967);
if(temp__5735__auto__){
var seq__20967__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20967__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20967__$1);
var G__20975 = cljs.core.chunk_rest(seq__20967__$1);
var G__20976 = c__4351__auto__;
var G__20977 = cljs.core.count(c__4351__auto__);
var G__20978 = (0);
seq__20967 = G__20975;
chunk__20968 = G__20976;
count__20969 = G__20977;
i__20970 = G__20978;
continue;
} else {
var event = cljs.core.first(seq__20967__$1);
re_frame.router.dispatch(event);


var G__20979 = cljs.core.next(seq__20967__$1);
var G__20980 = null;
var G__20981 = (0);
var G__20982 = (0);
seq__20967 = G__20979;
chunk__20968 = G__20980;
count__20969 = G__20981;
i__20970 = G__20982;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__20983 = cljs.core.seq(value);
var chunk__20984 = null;
var count__20985 = (0);
var i__20986 = (0);
while(true){
if((i__20986 < count__20985)){
var event = chunk__20984.cljs$core$IIndexed$_nth$arity$2(null,i__20986);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20987 = seq__20983;
var G__20988 = chunk__20984;
var G__20989 = count__20985;
var G__20990 = (i__20986 + (1));
seq__20983 = G__20987;
chunk__20984 = G__20988;
count__20985 = G__20989;
i__20986 = G__20990;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20983);
if(temp__5735__auto__){
var seq__20983__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20983__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20983__$1);
var G__20991 = cljs.core.chunk_rest(seq__20983__$1);
var G__20992 = c__4351__auto__;
var G__20993 = cljs.core.count(c__4351__auto__);
var G__20994 = (0);
seq__20983 = G__20991;
chunk__20984 = G__20992;
count__20985 = G__20993;
i__20986 = G__20994;
continue;
} else {
var event = cljs.core.first(seq__20983__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20995 = cljs.core.next(seq__20983__$1);
var G__20996 = null;
var G__20997 = (0);
var G__20998 = (0);
seq__20983 = G__20995;
chunk__20984 = G__20996;
count__20985 = G__20997;
i__20986 = G__20998;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
