// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__20579){
var map__20580 = p__20579;
var map__20580__$1 = ((((!((map__20580 == null)))?(((((map__20580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20580.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20580):map__20580);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20580__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20580__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20580__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20580__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__20582_20596 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__20583_20597 = null;
var count__20584_20598 = (0);
var i__20585_20599 = (0);
while(true){
if((i__20585_20599 < count__20584_20598)){
var vec__20586_20600 = chunk__20583_20597.cljs$core$IIndexed$_nth$arity$2(null,i__20585_20599);
var k_20601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20586_20600,(0),null);
var cb_20602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20586_20600,(1),null);
try{var G__20590_20603 = cljs.core.deref(re_frame.trace.traces);
(cb_20602.cljs$core$IFn$_invoke$arity$1 ? cb_20602.cljs$core$IFn$_invoke$arity$1(G__20590_20603) : cb_20602.call(null,G__20590_20603));
}catch (e20589){var e_20604 = e20589;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20601,"while storing",cljs.core.deref(re_frame.trace.traces),e_20604], 0));
}

var G__20605 = seq__20582_20596;
var G__20606 = chunk__20583_20597;
var G__20607 = count__20584_20598;
var G__20608 = (i__20585_20599 + (1));
seq__20582_20596 = G__20605;
chunk__20583_20597 = G__20606;
count__20584_20598 = G__20607;
i__20585_20599 = G__20608;
continue;
} else {
var temp__5735__auto___20609 = cljs.core.seq(seq__20582_20596);
if(temp__5735__auto___20609){
var seq__20582_20610__$1 = temp__5735__auto___20609;
if(cljs.core.chunked_seq_QMARK_(seq__20582_20610__$1)){
var c__4351__auto___20611 = cljs.core.chunk_first(seq__20582_20610__$1);
var G__20612 = cljs.core.chunk_rest(seq__20582_20610__$1);
var G__20613 = c__4351__auto___20611;
var G__20614 = cljs.core.count(c__4351__auto___20611);
var G__20615 = (0);
seq__20582_20596 = G__20612;
chunk__20583_20597 = G__20613;
count__20584_20598 = G__20614;
i__20585_20599 = G__20615;
continue;
} else {
var vec__20591_20616 = cljs.core.first(seq__20582_20610__$1);
var k_20617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20591_20616,(0),null);
var cb_20618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20591_20616,(1),null);
try{var G__20595_20619 = cljs.core.deref(re_frame.trace.traces);
(cb_20618.cljs$core$IFn$_invoke$arity$1 ? cb_20618.cljs$core$IFn$_invoke$arity$1(G__20595_20619) : cb_20618.call(null,G__20595_20619));
}catch (e20594){var e_20620 = e20594;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20617,"while storing",cljs.core.deref(re_frame.trace.traces),e_20620], 0));
}

var G__20621 = cljs.core.next(seq__20582_20610__$1);
var G__20622 = null;
var G__20623 = (0);
var G__20624 = (0);
seq__20582_20596 = G__20621;
chunk__20583_20597 = G__20622;
count__20584_20598 = G__20623;
i__20585_20599 = G__20624;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
