// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__20845){
var vec__20846 = p__20845;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20846,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20846,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__20849 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20849,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20849,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20849,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__20853 = arguments.length;
switch (G__20853) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4037__auto__ = cljs.core.count(a);
var y__4038__auto__ = cljs.core.count(b);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));
} else {
var m__4244__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4243__auto__ = (((a == null))?null:a);
var m__4244__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto__.call(null,a,b));
} else {
var m__4244__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__20855_20879 = clojure.data.equality_partition;
var G__20856_20880 = "null";
var G__20857_20881 = ((function (G__20855_20879,G__20856_20880){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20855_20879,G__20856_20880))
;
goog.object.set(G__20855_20879,G__20856_20880,G__20857_20881);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__20858_20882 = clojure.data.equality_partition;
var G__20859_20883 = "string";
var G__20860_20884 = ((function (G__20858_20882,G__20859_20883){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20858_20882,G__20859_20883))
;
goog.object.set(G__20858_20882,G__20859_20883,G__20860_20884);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__20861_20885 = clojure.data.equality_partition;
var G__20862_20886 = "number";
var G__20863_20887 = ((function (G__20861_20885,G__20862_20886){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20861_20885,G__20862_20886))
;
goog.object.set(G__20861_20885,G__20862_20886,G__20863_20887);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__20864_20888 = clojure.data.equality_partition;
var G__20865_20889 = "array";
var G__20866_20890 = ((function (G__20864_20888,G__20865_20889){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__20864_20888,G__20865_20889))
;
goog.object.set(G__20864_20888,G__20865_20889,G__20866_20890);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__20867_20891 = clojure.data.equality_partition;
var G__20868_20892 = "function";
var G__20869_20893 = ((function (G__20867_20891,G__20868_20892){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20867_20891,G__20868_20892))
;
goog.object.set(G__20867_20891,G__20868_20892,G__20869_20893);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__20870_20894 = clojure.data.equality_partition;
var G__20871_20895 = "boolean";
var G__20872_20896 = ((function (G__20870_20894,G__20871_20895){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__20870_20894,G__20871_20895))
;
goog.object.set(G__20870_20894,G__20871_20895,G__20872_20896);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__20873_20897 = clojure.data.equality_partition;
var G__20874_20898 = "_";
var G__20875_20899 = ((function (G__20873_20897,G__20874_20898){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__20873_20897,G__20874_20898))
;
goog.object.set(G__20873_20897,G__20874_20898,G__20875_20899);
goog.object.set(clojure.data.Diff,"null",true);

var G__20900_20924 = clojure.data.diff_similar;
var G__20901_20925 = "null";
var G__20902_20926 = ((function (G__20900_20924,G__20901_20925){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20900_20924,G__20901_20925))
;
goog.object.set(G__20900_20924,G__20901_20925,G__20902_20926);

goog.object.set(clojure.data.Diff,"string",true);

var G__20903_20927 = clojure.data.diff_similar;
var G__20904_20928 = "string";
var G__20905_20929 = ((function (G__20903_20927,G__20904_20928){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20903_20927,G__20904_20928))
;
goog.object.set(G__20903_20927,G__20904_20928,G__20905_20929);

goog.object.set(clojure.data.Diff,"number",true);

var G__20906_20930 = clojure.data.diff_similar;
var G__20907_20931 = "number";
var G__20908_20932 = ((function (G__20906_20930,G__20907_20931){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20906_20930,G__20907_20931))
;
goog.object.set(G__20906_20930,G__20907_20931,G__20908_20932);

goog.object.set(clojure.data.Diff,"array",true);

var G__20909_20933 = clojure.data.diff_similar;
var G__20910_20934 = "array";
var G__20911_20935 = ((function (G__20909_20933,G__20910_20934){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__20909_20933,G__20910_20934))
;
goog.object.set(G__20909_20933,G__20910_20934,G__20911_20935);

goog.object.set(clojure.data.Diff,"function",true);

var G__20912_20936 = clojure.data.diff_similar;
var G__20913_20937 = "function";
var G__20914_20938 = ((function (G__20912_20936,G__20913_20937){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20912_20936,G__20913_20937))
;
goog.object.set(G__20912_20936,G__20913_20937,G__20914_20938);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__20915_20939 = clojure.data.diff_similar;
var G__20916_20940 = "boolean";
var G__20917_20941 = ((function (G__20915_20939,G__20916_20940){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__20915_20939,G__20916_20940))
;
goog.object.set(G__20915_20939,G__20916_20940,G__20917_20941);

goog.object.set(clojure.data.Diff,"_",true);

var G__20918_20942 = clojure.data.diff_similar;
var G__20919_20943 = "_";
var G__20920_20944 = ((function (G__20918_20942,G__20919_20943){
return (function (a,b){
var fexpr__20922 = (function (){var G__20923 = clojure.data.equality_partition(a);
var G__20923__$1 = (((G__20923 instanceof cljs.core.Keyword))?G__20923.fqn:null);
switch (G__20923__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20923__$1)].join('')));

}
})();
return (fexpr__20922.cljs$core$IFn$_invoke$arity$2 ? fexpr__20922.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__20922.call(null,a,b));
});})(G__20918_20942,G__20919_20943))
;
goog.object.set(G__20918_20942,G__20919_20943,G__20920_20944);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
