// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('tick.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('time_literals.read_write');
goog.require('cljc.java_time.local_date');
goog.require('cljc.java_time.local_date_time');
goog.require('cljc.java_time.local_time');
goog.require('cljc.java_time.clock');
goog.require('cljc.java_time.instant');
goog.require('cljc.java_time.zone_id');
goog.require('cljc.java_time.zone_offset');
goog.require('cljc.java_time.zoned_date_time');
goog.require('cljc.java_time.offset_date_time');
goog.require('cljc.java_time.duration');
goog.require('cljc.java_time.year_month');
goog.require('cljc.java_time.month');
goog.require('cljc.java_time.year');
goog.require('cljc.java_time.day_of_week');
goog.require('cljc.java_time.period');
goog.require('cljc.java_time.temporal.temporal_amount');
goog.require('cljc.java_time.temporal.temporal_adjusters');
goog.require('cljc.java_time.temporal.chrono_field');
goog.require('cljc.java_time.temporal.chrono_unit');
goog.require('java.time');
goog.require('java.time.temporal');
goog.require('cljs.java_time.extend_eq_and_compare');
time_literals.read_write.print_time_literals_clj_BANG_();

time_literals.read_write.print_time_literals_cljs_BANG_();
tick.core._STAR_clock_STAR_ = null;
tick.core.now = (function tick$core$now(){
if(cljs.core.truth_(tick.core._STAR_clock_STAR_)){
return cljc.java_time.instant.now.cljs$core$IFn$_invoke$arity$1(tick.core._STAR_clock_STAR_);
} else {
return cljc.java_time.instant.now.cljs$core$IFn$_invoke$arity$0();
}
});
tick.core.today = (function tick$core$today(){
if(cljs.core.truth_(tick.core._STAR_clock_STAR_)){
return cljc.java_time.local_date.now.cljs$core$IFn$_invoke$arity$1(tick.core._STAR_clock_STAR_);
} else {
return cljc.java_time.local_date.now.cljs$core$IFn$_invoke$arity$0();
}
});
tick.core.epoch = (function tick$core$epoch(){
return cljc.java_time.instant.epoch;
});

/**
 * @interface
 */
tick.core.ITimeReify = function(){};

/**
 * Set time be ON a date
 */
tick.core.on = (function tick$core$on(time,date){
if(((!((time == null))) && (!((time.tick$core$ITimeReify$on$arity$2 == null))))){
return time.tick$core$ITimeReify$on$arity$2(time,date);
} else {
var x__4243__auto__ = (((time == null))?null:time);
var m__4244__auto__ = (tick.core.on[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(time,date) : m__4244__auto__.call(null,time,date));
} else {
var m__4244__auto____$1 = (tick.core.on["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(time,date) : m__4244__auto____$1.call(null,time,date));
} else {
throw cljs.core.missing_protocol("ITimeReify.on",time);
}
}
}
});

/**
 * Set date to be AT a time
 */
tick.core.at = (function tick$core$at(date,time){
if(((!((date == null))) && (!((date.tick$core$ITimeReify$at$arity$2 == null))))){
return date.tick$core$ITimeReify$at$arity$2(date,time);
} else {
var x__4243__auto__ = (((date == null))?null:date);
var m__4244__auto__ = (tick.core.at[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(date,time) : m__4244__auto__.call(null,date,time));
} else {
var m__4244__auto____$1 = (tick.core.at["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(date,time) : m__4244__auto____$1.call(null,date,time));
} else {
throw cljs.core.missing_protocol("ITimeReify.at",date);
}
}
}
});

/**
 * Set a date-time to be in a time-zone
 */
tick.core.in$ = (function tick$core$in(dt,zone){
if(((!((dt == null))) && (!((dt.tick$core$ITimeReify$in$arity$2 == null))))){
return dt.tick$core$ITimeReify$in$arity$2(dt,zone);
} else {
var x__4243__auto__ = (((dt == null))?null:dt);
var m__4244__auto__ = (tick.core.in$[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(dt,zone) : m__4244__auto__.call(null,dt,zone));
} else {
var m__4244__auto____$1 = (tick.core.in$["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(dt,zone) : m__4244__auto____$1.call(null,dt,zone));
} else {
throw cljs.core.missing_protocol("ITimeReify.in",dt);
}
}
}
});

/**
 * Set a date-time to be offset by an amount
 */
tick.core.offset_by = (function tick$core$offset_by(dt,amount){
if(((!((dt == null))) && (!((dt.tick$core$ITimeReify$offset_by$arity$2 == null))))){
return dt.tick$core$ITimeReify$offset_by$arity$2(dt,amount);
} else {
var x__4243__auto__ = (((dt == null))?null:dt);
var m__4244__auto__ = (tick.core.offset_by[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(dt,amount) : m__4244__auto__.call(null,dt,amount));
} else {
var m__4244__auto____$1 = (tick.core.offset_by["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(dt,amount) : m__4244__auto____$1.call(null,dt,amount));
} else {
throw cljs.core.missing_protocol("ITimeReify.offset-by",dt);
}
}
}
});

tick.core.midnight = (function tick$core$midnight(var_args){
var G__26941 = arguments.length;
switch (G__26941) {
case 0:
return tick.core.midnight.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.midnight.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.midnight.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.local_time.midnight;
});

tick.core.midnight.cljs$core$IFn$_invoke$arity$1 = (function (date){
return tick.core.at(date,cljc.java_time.local_time.midnight);
});

tick.core.midnight.cljs$lang$maxFixedArity = 1;

tick.core.noon = (function tick$core$noon(var_args){
var G__26944 = arguments.length;
switch (G__26944) {
case 0:
return tick.core.noon.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.noon.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.noon.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.local_time.noon;
});

tick.core.noon.cljs$core$IFn$_invoke$arity$1 = (function (date){
return tick.core.at(date,cljc.java_time.local_time.noon);
});

tick.core.noon.cljs$lang$maxFixedArity = 1;

cljs.spec.alpha.def_impl(cljs.core.cst$kw$tick$core_SLASH_instant,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_instance_QMARK_,cljs.core.cst$sym$java$time_SLASH_Instant,cljs.core.cst$sym$_PERCENT_)),(function (p1__26946_SHARP_){
return (p1__26946_SHARP_ instanceof java.time.Instant);
}));
tick.core.parse_day = (function tick$core$parse_day(input){
var pred__26947 = cljs.core.re_matches;
var expr__26948 = clojure.string.lower_case(input);
if(cljs.core.truth_((function (){var G__26950 = /^(mon)(day)?$/;
var G__26951 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26950,G__26951) : pred__26947.call(null,G__26950,G__26951));
})())){
return cljc.java_time.day_of_week.monday;
} else {
if(cljs.core.truth_((function (){var G__26952 = /^(tue)(s|sday)?$/;
var G__26953 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26952,G__26953) : pred__26947.call(null,G__26952,G__26953));
})())){
return cljc.java_time.day_of_week.tuesday;
} else {
if(cljs.core.truth_((function (){var G__26954 = /^(wed)(s|nesday)?$/;
var G__26955 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26954,G__26955) : pred__26947.call(null,G__26954,G__26955));
})())){
return cljc.java_time.day_of_week.wednesday;
} else {
if(cljs.core.truth_((function (){var G__26956 = /^(thur)(s|sday)?$/;
var G__26957 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26956,G__26957) : pred__26947.call(null,G__26956,G__26957));
})())){
return cljc.java_time.day_of_week.thursday;
} else {
if(cljs.core.truth_((function (){var G__26958 = /^(fri)(day)?$/;
var G__26959 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26958,G__26959) : pred__26947.call(null,G__26958,G__26959));
})())){
return cljc.java_time.day_of_week.friday;
} else {
if(cljs.core.truth_((function (){var G__26960 = /^(sat)(urday)?$/;
var G__26961 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26960,G__26961) : pred__26947.call(null,G__26960,G__26961));
})())){
return cljc.java_time.day_of_week.saturday;
} else {
if(cljs.core.truth_((function (){var G__26962 = /^(sun)(day)?$/;
var G__26963 = expr__26948;
return (pred__26947.cljs$core$IFn$_invoke$arity$2 ? pred__26947.cljs$core$IFn$_invoke$arity$2(G__26962,G__26963) : pred__26947.call(null,G__26962,G__26963));
})())){
return cljc.java_time.day_of_week.sunday;
} else {
return null;
}
}
}
}
}
}
}
});
tick.core.parse_month = (function tick$core$parse_month(input){
var pred__26964 = cljs.core.re_matches;
var expr__26965 = clojure.string.lower_case(input);
if(cljs.core.truth_((function (){var G__26967 = /^(jan)(uary)?$/;
var G__26968 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26967,G__26968) : pred__26964.call(null,G__26967,G__26968));
})())){
return cljc.java_time.month.january;
} else {
if(cljs.core.truth_((function (){var G__26969 = /^(feb)(ruary)?$/;
var G__26970 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26969,G__26970) : pred__26964.call(null,G__26969,G__26970));
})())){
return cljc.java_time.month.february;
} else {
if(cljs.core.truth_((function (){var G__26971 = /^(mar)(ch)?$/;
var G__26972 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26971,G__26972) : pred__26964.call(null,G__26971,G__26972));
})())){
return cljc.java_time.month.march;
} else {
if(cljs.core.truth_((function (){var G__26973 = /^(apr)(il)?$/;
var G__26974 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26973,G__26974) : pred__26964.call(null,G__26973,G__26974));
})())){
return cljc.java_time.month.april;
} else {
if(cljs.core.truth_((function (){var G__26975 = /^may$/;
var G__26976 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26975,G__26976) : pred__26964.call(null,G__26975,G__26976));
})())){
return cljc.java_time.month.may;
} else {
if(cljs.core.truth_((function (){var G__26977 = /^(jun)(e)?$/;
var G__26978 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26977,G__26978) : pred__26964.call(null,G__26977,G__26978));
})())){
return cljc.java_time.month.june;
} else {
if(cljs.core.truth_((function (){var G__26979 = /^(jul)(y)?$/;
var G__26980 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26979,G__26980) : pred__26964.call(null,G__26979,G__26980));
})())){
return cljc.java_time.month.july;
} else {
if(cljs.core.truth_((function (){var G__26981 = /^(aug)(ust)?$/;
var G__26982 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26981,G__26982) : pred__26964.call(null,G__26981,G__26982));
})())){
return cljc.java_time.month.august;
} else {
if(cljs.core.truth_((function (){var G__26983 = /^(sep)(tember)?$/;
var G__26984 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26983,G__26984) : pred__26964.call(null,G__26983,G__26984));
})())){
return cljc.java_time.month.september;
} else {
if(cljs.core.truth_((function (){var G__26985 = /^(oct)(ober)?$/;
var G__26986 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26985,G__26986) : pred__26964.call(null,G__26985,G__26986));
})())){
return cljc.java_time.month.october;
} else {
if(cljs.core.truth_((function (){var G__26987 = /^(nov)(ember)?$/;
var G__26988 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26987,G__26988) : pred__26964.call(null,G__26987,G__26988));
})())){
return cljc.java_time.month.november;
} else {
if(cljs.core.truth_((function (){var G__26989 = /^(dec)(ember)?$/;
var G__26990 = expr__26965;
return (pred__26964.cljs$core$IFn$_invoke$arity$2 ? pred__26964.cljs$core$IFn$_invoke$arity$2(G__26989,G__26990) : pred__26964.call(null,G__26989,G__26990));
})())){
return cljc.java_time.month.december;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * @interface
 */
tick.core.IParseable = function(){};

/**
 * Parse to most applicable instance.
 */
tick.core.parse = (function tick$core$parse(_){
if(((!((_ == null))) && (!((_.tick$core$IParseable$parse$arity$1 == null))))){
return _.tick$core$IParseable$parse$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.parse[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.parse["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IParseable.parse",_);
}
}
}
});

tick.core.parse_int = (function tick$core$parse_int(x){
return Number(x);
});
goog.object.set(tick.core.IParseable,"string",true);

var G__26991_27056 = tick.core.parse;
var G__26992_27057 = "string";
var G__26993_27058 = ((function (G__26991_27056,G__26992_27057){
return (function (s){
var pred__26994 = cljs.core.re_matches;
var expr__26995 = s;
var temp__5733__auto__ = (function (){var G__26997 = /(\d{1,2})\s*(am|pm)/;
var G__26998 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__26997,G__26998) : pred__26994.call(null,G__26997,G__26998));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var p__4286__auto__ = temp__5733__auto__;
var fexpr__27004 = ((function (p__4286__auto__,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (p__27005){
var vec__27006 = p__27005;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27006,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27006,(1),null);
var ap = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27006,(2),null);
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$2((function (){var G__27009 = tick.core.parse_int(h);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("pm",ap)){
return (G__27009 + (12));
} else {
return G__27009;
}
})(),(0));
});})(p__4286__auto__,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27004(p__4286__auto__);
} else {
var temp__5733__auto____$1 = (function (){var G__27010 = /(\d{1,2})/;
var G__27011 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27010,G__27011) : pred__26994.call(null,G__27010,G__27011));
})();
if(cljs.core.truth_(temp__5733__auto____$1)){
var p__4286__auto__ = temp__5733__auto____$1;
var fexpr__27016 = ((function (p__4286__auto__,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (p__27017){
var vec__27018 = p__27017;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27018,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27018,(1),null);
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$2(tick.core.parse_int(h),(0));
});})(p__4286__auto__,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27016(p__4286__auto__);
} else {
var temp__5733__auto____$2 = (function (){var G__27021 = /\d{2}:\d{2}\S*/;
var G__27022 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27021,G__27022) : pred__26994.call(null,G__27021,G__27022));
})();
if(cljs.core.truth_(temp__5733__auto____$2)){
var p__4286__auto__ = temp__5733__auto____$2;
var fexpr__27023 = ((function (p__4286__auto__,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.local_time.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27023(p__4286__auto__);
} else {
var temp__5733__auto____$3 = (function (){var G__27024 = /(\d{1,2}):(\d{2})/;
var G__27025 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27024,G__27025) : pred__26994.call(null,G__27024,G__27025));
})();
if(cljs.core.truth_(temp__5733__auto____$3)){
var p__4286__auto__ = temp__5733__auto____$3;
var fexpr__27030 = ((function (p__4286__auto__,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (p__27031){
var vec__27032 = p__27031;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27032,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27032,(1),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27032,(2),null);
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$2(tick.core.parse_int(h),tick.core.parse_int(m));
});})(p__4286__auto__,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27030(p__4286__auto__);
} else {
var temp__5733__auto____$4 = (function (){var G__27035 = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,9})?Z/;
var G__27036 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27035,G__27036) : pred__26994.call(null,G__27035,G__27036));
})();
if(cljs.core.truth_(temp__5733__auto____$4)){
var p__4286__auto__ = temp__5733__auto____$4;
var fexpr__27037 = ((function (p__4286__auto__,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.instant.parse(s__$1);
});})(p__4286__auto__,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27037(p__4286__auto__);
} else {
var temp__5733__auto____$5 = (function (){var G__27038 = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,9})?[+-]\d{2}:\d{2}/;
var G__27039 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27038,G__27039) : pred__26994.call(null,G__27038,G__27039));
})();
if(cljs.core.truth_(temp__5733__auto____$5)){
var p__4286__auto__ = temp__5733__auto____$5;
var fexpr__27040 = ((function (p__4286__auto__,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.zoned_date_time.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27040(p__4286__auto__);
} else {
var temp__5733__auto____$6 = (function (){var G__27041 = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,9})?[+-]\d{2}:\d{2}\[\w+\/\w+\]/;
var G__27042 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27041,G__27042) : pred__26994.call(null,G__27041,G__27042));
})();
if(cljs.core.truth_(temp__5733__auto____$6)){
var p__4286__auto__ = temp__5733__auto____$6;
var fexpr__27043 = ((function (p__4286__auto__,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.zoned_date_time.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27043(p__4286__auto__);
} else {
var temp__5733__auto____$7 = (function (){var G__27044 = /\d{4}-\d{2}-\d{2}T\S*/;
var G__27045 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27044,G__27045) : pred__26994.call(null,G__27044,G__27045));
})();
if(cljs.core.truth_(temp__5733__auto____$7)){
var p__4286__auto__ = temp__5733__auto____$7;
var fexpr__27046 = ((function (p__4286__auto__,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.local_date_time.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27046(p__4286__auto__);
} else {
var temp__5733__auto____$8 = (function (){var G__27047 = /\d{4}-\d{2}-\d{2}/;
var G__27048 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27047,G__27048) : pred__26994.call(null,G__27047,G__27048));
})();
if(cljs.core.truth_(temp__5733__auto____$8)){
var p__4286__auto__ = temp__5733__auto____$8;
var fexpr__27049 = ((function (p__4286__auto__,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.local_date.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27049(p__4286__auto__);
} else {
var temp__5733__auto____$9 = (function (){var G__27050 = /\d{4}-\d{2}/;
var G__27051 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27050,G__27051) : pred__26994.call(null,G__27050,G__27051));
})();
if(cljs.core.truth_(temp__5733__auto____$9)){
var p__4286__auto__ = temp__5733__auto____$9;
var fexpr__27052 = ((function (p__4286__auto__,temp__5733__auto____$9,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.year_month.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$9,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27052(p__4286__auto__);
} else {
var temp__5733__auto____$10 = (function (){var G__27053 = /\d{4}/;
var G__27054 = expr__26995;
return (pred__26994.cljs$core$IFn$_invoke$arity$2 ? pred__26994.cljs$core$IFn$_invoke$arity$2(G__27053,G__27054) : pred__26994.call(null,G__27053,G__27054));
})();
if(cljs.core.truth_(temp__5733__auto____$10)){
var p__4286__auto__ = temp__5733__auto____$10;
var fexpr__27055 = ((function (p__4286__auto__,temp__5733__auto____$10,temp__5733__auto____$9,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057){
return (function (s__$1){
return cljc.java_time.year.parse.cljs$core$IFn$_invoke$arity$1(s__$1);
});})(p__4286__auto__,temp__5733__auto____$10,temp__5733__auto____$9,temp__5733__auto____$8,temp__5733__auto____$7,temp__5733__auto____$6,temp__5733__auto____$5,temp__5733__auto____$4,temp__5733__auto____$3,temp__5733__auto____$2,temp__5733__auto____$1,temp__5733__auto__,pred__26994,expr__26995,G__26991_27056,G__26992_27057))
;
return fexpr__27055(p__4286__auto__);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unparseable time string",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$input,s], null));
}
}
}
}
}
}
}
}
}
}
}
});})(G__26991_27056,G__26992_27057))
;
goog.object.set(G__26991_27056,G__26992_27057,G__26993_27058);

/**
 * @interface
 */
tick.core.IConversion = function(){};

/**
 * Make a java.util.Date instance.
 */
tick.core.inst = (function tick$core$inst(_){
if(((!((_ == null))) && (!((_.tick$core$IConversion$inst$arity$1 == null))))){
return _.tick$core$IConversion$inst$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.inst[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.inst["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IConversion.inst",_);
}
}
}
});

/**
 * Make a java.time.Instant instance.
 */
tick.core.instant = (function tick$core$instant(_){
if(((!((_ == null))) && (!((_.tick$core$IConversion$instant$arity$1 == null))))){
return _.tick$core$IConversion$instant$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.instant[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.instant["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IConversion.instant",_);
}
}
}
});

/**
 * Make a java.time.OffsetDateTime instance.
 */
tick.core.offset_date_time = (function tick$core$offset_date_time(_){
if(((!((_ == null))) && (!((_.tick$core$IConversion$offset_date_time$arity$1 == null))))){
return _.tick$core$IConversion$offset_date_time$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.offset_date_time[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.offset_date_time["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IConversion.offset-date-time",_);
}
}
}
});

/**
 * Make a java.time.ZonedDateTime instance.
 */
tick.core.zoned_date_time = (function tick$core$zoned_date_time(_){
if(((!((_ == null))) && (!((_.tick$core$IConversion$zoned_date_time$arity$1 == null))))){
return _.tick$core$IConversion$zoned_date_time$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.zoned_date_time[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.zoned_date_time["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IConversion.zoned-date-time",_);
}
}
}
});


/**
 * @interface
 */
tick.core.IExtraction = function(){};

/**
 * Make a java.time.LocalTime instance.
 */
tick.core.time = (function tick$core$time(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$time$arity$1 == null))))){
return _.tick$core$IExtraction$time$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.time[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.time["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.time",_);
}
}
}
});

/**
 * Make a java.time.LocalDate instance.
 */
tick.core.date = (function tick$core$date(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$date$arity$1 == null))))){
return _.tick$core$IExtraction$date$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.date[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.date["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.date",_);
}
}
}
});

/**
 * Make a java.time.LocalDateTime instance.
 */
tick.core.date_time = (function tick$core$date_time(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$date_time$arity$1 == null))))){
return _.tick$core$IExtraction$date_time$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.date_time[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.date_time["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.date-time",_);
}
}
}
});

/**
 * Return the millisecond field of the given time
 */
tick.core.nanosecond = (function tick$core$nanosecond(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$nanosecond$arity$1 == null))))){
return _.tick$core$IExtraction$nanosecond$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.nanosecond[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.nanosecond["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.nanosecond",_);
}
}
}
});

/**
 * Return the millisecond field of the given time
 */
tick.core.microsecond = (function tick$core$microsecond(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$microsecond$arity$1 == null))))){
return _.tick$core$IExtraction$microsecond$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.microsecond[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.microsecond["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.microsecond",_);
}
}
}
});

/**
 * Return the millisecond field of the given time
 */
tick.core.millisecond = (function tick$core$millisecond(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$millisecond$arity$1 == null))))){
return _.tick$core$IExtraction$millisecond$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.millisecond[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.millisecond["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.millisecond",_);
}
}
}
});

/**
 * Return the second field of the given time
 */
tick.core.second = (function tick$core$second(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$second$arity$1 == null))))){
return _.tick$core$IExtraction$second$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.second[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.second["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.second",_);
}
}
}
});

/**
 * Return the minute field of the given time
 */
tick.core.minute = (function tick$core$minute(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$minute$arity$1 == null))))){
return _.tick$core$IExtraction$minute$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.minute[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.minute["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.minute",_);
}
}
}
});

/**
 * Return the hour field of the given time
 */
tick.core.hour = (function tick$core$hour(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$hour$arity$1 == null))))){
return _.tick$core$IExtraction$hour$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.hour[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.hour["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.hour",_);
}
}
}
});

/**
 * Make a java.time.DayOfWeek instance.
 */
tick.core.day_of_week = (function tick$core$day_of_week(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$day_of_week$arity$1 == null))))){
return _.tick$core$IExtraction$day_of_week$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.day_of_week[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.day_of_week["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.day-of-week",_);
}
}
}
});

/**
 * Return value of the day in the month as an integer.
 */
tick.core.day_of_month = (function tick$core$day_of_month(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$day_of_month$arity$1 == null))))){
return _.tick$core$IExtraction$day_of_month$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.day_of_month[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.day_of_month["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.day-of-month",_);
}
}
}
});

/**
 * Return value as integer
 */
tick.core.int$ = (function tick$core$int(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$int$arity$1 == null))))){
return _.tick$core$IExtraction$int$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.int$[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.int$["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.int",_);
}
}
}
});

/**
 * Return value as long
 */
tick.core.long$ = (function tick$core$long(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$long$arity$1 == null))))){
return _.tick$core$IExtraction$long$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.long$[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.long$["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.long",_);
}
}
}
});

/**
 * Make a java.time.Month instance.
 */
tick.core.month = (function tick$core$month(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$month$arity$1 == null))))){
return _.tick$core$IExtraction$month$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.month[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.month["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.month",_);
}
}
}
});

/**
 * Make a java.time.Year instance.
 */
tick.core.year = (function tick$core$year(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$year$arity$1 == null))))){
return _.tick$core$IExtraction$year$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.year[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.year["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.year",_);
}
}
}
});

/**
 * Make a java.time.YearMonth instance.
 */
tick.core.year_month = (function tick$core$year_month(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$year_month$arity$1 == null))))){
return _.tick$core$IExtraction$year_month$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.year_month[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.year_month["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.year-month",_);
}
}
}
});

/**
 * Make a java.time.ZoneId instance.
 */
tick.core.zone = (function tick$core$zone(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$zone$arity$1 == null))))){
return _.tick$core$IExtraction$zone$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.zone[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.zone["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.zone",_);
}
}
}
});

/**
 * Make a java.time.ZoneOffset instance.
 */
tick.core.zone_offset = (function tick$core$zone_offset(_){
if(((!((_ == null))) && (!((_.tick$core$IExtraction$zone_offset$arity$1 == null))))){
return _.tick$core$IExtraction$zone_offset$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.zone_offset[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.zone_offset["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IExtraction.zone-offset",_);
}
}
}
});

tick.core.new_time = (function tick$core$new_time(var_args){
var G__27060 = arguments.length;
switch (G__27060) {
case 0:
return tick.core.new_time.cljs$core$IFn$_invoke$arity$0();

break;
case 2:
return tick.core.new_time.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tick.core.new_time.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return tick.core.new_time.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.new_time.cljs$core$IFn$_invoke$arity$0 = (function (){
return tick.core.time(tick.core.now());
});

tick.core.new_time.cljs$core$IFn$_invoke$arity$2 = (function (hour,minute){
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$2(hour,minute);
});

tick.core.new_time.cljs$core$IFn$_invoke$arity$3 = (function (hour,minute,second){
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$3(hour,minute,second);
});

tick.core.new_time.cljs$core$IFn$_invoke$arity$4 = (function (hour,minute,second,nano){
return cljc.java_time.local_time.of.cljs$core$IFn$_invoke$arity$4(hour,minute,second,nano);
});

tick.core.new_time.cljs$lang$maxFixedArity = 4;

tick.core.new_date = (function tick$core$new_date(var_args){
var G__27063 = arguments.length;
switch (G__27063) {
case 0:
return tick.core.new_date.cljs$core$IFn$_invoke$arity$0();

break;
case 3:
return tick.core.new_date.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return tick.core.new_date.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return tick.core.new_date.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.new_date.cljs$core$IFn$_invoke$arity$0 = (function (){
return tick.core.today();
});

tick.core.new_date.cljs$core$IFn$_invoke$arity$3 = (function (year,month,day_of_month){
return cljc.java_time.local_date.of(year,month,day_of_month);
});

tick.core.new_date.cljs$core$IFn$_invoke$arity$2 = (function (year,day_of_year){
return cljc.java_time.local_date.of_year_day(year,day_of_year);
});

tick.core.new_date.cljs$core$IFn$_invoke$arity$1 = (function (epoch_day){
return cljc.java_time.local_date.of_epoch_day(epoch_day);
});

tick.core.new_date.cljs$lang$maxFixedArity = 3;

/**
 * Return the current zone, which can be overridden by the *clock* dynamic var
 */
tick.core.current_zone = (function tick$core$current_zone(){
var temp__5733__auto__ = tick.core._STAR_clock_STAR_;
if(cljs.core.truth_(temp__5733__auto__)){
var clk = temp__5733__auto__;
return cljc.java_time.clock.get_zone(clk);
} else {
return cljc.java_time.zone_id.system_default();
}
});
goog.object.set(tick.core.IConversion,"function",true);

var G__27065_27092 = tick.core.inst;
var G__27066_27093 = "function";
var G__27067_27094 = ((function (G__27065_27092,G__27066_27093){
return (function (f){
return tick.core.inst((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27065_27092,G__27066_27093))
;
goog.object.set(G__27065_27092,G__27066_27093,G__27067_27094);

var G__27068_27095 = tick.core.instant;
var G__27069_27096 = "function";
var G__27070_27097 = ((function (G__27068_27095,G__27069_27096){
return (function (f){
return tick.core.instant((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27068_27095,G__27069_27096))
;
goog.object.set(G__27068_27095,G__27069_27096,G__27070_27097);

var G__27071_27098 = tick.core.offset_date_time;
var G__27072_27099 = "function";
var G__27073_27100 = ((function (G__27071_27098,G__27072_27099){
return (function (f){
return tick.core.offset_date_time((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27071_27098,G__27072_27099))
;
goog.object.set(G__27071_27098,G__27072_27099,G__27073_27100);

var G__27074_27101 = tick.core.zoned_date_time;
var G__27075_27102 = "function";
var G__27076_27103 = ((function (G__27074_27101,G__27075_27102){
return (function (f){
return tick.core.zoned_date_time((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27074_27101,G__27075_27102))
;
goog.object.set(G__27074_27101,G__27075_27102,G__27076_27103);

java.time.Instant.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$IConversion$inst$arity$1 = (function (i){
var i__$1 = this;
return (new Date(cljc.java_time.instant.to_epoch_milli(i__$1)));
});

java.time.Instant.prototype.tick$core$IConversion$instant$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.Instant.prototype.tick$core$IConversion$offset_date_time$arity$1 = (function (i){
var i__$1 = this;
return tick.core.zoned_date_time(i__$1);
});

java.time.Instant.prototype.tick$core$IConversion$zoned_date_time$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.zoned_date_time.of_instant.cljs$core$IFn$_invoke$arity$2(i__$1,tick.core.current_zone());
});

goog.object.set(tick.core.IConversion,"string",true);

var G__27077_27104 = tick.core.inst;
var G__27078_27105 = "string";
var G__27079_27106 = ((function (G__27077_27104,G__27078_27105){
return (function (s){
return tick.core.inst(tick.core.instant(s));
});})(G__27077_27104,G__27078_27105))
;
goog.object.set(G__27077_27104,G__27078_27105,G__27079_27106);

var G__27080_27107 = tick.core.instant;
var G__27081_27108 = "string";
var G__27082_27109 = ((function (G__27080_27107,G__27081_27108){
return (function (s){
return tick.core.instant(tick.core.parse(s));
});})(G__27080_27107,G__27081_27108))
;
goog.object.set(G__27080_27107,G__27081_27108,G__27082_27109);

var G__27083_27110 = tick.core.offset_date_time;
var G__27084_27111 = "string";
var G__27085_27112 = ((function (G__27083_27110,G__27084_27111){
return (function (s){
return tick.core.zoned_date_time(s);
});})(G__27083_27110,G__27084_27111))
;
goog.object.set(G__27083_27110,G__27084_27111,G__27085_27112);

var G__27086_27113 = tick.core.zoned_date_time;
var G__27087_27114 = "string";
var G__27088_27115 = ((function (G__27086_27113,G__27087_27114){
return (function (s){
return cljc.java_time.zoned_date_time.parse.cljs$core$IFn$_invoke$arity$1(s);
});})(G__27086_27113,G__27087_27114))
;
goog.object.set(G__27086_27113,G__27087_27114,G__27088_27115);

goog.object.set(tick.core.IConversion,"number",true);

var G__27089_27116 = tick.core.instant;
var G__27090_27117 = "number";
var G__27091_27118 = ((function (G__27089_27116,G__27090_27117){
return (function (n){
return cljc.java_time.instant.of_epoch_milli(n);
});})(G__27089_27116,G__27090_27117))
;
goog.object.set(G__27089_27116,G__27090_27117,G__27091_27118);

java.time.LocalDateTime.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$IConversion$inst$arity$1 = (function (ldt){
var ldt__$1 = this;
return tick.core.inst(tick.core.zoned_date_time(ldt__$1));
});

java.time.LocalDateTime.prototype.tick$core$IConversion$instant$arity$1 = (function (ldt){
var ldt__$1 = this;
return tick.core.instant(tick.core.zoned_date_time(ldt__$1));
});

java.time.LocalDateTime.prototype.tick$core$IConversion$offset_date_time$arity$1 = (function (ldt){
var ldt__$1 = this;
return tick.core.zoned_date_time(ldt__$1);
});

java.time.LocalDateTime.prototype.tick$core$IConversion$zoned_date_time$arity$1 = (function (ldt){
var ldt__$1 = this;
return cljc.java_time.local_date_time.at_zone(ldt__$1,tick.core.current_zone());
});

Date.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$IConversion$inst$arity$1 = (function (d){
var d__$1 = this;
return d__$1;
});

Date.prototype.tick$core$IConversion$instant$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.instant.of_epoch_milli(d__$1.getTime());
});

Date.prototype.tick$core$IConversion$zoned_date_time$arity$1 = (function (d){
var d__$1 = this;
return tick.core.zoned_date_time(tick.core.instant(d__$1));
});

Date.prototype.tick$core$IConversion$offset_date_time$arity$1 = (function (d){
var d__$1 = this;
return tick.core.offset_date_time(tick.core.instant(d__$1));
});

java.time.OffsetDateTime.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetDateTime.prototype.tick$core$IConversion$inst$arity$1 = (function (odt){
var odt__$1 = this;
return tick.core.inst(tick.core.instant(odt__$1));
});

java.time.OffsetDateTime.prototype.tick$core$IConversion$instant$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.to_instant(odt__$1);
});

java.time.OffsetDateTime.prototype.tick$core$IConversion$offset_date_time$arity$1 = (function (odt){
var odt__$1 = this;
return odt__$1;
});

java.time.OffsetDateTime.prototype.tick$core$IConversion$zoned_date_time$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.to_zoned_date_time(odt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$IConversion$inst$arity$1 = (function (zdt){
var zdt__$1 = this;
return tick.core.inst(tick.core.instant(zdt__$1));
});

java.time.ZonedDateTime.prototype.tick$core$IConversion$instant$arity$1 = (function (zdt){
var zdt__$1 = this;
return zdt__$1.toInstant();
});

java.time.ZonedDateTime.prototype.tick$core$IConversion$offset_date_time$arity$1 = (function (zdt){
var zdt__$1 = this;
return zdt__$1;
});

java.time.ZonedDateTime.prototype.tick$core$IConversion$zoned_date_time$arity$1 = (function (zdt){
var zdt__$1 = this;
return zdt__$1;
});
java.time.YearMonth.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.YearMonth.prototype.tick$core$IExtraction$year_month$arity$1 = (function (ym){
var ym__$1 = this;
return ym__$1;
});

java.time.YearMonth.prototype.tick$core$IExtraction$month$arity$1 = (function (ym){
var ym__$1 = this;
return cljc.java_time.year_month.get_month(ym__$1);
});

java.time.YearMonth.prototype.tick$core$IExtraction$year$arity$1 = (function (ym){
var ym__$1 = this;
return tick.core.year(cljc.java_time.year_month.get_year(ym__$1));
});

java.time.Year.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Year.prototype.tick$core$IExtraction$year$arity$1 = (function (y){
var y__$1 = this;
return y__$1;
});

java.time.Year.prototype.tick$core$IExtraction$int$arity$1 = (function (y){
var y__$1 = this;
return cljc.java_time.year.get_value(y__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$IExtraction$time$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.to_local_time(zdt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$date$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.to_local_date(zdt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$date_time$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.to_local_date_time(zdt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$nanosecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get(t__$1,cljc.java_time.temporal.chrono_field.nano_of_second);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$microsecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get(t__$1,cljc.java_time.temporal.chrono_field.micro_of_second);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$millisecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get(t__$1,cljc.java_time.temporal.chrono_field.milli_of_second);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$second$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get_second(t__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$minute$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get_minute(t__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$hour$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get_hour(t__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$day_of_week$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get_day_of_week(t__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$day_of_month$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.zoned_date_time.get_day_of_month(t__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$month$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.get_month(zdt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$year$arity$1 = (function (zdt){
var zdt__$1 = this;
return tick.core.year(cljc.java_time.zoned_date_time.get_year(zdt__$1));
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$zone$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.get_zone(zdt__$1);
});

java.time.ZonedDateTime.prototype.tick$core$IExtraction$zone_offset$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.zoned_date_time.get_offset(zdt__$1);
});

java.time.Instant.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$IExtraction$time$arity$1 = (function (i){
var i__$1 = this;
return tick.core.time(tick.core.zoned_date_time(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$date$arity$1 = (function (i){
var i__$1 = this;
return tick.core.date(tick.core.zoned_date_time(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$date_time$arity$1 = (function (i){
var i__$1 = this;
return tick.core.date_time(tick.core.zoned_date_time(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$nanosecond$arity$1 = (function (t){
var t__$1 = this;
return tick.core.nanosecond(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$microsecond$arity$1 = (function (t){
var t__$1 = this;
return tick.core.microsecond(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$millisecond$arity$1 = (function (t){
var t__$1 = this;
return tick.core.millisecond(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$second$arity$1 = (function (t){
var t__$1 = this;
return tick.core.second(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$minute$arity$1 = (function (t){
var t__$1 = this;
return tick.core.minute(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$hour$arity$1 = (function (t){
var t__$1 = this;
return tick.core.hour(tick.core.zoned_date_time(t__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$day_of_week$arity$1 = (function (i){
var i__$1 = this;
return tick.core.day_of_week(tick.core.date(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$day_of_month$arity$1 = (function (i){
var i__$1 = this;
return tick.core.day_of_month(tick.core.date(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$int$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.instant.get_nano(i__$1);
});

java.time.Instant.prototype.tick$core$IExtraction$long$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.instant.get_epoch_second(i__$1);
});

java.time.Instant.prototype.tick$core$IExtraction$month$arity$1 = (function (i){
var i__$1 = this;
return tick.core.month(tick.core.date(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$year$arity$1 = (function (i){
var i__$1 = this;
return tick.core.year(tick.core.date(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$year_month$arity$1 = (function (i){
var i__$1 = this;
return tick.core.year_month(tick.core.date(i__$1));
});

java.time.Instant.prototype.tick$core$IExtraction$zone$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.zone_id.of.cljs$core$IFn$_invoke$arity$1("UTC");
});

java.time.Instant.prototype.tick$core$IExtraction$zone_offset$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.zone_offset.utc;
});

goog.object.set(tick.core.IExtraction,"object",true);

var G__27119_27227 = tick.core.int$;
var G__27120_27228 = "object";
var G__27121_27229 = ((function (G__27119_27227,G__27120_27228){
return (function (v){
return tick.core.parse_int(v);
});})(G__27119_27227,G__27120_27228))
;
goog.object.set(G__27119_27227,G__27120_27228,G__27121_27229);

var G__27122_27230 = tick.core.long$;
var G__27123_27231 = "object";
var G__27124_27232 = ((function (G__27122_27230,G__27123_27231){
return (function (v){
return tick.core.parse_int(v);
});})(G__27122_27230,G__27123_27231))
;
goog.object.set(G__27122_27230,G__27123_27231,G__27124_27232);

Date.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$IExtraction$date$arity$1 = (function (d){
var d__$1 = this;
return tick.core.date(tick.core.zoned_date_time(tick.core.instant(d__$1)));
});

Date.prototype.tick$core$IExtraction$date_time$arity$1 = (function (d){
var d__$1 = this;
return tick.core.date_time(tick.core.instant(d__$1));
});

Date.prototype.tick$core$IExtraction$year_month$arity$1 = (function (d){
var d__$1 = this;
return tick.core.year_month(tick.core.date(d__$1));
});

Date.prototype.tick$core$IExtraction$year$arity$1 = (function (d){
var d__$1 = this;
return tick.core.year(tick.core.date(d__$1));
});

java.time.ZoneId.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZoneId.prototype.tick$core$IExtraction$zone$arity$1 = (function (z){
var z__$1 = this;
return z__$1;
});

java.time.LocalDate.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$IExtraction$date$arity$1 = (function (d){
var d__$1 = this;
return d__$1;
});

java.time.LocalDate.prototype.tick$core$IExtraction$day_of_week$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.local_date.get_day_of_week(d__$1);
});

java.time.LocalDate.prototype.tick$core$IExtraction$day_of_month$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.local_date.get_day_of_month(d__$1);
});

java.time.LocalDate.prototype.tick$core$IExtraction$month$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.month.from(d__$1);
});

java.time.LocalDate.prototype.tick$core$IExtraction$year_month$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.year_month.of(cljc.java_time.local_date.get_year(d__$1),cljc.java_time.local_date.get_month_value(d__$1));
});

java.time.LocalDate.prototype.tick$core$IExtraction$year$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.year.of(cljc.java_time.local_date.get_year(d__$1));
});

goog.object.set(tick.core.IExtraction,"number",true);

var G__27125_27233 = tick.core.day_of_week;
var G__27126_27234 = "number";
var G__27127_27235 = ((function (G__27125_27233,G__27126_27234){
return (function (n){
return cljc.java_time.day_of_week.of(n);
});})(G__27125_27233,G__27126_27234))
;
goog.object.set(G__27125_27233,G__27126_27234,G__27127_27235);

var G__27128_27236 = tick.core.month;
var G__27129_27237 = "number";
var G__27130_27238 = ((function (G__27128_27236,G__27129_27237){
return (function (n){
return cljc.java_time.month.of(n);
});})(G__27128_27236,G__27129_27237))
;
goog.object.set(G__27128_27236,G__27129_27237,G__27130_27238);

var G__27131_27239 = tick.core.year;
var G__27132_27240 = "number";
var G__27133_27241 = ((function (G__27131_27239,G__27132_27240){
return (function (n){
return cljc.java_time.year.of(n);
});})(G__27131_27239,G__27132_27240))
;
goog.object.set(G__27131_27239,G__27132_27240,G__27133_27241);

var G__27134_27242 = tick.core.zone_offset;
var G__27135_27243 = "number";
var G__27136_27244 = ((function (G__27134_27242,G__27135_27243){
return (function (s){
return cljc.java_time.zone_offset.of_hours(s);
});})(G__27134_27242,G__27135_27243))
;
goog.object.set(G__27134_27242,G__27135_27243,G__27136_27244);

java.time.ZoneOffset.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZoneOffset.prototype.tick$core$IExtraction$zone_offset$arity$1 = (function (z){
var z__$1 = this;
return z__$1;
});

goog.object.set(tick.core.IExtraction,"string",true);

var G__27137_27245 = tick.core.time;
var G__27138_27246 = "string";
var G__27139_27247 = ((function (G__27137_27245,G__27138_27246){
return (function (s){
return tick.core.time(tick.core.parse(s));
});})(G__27137_27245,G__27138_27246))
;
goog.object.set(G__27137_27245,G__27138_27246,G__27139_27247);

var G__27140_27248 = tick.core.date;
var G__27141_27249 = "string";
var G__27142_27250 = ((function (G__27140_27248,G__27141_27249){
return (function (s){
return tick.core.date(tick.core.parse(s));
});})(G__27140_27248,G__27141_27249))
;
goog.object.set(G__27140_27248,G__27141_27249,G__27142_27250);

var G__27143_27251 = tick.core.date_time;
var G__27144_27252 = "string";
var G__27145_27253 = ((function (G__27143_27251,G__27144_27252){
return (function (s){
return cljc.java_time.local_date_time.parse.cljs$core$IFn$_invoke$arity$1(s);
});})(G__27143_27251,G__27144_27252))
;
goog.object.set(G__27143_27251,G__27144_27252,G__27145_27253);

var G__27146_27254 = tick.core.day_of_week;
var G__27147_27255 = "string";
var G__27148_27256 = ((function (G__27146_27254,G__27147_27255){
return (function (s){
var or__3949__auto__ = tick.core.parse_day(s);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return tick.core.day_of_week(tick.core.date(s));
}
});})(G__27146_27254,G__27147_27255))
;
goog.object.set(G__27146_27254,G__27147_27255,G__27148_27256);

var G__27149_27257 = tick.core.day_of_month;
var G__27150_27258 = "string";
var G__27151_27259 = ((function (G__27149_27257,G__27150_27258){
return (function (s){
return tick.core.day_of_month(tick.core.date(s));
});})(G__27149_27257,G__27150_27258))
;
goog.object.set(G__27149_27257,G__27150_27258,G__27151_27259);

var G__27152_27260 = tick.core.month;
var G__27153_27261 = "string";
var G__27154_27262 = ((function (G__27152_27260,G__27153_27261){
return (function (s){
var or__3949__auto__ = tick.core.parse_month(s);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return tick.core.month(tick.core.date(s));
}
});})(G__27152_27260,G__27153_27261))
;
goog.object.set(G__27152_27260,G__27153_27261,G__27154_27262);

var G__27155_27263 = tick.core.year;
var G__27156_27264 = "string";
var G__27157_27265 = ((function (G__27155_27263,G__27156_27264){
return (function (s){
return tick.core.year(tick.core.parse(s));
});})(G__27155_27263,G__27156_27264))
;
goog.object.set(G__27155_27263,G__27156_27264,G__27157_27265);

var G__27158_27266 = tick.core.year_month;
var G__27159_27267 = "string";
var G__27160_27268 = ((function (G__27158_27266,G__27159_27267){
return (function (s){
return tick.core.year_month(tick.core.parse(s));
});})(G__27158_27266,G__27159_27267))
;
goog.object.set(G__27158_27266,G__27159_27267,G__27160_27268);

var G__27161_27269 = tick.core.zone;
var G__27162_27270 = "string";
var G__27163_27271 = ((function (G__27161_27269,G__27162_27270){
return (function (s){
return cljc.java_time.zone_id.of.cljs$core$IFn$_invoke$arity$1(s);
});})(G__27161_27269,G__27162_27270))
;
goog.object.set(G__27161_27269,G__27162_27270,G__27163_27271);

var G__27164_27272 = tick.core.zone_offset;
var G__27165_27273 = "string";
var G__27166_27274 = ((function (G__27164_27272,G__27165_27273){
return (function (s){
return cljc.java_time.zone_offset.of.cljs$core$IFn$_invoke$arity$1(s);
});})(G__27164_27272,G__27165_27273))
;
goog.object.set(G__27164_27272,G__27165_27273,G__27166_27274);

var G__27167_27275 = tick.core.int$;
var G__27168_27276 = "string";
var G__27169_27277 = ((function (G__27167_27275,G__27168_27276){
return (function (s){
return cljc.java_time.instant.get_nano(tick.core.instant(s));
});})(G__27167_27275,G__27168_27276))
;
goog.object.set(G__27167_27275,G__27168_27276,G__27169_27277);

var G__27170_27278 = tick.core.long$;
var G__27171_27279 = "string";
var G__27172_27280 = ((function (G__27170_27278,G__27171_27279){
return (function (s){
return cljc.java_time.instant.get_epoch_second(tick.core.instant(s));
});})(G__27170_27278,G__27171_27279))
;
goog.object.set(G__27170_27278,G__27171_27279,G__27172_27280);

goog.object.set(tick.core.IExtraction,"function",true);

var G__27173_27281 = tick.core.time;
var G__27174_27282 = "function";
var G__27175_27283 = ((function (G__27173_27281,G__27174_27282){
return (function (f){
return tick.core.time((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27173_27281,G__27174_27282))
;
goog.object.set(G__27173_27281,G__27174_27282,G__27175_27283);

var G__27176_27284 = tick.core.date;
var G__27177_27285 = "function";
var G__27178_27286 = ((function (G__27176_27284,G__27177_27285){
return (function (f){
return tick.core.date((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27176_27284,G__27177_27285))
;
goog.object.set(G__27176_27284,G__27177_27285,G__27178_27286);

var G__27179_27287 = tick.core.date_time;
var G__27180_27288 = "function";
var G__27181_27289 = ((function (G__27179_27287,G__27180_27288){
return (function (f){
return tick.core.date_time((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27179_27287,G__27180_27288))
;
goog.object.set(G__27179_27287,G__27180_27288,G__27181_27289);

var G__27182_27290 = tick.core.nanosecond;
var G__27183_27291 = "function";
var G__27184_27292 = ((function (G__27182_27290,G__27183_27291){
return (function (f){
return tick.core.nanosecond((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27182_27290,G__27183_27291))
;
goog.object.set(G__27182_27290,G__27183_27291,G__27184_27292);

var G__27185_27293 = tick.core.microsecond;
var G__27186_27294 = "function";
var G__27187_27295 = ((function (G__27185_27293,G__27186_27294){
return (function (f){
return tick.core.microsecond((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27185_27293,G__27186_27294))
;
goog.object.set(G__27185_27293,G__27186_27294,G__27187_27295);

var G__27188_27296 = tick.core.millisecond;
var G__27189_27297 = "function";
var G__27190_27298 = ((function (G__27188_27296,G__27189_27297){
return (function (f){
return tick.core.millisecond((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27188_27296,G__27189_27297))
;
goog.object.set(G__27188_27296,G__27189_27297,G__27190_27298);

var G__27191_27299 = tick.core.second;
var G__27192_27300 = "function";
var G__27193_27301 = ((function (G__27191_27299,G__27192_27300){
return (function (f){
return tick.core.second((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27191_27299,G__27192_27300))
;
goog.object.set(G__27191_27299,G__27192_27300,G__27193_27301);

var G__27194_27302 = tick.core.minute;
var G__27195_27303 = "function";
var G__27196_27304 = ((function (G__27194_27302,G__27195_27303){
return (function (f){
return tick.core.minute((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27194_27302,G__27195_27303))
;
goog.object.set(G__27194_27302,G__27195_27303,G__27196_27304);

var G__27197_27305 = tick.core.hour;
var G__27198_27306 = "function";
var G__27199_27307 = ((function (G__27197_27305,G__27198_27306){
return (function (f){
return tick.core.hour((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27197_27305,G__27198_27306))
;
goog.object.set(G__27197_27305,G__27198_27306,G__27199_27307);

var G__27200_27308 = tick.core.day_of_week;
var G__27201_27309 = "function";
var G__27202_27310 = ((function (G__27200_27308,G__27201_27309){
return (function (f){
return tick.core.day_of_week((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27200_27308,G__27201_27309))
;
goog.object.set(G__27200_27308,G__27201_27309,G__27202_27310);

var G__27203_27311 = tick.core.day_of_month;
var G__27204_27312 = "function";
var G__27205_27313 = ((function (G__27203_27311,G__27204_27312){
return (function (f){
return tick.core.day_of_month((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27203_27311,G__27204_27312))
;
goog.object.set(G__27203_27311,G__27204_27312,G__27205_27313);

var G__27206_27314 = tick.core.int$;
var G__27207_27315 = "function";
var G__27208_27316 = ((function (G__27206_27314,G__27207_27315){
return (function (f){
return tick.core.int$((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27206_27314,G__27207_27315))
;
goog.object.set(G__27206_27314,G__27207_27315,G__27208_27316);

var G__27209_27317 = tick.core.long$;
var G__27210_27318 = "function";
var G__27211_27319 = ((function (G__27209_27317,G__27210_27318){
return (function (f){
return tick.core.long$((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27209_27317,G__27210_27318))
;
goog.object.set(G__27209_27317,G__27210_27318,G__27211_27319);

var G__27212_27320 = tick.core.month;
var G__27213_27321 = "function";
var G__27214_27322 = ((function (G__27212_27320,G__27213_27321){
return (function (f){
return tick.core.month((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27212_27320,G__27213_27321))
;
goog.object.set(G__27212_27320,G__27213_27321,G__27214_27322);

var G__27215_27323 = tick.core.year;
var G__27216_27324 = "function";
var G__27217_27325 = ((function (G__27215_27323,G__27216_27324){
return (function (f){
return tick.core.year((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27215_27323,G__27216_27324))
;
goog.object.set(G__27215_27323,G__27216_27324,G__27217_27325);

var G__27218_27326 = tick.core.year_month;
var G__27219_27327 = "function";
var G__27220_27328 = ((function (G__27218_27326,G__27219_27327){
return (function (f){
return tick.core.year_month((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27218_27326,G__27219_27327))
;
goog.object.set(G__27218_27326,G__27219_27327,G__27220_27328);

var G__27221_27329 = tick.core.zone;
var G__27222_27330 = "function";
var G__27223_27331 = ((function (G__27221_27329,G__27222_27330){
return (function (f){
return tick.core.zone((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27221_27329,G__27222_27330))
;
goog.object.set(G__27221_27329,G__27222_27330,G__27223_27331);

var G__27224_27332 = tick.core.zone_offset;
var G__27225_27333 = "function";
var G__27226_27334 = ((function (G__27224_27332,G__27225_27333){
return (function (f){
return tick.core.zone_offset((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});})(G__27224_27332,G__27225_27333))
;
goog.object.set(G__27224_27332,G__27225_27333,G__27226_27334);

java.time.LocalTime.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$IExtraction$time$arity$1 = (function (t){
var t__$1 = this;
return t__$1;
});

java.time.LocalTime.prototype.tick$core$IExtraction$nanosecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get(t__$1,cljc.java_time.temporal.chrono_field.nano_of_second);
});

java.time.LocalTime.prototype.tick$core$IExtraction$microsecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get(t__$1,cljc.java_time.temporal.chrono_field.micro_of_second);
});

java.time.LocalTime.prototype.tick$core$IExtraction$millisecond$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get(t__$1,cljc.java_time.temporal.chrono_field.milli_of_second);
});

java.time.LocalTime.prototype.tick$core$IExtraction$second$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get_second(t__$1);
});

java.time.LocalTime.prototype.tick$core$IExtraction$minute$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get_minute(t__$1);
});

java.time.LocalTime.prototype.tick$core$IExtraction$hour$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_time.get_hour(t__$1);
});

java.time.OffsetDateTime.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetDateTime.prototype.tick$core$IExtraction$time$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.to_local_time(odt__$1);
});

java.time.OffsetDateTime.prototype.tick$core$IExtraction$date$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.to_local_date(odt__$1);
});

java.time.OffsetDateTime.prototype.tick$core$IExtraction$date_time$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.to_local_date_time(odt__$1);
});

java.time.OffsetDateTime.prototype.tick$core$IExtraction$year$arity$1 = (function (odt){
var odt__$1 = this;
return tick.core.year(cljc.java_time.offset_date_time.get_year(odt__$1));
});

java.time.OffsetDateTime.prototype.tick$core$IExtraction$zone_offset$arity$1 = (function (odt){
var odt__$1 = this;
return cljc.java_time.offset_date_time.get_offset(odt__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$IExtraction$time$arity$1 = (function (dt){
var dt__$1 = this;
return cljc.java_time.local_date_time.to_local_time(dt__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$date$arity$1 = (function (dt){
var dt__$1 = this;
return cljc.java_time.local_date_time.to_local_date(dt__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$date_time$arity$1 = (function (ldt){
var ldt__$1 = this;
return ldt__$1;
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$second$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_date_time.get_second(t__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$minute$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_date_time.get_minute(t__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$hour$arity$1 = (function (t){
var t__$1 = this;
return cljc.java_time.local_date_time.get_hour(t__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$day_of_week$arity$1 = (function (dt){
var dt__$1 = this;
return tick.core.day_of_week(tick.core.date(dt__$1));
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$day_of_month$arity$1 = (function (dt){
var dt__$1 = this;
return tick.core.day_of_month(tick.core.date(dt__$1));
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$year_month$arity$1 = (function (dt){
var dt__$1 = this;
return tick.core.year_month(tick.core.date(dt__$1));
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$month$arity$1 = (function (dt){
var dt__$1 = this;
return cljc.java_time.local_date_time.get_month(dt__$1);
});

java.time.LocalDateTime.prototype.tick$core$IExtraction$year$arity$1 = (function (dt){
var dt__$1 = this;
return tick.core.year(tick.core.date(dt__$1));
});

java.time.Month.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Month.prototype.tick$core$IExtraction$int$arity$1 = (function (m){
var m__$1 = this;
return cljc.java_time.month.get_value(m__$1);
});

java.time.DayOfWeek.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.DayOfWeek.prototype.tick$core$IExtraction$int$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.day_of_week.get_value(d__$1);
});
tick.core.field_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$proleptic_DASH_month,cljs.core.cst$kw$aligned_DASH_week_DASH_of_DASH_month,cljs.core.cst$kw$clock_DASH_hour_DASH_of_DASH_ampm,cljs.core.cst$kw$epoch_DASH_day,cljs.core.cst$kw$nano_DASH_of_DASH_second,cljs.core.cst$kw$aligned_DASH_week_DASH_of_DASH_year,cljs.core.cst$kw$era,cljs.core.cst$kw$offset_DASH_seconds,cljs.core.cst$kw$micro_DASH_of_DASH_day,cljs.core.cst$kw$minute_DASH_of_DASH_day,cljs.core.cst$kw$day_DASH_of_DASH_week,cljs.core.cst$kw$ampm_DASH_of_DASH_day,cljs.core.cst$kw$clock_DASH_hour_DASH_of_DASH_day,cljs.core.cst$kw$hour_DASH_of_DASH_day,cljs.core.cst$kw$month_DASH_of_DASH_year,cljs.core.cst$kw$milli_DASH_of_DASH_second,cljs.core.cst$kw$instant_DASH_seconds,cljs.core.cst$kw$micro_DASH_of_DASH_second,cljs.core.cst$kw$aligned_DASH_day_DASH_of_DASH_week_DASH_in_DASH_month,cljs.core.cst$kw$day_DASH_of_DASH_month,cljs.core.cst$kw$year,cljs.core.cst$kw$day_DASH_of_DASH_year,cljs.core.cst$kw$year_DASH_of_DASH_era,cljs.core.cst$kw$nano_DASH_of_DASH_day,cljs.core.cst$kw$hour_DASH_of_DASH_ampm,cljs.core.cst$kw$second_DASH_of_DASH_minute,cljs.core.cst$kw$aligned_DASH_day_DASH_of_DASH_week_DASH_in_DASH_year,cljs.core.cst$kw$second_DASH_of_DASH_day,cljs.core.cst$kw$milli_DASH_of_DASH_day,cljs.core.cst$kw$minute_DASH_of_DASH_hour],[cljc.java_time.temporal.chrono_field.proleptic_month,cljc.java_time.temporal.chrono_field.aligned_week_of_month,cljc.java_time.temporal.chrono_field.clock_hour_of_ampm,cljc.java_time.temporal.chrono_field.epoch_day,cljc.java_time.temporal.chrono_field.nano_of_second,cljc.java_time.temporal.chrono_field.aligned_week_of_year,cljc.java_time.temporal.chrono_field.era,cljc.java_time.temporal.chrono_field.offset_seconds,cljc.java_time.temporal.chrono_field.micro_of_day,cljc.java_time.temporal.chrono_field.minute_of_day,cljc.java_time.temporal.chrono_field.day_of_week,cljc.java_time.temporal.chrono_field.ampm_of_day,cljc.java_time.temporal.chrono_field.clock_hour_of_day,cljc.java_time.temporal.chrono_field.hour_of_day,cljc.java_time.temporal.chrono_field.month_of_year,cljc.java_time.temporal.chrono_field.milli_of_second,cljc.java_time.temporal.chrono_field.instant_seconds,cljc.java_time.temporal.chrono_field.micro_of_second,cljc.java_time.temporal.chrono_field.aligned_day_of_week_in_month,cljc.java_time.temporal.chrono_field.day_of_month,cljc.java_time.temporal.chrono_field.year,cljc.java_time.temporal.chrono_field.day_of_year,cljc.java_time.temporal.chrono_field.year_of_era,cljc.java_time.temporal.chrono_field.nano_of_day,cljc.java_time.temporal.chrono_field.hour_of_ampm,cljc.java_time.temporal.chrono_field.second_of_minute,cljc.java_time.temporal.chrono_field.aligned_day_of_week_in_year,cljc.java_time.temporal.chrono_field.second_of_day,cljc.java_time.temporal.chrono_field.milli_of_day,cljc.java_time.temporal.chrono_field.minute_of_hour]);

/**
* @constructor
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ILookup}
*/
tick.core.FieldsLookup = (function (t){
this.t = t;
this.cljs$lang$protocol_mask$partition0$ = 8388864;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
tick.core.FieldsLookup.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (___$1){
return (function (p__27335){
var vec__27336 = p__27335;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27336,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27336,(1),null);
var cf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tick.core.field_map,k);
if(cljs.core.truth_(self__.t.isSupported(cf))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,self__.t.getLong(cf)], null);
} else {
return null;
}
});})(___$1))
,tick.core.field_map)));
});

tick.core.FieldsLookup.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,fld){
var self__ = this;
var ___$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tick.core.field_map,fld);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
return self__.t.getLong(f);
} else {
return null;
}
});

tick.core.FieldsLookup.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,fld,notfound){
var self__ = this;
var ___$1 = this;
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tick.core.field_map,fld);
if(cljs.core.truth_(temp__5733__auto__)){
var f = temp__5733__auto__;
try{return self__.t.getLong(f);
}catch (e27339){if((e27339 instanceof Error)){
var e = e27339;
return notfound;
} else {
throw e27339;

}
}} else {
return notfound;
}
});

tick.core.FieldsLookup.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$t], null);
});

tick.core.FieldsLookup.cljs$lang$type = true;

tick.core.FieldsLookup.cljs$lang$ctorStr = "tick.core/FieldsLookup";

tick.core.FieldsLookup.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"tick.core/FieldsLookup");
});

/**
 * Positional factory function for tick.core/FieldsLookup.
 */
tick.core.__GT_FieldsLookup = (function tick$core$__GT_FieldsLookup(t){
return (new tick.core.FieldsLookup(t));
});

tick.core.fields = (function tick$core$fields(t){
return tick.core.__GT_FieldsLookup(t);
});
/**
 * Adjust a temporal with an adjuster or field
 */
tick.core.with$ = (function tick$core$with(var_args){
var G__27341 = arguments.length;
switch (G__27341) {
case 2:
return tick.core.with$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tick.core.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.with$.cljs$core$IFn$_invoke$arity$2 = (function (t,adj){
return t.with(adj);
});

tick.core.with$.cljs$core$IFn$_invoke$arity$3 = (function (t,fld,new_value){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tick.core.field_map,fld);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
return t.with(f,new_value);
} else {
return null;
}
});

tick.core.with$.cljs$lang$maxFixedArity = 3;

tick.core.day_of_week_in_month = (function tick$core$day_of_week_in_month(var_args){
var G__27344 = arguments.length;
switch (G__27344) {
case 2:
return tick.core.day_of_week_in_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tick.core.day_of_week_in_month.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.day_of_week_in_month.cljs$core$IFn$_invoke$arity$2 = (function (ordinal,dow){
return cljc.java_time.temporal.temporal_adjusters.day_of_week_in_month(ordinal,tick.core.day_of_week(dow));
});

tick.core.day_of_week_in_month.cljs$core$IFn$_invoke$arity$3 = (function (t,ordinal,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.day_of_week_in_month.cljs$core$IFn$_invoke$arity$2(ordinal,dow));
});

tick.core.day_of_week_in_month.cljs$lang$maxFixedArity = 3;

tick.core.first_day_of_month = (function tick$core$first_day_of_month(var_args){
var G__27347 = arguments.length;
switch (G__27347) {
case 0:
return tick.core.first_day_of_month.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.first_day_of_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.first_day_of_month.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.first_day_of_month();
});

tick.core.first_day_of_month.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.first_day_of_month.cljs$core$IFn$_invoke$arity$0());
});

tick.core.first_day_of_month.cljs$lang$maxFixedArity = 1;

tick.core.first_day_of_next_month = (function tick$core$first_day_of_next_month(var_args){
var G__27350 = arguments.length;
switch (G__27350) {
case 0:
return tick.core.first_day_of_next_month.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.first_day_of_next_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.first_day_of_next_month.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.first_day_of_next_month();
});

tick.core.first_day_of_next_month.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.first_day_of_next_month.cljs$core$IFn$_invoke$arity$0());
});

tick.core.first_day_of_next_month.cljs$lang$maxFixedArity = 1;

tick.core.first_day_of_next_year = (function tick$core$first_day_of_next_year(var_args){
var G__27353 = arguments.length;
switch (G__27353) {
case 0:
return tick.core.first_day_of_next_year.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.first_day_of_next_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.first_day_of_next_year.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.first_day_of_next_year();
});

tick.core.first_day_of_next_year.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.first_day_of_next_year.cljs$core$IFn$_invoke$arity$0());
});

tick.core.first_day_of_next_year.cljs$lang$maxFixedArity = 1;

tick.core.first_day_of_year = (function tick$core$first_day_of_year(var_args){
var G__27356 = arguments.length;
switch (G__27356) {
case 0:
return tick.core.first_day_of_year.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.first_day_of_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.first_day_of_year.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.first_day_of_year();
});

tick.core.first_day_of_year.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.first_day_of_year.cljs$core$IFn$_invoke$arity$0());
});

tick.core.first_day_of_year.cljs$lang$maxFixedArity = 1;

tick.core.first_in_month = (function tick$core$first_in_month(var_args){
var G__27359 = arguments.length;
switch (G__27359) {
case 1:
return tick.core.first_in_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.first_in_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.first_in_month.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.first_in_month(tick.core.day_of_week(dow));
});

tick.core.first_in_month.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.first_in_month.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.first_in_month.cljs$lang$maxFixedArity = 2;

tick.core.last_day_of_month = (function tick$core$last_day_of_month(var_args){
var G__27362 = arguments.length;
switch (G__27362) {
case 0:
return tick.core.last_day_of_month.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.last_day_of_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.last_day_of_month.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.last_day_of_month();
});

tick.core.last_day_of_month.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.last_day_of_month.cljs$core$IFn$_invoke$arity$0());
});

tick.core.last_day_of_month.cljs$lang$maxFixedArity = 1;

tick.core.last_day_of_year = (function tick$core$last_day_of_year(var_args){
var G__27365 = arguments.length;
switch (G__27365) {
case 0:
return tick.core.last_day_of_year.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return tick.core.last_day_of_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.last_day_of_year.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljc.java_time.temporal.temporal_adjusters.last_day_of_year();
});

tick.core.last_day_of_year.cljs$core$IFn$_invoke$arity$1 = (function (t){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.last_day_of_year.cljs$core$IFn$_invoke$arity$0());
});

tick.core.last_day_of_year.cljs$lang$maxFixedArity = 1;

tick.core.last_in_month = (function tick$core$last_in_month(var_args){
var G__27368 = arguments.length;
switch (G__27368) {
case 1:
return tick.core.last_in_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.last_in_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.last_in_month.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.last_in_month(tick.core.day_of_week(dow));
});

tick.core.last_in_month.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.last_in_month.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.last_in_month.cljs$lang$maxFixedArity = 2;

tick.core.next = (function tick$core$next(var_args){
var G__27371 = arguments.length;
switch (G__27371) {
case 1:
return tick.core.next.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.next.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.next.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.next(tick.core.day_of_week(dow));
});

tick.core.next.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.next.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.next.cljs$lang$maxFixedArity = 2;

tick.core.next_or_same = (function tick$core$next_or_same(var_args){
var G__27374 = arguments.length;
switch (G__27374) {
case 1:
return tick.core.next_or_same.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.next_or_same.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.next_or_same.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.next_or_same(tick.core.day_of_week(dow));
});

tick.core.next_or_same.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.next_or_same.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.next_or_same.cljs$lang$maxFixedArity = 2;

tick.core.previous = (function tick$core$previous(var_args){
var G__27377 = arguments.length;
switch (G__27377) {
case 1:
return tick.core.previous.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.previous.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.previous.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.previous(tick.core.day_of_week(dow));
});

tick.core.previous.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.previous.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.previous.cljs$lang$maxFixedArity = 2;

tick.core.previous_or_same = (function tick$core$previous_or_same(var_args){
var G__27380 = arguments.length;
switch (G__27380) {
case 1:
return tick.core.previous_or_same.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.previous_or_same.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.previous_or_same.cljs$core$IFn$_invoke$arity$1 = (function (dow){
return cljc.java_time.temporal.temporal_adjusters.previous_or_same(tick.core.day_of_week(dow));
});

tick.core.previous_or_same.cljs$core$IFn$_invoke$arity$2 = (function (t,dow){
return tick.core.with$.cljs$core$IFn$_invoke$arity$2(t,tick.core.previous_or_same.cljs$core$IFn$_invoke$arity$1(dow));
});

tick.core.previous_or_same.cljs$lang$maxFixedArity = 2;


/**
 * @interface
 */
tick.core.ITimeComparison = function(){};

/**
 * Is x before y?
 */
tick.core._LT_ = (function tick$core$_LT_(x,y){
if(((!((x == null))) && (!((x.tick$core$ITimeComparison$_LT_$arity$2 == null))))){
return x.tick$core$ITimeComparison$_LT_$arity$2(x,y);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (tick.core._LT_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto__.call(null,x,y));
} else {
var m__4244__auto____$1 = (tick.core._LT_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("ITimeComparison.<",x);
}
}
}
});

/**
 * Is x before or at the same time as y?
 */
tick.core._LT__EQ_ = (function tick$core$_LT__EQ_(x,y){
if(((!((x == null))) && (!((x.tick$core$ITimeComparison$_LT__EQ_$arity$2 == null))))){
return x.tick$core$ITimeComparison$_LT__EQ_$arity$2(x,y);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (tick.core._LT__EQ_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto__.call(null,x,y));
} else {
var m__4244__auto____$1 = (tick.core._LT__EQ_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("ITimeComparison.<=",x);
}
}
}
});

/**
 * Is x after y?
 */
tick.core._GT_ = (function tick$core$_GT_(x,y){
if(((!((x == null))) && (!((x.tick$core$ITimeComparison$_GT_$arity$2 == null))))){
return x.tick$core$ITimeComparison$_GT_$arity$2(x,y);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (tick.core._GT_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto__.call(null,x,y));
} else {
var m__4244__auto____$1 = (tick.core._GT_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("ITimeComparison.>",x);
}
}
}
});

/**
 * Is x after or at the same time as y?
 */
tick.core._GT__EQ_ = (function tick$core$_GT__EQ_(x,y){
if(((!((x == null))) && (!((x.tick$core$ITimeComparison$_GT__EQ_$arity$2 == null))))){
return x.tick$core$ITimeComparison$_GT__EQ_$arity$2(x,y);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (tick.core._GT__EQ_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto__.call(null,x,y));
} else {
var m__4244__auto____$1 = (tick.core._GT__EQ_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("ITimeComparison.>=",x);
}
}
}
});

java.time.YearMonth.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.YearMonth.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.YearMonth.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.YearMonth.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.YearMonth.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.Year.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Year.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.Year.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.Year.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.Year.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.ZonedDateTime.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.ZonedDateTime.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.ZonedDateTime.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.ZonedDateTime.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.Instant.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.Instant.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.Instant.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.Instant.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

Date.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return (cljs.core.compare(x__$1,y) < (0));
});

Date.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return !((cljs.core.compare(x__$1,y) > (0)));
});

Date.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return (cljs.core.compare(x__$1,y) > (0));
});

Date.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return !((cljs.core.compare(x__$1,y) < (0)));
});

java.time.LocalDate.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.LocalDate.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.LocalDate.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.LocalDate.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.LocalTime.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.LocalTime.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.LocalTime.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.LocalTime.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.OffsetDateTime.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetDateTime.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.OffsetDateTime.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.OffsetDateTime.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.OffsetDateTime.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.LocalDateTime.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isBefore(y);
});

java.time.LocalDateTime.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isAfter(y));
});

java.time.LocalDateTime.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return x__$1.isAfter(y);
});

java.time.LocalDateTime.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.not(x__$1.isBefore(y));
});

java.time.Duration.prototype.tick$core$ITimeComparison$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$ITimeComparison$_LT_$arity$2 = (function (x,y){
var x__$1 = this;
return (x__$1.compareTo(y) < (0));
});

java.time.Duration.prototype.tick$core$ITimeComparison$_LT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
var or__3949__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x__$1,y);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return x__$1.compareTo(y);
}
});

java.time.Duration.prototype.tick$core$ITimeComparison$_GT_$arity$2 = (function (x,y){
var x__$1 = this;
return (x__$1.compareTo(y) > (0));
});

java.time.Duration.prototype.tick$core$ITimeComparison$_GT__EQ_$arity$2 = (function (x,y){
var x__$1 = this;
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x__$1,y)) || ((x__$1.compareTo(y) > (0))));
});
tick.core.unit_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$nanos,cljs.core.cst$kw$forever,cljs.core.cst$kw$months,cljs.core.cst$kw$days,cljs.core.cst$kw$half_DASH_days,cljs.core.cst$kw$micros,cljs.core.cst$kw$seconds,cljs.core.cst$kw$centuries,cljs.core.cst$kw$decades,cljs.core.cst$kw$hours,cljs.core.cst$kw$years,cljs.core.cst$kw$minutes,cljs.core.cst$kw$eras,cljs.core.cst$kw$millennia,cljs.core.cst$kw$weeks,cljs.core.cst$kw$millis],[cljc.java_time.temporal.chrono_unit.nanos,cljc.java_time.temporal.chrono_unit.forever,cljc.java_time.temporal.chrono_unit.months,cljc.java_time.temporal.chrono_unit.days,cljc.java_time.temporal.chrono_unit.half_days,cljc.java_time.temporal.chrono_unit.micros,cljc.java_time.temporal.chrono_unit.seconds,cljc.java_time.temporal.chrono_unit.centuries,cljc.java_time.temporal.chrono_unit.decades,cljc.java_time.temporal.chrono_unit.hours,cljc.java_time.temporal.chrono_unit.years,cljc.java_time.temporal.chrono_unit.minutes,cljc.java_time.temporal.chrono_unit.eras,cljc.java_time.temporal.chrono_unit.millennia,cljc.java_time.temporal.chrono_unit.weeks,cljc.java_time.temporal.chrono_unit.millis]);
tick.core.reverse_unit_map = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.reverse,tick.core.unit_map)));
tick.core.units = (function tick$core$units(x){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4324__auto__ = (function tick$core$units_$_iter__27382(s__27383){
return (new cljs.core.LazySeq(null,(function (){
var s__27383__$1 = s__27383;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__27383__$1);
if(temp__5735__auto__){
var s__27383__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27383__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__27383__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__27385 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__27384 = (0);
while(true){
if((i__27384 < size__4323__auto__)){
var tu = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__27384);
var k = (tick.core.reverse_unit_map.cljs$core$IFn$_invoke$arity$1 ? tick.core.reverse_unit_map.cljs$core$IFn$_invoke$arity$1(tu) : tick.core.reverse_unit_map.call(null,tu));
if(cljs.core.truth_(k)){
cljs.core.chunk_append(b__27385,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,x.get(tu)], null));

var G__27386 = (i__27384 + (1));
i__27384 = G__27386;
continue;
} else {
var G__27387 = (i__27384 + (1));
i__27384 = G__27387;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27385),tick$core$units_$_iter__27382(cljs.core.chunk_rest(s__27383__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27385),null);
}
} else {
var tu = cljs.core.first(s__27383__$2);
var k = (tick.core.reverse_unit_map.cljs$core$IFn$_invoke$arity$1 ? tick.core.reverse_unit_map.cljs$core$IFn$_invoke$arity$1(tu) : tick.core.reverse_unit_map.call(null,tu));
if(cljs.core.truth_(k)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,x.get(tu)], null),tick$core$units_$_iter__27382(cljs.core.rest(s__27383__$2)));
} else {
var G__27388 = cljs.core.rest(s__27383__$2);
s__27383__$1 = G__27388;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__(cljc.java_time.temporal.temporal_amount.get_units(x));
})());
});
tick.core.truncate = (function tick$core$truncate(x,u){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tick.core.unit_map,u);
if(cljs.core.truth_(temp__5735__auto__)){
var u__$1 = temp__5735__auto__;
return x.truncatedTo(u__$1);
} else {
return null;
}
});

/**
 * @interface
 */
tick.core.ITimeLength = function(){};

/**
 * Return the given quantity in nanoseconds.
 */
tick.core.nanos = (function tick$core$nanos(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$nanos$arity$1 == null))))){
return _.tick$core$ITimeLength$nanos$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.nanos[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.nanos["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.nanos",_);
}
}
}
});

/**
 * Return the given quantity in microseconds.
 */
tick.core.micros = (function tick$core$micros(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$micros$arity$1 == null))))){
return _.tick$core$ITimeLength$micros$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.micros[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.micros["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.micros",_);
}
}
}
});

/**
 * Return the given quantity in milliseconds.
 */
tick.core.millis = (function tick$core$millis(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$millis$arity$1 == null))))){
return _.tick$core$ITimeLength$millis$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.millis[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.millis["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.millis",_);
}
}
}
});

/**
 * Return the given quantity in seconds.
 */
tick.core.seconds = (function tick$core$seconds(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$seconds$arity$1 == null))))){
return _.tick$core$ITimeLength$seconds$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.seconds[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.seconds["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.seconds",_);
}
}
}
});

/**
 * Return the given quantity in minutes.
 */
tick.core.minutes = (function tick$core$minutes(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$minutes$arity$1 == null))))){
return _.tick$core$ITimeLength$minutes$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.minutes[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.minutes["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.minutes",_);
}
}
}
});

/**
 * Return the given quantity in hours.
 */
tick.core.hours = (function tick$core$hours(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$hours$arity$1 == null))))){
return _.tick$core$ITimeLength$hours$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.hours[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.hours["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.hours",_);
}
}
}
});

/**
 * Return the given quantity in days.
 */
tick.core.days = (function tick$core$days(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$days$arity$1 == null))))){
return _.tick$core$ITimeLength$days$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.days[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.days["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.days",_);
}
}
}
});

/**
 * Return the given quantity in months.
 */
tick.core.months = (function tick$core$months(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$months$arity$1 == null))))){
return _.tick$core$ITimeLength$months$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.months[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.months["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.months",_);
}
}
}
});

/**
 * Return the given quantity in years.
 */
tick.core.years = (function tick$core$years(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeLength$years$arity$1 == null))))){
return _.tick$core$ITimeLength$years$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.years[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.years["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeLength.years",_);
}
}
}
});

java.time.Duration.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$IConversion$instant$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.instant.of_epoch_milli(tick.core.millis(d__$1));
});

java.time.Duration.prototype.tick$core$IConversion$inst$arity$1 = (function (d){
var d__$1 = this;
return tick.core.inst(tick.core.instant(d__$1));
});
java.time.Duration.prototype.tick$core$ITimeLength$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$ITimeLength$nanos$arity$1 = (function (d){
var d__$1 = this;
return d__$1.toNanos();
});

java.time.Duration.prototype.tick$core$ITimeLength$micros$arity$1 = (function (d){
var d__$1 = this;
return (tick.core.nanos(d__$1) / (1000));
});

java.time.Duration.prototype.tick$core$ITimeLength$millis$arity$1 = (function (d){
var d__$1 = this;
return d__$1.toMillis();
});

java.time.Duration.prototype.tick$core$ITimeLength$seconds$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.duration.get_seconds(d__$1);
});

java.time.Duration.prototype.tick$core$ITimeLength$minutes$arity$1 = (function (d){
var d__$1 = this;
return d__$1.toMinutes();
});

java.time.Duration.prototype.tick$core$ITimeLength$hours$arity$1 = (function (d){
var d__$1 = this;
return d__$1.toHours();
});

java.time.Duration.prototype.tick$core$ITimeLength$days$arity$1 = (function (d){
var d__$1 = this;
return d__$1.toDays();
});

java.time.Period.prototype.tick$core$ITimeLength$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Period.prototype.tick$core$ITimeLength$days$arity$1 = (function (p){
var p__$1 = this;
return cljc.java_time.period.get_days(p__$1);
});

java.time.Period.prototype.tick$core$ITimeLength$months$arity$1 = (function (p){
var p__$1 = this;
return cljc.java_time.period.get_months(p__$1);
});

java.time.Period.prototype.tick$core$ITimeLength$years$arity$1 = (function (p){
var p__$1 = this;
return cljc.java_time.period.get_years(p__$1);
});
tick.core.new_duration = (function tick$core$new_duration(n,u){
var unit = (tick.core.unit_map.cljs$core$IFn$_invoke$arity$1 ? tick.core.unit_map.cljs$core$IFn$_invoke$arity$1(u) : tick.core.unit_map.call(null,u));
if(cljs.core.truth_(unit)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Not a unit: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(u)].join('')),"\n","unit"].join('')));
}

return cljc.java_time.duration.of(n,unit);
});
tick.core.new_period = (function tick$core$new_period(n,u){
var G__27389 = u;
var G__27389__$1 = (((G__27389 instanceof cljs.core.Keyword))?G__27389.fqn:null);
switch (G__27389__$1) {
case "days":
return cljc.java_time.period.of_days(n);

break;
case "weeks":
return cljc.java_time.period.of_weeks(n);

break;
case "months":
return cljc.java_time.period.of_months(n);

break;
case "years":
return cljc.java_time.period.of_years(n);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27389__$1)].join('')));

}
});
java.time.Duration.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$IExtraction$zone_offset$arity$1 = (function (d){
var d__$1 = this;
return cljc.java_time.zone_offset.of_total_seconds(tick.core.new_duration((1),cljs.core.cst$kw$seconds));
});
tick.core.current_clock = (function tick$core$current_clock(){
var or__3949__auto__ = tick.core._STAR_clock_STAR_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljc.java_time.clock.system_default_zone();
}
});

/**
 * @interface
 */
tick.core.IClock = function(){};

/**
 * Make a clock
 */
tick.core.clock = (function tick$core$clock(_){
if(((!((_ == null))) && (!((_.tick$core$IClock$clock$arity$1 == null))))){
return _.tick$core$IClock$clock$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.clock[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.clock["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("IClock.clock",_);
}
}
}
});

java.time.Instant.prototype.tick$core$IClock$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$IClock$clock$arity$1 = (function (i){
var i__$1 = this;
return cljc.java_time.clock.fixed(i__$1,tick.core.current_zone());
});

java.time.ZonedDateTime.prototype.tick$core$IClock$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$IClock$clock$arity$1 = (function (zdt){
var zdt__$1 = this;
return cljc.java_time.clock.fixed(zdt__$1.toInstant(),cljc.java_time.zoned_date_time.get_zone(zdt__$1));
});

goog.object.set(tick.core.IClock,"object",true);

var G__27391_27397 = tick.core.clock;
var G__27392_27398 = "object";
var G__27393_27399 = ((function (G__27391_27397,G__27392_27398){
return (function (o){
return tick.core.clock(tick.core.zoned_date_time(o));
});})(G__27391_27397,G__27392_27398))
;
goog.object.set(G__27391_27397,G__27392_27398,G__27393_27399);

java.time.Clock.prototype.tick$core$IClock$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Clock.prototype.tick$core$IClock$clock$arity$1 = (function (clk){
var clk__$1 = this;
return clk__$1;
});

java.time.ZoneId.prototype.tick$core$IClock$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZoneId.prototype.tick$core$IClock$clock$arity$1 = (function (z){
var z__$1 = this;
return cljc.java_time.clock.system(z__$1);
});

goog.object.set(tick.core.IClock,"string",true);

var G__27394_27400 = tick.core.clock;
var G__27395_27401 = "string";
var G__27396_27402 = ((function (G__27394_27400,G__27395_27401){
return (function (s){
return tick.core.clock(tick.core.parse(s));
});})(G__27394_27400,G__27395_27401))
;
goog.object.set(G__27394_27400,G__27395_27401,G__27396_27402);
tick.core.advance = (function tick$core$advance(var_args){
var G__27404 = arguments.length;
switch (G__27404) {
case 1:
return tick.core.advance.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.advance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.advance.cljs$core$IFn$_invoke$arity$1 = (function (clk){
return tick.core.advance.cljs$core$IFn$_invoke$arity$2(clk,tick.core.new_duration((1),cljs.core.cst$kw$seconds));
});

tick.core.advance.cljs$core$IFn$_invoke$arity$2 = (function (clk,dur){
return cljc.java_time.clock.tick(clk,dur);
});

tick.core.advance.cljs$lang$maxFixedArity = 2;

java.time.Clock.prototype.tick$core$IConversion$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Clock.prototype.tick$core$IConversion$instant$arity$1 = (function (clk){
var clk__$1 = this;
return clk__$1.instant();
});
java.time.Clock.prototype.tick$core$IExtraction$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Clock.prototype.tick$core$IExtraction$zone$arity$1 = (function (clk){
var clk__$1 = this;
return cljc.java_time.clock.get_zone(clk__$1);
});
java.time.Clock.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Clock.prototype.tick$core$ITimeReify$in$arity$2 = (function (clk,zone){
var clk__$1 = this;
return clk__$1.withZone(zone);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {tick.core.IClock}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tick.core.AtomicClock = (function (_STAR_clock,__meta,__extmap,__hash){
this._STAR_clock = _STAR_clock;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229700362;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
tick.core.AtomicClock.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

tick.core.AtomicClock.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k27407,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__27411 = k27407;
var G__27411__$1 = (((G__27411 instanceof cljs.core.Keyword))?G__27411.fqn:null);
switch (G__27411__$1) {
case "*clock":
return self__._STAR_clock;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27407,else__4206__auto__);

}
});

tick.core.AtomicClock.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#tick.core.AtomicClock{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$_STAR_clock,self__._STAR_clock],null))], null),self__.__extmap));
});

tick.core.AtomicClock.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27406){
var self__ = this;
var G__27406__$1 = this;
return (new cljs.core.RecordIter((0),G__27406__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_STAR_clock], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

tick.core.AtomicClock.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

tick.core.AtomicClock.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new tick.core.AtomicClock(self__._STAR_clock,self__.__meta,self__.__extmap,self__.__hash));
});

tick.core.AtomicClock.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
});

tick.core.AtomicClock.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__27412 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1122898333 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__27412(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

tick.core.AtomicClock.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27408,other27409){
var self__ = this;
var this27408__$1 = this;
return ((!((other27409 == null))) && ((this27408__$1.constructor === other27409.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27408__$1._STAR_clock,other27409._STAR_clock)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27408__$1.__extmap,other27409.__extmap)));
});

tick.core.AtomicClock.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_STAR_clock,null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new tick.core.AtomicClock(self__._STAR_clock,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

tick.core.AtomicClock.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__27406){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__27413 = cljs.core.keyword_identical_QMARK_;
var expr__27414 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__27416 = cljs.core.cst$kw$_STAR_clock;
var G__27417 = expr__27414;
return (pred__27413.cljs$core$IFn$_invoke$arity$2 ? pred__27413.cljs$core$IFn$_invoke$arity$2(G__27416,G__27417) : pred__27413.call(null,G__27416,G__27417));
})())){
return (new tick.core.AtomicClock(G__27406,self__.__meta,self__.__extmap,null));
} else {
return (new tick.core.AtomicClock(self__._STAR_clock,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__27406),null));
}
});

tick.core.AtomicClock.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$_STAR_clock,self__._STAR_clock,null))], null),self__.__extmap));
});

tick.core.AtomicClock.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__27406){
var self__ = this;
var this__4202__auto____$1 = this;
return (new tick.core.AtomicClock(self__._STAR_clock,G__27406,self__.__extmap,self__.__hash));
});

tick.core.AtomicClock.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

tick.core.AtomicClock.prototype.tick$core$IClock$ = cljs.core.PROTOCOL_SENTINEL;

tick.core.AtomicClock.prototype.tick$core$IClock$clock$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__._STAR_clock);
});

tick.core.AtomicClock.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return tick.core.instant(cljs.core.deref(self__._STAR_clock));
});

tick.core.AtomicClock.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_STAR_clock], null);
});

tick.core.AtomicClock.cljs$lang$type = true;

tick.core.AtomicClock.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"tick.core/AtomicClock",null,(1),null));
});

tick.core.AtomicClock.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"tick.core/AtomicClock");
});

/**
 * Positional factory function for tick.core/AtomicClock.
 */
tick.core.__GT_AtomicClock = (function tick$core$__GT_AtomicClock(_STAR_clock){
return (new tick.core.AtomicClock(_STAR_clock,null,null,null));
});

/**
 * Factory function for tick.core/AtomicClock, taking a map of keywords to field values.
 */
tick.core.map__GT_AtomicClock = (function tick$core$map__GT_AtomicClock(G__27410){
var extmap__4236__auto__ = (function (){var G__27418 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__27410,cljs.core.cst$kw$_STAR_clock);
if(cljs.core.record_QMARK_(G__27410)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27418);
} else {
return G__27418;
}
})();
return (new tick.core.AtomicClock(cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(G__27410),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

tick.core.atom = (function tick$core$atom(var_args){
var G__27421 = arguments.length;
switch (G__27421) {
case 1:
return tick.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return tick.core.atom.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (clk){
return tick.core.__GT_AtomicClock(cljs.core.atom.cljs$core$IFn$_invoke$arity$1(clk));
});

tick.core.atom.cljs$core$IFn$_invoke$arity$0 = (function (){
return tick.core.atom.cljs$core$IFn$_invoke$arity$1(tick.core.current_clock());
});

tick.core.atom.cljs$lang$maxFixedArity = 1;

tick.core.swap_BANG_ = (function tick$core$swap_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27426 = arguments.length;
var i__4532__auto___27427 = (0);
while(true){
if((i__4532__auto___27427 < len__4531__auto___27426)){
args__4534__auto__.push((arguments[i__4532__auto___27427]));

var G__27428 = (i__4532__auto___27427 + (1));
i__4532__auto___27427 = G__27428;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return tick.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

tick.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (at,f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(at),f,args);
});

tick.core.swap_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
tick.core.swap_BANG_.cljs$lang$applyTo = (function (seq27423){
var G__27424 = cljs.core.first(seq27423);
var seq27423__$1 = cljs.core.next(seq27423);
var G__27425 = cljs.core.first(seq27423__$1);
var seq27423__$2 = cljs.core.next(seq27423__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27424,G__27425,seq27423__$2);
});

tick.core.swap_vals_BANG_ = (function tick$core$swap_vals_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27432 = arguments.length;
var i__4532__auto___27433 = (0);
while(true){
if((i__4532__auto___27433 < len__4531__auto___27432)){
args__4534__auto__.push((arguments[i__4532__auto___27433]));

var G__27434 = (i__4532__auto___27433 + (1));
i__4532__auto___27433 = G__27434;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return tick.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

tick.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (at,f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_vals_BANG_,cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(at),f,args);
});

tick.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
tick.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq27429){
var G__27430 = cljs.core.first(seq27429);
var seq27429__$1 = cljs.core.next(seq27429);
var G__27431 = cljs.core.first(seq27429__$1);
var seq27429__$2 = cljs.core.next(seq27429__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27430,G__27431,seq27429__$2);
});

tick.core.compare_and_set_BANG_ = (function tick$core$compare_and_set_BANG_(at,oldval,newval){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.compare_and_set_BANG_,cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(at),oldval,newval);
});
tick.core.reset_BANG_ = (function tick$core$reset_BANG_(at,newval){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.reset_BANG_,cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(at),newval);
});
tick.core.reset_vals_BANG_ = (function tick$core$reset_vals_BANG_(at,newval){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.reset_vals_BANG_,cljs.core.cst$kw$_STAR_clock.cljs$core$IFn$_invoke$arity$1(at),newval);
});

/**
 * @interface
 */
tick.core.ITimeArithmetic = function(){};

/**
 * Add to time
 */
tick.core._PLUS_ = (function tick$core$_PLUS_(t,d){
if(((!((t == null))) && (!((t.tick$core$ITimeArithmetic$_PLUS_$arity$2 == null))))){
return t.tick$core$ITimeArithmetic$_PLUS_$arity$2(t,d);
} else {
var x__4243__auto__ = (((t == null))?null:t);
var m__4244__auto__ = (tick.core._PLUS_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(t,d) : m__4244__auto__.call(null,t,d));
} else {
var m__4244__auto____$1 = (tick.core._PLUS_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(t,d) : m__4244__auto____$1.call(null,t,d));
} else {
throw cljs.core.missing_protocol("ITimeArithmetic.+",t);
}
}
}
});

/**
 * Subtract from time, or negate
 */
tick.core._ = (function tick$core$_(t,d){
if(((!((t == null))) && (!((t.tick$core$ITimeArithmetic$_$arity$2 == null))))){
return t.tick$core$ITimeArithmetic$_$arity$2(t,d);
} else {
var x__4243__auto__ = (((t == null))?null:t);
var m__4244__auto__ = (tick.core._[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(t,d) : m__4244__auto__.call(null,t,d));
} else {
var m__4244__auto____$1 = (tick.core._["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(t,d) : m__4244__auto____$1.call(null,t,d));
} else {
throw cljs.core.missing_protocol("ITimeArithmetic.-",t);
}
}
}
});

tick.core.minus_ = (function tick$core$minus_(var_args){
var G__27436 = arguments.length;
switch (G__27436) {
case 1:
return tick.core.minus_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.minus_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.minus_.cljs$core$IFn$_invoke$arity$1 = (function (d){
return d.negated();
});

tick.core.minus_.cljs$core$IFn$_invoke$arity$2 = (function (t,d){
return t.minus(d);
});

tick.core.minus_.cljs$lang$maxFixedArity = 2;

goog.object.set(tick.core.ITimeArithmetic,"object",true);

var G__27438_27444 = tick.core._PLUS_;
var G__27439_27445 = "object";
var G__27440_27446 = ((function (G__27438_27444,G__27439_27445){
return (function (t,d){
return t.plus(d);
});})(G__27438_27444,G__27439_27445))
;
goog.object.set(G__27438_27444,G__27439_27445,G__27440_27446);

var G__27441_27447 = tick.core._;
var G__27442_27448 = "object";
var G__27443_27449 = ((function (G__27441_27447,G__27442_27448){
return (function (t,d){
return t.minus(d);
});})(G__27441_27447,G__27442_27448))
;
goog.object.set(G__27441_27447,G__27442_27448,G__27443_27449);
/**
 * Return the duration as a negative duration
 */
tick.core.negated = (function tick$core$negated(d){
return d.negated();
});

/**
 * @interface
 */
tick.core.ITimeShift = function(){};

/**
 * Increment time
 */
tick.core.forward_number = (function tick$core$forward_number(_,n){
if(((!((_ == null))) && (!((_.tick$core$ITimeShift$forward_number$arity$2 == null))))){
return _.tick$core$ITimeShift$forward_number$arity$2(_,n);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.forward_number[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(_,n) : m__4244__auto__.call(null,_,n));
} else {
var m__4244__auto____$1 = (tick.core.forward_number["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(_,n) : m__4244__auto____$1.call(null,_,n));
} else {
throw cljs.core.missing_protocol("ITimeShift.forward-number",_);
}
}
}
});

/**
 * Increment time
 */
tick.core.forward_duration = (function tick$core$forward_duration(_,d){
if(((!((_ == null))) && (!((_.tick$core$ITimeShift$forward_duration$arity$2 == null))))){
return _.tick$core$ITimeShift$forward_duration$arity$2(_,d);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.forward_duration[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(_,d) : m__4244__auto__.call(null,_,d));
} else {
var m__4244__auto____$1 = (tick.core.forward_duration["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(_,d) : m__4244__auto____$1.call(null,_,d));
} else {
throw cljs.core.missing_protocol("ITimeShift.forward-duration",_);
}
}
}
});

/**
 * Decrement time
 */
tick.core.backward_number = (function tick$core$backward_number(_,n){
if(((!((_ == null))) && (!((_.tick$core$ITimeShift$backward_number$arity$2 == null))))){
return _.tick$core$ITimeShift$backward_number$arity$2(_,n);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.backward_number[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(_,n) : m__4244__auto__.call(null,_,n));
} else {
var m__4244__auto____$1 = (tick.core.backward_number["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(_,n) : m__4244__auto____$1.call(null,_,n));
} else {
throw cljs.core.missing_protocol("ITimeShift.backward-number",_);
}
}
}
});

/**
 * Decrement time
 */
tick.core.backward_duration = (function tick$core$backward_duration(_,d){
if(((!((_ == null))) && (!((_.tick$core$ITimeShift$backward_duration$arity$2 == null))))){
return _.tick$core$ITimeShift$backward_duration$arity$2(_,d);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.backward_duration[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(_,d) : m__4244__auto__.call(null,_,d));
} else {
var m__4244__auto____$1 = (tick.core.backward_duration["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(_,d) : m__4244__auto____$1.call(null,_,d));
} else {
throw cljs.core.missing_protocol("ITimeShift.backward-duration",_);
}
}
}
});

java.time.YearMonth.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.YearMonth.prototype.tick$core$ITimeShift$forward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.plusMonths(n);
});

java.time.YearMonth.prototype.tick$core$ITimeShift$backward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.minusMonths(n);
});

java.time.YearMonth.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.YearMonth.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.Year.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Year.prototype.tick$core$ITimeShift$forward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.plusYears(n);
});

java.time.Year.prototype.tick$core$ITimeShift$backward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.minusYears(n);
});

java.time.ZonedDateTime.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.ZonedDateTime.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.Instant.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.Instant.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

Date.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return tick.core.instant(t__$1).plus(d);
});

Date.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return tick.core.instant(t__$1).minus(d);
});

java.time.LocalDate.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$ITimeShift$forward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.plusDays(n);
});

java.time.LocalDate.prototype.tick$core$ITimeShift$backward_number$arity$2 = (function (t,n){
var t__$1 = this;
return t__$1.minusDays(n);
});

java.time.LocalDate.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.LocalDate.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.LocalTime.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.LocalTime.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.OffsetDateTime.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetDateTime.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.OffsetDateTime.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.LocalDateTime.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.plus(d);
});

java.time.LocalDateTime.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (t,d){
var t__$1 = this;
return t__$1.minus(d);
});

java.time.Clock.prototype.tick$core$ITimeShift$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Clock.prototype.tick$core$ITimeShift$forward_duration$arity$2 = (function (clk,d){
var clk__$1 = this;
return cljc.java_time.clock.offset(clk__$1,d);
});

java.time.Clock.prototype.tick$core$ITimeShift$backward_duration$arity$2 = (function (clk,d){
var clk__$1 = this;
return cljc.java_time.clock.offset(clk__$1,tick.core.negated(d));
});
tick.core._GT__GT_ = (function tick$core$_GT__GT_(t,n_or_d){
if(typeof n_or_d === 'number'){
return tick.core.forward_number(t,n_or_d);
} else {
return tick.core.forward_duration(t,n_or_d);
}
});
tick.core._LT__LT_ = (function tick$core$_LT__LT_(t,n_or_d){
if(typeof n_or_d === 'number'){
return tick.core.backward_number(t,n_or_d);
} else {
return tick.core.backward_duration(t,n_or_d);
}
});

/**
 * @interface
 */
tick.core.ITimeRangeable = function(){};

/**
 * Returns a lazy seq of times from start (inclusive) to end (exclusive, nil means forever), by step, where start defaults to 0, step to 1, and end to infinity.
 */
tick.core.range = (function tick$core$range(var_args){
var G__27451 = arguments.length;
switch (G__27451) {
case 1:
return tick.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tick.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tick.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tick.core.range.cljs$core$IFn$_invoke$arity$1 = (function (from){
if(((!((from == null))) && (!((from.tick$core$ITimeRangeable$range$arity$1 == null))))){
return from.tick$core$ITimeRangeable$range$arity$1(from);
} else {
var x__4243__auto__ = (((from == null))?null:from);
var m__4244__auto__ = (tick.core.range[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(from) : m__4244__auto__.call(null,from));
} else {
var m__4244__auto____$1 = (tick.core.range["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(from) : m__4244__auto____$1.call(null,from));
} else {
throw cljs.core.missing_protocol("ITimeRangeable.range",from);
}
}
}
});

tick.core.range.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
if(((!((from == null))) && (!((from.tick$core$ITimeRangeable$range$arity$2 == null))))){
return from.tick$core$ITimeRangeable$range$arity$2(from,to);
} else {
var x__4243__auto__ = (((from == null))?null:from);
var m__4244__auto__ = (tick.core.range[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(from,to) : m__4244__auto__.call(null,from,to));
} else {
var m__4244__auto____$1 = (tick.core.range["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(from,to) : m__4244__auto____$1.call(null,from,to));
} else {
throw cljs.core.missing_protocol("ITimeRangeable.range",from);
}
}
}
});

tick.core.range.cljs$core$IFn$_invoke$arity$3 = (function (from,to,step){
if(((!((from == null))) && (!((from.tick$core$ITimeRangeable$range$arity$3 == null))))){
return from.tick$core$ITimeRangeable$range$arity$3(from,to,step);
} else {
var x__4243__auto__ = (((from == null))?null:from);
var m__4244__auto__ = (tick.core.range[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(from,to,step) : m__4244__auto__.call(null,from,to,step));
} else {
var m__4244__auto____$1 = (tick.core.range["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(from,to,step) : m__4244__auto____$1.call(null,from,to,step));
} else {
throw cljs.core.missing_protocol("ITimeRangeable.range",from);
}
}
}
});

tick.core.range.cljs$lang$maxFixedArity = 3;


tick.core.greater = (function tick$core$greater(x,y){
if((cljs.core.compare(x,y) < (0))){
return y;
} else {
return x;
}
});
tick.core.max = (function tick$core$max(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27457 = arguments.length;
var i__4532__auto___27458 = (0);
while(true){
if((i__4532__auto___27458 < len__4531__auto___27457)){
args__4534__auto__.push((arguments[i__4532__auto___27458]));

var G__27459 = (i__4532__auto___27458 + (1));
i__4532__auto___27458 = G__27459;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return tick.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

tick.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (arg,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__27453_SHARP_,p2__27454_SHARP_){
return tick.core.greater(p1__27453_SHARP_,p2__27454_SHARP_);
}),arg,args);
});

tick.core.max.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
tick.core.max.cljs$lang$applyTo = (function (seq27455){
var G__27456 = cljs.core.first(seq27455);
var seq27455__$1 = cljs.core.next(seq27455);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27456,seq27455__$1);
});

tick.core.lesser = (function tick$core$lesser(x,y){
if((cljs.core.compare(x,y) < (0))){
return x;
} else {
return y;
}
});
tick.core.min = (function tick$core$min(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27464 = arguments.length;
var i__4532__auto___27465 = (0);
while(true){
if((i__4532__auto___27465 < len__4531__auto___27464)){
args__4534__auto__.push((arguments[i__4532__auto___27465]));

var G__27466 = (i__4532__auto___27465 + (1));
i__4532__auto___27465 = G__27466;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return tick.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

tick.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (arg,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__27460_SHARP_,p2__27461_SHARP_){
return tick.core.lesser(p1__27460_SHARP_,p2__27461_SHARP_);
}),arg,args);
});

tick.core.min.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
tick.core.min.cljs$lang$applyTo = (function (seq27462){
var G__27463 = cljs.core.first(seq27462);
var seq27462__$1 = cljs.core.next(seq27462);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27463,seq27462__$1);
});

java.time.Instant.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27467_SHARP_){
return p1__27467_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
});

java.time.Instant.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27472 = cljs.core.iterate(((function (from__$1){
return (function (p1__27468_SHARP_){
return p1__27468_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27472,from__$1){
return (function (p1__27469_SHARP_){
return tick.core._LT_(p1__27469_SHARP_,to);
});})(G__27472,from__$1))
,G__27472);
} else {
return G__27472;
}
});

java.time.Instant.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27473 = cljs.core.iterate(((function (from__$1){
return (function (p1__27470_SHARP_){
return p1__27470_SHARP_.plus(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27473,from__$1){
return (function (p1__27471_SHARP_){
return tick.core._LT_(p1__27471_SHARP_,to);
});})(G__27473,from__$1))
,G__27473);
} else {
return G__27473;
}
});
java.time.ZonedDateTime.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27474_SHARP_){
return p1__27474_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
});

java.time.ZonedDateTime.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27479 = cljs.core.iterate(((function (from__$1){
return (function (p1__27475_SHARP_){
return p1__27475_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27479,from__$1){
return (function (p1__27476_SHARP_){
return tick.core._LT_(p1__27476_SHARP_,to);
});})(G__27479,from__$1))
,G__27479);
} else {
return G__27479;
}
});

java.time.ZonedDateTime.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27480 = cljs.core.iterate(((function (from__$1){
return (function (p1__27477_SHARP_){
return p1__27477_SHARP_.plus(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27480,from__$1){
return (function (p1__27478_SHARP_){
return tick.core._LT_(p1__27478_SHARP_,to);
});})(G__27480,from__$1))
,G__27480);
} else {
return G__27480;
}
});
java.time.LocalDate.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27481_SHARP_){
return p1__27481_SHARP_.plusDays((1));
});})(from__$1))
,from__$1);
});

java.time.LocalDate.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27486 = cljs.core.iterate(((function (from__$1){
return (function (p1__27482_SHARP_){
return p1__27482_SHARP_.plusDays((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27486,from__$1){
return (function (p1__27483_SHARP_){
return tick.core._LT_(p1__27483_SHARP_,to);
});})(G__27486,from__$1))
,G__27486);
} else {
return G__27486;
}
});

java.time.LocalDate.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27487 = cljs.core.iterate(((function (from__$1){
return (function (p1__27484_SHARP_){
return p1__27484_SHARP_.plusDays(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27487,from__$1){
return (function (p1__27485_SHARP_){
return tick.core._LT_(p1__27485_SHARP_,to);
});})(G__27487,from__$1))
,G__27487);
} else {
return G__27487;
}
});
tick.core.inc = (function tick$core$inc(t){
return tick.core.forward_number(t,(1));
});
tick.core.dec = (function tick$core$dec(t){
return tick.core.backward_number(t,(1));
});
tick.core.tomorrow = (function tick$core$tomorrow(){
return tick.core.forward_number(tick.core.today(),(1));
});
tick.core.yesterday = (function tick$core$yesterday(){
return tick.core.backward_number(tick.core.today(),(1));
});
java.time.LocalDateTime.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27488_SHARP_){
return p1__27488_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
});

java.time.LocalDateTime.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27493 = cljs.core.iterate(((function (from__$1){
return (function (p1__27489_SHARP_){
return p1__27489_SHARP_.plusSeconds((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27493,from__$1){
return (function (p1__27490_SHARP_){
return tick.core._LT_(p1__27490_SHARP_,to);
});})(G__27493,from__$1))
,G__27493);
} else {
return G__27493;
}
});

java.time.LocalDateTime.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27494 = cljs.core.iterate(((function (from__$1){
return (function (p1__27491_SHARP_){
return p1__27491_SHARP_.plus(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27494,from__$1){
return (function (p1__27492_SHARP_){
return tick.core._LT_(p1__27492_SHARP_,to);
});})(G__27494,from__$1))
,G__27494);
} else {
return G__27494;
}
});
java.time.YearMonth.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.YearMonth.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27495_SHARP_){
return p1__27495_SHARP_.plusMonths((1));
});})(from__$1))
,from__$1);
});

java.time.YearMonth.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27500 = cljs.core.iterate(((function (from__$1){
return (function (p1__27496_SHARP_){
return p1__27496_SHARP_.plusMonths((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27500,from__$1){
return (function (p1__27497_SHARP_){
return tick.core._LT_(p1__27497_SHARP_,to);
});})(G__27500,from__$1))
,G__27500);
} else {
return G__27500;
}
});

java.time.YearMonth.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27501 = cljs.core.iterate(((function (from__$1){
return (function (p1__27498_SHARP_){
return p1__27498_SHARP_.plus(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27501,from__$1){
return (function (p1__27499_SHARP_){
return tick.core._LT_(p1__27499_SHARP_,to);
});})(G__27501,from__$1))
,G__27501);
} else {
return G__27501;
}
});
java.time.Year.prototype.tick$core$ITimeRangeable$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Year.prototype.tick$core$ITimeRangeable$range$arity$1 = (function (from){
var from__$1 = this;
return cljs.core.iterate(((function (from__$1){
return (function (p1__27502_SHARP_){
return p1__27502_SHARP_.plusYears((1));
});})(from__$1))
,from__$1);
});

java.time.Year.prototype.tick$core$ITimeRangeable$range$arity$2 = (function (from,to){
var from__$1 = this;
var G__27507 = cljs.core.iterate(((function (from__$1){
return (function (p1__27503_SHARP_){
return p1__27503_SHARP_.plusYears((1));
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27507,from__$1){
return (function (p1__27504_SHARP_){
return tick.core._LT_(p1__27504_SHARP_,to);
});})(G__27507,from__$1))
,G__27507);
} else {
return G__27507;
}
});

java.time.Year.prototype.tick$core$ITimeRangeable$range$arity$3 = (function (from,to,step){
var from__$1 = this;
var G__27508 = cljs.core.iterate(((function (from__$1){
return (function (p1__27505_SHARP_){
return p1__27505_SHARP_.plus(step);
});})(from__$1))
,from__$1);
if(cljs.core.truth_(to)){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (G__27508,from__$1){
return (function (p1__27506_SHARP_){
return tick.core._LT_(p1__27506_SHARP_,to);
});})(G__27508,from__$1))
,G__27508);
} else {
return G__27508;
}
});

/**
 * @interface
 */
tick.core.IDivisible = function(){};

/**
 * Divide time
 */
tick.core.divide = (function tick$core$divide(t,divisor){
if(((!((t == null))) && (!((t.tick$core$IDivisible$divide$arity$2 == null))))){
return t.tick$core$IDivisible$divide$arity$2(t,divisor);
} else {
var x__4243__auto__ = (((t == null))?null:t);
var m__4244__auto__ = (tick.core.divide[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(t,divisor) : m__4244__auto__.call(null,t,divisor));
} else {
var m__4244__auto____$1 = (tick.core.divide["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(t,divisor) : m__4244__auto____$1.call(null,t,divisor));
} else {
throw cljs.core.missing_protocol("IDivisible.divide",t);
}
}
}
});

goog.object.set(tick.core.IDivisible,"string",true);

var G__27509_27512 = tick.core.divide;
var G__27510_27513 = "string";
var G__27511_27514 = ((function (G__27509_27512,G__27510_27513){
return (function (s,d){
return tick.core.divide(tick.core.parse(s),d);
});})(G__27509_27512,G__27510_27513))
;
goog.object.set(G__27509_27512,G__27510_27513,G__27511_27514);

/**
 * @interface
 */
tick.core.IDivisibleDuration = function(){};

/**
 * Divide a duration
 */
tick.core.divide_duration = (function tick$core$divide_duration(divisor,duration){
if(((!((divisor == null))) && (!((divisor.tick$core$IDivisibleDuration$divide_duration$arity$2 == null))))){
return divisor.tick$core$IDivisibleDuration$divide_duration$arity$2(divisor,duration);
} else {
var x__4243__auto__ = (((divisor == null))?null:divisor);
var m__4244__auto__ = (tick.core.divide_duration[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(divisor,duration) : m__4244__auto__.call(null,divisor,duration));
} else {
var m__4244__auto____$1 = (tick.core.divide_duration["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(divisor,duration) : m__4244__auto____$1.call(null,divisor,duration));
} else {
throw cljs.core.missing_protocol("IDivisibleDuration.divide-duration",divisor);
}
}
}
});

goog.object.set(tick.core.IDivisibleDuration,"number",true);

var G__27515_27518 = tick.core.divide_duration;
var G__27516_27519 = "number";
var G__27517_27520 = ((function (G__27515_27518,G__27516_27519){
return (function (n,duration){
return duration.dividedBy(n);
});})(G__27515_27518,G__27516_27519))
;
goog.object.set(G__27515_27518,G__27516_27519,G__27517_27520);

java.time.Duration.prototype.tick$core$IDivisibleDuration$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$IDivisibleDuration$divide_duration$arity$2 = (function (divisor,duration){
var divisor__$1 = this;
return (cljc.java_time.duration.get_seconds(duration) / cljc.java_time.duration.get_seconds(divisor__$1));
});
java.time.Duration.prototype.tick$core$IDivisible$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Duration.prototype.tick$core$IDivisible$divide$arity$2 = (function (d,x){
var d__$1 = this;
return tick.core.divide_duration(x,d__$1);
});

/**
 * @interface
 */
tick.core.ITimeSpan = function(){};

/**
 * Return the beginning of a span of time
 */
tick.core.beginning = (function tick$core$beginning(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeSpan$beginning$arity$1 == null))))){
return _.tick$core$ITimeSpan$beginning$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.beginning[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.beginning["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeSpan.beginning",_);
}
}
}
});

/**
 * Return the end of a span of time
 */
tick.core.end = (function tick$core$end(_){
if(((!((_ == null))) && (!((_.tick$core$ITimeSpan$end$arity$1 == null))))){
return _.tick$core$ITimeSpan$end$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.end[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.end["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("ITimeSpan.end",_);
}
}
}
});

tick.core.duration = (function tick$core$duration(x){
return cljc.java_time.duration.between(tick.core.beginning(x),tick.core.end(x));
});
tick.core.beginning_composite = (function tick$core$beginning_composite(m){
var map__27521 = m;
var map__27521__$1 = ((((!((map__27521 == null)))?(((((map__27521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27521):map__27521);
var beginning = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27521__$1,cljs.core.cst$kw$tick_SLASH_beginning);
var intervals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27521__$1,cljs.core.cst$kw$tick_SLASH_intervals);
if(cljs.core.truth_(intervals)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(tick.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tick_SLASH_beginning,intervals));
} else {
return beginning;
}
});
tick.core.end_composite = (function tick$core$end_composite(m){
var map__27523 = m;
var map__27523__$1 = ((((!((map__27523 == null)))?(((((map__27523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27523):map__27523);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27523__$1,cljs.core.cst$kw$tick_SLASH_end);
var intervals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27523__$1,cljs.core.cst$kw$tick_SLASH_intervals);
if(cljs.core.truth_(intervals)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(tick.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tick_SLASH_end,intervals));
} else {
return end;
}
});
cljs.core.PersistentArrayMap.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (m){
var m__$1 = this;
return tick.core.beginning_composite(m__$1);
});

cljs.core.PersistentArrayMap.prototype.tick$core$ITimeSpan$end$arity$1 = (function (m){
var m__$1 = this;
return tick.core.end_composite(m__$1);
});
cljs.core.PersistentHashMap.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (m){
var m__$1 = this;
return tick.core.beginning_composite(m__$1);
});

cljs.core.PersistentHashMap.prototype.tick$core$ITimeSpan$end$arity$1 = (function (m){
var m__$1 = this;
return tick.core.end_composite(m__$1);
});

/**
 * @interface
 */
tick.core.IBetween = function(){};

/**
 * Return the duration (or period) between two times
 */
tick.core.between = (function tick$core$between(v1,v2){
if(((!((v1 == null))) && (!((v1.tick$core$IBetween$between$arity$2 == null))))){
return v1.tick$core$IBetween$between$arity$2(v1,v2);
} else {
var x__4243__auto__ = (((v1 == null))?null:v1);
var m__4244__auto__ = (tick.core.between[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(v1,v2) : m__4244__auto__.call(null,v1,v2));
} else {
var m__4244__auto____$1 = (tick.core.between["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(v1,v2) : m__4244__auto____$1.call(null,v1,v2));
} else {
throw cljs.core.missing_protocol("IBetween.between",v1);
}
}
}
});

java.time.LocalDate.prototype.tick$core$IBetween$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$IBetween$between$arity$2 = (function (v1,v2){
var v1__$1 = this;
return cljc.java_time.period.between(v1__$1,tick.core.date(v2));
});

java.time.LocalDateTime.prototype.tick$core$IBetween$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$IBetween$between$arity$2 = (function (v1,v2){
var v1__$1 = this;
return cljc.java_time.duration.between(v1__$1,tick.core.date_time(v2));
});

java.time.Instant.prototype.tick$core$IBetween$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$IBetween$between$arity$2 = (function (v1,v2){
var v1__$1 = this;
return cljc.java_time.duration.between(v1__$1,tick.core.instant(v2));
});

goog.object.set(tick.core.IBetween,"string",true);

var G__27525_27528 = tick.core.between;
var G__27526_27529 = "string";
var G__27527_27530 = ((function (G__27525_27528,G__27526_27529){
return (function (v1,v2){
return tick.core.between(tick.core.parse(v1),tick.core.parse(v2));
});})(G__27525_27528,G__27526_27529))
;
goog.object.set(G__27525_27528,G__27526_27529,G__27527_27530);

Date.prototype.tick$core$IBetween$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$IBetween$between$arity$2 = (function (x,y){
var x__$1 = this;
return tick.core.between(tick.core.instant(x__$1),tick.core.instant(y));
});
/**
 * Does the span of time contain the given event? If the given event
 *   is itself a span, then t must wholly contain the beginning and end
 *   of the event.
 */
tick.core.coincident_QMARK_ = (function tick$core$coincident_QMARK_(t,event){
return ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.compare(tick.core.beginning(t),tick.core.beginning(event)))) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.compare(tick.core.end(event),tick.core.end(t)))));
});
goog.object.set(tick.core.ITimeSpan,"null",true);

var G__27531_27549 = tick.core.beginning;
var G__27532_27550 = "null";
var G__27533_27551 = ((function (G__27531_27549,G__27532_27550){
return (function (_){
return null;
});})(G__27531_27549,G__27532_27550))
;
goog.object.set(G__27531_27549,G__27532_27550,G__27533_27551);

var G__27534_27552 = tick.core.end;
var G__27535_27553 = "null";
var G__27536_27554 = ((function (G__27534_27552,G__27535_27553){
return (function (_){
return null;
});})(G__27534_27552,G__27535_27553))
;
goog.object.set(G__27534_27552,G__27535_27553,G__27536_27554);

java.time.YearMonth.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.YearMonth.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (ym){
var ym__$1 = this;
return tick.core.beginning(ym__$1.atDay((1)));
});

java.time.YearMonth.prototype.tick$core$ITimeSpan$end$arity$1 = (function (ym){
var ym__$1 = this;
return tick.core.end(ym__$1.atEndOfMonth());
});

java.time.Year.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Year.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (year){
var year__$1 = this;
return tick.core.beginning(year__$1.atMonth((1)));
});

java.time.Year.prototype.tick$core$ITimeSpan$end$arity$1 = (function (year){
var year__$1 = this;
return tick.core.end(year__$1.atMonth((12)));
});

java.time.ZonedDateTime.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.ZonedDateTime.prototype.tick$core$ITimeSpan$end$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.Instant.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.Instant.prototype.tick$core$ITimeSpan$end$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

Date.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (i){
var i__$1 = this;
return tick.core.instant(i__$1);
});

Date.prototype.tick$core$ITimeSpan$end$arity$1 = (function (i){
var i__$1 = this;
return tick.core.instant(i__$1);
});

java.time.LocalDate.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (date){
var date__$1 = this;
return date__$1.atStartOfDay();
});

java.time.LocalDate.prototype.tick$core$ITimeSpan$end$arity$1 = (function (date){
var date__$1 = this;
return tick.core.inc(date__$1).atStartOfDay();
});

goog.object.set(tick.core.ITimeSpan,"number",true);

var G__27537_27555 = tick.core.beginning;
var G__27538_27556 = "number";
var G__27539_27557 = ((function (G__27537_27555,G__27538_27556){
return (function (n){
return tick.core.beginning(tick.core.time(n));
});})(G__27537_27555,G__27538_27556))
;
goog.object.set(G__27537_27555,G__27538_27556,G__27539_27557);

var G__27540_27558 = tick.core.end;
var G__27541_27559 = "number";
var G__27542_27560 = ((function (G__27540_27558,G__27541_27559){
return (function (n){
return tick.core.end(tick.core.time(n));
});})(G__27540_27558,G__27541_27559))
;
goog.object.set(G__27540_27558,G__27541_27559,G__27542_27560);

goog.object.set(tick.core.ITimeSpan,"string",true);

var G__27543_27561 = tick.core.beginning;
var G__27544_27562 = "string";
var G__27545_27563 = ((function (G__27543_27561,G__27544_27562){
return (function (s){
return tick.core.beginning(tick.core.parse(s));
});})(G__27543_27561,G__27544_27562))
;
goog.object.set(G__27543_27561,G__27544_27562,G__27545_27563);

var G__27546_27564 = tick.core.end;
var G__27547_27565 = "string";
var G__27548_27566 = ((function (G__27546_27564,G__27547_27565){
return (function (s){
return tick.core.end(tick.core.parse(s));
});})(G__27546_27564,G__27547_27565))
;
goog.object.set(G__27546_27564,G__27547_27565,G__27548_27566);

java.time.LocalTime.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (x){
var x__$1 = this;
return x__$1;
});

java.time.LocalTime.prototype.tick$core$ITimeSpan$end$arity$1 = (function (x){
var x__$1 = this;
return x__$1;
});

java.time.OffsetDateTime.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetDateTime.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.OffsetDateTime.prototype.tick$core$ITimeSpan$end$arity$1 = (function (i){
var i__$1 = this;
return i__$1;
});

java.time.LocalDateTime.prototype.tick$core$ITimeSpan$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ITimeSpan$beginning$arity$1 = (function (x){
var x__$1 = this;
return x__$1;
});

java.time.LocalDateTime.prototype.tick$core$ITimeSpan$end$arity$1 = (function (x){
var x__$1 = this;
return x__$1;
});
java.time.LocalTime.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$ITimeReify$on$arity$2 = (function (t,date){
var t__$1 = this;
return date.atTime(t__$1);
});

java.time.OffsetTime.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.OffsetTime.prototype.tick$core$ITimeReify$on$arity$2 = (function (t,date){
var t__$1 = this;
return date.atTime(t__$1);
});

java.time.LocalDate.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDate.prototype.tick$core$ITimeReify$at$arity$2 = (function (date,t){
var date__$1 = this;
return date__$1.atTime(tick.core.time(t));
});

java.time.LocalDateTime.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ITimeReify$in$arity$2 = (function (ldt,z){
var ldt__$1 = this;
return ldt__$1.atZone(z);
});

java.time.LocalDateTime.prototype.tick$core$ITimeReify$offset_by$arity$2 = (function (ldt,offset){
var ldt__$1 = this;
return ldt__$1.atZone(tick.core.zone_offset(offset));
});

java.time.Instant.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ITimeReify$in$arity$2 = (function (t,z){
var t__$1 = this;
return cljc.java_time.zoned_date_time.of_instant.cljs$core$IFn$_invoke$arity$2(t__$1,z);
});

java.time.Instant.prototype.tick$core$ITimeReify$offset_by$arity$2 = (function (t,offset){
var t__$1 = this;
return cljc.java_time.zoned_date_time.of_instant.cljs$core$IFn$_invoke$arity$2(t__$1,tick.core.zone_offset(offset));
});

java.time.ZonedDateTime.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

java.time.ZonedDateTime.prototype.tick$core$ITimeReify$in$arity$2 = (function (t,z){
var t__$1 = this;
return t__$1.withZoneSameInstant(tick.core.zone(z));
});

Date.prototype.tick$core$ITimeReify$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$ITimeReify$in$arity$2 = (function (t,z){
var t__$1 = this;
return tick.core.in$(tick.core.instant(t__$1),tick.core.zone(z));
});

/**
 * @interface
 */
tick.core.ILocalTime = function(){};

/**
 * Is the time a java.time.LocalTime or java.time.LocalDateTime?
 */
tick.core.local_QMARK_ = (function tick$core$local_QMARK_(t){
if(((!((t == null))) && (!((t.tick$core$ILocalTime$local_QMARK_$arity$1 == null))))){
return t.tick$core$ILocalTime$local_QMARK_$arity$1(t);
} else {
var x__4243__auto__ = (((t == null))?null:t);
var m__4244__auto__ = (tick.core.local_QMARK_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(t) : m__4244__auto__.call(null,t));
} else {
var m__4244__auto____$1 = (tick.core.local_QMARK_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(t) : m__4244__auto____$1.call(null,t));
} else {
throw cljs.core.missing_protocol("ILocalTime.local?",t);
}
}
}
});

Date.prototype.tick$core$ILocalTime$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.tick$core$ILocalTime$local_QMARK_$arity$1 = (function (d){
var d__$1 = this;
return false;
});

java.time.Instant.prototype.tick$core$ILocalTime$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$ILocalTime$local_QMARK_$arity$1 = (function (i){
var i__$1 = this;
return false;
});

java.time.LocalDateTime.prototype.tick$core$ILocalTime$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$ILocalTime$local_QMARK_$arity$1 = (function (i){
var i__$1 = this;
return true;
});

java.time.LocalTime.prototype.tick$core$ILocalTime$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$ILocalTime$local_QMARK_$arity$1 = (function (i){
var i__$1 = this;
return true;
});

goog.object.set(tick.core.ILocalTime,"null",true);

var G__27567_27570 = tick.core.local_QMARK_;
var G__27568_27571 = "null";
var G__27569_27572 = ((function (G__27567_27570,G__27568_27571){
return (function (_){
return null;
});})(G__27567_27570,G__27568_27571))
;
goog.object.set(G__27567_27570,G__27568_27571,G__27569_27572);

/**
 * @interface
 */
tick.core.MinMax = function(){};

/**
 * Return the min
 */
tick.core.min_of_type = (function tick$core$min_of_type(_){
if(((!((_ == null))) && (!((_.tick$core$MinMax$min_of_type$arity$1 == null))))){
return _.tick$core$MinMax$min_of_type$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.min_of_type[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.min_of_type["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("MinMax.min-of-type",_);
}
}
}
});

/**
 * Return the max
 */
tick.core.max_of_type = (function tick$core$max_of_type(_){
if(((!((_ == null))) && (!((_.tick$core$MinMax$max_of_type$arity$1 == null))))){
return _.tick$core$MinMax$max_of_type$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (tick.core.max_of_type[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (tick.core.max_of_type["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("MinMax.max-of-type",_);
}
}
}
});

java.time.LocalTime.prototype.tick$core$MinMax$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalTime.prototype.tick$core$MinMax$min_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.local_time.min;
});

java.time.LocalTime.prototype.tick$core$MinMax$max_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.local_time.max;
});

java.time.LocalDateTime.prototype.tick$core$MinMax$ = cljs.core.PROTOCOL_SENTINEL;

java.time.LocalDateTime.prototype.tick$core$MinMax$min_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.local_date_time.min;
});

java.time.LocalDateTime.prototype.tick$core$MinMax$max_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.local_date_time.max;
});

java.time.Instant.prototype.tick$core$MinMax$ = cljs.core.PROTOCOL_SENTINEL;

java.time.Instant.prototype.tick$core$MinMax$min_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.instant.min;
});

java.time.Instant.prototype.tick$core$MinMax$max_of_type$arity$1 = (function (_){
var ___$1 = this;
return cljc.java_time.instant.max;
});

goog.object.set(tick.core.MinMax,"null",true);

var G__27573_27579 = tick.core.min_of_type;
var G__27574_27580 = "null";
var G__27575_27581 = ((function (G__27573_27579,G__27574_27580){
return (function (_){
return cljc.java_time.instant.min;
});})(G__27573_27579,G__27574_27580))
;
goog.object.set(G__27573_27579,G__27574_27580,G__27575_27581);

var G__27576_27582 = tick.core.max_of_type;
var G__27577_27583 = "null";
var G__27578_27584 = ((function (G__27576_27582,G__27577_27583){
return (function (_){
return cljc.java_time.instant.max;
});})(G__27576_27582,G__27577_27583))
;
goog.object.set(G__27576_27582,G__27577_27583,G__27578_27584);
tick.core.ago = (function tick$core$ago(dur){
return tick.core.backward_duration(tick.core.now(),dur);
});
tick.core.hence = (function tick$core$hence(dur){
return tick.core.forward_duration(tick.core.now(),dur);
});
tick.core.midnight_QMARK_ = (function tick$core$midnight_QMARK_(t){
return cljc.java_time.duration.between(t,tick.core.beginning(tick.core.date(t))).isZero();
});
