// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_22238 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__22239 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__22240 = null;
var count__22241 = (0);
var i__22242 = (0);
while(true){
if((i__22242 < count__22241)){
var vec__22243 = chunk__22240.cljs$core$IIndexed$_nth$arity$2(null,i__22242);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22243,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22243,(1),null);
var temp__5733__auto___22259 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___22259)){
var effect_fn_22260 = temp__5733__auto___22259;
(effect_fn_22260.cljs$core$IFn$_invoke$arity$1 ? effect_fn_22260.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_22260.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__22261 = seq__22239;
var G__22262 = chunk__22240;
var G__22263 = count__22241;
var G__22264 = (i__22242 + (1));
seq__22239 = G__22261;
chunk__22240 = G__22262;
count__22241 = G__22263;
i__22242 = G__22264;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22239);
if(temp__5735__auto__){
var seq__22239__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22239__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__22239__$1);
var G__22265 = cljs.core.chunk_rest(seq__22239__$1);
var G__22266 = c__4351__auto__;
var G__22267 = cljs.core.count(c__4351__auto__);
var G__22268 = (0);
seq__22239 = G__22265;
chunk__22240 = G__22266;
count__22241 = G__22267;
i__22242 = G__22268;
continue;
} else {
var vec__22246 = cljs.core.first(seq__22239__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22246,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22246,(1),null);
var temp__5733__auto___22269 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___22269)){
var effect_fn_22270 = temp__5733__auto___22269;
(effect_fn_22270.cljs$core$IFn$_invoke$arity$1 ? effect_fn_22270.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_22270.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__22271 = cljs.core.next(seq__22239__$1);
var G__22272 = null;
var G__22273 = (0);
var G__22274 = (0);
seq__22239 = G__22271;
chunk__22240 = G__22272;
count__22241 = G__22273;
i__22242 = G__22274;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__21803__auto___22275 = re_frame.interop.now();
var duration__21804__auto___22276 = (end__21803__auto___22275 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__21804__auto___22276,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__21803__auto___22275);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_22238;
}} else {
var seq__22249 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__22250 = null;
var count__22251 = (0);
var i__22252 = (0);
while(true){
if((i__22252 < count__22251)){
var vec__22253 = chunk__22250.cljs$core$IIndexed$_nth$arity$2(null,i__22252);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22253,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22253,(1),null);
var temp__5733__auto___22277 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___22277)){
var effect_fn_22278 = temp__5733__auto___22277;
(effect_fn_22278.cljs$core$IFn$_invoke$arity$1 ? effect_fn_22278.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_22278.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__22279 = seq__22249;
var G__22280 = chunk__22250;
var G__22281 = count__22251;
var G__22282 = (i__22252 + (1));
seq__22249 = G__22279;
chunk__22250 = G__22280;
count__22251 = G__22281;
i__22252 = G__22282;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22249);
if(temp__5735__auto__){
var seq__22249__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22249__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__22249__$1);
var G__22283 = cljs.core.chunk_rest(seq__22249__$1);
var G__22284 = c__4351__auto__;
var G__22285 = cljs.core.count(c__4351__auto__);
var G__22286 = (0);
seq__22249 = G__22283;
chunk__22250 = G__22284;
count__22251 = G__22285;
i__22252 = G__22286;
continue;
} else {
var vec__22256 = cljs.core.first(seq__22249__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22256,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22256,(1),null);
var temp__5733__auto___22287 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___22287)){
var effect_fn_22288 = temp__5733__auto___22287;
(effect_fn_22288.cljs$core$IFn$_invoke$arity$1 ? effect_fn_22288.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_22288.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__22289 = cljs.core.next(seq__22249__$1);
var G__22290 = null;
var G__22291 = (0);
var G__22292 = (0);
seq__22249 = G__22289;
chunk__22250 = G__22290;
count__22251 = G__22291;
i__22252 = G__22292;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__22293 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__22294 = null;
var count__22295 = (0);
var i__22296 = (0);
while(true){
if((i__22296 < count__22295)){
var map__22297 = chunk__22294.cljs$core$IIndexed$_nth$arity$2(null,i__22296);
var map__22297__$1 = ((((!((map__22297 == null)))?(((((map__22297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22297.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22297):map__22297);
var effect = map__22297__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22297__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22297__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__22293,chunk__22294,count__22295,i__22296,map__22297,map__22297__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__22293,chunk__22294,count__22295,i__22296,map__22297,map__22297__$1,effect,ms,dispatch))
,ms);
}


var G__22301 = seq__22293;
var G__22302 = chunk__22294;
var G__22303 = count__22295;
var G__22304 = (i__22296 + (1));
seq__22293 = G__22301;
chunk__22294 = G__22302;
count__22295 = G__22303;
i__22296 = G__22304;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22293);
if(temp__5735__auto__){
var seq__22293__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22293__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__22293__$1);
var G__22305 = cljs.core.chunk_rest(seq__22293__$1);
var G__22306 = c__4351__auto__;
var G__22307 = cljs.core.count(c__4351__auto__);
var G__22308 = (0);
seq__22293 = G__22305;
chunk__22294 = G__22306;
count__22295 = G__22307;
i__22296 = G__22308;
continue;
} else {
var map__22299 = cljs.core.first(seq__22293__$1);
var map__22299__$1 = ((((!((map__22299 == null)))?(((((map__22299.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22299.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22299):map__22299);
var effect = map__22299__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22299__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22299__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__22293,chunk__22294,count__22295,i__22296,map__22299,map__22299__$1,effect,ms,dispatch,seq__22293__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__22293,chunk__22294,count__22295,i__22296,map__22299,map__22299__$1,effect,ms,dispatch,seq__22293__$1,temp__5735__auto__))
,ms);
}


var G__22309 = cljs.core.next(seq__22293__$1);
var G__22310 = null;
var G__22311 = (0);
var G__22312 = (0);
seq__22293 = G__22309;
chunk__22294 = G__22310;
count__22295 = G__22311;
i__22296 = G__22312;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__22313 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__22314 = null;
var count__22315 = (0);
var i__22316 = (0);
while(true){
if((i__22316 < count__22315)){
var event = chunk__22314.cljs$core$IIndexed$_nth$arity$2(null,i__22316);
re_frame.router.dispatch(event);


var G__22317 = seq__22313;
var G__22318 = chunk__22314;
var G__22319 = count__22315;
var G__22320 = (i__22316 + (1));
seq__22313 = G__22317;
chunk__22314 = G__22318;
count__22315 = G__22319;
i__22316 = G__22320;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22313);
if(temp__5735__auto__){
var seq__22313__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22313__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__22313__$1);
var G__22321 = cljs.core.chunk_rest(seq__22313__$1);
var G__22322 = c__4351__auto__;
var G__22323 = cljs.core.count(c__4351__auto__);
var G__22324 = (0);
seq__22313 = G__22321;
chunk__22314 = G__22322;
count__22315 = G__22323;
i__22316 = G__22324;
continue;
} else {
var event = cljs.core.first(seq__22313__$1);
re_frame.router.dispatch(event);


var G__22325 = cljs.core.next(seq__22313__$1);
var G__22326 = null;
var G__22327 = (0);
var G__22328 = (0);
seq__22313 = G__22325;
chunk__22314 = G__22326;
count__22315 = G__22327;
i__22316 = G__22328;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__22329 = cljs.core.seq(value);
var chunk__22330 = null;
var count__22331 = (0);
var i__22332 = (0);
while(true){
if((i__22332 < count__22331)){
var event = chunk__22330.cljs$core$IIndexed$_nth$arity$2(null,i__22332);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__22333 = seq__22329;
var G__22334 = chunk__22330;
var G__22335 = count__22331;
var G__22336 = (i__22332 + (1));
seq__22329 = G__22333;
chunk__22330 = G__22334;
count__22331 = G__22335;
i__22332 = G__22336;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22329);
if(temp__5735__auto__){
var seq__22329__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22329__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__22329__$1);
var G__22337 = cljs.core.chunk_rest(seq__22329__$1);
var G__22338 = c__4351__auto__;
var G__22339 = cljs.core.count(c__4351__auto__);
var G__22340 = (0);
seq__22329 = G__22337;
chunk__22330 = G__22338;
count__22331 = G__22339;
i__22332 = G__22340;
continue;
} else {
var event = cljs.core.first(seq__22329__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__22341 = cljs.core.next(seq__22329__$1);
var G__22342 = null;
var G__22343 = (0);
var G__22344 = (0);
seq__22329 = G__22341;
chunk__22330 = G__22342;
count__22331 = G__22343;
i__22332 = G__22344;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
