// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_20719 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__20720 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20721 = null;
var count__20722 = (0);
var i__20723 = (0);
while(true){
if((i__20723 < count__20722)){
var vec__20724 = chunk__20721.cljs$core$IIndexed$_nth$arity$2(null,i__20723);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20724,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20724,(1),null);
var temp__5733__auto___20740 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20740)){
var effect_fn_20741 = temp__5733__auto___20740;
(effect_fn_20741.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20741.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20741.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20742 = seq__20720;
var G__20743 = chunk__20721;
var G__20744 = count__20722;
var G__20745 = (i__20723 + (1));
seq__20720 = G__20742;
chunk__20721 = G__20743;
count__20722 = G__20744;
i__20723 = G__20745;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20720);
if(temp__5735__auto__){
var seq__20720__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20720__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20720__$1);
var G__20746 = cljs.core.chunk_rest(seq__20720__$1);
var G__20747 = c__4351__auto__;
var G__20748 = cljs.core.count(c__4351__auto__);
var G__20749 = (0);
seq__20720 = G__20746;
chunk__20721 = G__20747;
count__20722 = G__20748;
i__20723 = G__20749;
continue;
} else {
var vec__20727 = cljs.core.first(seq__20720__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20727,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20727,(1),null);
var temp__5733__auto___20750 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20750)){
var effect_fn_20751 = temp__5733__auto___20750;
(effect_fn_20751.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20751.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20751.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20752 = cljs.core.next(seq__20720__$1);
var G__20753 = null;
var G__20754 = (0);
var G__20755 = (0);
seq__20720 = G__20752;
chunk__20721 = G__20753;
count__20722 = G__20754;
i__20723 = G__20755;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__20545__auto___20756 = re_frame.interop.now();
var duration__20546__auto___20757 = (end__20545__auto___20756 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__20546__auto___20757,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__20545__auto___20756);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_20719;
}} else {
var seq__20730 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20731 = null;
var count__20732 = (0);
var i__20733 = (0);
while(true){
if((i__20733 < count__20732)){
var vec__20734 = chunk__20731.cljs$core$IIndexed$_nth$arity$2(null,i__20733);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20734,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20734,(1),null);
var temp__5733__auto___20758 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20758)){
var effect_fn_20759 = temp__5733__auto___20758;
(effect_fn_20759.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20759.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20759.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20760 = seq__20730;
var G__20761 = chunk__20731;
var G__20762 = count__20732;
var G__20763 = (i__20733 + (1));
seq__20730 = G__20760;
chunk__20731 = G__20761;
count__20732 = G__20762;
i__20733 = G__20763;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20730);
if(temp__5735__auto__){
var seq__20730__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20730__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20730__$1);
var G__20764 = cljs.core.chunk_rest(seq__20730__$1);
var G__20765 = c__4351__auto__;
var G__20766 = cljs.core.count(c__4351__auto__);
var G__20767 = (0);
seq__20730 = G__20764;
chunk__20731 = G__20765;
count__20732 = G__20766;
i__20733 = G__20767;
continue;
} else {
var vec__20737 = cljs.core.first(seq__20730__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20737,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20737,(1),null);
var temp__5733__auto___20768 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20768)){
var effect_fn_20769 = temp__5733__auto___20768;
(effect_fn_20769.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20769.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20769.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20770 = cljs.core.next(seq__20730__$1);
var G__20771 = null;
var G__20772 = (0);
var G__20773 = (0);
seq__20730 = G__20770;
chunk__20731 = G__20771;
count__20732 = G__20772;
i__20733 = G__20773;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__20774 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20775 = null;
var count__20776 = (0);
var i__20777 = (0);
while(true){
if((i__20777 < count__20776)){
var map__20778 = chunk__20775.cljs$core$IIndexed$_nth$arity$2(null,i__20777);
var map__20778__$1 = ((((!((map__20778 == null)))?(((((map__20778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20778):map__20778);
var effect = map__20778__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20778__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20778__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20774,chunk__20775,count__20776,i__20777,map__20778,map__20778__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20774,chunk__20775,count__20776,i__20777,map__20778,map__20778__$1,effect,ms,dispatch))
,ms);
}


var G__20782 = seq__20774;
var G__20783 = chunk__20775;
var G__20784 = count__20776;
var G__20785 = (i__20777 + (1));
seq__20774 = G__20782;
chunk__20775 = G__20783;
count__20776 = G__20784;
i__20777 = G__20785;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20774);
if(temp__5735__auto__){
var seq__20774__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20774__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20774__$1);
var G__20786 = cljs.core.chunk_rest(seq__20774__$1);
var G__20787 = c__4351__auto__;
var G__20788 = cljs.core.count(c__4351__auto__);
var G__20789 = (0);
seq__20774 = G__20786;
chunk__20775 = G__20787;
count__20776 = G__20788;
i__20777 = G__20789;
continue;
} else {
var map__20780 = cljs.core.first(seq__20774__$1);
var map__20780__$1 = ((((!((map__20780 == null)))?(((((map__20780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20780.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20780):map__20780);
var effect = map__20780__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20780__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20780__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20774,chunk__20775,count__20776,i__20777,map__20780,map__20780__$1,effect,ms,dispatch,seq__20774__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20774,chunk__20775,count__20776,i__20777,map__20780,map__20780__$1,effect,ms,dispatch,seq__20774__$1,temp__5735__auto__))
,ms);
}


var G__20790 = cljs.core.next(seq__20774__$1);
var G__20791 = null;
var G__20792 = (0);
var G__20793 = (0);
seq__20774 = G__20790;
chunk__20775 = G__20791;
count__20776 = G__20792;
i__20777 = G__20793;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__20794 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20795 = null;
var count__20796 = (0);
var i__20797 = (0);
while(true){
if((i__20797 < count__20796)){
var event = chunk__20795.cljs$core$IIndexed$_nth$arity$2(null,i__20797);
re_frame.router.dispatch(event);


var G__20798 = seq__20794;
var G__20799 = chunk__20795;
var G__20800 = count__20796;
var G__20801 = (i__20797 + (1));
seq__20794 = G__20798;
chunk__20795 = G__20799;
count__20796 = G__20800;
i__20797 = G__20801;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20794);
if(temp__5735__auto__){
var seq__20794__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20794__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20794__$1);
var G__20802 = cljs.core.chunk_rest(seq__20794__$1);
var G__20803 = c__4351__auto__;
var G__20804 = cljs.core.count(c__4351__auto__);
var G__20805 = (0);
seq__20794 = G__20802;
chunk__20795 = G__20803;
count__20796 = G__20804;
i__20797 = G__20805;
continue;
} else {
var event = cljs.core.first(seq__20794__$1);
re_frame.router.dispatch(event);


var G__20806 = cljs.core.next(seq__20794__$1);
var G__20807 = null;
var G__20808 = (0);
var G__20809 = (0);
seq__20794 = G__20806;
chunk__20795 = G__20807;
count__20796 = G__20808;
i__20797 = G__20809;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__20810 = cljs.core.seq(value);
var chunk__20811 = null;
var count__20812 = (0);
var i__20813 = (0);
while(true){
if((i__20813 < count__20812)){
var event = chunk__20811.cljs$core$IIndexed$_nth$arity$2(null,i__20813);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20814 = seq__20810;
var G__20815 = chunk__20811;
var G__20816 = count__20812;
var G__20817 = (i__20813 + (1));
seq__20810 = G__20814;
chunk__20811 = G__20815;
count__20812 = G__20816;
i__20813 = G__20817;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20810);
if(temp__5735__auto__){
var seq__20810__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20810__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20810__$1);
var G__20818 = cljs.core.chunk_rest(seq__20810__$1);
var G__20819 = c__4351__auto__;
var G__20820 = cljs.core.count(c__4351__auto__);
var G__20821 = (0);
seq__20810 = G__20818;
chunk__20811 = G__20819;
count__20812 = G__20820;
i__20813 = G__20821;
continue;
} else {
var event = cljs.core.first(seq__20810__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20822 = cljs.core.next(seq__20810__$1);
var G__20823 = null;
var G__20824 = (0);
var G__20825 = (0);
seq__20810 = G__20822;
chunk__20811 = G__20823;
count__20812 = G__20824;
i__20813 = G__20825;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
